/*!
 * CreateJS
 * Visit http://createjs.com/ for documentation, updates and examples.
 *
 * Copyright (c) 2010 gskinn2er.com, inc.
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
var createjs = createjs || {};
createjs.stageTransformable = !0;
createjs.extend = function(n, t) {
    "use strict";

    function i() {
        this.constructor = n
    }
    return i.prototype = t.prototype, n.prototype = new i
};
createjs.promote = function(n, t) {
    "use strict";
    var i = n.prototype,
        r = Object.getPrototypeOf && Object.getPrototypeOf(i) || i.__proto__,
        u;
    if (r) {
        i[(t += "_") + "constructor"] = r.constructor;
        for (u in r) i.hasOwnProperty(u) && typeof r[u] == "function" && (i[t + u] = r[u])
    }
    return n
};
createjs.indexOf = function(n, t) {
        "use strict";
        for (var i = 0, r = n.length; i < r; i++)
            if (t === n[i]) return i;
        return -1
    },
    function() {
        "use strict";

        function n() {
            throw "UID cannot be instantiated";
        }
        n._nextID = 0;
        n.get = function() {
            return n._nextID++
        };
        createjs.UID = n
    }();
createjs.deprecate = function(n, t) {
        "use strict";
        return function() {
            var i = "Deprecated property or method '" + t + "'. See docs for info.";
            return console && (console.warn ? console.warn(i) : console.log(i)), n && n.apply(this, arguments)
        }
    },
    function() {
        "use strict";

        function t(n, t, i) {
            this.type = n;
            this.target = null;
            this.currentTarget = null;
            this.eventPhase = 0;
            this.bubbles = !!t;
            this.cancelable = !!i;
            this.timeStamp = (new Date).getTime();
            this.defaultPrevented = !1;
            this.propagationStopped = !1;
            this.immediatePropagationStopped = !1;
            this.removed = !1
        }
        var n = t.prototype;
        n.preventDefault = function() {
            this.defaultPrevented = this.cancelable && !0
        };
        n.stopPropagation = function() {
            this.propagationStopped = !0
        };
        n.stopImmediatePropagation = function() {
            this.immediatePropagationStopped = this.propagationStopped = !0
        };
        n.remove = function() {
            this.removed = !0
        };
        n.clone = function() {
            return new t(this.type, this.bubbles, this.cancelable)
        };
        n.set = function(n) {
            for (var t in n) this[t] = n[t];
            return this
        };
        n.toString = function() {
            return "[Event (type=" + this.type + ")]"
        };
        createjs.Event = t
    }(),
    function() {
        "use strict";

        function t() {
            this._listeners = null;
            this._captureListeners = null
        }
        var n = t.prototype;
        t.initialize = function(t) {
            t.addEventListener = n.addEventListener;
            t.on = n.on;
            t.removeEventListener = t.off = n.removeEventListener;
            t.removeAllEventListeners = n.removeAllEventListeners;
            t.hasEventListener = n.hasEventListener;
            t.dispatchEvent = n.dispatchEvent;
            t._dispatchEvent = n._dispatchEvent;
            t.willTrigger = n.willTrigger
        };
        n.addEventListener = function(n, t, i) {
            var u, r;
            return u = i ? this._captureListeners = this._captureListeners || {} : this._listeners = this._listeners || {}, r = u[n], r && this.removeEventListener(n, t, i), r = u[n], r ? r.push(t) : u[n] = [t], t
        };
        n.on = function(n, t, i, r, u, f) {
            return t.handleEvent && (i = i || t, t = t.handleEvent), i = i || this, this.addEventListener(n, function(n) {
                t.call(i, n, u);
                r && n.remove()
            }, f)
        };
        n.removeEventListener = function(n, t, i) {
            var f = i ? this._captureListeners : this._listeners,
                r, u, e;
            if (f && (r = f[n], r))
                for (u = 0, e = r.length; u < e; u++)
                    if (r[u] == t) {
                        e == 1 ? delete f[n] : r.splice(u, 1);
                        break
                    }
        };
        n.off = n.removeEventListener;
        n.removeAllEventListeners = function(n) {
            n ? (this._listeners && delete this._listeners[n], this._captureListeners && delete this._captureListeners[n]) : this._listeners = this._captureListeners = null
        };
        n.dispatchEvent = function(n, t, i) {
            var e, u, f, r, o;
            if (typeof n == "string") {
                if (e = this._listeners, !t && (!e || !e[n])) return !0;
                n = new createjs.Event(n, t, i)
            } else n.target && n.clone && (n = n.clone());
            try {
                n.target = this
            } catch (s) {}
            if (n.bubbles && this.parent) {
                for (u = this, f = [u]; u.parent;) f.push(u = u.parent);
                for (o = f.length, r = o - 1; r >= 0 && !n.propagationStopped; r--) f[r]._dispatchEvent(n, 1 + (r == 0));
                for (r = 1; r < o && !n.propagationStopped; r++) f[r]._dispatchEvent(n, 3)
            } else this._dispatchEvent(n, 2);
            return !n.defaultPrevented
        };
        n.hasEventListener = function(n) {
            var t = this._listeners,
                i = this._captureListeners;
            return !!(t && t[n] || i && i[n])
        };
        n.willTrigger = function(n) {
            for (var t = this; t;) {
                if (t.hasEventListener(n)) return !0;
                t = t.parent
            }
            return !1
        };
        n.toString = function() {
            return "[EventDispatcher]"
        };
        n._dispatchEvent = function(n, t) {
            var f, i, e = t <= 2 ? this._captureListeners : this._listeners,
                u, r;
            if (n && e && (i = e[n.type]) && (f = i.length)) {
                try {
                    n.currentTarget = this
                } catch (o) {}
                try {
                    n.eventPhase = t | 0
                } catch (o) {}
                for (n.removed = !1, i = i.slice(), u = 0; u < f && !n.immediatePropagationStopped; u++) r = i[u], r.handleEvent ? r.handleEvent(n) : r(n), n.removed && (this.off(n.type, r, t == 1), n.removed = !1)
            }
            t === 2 && this._dispatchEvent(n, 2.1)
        };
        createjs.EventDispatcher = t
    }(),
    function() {
        "use strict";

        function n() {
            throw "Ticker cannot be instantiated.";
        }
        n.RAF_SYNCHED = "synched";
        n.RAF = "raf";
        n.TIMEOUT = "timeout";
        n.timingMode = null;
        n.maxDelta = 0;
        n.paused = !1;
        n.removeEventListener = null;
        n.removeAllEventListeners = null;
        n.dispatchEvent = null;
        n.hasEventListener = null;
        n._listeners = null;
        createjs.EventDispatcher.initialize(n);
        n._addEventListener = n.addEventListener;
        n.addEventListener = function() {
            return n._inited || n.init(), n._addEventListener.apply(n, arguments)
        };
        n._inited = !1;
        n._startTime = 0;
        n._pausedTime = 0;
        n._ticks = 0;
        n._pausedTicks = 0;
        n._interval = 50;
        n._lastTime = 0;
        n._times = null;
        n._tickTimes = null;
        n._timerId = null;
        n._raf = !0;
        n._setInterval = function(t) {
            (n._interval = t, n._inited) && n._setupTick()
        };
        n.setInterval = createjs.deprecate(n._setInterval, "Ticker.setInterval");
        n._getInterval = function() {
            return n._interval
        };
        n.getInterval = createjs.deprecate(n._getInterval, "Ticker.getInterval");
        n._setFPS = function(t) {
            n._setInterval(1e3 / t)
        };
        n.setFPS = createjs.deprecate(n._setFPS, "Ticker.setFPS");
        n._getFPS = function() {
            return 1e3 / n._interval
        };
        n.getFPS = createjs.deprecate(n._getFPS, "Ticker.getFPS");
        try {
            Object.defineProperties(n, {
                interval: {
                    get: n._getInterval,
                    set: n._setInterval
                },
                framerate: {
                    get: n._getFPS,
                    set: n._setFPS
                }
            })
        } catch (r) {
            console.log(r)
        }
        n.init = function() {
            n._inited || (n._inited = !0, n._times = [], n._tickTimes = [], n._startTime = n._getTime(), n._times.push(n._lastTime = 0), n.interval = n._interval)
        };
        n.reset = function() {
            if (n._raf) {
                var t = window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || window.oCancelAnimationFrame || window.msCancelAnimationFrame;
                t && t(n._timerId)
            } else clearTimeout(n._timerId);
            n.removeAllEventListeners("tick");
            n._timerId = n._times = n._tickTimes = null;
            n._startTime = n._lastTime = n._ticks = n._pausedTime = 0;
            n._inited = !1
        };
        n.getMeasuredTickTime = function(t) {
            var u = 0,
                i = n._tickTimes,
                r;
            if (!i || i.length < 1) return -1;
            for (t = Math.min(i.length, t || n._getFPS() | 0), r = 0; r < t; r++) u += i[r];
            return u / t
        };
        n.getMeasuredFPS = function(t) {
            var i = n._times;
            return !i || i.length < 2 ? -1 : (t = Math.min(i.length - 1, t || n._getFPS() | 0), 1e3 / ((i[0] - i[t]) / t))
        };
        n.getTime = function(t) {
            return n._startTime ? n._getTime() - (t ? n._pausedTime : 0) : -1
        };
        n.getEventTime = function(t) {
            return n._startTime ? (n._lastTime || n._startTime) - (t ? n._pausedTime : 0) : -1
        };
        n.getTicks = function(t) {
            return n._ticks - (t ? n._pausedTicks : 0)
        };
        n._handleSynch = function() {
            n._timerId = null;
            n._setupTick();
            n._getTime() - n._lastTime >= (n._interval - 1) * .97 && n._tick()
        };
        n._handleRAF = function() {
            n._timerId = null;
            n._setupTick();
            n._tick()
        };
        n._handleTimeout = function() {
            n._timerId = null;
            n._setupTick();
            n._tick()
        };
        n._setupTick = function() {
            var t, i;
            if (n._timerId == null) {
                if (t = n.timingMode, (t == n.RAF_SYNCHED || t == n.RAF) && (i = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame, i)) {
                    n._timerId = i(t == n.RAF ? n._handleRAF : n._handleSynch);
                    n._raf = !0;
                    return
                }
                n._raf = !1;
                n._timerId = setTimeout(n._handleTimeout, n._interval)
            }
        };
        n._tick = function() {
            var f = n.paused,
                t = n._getTime(),
                u = t - n._lastTime,
                i, r;
            for (n._lastTime = t, n._ticks++, f && (n._pausedTicks++, n._pausedTime += u), n.hasEventListener("tick") && (i = new createjs.Event("tick"), r = n.maxDelta, i.delta = r && u > r ? r : u, i.paused = f, i.time = t, i.runTime = t - n._pausedTime, n.dispatchEvent(i)), n._tickTimes.unshift(n._getTime() - t); n._tickTimes.length > 100;) n._tickTimes.pop();
            for (n._times.unshift(t); n._times.length > 100;) n._times.pop()
        };
        var t = window,
            i = t.performance.now || t.performance.mozNow || t.performance.msNow || t.performance.oNow || t.performance.webkitNow;
        n._getTime = function() {
            return (i && i.call(t.performance) || (new Date).getTime()) - n._startTime
        };
        createjs.Ticker = n
    }(),
    function() {
        "use strict";

        function n(n) {
            this.readyState = n.readyState;
            this._video = n;
            this._canvas = null;
            this._lastTime = -1;
            this.readyState < 2 && n.addEventListener("canplaythrough", this._videoReady.bind(this))
        }
        var t = n.prototype;
        t.getImage = function() {
            var n, t, i;
            if (!(this.readyState < 2)) return n = this._canvas, t = this._video, n || (n = this._canvas = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas"), n.width = t.videoWidth, n.height = t.videoHeight), t.readyState >= 2 && t.currentTime !== this._lastTime && (i = n.getContext("2d"), i.clearRect(0, 0, n.width, n.height), i.drawImage(t, 0, 0, n.width, n.height), this._lastTime = t.currentTime), n
        };
        t._videoReady = function() {
            this.readyState = 2
        };
        createjs.VideoBuffer = n
    }(),
    function() {
        "use strict";

        function t(n, t, i, r, u, f, e, o, s, h, c) {
            this.Event_constructor(n, t, i);
            this.stageX = r;
            this.stageY = u;
            this.rawX = s == null ? r : s;
            this.rawY = h == null ? u : h;
            this.nativeEvent = f;
            this.pointerID = e;
            this.primary = !!o;
            this.relatedTarget = c
        }
        var n = createjs.extend(t, createjs.Event);
        n._get_localX = function() {
            return this.currentTarget.globalToLocal(this.rawX, this.rawY).x
        };
        n._get_localY = function() {
            return this.currentTarget.globalToLocal(this.rawX, this.rawY).y
        };
        n._get_isTouch = function() {
            return this.pointerID !== -1
        };
        try {
            Object.defineProperties(n, {
                localX: {
                    get: n._get_localX
                },
                localY: {
                    get: n._get_localY
                },
                isTouch: {
                    get: n._get_isTouch
                }
            })
        } catch (i) {}
        n.clone = function() {
            return new t(this.type, this.bubbles, this.cancelable, this.stageX, this.stageY, this.nativeEvent, this.pointerID, this.primary, this.rawX, this.rawY)
        };
        n.toString = function() {
            return "[MouseEvent (type=" + this.type + " stageX=" + this.stageX + " stageY=" + this.stageY + ")]"
        };
        createjs.MouseEvent = createjs.promote(t, "Event")
    }(),
    function() {
        "use strict";

        function t(n, t, i, r, u, f) {
            this.setValues(n, t, i, r, u, f)
        }
        var n = t.prototype;
        t.DEG_TO_RAD = Math.PI / 180;
        t.identity = null;
        n.setValues = function(n, t, i, r, u, f) {
            return this.a = n == null ? 1 : n, this.b = t || 0, this.c = i || 0, this.d = r == null ? 1 : r, this.tx = u || 0, this.ty = f || 0, this
        };
        n.append = function(n, t, i, r, u, f) {
            var e = this.a,
                o = this.b,
                s = this.c,
                h = this.d;
            return (n != 1 || t != 0 || i != 0 || r != 1) && (this.a = e * n + s * t, this.b = o * n + h * t, this.c = e * i + s * r, this.d = o * i + h * r), this.tx = e * u + s * f + this.tx, this.ty = o * u + h * f + this.ty, this
        };
        n.prepend = function(n, t, i, r, u, f) {
            var e = this.a,
                o = this.c,
                s = this.tx;
            return this.a = n * e + i * this.b, this.b = t * e + r * this.b, this.c = n * o + i * this.d, this.d = t * o + r * this.d, this.tx = n * s + i * this.ty + u, this.ty = t * s + r * this.ty + f, this
        };
        n.appendMatrix = function(n) {
            return this.append(n.a, n.b, n.c, n.d, n.tx, n.ty)
        };
        n.prependMatrix = function(n) {
            return this.prepend(n.a, n.b, n.c, n.d, n.tx, n.ty)
        };
        n.appendTransform = function(n, i, r, u, f, e, o, s, h) {
            if (f % 360) var a = f * t.DEG_TO_RAD,
                c = Math.cos(a),
                l = Math.sin(a);
            else c = 1, l = 0;
            return e || o ? (e *= t.DEG_TO_RAD, o *= t.DEG_TO_RAD, this.append(Math.cos(o), Math.sin(o), -Math.sin(e), Math.cos(e), n, i), this.append(c * r, l * r, -l * u, c * u, 0, 0)) : this.append(c * r, l * r, -l * u, c * u, n, i), (s || h) && (this.tx -= s * this.a + h * this.c, this.ty -= s * this.b + h * this.d), this
        };
        n.prependTransform = function(n, i, r, u, f, e, o, s, h) {
            if (f % 360) var a = f * t.DEG_TO_RAD,
                c = Math.cos(a),
                l = Math.sin(a);
            else c = 1, l = 0;
            return (s || h) && (this.tx -= s, this.ty -= h), e || o ? (e *= t.DEG_TO_RAD, o *= t.DEG_TO_RAD, this.prepend(c * r, l * r, -l * u, c * u, 0, 0), this.prepend(Math.cos(o), Math.sin(o), -Math.sin(e), Math.cos(e), n, i)) : this.prepend(c * r, l * r, -l * u, c * u, n, i), this
        };
        n.rotate = function(n) {
            n = n * t.DEG_TO_RAD;
            var i = Math.cos(n),
                r = Math.sin(n),
                u = this.a,
                f = this.b;
            return this.a = u * i + this.c * r, this.b = f * i + this.d * r, this.c = -u * r + this.c * i, this.d = -f * r + this.d * i, this
        };
        n.skew = function(n, i) {
            return n = n * t.DEG_TO_RAD, i = i * t.DEG_TO_RAD, this.append(Math.cos(i), Math.sin(i), -Math.sin(n), Math.cos(n), 0, 0), this
        };
        n.scale = function(n, t) {
            return this.a *= n, this.b *= n, this.c *= t, this.d *= t, this
        };
        n.translate = function(n, t) {
            return this.tx += this.a * n + this.c * t, this.ty += this.b * n + this.d * t, this
        };
        n.identity = function() {
            return this.a = this.d = 1, this.b = this.c = this.tx = this.ty = 0, this
        };
        n.invert = function() {
            var t = this.a,
                i = this.b,
                r = this.c,
                u = this.d,
                f = this.tx,
                n = t * u - i * r;
            return this.a = u / n, this.b = -i / n, this.c = -r / n, this.d = t / n, this.tx = (r * this.ty - u * f) / n, this.ty = -(t * this.ty - i * f) / n, this
        };
        n.isIdentity = function() {
            return this.tx === 0 && this.ty === 0 && this.a === 1 && this.b === 0 && this.c === 0 && this.d === 1
        };
        n.equals = function(n) {
            return this.tx === n.tx && this.ty === n.ty && this.a === n.a && this.b === n.b && this.c === n.c && this.d === n.d
        };
        n.transformPoint = function(n, t, i) {
            return i = i || {}, i.x = n * this.a + t * this.c + this.tx, i.y = n * this.b + t * this.d + this.ty, i
        };
        n.decompose = function(n) {
            n == null && (n = {});
            n.x = this.tx;
            n.y = this.ty;
            n.scaleX = Math.sqrt(this.a * this.a + this.b * this.b);
            n.scaleY = Math.sqrt(this.c * this.c + this.d * this.d);
            var r = Math.atan2(-this.c, this.d),
                i = Math.atan2(this.b, this.a),
                u = Math.abs(1 - r / i);
            return u < 1e-5 ? (n.rotation = i / t.DEG_TO_RAD, this.a < 0 && this.d >= 0 && (n.rotation += n.rotation <= 0 ? 180 : -180), n.skewX = n.skewY = 0) : (n.skewX = r / t.DEG_TO_RAD, n.skewY = i / t.DEG_TO_RAD), n
        };
        n.copy = function(n) {
            return this.setValues(n.a, n.b, n.c, n.d, n.tx, n.ty)
        };
        n.clone = function() {
            return new t(this.a, this.b, this.c, this.d, this.tx, this.ty)
        };
        n.toString = function() {
            return "[Matrix2D (a=" + this.a + " b=" + this.b + " c=" + this.c + " d=" + this.d + " tx=" + this.tx + " ty=" + this.ty + ")]"
        };
        t.identity = new t;
        createjs.Matrix2D = t
    }(),
    function() {
        "use strict";

        function t(n, t, i, r, u) {
            this.setValues(n, t, i, r, u)
        }
        var n = t.prototype;
        n.setValues = function(n, t, i, r, u) {
            return this.visible = n == null ? !0 : !!n, this.alpha = t == null ? 1 : t, this.shadow = i, this.compositeOperation = r, this.matrix = u || this.matrix && this.matrix.identity() || new createjs.Matrix2D, this
        };
        n.append = function(n, t, i, r, u) {
            return this.alpha *= t, this.shadow = i || this.shadow, this.compositeOperation = r || this.compositeOperation, this.visible = this.visible && n, u && this.matrix.appendMatrix(u), this
        };
        n.prepend = function(n, t, i, r, u) {
            return this.alpha *= t, this.shadow = this.shadow || i, this.compositeOperation = this.compositeOperation || r, this.visible = this.visible && n, u && this.matrix.prependMatrix(u), this
        };
        n.identity = function() {
            return this.visible = !0, this.alpha = 1, this.shadow = this.compositeOperation = null, this.matrix.identity(), this
        };
        n.clone = function() {
            return new t(this.alpha, this.shadow, this.compositeOperation, this.visible, this.matrix.clone())
        };
        createjs.DisplayProps = t
    }(),
    function() {
        "use strict";

        function t(n, t) {
            this.setValues(n, t)
        }
        var n = t.prototype;
        n.setValues = function(n, t) {
            return this.x = n || 0, this.y = t || 0, this
        };
        n.copy = function(n) {
            return this.x = n.x, this.y = n.y, this
        };
        n.clone = function() {
            return new t(this.x, this.y)
        };
        n.toString = function() {
            return "[Point (x=" + this.x + " y=" + this.y + ")]"
        };
        createjs.Point = t
    }(),
    function() {
        "use strict";

        function t(n, t, i, r) {
            this.setValues(n, t, i, r)
        }
        var n = t.prototype;
        n.setValues = function(n, t, i, r) {
            return this.x = n || 0, this.y = t || 0, this.width = i || 0, this.height = r || 0, this
        };
        n.extend = function(n, t, i, r) {
            return i = i || 0, r = r || 0, n + i > this.x + this.width && (this.width = n + i - this.x), t + r > this.y + this.height && (this.height = t + r - this.y), n < this.x && (this.width += this.x - n, this.x = n), t < this.y && (this.height += this.y - t, this.y = t), this
        };
        n.pad = function(n, t, i, r) {
            return this.x -= t, this.y -= n, this.width += t + r, this.height += n + i, this
        };
        n.copy = function(n) {
            return this.setValues(n.x, n.y, n.width, n.height)
        };
        n.contains = function(n, t, i, r) {
            return i = i || 0, r = r || 0, n >= this.x && n + i <= this.x + this.width && t >= this.y && t + r <= this.y + this.height
        };
        n.union = function(n) {
            return this.clone().extend(n.x, n.y, n.width, n.height)
        };
        n.intersection = function(n) {
            var i = n.x,
                r = n.y,
                u = i + n.width,
                f = r + n.height;
            return this.x > i && (i = this.x), this.y > r && (r = this.y), this.x + this.width < u && (u = this.x + this.width), this.y + this.height < f && (f = this.y + this.height), u <= i || f <= r ? null : new t(i, r, u - i, f - r)
        };
        n.intersects = function(n) {
            return n.x <= this.x + this.width && this.x <= n.x + n.width && n.y <= this.y + this.height && this.y <= n.y + n.height
        };
        n.isEmpty = function() {
            return this.width <= 0 || this.height <= 0
        };
        n.clone = function() {
            return new t(this.x, this.y, this.width, this.height)
        };
        n.toString = function() {
            return "[Rectangle (x=" + this.x + " y=" + this.y + " width=" + this.width + " height=" + this.height + ")]"
        };
        createjs.Rectangle = t
    }(),
    function() {
        "use strict";

        function t(n, t, i, r, u, f, e) {
            n.addEventListener && (this.target = n, this.overLabel = i == null ? "over" : i, this.outLabel = t == null ? "out" : t, this.downLabel = r == null ? "down" : r, this.play = u, this._isPressed = !1, this._isOver = !1, this._enabled = !1, n.mouseChildren = !1, this.enabled = !0, this.handleEvent({}), f && (e && (f.actionsEnabled = !1, f.gotoAndStop && f.gotoAndStop(e)), n.hitArea = f))
        }
        var n = t.prototype;
        n._setEnabled = function(n) {
            if (n != this._enabled) {
                var t = this.target;
                this._enabled = n;
                n ? (t.cursor = "pointer", t.addEventListener("rollover", this), t.addEventListener("rollout", this), t.addEventListener("mousedown", this), t.addEventListener("pressup", this), t._reset && (t.__reset = t._reset, t._reset = this._reset)) : (t.cursor = null, t.removeEventListener("rollover", this), t.removeEventListener("rollout", this), t.removeEventListener("mousedown", this), t.removeEventListener("pressup", this), t.__reset && (t._reset = t.__reset, delete t.__reset))
            }
        };
        n.setEnabled = createjs.deprecate(n._setEnabled, "ButtonHelper.setEnabled");
        n._getEnabled = function() {
            return this._enabled
        };
        n.getEnabled = createjs.deprecate(n._getEnabled, "ButtonHelper.getEnabled");
        try {
            Object.defineProperties(n, {
                enabled: {
                    get: n._getEnabled,
                    set: n._setEnabled
                }
            })
        } catch (i) {}
        n.toString = function() {
            return "[ButtonHelper]"
        };
        n.handleEvent = function(n) {
            var t, i = this.target,
                r = n.type;
            r == "mousedown" ? (this._isPressed = !0, t = this.downLabel) : r == "pressup" ? (this._isPressed = !1, t = this._isOver ? this.overLabel : this.outLabel) : r == "rollover" ? (this._isOver = !0, t = this._isPressed ? this.downLabel : this.overLabel) : (this._isOver = !1, t = this._isPressed ? this.overLabel : this.outLabel);
            this.play ? i.gotoAndPlay && i.gotoAndPlay(t) : i.gotoAndStop && i.gotoAndStop(t)
        };
        n._reset = function() {
            var n = this.paused;
            this.__reset();
            this.paused = n
        };
        createjs.ButtonHelper = t
    }(),
    function() {
        "use strict";

        function n(n, t, i, r) {
            this.color = n || "black";
            this.offsetX = t || 0;
            this.offsetY = i || 0;
            this.blur = r || 0
        }
        var t = n.prototype;
        n.identity = new n("transparent", 0, 0, 0);
        t.toString = function() {
            return "[Shadow]"
        };
        t.clone = function() {
            return new n(this.color, this.offsetX, this.offsetY, this.blur)
        };
        createjs.Shadow = n
    }(),
    function() {
        "use strict";

        function t(n) {
            this.EventDispatcher_constructor();
            this.complete = !0;
            this.framerate = 0;
            this._animations = null;
            this._frames = null;
            this._images = null;
            this._data = null;
            this._loadCount = 0;
            this._frameHeight = 0;
            this._frameWidth = 0;
            this._numFrames = 0;
            this._regX = 0;
            this._regY = 0;
            this._spacing = 0;
            this._margin = 0;
            this._parseData(n)
        }
        var n = createjs.extend(t, createjs.EventDispatcher);
        n._getAnimations = function() {
            return this._animations.slice()
        };
        n.getAnimations = createjs.deprecate(n._getAnimations, "SpriteSheet.getAnimations");
        try {
            Object.defineProperties(n, {
                animations: {
                    get: n._getAnimations
                }
            })
        } catch (i) {}
        n.getNumFrames = function(n) {
            if (n == null) return this._frames ? this._frames.length : this._numFrames || 0;
            var t = this._data[n];
            return t == null ? 0 : t.frames.length
        };
        n.getAnimation = function(n) {
            return this._data[n]
        };
        n.getFrame = function(n) {
            var t;
            return this._frames && (t = this._frames[n]) ? t : null
        };
        n.getFrameBounds = function(n, t) {
            var i = this.getFrame(n);
            return i ? (t || new createjs.Rectangle).setValues(-i.regX, -i.regY, i.rect.width, i.rect.height) : null
        };
        n.toString = function() {
            return "[SpriteSheet]"
        };
        n.clone = function() {
            throw "SpriteSheet cannot be cloned.";
        };
        n._parseData = function(n) {
            var r, h, u, f, e, c, o, s, t, i, l;
            if (n != null) {
                if (this.framerate = n.framerate || 0, n.images && (h = n.images.length) > 0)
                    for (f = this._images = [], r = 0; r < h; r++) e = n.images[r], typeof e == "string" && (c = e, e = document.createElement("img"), e.src = c), f.push(e), e.getContext || e.naturalWidth || (this._loadCount++, this.complete = !1, function(n, t) {
                        e.onload = function() {
                            n._handleImageLoad(t)
                        }
                    }(this, c), function(n, t) {
                        e.onerror = function() {
                            n._handleImageError(t)
                        }
                    }(this, c));
                if (n.frames != null)
                    if (Array.isArray(n.frames))
                        for (this._frames = [], f = n.frames, r = 0, h = f.length; r < h; r++) o = f[r], this._frames.push({
                            image: this._images[o[4] ? o[4] : 0],
                            rect: new createjs.Rectangle(o[0], o[1], o[2], o[3]),
                            regX: o[5] || 0,
                            regY: o[6] || 0
                        });
                    else u = n.frames, this._frameWidth = u.width, this._frameHeight = u.height, this._regX = u.regX || 0, this._regY = u.regY || 0, this._spacing = u.spacing || 0, this._margin = u.margin || 0, this._numFrames = u.count, this._loadCount == 0 && this._calculateFrames();
                if (this._animations = [], (u = n.animations) != null) {
                    this._data = {};
                    for (s in u) {
                        if (t = {
                                name: s
                            }, i = u[s], typeof i == "number") f = t.frames = [i];
                        else if (Array.isArray(i))
                            if (i.length == 1) t.frames = [i[0]];
                            else
                                for (t.speed = i[3], t.next = i[2], f = t.frames = [], r = i[0]; r <= i[1]; r++) f.push(r);
                        else t.speed = i.speed, t.next = i.next, l = i.frames, f = t.frames = typeof l == "number" ? [l] : l.slice(0);
                        (t.next === !0 || t.next === undefined) && (t.next = s);
                        (t.next === !1 || f.length < 2 && t.next == s) && (t.next = null);
                        t.speed || (t.speed = 1);
                        this._animations.push(s);
                        this._data[s] = t
                    }
                }
            }
        };
        n._handleImageLoad = function() {
            --this._loadCount == 0 && (this._calculateFrames(), this.complete = !0, this.dispatchEvent("complete"))
        };
        n._handleImageError = function(n) {
            var t = new createjs.Event("error");
            t.src = n;
            this.dispatchEvent(t);
            --this._loadCount == 0 && this.dispatchEvent("complete")
        };
        n._calculateFrames = function() {
            var i, o, r;
            if (!this._frames && this._frameWidth != 0) {
                this._frames = [];
                var c = this._numFrames || 1e5,
                    u = 0,
                    f = this._frameWidth,
                    e = this._frameHeight,
                    h = this._spacing,
                    t = this._margin;
                n: for (i = 0, o = this._images; i < o.length; i++)
                    for (var n = o[i], l = n.width || n.naturalWidth, a = n.height || n.naturalHeight, s = t; s <= a - t - e;) {
                        for (r = t; r <= l - t - f;) {
                            if (u >= c) break n;
                            u++;
                            this._frames.push({
                                image: n,
                                rect: new createjs.Rectangle(r, s, f, e),
                                regX: this._regX,
                                regY: this._regY
                            });
                            r += f + h
                        }
                        s += e + h
                    }
                this._numFrames = u
            }
        };
        createjs.SpriteSheet = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function i() {
            this.command = null;
            this._stroke = null;
            this._strokeStyle = null;
            this._oldStrokeStyle = null;
            this._strokeDash = null;
            this._oldStrokeDash = null;
            this._strokeIgnoreScale = !1;
            this._fill = null;
            this._instructions = [];
            this._commitIndex = 0;
            this._activeInstructions = [];
            this._dirty = !1;
            this._storeIndex = 0;
            this.clear()
        }
        var n = i.prototype,
            t = i,
            r;
        i.getRGB = function(n, t, i, r) {
            return n != null && i == null && (r = t, i = n & 255, t = n >> 8 & 255, n = n >> 16 & 255), r == null ? "rgb(" + n + "," + t + "," + i + ")" : "rgba(" + n + "," + t + "," + i + "," + r + ")"
        };
        i.getHSL = function(n, t, i, r) {
            return r == null ? "hsl(" + n % 360 + "," + t + "%," + i + "%)" : "hsla(" + n % 360 + "," + t + "%," + i + "%," + r + ")"
        };
        i.BASE_64 = {
            A: 0,
            B: 1,
            C: 2,
            D: 3,
            E: 4,
            F: 5,
            G: 6,
            H: 7,
            I: 8,
            J: 9,
            K: 10,
            L: 11,
            M: 12,
            N: 13,
            O: 14,
            P: 15,
            Q: 16,
            R: 17,
            S: 18,
            T: 19,
            U: 20,
            V: 21,
            W: 22,
            X: 23,
            Y: 24,
            Z: 25,
            a: 26,
            b: 27,
            c: 28,
            d: 29,
            e: 30,
            f: 31,
            g: 32,
            h: 33,
            i: 34,
            j: 35,
            k: 36,
            l: 37,
            m: 38,
            n: 39,
            o: 40,
            p: 41,
            q: 42,
            r: 43,
            s: 44,
            t: 45,
            u: 46,
            v: 47,
            w: 48,
            x: 49,
            y: 50,
            z: 51,
            "0": 52,
            "1": 53,
            "2": 54,
            "3": 55,
            "4": 56,
            "5": 57,
            "6": 58,
            "7": 59,
            "8": 60,
            "9": 61,
            "+": 62,
            "/": 63
        };
        i.STROKE_CAPS_MAP = ["butt", "round", "square"];
        i.STROKE_JOINTS_MAP = ["miter", "round", "bevel"];
        r = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas");
        r.getContext && (i._ctx = r.getContext("2d"), r.width = r.height = 1);
        n._getInstructions = function() {
            return this._updateInstructions(), this._instructions
        };
        n.getInstructions = createjs.deprecate(n._getInstructions, "Graphics.getInstructions");
        try {
            Object.defineProperties(n, {
                instructions: {
                    get: n._getInstructions
                }
            })
        } catch (u) {}
        n.isEmpty = function() {
            return !(this._instructions.length || this._activeInstructions.length)
        };
        n.draw = function(n, t) {
            var r, i, u;
            for (this._updateInstructions(), r = this._instructions, i = this._storeIndex, u = r.length; i < u; i++) r[i].exec(n, t)
        };
        n.drawAsPath = function(n) {
            var r, i, t, u;
            for (this._updateInstructions(), i = this._instructions, t = this._storeIndex, u = i.length; t < u; t++)(r = i[t]).path !== !1 && r.exec(n)
        };
        n.moveTo = function(n, i) {
            return this.append(new t.MoveTo(n, i), !0)
        };
        n.lineTo = function(n, i) {
            return this.append(new t.LineTo(n, i))
        };
        n.arcTo = function(n, i, r, u, f) {
            return this.append(new t.ArcTo(n, i, r, u, f))
        };
        n.arc = function(n, i, r, u, f, e) {
            return this.append(new t.Arc(n, i, r, u, f, e))
        };
        n.quadraticCurveTo = function(n, i, r, u) {
            return this.append(new t.QuadraticCurveTo(n, i, r, u))
        };
        n.bezierCurveTo = function(n, i, r, u, f, e) {
            return this.append(new t.BezierCurveTo(n, i, r, u, f, e))
        };
        n.rect = function(n, i, r, u) {
            return this.append(new t.Rect(n, i, r, u))
        };
        n.closePath = function() {
            return this._activeInstructions.length ? this.append(new t.ClosePath) : this
        };
        n.clear = function() {
            return this._instructions.length = this._activeInstructions.length = this._commitIndex = 0, this._strokeStyle = this._oldStrokeStyle = this._stroke = this._fill = this._strokeDash = this._oldStrokeDash = null, this._dirty = this._strokeIgnoreScale = !1, this
        };
        n.beginFill = function(n) {
            return this._setFill(n ? new t.Fill(n) : null)
        };
        n.beginLinearGradientFill = function(n, i, r, u, f, e) {
            return this._setFill((new t.Fill).linearGradient(n, i, r, u, f, e))
        };
        n.beginRadialGradientFill = function(n, i, r, u, f, e, o, s) {
            return this._setFill((new t.Fill).radialGradient(n, i, r, u, f, e, o, s))
        };
        n.beginBitmapFill = function(n, i, r) {
            return this._setFill(new t.Fill(null, r).bitmap(n, i))
        };
        n.endFill = function() {
            return this.beginFill()
        };
        n.setStrokeStyle = function(n, i, r, u, f) {
            return this._updateInstructions(!0), this._strokeStyle = this.command = new t.StrokeStyle(n, i, r, u, f), this._stroke && (this._stroke.ignoreScale = f), this._strokeIgnoreScale = f, this
        };
        n.setStrokeDash = function(n, i) {
            return this._updateInstructions(!0), this._strokeDash = this.command = new t.StrokeDash(n, i), this
        };
        n.beginStroke = function(n) {
            return this._setStroke(n ? new t.Stroke(n) : null)
        };
        n.beginLinearGradientStroke = function(n, i, r, u, f, e) {
            return this._setStroke((new t.Stroke).linearGradient(n, i, r, u, f, e))
        };
        n.beginRadialGradientStroke = function(n, i, r, u, f, e, o, s) {
            return this._setStroke((new t.Stroke).radialGradient(n, i, r, u, f, e, o, s))
        };
        n.beginBitmapStroke = function(n, i) {
            return this._setStroke((new t.Stroke).bitmap(n, i))
        };
        n.endStroke = function() {
            return this.beginStroke()
        };
        n.curveTo = n.quadraticCurveTo;
        n.drawRect = n.rect;
        n.drawRoundRect = function(n, t, i, r, u) {
            return this.drawRoundRectComplex(n, t, i, r, u, u, u, u)
        };
        n.drawRoundRectComplex = function(n, i, r, u, f, e, o, s) {
            return this.append(new t.RoundRect(n, i, r, u, f, e, o, s))
        };
        n.drawCircle = function(n, i, r) {
            return this.append(new t.Circle(n, i, r))
        };
        n.drawEllipse = function(n, i, r, u) {
            return this.append(new t.Ellipse(n, i, r, u))
        };
        n.drawPolyStar = function(n, i, r, u, f, e) {
            return this.append(new t.PolyStar(n, i, r, u, f, e))
        };
        n.drawPolygon = function(n, i) {
            return this.append(new t.Polygon(n, i))
        };
        n.append = function(n, t) {
            return this._activeInstructions.push(n), this.command = n, t || (this._dirty = !0), this
        };
        n.decodePath = function(n) {
            for (var w = [this.moveTo, this.lineTo, this.quadraticCurveTo, this.bezierCurveTo, this.closePath], b = [2, 2, 4, 6, 0], r = 0, k = n.length, e = [], o = 0, s = 0, f = i.BASE_64, y, l, u, t, p; r < k;) {
                var a = n.charAt(r),
                    h = f[a],
                    c = h >> 3,
                    v = w[c];
                if (!v || h & 3) throw "bad path data (@" + r + "): " + a;
                for (y = b[c], c || (o = s = 0), e.length = 0, r++, l = (h >> 2 & 1) + 2, u = 0; u < y; u++) t = f[n.charAt(r)], p = t >> 5 ? -1 : 1, t = (t & 31) << 6 | f[n.charAt(r + 1)], l == 3 && (t = t << 6 | f[n.charAt(r + 2)]), t = p * t / 10, u % 2 ? o = t += o : s = t += s, e[u] = t, r += l;
                v.apply(this, e)
            }
            return this
        };
        n.store = function() {
            return this._updateInstructions(!0), this._storeIndex = this._instructions.length, this
        };
        n.unstore = function() {
            return this._storeIndex = 0, this
        };
        n.clone = function() {
            var n = new i;
            return n.command = this.command, n._stroke = this._stroke, n._strokeStyle = this._strokeStyle, n._strokeDash = this._strokeDash, n._strokeIgnoreScale = this._strokeIgnoreScale, n._fill = this._fill, n._instructions = this._instructions.slice(), n._commitIndex = this._commitIndex, n._activeInstructions = this._activeInstructions.slice(), n._dirty = this._dirty, n._storeIndex = this._storeIndex, n
        };
        n.toString = function() {
            return "[Graphics]"
        };
        n.mt = n.moveTo;
        n.lt = n.lineTo;
        n.at = n.arcTo;
        n.bt = n.bezierCurveTo;
        n.qt = n.quadraticCurveTo;
        n.a = n.arc;
        n.r = n.rect;
        n.cp = n.closePath;
        n.c = n.clear;
        n.f = n.beginFill;
        n.lf = n.beginLinearGradientFill;
        n.rf = n.beginRadialGradientFill;
        n.bf = n.beginBitmapFill;
        n.ef = n.endFill;
        n.ss = n.setStrokeStyle;
        n.sd = n.setStrokeDash;
        n.s = n.beginStroke;
        n.ls = n.beginLinearGradientStroke;
        n.rs = n.beginRadialGradientStroke;
        n.bs = n.beginBitmapStroke;
        n.es = n.endStroke;
        n.dr = n.drawRect;
        n.rr = n.drawRoundRect;
        n.rc = n.drawRoundRectComplex;
        n.dc = n.drawCircle;
        n.de = n.drawEllipse;
        n.dp = n.drawPolyStar;
        n.pg = n.drawPolygon;
        n.p = n.decodePath;
        n._updateInstructions = function(n) {
            var t = this._instructions,
                u = this._activeInstructions,
                o = this._commitIndex,
                f, e, r;
            if (this._dirty && u.length) {
                for (t.length = o, t.push(i.beginCmd), f = u.length, e = t.length, t.length = e + f, r = 0; r < f; r++) t[r + e] = u[r];
                this._fill && t.push(this._fill);
                this._stroke && (this._strokeDash !== this._oldStrokeDash && t.push(this._strokeDash), this._strokeStyle !== this._oldStrokeStyle && t.push(this._strokeStyle), n && (this._oldStrokeStyle = this._strokeStyle, this._oldStrokeDash = this._strokeDash), t.push(this._stroke));
                this._dirty = !1
            }
            n && (u.length = 0, this._commitIndex = t.length)
        };
        n._setFill = function(n) {
            return this._updateInstructions(!0), this.command = this._fill = n, this
        };
        n._setStroke = function(n) {
            return this._updateInstructions(!0), (this.command = this._stroke = n) && (n.ignoreScale = this._strokeIgnoreScale), this
        };
        (t.LineTo = function(n, t) {
            this.x = n;
            this.y = t
        }).prototype.exec = function(n) {
            n.lineTo(this.x, this.y)
        };
        (t.MoveTo = function(n, t) {
            this.x = n;
            this.y = t
        }).prototype.exec = function(n) {
            n.moveTo(this.x, this.y)
        };
        (t.ArcTo = function(n, t, i, r, u) {
            this.x1 = n;
            this.y1 = t;
            this.x2 = i;
            this.y2 = r;
            this.radius = u
        }).prototype.exec = function(n) {
            n.arcTo(this.x1, this.y1, this.x2, this.y2, this.radius)
        };
        (t.Arc = function(n, t, i, r, u, f) {
            this.x = n;
            this.y = t;
            this.radius = i;
            this.startAngle = r;
            this.endAngle = u;
            this.anticlockwise = !!f
        }).prototype.exec = function(n) {
            n.arc(this.x, this.y, this.radius, this.startAngle, this.endAngle, this.anticlockwise)
        };
        (t.QuadraticCurveTo = function(n, t, i, r) {
            this.cpx = n;
            this.cpy = t;
            this.x = i;
            this.y = r
        }).prototype.exec = function(n) {
            n.quadraticCurveTo(this.cpx, this.cpy, this.x, this.y)
        };
        (t.BezierCurveTo = function(n, t, i, r, u, f) {
            this.cp1x = n;
            this.cp1y = t;
            this.cp2x = i;
            this.cp2y = r;
            this.x = u;
            this.y = f
        }).prototype.exec = function(n) {
            n.bezierCurveTo(this.cp1x, this.cp1y, this.cp2x, this.cp2y, this.x, this.y)
        };
        (t.Rect = function(n, t, i, r) {
            this.x = n;
            this.y = t;
            this.w = i;
            this.h = r
        }).prototype.exec = function(n) {
            n.rect(this.x, this.y, this.w, this.h)
        };
        (t.ClosePath = function() {}).prototype.exec = function(n) {
            n.closePath()
        };
        (t.BeginPath = function() {}).prototype.exec = function(n) {
            n.beginPath()
        };
        n = (t.Fill = function(n, t) {
            this.style = n;
            this.matrix = t
        }).prototype;
        n.exec = function(n) {
            if (this.style) {
                n.fillStyle = this.style;
                var t = this.matrix;
                t && (n.save(), n.transform(t.a, t.b, t.c, t.d, t.tx, t.ty));
                n.fill();
                t && n.restore()
            }
        };
        n.linearGradient = function(n, t, r, u, f, e) {
            for (var s = this.style = i._ctx.createLinearGradient(r, u, f, e), o = 0, h = n.length; o < h; o++) s.addColorStop(t[o], n[o]);
            return s.props = {
                colors: n,
                ratios: t,
                x0: r,
                y0: u,
                x1: f,
                y1: e,
                type: "linear"
            }, this
        };
        n.radialGradient = function(n, t, r, u, f, e, o, s) {
            for (var c = this.style = i._ctx.createRadialGradient(r, u, f, e, o, s), h = 0, l = n.length; h < l; h++) c.addColorStop(t[h], n[h]);
            return c.props = {
                colors: n,
                ratios: t,
                x0: r,
                y0: u,
                r0: f,
                x1: e,
                y1: o,
                r1: s,
                type: "radial"
            }, this
        };
        n.bitmap = function(n, t, r) {
            if (r && (this.matrix = r), n.naturalWidth || n.getContext || n.readyState >= 2) {
                var u = this.style = i._ctx.createPattern(n, t || "");
                u.props = {
                    image: n,
                    repetition: t,
                    type: "bitmap"
                }
            }
            return this
        };
        n.path = !1;
        n = (t.Stroke = function(n, t) {
            this.style = n;
            this.ignoreScale = t
        }).prototype;
        n.exec = function(n) {
            this.style && (n.strokeStyle = this.style, this.ignoreScale && (n.save(), n.setTransform(1, 0, 0, 1, 0, 0)), n.stroke(), this.ignoreScale && n.restore())
        };
        n.linearGradient = t.Fill.prototype.linearGradient;
        n.radialGradient = t.Fill.prototype.radialGradient;
        n.bitmap = t.Fill.prototype.bitmap;
        n.path = !1;
        n = (t.StrokeStyle = function(n, t, i, r, u) {
            this.width = n;
            this.caps = t;
            this.joints = i;
            this.miterLimit = r;
            this.ignoreScale = u
        }).prototype;
        n.exec = function(n) {
            n.lineWidth = this.width == null ? "1" : this.width;
            n.lineCap = this.caps == null ? "butt" : isNaN(this.caps) ? this.caps : i.STROKE_CAPS_MAP[this.caps];
            n.lineJoin = this.joints == null ? "miter" : isNaN(this.joints) ? this.joints : i.STROKE_JOINTS_MAP[this.joints];
            n.miterLimit = this.miterLimit == null ? "10" : this.miterLimit;
            n.ignoreScale = this.ignoreScale == null ? !1 : this.ignoreScale
        };
        n.path = !1;
        (t.StrokeDash = function(n, t) {
            this.segments = n;
            this.offset = t || 0
        }).prototype.exec = function(n) {
            n.setLineDash && (n.setLineDash(this.segments || t.StrokeDash.EMPTY_SEGMENTS), n.lineDashOffset = this.offset || 0)
        };
        t.StrokeDash.EMPTY_SEGMENTS = [];
        (t.RoundRect = function(n, t, i, r, u, f, e, o) {
            this.x = n;
            this.y = t;
            this.w = i;
            this.h = r;
            this.radiusTL = u;
            this.radiusTR = f;
            this.radiusBR = e;
            this.radiusBL = o
        }).prototype.exec = function(n) {
            var o = (s < h ? s : h) / 2,
                c = 0,
                l = 0,
                a = 0,
                v = 0,
                t = this.x,
                i = this.y,
                s = this.w,
                h = this.h,
                r = this.radiusTL,
                u = this.radiusTR,
                f = this.radiusBR,
                e = this.radiusBL;
            r < 0 && (r *= c = -1);
            r > o && (r = o);
            u < 0 && (u *= l = -1);
            u > o && (u = o);
            f < 0 && (f *= a = -1);
            f > o && (f = o);
            e < 0 && (e *= v = -1);
            e > o && (e = o);
            n.moveTo(t + s - u, i);
            n.arcTo(t + s + u * l, i - u * l, t + s, i + u, u);
            n.lineTo(t + s, i + h - f);
            n.arcTo(t + s + f * a, i + h + f * a, t + s - f, i + h, f);
            n.lineTo(t + e, i + h);
            n.arcTo(t - e * v, i + h + e * v, t, i + h - e, e);
            n.lineTo(t, i + r);
            n.arcTo(t - r * c, i - r * c, t + r, i, r);
            n.closePath()
        };
        (t.Circle = function(n, t, i) {
            this.x = n;
            this.y = t;
            this.radius = i
        }).prototype.exec = function(n) {
            n.arc(this.x, this.y, this.radius, 0, Math.PI * 2)
        };
        (t.Ellipse = function(n, t, i, r) {
            this.x = n;
            this.y = t;
            this.w = i;
            this.h = r
        }).prototype.exec = function(n) {
            var i = this.x,
                u = this.y,
                o = this.w,
                s = this.h,
                l = .5522848,
                f = o / 2 * l,
                e = s / 2 * l,
                h = i + o,
                c = u + s,
                r = i + o / 2,
                t = u + s / 2;
            n.moveTo(i, t);
            n.bezierCurveTo(i, t - e, r - f, u, r, u);
            n.bezierCurveTo(r + f, u, h, t - e, h, t);
            n.bezierCurveTo(h, t + e, r + f, c, r, c);
            n.bezierCurveTo(r - f, c, i, t + e, i, t)
        };
        (t.PolyStar = function(n, t, i, r, u, f) {
            this.x = n;
            this.y = t;
            this.radius = i;
            this.sides = r;
            this.pointSize = u;
            this.angle = f
        }).prototype.exec = function(n) {
            var u = this.x,
                f = this.y,
                i = this.radius,
                t = (this.angle || 0) / 180 * Math.PI,
                e = this.sides,
                o = 1 - (this.pointSize || 0),
                s = Math.PI / e,
                r;
            for (n.moveTo(u + Math.cos(t) * i, f + Math.sin(t) * i), r = 0; r < e + 1; r++) {
                if (t += s, o != 1 && (n.lineTo(u + Math.cos(t) * i * o, f + Math.sin(t) * i * o), r == e)) break;
                t += s;
                n.lineTo(u + Math.cos(t) * i, f + Math.sin(t) * i)
            }
            n.closePath()
        };
        (t.Polygon = function(n, t) {
            this.points = n;
            t == null && (t = !0);
            this.close = t
        }).prototype.exec = function(n) {
            var u = this.points,
                e = this.close,
                t, i, f, r;
            for (i = u[0], n.moveTo(i[0], i[1]), r = 1; r < u.length; r++) t = u[r], r == 1 && (f = [t[0], t[1]]), n.lineTo(t[0], t[1]);
            e && (n.lineTo(i[0], i[1]), n.lineTo(f[0], f[1]));
            n.closePath()
        };
        i.beginCmd = new t.BeginPath;
        createjs.Graphics = i
    }(),
    function() {
        "use strict";

        function t() {
            this.EventDispatcher_constructor();
            this.alpha = 1;
            this.cacheCanvas = null;
            this.bitmapCache = null;
            this.id = createjs.UID.get();
            this.mouseEnabled = !0;
            this.tickEnabled = !0;
            this.name = null;
            this.parent = null;
            this.regX = 0;
            this.regY = 0;
            this.rotation = 0;
            this.scaleX = 1;
            this.scaleY = 1;
            this.skewX = 0;
            this.skewY = 0;
            this.shadow = null;
            this.visible = !0;
            this.x = 0;
            this.y = 0;
            this.transformMatrix = null;
            this.compositeOperation = null;
            this.snapToPixel = !0;
            this.filters = null;
            this.mask = null;
            this.hitArea = null;
            this.cursor = null;
            this._props = new createjs.DisplayProps;
            this._rectangle = new createjs.Rectangle;
            this._bounds = null;
            this._webGLRenderStyle = t._StageGL_NONE
        }
        var n = createjs.extend(t, createjs.EventDispatcher),
            i;
        t._MOUSE_EVENTS = ["click", "dblclick", "mousedown", "mouseout", "mouseover", "pressmove", "pressup", "rollout", "rollover"];
        t.suppressCrossDomainErrors = !1;
        t._snapToPixelEnabled = !1;
        t._StageGL_NONE = 0;
        t._StageGL_SPRITE = 1;
        t._StageGL_BITMAP = 2;
        i = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas");
        i.getContext && (t._hitTestCanvas = i, t._hitTestContext = i.getContext("2d"), i.width = i.height = 1);
        n._getStage = function() {
            for (var n = this, t = createjs.Stage; n.parent;) n = n.parent;
            return n instanceof t ? n : null
        };
        n.getStage = createjs.deprecate(n._getStage, "DisplayObject.getStage");
        try {
            Object.defineProperties(n, {
                stage: {
                    get: n._getStage
                },
                cacheID: {
                    get: function() {
                        return this.bitmapCache && this.bitmapCache.cacheID
                    },
                    set: function(n) {
                        this.bitmapCache && (this.bitmapCache.cacheID = n)
                    }
                },
                scale: {
                    get: function() {
                        return this.scaleX
                    },
                    set: function(n) {
                        this.scaleX = this.scaleY = n
                    }
                }
            })
        } catch (r) {}
        n.isVisible = function() {
            return !!(this.visible && this.alpha > 0 && this.scaleX != 0 && this.scaleY != 0)
        };
        n.draw = function(n, t) {
            var i = this.bitmapCache;
            return i && !t ? i.draw(n) : !1
        };
        n.updateContext = function(n) {
            var r = this,
                u = r.mask,
                i = r._props.matrix,
                f, e;
            u && u.graphics && !u.graphics.isEmpty() && (u.getMatrix(i), n.transform(i.a, i.b, i.c, i.d, i.tx, i.ty), u.graphics.drawAsPath(n), n.clip(), i.invert(), n.transform(i.a, i.b, i.c, i.d, i.tx, i.ty));
            this.getMatrix(i);
            f = i.tx;
            e = i.ty;
            t._snapToPixelEnabled && r.snapToPixel && (f = f + (f < 0 ? -.5 : .5) | 0, e = e + (e < 0 ? -.5 : .5) | 0);
            n.transform(i.a, i.b, i.c, i.d, f, e);
            n.globalAlpha *= r.alpha;
            r.compositeOperation && (n.globalCompositeOperation = r.compositeOperation);
            r.shadow && this._applyShadow(n, r.shadow)
        };
        n.cache = function(n, t, i, r, u, f) {
            this.bitmapCache || (this.bitmapCache = new createjs.BitmapCache);
            this.bitmapCache.define(this, n, t, i, r, u, f)
        };
        n.updateCache = function(n) {
            if (!this.bitmapCache) throw "cache() must be called before updateCache()";
            this.bitmapCache.update(n)
        };
        n.uncache = function() {
            this.bitmapCache && (this.bitmapCache.release(), this.bitmapCache = undefined)
        };
        n.getCacheDataURL = function() {
            return this.bitmapCache ? this.bitmapCache.getCacheDataURL() : null
        };
        n.localToGlobal = function(n, t, i) {
            var r = this.getConcatenatedMatrix(this._props.matrix).transformPoint(n, t, i || new createjs.Point);
            return this.stage && createjs.stageTransformable && (r = this.stage.getConcatenatedMatrix(this._mtx).invert().transformPoint(r.x, r.y)), r
        };
        n.globalToLocal = function(n, t, i) {
            if (this.stage && createjs.stageTransformable) {
                var r = this.stage.getConcatenatedMatrix(this._mtx).transformPoint(n, t);
                n = r.x;
                t = r.y
            }
            return this.getConcatenatedMatrix(this._props.matrix).invert().transformPoint(n, t, i || new createjs.Point)
        };
        n.localToLocal = function(n, t, i, r) {
            return r = this.localToGlobal(n, t, r), i.globalToLocal(r.x, r.y, r)
        };
        n.setTransform = function(n, t, i, r, u, f, e, o, s) {
            return this.x = n || 0, this.y = t || 0, this.scaleX = i == null ? 1 : i, this.scaleY = r == null ? 1 : r, this.rotation = u || 0, this.skewX = f || 0, this.skewY = e || 0, this.regX = o || 0, this.regY = s || 0, this
        };
        n.getMatrix = function(n) {
            var t = this,
                i = n && n.identity() || new createjs.Matrix2D;
            return t.transformMatrix ? i.copy(t.transformMatrix) : i.appendTransform(t.x, t.y, t.scaleX, t.scaleY, t.rotation, t.skewX, t.skewY, t.regX, t.regY)
        };
        n.getConcatenatedMatrix = function(n) {
            for (var t = this, i = this.getMatrix(n); t = t.parent;) i.prependMatrix(t.getMatrix(t._props.matrix));
            return i
        };
        n.getConcatenatedDisplayProps = function(n) {
            n = n ? n.identity() : new createjs.DisplayProps;
            var t = this,
                i = t.getMatrix(n.matrix);
            do n.prepend(t.visible, t.alpha, t.shadow, t.compositeOperation), t != this && i.prependMatrix(t.getMatrix(t._props.matrix)); while (t = t.parent);
            return n
        };
        n.hitTest = function(n, i) {
            var r = t._hitTestContext,
                u;
            return r.setTransform(1, 0, 0, 1, -n, -i), this.draw(r), u = this._testHit(r), r.setTransform(1, 0, 0, 1, 0, 0), r.clearRect(0, 0, 2, 2), u
        };
        n.set = function(n) {
            for (var t in n) this[t] = n[t];
            return this
        };
        n.getBounds = function() {
            var n, t;
            return this._bounds ? this._rectangle.copy(this._bounds) : (n = this.cacheCanvas, n) ? (t = this._cacheScale, this._rectangle.setValues(this._cacheOffsetX, this._cacheOffsetY, n.width / t, n.height / t)) : null
        };
        n.getTransformedBounds = function() {
            return this._getBounds()
        };
        n.setBounds = function(n, t, i, r) {
            if (n == null) {
                this._bounds = n;
                return
            }
            this._bounds = (this._bounds || new createjs.Rectangle).setValues(n, t, i, r)
        };
        n.clone = function() {
            return this._cloneProps(new t)
        };
        n.toString = function() {
            return "[DisplayObject (name=" + this.name + ")]"
        };
        n._updateState = null;
        n._cloneProps = function(n) {
            return n.alpha = this.alpha, n.mouseEnabled = this.mouseEnabled, n.tickEnabled = this.tickEnabled, n.name = this.name, n.regX = this.regX, n.regY = this.regY, n.rotation = this.rotation, n.scaleX = this.scaleX, n.scaleY = this.scaleY, n.shadow = this.shadow, n.skewX = this.skewX, n.skewY = this.skewY, n.visible = this.visible, n.x = this.x, n.y = this.y, n.compositeOperation = this.compositeOperation, n.snapToPixel = this.snapToPixel, n.filters = this.filters == null ? null : this.filters.slice(0), n.mask = this.mask, n.hitArea = this.hitArea, n.cursor = this.cursor, n._bounds = this._bounds, n
        };
        n._applyShadow = function(n, t) {
            t = t || Shadow.identity;
            n.shadowColor = t.color;
            n.shadowOffsetX = t.offsetX;
            n.shadowOffsetY = t.offsetY;
            n.shadowBlur = t.blur
        };
        n._tick = function(n) {
            var t = this._listeners;
            t && t.tick && (n.target = null, n.propagationStopped = n.immediatePropagationStopped = !1, this.dispatchEvent(n))
        };
        n._testHit = function(n) {
            try {
                var i = n.getImageData(0, 0, 1, 1).data[3] > 1
            } catch (r) {
                if (!t.suppressCrossDomainErrors) throw "An error has occurred. This is most likely due to security restrictions on reading canvas pixel data with local or cross-domain images.";
            }
            return i
        };
        n._getBounds = function(n, t) {
            return this._transformBounds(this.getBounds(), n, t)
        };
        n._transformBounds = function(n, t, i) {
            if (!n) return n;
            var r = n.x,
                u = n.y,
                a = n.width,
                v = n.height,
                f = this._props.matrix;
            f = i ? f.identity() : this.getMatrix(f);
            (r || u) && f.appendTransform(0, 0, 1, 1, 0, 0, 0, -r, -u);
            t && f.prependMatrix(t);
            var y = a * f.a,
                p = a * f.b,
                w = v * f.c,
                b = v * f.d,
                c = f.tx,
                l = f.ty,
                e = c,
                s = c,
                o = l,
                h = l;
            return (r = y + c) < e ? e = r : r > s && (s = r), (r = y + w + c) < e ? e = r : r > s && (s = r), (r = w + c) < e ? e = r : r > s && (s = r), (u = p + l) < o ? o = u : u > h && (h = u), (u = p + b + l) < o ? o = u : u > h && (h = u), (u = b + l) < o ? o = u : u > h && (h = u), n.setValues(e, o, s - e, h - o)
        };
        n._hasMouseEventListener = function() {
            for (var i = t._MOUSE_EVENTS, n = 0, r = i.length; n < r; n++)
                if (this.hasEventListener(i[n])) return !0;
            return !!this.cursor
        };
        createjs.DisplayObject = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function t() {
            this.DisplayObject_constructor();
            this.children = [];
            this.mouseChildren = !0;
            this.tickChildren = !0
        }
        var n = createjs.extend(t, createjs.DisplayObject);
        n._getNumChildren = function() {
            return this.children.length
        };
        n.getNumChildren = createjs.deprecate(n._getNumChildren, "Container.getNumChildren");
        try {
            Object.defineProperties(n, {
                numChildren: {
                    get: n._getNumChildren
                }
            })
        } catch (i) {}
        n.initialize = t;
        n.isVisible = function() {
            var n = this.cacheCanvas || this.children.length;
            return !!(this.visible && this.alpha > 0 && this.scaleX != 0 && this.scaleY != 0 && n)
        };
        n.draw = function(n, t) {
            var u, i, f, r;
            if (this.DisplayObject_draw(n, t)) return !0;
            for (u = this.children.slice(), i = 0, f = u.length; i < f; i++)(r = u[i], r.isVisible()) && (n.save(), r.updateContext(n), r.draw(n), n.restore());
            return !0
        };
        n.addChild = function(n) {
            var i, r, t, u;
            if (n == null) return n;
            if (i = arguments.length, i > 1) {
                for (r = 0; r < i; r++) this.addChild(arguments[r]);
                return arguments[i - 1]
            }
            return t = n.parent, u = t === this, t && t._removeChildAt(createjs.indexOf(t.children, n), u), n.parent = this, this.children.push(n), u || n.dispatchEvent("added"), n
        };
        n.addChildAt = function(n, t) {
            var i = arguments.length,
                f = arguments[i - 1],
                r, u, e;
            if (f < 0 || f > this.children.length) return arguments[i - 2];
            if (i > 2) {
                for (r = 0; r < i - 1; r++) this.addChildAt(arguments[r], f + r);
                return arguments[i - 2]
            }
            return u = n.parent, e = u === this, u && u._removeChildAt(createjs.indexOf(u.children, n), e), n.parent = this, this.children.splice(t, 0, n), e || n.dispatchEvent("added"), n
        };
        n.removeChild = function(n) {
            var r = arguments.length,
                t, i;
            if (r > 1) {
                for (t = !0, i = 0; i < r; i++) t = t && this.removeChild(arguments[i]);
                return t
            }
            return this._removeChildAt(createjs.indexOf(this.children, n))
        };
        n.removeChildAt = function(n) {
            var u = arguments.length,
                i, r, t;
            if (u > 1) {
                for (i = [], t = 0; t < u; t++) i[t] = arguments[t];
                for (i.sort(function(n, t) {
                        return t - n
                    }), r = !0, t = 0; t < u; t++) r = r && this._removeChildAt(i[t]);
                return r
            }
            return this._removeChildAt(n)
        };
        n.removeAllChildren = function() {
            for (var n = this.children; n.length;) this._removeChildAt(0)
        };
        n.getChildAt = function(n) {
            return this.children[n]
        };
        n.getChildByName = function(n) {
            for (var i = this.children, t = 0, r = i.length; t < r; t++)
                if (i[t].name == n) return i[t];
            return null
        };
        n.sortChildren = function(n) {
            this.children.sort(n)
        };
        n.getChildIndex = function(n) {
            return createjs.indexOf(this.children, n)
        };
        n.swapChildrenAt = function(n, t) {
            var i = this.children,
                r = i[n],
                u = i[t];
            r && u && (i[n] = u, i[t] = r)
        };
        n.swapChildren = function(n, t) {
            for (var r = this.children, u, f, i = 0, e = r.length; i < e; i++)
                if (r[i] == n && (u = i), r[i] == t && (f = i), u != null && f != null) break;
            i != e && (r[u] = t, r[f] = n)
        };
        n.setChildIndex = function(n, t) {
            var r = this.children,
                u = r.length,
                i;
            if (n.parent == this && !(t < 0) && !(t >= u)) {
                for (i = 0; i < u; i++)
                    if (r[i] == n) break;
                i != u && i != t && (r.splice(i, 1), r.splice(t, 0, n))
            }
        };
        n.contains = function(n) {
            while (n) {
                if (n == this) return !0;
                n = n.parent
            }
            return !1
        };
        n.hitTest = function(n, t) {
            return this.getObjectUnderPoint(n, t) != null
        };
        n.getObjectsUnderPoint = function(n, t, i) {
            var r = [],
                u = this.localToGlobal(n, t);
            return this._getObjectsUnderPoint(u.x, u.y, r, i > 0, i == 1), r
        };
        n.getObjectUnderPoint = function(n, t, i) {
            var r = this.localToGlobal(n, t);
            return this._getObjectsUnderPoint(r.x, r.y, null, i > 0, i == 1)
        };
        n.getBounds = function() {
            return this._getBounds(null, !0)
        };
        n.getTransformedBounds = function() {
            return this._getBounds()
        };
        n.clone = function(n) {
            var i = this._cloneProps(new t);
            return n && this._cloneChildren(i), i
        };
        n.toString = function() {
            return "[Container (name=" + this.name + ")]"
        };
        n._tick = function(n) {
            var t, i;
            if (this.tickChildren)
                for (t = this.children.length - 1; t >= 0; t--) i = this.children[t], i.tickEnabled && i._tick && i._tick(n);
            this.DisplayObject__tick(n)
        };
        n._cloneChildren = function(n) {
            var r, t, u, i;
            for (n.children.length && n.removeAllChildren(), r = n.children, t = 0, u = this.children.length; t < u; t++) i = this.children[t].clone(!0), i.parent = n, r.push(i)
        };
        n._removeChildAt = function(n, t) {
            if (n < 0 || n > this.children.length - 1) return !1;
            var i = this.children[n];
            return i && (i.parent = null), this.children.splice(n, 1), t || i.dispatchEvent("removed"), !0
        };
        n._getObjectsUnderPoint = function(n, i, r, u, f, e) {
            var h, c, v, k, l, o, s, y, a;
            if (this.stage && createjs.stageTransformable) {
                var p = n,
                    w = i,
                    b = this.stage.getConcatenatedMatrix(this._mtx).transformPoint(n, i);
                n = b.x;
                i = b.y
            }
            if (e = e || 0, !e && !this._testMask(this, n, i)) return null;
            for (c = createjs.DisplayObject._hitTestContext, f = f || u && this._hasMouseEventListener(), v = this.children, k = v.length, l = k - 1; l >= 0; l--)
                if ((o = v[l], s = o.hitArea, o.visible && (s || o.isVisible()) && (!u || o.mouseEnabled)) && (s || this._testMask(o, n, i)))
                    if (!s && o instanceof t) {
                        if (y = o._getObjectsUnderPoint(p != null ? p : n, w != null ? w : i, r, u, f, e + 1), !r && y) return u && !this.mouseChildren ? this : y
                    } else {
                        if (u && !f && !o._hasMouseEventListener()) continue;
                        if (a = o.getConcatenatedDisplayProps(o._props), h = a.matrix, s && (h.appendMatrix(s.getMatrix(s._props.matrix)), a.alpha = s.alpha), c.globalAlpha = a.alpha, c.setTransform(h.a, h.b, h.c, h.d, h.tx - n, h.ty - i), (s || o).draw(c), !this._testHit(c)) continue;
                        if (c.setTransform(1, 0, 0, 1, 0, 0), c.clearRect(0, 0, 2, 2), r) r.push(o);
                        else return u && !this.mouseChildren ? this : o
                    }
            return null
        };
        n._testMask = function(n, t, i) {
            var f = n.mask,
                r, e, u;
            return !f || !f.graphics || f.graphics.isEmpty() ? !0 : (r = this._props.matrix, e = n.parent, r = e ? e.getConcatenatedMatrix(r) : r.identity(), r = f.getMatrix(f._props.matrix).prependMatrix(r), u = createjs.DisplayObject._hitTestContext, u.setTransform(r.a, r.b, r.c, r.d, r.tx - t, r.ty - i), f.graphics.drawAsPath(u), u.fillStyle = "#000", u.fill(), !this._testHit(u)) ? !1 : (u.setTransform(1, 0, 0, 1, 0, 0), u.clearRect(0, 0, 2, 2), !0)
        };
        n._getBounds = function(n, t) {
            var i = this.DisplayObject_getBounds(),
                r, o, u, f, e;
            if (i) return this._transformBounds(i, n, t);
            for (r = this._props.matrix, r = t ? r.identity() : this.getMatrix(r), n && r.prependMatrix(n), o = this.children.length, u = null, f = 0; f < o; f++)(e = this.children[f], e.visible && (i = e._getBounds(r))) && (u ? u.extend(i.x, i.y, i.width, i.height) : u = i.clone());
            return u
        };
        createjs.Container = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.Container_constructor();
            this.autoClear = !0;
            this.canvas = typeof n == "string" ? document.getElementById(n) : n;
            this.mouseX = 0;
            this.mouseY = 0;
            this.drawRect = null;
            this.snapToPixelEnabled = !1;
            this.mouseInBounds = !1;
            this.tickOnUpdate = !0;
            this.mouseMoveOutside = !1;
            this.preventSelection = !0;
            this._pointerData = {};
            this._pointerCount = 0;
            this._primaryPointerID = null;
            this._mouseOverIntervalID = null;
            this._nextStage = null;
            this._prevStage = null;
            this.enableDOMEvents(!0)
        }
        var n = createjs.extend(t, createjs.Container);
        n._get_nextStage = function() {
            return this._nextStage
        };
        n._set_nextStage = function(n) {
            this._nextStage && (this._nextStage._prevStage = null);
            n && (n._prevStage = this);
            this._nextStage = n
        };
        try {
            Object.defineProperties(n, {
                nextStage: {
                    get: n._get_nextStage,
                    set: n._set_nextStage
                }
            })
        } catch (i) {}
        n.update = function(n) {
            if (this.canvas && (this.tickOnUpdate && this.tick(n), this.dispatchEvent("drawstart", !1, !0) !== !1)) {
                createjs.DisplayObject._snapToPixelEnabled = this.snapToPixelEnabled;
                var i = this.drawRect,
                    t = this.canvas.getContext("2d");
                t.setTransform(1, 0, 0, 1, 0, 0);
                this.autoClear && (i ? t.clearRect(i.x, i.y, i.width, i.height) : t.clearRect(0, 0, this.canvas.width + 1, this.canvas.height + 1));
                t.save();
                this.drawRect && (t.beginPath(), t.rect(i.x, i.y, i.width, i.height), t.clip());
                this.updateContext(t);
                this.draw(t, !1);
                t.restore();
                this.dispatchEvent("drawend")
            }
        };
        n.tick = function(n) {
            var i, t;
            if (this.tickEnabled && this.dispatchEvent("tickstart", !1, !0) !== !1) {
                if (i = new createjs.Event("tick"), n)
                    for (t in n) n.hasOwnProperty(t) && (i[t] = n[t]);
                this._tick(i);
                this.dispatchEvent("tickend")
            }
        };
        n.handleEvent = function(n) {
            n.type == "tick" && this.update(n)
        };
        n.clear = function() {
            if (this.canvas) {
                var n = this.canvas.getContext("2d");
                n.setTransform(1, 0, 0, 1, 0, 0);
                n.clearRect(0, 0, this.canvas.width + 1, this.canvas.height + 1)
            }
        };
        n.toDataURL = function(n, t) {
            var r, i = this.canvas.getContext("2d"),
                u = this.canvas.width,
                f = this.canvas.height,
                e, o;
            return n && (r = i.getImageData(0, 0, u, f), e = i.globalCompositeOperation, i.globalCompositeOperation = "destination-over", i.fillStyle = n, i.fillRect(0, 0, u, f)), o = this.canvas.toDataURL(t || "image/png"), n && (i.putImageData(r, 0, 0), i.globalCompositeOperation = e), o
        };
        n.enableMouseOver = function(n) {
            if (this._mouseOverIntervalID && (clearInterval(this._mouseOverIntervalID), this._mouseOverIntervalID = null, n == 0 && this._testMouseOver(!0)), n == null) n = 20;
            else if (n <= 0) return;
            var t = this;
            this._mouseOverIntervalID = setInterval(function() {
                t._testMouseOver()
            }, 1e3 / Math.min(50, n))
        };
        n.enableDOMEvents = function(n) {
            var i, r, t, f, u;
            if (n == null && (n = !0), t = this._eventListeners, !n && t) {
                for (i in t) r = t[i], r.t.removeEventListener(i, r.f, !1);
                this._eventListeners = null
            } else if (n && !t && this.canvas) {
                f = window.addEventListener ? window : document;
                u = this;
                t = this._eventListeners = {};
                t.mouseup = {
                    t: f,
                    f: function(n) {
                        u._handleMouseUp(n)
                    }
                };
                t.mousemove = {
                    t: f,
                    f: function(n) {
                        u._handleMouseMove(n)
                    }
                };
                t.dblclick = {
                    t: this.canvas,
                    f: function(n) {
                        u._handleDoubleClick(n)
                    }
                };
                t.mousedown = {
                    t: this.canvas,
                    f: function(n) {
                        u._handleMouseDown(n)
                    }
                };
                for (i in t) r = t[i], r.t.addEventListener(i, r.f, !1)
            }
        };
        n.clone = function() {
            throw "Stage cannot be cloned.";
        };
        n.toString = function() {
            return "[Stage (name=" + this.name + ")]"
        };
        n._getElementRect = function(n) {
            var i;
            try {
                i = n.getBoundingClientRect()
            } catch (h) {
                i = {
                    top: n.offsetTop,
                    left: n.offsetLeft,
                    width: n.offsetWidth,
                    height: n.offsetHeight
                }
            }
            var r = (window.pageXOffset || document.scrollLeft || 0) - (document.clientLeft || document.body.clientLeft || 0),
                u = (window.pageYOffset || document.scrollTop || 0) - (document.clientTop || document.body.clientTop || 0),
                t = window.getComputedStyle ? getComputedStyle(n, null) : n.currentStyle,
                f = parseInt(t.paddingLeft) + parseInt(t.borderLeftWidth),
                e = parseInt(t.paddingTop) + parseInt(t.borderTopWidth),
                o = parseInt(t.paddingRight) + parseInt(t.borderRightWidth),
                s = parseInt(t.paddingBottom) + parseInt(t.borderBottomWidth);
            return {
                left: i.left + r + f,
                right: i.right + r - o,
                top: i.top + u + e,
                bottom: i.bottom + u - s
            }
        };
        n._getPointerData = function(n) {
            var t = this._pointerData[n];
            return t || (t = this._pointerData[n] = {
                x: 0,
                y: 0
            }), t
        };
        n._handleMouseMove = function(n) {
            n || (n = window.event);
            this._handlePointerMove(-1, n, n.pageX, n.pageY)
        };
        n._handlePointerMove = function(n, t, i, r, u) {
            if ((!this._prevStage || u !== undefined) && this.canvas) {
                var o = this._nextStage,
                    f = this._getPointerData(n),
                    e = f.inBounds;
                this._updatePointerPosition(n, t, i, r);
                (e || f.inBounds || this.mouseMoveOutside) && (n === -1 && f.inBounds == !e && this._dispatchMouseEvent(this, e ? "mouseleave" : "mouseenter", !1, n, f, t), this._dispatchMouseEvent(this, "stagemousemove", !1, n, f, t), this._dispatchMouseEvent(f.target, "pressmove", !0, n, f, t));
                o && o._handlePointerMove(n, t, i, r, null)
            }
        };
        n._updatePointerPosition = function(n, t, i, r) {
            var o = this._getElementRect(this.canvas),
                f, e, u, s, h;
            i -= o.left;
            r -= o.top;
            f = this.canvas.width;
            e = this.canvas.height;
            i /= (o.right - o.left) / f;
            r /= (o.bottom - o.top) / e;
            u = this._getPointerData(n);
            createjs.stageTransformable ? (this._mtx = this.getConcatenatedMatrix(this._mtx).invert(), (u.inBounds = i >= 0 && r >= 0 && i <= f - 1 && r <= e - 1) ? (u.x = i, u.y = r, s = this._mtx.transformPoint(u.x, u.y), u.x = s.x, u.y = s.y) : this.mouseMoveOutside && (u.x = i < 0 ? 0 : i > f - 1 ? f - 1 : i, u.y = r < 0 ? 0 : r > e - 1 ? e - 1 : r, s = this._mtx.transformPoint(u.x, u.y), u.x = s.x, u.y = s.y), u.rawX = i, u.rawY = r, h = this._mtx.transformPoint(u.rawX, u.rawY), u.rawX = h.x, u.rawY = h.y) : ((u.inBounds = i >= 0 && r >= 0 && i <= f - 1 && r <= e - 1) ? (u.x = i, u.y = r) : this.mouseMoveOutside && (u.x = i < 0 ? 0 : i > f - 1 ? f - 1 : i, u.y = r < 0 ? 0 : r > e - 1 ? e - 1 : r), u.rawX = i, u.rawY = r);
            u.posEvtObj = t;
            (n === this._primaryPointerID || n === -1) && (this.mouseX = u.x, this.mouseY = u.y, this.mouseInBounds = u.inBounds)
        };
        n._handleMouseUp = function(n) {
            this._handlePointerUp(-1, n, !1)
        };
        n._handlePointerUp = function(n, t, i, r) {
            var o = this._nextStage,
                u = this._getPointerData(n),
                f, e;
            this._prevStage && r === undefined || (f = null, e = u.target, !r && (e || o) && (f = this._getObjectsUnderPoint(u.x, u.y, null, !0)), u.down && (this._dispatchMouseEvent(this, "stagemouseup", !1, n, u, t, f), u.down = !1), f == e && this._dispatchMouseEvent(e, "click", !0, n, u, t), this._dispatchMouseEvent(e, "pressup", !0, n, u, t), i ? (n == this._primaryPointerID && (this._primaryPointerID = null), delete this._pointerData[n]) : u.target = null, o && o._handlePointerUp(n, t, i, r || f && this))
        };
        n._handleMouseDown = function(n) {
            this._handlePointerDown(-1, n, n.pageX, n.pageY)
        };
        n._handlePointerDown = function(n, t, i, r, u) {
            this.preventSelection && t.preventDefault();
            (this._primaryPointerID == null || n === -1) && (this._primaryPointerID = n);
            r != null && this._updatePointerPosition(n, t, i, r);
            var e = null,
                o = this._nextStage,
                f = this._getPointerData(n);
            u || (e = f.target = this._getObjectsUnderPoint(f.x, f.y, null, !0));
            f.inBounds && (this._dispatchMouseEvent(this, "stagemousedown", !1, n, f, t, e), f.down = !0);
            this._dispatchMouseEvent(e, "mousedown", !0, n, f, t);
            o && o._handlePointerDown(n, t, i, r, u || e && this)
        };
        n._testMouseOver = function(n, t, i) {
            var s, f;
            if (!this._prevStage || t !== undefined) {
                if (s = this._nextStage, !this._mouseOverIntervalID) {
                    s && s._testMouseOver(n, t, i);
                    return
                }
                if (f = this._getPointerData(-1), f && (n || this.mouseX != this._mouseOverX || this.mouseY != this._mouseOverY || !this.mouseInBounds)) {
                    var e = f.posEvtObj,
                        y = i || e && e.target == this.canvas,
                        u = null,
                        v = -1,
                        a = "",
                        o, r, p;
                    !t && (n || this.mouseInBounds && y) && (u = this._getObjectsUnderPoint(this.mouseX, this.mouseY, null, !0), this._mouseOverX = this.mouseX, this._mouseOverY = this.mouseY);
                    var h = this._mouseOverTarget || [],
                        c = h[h.length - 1],
                        l = this._mouseOverTarget = [];
                    for (o = u; o;) l.unshift(o), a || (a = o.cursor), o = o.parent;
                    for (this.canvas.style.cursor = a, !t && i && (i.canvas.style.cursor = a), r = 0, p = l.length; r < p; r++) {
                        if (l[r] != h[r]) break;
                        v = r
                    }
                    for (c != u && this._dispatchMouseEvent(c, "mouseout", !0, -1, f, e, u), r = h.length - 1; r > v; r--) this._dispatchMouseEvent(h[r], "rollout", !1, -1, f, e, u);
                    for (r = l.length - 1; r > v; r--) this._dispatchMouseEvent(l[r], "rollover", !1, -1, f, e, c);
                    c != u && this._dispatchMouseEvent(u, "mouseover", !0, -1, f, e, c);
                    s && s._testMouseOver(n, t || u && this, i || y && this)
                }
            }
        };
        n._handleDoubleClick = function(n, t) {
            var i = null,
                u = this._nextStage,
                r = this._getPointerData(-1);
            t || (i = this._getObjectsUnderPoint(r.x, r.y, null, !0), this._dispatchMouseEvent(i, "dblclick", !0, -1, r, n));
            u && u._handleDoubleClick(n, t || i && this)
        };
        n._dispatchMouseEvent = function(n, t, i, r, u, f, e) {
            if (n && (i || n.hasEventListener(t))) {
                var o = new createjs.MouseEvent(t, i, !1, u.x, u.y, f, r, r === this._primaryPointerID || r === -1, u.rawX, u.rawY, e);
                n.dispatchEvent(o)
            }
        };
        createjs.Stage = createjs.promote(t, "Container")
    }(),
    function() {
        "use strict";

        function n(t, i) {
            if (this.Stage_constructor(t), i !== undefined) {
                if (typeof i != "object") throw "Invalid options object";
                var r = i.premultiply,
                    u = i.transparent,
                    f = i.antialias,
                    e = i.preserveBuffer,
                    o = i.autoPurge
            }
            this.vocalDebug = !1;
            this._preserveBuffer = e || !1;
            this._antialias = f || !1;
            this._transparent = u || !1;
            this._premultiply = r || !1;
            this._autoPurge = undefined;
            this.autoPurge = o;
            this._viewportWidth = 0;
            this._viewportHeight = 0;
            this._projectionMatrix = null;
            this._webGLContext = null;
            this._clearColor = {
                r: .5,
                g: .5,
                b: .5,
                a: 0
            };
            this._maxCardsPerBatch = n.DEFAULT_MAX_BATCH_SIZE;
            this._activeShader = null;
            this._vertices = null;
            this._vertexPositionBuffer = null;
            this._uvs = null;
            this._uvPositionBuffer = null;
            this._indices = null;
            this._textureIndexBuffer = null;
            this._alphas = null;
            this._alphaBuffer = null;
            this._textureDictionary = [];
            this._textureIDs = {};
            this._batchTextures = [];
            this._baseTextures = [];
            this._batchTextureCount = 8;
            this._lastTextureInsert = -1;
            this._batchID = 0;
            this._drawID = 0;
            this._slotBlacklist = [];
            this._isDrawing = 0;
            this._lastTrackedCanvas = 0;
            this.isCacheControlled = !1;
            this._cacheContainer = new createjs.Container;
            this._initializeWebGL()
        }
        var t = createjs.extend(n, createjs.Stage);
        n.buildUVRects = function(n, t, i) {
            var e, o, f, r, u;
            if (!n || !n._frames) return null;
            for (t === undefined && (t = -1), i === undefined && (i = !1), e = t != -1 && i ? t : 0, o = t != -1 && i ? t + 1 : n._frames.length, f = e; f < o; f++)(r = n._frames[f], r.uvRect || r.image.width <= 0 || r.image.height <= 0) || (u = r.rect, r.uvRect = {
                t: u.y / r.image.height,
                l: u.x / r.image.width,
                b: (u.y + u.height) / r.image.height,
                r: (u.x + u.width) / r.image.width
            });
            return n._frames[t != -1 ? t : 0].uvRect || {
                t: 0,
                l: 0,
                b: 1,
                r: 1
            }
        };
        n.isWebGLActive = function(n) {
            return n && n instanceof WebGLRenderingContext && typeof WebGLRenderingContext != "undefined"
        };
        n.VERTEX_PROPERTY_COUNT = 6;
        n.INDICIES_PER_CARD = 6;
        n.DEFAULT_MAX_BATCH_SIZE = 1e4;
        n.WEBGL_MAX_INDEX_NUM = Math.pow(2, 16);
        n.UV_RECT = {
            t: 0,
            l: 0,
            b: 1,
            r: 1
        };
        try {
            n.COVER_VERT = new Float32Array([-1, 1, 1, 1, -1, -1, 1, 1, 1, -1, -1, -1]);
            n.COVER_UV = new Float32Array([0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1]);
            n.COVER_UV_FLIP = new Float32Array([0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0])
        } catch (i) {}
        n.REGULAR_VARYING_HEADER = "precision mediump float;varying vec2 vTextureCoord;varying lowp float indexPicker;varying lowp float alphaValue;";
        n.REGULAR_VERTEX_HEADER = n.REGULAR_VARYING_HEADER + "attribute vec2 vertexPosition;attribute vec2 uvPosition;attribute lowp float textureIndex;attribute lowp float objectAlpha;uniform mat4 pMatrix;";
        n.REGULAR_FRAGMENT_HEADER = n.REGULAR_VARYING_HEADER + "uniform sampler2D uSampler[{{count}}];";
        n.REGULAR_VERTEX_BODY = "void main(void) {gl_Position = vec4((vertexPosition.x * pMatrix[0][0]) + pMatrix[3][0],(vertexPosition.y * pMatrix[1][1]) + pMatrix[3][1],pMatrix[3][2],1.0);alphaValue = objectAlpha;indexPicker = textureIndex;vTextureCoord = uvPosition;}";
        n.REGULAR_FRAGMENT_BODY = "void main(void) {vec4 color = vec4(1.0, 0.0, 0.0, 1.0);if (indexPicker <= 0.5) {color = texture2D(uSampler[0], vTextureCoord);{{alternates}}}{{fragColor}}}";
        n.REGULAR_FRAG_COLOR_NORMAL = "gl_FragColor = vec4(color.rgb, color.a * alphaValue);";
        n.REGULAR_FRAG_COLOR_PREMULTIPLY = "if(color.a > 0.0035) {gl_FragColor = vec4(color.rgb/color.a, color.a * alphaValue);} else {gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);}";
        n.PARTICLE_VERTEX_BODY = n.REGULAR_VERTEX_BODY;
        n.PARTICLE_FRAGMENT_BODY = n.REGULAR_FRAGMENT_BODY;
        n.COVER_VARYING_HEADER = "precision mediump float;varying highp vec2 vRenderCoord;varying highp vec2 vTextureCoord;";
        n.COVER_VERTEX_HEADER = n.COVER_VARYING_HEADER + "attribute vec2 vertexPosition;attribute vec2 uvPosition;uniform float uUpright;";
        n.COVER_FRAGMENT_HEADER = n.COVER_VARYING_HEADER + "uniform sampler2D uSampler;";
        n.COVER_VERTEX_BODY = "void main(void) {gl_Position = vec4(vertexPosition.x, vertexPosition.y, 0.0, 1.0);vRenderCoord = uvPosition;vTextureCoord = vec2(uvPosition.x, abs(uUpright - uvPosition.y));}";
        n.COVER_FRAGMENT_BODY = "void main(void) {vec4 color = texture2D(uSampler, vRenderCoord);gl_FragColor = color;}";
        t._get_isWebGL = function() {
            return !!this._webGLContext
        };
        t._set_autoPurge = function(n) {
            n = isNaN(n) ? 1200 : n;
            n != -1 && (n = n < 10 ? 10 : n);
            this._autoPurge = n
        };
        t._get_autoPurge = function() {
            return Number(this._autoPurge)
        };
        try {
            Object.defineProperties(t, {
                isWebGL: {
                    get: t._get_isWebGL
                },
                autoPurge: {
                    get: t._get_autoPurge,
                    set: t._set_autoPurge
                }
            })
        } catch (i) {}
        t._initializeWebGL = function() {
            if (this.canvas) {
                if (!this._webGLContext || this._webGLContext.canvas !== this.canvas) {
                    var t = {
                            depth: !1,
                            alpha: this._transparent,
                            stencil: !0,
                            antialias: this._antialias,
                            premultipliedAlpha: this._premultiply,
                            preserveDrawingBuffer: this._preserveBuffer
                        },
                        n = this._webGLContext = this._fetchWebGLContext(this.canvas, t);
                    if (!n) return null;
                    this.updateSimultaneousTextureCount(n.getParameter(n.MAX_TEXTURE_IMAGE_UNITS));
                    this._maxTextureSlots = n.getParameter(n.MAX_COMBINED_TEXTURE_IMAGE_UNITS);
                    this._createBuffers(n);
                    this._initTextures(n);
                    n.disable(n.DEPTH_TEST);
                    n.enable(n.BLEND);
                    n.blendFuncSeparate(n.SRC_ALPHA, n.ONE_MINUS_SRC_ALPHA, n.ONE, n.ONE_MINUS_SRC_ALPHA);
                    n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL, this._premultiply);
                    this._webGLContext.clearColor(this._clearColor.r, this._clearColor.g, this._clearColor.b, this._clearColor.a);
                    this.updateViewport(this._viewportWidth || this.canvas.width, this._viewportHeight || this.canvas.height)
                }
            } else this._webGLContext = null;
            return this._webGLContext
        };
        t.update = function(n) {
            if (this.canvas) {
                if (this.tickOnUpdate && this.tick(n), this.dispatchEvent("drawstart"), this.autoClear && this.clear(), this._webGLContext) this._batchDraw(this, this._webGLContext), this._autoPurge == -1 || this._drawID % (this._autoPurge / 2 | 0) || this.purgeTextures(this._autoPurge);
                else {
                    var t = this.canvas.getContext("2d");
                    t.save();
                    this.updateContext(t);
                    this.draw(t, !1);
                    t.restore()
                }
                this.dispatchEvent("drawend")
            }
        };
        t.clear = function() {
            if (this.canvas)
                if (n.isWebGLActive(this._webGLContext)) {
                    var r = this._webGLContext,
                        t = this._clearColor,
                        i = this._transparent ? t.a : 1;
                    this._webGLContext.clearColor(t.r * i, t.g * i, t.b * i, i);
                    r.clear(r.COLOR_BUFFER_BIT);
                    this._webGLContext.clearColor(t.r, t.g, t.b, t.a)
                } else this.Stage_clear()
        };
        t.draw = function(t, i) {
            if (t === this._webGLContext && n.isWebGLActive(this._webGLContext)) {
                var r = this._webGLContext;
                return this._batchDraw(this, r, i), !0
            }
            return this.Stage_draw(t, i)
        };
        t.cacheDraw = function(t, i, r) {
            if (n.isWebGLActive(this._webGLContext)) {
                var u = this._webGLContext;
                return this._cacheDraw(u, t, i, r), !0
            }
            return !1
        };
        t.protectTextureSlot = function(n, t) {
            if (n > this._maxTextureSlots || n < 0) throw "Slot outside of acceptable range";
            this._slotBlacklist[n] = !!t
        };
        t.getTargetRenderTexture = function(n, t, i) {
            var r, u = !1,
                f = this._webGLContext;
            if (n.__lastRT !== undefined && n.__lastRT === n.__rtA && (u = !0), u ? (n.__rtB === undefined ? n.__rtB = this.getRenderBufferTexture(t, i) : ((t != n.__rtB._width || i != n.__rtB._height) && this.resizeTexture(n.__rtB, t, i), this.setTextureParams(f)), r = n.__rtB) : (n.__rtA === undefined ? n.__rtA = this.getRenderBufferTexture(t, i) : ((t != n.__rtA._width || i != n.__rtA._height) && this.resizeTexture(n.__rtA, t, i), this.setTextureParams(f)), r = n.__rtA), !r) throw "Problems creating render textures, known causes include using too much VRAM by not releasing WebGL texture instances";
            return n.__lastRT = r, r
        };
        t.releaseTexture = function(n) {
            var t, r, i;
            if (n) {
                if (n.children)
                    for (t = 0, r = n.children.length; t < r; t++) this.releaseTexture(n.children[t]);
                if (n.cacheCanvas && n.uncache(), i = undefined, n._storeID !== undefined) {
                    if (n === this._textureDictionary[n._storeID]) {
                        this._killTextureObject(n);
                        n._storeID = undefined;
                        return
                    }
                    i = n
                } else if (n._webGLRenderStyle === 2) i = n.image;
                else if (n._webGLRenderStyle === 1) {
                    for (t = 0, r = n.spriteSheet._images.length; t < r; t++) this.releaseTexture(n.spriteSheet._images[t]);
                    return
                }
                if (i === undefined) {
                    this.vocalDebug && console.log("No associated texture found on release");
                    return
                }
                this._killTextureObject(this._textureDictionary[i._storeID]);
                i._storeID = undefined
            }
        };
        t.purgeTextures = function(n) {
            var r, u, t, i;
            for (n == undefined && (n = 100), r = this._textureDictionary, u = r.length, t = 0; t < u; t++)(i = r[t], i) && i._drawID + n <= this._drawID && this._killTextureObject(i)
        };
        t.updateSimultaneousTextureCount = function(n) {
            var i = this._webGLContext,
                t = !1;
            for ((n < 1 || isNaN(n)) && (n = 1), this._batchTextureCount = n; !t;) try {
                this._activeShader = this._fetchShaderProgram(i);
                t = !0
            } catch (r) {
                if (this._batchTextureCount == 1) throw "Cannot compile shader " + r;
                this._batchTextureCount -= 4;
                this._batchTextureCount < 1 && (this._batchTextureCount = 1);
                this.vocalDebug && console.log("Reducing desired texture count due to errors: " + this._batchTextureCount)
            }
        };
        t.updateViewport = function(n, t) {
            this._viewportWidth = n | 0;
            this._viewportHeight = t | 0;
            var i = this._webGLContext;
            i && (i.viewport(0, 0, this._viewportWidth, this._viewportHeight), this._projectionMatrix = new Float32Array([2 / this._viewportWidth, 0, 0, 0, 0, -2 / this._viewportHeight, 1, 0, 0, 0, 1, 0, -1, 1, .1, 0]), this._projectionMatrixFlip = new Float32Array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]), this._projectionMatrixFlip.set(this._projectionMatrix), this._projectionMatrixFlip[5] *= -1, this._projectionMatrixFlip[13] *= -1)
        };
        t.getFilterShader = function(n) {
            n || (n = this);
            var i = this._webGLContext,
                t = this._activeShader;
            if (n._builtShader) t = n._builtShader, n.shaderParamSetup && (i.useProgram(t), n.shaderParamSetup(i, this, t));
            else try {
                t = this._fetchShaderProgram(i, "filter", n.VTX_SHADER_BODY, n.FRAG_SHADER_BODY, n.shaderParamSetup && n.shaderParamSetup.bind(n));
                n._builtShader = t;
                t._name = n.toString()
            } catch (r) {
                console && console.log("SHADER SWITCH FAILURE", r)
            }
            return t
        };
        t.getBaseTexture = function(n, t) {
            var u = Math.ceil(n > 0 ? n : 1) || 1,
                f = Math.ceil(t > 0 ? t : 1) || 1,
                i = this._webGLContext,
                r = i.createTexture();
            return this.resizeTexture(r, u, f), this.setTextureParams(i, !1), r
        };
        t.resizeTexture = function(n, t, i) {
            var r = this._webGLContext;
            r.bindTexture(r.TEXTURE_2D, n);
            r.texImage2D(r.TEXTURE_2D, 0, r.RGBA, t, i, 0, r.RGBA, r.UNSIGNED_BYTE, null);
            n.width = t;
            n.height = i
        };
        t.getRenderBufferTexture = function(n, t) {
            var r = this._webGLContext,
                i = this.getBaseTexture(n, t),
                u;
            return i ? (u = r.createFramebuffer(), !u) ? null : (i.width = n, i.height = t, r.bindFramebuffer(r.FRAMEBUFFER, u), r.framebufferTexture2D(r.FRAMEBUFFER, r.COLOR_ATTACHMENT0, r.TEXTURE_2D, i, 0), u._renderTexture = i, i._frameBuffer = u, i._storeID = this._textureDictionary.length, this._textureDictionary[i._storeID] = i, r.bindFramebuffer(r.FRAMEBUFFER, null), i) : null
        };
        t.setTextureParams = function(n, t) {
            t && this._antialias ? (n.texParameteri(n.TEXTURE_2D, n.TEXTURE_MIN_FILTER, n.LINEAR), n.texParameteri(n.TEXTURE_2D, n.TEXTURE_MAG_FILTER, n.LINEAR)) : (n.texParameteri(n.TEXTURE_2D, n.TEXTURE_MIN_FILTER, n.NEAREST), n.texParameteri(n.TEXTURE_2D, n.TEXTURE_MAG_FILTER, n.NEAREST));
            n.texParameteri(n.TEXTURE_2D, n.TEXTURE_WRAP_S, n.CLAMP_TO_EDGE);
            n.texParameteri(n.TEXTURE_2D, n.TEXTURE_WRAP_T, n.CLAMP_TO_EDGE)
        };
        t.setClearColor = function(n) {
            var i, r, u, f, t;
            (typeof n == "string" ? n.indexOf("#") == 0 ? (n.length == 4 && (n = "#" + n.charAt(1) + n.charAt(1) + n.charAt(2) + n.charAt(2) + n.charAt(3) + n.charAt(3)), i = Number("0x" + n.slice(1, 3)) / 255, r = Number("0x" + n.slice(3, 5)) / 255, u = Number("0x" + n.slice(5, 7)) / 255, f = Number("0x" + n.slice(7, 9)) / 255) : n.indexOf("rgba(") == 0 && (t = n.slice(5, -1).split(","), i = Number(t[0]) / 255, r = Number(t[1]) / 255, u = Number(t[2]) / 255, f = Number(t[3])) : (i = ((n & 4278190080) >>> 24) / 255, r = ((n & 16711680) >>> 16) / 255, u = ((n & 65280) >>> 8) / 255, f = (n & 255) / 255), this._clearColor.r = i || 0, this._clearColor.g = r || 0, this._clearColor.b = u || 0, this._clearColor.a = f || 0, this._webGLContext) && this._webGLContext.clearColor(this._clearColor.r, this._clearColor.g, this._clearColor.b, this._clearColor.a)
        };
        t.toString = function() {
            return "[StageGL (name=" + this.name + ")]"
        };
        t._fetchWebGLContext = function(n, t) {
            var i, r;
            try {
                i = n.getContext("webgl", t) || n.getContext("experimental-webgl", t)
            } catch (u) {}
            return i ? (i.viewportWidth = n.width, i.viewportHeight = n.height) : (r = "Could not initialize WebGL", console.error ? console.error(r) : console.log(r)), i
        };
        t._fetchShaderProgram = function(t, i, r, u, f) {
            var o, s, c, h;
            t.useProgram(null);
            switch (i) {
                case "filter":
                    s = n.COVER_VERTEX_HEADER + (r || n.COVER_VERTEX_BODY);
                    o = n.COVER_FRAGMENT_HEADER + (u || n.COVER_FRAGMENT_BODY);
                    break;
                case "particle":
                    s = n.REGULAR_VERTEX_HEADER + n.PARTICLE_VERTEX_BODY;
                    o = n.REGULAR_FRAGMENT_HEADER + n.PARTICLE_FRAGMENT_BODY;
                    break;
                case "override":
                    s = n.REGULAR_VERTEX_HEADER + (r || n.REGULAR_VERTEX_BODY);
                    o = n.REGULAR_FRAGMENT_HEADER + (u || n.REGULAR_FRAGMENT_BODY);
                    break;
                case "regular":
                default:
                    s = n.REGULAR_VERTEX_HEADER + n.REGULAR_VERTEX_BODY;
                    o = n.REGULAR_FRAGMENT_HEADER + n.REGULAR_FRAGMENT_BODY
            }
            var l = this._createShader(t, t.VERTEX_SHADER, s),
                a = this._createShader(t, t.FRAGMENT_SHADER, o),
                e = t.createProgram();
            if (t.attachShader(e, l), t.attachShader(e, a), t.linkProgram(e), e._type = i, !t.getProgramParameter(e, t.LINK_STATUS)) {
                t.useProgram(this._activeShader);
                throw t.getProgramInfoLog(e);
            }
            t.useProgram(e);
            switch (i) {
                case "filter":
                    e.vertexPositionAttribute = t.getAttribLocation(e, "vertexPosition");
                    t.enableVertexAttribArray(e.vertexPositionAttribute);
                    e.uvPositionAttribute = t.getAttribLocation(e, "uvPosition");
                    t.enableVertexAttribArray(e.uvPositionAttribute);
                    e.samplerUniform = t.getUniformLocation(e, "uSampler");
                    t.uniform1i(e.samplerUniform, 0);
                    e.uprightUniform = t.getUniformLocation(e, "uUpright");
                    t.uniform1f(e.uprightUniform, 0);
                    f && f(t, this, e);
                    break;
                case "override":
                case "particle":
                case "regular":
                default:
                    for (e.vertexPositionAttribute = t.getAttribLocation(e, "vertexPosition"), t.enableVertexAttribArray(e.vertexPositionAttribute), e.uvPositionAttribute = t.getAttribLocation(e, "uvPosition"), t.enableVertexAttribArray(e.uvPositionAttribute), e.textureIndexAttribute = t.getAttribLocation(e, "textureIndex"), t.enableVertexAttribArray(e.textureIndexAttribute), e.alphaAttribute = t.getAttribLocation(e, "objectAlpha"), t.enableVertexAttribArray(e.alphaAttribute), c = [], h = 0; h < this._batchTextureCount; h++) c[h] = h;
                    e.samplerData = c;
                    e.samplerUniform = t.getUniformLocation(e, "uSampler");
                    t.uniform1iv(e.samplerUniform, c);
                    e.pMatrixUniform = t.getUniformLocation(e, "pMatrix")
            }
            return t.useProgram(this._activeShader), e
        };
        t._createShader = function(t, i, r) {
            var e, f, u;
            for (r = r.replace(/{{count}}/g, this._batchTextureCount), e = "", f = 1; f < this._batchTextureCount; f++) e += "} else if (indexPicker <= " + f + ".5) { color = texture2D(uSampler[" + f + "], vTextureCoord);";
            if (r = r.replace(/{{alternates}}/g, e), r = r.replace(/{{fragColor}}/g, this._premultiply ? n.REGULAR_FRAG_COLOR_PREMULTIPLY : n.REGULAR_FRAG_COLOR_NORMAL), u = t.createShader(i), t.shaderSource(u, r), t.compileShader(u), !t.getShaderParameter(u, t.COMPILE_STATUS)) throw t.getShaderInfoLog(u);
            return u
        };
        t._createBuffers = function(t) {
            var u = this._maxCardsPerBatch * n.INDICIES_PER_CARD,
                r, i, f, v = this._vertexPositionBuffer = t.createBuffer(),
                e, s, o, h, c, l, a;
            for (t.bindBuffer(t.ARRAY_BUFFER, v), r = 2, e = this._vertices = new Float32Array(u * r), i = 0, f = e.length; i < f; i += r) e[i] = e[i + 1] = 0;
            for (t.bufferData(t.ARRAY_BUFFER, e, t.DYNAMIC_DRAW), v.itemSize = r, v.numItems = u, s = this._uvPositionBuffer = t.createBuffer(), t.bindBuffer(t.ARRAY_BUFFER, s), r = 2, o = this._uvs = new Float32Array(u * r), i = 0, f = o.length; i < f; i += r) o[i] = o[i + 1] = 0;
            for (t.bufferData(t.ARRAY_BUFFER, o, t.DYNAMIC_DRAW), s.itemSize = r, s.numItems = u, h = this._textureIndexBuffer = t.createBuffer(), t.bindBuffer(t.ARRAY_BUFFER, h), r = 1, c = this._indices = new Float32Array(u * r), i = 0, f = c.length; i < f; i++) c[i] = 0;
            for (t.bufferData(t.ARRAY_BUFFER, c, t.DYNAMIC_DRAW), h.itemSize = r, h.numItems = u, l = this._alphaBuffer = t.createBuffer(), t.bindBuffer(t.ARRAY_BUFFER, l), r = 1, a = this._alphas = new Float32Array(u * r), i = 0, f = a.length; i < f; i++) a[i] = 1;
            t.bufferData(t.ARRAY_BUFFER, a, t.DYNAMIC_DRAW);
            l.itemSize = r;
            l.numItems = u
        };
        t._initTextures = function() {
            var n, t;
            for (this._lastTextureInsert = -1, this._textureDictionary = [], this._textureIDs = {}, this._baseTextures = [], this._batchTextures = [], n = 0; n < this._batchTextureCount; n++)
                if (t = this.getBaseTexture(), this._baseTextures[n] = this._batchTextures[n] = t, !t) throw "Problems creating basic textures, known causes include using too much VRAM by not releasing WebGL texture instances";
        };
        t._loadTextureImage = function(n, t) {
            var u = t.src,
                r, i, f;
            return u || (t._isCanvas = !0, u = t.src = "canvas_" + this._lastTrackedCanvas++), r = this._textureIDs[u], r === undefined && (r = this._textureIDs[u] = this._textureDictionary.length), this._textureDictionary[r] === undefined && (this._textureDictionary[r] = this.getBaseTexture()), i = this._textureDictionary[r], i ? (i._batchID = this._batchID, i._storeID = r, i._imageData = t, this._insertTextureInBatch(n, i), t._storeID = r, t.complete || t.naturalWidth || t._isCanvas ? this._updateTextureImageData(n, t) : t.addEventListener("load", this._updateTextureImageData.bind(this, n, t))) : (f = "Problem creating desired texture, known causes include using too much VRAM by not releasing WebGL texture instances", console.error && console.error(f) || console.log(f), i = this._baseTextures[0], i._batchID = this._batchID, i._storeID = -1, i._imageData = i, this._insertTextureInBatch(n, i)), i
        };
        t._updateTextureImageData = function(n, t) {
            var u = t.width & t.width - 1 || t.height & t.height - 1,
                i = this._textureDictionary[t._storeID],
                r;
            n.activeTexture(n.TEXTURE0 + i._activeIndex);
            n.bindTexture(n.TEXTURE_2D, i);
            i.isPOT = !u;
            this.setTextureParams(n, i.isPOT);
            try {
                n.texImage2D(n.TEXTURE_2D, 0, n.RGBA, n.RGBA, n.UNSIGNED_BYTE, t)
            } catch (f) {
                r = "\nAn error has occurred. This is most likely due to security restrictions on WebGL images with local or cross-domain origins";
                console.error ? (console.error(r), console.error(f)) : console && (console.log(r), console.log(f))
            }
            t._invalid = !1;
            i._w = t.width;
            i._h = t.height;
            this.vocalDebug && (u && console.warn("NPOT(Non Power of Two) Texture: " + t.src), (t.width > n.MAX_TEXTURE_SIZE || t.height > n.MAX_TEXTURE_SIZE) && console && console.error("Oversized Texture: " + t.width + "x" + t.height + " vs " + n.MAX_TEXTURE_SIZE + "max"))
        };
        t._insertTextureInBatch = function(n, t) {
            var i;
            if (this._batchTextures[t._activeIndex] !== t) {
                var r = -1,
                    f = (this._lastTextureInsert + 1) % this._batchTextureCount,
                    u = f;
                do {
                    if (this._batchTextures[u]._batchID != this._batchID && !this._slotBlacklist[u]) {
                        r = u;
                        break
                    }
                    u = (u + 1) % this._batchTextureCount
                } while (u !== f);
                r === -1 && (this.batchReason = "textureOverflow", this._drawBuffers(n), this.batchCardCount = 0, r = f);
                this._batchTextures[r] = t;
                t._activeIndex = r;
                i = t._imageData;
                i && i._invalid && t._drawID !== undefined ? this._updateTextureImageData(n, i) : (n.activeTexture(n.TEXTURE0 + r), n.bindTexture(n.TEXTURE_2D, t), this.setTextureParams(n));
                this._lastTextureInsert = r
            } else i = t._imageData, t._storeID != undefined && i && i._invalid && this._updateTextureImageData(n, i);
            t._drawID = this._drawID;
            t._batchID = this._batchID
        };
        t._killTextureObject = function(n) {
            var t, i;
            if (n) {
                if (t = this._webGLContext, n._storeID !== undefined && n._storeID >= 0) {
                    this._textureDictionary[n._storeID] = undefined;
                    for (i in this._textureIDs) this._textureIDs[i] == n._storeID && delete this._textureIDs[i];
                    n._imageData && (n._imageData._storeID = undefined);
                    n._imageData = n._storeID = undefined
                }
                n._activeIndex !== undefined && this._batchTextures[n._activeIndex] === n && (this._batchTextures[n._activeIndex] = this._baseTextures[n._activeIndex]);
                try {
                    n._frameBuffer && t.deleteFramebuffer(n._frameBuffer);
                    n._frameBuffer = undefined
                } catch (r) {
                    this.vocalDebug && console.log(r)
                }
                try {
                    t.deleteTexture(n)
                } catch (r) {
                    this.vocalDebug && console.log(r)
                }
            }
        };
        t._backupBatchTextures = function(n, t) {
            var r = this._webGLContext,
                i;
            for (this._backupTextures || (this._backupTextures = []), t === undefined && (t = this._backupTextures), i = 0; i < this._batchTextureCount; i++) r.activeTexture(r.TEXTURE0 + i), n ? this._batchTextures[i] = t[i] : (t[i] = this._batchTextures[i], this._batchTextures[i] = this._baseTextures[i]), r.bindTexture(r.TEXTURE_2D, this._batchTextures[i]), this.setTextureParams(r, this._batchTextures[i].isPOT);
            n && t === this._backupTextures && (this._backupTextures = [])
        };
        t._batchDraw = function(n, t, i) {
            this._isDrawing > 0 && this._drawBuffers(t);
            this._isDrawing++;
            this._drawID++;
            this.batchCardCount = 0;
            this.depth = 0;
            this._appendToBatchGroup(n, t, new createjs.Matrix2D, this.alpha, i);
            this.batchReason = "drawFinish";
            this._drawBuffers(t);
            this._isDrawing--
        };
        t._cacheDraw = function(n, t, i, r) {
            var o, s = this._activeShader,
                h = this._slotBlacklist,
                e = this._maxTextureSlots - 1,
                c = this._viewportWidth,
                l = this._viewportHeight,
                u, f;
            this.protectTextureSlot(e, !0);
            u = t.getMatrix();
            u = u.clone();
            u.scale(1 / r.scale, 1 / r.scale);
            u = u.invert();
            u.translate(-r.offX / r.scale * t.scaleX, -r.offY / r.scale * t.scaleY);
            f = this._cacheContainer;
            f.children = [t];
            f.transformMatrix = u;
            this._backupBatchTextures(!1);
            i && i.length ? this._drawFilters(t, i, r) : this.isCacheControlled ? (n.clear(n.COLOR_BUFFER_BIT), this._batchDraw(f, n, !0)) : (n.activeTexture(n.TEXTURE0 + e), t.cacheCanvas = this.getTargetRenderTexture(t, r._drawWidth, r._drawHeight), o = t.cacheCanvas, n.bindFramebuffer(n.FRAMEBUFFER, o._frameBuffer), this.updateViewport(r._drawWidth, r._drawHeight), this._projectionMatrix = this._projectionMatrixFlip, n.clear(n.COLOR_BUFFER_BIT), this._batchDraw(f, n, !0), n.bindFramebuffer(n.FRAMEBUFFER, null), this.updateViewport(c, l));
            this._backupBatchTextures(!0);
            this.protectTextureSlot(e, !1);
            this._activeShader = s;
            this._slotBlacklist = h
        };
        t._drawFilters = function(n, t, i) {
            var r = this._webGLContext,
                u, o = this._maxTextureSlots - 1,
                s = this._viewportWidth,
                h = this._viewportHeight,
                l = this._cacheContainer,
                a = t.length;
            r.activeTexture(r.TEXTURE0 + o);
            u = this.getTargetRenderTexture(n, i._drawWidth, i._drawHeight);
            r.bindFramebuffer(r.FRAMEBUFFER, u._frameBuffer);
            this.updateViewport(i._drawWidth, i._drawHeight);
            r.clear(r.COLOR_BUFFER_BIT);
            this._batchDraw(l, r, !0);
            r.activeTexture(r.TEXTURE0);
            r.bindTexture(r.TEXTURE_2D, u);
            this.setTextureParams(r);
            var f = !1,
                c = 0,
                e = t[c];
            do(this._activeShader = this.getFilterShader(e), this._activeShader) && (r.activeTexture(r.TEXTURE0 + o), u = this.getTargetRenderTexture(n, i._drawWidth, i._drawHeight), r.bindFramebuffer(r.FRAMEBUFFER, u._frameBuffer), r.viewport(0, 0, i._drawWidth, i._drawHeight), r.clear(r.COLOR_BUFFER_BIT), this._drawCover(r, f), r.activeTexture(r.TEXTURE0), r.bindTexture(r.TEXTURE_2D, u), this.setTextureParams(r), (a > 1 || t[0]._multiPass) && (f = !f), e = e._multiPass !== null ? e._multiPass : t[++c]); while (e);
            this.isCacheControlled ? (r.bindFramebuffer(r.FRAMEBUFFER, null), this.updateViewport(s, h), this._activeShader = this.getFilterShader(this), r.clear(r.COLOR_BUFFER_BIT), this._drawCover(r, f)) : (f && (r.activeTexture(r.TEXTURE0 + o), u = this.getTargetRenderTexture(n, i._drawWidth, i._drawHeight), r.bindFramebuffer(r.FRAMEBUFFER, u._frameBuffer), this._activeShader = this.getFilterShader(this), r.viewport(0, 0, i._drawWidth, i._drawHeight), r.clear(r.COLOR_BUFFER_BIT), this._drawCover(r, !f)), r.bindFramebuffer(r.FRAMEBUFFER, null), this.updateViewport(s, h), n.cacheCanvas = u)
        };
        t._appendToBatchGroup = function(t, i, r, u, f) {
            var nt, p, w, k, d, et, ut, e, s, h, ot, v, b, g, c, rt, ft, a, o;
            for (t._glMtx || (t._glMtx = new createjs.Matrix2D), nt = t._glMtx, nt.copy(r), t.transformMatrix ? nt.appendMatrix(t.transformMatrix) : nt.appendTransform(t.x, t.y, t.scaleX, t.scaleY, t.rotation, t.skewX, t.skewY, t.regX, t.regY), et = t.children.length, ut = 0; ut < et; ut++)
                if (e = t.children[ut], e.visible && u) {
                    if ((!e.cacheCanvas || f) && (e._updateState && e._updateState(), e.children)) {
                        this._appendToBatchGroup(e, i, nt, e.alpha * u);
                        continue
                    }
                    if (this.batchCardCount + 1 > this._maxCardsPerBatch && (this.batchReason = "vertexOverflow", this._drawBuffers(i), this.batchCardCount = 0), e._glMtx || (e._glMtx = new createjs.Matrix2D), s = e._glMtx, s.copy(nt), e.transformMatrix ? s.appendMatrix(e.transformMatrix) : s.appendTransform(e.x, e.y, e.scaleX, e.scaleY, e.rotation, e.skewX, e.skewY, e.regX, e.regY), rt = e.cacheCanvas && !f, e._webGLRenderStyle === 2 || rt) v = (f ? !1 : e.cacheCanvas) || e.image;
                    else if (e._webGLRenderStyle === 1) {
                        if (b = e.spriteSheet.getFrame(e.currentFrame), b === null) continue;
                        v = b.image
                    } else continue;
                    var y = this._uvs,
                        l = this._vertices,
                        tt = this._indices,
                        it = this._alphas;
                    if (v) {
                        if (v._storeID === undefined) g = this._loadTextureImage(i, v), this._insertTextureInBatch(i, g);
                        else {
                            if (g = this._textureDictionary[v._storeID], !g) {
                                this.vocalDebug && console.log("Texture should not be looked up while not being stored.");
                                continue
                            }
                            g._batchID !== this._batchID && this._insertTextureInBatch(i, g)
                        }
                        ot = g._activeIndex;
                        e._webGLRenderStyle === 2 || rt ? !rt && e.sourceRect ? (e._uvRect || (e._uvRect = {}), c = e.sourceRect, h = e._uvRect, h.t = c.y / v.height, h.l = c.x / v.width, h.b = (c.y + c.height) / v.height, h.r = (c.x + c.width) / v.width, p = 0, w = 0, k = c.width + p, d = c.height + w) : (h = n.UV_RECT, rt ? (c = e.bitmapCache, p = c.x + c._filterOffX / c.scale, w = c.y + c._filterOffY / c.scale, k = c._drawWidth / c.scale + p, d = c._drawHeight / c.scale + w) : (p = 0, w = 0, k = v.width + p, d = v.height + w)) : e._webGLRenderStyle === 1 && (ft = b.rect, h = b.uvRect, h || (h = n.buildUVRects(e.spriteSheet, e.currentFrame, !1)), p = -b.regX, w = -b.regY, k = ft.width - b.regX, d = ft.height - b.regY);
                        a = this.batchCardCount * n.INDICIES_PER_CARD;
                        o = a * 2;
                        l[o] = p * s.a + w * s.c + s.tx;
                        l[o + 1] = p * s.b + w * s.d + s.ty;
                        l[o + 2] = p * s.a + d * s.c + s.tx;
                        l[o + 3] = p * s.b + d * s.d + s.ty;
                        l[o + 4] = k * s.a + w * s.c + s.tx;
                        l[o + 5] = k * s.b + w * s.d + s.ty;
                        l[o + 6] = l[o + 2];
                        l[o + 7] = l[o + 3];
                        l[o + 8] = l[o + 4];
                        l[o + 9] = l[o + 5];
                        l[o + 10] = k * s.a + d * s.c + s.tx;
                        l[o + 11] = k * s.b + d * s.d + s.ty;
                        y[o] = h.l;
                        y[o + 1] = h.t;
                        y[o + 2] = h.l;
                        y[o + 3] = h.b;
                        y[o + 4] = h.r;
                        y[o + 5] = h.t;
                        y[o + 6] = h.l;
                        y[o + 7] = h.b;
                        y[o + 8] = h.r;
                        y[o + 9] = h.t;
                        y[o + 10] = h.r;
                        y[o + 11] = h.b;
                        tt[a] = tt[a + 1] = tt[a + 2] = tt[a + 3] = tt[a + 4] = tt[a + 5] = ot;
                        it[a] = it[a + 1] = it[a + 2] = it[a + 3] = it[a + 4] = it[a + 5] = e.alpha * u;
                        this.batchCardCount++
                    }
                }
        };
        t._drawBuffers = function(t) {
            var r, u;
            if (!(this.batchCardCount <= 0)) {
                this.vocalDebug && console.log("Draw[" + this._drawID + ":" + this._batchID + "] : " + this.batchReason);
                var i = this._activeShader,
                    f = this._vertexPositionBuffer,
                    e = this._textureIndexBuffer,
                    o = this._uvPositionBuffer,
                    s = this._alphaBuffer;
                for (t.useProgram(i), t.bindBuffer(t.ARRAY_BUFFER, f), t.vertexAttribPointer(i.vertexPositionAttribute, f.itemSize, t.FLOAT, !1, 0, 0), t.bufferSubData(t.ARRAY_BUFFER, 0, this._vertices), t.bindBuffer(t.ARRAY_BUFFER, e), t.vertexAttribPointer(i.textureIndexAttribute, e.itemSize, t.FLOAT, !1, 0, 0), t.bufferSubData(t.ARRAY_BUFFER, 0, this._indices), t.bindBuffer(t.ARRAY_BUFFER, o), t.vertexAttribPointer(i.uvPositionAttribute, o.itemSize, t.FLOAT, !1, 0, 0), t.bufferSubData(t.ARRAY_BUFFER, 0, this._uvs), t.bindBuffer(t.ARRAY_BUFFER, s), t.vertexAttribPointer(i.alphaAttribute, s.itemSize, t.FLOAT, !1, 0, 0), t.bufferSubData(t.ARRAY_BUFFER, 0, this._alphas), t.uniformMatrix4fv(i.pMatrixUniform, t.FALSE, this._projectionMatrix), r = 0; r < this._batchTextureCount; r++) u = this._batchTextures[r], t.activeTexture(t.TEXTURE0 + r), t.bindTexture(t.TEXTURE_2D, u), this.setTextureParams(t, u.isPOT);
                t.drawArrays(t.TRIANGLES, 0, this.batchCardCount * n.INDICIES_PER_CARD);
                this._batchID++
            }
        };
        t._drawCover = function(t, i) {
            this._isDrawing > 0 && this._drawBuffers(t);
            this.vocalDebug && console.log("Draw[" + this._drawID + ":" + this._batchID + "] : Cover");
            var r = this._activeShader,
                u = this._vertexPositionBuffer,
                f = this._uvPositionBuffer;
            t.clear(t.COLOR_BUFFER_BIT);
            t.useProgram(r);
            t.bindBuffer(t.ARRAY_BUFFER, u);
            t.vertexAttribPointer(r.vertexPositionAttribute, u.itemSize, t.FLOAT, !1, 0, 0);
            t.bufferSubData(t.ARRAY_BUFFER, 0, n.COVER_VERT);
            t.bindBuffer(t.ARRAY_BUFFER, f);
            t.vertexAttribPointer(r.uvPositionAttribute, f.itemSize, t.FLOAT, !1, 0, 0);
            t.bufferSubData(t.ARRAY_BUFFER, 0, i ? n.COVER_UV_FLIP : n.COVER_UV);
            t.uniform1i(r.samplerUniform, 0);
            t.uniform1f(r.uprightUniform, i ? 0 : 1);
            t.drawArrays(t.TRIANGLES, 0, n.INDICIES_PER_CARD)
        };
        createjs.StageGL = createjs.promote(n, "Stage")
    }(),
    function() {
        function t(n) {
            this.DisplayObject_constructor();
            typeof n == "string" ? (this.image = document.createElement("img"), this.image.src = n) : this.image = n;
            this.sourceRect = null;
            this._webGLRenderStyle = createjs.DisplayObject._StageGL_BITMAP
        }
        var n = createjs.extend(t, createjs.DisplayObject);
        n.initialize = t;
        n.isVisible = function() {
            var n = this.image,
                t = this.cacheCanvas || n && (n.naturalWidth || n.getContext || n.readyState >= 2);
            return !!(this.visible && this.alpha > 0 && this.scaleX != 0 && this.scaleY != 0 && t)
        };
        n.draw = function(n, t) {
            var i, f;
            if (this.DisplayObject_draw(n, t) || (i = this.image, f = this.sourceRect, i.getImage && (i = i.getImage()), !i)) return !0;
            if (f) {
                var r = f.x,
                    u = f.y,
                    e = r + f.width,
                    o = u + f.height,
                    s = 0,
                    h = 0,
                    c = i.width,
                    l = i.height;
                r < 0 && (s -= r, r = 0);
                e > c && (e = c);
                u < 0 && (h -= u, u = 0);
                o > l && (o = l);
                n.drawImage(i, r, u, e - r, o - u, s, h, e - r, o - u)
            } else n.drawImage(i, 0, 0);
            return !0
        };
        n.cache = function(n, t, i, r, u, f) {
            this.bitmapCache || (this.bitmapCache = new createjs.BitmapCache);
            this.bitmapCache.define(this, n, t, i, r, u, f)
        };
        n.updateCache = function(n) {
            if (!this.bitmapCache) throw "cache() must be called before updateCache()";
            this.bitmapCache.update(n)
        };
        n.uncache = function() {
            this.bitmapCache && (this.bitmapCache.release(), this.bitmapCache = undefined)
        };
        n.getCacheDataURL = function() {
            return this.bitmapCache ? this.bitmapCache.getDataURL() : null
        };
        n.getBounds = function() {
            var t = this.DisplayObject_getBounds();
            if (t) return t;
            var n = this.image,
                i = this.sourceRect || n,
                r = n && (n.naturalWidth || n.getContext || n.readyState >= 2);
            return r ? this._rectangle.setValues(0, 0, i.width, i.height) : null
        };
        n.clone = function(n) {
            var i = this.image,
                r;
            return i && n && (i = i.cloneNode()), r = new t(i), this.sourceRect && (r.sourceRect = this.sourceRect.clone()), this._cloneProps(r), r
        };
        n.toString = function() {
            return "[Bitmap (name=" + this.name + ")]"
        };
        createjs.Bitmap = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t(n, t) {
            this.DisplayObject_constructor();
            this.currentFrame = 0;
            this.currentAnimation = null;
            this.paused = !0;
            this.spriteSheet = n;
            this.currentAnimationFrame = 0;
            this.framerate = 0;
            this._animation = null;
            this._currentFrame = null;
            this._skipAdvance = !1;
            this._webGLRenderStyle = createjs.DisplayObject._StageGL_SPRITE;
            t != null && this.gotoAndPlay(t)
        }
        var n = createjs.extend(t, createjs.DisplayObject);
        n.initialize = t;
        n.isVisible = function() {
            var n = this.cacheCanvas || this.spriteSheet.complete;
            return !!(this.visible && this.alpha > 0 && this.scaleX != 0 && this.scaleY != 0 && n)
        };
        n.draw = function(n, t) {
            var r, i;
            return this.DisplayObject_draw(n, t) ? !0 : (this._normalizeFrame(), r = this.spriteSheet.getFrame(this._currentFrame | 0), !r) ? !1 : (i = r.rect, i.width && i.height && n.drawImage(r.image, i.x, i.y, i.width, i.height, -r.regX, -r.regY, i.width, i.height), !0)
        };
        n.play = function() {
            this.paused = !1
        };
        n.stop = function() {
            this.paused = !0
        };
        n.gotoAndPlay = function(n) {
            this.paused = !1;
            this._skipAdvance = !0;
            this._goto(n)
        };
        n.gotoAndStop = function(n) {
            this.paused = !0;
            this._goto(n)
        };
        n.advance = function(n) {
            var t = this.framerate || this.spriteSheet.framerate,
                i = t && n != null ? n / (1e3 / t) : 1;
            this._normalizeFrame(i)
        };
        n.getBounds = function() {
            return this.DisplayObject_getBounds() || this.spriteSheet.getFrameBounds(this.currentFrame, this._rectangle)
        };
        n.clone = function() {
            return this._cloneProps(new t(this.spriteSheet))
        };
        n.toString = function() {
            return "[Sprite (name=" + this.name + ")]"
        };
        n._cloneProps = function(n) {
            return this.DisplayObject__cloneProps(n), n.currentFrame = this.currentFrame, n.currentAnimation = this.currentAnimation, n.paused = this.paused, n.currentAnimationFrame = this.currentAnimationFrame, n.framerate = this.framerate, n._animation = this._animation, n._currentFrame = this._currentFrame, n._skipAdvance = this._skipAdvance, n
        };
        n._tick = function(n) {
            this.paused || (this._skipAdvance || this.advance(n && n.delta), this._skipAdvance = !1);
            this.DisplayObject__tick(n)
        };
        n._normalizeFrame = function(n) {
            var f, u, e;
            n = n || 0;
            var i = this._animation,
                o = this.paused,
                r = this._currentFrame,
                t;
            if (i) {
                if (f = i.speed || 1, u = this.currentAnimationFrame, t = i.frames.length, u + n * f >= t) {
                    if (e = i.next, this._dispatchAnimationEnd(i, r, o, e, t - 1)) return;
                    if (e) return this._goto(e, n - (t - u) / f);
                    this.paused = !0;
                    u = i.frames.length - 1
                } else u += n * f;
                this.currentAnimationFrame = u;
                this._currentFrame = i.frames[u | 0]
            } else if (r = this._currentFrame += n, t = this.spriteSheet.getNumFrames(), r >= t && t > 0 && !this._dispatchAnimationEnd(i, r, o, t - 1) && (this._currentFrame -= t) >= t) return this._normalizeFrame();
            r = this._currentFrame | 0;
            this.currentFrame != r && (this.currentFrame = r, this.dispatchEvent("change"))
        };
        n._dispatchAnimationEnd = function(n, t, i, r, u) {
            var o = n ? n.name : null,
                f, e;
            return this.hasEventListener("animationend") && (f = new createjs.Event("animationend"), f.name = o, f.next = r, this.dispatchEvent(f)), e = this._animation != n || this._currentFrame != t, e || i || !this.paused || (this.currentAnimationFrame = u, e = !0), e
        };
        n._goto = function(n, t) {
            if (this.currentAnimationFrame = 0, isNaN(n)) {
                var i = this.spriteSheet.getAnimation(n);
                i && (this._animation = i, this.currentAnimation = n, this._normalizeFrame(t))
            } else this.currentAnimation = this._animation = null, this._currentFrame = n, this._normalizeFrame()
        };
        createjs.Sprite = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.DisplayObject_constructor();
            this.graphics = n ? n : new createjs.Graphics
        }
        var n = createjs.extend(t, createjs.DisplayObject);
        n.isVisible = function() {
            var n = this.cacheCanvas || this.graphics && !this.graphics.isEmpty();
            return !!(this.visible && this.alpha > 0 && this.scaleX != 0 && this.scaleY != 0 && n)
        };
        n.draw = function(n, t) {
            return this.DisplayObject_draw(n, t) ? !0 : (this.graphics.draw(n, this), !0)
        };
        n.clone = function(n) {
            var i = n && this.graphics ? this.graphics.clone() : this.graphics;
            return this._cloneProps(new t(i))
        };
        n.toString = function() {
            return "[Shape (name=" + this.name + ")]"
        };
        createjs.Shape = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.DisplayObject_constructor();
            this.text = n;
            this.font = t;
            this.color = i;
            this.textAlign = "left";
            this.textBaseline = "top";
            this.maxWidth = null;
            this.outline = 0;
            this.lineHeight = 0;
            this.lineWidth = null
        }
        var n = createjs.extend(t, createjs.DisplayObject),
            i = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas");
        i.getContext && (t._workingContext = i.getContext("2d"), i.width = i.height = 1);
        t.H_OFFSETS = {
            start: 0,
            left: 0,
            center: -.5,
            end: -1,
            right: -1
        };
        t.V_OFFSETS = {
            top: 0,
            hanging: -.01,
            middle: -.4,
            alphabetic: -.8,
            ideographic: -.85,
            bottom: -1
        };
        n.isVisible = function() {
            var n = this.cacheCanvas || this.text != null && this.text !== "";
            return !!(this.visible && this.alpha > 0 && this.scaleX != 0 && this.scaleY != 0 && n)
        };
        n.draw = function(n, t) {
            if (this.DisplayObject_draw(n, t)) return !0;
            var i = this.color || "#000";
            return this.outline ? (n.strokeStyle = i, n.lineWidth = this.outline * 1) : n.fillStyle = i, this._drawText(this._prepContext(n)), !0
        };
        n.getMeasuredWidth = function() {
            return this._getMeasuredWidth(this.text)
        };
        n.getMeasuredLineHeight = function() {
            return this._getMeasuredWidth("M") * 1.2
        };
        n.getMeasuredHeight = function() {
            return this._drawText(null, {}).height
        };
        n.getBounds = function() {
            var i = this.DisplayObject_getBounds();
            if (i) return i;
            if (this.text == null || this.text === "") return null;
            var n = this._drawText(null, {}),
                r = this.maxWidth && this.maxWidth < n.width ? this.maxWidth : n.width,
                u = r * t.H_OFFSETS[this.textAlign || "left"],
                f = this.lineHeight || this.getMeasuredLineHeight(),
                e = f * t.V_OFFSETS[this.textBaseline || "top"];
            return this._rectangle.setValues(u, e, r, n.height)
        };
        n.getMetrics = function() {
            var n = {
                lines: []
            };
            return n.lineHeight = this.lineHeight || this.getMeasuredLineHeight(), n.vOffset = n.lineHeight * t.V_OFFSETS[this.textBaseline || "top"], this._drawText(null, n, n.lines)
        };
        n.clone = function() {
            return this._cloneProps(new t(this.text, this.font, this.color))
        };
        n.toString = function() {
            return "[Text (text=" + (this.text.length > 20 ? this.text.substr(0, 17) + "..." : this.text) + ")]"
        };
        n._cloneProps = function(n) {
            return this.DisplayObject__cloneProps(n), n.textAlign = this.textAlign, n.textBaseline = this.textBaseline, n.maxWidth = this.maxWidth, n.outline = this.outline, n.lineHeight = this.lineHeight, n.lineWidth = this.lineWidth, n
        };
        n._prepContext = function(n) {
            return n.font = this.font || "10px sans-serif", n.textAlign = this.textAlign || "left", n.textBaseline = this.textBaseline || "top", n.lineJoin = "miter", n.miterLimit = 2.5, n
        };
        n._drawText = function(n, i, r) {
            var c = !!n,
                l, p, u, f, e, o, w, v;
            c || (n = t._workingContext, n.save(), this._prepContext(n));
            var a = this.lineHeight || this.getMeasuredLineHeight(),
                s = 0,
                h = 0,
                y = String(this.text).split(/(?:\r\n|\r|\n)/);
            for (l = 0, p = y.length; l < p; l++) {
                if (u = y[l], f = null, this.lineWidth != null && (f = n.measureText(u).width) > this.lineWidth)
                    for (e = u.split(/(\s)/), u = e[0], f = n.measureText(u).width, o = 1, w = e.length; o < w; o += 2) v = n.measureText(e[o] + e[o + 1]).width, f + v > this.lineWidth ? (c && this._drawTextLine(n, u, h * a), r && r.push(u), f > s && (s = f), u = e[o + 1], f = n.measureText(u).width, h++) : (u += e[o] + e[o + 1], f += v);
                c && this._drawTextLine(n, u, h * a);
                r && r.push(u);
                i && f == null && (f = n.measureText(u).width);
                f > s && (s = f);
                h++
            }
            return i && (i.width = s, i.height = h * a), c || n.restore(), i
        };
        n._drawTextLine = function(n, t, i) {
            this.outline ? n.strokeText(t, 0, i, this.maxWidth || 65535) : n.fillText(t, 0, i, this.maxWidth || 65535)
        };
        n._getMeasuredWidth = function(n) {
            var i = t._workingContext,
                r;
            return i.save(), r = this._prepContext(i).measureText(n).width, i.restore(), r
        };
        createjs.Text = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t(n, t) {
            this.Container_constructor();
            this.text = n || "";
            this.spriteSheet = t;
            this.lineHeight = 0;
            this.letterSpacing = 0;
            this.spaceWidth = 0;
            this._oldProps = {
                text: 0,
                spriteSheet: 0,
                lineHeight: 0,
                letterSpacing: 0,
                spaceWidth: 0
            };
            this._oldStage = null;
            this._drawAction = null
        }
        var n = createjs.extend(t, createjs.Container);
        t.maxPoolSize = 100;
        t._spritePool = [];
        n.draw = function(n, t) {
            this.DisplayObject_draw(n, t) || (this._updateState(), this.Container_draw(n, t))
        };
        n.getBounds = function() {
            return this._updateText(), this.Container_getBounds()
        };
        n.isVisible = function() {
            var n = this.cacheCanvas || this.spriteSheet && this.spriteSheet.complete && this.text;
            return !!(this.visible && this.alpha > 0 && this.scaleX !== 0 && this.scaleY !== 0 && n)
        };
        n.clone = function() {
            return this._cloneProps(new t(this.text, this.spriteSheet))
        };
        n.addChild = n.addChildAt = n.removeChild = n.removeChildAt = n.removeAllChildren = function() {};
        n._updateState = function() {
            this._updateText()
        };
        n._cloneProps = function(n) {
            return this.Container__cloneProps(n), n.lineHeight = this.lineHeight, n.letterSpacing = this.letterSpacing, n.spaceWidth = this.spaceWidth, n
        };
        n._getFrameIndex = function(n, t) {
            var i, r = t.getAnimation(n);
            return r || (n != (i = n.toUpperCase()) || n != (i = n.toLowerCase()) || (i = null), i && (r = t.getAnimation(i))), r && r.frames[0]
        };
        n._getFrame = function(n, t) {
            var i = this._getFrameIndex(n, t);
            return i == null ? i : t.getFrame(i)
        };
        n._getLineHeight = function(n) {
            var t = this._getFrame("1", n) || this._getFrame("T", n) || this._getFrame("L", n) || n.getFrame(0);
            return t ? t.rect.height : 1
        };
        n._getSpaceWidth = function(n) {
            var t = this._getFrame("1", n) || this._getFrame("l", n) || this._getFrame("e", n) || this._getFrame("a", n) || n.getFrame(0);
            return t ? t.rect.width : 1
        };
        n._updateText = function() {
            var o = 0,
                w = 0,
                l = this._oldProps,
                b = !1,
                a = this.spaceWidth,
                v = this.lineHeight,
                u = this.spriteSheet,
                f = t._spritePool,
                s = this.children,
                h = 0,
                c = s.length,
                n, e, y, i, k, r, p;
            for (e in l) l[e] != this[e] && (l[e] = this[e], b = !0);
            if (b) {
                for (y = !!this._getFrame(" ", u), y || a || (a = this._getSpaceWidth(u)), v || (v = this._getLineHeight(u)), i = 0, k = this.text.length; i < k; i++) {
                    if (r = this.text.charAt(i), r != " " || y) {
                        if (r == "\n" || r == "\r") {
                            r == "\r" && this.text.charAt(i + 1) == "\n" && i++;
                            o = 0;
                            w += v;
                            continue
                        }
                    } else {
                        o += a;
                        continue
                    }(p = this._getFrameIndex(r, u), p != null) && (h < c ? n = s[h] : (s.push(n = f.length ? f.pop() : new createjs.Sprite), n.parent = this, c++), n.spriteSheet = u, n.gotoAndStop(p), n.x = o, n.y = w, h++, o += n.getBounds().width + this.letterSpacing)
                }
                while (c > h) f.push(n = s.pop()), n.parent = null, c--;
                f.length > t.maxPoolSize && (f.length = t.maxPoolSize)
            }
        };
        createjs.BitmapText = createjs.promote(t, "Container")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.Container_constructor();
            t.inited || t.init();
            var r, u, i, f;
            n instanceof String || arguments.length > 1 ? (r = n, u = arguments[1], i = arguments[2], f = arguments[3], i == null && (i = -1), n = null) : n && (r = n.mode, u = n.startPosition, i = n.loop, f = n.labels);
            n || (n = {
                labels: f
            });
            this.mode = r || t.INDEPENDENT;
            this.startPosition = u || 0;
            this.loop = i === !0 ? -1 : i || 0;
            this.currentFrame = 0;
            this.paused = n.paused || !1;
            this.actionsEnabled = !0;
            this.autoReset = !0;
            this.frameBounds = this.frameBounds || n.frameBounds;
            this.framerate = null;
            n.useTicks = n.paused = !0;
            this.timeline = new createjs.Timeline(n);
            this._synchOffset = 0;
            this._rawPosition = -1;
            this._bound_resolveState = this._resolveState.bind(this);
            this._t = 0;
            this._managed = {}
        }

        function i() {
            throw "MovieClipPlugin cannot be instantiated.";
        }
        var n = createjs.extend(t, createjs.Container);
        t.INDEPENDENT = "independent";
        t.SINGLE_FRAME = "single";
        t.SYNCHED = "synched";
        t.inited = !1;
        t.init = function() {
            t.inited || (i.install(), t.inited = !0)
        };
        n._getLabels = function() {
            return this.timeline.getLabels()
        };
        n.getLabels = createjs.deprecate(n._getLabels, "MovieClip.getLabels");
        n._getCurrentLabel = function() {
            return this.timeline.currentLabel
        };
        n.getCurrentLabel = createjs.deprecate(n._getCurrentLabel, "MovieClip.getCurrentLabel");
        n._getDuration = function() {
            return this.timeline.duration
        };
        n.getDuration = createjs.deprecate(n._getDuration, "MovieClip.getDuration");
        try {
            Object.defineProperties(n, {
                labels: {
                    get: n._getLabels
                },
                currentLabel: {
                    get: n._getCurrentLabel
                },
                totalFrames: {
                    get: n._getDuration
                },
                duration: {
                    get: n._getDuration
                }
            })
        } catch (r) {}
        n.initialize = t;
        n.isVisible = function() {
            return !!(this.visible && this.alpha > 0 && this.scaleX != 0 && this.scaleY != 0)
        };
        n.draw = function(n, t) {
            return this.DisplayObject_draw(n, t) ? !0 : (this._updateState(), this.Container_draw(n, t), !0)
        };
        n.play = function() {
            this.paused = !1
        };
        n.stop = function() {
            this.paused = !0
        };
        n.gotoAndPlay = function(n) {
            this.paused = !1;
            this._goto(n)
        };
        n.gotoAndStop = function(n) {
            this.paused = !0;
            this._goto(n)
        };
        n.advance = function(n) {
            var e = t.INDEPENDENT,
                r, i, u, f;
            if (this.mode === e) {
                for (r = this, i = r.framerate;
                    (r = r.parent) && i === null;) r.mode === e && (i = r._framerate);
                if (this._framerate = i, !(this.totalFrames <= 1))
                    for (u = i !== null && i !== -1 && n !== null ? n / (1e3 / i) + this._t : 1, f = u | 0, this._t = u - f; !this.paused && f--;) this._updateTimeline(this._rawPosition + 1, !1)
            }
        };
        n.clone = function() {
            throw "MovieClip cannot be cloned.";
        };
        n.toString = function() {
            return "[MovieClip (name=" + this.name + ")]"
        };
        n._updateState = function() {
            (this._rawPosition === -1 || this.mode !== t.INDEPENDENT) && this._updateTimeline(-1)
        };
        n._tick = function(n) {
            this.advance(n && n.delta);
            this.Container__tick(n)
        };
        n._goto = function(n) {
            var t = this.timeline.resolve(n);
            t != null && (this._t = 0, this._updateTimeline(t, !0))
        };
        n._reset = function() {
            this._rawPosition = -1;
            this._t = this.currentFrame = 0;
            this.paused = !1
        };
        n._updateTimeline = function(n, i) {
            var r = this.mode !== t.INDEPENDENT,
                u = this.timeline;
            (r && (n = this.startPosition + (this.mode === t.SINGLE_FRAME ? 0 : this._synchOffset)), n < 0 && (n = 0), this._rawPosition !== n || r) && (this._rawPosition = n, u.loop = this.loop, u.setPosition(n, r || !this.actionsEnabled, i, this._bound_resolveState))
        };
        n._renderFirstFrame = function() {
            var n = this.timeline,
                t = n.rawPosition;
            n.setPosition(0, !0, !0, this._bound_resolveState);
            n.rawPosition = t
        };
        n._resolveState = function() {
            var o = this.timeline,
                s, r, n, h, i, t, u, f, e;
            this.currentFrame = o.position;
            for (s in this._managed) this._managed[s] = 1;
            for (r = o.tweens, n = 0, h = r.length; n < h; n++)(i = r[n], t = i.target, t === this || i.passive) || (u = i._stepPosition, t instanceof createjs.DisplayObject ? this._addManagedChild(t, u) : this._setState(t.state, u));
            for (f = this.children, n = f.length - 1; n >= 0; n--) e = f[n].id, this._managed[e] === 1 && (this.removeChildAt(n), delete this._managed[e])
        };
        n._setState = function(n, t) {
            var i, r;
            if (n)
                for (i = n.length - 1; i >= 0; i--) {
                    var u = n[i],
                        f = u.t,
                        e = u.p;
                    for (r in e) f[r] = e[r];
                    this._addManagedChild(f, t)
                }
        };
        n._addManagedChild = function(n, i) {
            n._off || (this.addChildAt(n, 0), n instanceof t && (n._synchOffset = i, n.mode === t.INDEPENDENT && n.autoReset && !this._managed[n.id] && n._reset()), this._managed[n.id] = 2)
        };
        n._getBounds = function(n, t) {
            var i = this.DisplayObject_getBounds();
            return (i || this.frameBounds && (i = this._rectangle.copy(this.frameBounds[this.currentFrame])), i) ? this._transformBounds(i, n, t) : this.Container__getBounds(n, t)
        };
        createjs.MovieClip = createjs.promote(t, "Container");
        i.priority = 100;
        i.ID = "MovieClip";
        i.install = function() {
            createjs.Tween._installPlugin(i)
        };
        i.init = function(n, r) {
            r === "startPosition" && n.target instanceof t && n._addPlugin(i)
        };
        i.step = function() {};
        i.change = function(n, t, i, r, u) {
            if (i === "startPosition") return u === 1 ? t.props[i] : t.prev.props[i]
        }
    }(),
    function() {
        "use strict";

        function n() {
            throw "SpriteSheetUtils cannot be instantiated";
        }
        var t = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas");
        t.getContext && (n._workingCanvas = t, n._workingContext = t.getContext("2d"), t.width = t.height = 1);
        n.extractFrame = function(t, i) {
            var u, r, f, e;
            return (isNaN(i) && (i = t.getAnimation(i).frames[0]), u = t.getFrame(i), !u) ? null : (r = u.rect, f = n._workingCanvas, f.width = r.width, f.height = r.height, n._workingContext.drawImage(u.image, r.x, r.y, r.width, r.height, 0, 0, r.width, r.height), e = document.createElement("img"), e.src = f.toDataURL("image/png"), e)
        };
        n.addFlippedFrames = createjs.deprecate(null, "SpriteSheetUtils.addFlippedFrames");
        n.mergeAlpha = createjs.deprecate(null, "SpriteSheetUtils.mergeAlpha");
        n._flip = function(t, i, r, u) {
            for (var f, o, h, w, s, y, k, c, p, tt, a = t._images, l = n._workingCanvas, v = n._workingContext, d = a.length / i, e = 0; e < d; e++) f = a[e], f.__tmp = e, v.setTransform(1, 0, 0, 1, 0, 0), v.clearRect(0, 0, l.width + 1, l.height + 1), l.width = f.width, l.height = f.height, v.setTransform(r ? -1 : 1, 0, 0, u ? -1 : 1, r ? f.width : 0, u ? f.height : 0), v.drawImage(f, 0, 0), o = document.createElement("img"), o.src = l.toDataURL("image/png"), o.width = f.width || f.naturalWidth, o.height = f.height || f.naturalHeight, a.push(o);
            for (h = t._frames, w = h.length / i, e = 0; e < w; e++) f = h[e], s = f.rect.clone(), o = a[f.image.__tmp + d * i], y = {
                image: o,
                rect: s,
                regX: f.regX,
                regY: f.regY
            }, r && (s.x = (o.width || o.naturalWidth) - s.x - s.width, y.regX = s.width - f.regX), u && (s.y = (o.height || o.naturalHeight) - s.y - s.height, y.regY = s.height - f.regY), h.push(y);
            var g = "_" + (r ? "h" : "") + (u ? "v" : ""),
                b = t._animations,
                nt = t._data,
                it = b.length / i;
            for (e = 0; e < it; e++) {
                for (k = b[e], f = nt[k], c = {
                        name: k + g,
                        speed: f.speed,
                        next: f.next,
                        frames: []
                    }, f.next && (c.next += g), h = f.frames, p = 0, tt = h.length; p < tt; p++) c.frames.push(h[p] + w * i);
                nt[c.name] = c;
                b.push(c.name)
            }
        };
        createjs.SpriteSheetUtils = n
    }(),
    function() {
        "use strict";

        function t(n) {
            this.EventDispatcher_constructor();
            this.maxWidth = 2048;
            this.maxHeight = 2048;
            this.spriteSheet = null;
            this.scale = 1;
            this.padding = 1;
            this.timeSlice = .3;
            this.progress = -1;
            this.framerate = n || 0;
            this._frames = [];
            this._animations = {};
            this._data = null;
            this._nextFrameIndex = 0;
            this._index = 0;
            this._timerID = null;
            this._scale = 1
        }
        var n = createjs.extend(t, createjs.EventDispatcher);
        t.ERR_DIMENSIONS = "frame dimensions exceed max spritesheet dimensions";
        t.ERR_RUNNING = "a build is already running";
        n.addFrame = function(n, i, r, u, f) {
            if (this._data) throw t.ERR_RUNNING;
            var e = i || n.bounds || n.nominalBounds;
            return (!e && n.getBounds && (e = n.getBounds()), !e) ? null : (r = r || 1, this._frames.push({
                source: n,
                sourceRect: e,
                scale: r,
                funct: u,
                data: f,
                index: this._frames.length,
                height: e.height * r
            }) - 1)
        };
        n.addAnimation = function(n, i, r, u) {
            if (this._data) throw t.ERR_RUNNING;
            this._animations[n] = {
                frames: i,
                next: r,
                speed: u
            }
        };
        n.addMovieClip = function(n, i, r, u, f, e) {
            var h, c, o, v, y, p, k, w, s, b, a;
            if (this._data) throw t.ERR_RUNNING;
            if (h = n.frameBounds, c = i || n.bounds || n.nominalBounds, !c && n.getBounds && (c = n.getBounds()), c || h) {
                for (y = this._frames.length, p = n.timeline.duration, o = 0; o < p; o++) k = h && h[o] ? h[o] : c, this.addFrame(n, k, r, this._setupMovieClipFrame, {
                    i: o,
                    f: u,
                    d: f
                });
                w = n.timeline._labels;
                s = [];
                for (b in w) s.push({
                    index: w[b],
                    label: b
                });
                if (s.length)
                    for (s.sort(function(n, t) {
                            return n.index - t.index
                        }), o = 0, v = s.length; o < v; o++) {
                        var l = s[o].label,
                            d = y + s[o].index,
                            g = y + (o == v - 1 ? p : s[o + 1].index),
                            nt = [];
                        for (a = d; a < g; a++) nt.push(a);
                        (!e || (l = e(l, n, d, g), l)) && this.addAnimation(l, nt, !0)
                    }
            }
        };
        n.build = function() {
            if (this._data) throw t.ERR_RUNNING;
            for (this._startBuild(); this._drawNext(););
            return this._endBuild(), this.spriteSheet
        };
        n.buildAsync = function(n) {
            if (this._data) throw t.ERR_RUNNING;
            this.timeSlice = n;
            this._startBuild();
            var i = this;
            this._timerID = setTimeout(function() {
                i._run()
            }, 50 - Math.max(.01, Math.min(.99, this.timeSlice || .3)) * 50)
        };
        n.stopAsync = function() {
            clearTimeout(this._timerID);
            this._data = null
        };
        n.clone = function() {
            throw "SpriteSheetBuilder cannot be cloned.";
        };
        n.toString = function() {
            return "[SpriteSheetBuilder]"
        };
        n._startBuild = function() {
            var s = this.padding || 0,
                e, n, i, f;
            if (this.progress = 0, this.spriteSheet = null, this._index = 0, this._scale = this.scale, e = [], this._data = {
                    images: [],
                    frames: e,
                    framerate: this.framerate,
                    animations: this._animations
                }, n = this._frames.slice(), n.sort(function(n, t) {
                    return n.height <= t.height ? -1 : 1
                }), n[n.length - 1].height + s * 2 > this.maxHeight) throw t.ERR_DIMENSIONS;
            for (var r = 0, u = 0, o = 0; n.length;) i = this._fillRow(n, r, o, e, s), i.w > u && (u = i.w), r += i.h, i.h && n.length || (f = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas"), f.width = this._getSize(u, this.maxWidth), f.height = this._getSize(r, this.maxHeight), this._data.images[o] = f, i.h || (u = r = 0, o++))
        };
        n._setupMovieClipFrame = function(n, t) {
            var i = n.actionsEnabled;
            n.actionsEnabled = !1;
            n.gotoAndStop(t.i);
            n.actionsEnabled = i;
            t.f && t.f(n, t.d, t.i)
        };
        n._getSize = function(n, t) {
            for (var i = 4; Math.pow(2, ++i) < n;);
            return Math.min(t, Math.pow(2, i))
        };
        n._fillRow = function(n, i, r, u, f) {
            var y = this.maxWidth,
                w = this.maxHeight,
                h;
            i += f;
            var b = w - i,
                s = f,
                v = 0;
            for (h = n.length - 1; h >= 0; h--) {
                var e = n[h],
                    o = this._scale * e.scale,
                    l = e.sourceRect,
                    p = e.source,
                    k = Math.floor(o * l.x - f),
                    d = Math.floor(o * l.y - f),
                    a = Math.ceil(o * l.height + f * 2),
                    c = Math.ceil(o * l.width + f * 2);
                if (c > y) throw t.ERR_DIMENSIONS;
                a > b || s + c > y || (e.img = r, e.rect = new createjs.Rectangle(s, i, c, a), v = v || a, n.splice(h, 1), u[e.index] = [s, i, c, a, r, Math.round(-k + o * p.regX - f), Math.round(-d + o * p.regY - f)], s += c)
            }
            return {
                w: s,
                h: v
            }
        };
        n._endBuild = function() {
            this.spriteSheet = new createjs.SpriteSheet(this._data);
            this._data = null;
            this.progress = 1;
            this.dispatchEvent("complete")
        };
        n._run = function() {
            for (var t = Math.max(.01, Math.min(.99, this.timeSlice || .3)) * 50, f = (new Date).getTime() + t, i = !1, r, u, n; f > (new Date).getTime();)
                if (!this._drawNext()) {
                    i = !0;
                    break
                }
            i ? this._endBuild() : (r = this, this._timerID = setTimeout(function() {
                r._run()
            }, 50 - t));
            u = this.progress = this._index / this._frames.length;
            this.hasEventListener("progress") && (n = new createjs.Event("progress"), n.progress = u, this.dispatchEvent(n))
        };
        n._drawNext = function() {
            var n = this._frames[this._index],
                r = n.scale * this._scale,
                i = n.rect,
                u = n.sourceRect,
                f = this._data.images[n.img],
                t = f.getContext("2d");
            return n.funct && n.funct(n.source, n.data), t.save(), t.beginPath(), t.rect(i.x, i.y, i.width, i.height), t.clip(), t.translate(Math.ceil(i.x - u.x * r), Math.ceil(i.y - u.y * r)), t.scale(r, r), n.source.draw(t), t.restore(), ++this._index < this._frames.length
        };
        createjs.SpriteSheetBuilder = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.DisplayObject_constructor();
            typeof n == "string" && (n = document.getElementById(n));
            this.mouseEnabled = !1;
            var t = n.style;
            t.position = "absolute";
            t.transformOrigin = t.WebkitTransformOrigin = t.msTransformOrigin = t.MozTransformOrigin = t.OTransformOrigin = "0% 0%";
            this.htmlElement = n;
            this._oldProps = null;
            this._oldStage = null;
            this._drawAction = null
        }
        var n = createjs.extend(t, createjs.DisplayObject);
        n.isVisible = function() {
            return this.htmlElement != null
        };
        n.draw = function() {
            return !0
        };
        n.cache = function() {};
        n.uncache = function() {};
        n.updateCache = function() {};
        n.hitTest = function() {};
        n.localToGlobal = function() {};
        n.globalToLocal = function() {};
        n.localToLocal = function() {};
        n.clone = function() {
            throw "DOMElement cannot be cloned.";
        };
        n.toString = function() {
            return "[DOMElement (name=" + this.name + ")]"
        };
        n._tick = function(n) {
            var t = this.stage;
            t && t !== this._oldStage && (this._drawAction && t.off("drawend", this._drawAction), this._drawAction = t.on("drawend", this._handleDrawEnd, this), this._oldStage = t);
            this.DisplayObject__tick(n)
        };
        n._handleDrawEnd = function() {
            var e = this.htmlElement,
                f;
            if (e) {
                var i = e.style,
                    u = this.getConcatenatedDisplayProps(this._props),
                    t = u.matrix,
                    o = u.visible ? "visible" : "hidden";
                if (o != i.visibility && (i.visibility = o), u.visible) {
                    var r = this._oldProps,
                        s = r && r.matrix,
                        n = 1e4;
                    s && s.equals(t) || (f = "matrix(" + (t.a * n | 0) / n + "," + (t.b * n | 0) / n + "," + (t.c * n | 0) / n + "," + (t.d * n | 0) / n + "," + (t.tx + .5 | 0), i.transform = i.WebkitTransform = i.OTransform = i.msTransform = f + "," + (t.ty + .5 | 0) + ")", i.MozTransform = f + "px," + (t.ty + .5 | 0) + "px)", r || (r = this._oldProps = new createjs.DisplayProps(!0, null)), r.matrix.copy(t));
                    r.alpha != u.alpha && (i.opacity = "" + (u.alpha * n | 0) / n, r.alpha = u.alpha)
                }
            }
        };
        createjs.DOMElement = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t() {
            this.usesContext = !1;
            this._multiPass = null;
            this.VTX_SHADER_BODY = null;
            this.FRAG_SHADER_BODY = null
        }
        var n = t.prototype;
        n.getBounds = function(n) {
            return n
        };
        n.shaderParamSetup = function() {};
        n.applyFilter = function(n, t, i, r, u, f, e, o) {
            f = f || n;
            e == null && (e = t);
            o == null && (o = i);
            try {
                var s = n.getImageData(t, i, r, u)
            } catch (h) {
                return !1
            }
            return this._applyFilter(s) ? (f.putImageData(s, e, o), !0) : !1
        };
        n.toString = function() {
            return "[Filter]"
        };
        n.clone = function() {
            return new t
        };
        n._applyFilter = function() {
            return !0
        };
        createjs.Filter = t
    }(),
    function() {
        "use strict";

        function t() {
            this.width = undefined;
            this.height = undefined;
            this.x = undefined;
            this.y = undefined;
            this.scale = 1;
            this.offX = 0;
            this.offY = 0;
            this.cacheID = 0;
            this._filterOffX = 0;
            this._filterOffY = 0;
            this._cacheDataURLID = 0;
            this._cacheDataURL = null;
            this._drawWidth = 0;
            this._drawHeight = 0
        }
        var n = t.prototype;
        t.getFilterBounds = function(n, t) {
            var u, e, r, f, i;
            if (t || (t = new createjs.Rectangle), u = n.filters, e = u && u.length, !!e <= 0) return t;
            for (r = 0; r < e; r++)(f = u[r], f && f.getBounds) && (i = f.getBounds(), i) && (r == 0 ? t.setValues(i.x, i.y, i.width, i.height) : t.extend(i.x, i.y, i.width, i.height));
            return t
        };
        n.toString = function() {
            return "[BitmapCache]"
        };
        n.define = function(n, t, i, r, u, f, e) {
            if (!n) throw "No symbol to cache";
            this._options = e;
            this.target = n;
            this.width = r >= 1 ? r : 1;
            this.height = u >= 1 ? u : 1;
            this.x = t || 0;
            this.y = i || 0;
            this.scale = f || 1;
            this.update()
        };
        n.update = function(n) {
            if (!this.target) throw "define() must be called before update()";
            var i = t.getFilterBounds(this.target),
                r = this.target.cacheCanvas;
            this._drawWidth = Math.ceil(this.width * this.scale) + i.width;
            this._drawHeight = Math.ceil(this.height * this.scale) + i.height;
            r && this._drawWidth == r.width && this._drawHeight == r.height || this._updateSurface();
            this._filterOffX = i.x;
            this._filterOffY = i.y;
            this.offX = this.x * this.scale + this._filterOffX;
            this.offY = this.y * this.scale + this._filterOffY;
            this._drawToCache(n);
            this.cacheID = this.cacheID ? this.cacheID + 1 : 1
        };
        n.release = function() {
            if (this._webGLCache) this._webGLCache.isCacheControlled || (this.__lastRT && (this.__lastRT = undefined), this.__rtA && this._webGLCache._killTextureObject(this.__rtA), this.__rtB && this._webGLCache._killTextureObject(this.__rtB), this.target && this.target.cacheCanvas && this._webGLCache._killTextureObject(this.target.cacheCanvas)), this._webGLCache = !1;
            else {
                var n = this.target.stage;
                n instanceof createjs.StageGL && n.releaseTexture(this.target.cacheCanvas)
            }
            this.target = this.target.cacheCanvas = null;
            this.cacheID = this._cacheDataURLID = this._cacheDataURL = undefined;
            this.width = this.height = this.x = this.y = this.offX = this.offY = 0;
            this.scale = 1
        };
        n.getCacheDataURL = function() {
            var n = this.target && this.target.cacheCanvas;
            return n ? (this.cacheID != this._cacheDataURLID && (this._cacheDataURLID = this.cacheID, this._cacheDataURL = n.toDataURL ? n.getCacheDataURL() : null), this._cacheDataURL) : null
        };
        n.draw = function(n) {
            return this.target ? (n.drawImage(this.target.cacheCanvas, this.x + this._filterOffX / this.scale, this.y + this._filterOffY / this.scale, this._drawWidth / this.scale, this._drawHeight / this.scale), !0) : !1
        };
        n._updateSurface = function() {
            var i, n, t;
            if (!this._options || !this._options.useGL) {
                n = this.target.cacheCanvas;
                n || (n = this.target.cacheCanvas = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas"));
                n.width = this._drawWidth;
                n.height = this._drawHeight;
                return
            }
            if (!this._webGLCache)
                if (this._options.useGL === "stage") {
                    if (!(this.target.stage && this.target.stage.isWebGL)) {
                        i = "Cannot use 'stage' for cache because the object's parent stage is " + (this.target.stage ? "non WebGL." : "not set, please addChild to the correct stage.");
                        throw i;
                    }
                    this.target.cacheCanvas = !0;
                    this._webGLCache = this.target.stage
                } else if (this._options.useGL === "new") this.target.cacheCanvas = document.createElement("canvas"), this._webGLCache = new createjs.StageGL(this.target.cacheCanvas, {
                antialias: !0,
                transparent: !0,
                autoPurge: -1
            }), this._webGLCache.isCacheControlled = !0;
            else if (this._options.useGL instanceof createjs.StageGL) this.target.cacheCanvas = !0, this._webGLCache = this._options.useGL, this._webGLCache.isCacheControlled = !0;
            else throw "Invalid option provided to useGL, expected ['stage', 'new', StageGL, undefined], got " + this._options.useGL;
            n = this.target.cacheCanvas;
            t = this._webGLCache;
            t.isCacheControlled && (n.width = this._drawWidth, n.height = this._drawHeight, t.updateViewport(this._drawWidth, this._drawHeight));
            this.target.filters ? (t.getTargetRenderTexture(this.target, this._drawWidth, this._drawHeight), t.getTargetRenderTexture(this.target, this._drawWidth, this._drawHeight)) : t.isCacheControlled || t.getTargetRenderTexture(this.target, this._drawWidth, this._drawHeight)
        };
        n._drawToCache = function(n) {
            var i = this.target.cacheCanvas,
                r = this.target,
                u = this._webGLCache,
                t;
            u ? (u.cacheDraw(r, r.filters, this), i = this.target.cacheCanvas, i.width = this._drawWidth, i.height = this._drawHeight) : (t = i.getContext("2d"), n || t.clearRect(0, 0, this._drawWidth + 1, this._drawHeight + 1), t.save(), t.globalCompositeOperation = n, t.setTransform(this.scale, 0, 0, this.scale, -this._filterOffX, -this._filterOffY), t.translate(-this.x, -this.y), r.draw(t, !0), t.restore(), r.filters && r.filters.length && this._applyFilters(t));
            i._invalid = !0
        };
        n._applyFilters = function(n) {
            var r = this.target.filters,
                u = this._drawWidth,
                f = this._drawHeight,
                t, e = 0,
                i = r[e];
            do i.usesContext ? (t && (n.putImageData(t, 0, 0), t = null), i.applyFilter(n, 0, 0, u, f)) : (t || (t = n.getImageData(0, 0, u, f)), i._applyFilter(t)), i = i._multiPass !== null ? i._multiPass : r[++e]; while (i);
            t && n.putImageData(t, 0, 0)
        };
        createjs.BitmapCache = t
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.Filter_constructor();
            this._blurX = n;
            this._blurXTable = [];
            this._lastBlurX = null;
            this._blurY = t;
            this._blurYTable = [];
            this._lastBlurY = null;
            this._quality;
            this._lastQuality = null;
            this.FRAG_SHADER_TEMPLATE = "uniform float xWeight[{{blurX}}];uniform float yWeight[{{blurY}}];uniform vec2 textureOffset;void main(void) {vec4 color = vec4(0.0);float xAdj = ({{blurX}}.0-1.0)/2.0;float yAdj = ({{blurY}}.0-1.0)/2.0;vec2 sampleOffset;for(int i=0; i<{{blurX}}; i++) {for(int j=0; j<{{blurY}}; j++) {sampleOffset = vRenderCoord + (textureOffset * vec2(float(i)-xAdj, float(j)-yAdj));color += texture2D(uSampler, sampleOffset) * (xWeight[i] * yWeight[j]);}}gl_FragColor = color.rgba;}";
            (isNaN(i) || i < 1) && (i = 1);
            this.setQuality(i | 0)
        }
        var n = createjs.extend(t, createjs.Filter);
        n.getBlurX = function() {
            return this._blurX
        };
        n.getBlurY = function() {
            return this._blurY
        };
        n.setBlurX = function(n) {
            (isNaN(n) || n < 0) && (n = 0);
            this._blurX = n
        };
        n.setBlurY = function(n) {
            (isNaN(n) || n < 0) && (n = 0);
            this._blurY = n
        };
        n.getQuality = function() {
            return this._quality
        };
        n.setQuality = function(n) {
            (isNaN(n) || n < 0) && (n = 0);
            this._quality = n | 0
        };
        n._getShader = function() {
            var t = this._lastBlurX !== this._blurX,
                i = this._lastBlurY !== this._blurY,
                n = this._lastQuality !== this._quality;
            return t || i || n ? ((t || n) && (this._blurXTable = this._getTable(this._blurX * this._quality)), (i || n) && (this._blurYTable = this._getTable(this._blurY * this._quality)), this._updateShader(), this._lastBlurX = this._blurX, this._lastBlurY = this._blurY, this._lastQuality = this._quality, undefined) : this._compiledShader
        };
        n._setShader = function() {
            this._compiledShader
        };
        try {
            Object.defineProperties(n, {
                blurX: {
                    get: n.getBlurX,
                    set: n.setBlurX
                },
                blurY: {
                    get: n.getBlurY,
                    set: n.setBlurY
                },
                quality: {
                    get: n.getQuality,
                    set: n.setQuality
                },
                _builtShader: {
                    get: n._getShader,
                    set: n._setShader
                }
            })
        } catch (i) {
            console.log(i)
        }
        n._getTable = function(n) {
            var t, i, r, u, f, e;
            if (n <= 1) return [1];
            for (t = [], i = Math.ceil(n * 2), i += i % 2 ? 0 : 1, r = i / 2 | 0, u = -r; u <= r; u++) f = u / r * 4.2, t.push(1 / Math.sqrt(2 * Math.PI) * Math.pow(Math.E, -(Math.pow(f, 2) / 4)));
            return e = t.reduce(function(n, t) {
                return n + t
            }), t.map(function(n) {
                return n / e
            })
        };
        n._updateShader = function() {
            if (this._blurX !== undefined && this._blurY !== undefined) {
                var n = this.FRAG_SHADER_TEMPLATE;
                n = n.replace(/\{\{blurX\}\}/g, this._blurXTable.length.toFixed(0));
                n = n.replace(/\{\{blurY\}\}/g, this._blurYTable.length.toFixed(0));
                this.FRAG_SHADER_BODY = n
            }
        };
        n.shaderParamSetup = function(n, t, i) {
            n.uniform1fv(n.getUniformLocation(i, "xWeight"), this._blurXTable);
            n.uniform1fv(n.getUniformLocation(i, "yWeight"), this._blurYTable);
            n.uniform2f(n.getUniformLocation(i, "textureOffset"), 2 / (t._viewportWidth * this._quality), 2 / (t._viewportHeight * this._quality))
        };
        t.MUL_TABLE = [1, 171, 205, 293, 57, 373, 79, 137, 241, 27, 391, 357, 41, 19, 283, 265, 497, 469, 443, 421, 25, 191, 365, 349, 335, 161, 155, 149, 9, 278, 269, 261, 505, 245, 475, 231, 449, 437, 213, 415, 405, 395, 193, 377, 369, 361, 353, 345, 169, 331, 325, 319, 313, 307, 301, 37, 145, 285, 281, 69, 271, 267, 263, 259, 509, 501, 493, 243, 479, 118, 465, 459, 113, 446, 55, 435, 429, 423, 209, 413, 51, 403, 199, 393, 97, 3, 379, 375, 371, 367, 363, 359, 355, 351, 347, 43, 85, 337, 333, 165, 327, 323, 5, 317, 157, 311, 77, 305, 303, 75, 297, 294, 73, 289, 287, 71, 141, 279, 277, 275, 68, 135, 67, 133, 33, 262, 260, 129, 511, 507, 503, 499, 495, 491, 61, 121, 481, 477, 237, 235, 467, 232, 115, 457, 227, 451, 7, 445, 221, 439, 218, 433, 215, 427, 425, 211, 419, 417, 207, 411, 409, 203, 202, 401, 399, 396, 197, 49, 389, 387, 385, 383, 95, 189, 47, 187, 93, 185, 23, 183, 91, 181, 45, 179, 89, 177, 11, 175, 87, 173, 345, 343, 341, 339, 337, 21, 167, 83, 331, 329, 327, 163, 81, 323, 321, 319, 159, 79, 315, 313, 39, 155, 309, 307, 153, 305, 303, 151, 75, 299, 149, 37, 295, 147, 73, 291, 145, 289, 287, 143, 285, 71, 141, 281, 35, 279, 139, 69, 275, 137, 273, 17, 271, 135, 269, 267, 133, 265, 33, 263, 131, 261, 130, 259, 129, 257, 1];
        t.SHG_TABLE = [0, 9, 10, 11, 9, 12, 10, 11, 12, 9, 13, 13, 10, 9, 13, 13, 14, 14, 14, 14, 10, 13, 14, 14, 14, 13, 13, 13, 9, 14, 14, 14, 15, 14, 15, 14, 15, 15, 14, 15, 15, 15, 14, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 12, 14, 15, 15, 13, 15, 15, 15, 15, 16, 16, 16, 15, 16, 14, 16, 16, 14, 16, 13, 16, 16, 16, 15, 16, 13, 16, 15, 16, 14, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13, 14, 16, 16, 15, 16, 16, 10, 16, 15, 16, 14, 16, 16, 14, 16, 16, 14, 16, 16, 14, 15, 16, 16, 16, 14, 15, 14, 15, 13, 16, 16, 15, 17, 17, 17, 17, 17, 17, 14, 15, 17, 17, 16, 16, 17, 16, 15, 17, 16, 17, 11, 17, 16, 17, 16, 17, 16, 17, 17, 16, 17, 17, 16, 17, 17, 16, 16, 17, 17, 17, 16, 14, 17, 17, 17, 17, 15, 16, 14, 16, 15, 16, 13, 16, 15, 16, 14, 16, 15, 16, 12, 16, 15, 16, 17, 17, 17, 17, 17, 13, 16, 15, 17, 17, 17, 16, 15, 17, 17, 17, 16, 15, 17, 17, 14, 16, 17, 17, 16, 17, 17, 16, 15, 17, 16, 14, 17, 16, 15, 17, 16, 17, 17, 16, 17, 15, 16, 17, 14, 17, 16, 15, 17, 16, 17, 13, 17, 16, 17, 17, 16, 17, 14, 17, 16, 17, 16, 17, 16, 17, 9];
        n.getBounds = function(n) {
            var i = this.blurX | 0,
                r = this.blurY | 0,
                t;
            return i <= 0 && r <= 0 ? n : (t = Math.pow(this.quality, .2), (n || new createjs.Rectangle).pad(r * t + 1, i * t + 1, r * t + 1, i * t + 1))
        };
        n.clone = function() {
            return new t(this.blurX, this.blurY, this.quality)
        };
        n.toString = function() {
            return "[BlurFilter]"
        };
        n._applyFilter = function(n) {
            var nt = this._blurX >> 1,
                y, v, ut, o, h, c;
            if (isNaN(nt) || nt < 0 || (y = this._blurY >> 1, isNaN(y) || y < 0) || nt == 0 && y == 0) return !1;
            v = this.quality;
            (isNaN(v) || v < 1) && (v = 1);
            v |= 0;
            v > 3 && (v = 3);
            v < 1 && (v = 1);
            for (var i = n.data, a = 0, p = 0, e = 0, r = 0, lt = 0, f = 0, at = 0, w = 0, b = 0, k = 0, d = 0, ft = 0, et = 0, ot = 0, l = 0, vt = nt + nt + 1 | 0, yt = y + y + 1 | 0, g = n.width | 0, st = n.height | 0, ht = g - 1 | 0, rt = st - 1 | 0, it = nt + 1 | 0, tt = y + 1 | 0, ct = {
                    r: 0,
                    b: 0,
                    g: 0,
                    a: 0
                }, s = ct, e = 1; e < vt; e++) s = s.n = {
                r: 0,
                b: 0,
                g: 0,
                a: 0
            };
            for (s.n = ct, ut = {
                    r: 0,
                    b: 0,
                    g: 0,
                    a: 0
                }, o = ut, e = 1; e < yt; e++) o = o.n = {
                r: 0,
                b: 0,
                g: 0,
                a: 0
            };
            o.n = ut;
            for (var u = null, pt = t.MUL_TABLE[nt] | 0, wt = t.SHG_TABLE[nt] | 0, bt = t.MUL_TABLE[y] | 0, kt = t.SHG_TABLE[y] | 0; v-- > 0;) {
                for (at = f = 0, h = pt, c = wt, p = st; --p > -1;) {
                    for (w = it * (ft = i[f | 0]), b = it * (et = i[f + 1 | 0]), k = it * (ot = i[f + 2 | 0]), d = it * (l = i[f + 3 | 0]), s = ct, e = it; --e > -1;) s.r = ft, s.g = et, s.b = ot, s.a = l, s = s.n;
                    for (e = 1; e < it; e++) r = f + ((ht < e ? ht : e) << 2) | 0, w += s.r = i[r], b += s.g = i[r + 1], k += s.b = i[r + 2], d += s.a = i[r + 3], s = s.n;
                    for (u = ct, a = 0; a < g; a++) i[f++] = w * h >>> c, i[f++] = b * h >>> c, i[f++] = k * h >>> c, i[f++] = d * h >>> c, r = at + ((r = a + nt + 1) < ht ? r : ht) << 2, w -= u.r - (u.r = i[r]), b -= u.g - (u.g = i[r + 1]), k -= u.b - (u.b = i[r + 2]), d -= u.a - (u.a = i[r + 3]), u = u.n;
                    at += g
                }
                for (h = bt, c = kt, a = 0; a < g; a++) {
                    for (f = a << 2 | 0, w = tt * (ft = i[f]) | 0, b = tt * (et = i[f + 1 | 0]) | 0, k = tt * (ot = i[f + 2 | 0]) | 0, d = tt * (l = i[f + 3 | 0]) | 0, o = ut, e = 0; e < tt; e++) o.r = ft, o.g = et, o.b = ot, o.a = l, o = o.n;
                    for (lt = g, e = 1; e <= y; e++) f = lt + a << 2, w += o.r = i[f], b += o.g = i[f + 1], k += o.b = i[f + 2], d += o.a = i[f + 3], o = o.n, e < rt && (lt += g);
                    if (f = a, u = ut, v > 0)
                        for (p = 0; p < st; p++) r = f << 2, i[r + 3] = l = d * h >>> c, l > 0 ? (i[r] = w * h >>> c, i[r + 1] = b * h >>> c, i[r + 2] = k * h >>> c) : i[r] = i[r + 1] = i[r + 2] = 0, r = a + ((r = p + tt) < rt ? r : rt) * g << 2, w -= u.r - (u.r = i[r]), b -= u.g - (u.g = i[r + 1]), k -= u.b - (u.b = i[r + 2]), d -= u.a - (u.a = i[r + 3]), u = u.n, f += g;
                    else
                        for (p = 0; p < st; p++) r = f << 2, i[r + 3] = l = d * h >>> c, l > 0 ? (l = 255 / l, i[r] = (w * h >>> c) * l, i[r + 1] = (b * h >>> c) * l, i[r + 2] = (k * h >>> c) * l) : i[r] = i[r + 1] = i[r + 2] = 0, r = a + ((r = p + tt) < rt ? r : rt) * g << 2, w -= u.r - (u.r = i[r]), b -= u.g - (u.g = i[r + 1]), k -= u.b - (u.b = i[r + 2]), d -= u.a - (u.a = i[r + 3]), u = u.n, f += g
                }
            }
            return !0
        };
        createjs.BlurFilter = createjs.promote(t, "Filter")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.Filter_constructor();
            this.alphaMap = n;
            this._alphaMap = null;
            this._mapData = null;
            this._mapTexture = null;
            this.FRAG_SHADER_BODY = "uniform sampler2D uAlphaSampler;void main(void) {vec4 color = texture2D(uSampler, vRenderCoord);vec4 alphaMap = texture2D(uAlphaSampler, vTextureCoord);gl_FragColor = vec4(color.rgb, color.a * (alphaMap.r * ceil(alphaMap.a)));}"
        }
        var n = createjs.extend(t, createjs.Filter);
        n.shaderParamSetup = function(n, t, i) {
            this._mapTexture || (this._mapTexture = n.createTexture());
            n.activeTexture(n.TEXTURE1);
            n.bindTexture(n.TEXTURE_2D, this._mapTexture);
            t.setTextureParams(n);
            n.texImage2D(n.TEXTURE_2D, 0, n.RGBA, n.RGBA, n.UNSIGNED_BYTE, this.alphaMap);
            n.uniform1i(n.getUniformLocation(i, "uAlphaSampler"), 1)
        };
        n.clone = function() {
            var n = new t(this.alphaMap);
            return n._alphaMap = this._alphaMap, n._mapData = this._mapData, n
        };
        n.toString = function() {
            return "[AlphaMapFilter]"
        };
        n._applyFilter = function(n) {
            var i, r, t, u;
            if (!this.alphaMap) return !0;
            if (!this._prepAlphaMap()) return !1;
            for (i = n.data, r = this._mapData, t = 0, u = i.length; t < u; t += 4) i[t + 3] = r[t] || 0;
            return !0
        };
        n._prepAlphaMap = function() {
            var n, t, i, r;
            if (!this.alphaMap) return !1;
            if (this.alphaMap == this._alphaMap && this._mapData) return !0;
            this._mapData = null;
            n = this._alphaMap = this.alphaMap;
            t = n;
            n instanceof HTMLCanvasElement ? i = t.getContext("2d") : (t = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas"), t.width = n.width, t.height = n.height, i = t.getContext("2d"), i.drawImage(n, 0, 0));
            try {
                r = i.getImageData(0, 0, n.width, n.height)
            } catch (u) {
                return !1
            }
            return this._mapData = r.data, !0
        };
        createjs.AlphaMapFilter = createjs.promote(t, "Filter")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.Filter_constructor();
            this.mask = n;
            this.usesContext = !0;
            this.FRAG_SHADER_BODY = "uniform sampler2D uAlphaSampler;void main(void) {vec4 color = texture2D(uSampler, vRenderCoord);vec4 alphaMap = texture2D(uAlphaSampler, vTextureCoord);gl_FragColor = vec4(color.rgb, color.a * alphaMap.a);}"
        }
        var n = createjs.extend(t, createjs.Filter);
        n.shaderParamSetup = function(n, t, i) {
            this._mapTexture || (this._mapTexture = n.createTexture());
            n.activeTexture(n.TEXTURE1);
            n.bindTexture(n.TEXTURE_2D, this._mapTexture);
            t.setTextureParams(n);
            n.texImage2D(n.TEXTURE_2D, 0, n.RGBA, n.RGBA, n.UNSIGNED_BYTE, this.mask);
            n.uniform1i(n.getUniformLocation(i, "uAlphaSampler"), 1)
        };
        n.applyFilter = function(n, t, i, r, u, f, e, o) {
            return this.mask ? (f = f || n, e == null && (e = t), o == null && (o = i), f.save(), n != f) ? !1 : (f.globalCompositeOperation = "destination-in", f.drawImage(this.mask, e, o), f.restore(), !0) : !0
        };
        n.clone = function() {
            return new t(this.mask)
        };
        n.toString = function() {
            return "[AlphaMaskFilter]"
        };
        createjs.AlphaMaskFilter = createjs.promote(t, "Filter")
    }(),
    function() {
        "use strict";

        function t(n, t, i, r, u, f, e, o) {
            this.Filter_constructor();
            this.redMultiplier = n != null ? n : 1;
            this.greenMultiplier = t != null ? t : 1;
            this.blueMultiplier = i != null ? i : 1;
            this.alphaMultiplier = r != null ? r : 1;
            this.redOffset = u || 0;
            this.greenOffset = f || 0;
            this.blueOffset = e || 0;
            this.alphaOffset = o || 0;
            this.FRAG_SHADER_BODY = "uniform vec4 uColorMultiplier;uniform vec4 uColorOffset;void main(void) {vec4 color = texture2D(uSampler, vRenderCoord);gl_FragColor = (color * uColorMultiplier) + uColorOffset;}"
        }
        var n = createjs.extend(t, createjs.Filter);
        n.shaderParamSetup = function(n, t, i) {
            n.uniform4f(n.getUniformLocation(i, "uColorMultiplier"), this.redMultiplier, this.greenMultiplier, this.blueMultiplier, this.alphaMultiplier);
            n.uniform4f(n.getUniformLocation(i, "uColorOffset"), this.redOffset / 255, this.greenOffset / 255, this.blueOffset / 255, this.alphaOffset / 255)
        };
        n.toString = function() {
            return "[ColorFilter]"
        };
        n.clone = function() {
            return new t(this.redMultiplier, this.greenMultiplier, this.blueMultiplier, this.alphaMultiplier, this.redOffset, this.greenOffset, this.blueOffset, this.alphaOffset)
        };
        n._applyFilter = function(n) {
            for (var i = n.data, r = i.length, t = 0; t < r; t += 4) i[t] = i[t] * this.redMultiplier + this.redOffset, i[t + 1] = i[t + 1] * this.greenMultiplier + this.greenOffset, i[t + 2] = i[t + 2] * this.blueMultiplier + this.blueOffset, i[t + 3] = i[t + 3] * this.alphaMultiplier + this.alphaOffset;
            return !0
        };
        createjs.ColorFilter = createjs.promote(t, "Filter")
    }(),
    function() {
        "use strict";

        function n(n, t, i, r) {
            this.setColor(n, t, i, r)
        }
        var t = n.prototype;
        n.DELTA_INDEX = [0, .01, .02, .04, .05, .06, .07, .08, .1, .11, .12, .14, .15, .16, .17, .18, .2, .21, .22, .24, .25, .27, .28, .3, .32, .34, .36, .38, .4, .42, .44, .46, .48, .5, .53, .56, .59, .62, .65, .68, .71, .74, .77, .8, .83, .86, .89, .92, .95, .98, 1, 1.06, 1.12, 1.18, 1.24, 1.3, 1.36, 1.42, 1.48, 1.54, 1.6, 1.66, 1.72, 1.78, 1.84, 1.9, 1.96, 2, 2.12, 2.25, 2.37, 2.5, 2.62, 2.75, 2.87, 3, 3.2, 3.4, 3.6, 3.8, 4, 4.3, 4.7, 4.9, 5, 5.5, 6, 6.5, 6.8, 7, 7.3, 7.5, 7.8, 8, 8.4, 8.7, 9, 9.4, 9.6, 9.8, 10];
        n.IDENTITY_MATRIX = [1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1];
        n.LENGTH = n.IDENTITY_MATRIX.length;
        t.setColor = function(n, t, i, r) {
            return this.reset().adjustColor(n, t, i, r)
        };
        t.reset = function() {
            return this.copy(n.IDENTITY_MATRIX)
        };
        t.adjustColor = function(n, t, i, r) {
            return this.adjustHue(r), this.adjustContrast(t), this.adjustBrightness(n), this.adjustSaturation(i)
        };
        t.adjustBrightness = function(n) {
            return n == 0 || isNaN(n) ? this : (n = this._cleanValue(n, 255), this._multiplyMatrix([1, 0, 0, 0, n, 0, 1, 0, 0, n, 0, 0, 1, 0, n, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1]), this)
        };
        t.adjustContrast = function(t) {
            if (t == 0 || isNaN(t)) return this;
            t = this._cleanValue(t, 100);
            var i;
            return t < 0 ? i = 127 + t / 100 * 127 : (i = t % 1, i = i == 0 ? n.DELTA_INDEX[t] : n.DELTA_INDEX[t << 0] * (1 - i) + n.DELTA_INDEX[(t << 0) + 1] * i, i = i * 127 + 127), this._multiplyMatrix([i / 127, 0, 0, 0, .5 * (127 - i), 0, i / 127, 0, 0, .5 * (127 - i), 0, 0, i / 127, 0, .5 * (127 - i), 0, 0, 0, 1, 0, 0, 0, 0, 0, 1]), this
        };
        t.adjustSaturation = function(n) {
            if (n == 0 || isNaN(n)) return this;
            n = this._cleanValue(n, 100);
            var t = 1 + (n > 0 ? 3 * n / 100 : n / 100),
                i = .3086,
                r = .6094,
                u = .082;
            return this._multiplyMatrix([i * (1 - t) + t, r * (1 - t), u * (1 - t), 0, 0, i * (1 - t), r * (1 - t) + t, u * (1 - t), 0, 0, i * (1 - t), r * (1 - t), u * (1 - t) + t, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1]), this
        };
        t.adjustHue = function(n) {
            if (n == 0 || isNaN(n)) return this;
            n = this._cleanValue(n, 180) / 180 * Math.PI;
            var t = Math.cos(n),
                i = Math.sin(n),
                r = .213,
                u = .715,
                f = .072;
            return this._multiplyMatrix([r + t * (1 - r) + i * -r, u + t * -u + i * -u, f + t * -f + i * (1 - f), 0, 0, r + t * -r + i * .143, u + t * (1 - u) + i * .14, f + t * -f + i * -.283, 0, 0, r + t * -r + i * -(1 - r), u + t * -u + i * u, f + t * (1 - f) + i * f, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1]), this
        };
        t.concat = function(t) {
            return (t = this._fixMatrix(t), t.length != n.LENGTH) ? this : (this._multiplyMatrix(t), this)
        };
        t.clone = function() {
            return (new n).copy(this)
        };
        t.toArray = function() {
            for (var i = [], t = 0, r = n.LENGTH; t < r; t++) i[t] = this[t];
            return i
        };
        t.copy = function(t) {
            for (var r = n.LENGTH, i = 0; i < r; i++) this[i] = t[i];
            return this
        };
        t.toString = function() {
            return "[ColorMatrix]"
        };
        t._multiplyMatrix = function(n) {
            for (var t, r, f = [], u, i = 0; i < 5; i++) {
                for (t = 0; t < 5; t++) f[t] = this[t + i * 5];
                for (t = 0; t < 5; t++) {
                    for (u = 0, r = 0; r < 5; r++) u += n[t + r * 5] * f[r];
                    this[t + i * 5] = u
                }
            }
        };
        t._cleanValue = function(n, t) {
            return Math.min(t, Math.max(-t, n))
        };
        t._fixMatrix = function(t) {
            return t instanceof n && (t = t.toArray()), t.length < n.LENGTH ? t = t.slice(0, t.length).concat(n.IDENTITY_MATRIX.slice(t.length, n.LENGTH)) : t.length > n.LENGTH && (t = t.slice(0, n.LENGTH)), t
        };
        createjs.ColorMatrix = n
    }(),
    function() {
        "use strict";

        function t(n) {
            this.Filter_constructor();
            this.matrix = n;
            this.FRAG_SHADER_BODY = "uniform mat4 uColorMatrix;uniform vec4 uColorMatrixOffset;void main(void) {vec4 color = texture2D(uSampler, vRenderCoord);mat4 m = uColorMatrix;vec4 newColor = vec4(0,0,0,0);newColor.r = color.r*m[0][0] + color.g*m[0][1] + color.b*m[0][2] + color.a*m[0][3];newColor.g = color.r*m[1][0] + color.g*m[1][1] + color.b*m[1][2] + color.a*m[1][3];newColor.b = color.r*m[2][0] + color.g*m[2][1] + color.b*m[2][2] + color.a*m[2][3];newColor.a = color.r*m[3][0] + color.g*m[3][1] + color.b*m[3][2] + color.a*m[3][3];gl_FragColor = newColor + uColorMatrixOffset;}"
        }
        var n = createjs.extend(t, createjs.Filter);
        n.shaderParamSetup = function(n, t, i) {
            var r = this.matrix,
                u = new Float32Array([r[0], r[1], r[2], r[3], r[5], r[6], r[7], r[8], r[10], r[11], r[12], r[13], r[15], r[16], r[17], r[18]]);
            n.uniformMatrix4fv(n.getUniformLocation(i, "uColorMatrix"), !1, u);
            n.uniform4f(n.getUniformLocation(i, "uColorMatrixOffset"), r[4] / 255, r[9] / 255, r[14] / 255, r[19] / 255)
        };
        n.toString = function() {
            return "[ColorMatrixFilter]"
        };
        n.clone = function() {
            return new t(this.matrix)
        };
        n._applyFilter = function(n) {
            for (var r = n.data, s = r.length, u, f, e, o, t = this.matrix, h = t[0], c = t[1], l = t[2], a = t[3], v = t[4], y = t[5], p = t[6], w = t[7], b = t[8], k = t[9], d = t[10], g = t[11], nt = t[12], tt = t[13], it = t[14], rt = t[15], ut = t[16], ft = t[17], et = t[18], ot = t[19], i = 0; i < s; i += 4) u = r[i], f = r[i + 1], e = r[i + 2], o = r[i + 3], r[i] = u * h + f * c + e * l + o * a + v, r[i + 1] = u * y + f * p + e * w + o * b + k, r[i + 2] = u * d + f * g + e * nt + o * tt + it, r[i + 3] = u * rt + f * ut + e * ft + o * et + ot;
            return !0
        };
        createjs.ColorMatrixFilter = createjs.promote(t, "Filter")
    }(),
    function() {
        "use strict";

        function n() {
            throw "Touch cannot be instantiated";
        }
        n.isSupported = function() {
            return !!("ontouchstart" in window || window.MSPointerEvent && window.navigator.msMaxTouchPoints > 0 || window.PointerEvent && window.navigator.maxTouchPoints > 0)
        };
        n.enable = function(t, i, r, u) {
            return !t || !t.canvas || !n.isSupported() ? !1 : t.__touch ? !0 : (t.__touch = {
                pointers: {},
                multitouch: !i,
                preventDefault: !r,
                count: 0
            }, u ? "ontouchstart" in window ? n._enable(t) : (window.PointerEvent || window.MSPointerEvent) && n._IE_enable(t) : "ontouchstart" in window || createjs.BrowserDetect.isChrome || createjs.BrowserDetect.isEdge || createjs.BrowserDetect.isFirefox ? n._enable(t) : (window.PointerEvent || window.MSPointerEvent) && n._IE_enable(t), !0)
        };
        n.disable = function(t) {
            t && ("ontouchstart" in window || createjs.BrowserDetect.isChrome || createjs.BrowserDetect.isFirefox ? n._disable(t) : (window.PointerEvent || window.MSPointerEvent) && n._IE_disable(t), delete t.__touch)
        };
        n._enable = function(t) {
            var i = t.canvas,
                r = t.__touch.f = function(i) {
                    n._handleEvent(t, i)
                };
            i.addEventListener("touchstart", r, !1);
            i.addEventListener("touchmove", r, !1);
            i.addEventListener("touchend", r, !1);
            i.addEventListener("touchcancel", r, !1)
        };
        n._disable = function(n) {
            var t = n.canvas,
                i;
            t && (i = n.__touch.f, t.removeEventListener("touchstart", i, !1), t.removeEventListener("touchmove", i, !1), t.removeEventListener("touchend", i, !1), t.removeEventListener("touchcancel", i, !1))
        };
        n._handleEvent = function(n, t) {
            var e, r, u, o, i, f;
            if (n)
                for (n.__touch.preventDefault && t.preventDefault && t.preventDefault(), e = t.changedTouches, r = t.type, u = 0, o = e.length; u < o; u++)(i = e[u], f = i.identifier, i.target == n.canvas) && (r === "touchstart" ? this._handleStart(n, f, t, i.pageX, i.pageY) : r === "touchmove" ? this._handleMove(n, f, t, i.pageX, i.pageY) : (r === "touchend" || r === "touchcancel") && this._handleEnd(n, f, t))
        };
        n._IE_enable = function(t) {
            var r = t.canvas,
                i = t.__touch.f = function(i) {
                    n._IE_handleEvent(t, i)
                };
            r.style["-webkit-tap-highlight-color"] = "transparent";
            window.PointerEvent === undefined ? (r.addEventListener("MSPointerDown", i, !1), window.addEventListener("MSPointerMove", i, !1), window.addEventListener("MSPointerUp", i, !1), window.addEventListener("MSPointerCancel", i, !1), t.__touch.preventDefault && (r.style.msTouchAction = "none")) : (r.addEventListener("pointerdown", i, !1), window.addEventListener("pointermove", i, !1), window.addEventListener("pointerup", i, !1), window.addEventListener("pointercancel", i, !1), t.__touch.preventDefault && (r.style.touchAction = "none"));
            t.__touch.activeIDs = {}
        };
        n._IE_disable = function(n) {
            var t = n.__touch.f;
            window.PointerEvent === undefined ? (window.removeEventListener("MSPointerMove", t, !1), window.removeEventListener("MSPointerUp", t, !1), window.removeEventListener("MSPointerCancel", t, !1), n.canvas && n.canvas.removeEventListener("MSPointerDown", t, !1)) : (window.removeEventListener("pointermove", t, !1), window.removeEventListener("pointerup", t, !1), window.removeEventListener("pointercancel", t, !1), n.canvas && n.canvas.removeEventListener("pointerdown", t, !1))
        };
        n._IE_handleEvent = function(n, t) {
            if (n) {
                n.__touch.preventDefault && t.preventDefault && t.preventDefault();
                var i = t.type,
                    r = t.pointerId,
                    u = n.__touch.activeIDs;
                if (i === "MSPointerDown" || i === "pointerdown") {
                    if (t.srcElement != n.canvas) return;
                    u[r] = !0;
                    this._handleStart(n, r, t, t.pageX, t.pageY);
                    switch (t.pointerType) {
                        case "mouse":
                            n.enableDOMEvents(!0);
                            break;
                        case "touch":
                            n.enableDOMEvents(!1)
                    }
                } else u[r] && (i === "MSPointerMove" || i === "pointermove" ? this._handleMove(n, r, t, t.pageX, t.pageY) : (i === "MSPointerUp" || i === "MSPointerCancel" || i === "pointerup" || i === "pointercancel") && (delete u[r], this._handleEnd(n, r, t)))
            }
        };
        n._handleStart = function(n, t, i, r, u) {
            var f = n.__touch,
                e;
            (f.multitouch || !f.count) && ((e = f.pointers, e[t]) || (e[t] = !0, f.count++, n._handlePointerDown(t, i, r, u)))
        };
        n._handleMove = function(n, t, i, r, u) {
            n.__touch.pointers[t] && n._handlePointerMove(t, i, r, u)
        };
        n._handleEnd = function(n, t, i) {
            var r = n.__touch,
                u = r.pointers;
            u[t] && (r.count--, n._handlePointerUp(t, i, !0), delete u[t])
        };
        createjs.Touch = n
    }(),
    function() {
        "use strict";
        var n = createjs.EaselJS = createjs.EaselJS || {};
        n.version = "1.0.0";
        n.buildDate = "Thu, 12 Oct 2017 16:34:05 GMT"
    }(),
    function() {
        "use strict";
        var n = createjs.PreloadJS = createjs.PreloadJS || {};
        n.version = "NEXT";
        n.buildDate = "Thu, 14 Sep 2017 22:19:45 GMT"
    }(),
    function() {
        "use strict";
        createjs.proxy = function(n, t) {
            var i = Array.prototype.slice.call(arguments, 2);
            return function() {
                return n.apply(t, Array.prototype.slice.call(arguments, 0).concat(i))
            }
        }
    }(),
    function() {
        "use strict";

        function n(n, t, i) {
            this.Event_constructor("error");
            this.title = n;
            this.message = t;
            this.data = i
        }
        var t = createjs.extend(n, createjs.Event);
        t.clone = function() {
            return new createjs.ErrorEvent(this.title, this.message, this.data)
        };
        createjs.ErrorEvent = createjs.promote(n, "Event")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.Event_constructor("progress");
            this.loaded = n;
            this.total = t == null ? 1 : t;
            this.progress = t == 0 ? 0 : this.loaded / this.total
        }
        var t = createjs.extend(n, createjs.Event);
        t.clone = function() {
            return new createjs.ProgressEvent(this.loaded, this.total)
        };
        createjs.ProgressEvent = createjs.promote(n, "Event")
    }(window);
/*! JSON v3.3.2 | http://bestiejs.github.io/json3 | Copyright 2012-2014, Kit Cambridge | http://kit.mit-license.org */
(function() {
    function f(t, r) {
        function l(n) {
            var e, i, a, t, s, f, u;
            if (l[n] !== h) return l[n];
            if (n == "bug-string-char-index") e = "a" [0] != "a";
            else if (n == "json") e = l("json-stringify") && l("json-parse");
            else {
                if (a = '{"a":[1,true,false,null,"\\u0000\\b\\n\\f\\r\\t"]}', n == "json-stringify") {
                    if (t = r.stringify, s = typeof t == "function" && c, s) {
                        (i = function() {
                            return 1
                        }).toJSON = i;
                        try {
                            s = t(0) === "0" && t(new lt) === "0" && t(new et) == '""' && t(o) === h && t(h) === h && t() === h && t(i) === "1" && t([i]) == "[1]" && t([h]) == "[null]" && t(null) == "null" && t([h, o, null]) == "[null,null,null]" && t({
                                a: [i, !0, !1, null, "\x00\b\n\f\r\t"]
                            }) == a && t(null, i) === "1" && t([1, 2], null, 1) == "[\n 1,\n 2\n]" && t(new w(-864e13)) == '"-271821-04-20T00:00:00.000Z"' && t(new w(864e13)) == '"+275760-09-13T00:00:00.000Z"' && t(new w(-621987552e5)) == '"-000001-01-01T00:00:00.000Z"' && t(new w(-1)) == '"1969-12-31T23:59:59.999Z"'
                        } catch (v) {
                            s = !1
                        }
                    }
                    e = s
                }
                if (n == "json-parse") {
                    if (f = r.parse, typeof f == "function") try {
                        if (f("0") === 0 && !f(!1) && (i = f(a), u = i.a.length == 5 && i.a[0] === 1, u)) {
                            try {
                                u = !f('"\t"')
                            } catch (v) {}
                            if (u) try {
                                u = f("01") !== 1
                            } catch (v) {}
                            if (u) try {
                                u = f("1.") !== 1
                            } catch (v) {}
                        }
                    } catch (v) {
                        u = !1
                    }
                    e = u
                }
            }
            return l[n] = !!e
        }
        t || (t = n.Object());
        r || (r = n.Object());
        var lt = t.Number || n.Number,
            et = t.String || n.String,
            at = t.Object || n.Object,
            w = t.Date || n.Date,
            vt = t.SyntaxError || n.SyntaxError,
            yt = t.TypeError || n.TypeError,
            pt = t.Math || n.Math,
            g = t.JSON || n.JSON;
        typeof g == "object" && g && (r.stringify = g.stringify, r.parse = g.parse);
        var ot = at.prototype,
            o = ot.toString,
            s, p, h, c = new w(-0xc782b5b800cec);
        try {
            c = c.getUTCFullYear() == -109252 && c.getUTCMonth() === 0 && c.getUTCDate() === 1 && c.getUTCHours() == 10 && c.getUTCMinutes() == 37 && c.getUTCSeconds() == 6 && c.getUTCMilliseconds() == 708
        } catch (ri) {}
        if (!l("json")) {
            var b = "[object Function]",
                wt = "[object Date]",
                nt = "[object Number]",
                tt = "[object String]",
                it = "[object Array]",
                bt = "[object Boolean]",
                k = l("bug-string-char-index");
            if (!c) var a = pt.floor,
                kt = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334],
                d = function(n, t) {
                    return kt[t] + 365 * (n - 1970) + a((n - 1969 + (t = +(t > 1))) / 4) - a((n - 1901 + t) / 100) + a((n - 1601 + t) / 400)
                };
            if ((s = ot.hasOwnProperty) || (s = function(n) {
                    var t = {},
                        i;
                    return (t.__proto__ = null, t.__proto__ = {
                        toString: 1
                    }, t).toString != o ? s = function(n) {
                        var t = this.__proto__,
                            i = n in (this.__proto__ = null, this);
                        return this.__proto__ = t, i
                    } : (i = t.constructor, s = function(n) {
                        var t = (this.constructor || i).prototype;
                        return n in this && !(n in t && this[n] === t[n])
                    }), t = null, s.call(this, n)
                }), p = function(n, t) {
                    var u = 0,
                        f, r, e;
                    (f = function() {
                        this.valueOf = 0
                    }).prototype.valueOf = 0;
                    r = new f;
                    for (e in r) s.call(r, e) && u++;
                    return f = r = null, u ? p = u == 2 ? function(n, t) {
                        var r = {},
                            u = o.call(n) == b;
                        for (var i in n) u && i == "prototype" || s.call(r, i) || !(r[i] = 1) || !s.call(n, i) || t(i)
                    } : function(n, t) {
                        var u = o.call(n) == b,
                            i, r;
                        for (i in n) u && i == "prototype" || !s.call(n, i) || (r = i === "constructor") || t(i);
                        (r || s.call(n, i = "constructor")) && t(i)
                    } : (r = ["valueOf", "toString", "toLocaleString", "propertyIsEnumerable", "isPrototypeOf", "hasOwnProperty", "constructor"], p = function(n, t) {
                        var f = o.call(n) == b,
                            u, e, h = !f && typeof n.constructor != "function" && i[typeof n.hasOwnProperty] && n.hasOwnProperty || s;
                        for (u in n) f && u == "prototype" || !h.call(n, u) || t(u);
                        for (e = r.length; u = r[--e]; h.call(n, u) && t(u));
                    }), p(n, t)
                }, !l("json-stringify")) {
                var dt = {
                        92: "\\\\",
                        34: '\\"',
                        8: "\\b",
                        12: "\\f",
                        10: "\\n",
                        13: "\\r",
                        9: "\\t"
                    },
                    gt = "000000",
                    v = function(n, t) {
                        return (gt + (t || 0)).slice(-n)
                    },
                    ni = "\\u00",
                    st = function(n) {
                        for (var r = '"', t = 0, u = n.length, f = !k || u > 10, e = f && (k ? n.split("") : n), i; t < u; t++) {
                            i = n.charCodeAt(t);
                            switch (i) {
                                case 8:
                                case 9:
                                case 10:
                                case 12:
                                case 13:
                                case 34:
                                case 92:
                                    r += dt[i];
                                    break;
                                default:
                                    if (i < 32) {
                                        r += ni + v(2, i.toString(16));
                                        break
                                    }
                                    r += f ? e[t] : n.charAt(t)
                            }
                        }
                        return r + '"'
                    },
                    ut = function(n, t, i, r, u, f, e) {
                        var c, y, l, k, w, g, et, ot, ht, ct, b, lt, ft, rt, at, vt;
                        try {
                            c = t[n]
                        } catch (pt) {}
                        if (typeof c == "object" && c)
                            if (y = o.call(c), y != wt || s.call(c, "toJSON")) typeof c.toJSON == "function" && (y != nt && y != tt && y != it || s.call(c, "toJSON")) && (c = c.toJSON(n));
                            else if (c > -1 / 0 && c < 1 / 0) {
                            if (d) {
                                for (w = a(c / 864e5), l = a(w / 365.2425) + 1970 - 1; d(l + 1, 0) <= w; l++);
                                for (k = a((w - d(l, 0)) / 30.42); d(l, k + 1) <= w; k++);
                                w = 1 + w - d(l, k);
                                g = (c % 864e5 + 864e5) % 864e5;
                                et = a(g / 36e5) % 24;
                                ot = a(g / 6e4) % 60;
                                ht = a(g / 1e3) % 60;
                                ct = g % 1e3
                            } else l = c.getUTCFullYear(), k = c.getUTCMonth(), w = c.getUTCDate(), et = c.getUTCHours(), ot = c.getUTCMinutes(), ht = c.getUTCSeconds(), ct = c.getUTCMilliseconds();
                            c = (l <= 0 || l >= 1e4 ? (l < 0 ? "-" : "+") + v(6, l < 0 ? -l : l) : v(4, l)) + "-" + v(2, k + 1) + "-" + v(2, w) + "T" + v(2, et) + ":" + v(2, ot) + ":" + v(2, ht) + "." + v(3, ct) + "Z"
                        } else c = null;
                        if (i && (c = i.call(t, n, c)), c === null) return "null";
                        if (y = o.call(c), y == bt) return "" + c;
                        if (y == nt) return c > -1 / 0 && c < 1 / 0 ? "" + c : "null";
                        if (y == tt) return st("" + c);
                        if (typeof c == "object") {
                            for (rt = e.length; rt--;)
                                if (e[rt] === c) throw yt();
                            if (e.push(c), b = [], at = f, f += u, y == it) {
                                for (ft = 0, rt = c.length; ft < rt; ft++) lt = ut(ft, c, i, r, u, f, e), b.push(lt === h ? "null" : lt);
                                vt = b.length ? u ? "[\n" + f + b.join(",\n" + f) + "\n" + at + "]" : "[" + b.join(",") + "]" : "[]"
                            } else p(r || c, function(n) {
                                var t = ut(n, c, i, r, u, f, e);
                                t !== h && b.push(st(n) + ":" + (u ? " " : "") + t)
                            }), vt = b.length ? u ? "{\n" + f + b.join(",\n" + f) + "\n" + at + "}" : "{" + b.join(",") + "}" : "{}";
                            return e.pop(), vt
                        }
                    };
                r.stringify = function(n, t, r) {
                    var e, c, s, u, h, l, f;
                    if (i[typeof t] && t)
                        if ((u = o.call(t)) == b) c = t;
                        else if (u == it)
                        for (s = {}, h = 0, l = t.length; h < l; f = t[h++], (u = o.call(f), u == tt || u == nt) && (s[f] = 1));
                    if (r)
                        if ((u = o.call(r)) == nt) {
                            if ((r -= r % 1) > 0)
                                for (e = "", r > 10 && (r = 10); e.length < r; e += " ");
                        } else u == tt && (e = r.length <= 10 ? r : r.slice(0, 10));
                    return ut("", (f = {}, f[""] = n, f), c, s, e, "", [])
                }
            }
            if (!l("json-parse")) {
                var ti = et.fromCharCode,
                    ii = {
                        92: "\\",
                        34: '"',
                        47: "/",
                        98: "\b",
                        116: "\t",
                        110: "\n",
                        102: "\f",
                        114: "\r"
                    },
                    u, rt, e = function() {
                        u = rt = null;
                        throw vt();
                    },
                    y = function() {
                        for (var t = rt, o = t.length, r, f, i, s, n; u < o;) {
                            n = t.charCodeAt(u);
                            switch (n) {
                                case 9:
                                case 10:
                                case 13:
                                case 32:
                                    u++;
                                    break;
                                case 123:
                                case 125:
                                case 91:
                                case 93:
                                case 58:
                                case 44:
                                    return r = k ? t.charAt(u) : t[u], u++, r;
                                case 34:
                                    for (r = "@", u++; u < o;)
                                        if (n = t.charCodeAt(u), n < 32) e();
                                        else if (n == 92) {
                                        n = t.charCodeAt(++u);
                                        switch (n) {
                                            case 92:
                                            case 34:
                                            case 47:
                                            case 98:
                                            case 116:
                                            case 110:
                                            case 102:
                                            case 114:
                                                r += ii[n];
                                                u++;
                                                break;
                                            case 117:
                                                for (f = ++u, i = u + 4; u < i; u++) n = t.charCodeAt(u), n >= 48 && n <= 57 || n >= 97 && n <= 102 || n >= 65 && n <= 70 || e();
                                                r += ti("0x" + t.slice(f, u));
                                                break;
                                            default:
                                                e()
                                        }
                                    } else {
                                        if (n == 34) break;
                                        for (n = t.charCodeAt(u), f = u; n >= 32 && n != 92 && n != 34;) n = t.charCodeAt(++u);
                                        r += t.slice(f, u)
                                    }
                                    if (t.charCodeAt(u) == 34) return u++, r;
                                    e();
                                default:
                                    if (f = u, n == 45 && (s = !0, n = t.charCodeAt(++u)), n >= 48 && n <= 57) {
                                        for (n == 48 && (n = t.charCodeAt(u + 1), n >= 48 && n <= 57) && e(), s = !1; u < o && (n = t.charCodeAt(u), n >= 48 && n <= 57); u++);
                                        if (t.charCodeAt(u) == 46) {
                                            for (i = ++u; i < o && (n = t.charCodeAt(i), n >= 48 && n <= 57); i++);
                                            i == u && e();
                                            u = i
                                        }
                                        if (n = t.charCodeAt(u), n == 101 || n == 69) {
                                            for (n = t.charCodeAt(++u), (n == 43 || n == 45) && u++, i = u; i < o && (n = t.charCodeAt(i), n >= 48 && n <= 57); i++);
                                            i == u && e();
                                            u = i
                                        }
                                        return +t.slice(f, u)
                                    }
                                    if (s && e(), t.slice(u, u + 4) == "true") return u += 4, !0;
                                    if (t.slice(u, u + 5) == "false") return u += 5, !1;
                                    if (t.slice(u, u + 4) == "null") return u += 4, null;
                                    e()
                            }
                        }
                        return "$"
                    },
                    ft = function(n) {
                        var t, i;
                        if (n == "$" && e(), typeof n == "string") {
                            if ((k ? n.charAt(0) : n[0]) == "@") return n.slice(1);
                            if (n == "[") {
                                for (t = [];; i || (i = !0)) {
                                    if (n = y(), n == "]") break;
                                    i && (n == "," ? (n = y(), n == "]" && e()) : e());
                                    n == "," && e();
                                    t.push(ft(n))
                                }
                                return t
                            }
                            if (n == "{") {
                                for (t = {};; i || (i = !0)) {
                                    if (n = y(), n == "}") break;
                                    i && (n == "," ? (n = y(), n == "}" && e()) : e());
                                    (n == "," || typeof n != "string" || (k ? n.charAt(0) : n[0]) != "@" || y() != ":") && e();
                                    t[n.slice(1)] = ft(y())
                                }
                                return t
                            }
                            e()
                        }
                        return n
                    },
                    ht = function(n, t, i) {
                        var r = ct(n, t, i);
                        r === h ? delete n[t] : n[t] = r
                    },
                    ct = function(n, t, i) {
                        var r = n[t],
                            u;
                        if (typeof r == "object" && r)
                            if (o.call(r) == it)
                                for (u = r.length; u--;) ht(r, u, i);
                            else p(r, function(n) {
                                ht(r, n, i)
                            });
                        return i.call(n, t, r)
                    };
                r.parse = function(n, t) {
                    var i, r;
                    return u = 0, rt = "" + n, i = ft(y()), y() != "$" && e(), u = rt = null, t && o.call(t) == b ? ct((r = {}, r[""] = i, r), "", t) : i
                }
            }
        }
        return r.runInContext = f, r
    }
    var e = typeof define == "function" && define.amd,
        i = {
            "function": !0,
            object: !0
        },
        u = i[typeof exports] && exports && !exports.nodeType && exports,
        n = i[typeof window] && window || this,
        t = u && i[typeof module] && module && !module.nodeType && typeof global == "object" && global;
    if (t && (t.global === t || t.window === t || t.self === t) && (n = t), u && !e) f(n, u);
    else {
        var o = n.JSON,
            s = n.JSON3,
            h = !1,
            r = f(n, n.JSON3 = {
                noConflict: function() {
                    return h || (h = !0, n.JSON = o, n.JSON3 = s, o = s = null), r
                }
            });
        n.JSON = {
            parse: r.parse,
            stringify: r.stringify
        }
    }
    e && define(function() {
        return r
    })
}).call(this),
    function() {
        var n = {};
        n.a = function() {
            return n.el("a")
        };
        n.svg = function() {
            return n.el("svg")
        };
        n.object = function() {
            return n.el("object")
        };
        n.image = function() {
            return n.el("image")
        };
        n.img = function() {
            return n.el("img")
        };
        n.style = function() {
            return n.el("style")
        };
        n.link = function() {
            return n.el("link")
        };
        n.script = function() {
            return n.el("script")
        };
        n.audio = function() {
            return n.el("audio")
        };
        n.video = function() {
            return n.el("video")
        };
        n.text = function(n) {
            return document.createTextNode(n)
        };
        n.el = function(n) {
            return document.createElement(n)
        };
        createjs.Elements = n
    }(),
    function() {
        var n = {};
        n.ABSOLUTE_PATT = /^(?:\w+:)?\/{2}/i;
        n.RELATIVE_PATT = /^[./]*?\//i;
        n.EXTENSION_PATT = /\/?[^/]+\.(\w{1,5})$/i;
        n.parseURI = function(t) {
            var i = {
                    absolute: !1,
                    relative: !1,
                    protocol: null,
                    hostname: null,
                    port: null,
                    pathname: null,
                    search: null,
                    hash: null,
                    host: null
                },
                r, u, f, e;
            if (t == null) return i;
            r = createjs.Elements.a();
            r.href = t;
            for (u in i) u in r && (i[u] = r[u]);
            return f = t.indexOf("?"), f > -1 && (t = t.substr(0, f)), n.ABSOLUTE_PATT.test(t) ? i.absolute = !0 : n.RELATIVE_PATT.test(t) && (i.relative = !0), (e = t.match(n.EXTENSION_PATT)) && (i.extension = e[1].toLowerCase()), i
        };
        n.formatQueryString = function(n, t) {
            var i, r;
            if (n == null) throw new Error("You must specify data.");
            i = [];
            for (r in n) i.push(r + "=" + escape(n[r]));
            return t && (i = i.concat(t)), i.join("&")
        };
        n.buildURI = function(n, t) {
            var i, r, u;
            return t == null ? n : (i = [], r = n.indexOf("?"), r != -1 && (u = n.slice(r + 1), i = i.concat(u.split("&"))), r != -1 ? n.slice(0, r) + "?" + this.formatQueryString(t, i) : n + "?" + this.formatQueryString(t, i))
        };
        n.isCrossDomain = function(n) {
            var t = createjs.Elements.a(),
                i;
            return t.href = n.src, i = createjs.Elements.a(), i.href = location.href, t.hostname != "" && (t.port != i.port || t.protocol != i.protocol || t.hostname != i.hostname)
        };
        n.isLocal = function(n) {
            var t = createjs.Elements.a();
            return t.href = n.src, t.hostname == "" && t.protocol == "file:"
        };
        createjs.URLUtils = n
    }(),
    function() {
        var n = {
            container: null
        };
        n.appendToHead = function(t) {
            n.getHead().appendChild(t)
        };
        n.appendToBody = function(t) {
            if (n.container == null) {
                n.container = document.createElement("div");
                n.container.id = "preloadjs-container";
                var i = n.container.style;
                i.visibility = "hidden";
                i.position = "absolute";
                i.width = n.container.style.height = "10px";
                i.overflow = "hidden";
                i.transform = i.msTransform = i.webkitTransform = i.oTransform = "translate(-10px, -10px)";
                n.getBody().appendChild(n.container)
            }
            n.container.appendChild(t)
        };
        n.getHead = function() {
            return document.head || document.getElementsByTagName("head")[0]
        };
        n.getBody = function() {
            return document.body || document.getElementsByTagName("body")[0]
        };
        n.removeChild = function(n) {
            n.parent && n.parent.removeChild(n)
        };
        n.isImageTag = function(n) {
            return n instanceof HTMLImageElement
        };
        n.isAudioTag = function(n) {
            return window.HTMLAudioElement ? n instanceof HTMLAudioElement : !1
        };
        n.isVideoTag = function(n) {
            return window.HTMLVideoElement ? n instanceof HTMLVideoElement : !1
        };
        createjs.DomUtils = n
    }(),
    function() {
        var n = {};
        n.parseXML = function(n) {
            var t = null,
                i;
            try {
                window.DOMParser && (i = new DOMParser, t = i.parseFromString(n, "text/xml"))
            } catch (r) {}
            if (!t) try {
                t = new ActiveXObject("Microsoft.XMLDOM");
                t.async = !1;
                t.loadXML(n)
            } catch (r) {
                t = null
            }
            return t
        };
        n.parseJSON = function(n) {
            if (n == null) return null;
            try {
                return JSON.parse(n)
            } catch (t) {
                throw t;
            }
        };
        createjs.DataUtils = n
    }(),
    function() {
        var n = {};
        n.BINARY = "binary";
        n.CSS = "css";
        n.FONT = "font";
        n.FONTCSS = "fontcss";
        n.IMAGE = "image";
        n.JAVASCRIPT = "javascript";
        n.JSON = "json";
        n.JSONP = "jsonp";
        n.MANIFEST = "manifest";
        n.SOUND = "sound";
        n.VIDEO = "video";
        n.SPRITESHEET = "spritesheet";
        n.SVG = "svg";
        n.TEXT = "text";
        n.XML = "xml";
        createjs.Types = n
    }(),
    function() {
        var n = {};
        n.POST = "POST";
        n.GET = "GET";
        createjs.Methods = n
    }(),
    function() {
        "use strict";

        function t() {
            this.src = null;
            this.type = null;
            this.id = null;
            this.maintainOrder = !1;
            this.callback = null;
            this.data = null;
            this.method = createjs.Methods.GET;
            this.values = null;
            this.headers = null;
            this.withCredentials = !1;
            this.mimeType = null;
            this.crossOrigin = null;
            this.loadTimeout = n.LOAD_TIMEOUT_DEFAULT
        }
        var i = t.prototype = {},
            n = t;
        n.LOAD_TIMEOUT_DEFAULT = 8e3;
        n.create = function(i) {
            if (typeof i == "string") {
                var r = new t;
                return r.src = i, r
            }
            if (i instanceof n) return i;
            if (i instanceof Object && i.src) return i.loadTimeout == null && (i.loadTimeout = n.LOAD_TIMEOUT_DEFAULT), i;
            throw new Error("Type not recognized.");
        };
        i.set = function(n) {
            for (var t in n) this[t] = n[t];
            return this
        };
        createjs.LoadItem = n
    }(),
    function() {
        var n = {};
        n.isBinary = function(n) {
            switch (n) {
                case createjs.Types.IMAGE:
                case createjs.Types.BINARY:
                    return !0;
                default:
                    return !1
            }
        };
        n.isText = function(n) {
            switch (n) {
                case createjs.Types.TEXT:
                case createjs.Types.JSON:
                case createjs.Types.MANIFEST:
                case createjs.Types.XML:
                case createjs.Types.CSS:
                case createjs.Types.SVG:
                case createjs.Types.JAVASCRIPT:
                case createjs.Types.SPRITESHEET:
                    return !0;
                default:
                    return !1
            }
        };
        n.getTypeByExtension = function(n) {
            if (n == null) return createjs.Types.TEXT;
            switch (n.toLowerCase()) {
                case "jpeg":
                case "jpg":
                case "gif":
                case "png":
                case "webp":
                case "bmp":
                    return createjs.Types.IMAGE;
                case "ogg":
                case "mp3":
                case "webm":
                    return createjs.Types.SOUND;
                case "mp4":
                case "webm":
                case "ts":
                    return createjs.Types.VIDEO;
                case "json":
                    return createjs.Types.JSON;
                case "xml":
                    return createjs.Types.XML;
                case "css":
                    return createjs.Types.CSS;
                case "js":
                    return createjs.Types.JAVASCRIPT;
                case "svg":
                    return createjs.Types.SVG;
                default:
                    return createjs.Types.TEXT
            }
        };
        createjs.RequestUtils = n
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.EventDispatcher_constructor();
            this.loaded = !1;
            this.canceled = !1;
            this.progress = 0;
            this.type = i;
            this.resultFormatter = null;
            this._item = n ? createjs.LoadItem.create(n) : null;
            this._preferXHR = t;
            this._result = null;
            this._rawResult = null;
            this._loadedItems = null;
            this._tagSrcAttribute = null;
            this._tag = null
        }
        var n = createjs.extend(t, createjs.EventDispatcher),
            i = t;
        try {
            Object.defineProperties(i, {
                POST: {
                    get: createjs.deprecate(function() {
                        return createjs.Methods.POST
                    }, "AbstractLoader.POST")
                },
                GET: {
                    get: createjs.deprecate(function() {
                        return createjs.Methods.GET
                    }, "AbstractLoader.GET")
                },
                BINARY: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.BINARY
                    }, "AbstractLoader.BINARY")
                },
                CSS: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.CSS
                    }, "AbstractLoader.CSS")
                },
                FONT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.FONT
                    }, "AbstractLoader.FONT")
                },
                FONTCSS: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.FONTCSS
                    }, "AbstractLoader.FONTCSS")
                },
                IMAGE: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.IMAGE
                    }, "AbstractLoader.IMAGE")
                },
                JAVASCRIPT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JAVASCRIPT
                    }, "AbstractLoader.JAVASCRIPT")
                },
                JSON: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JSON
                    }, "AbstractLoader.JSON")
                },
                JSONP: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JSONP
                    }, "AbstractLoader.JSONP")
                },
                MANIFEST: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.MANIFEST
                    }, "AbstractLoader.MANIFEST")
                },
                SOUND: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SOUND
                    }, "AbstractLoader.SOUND")
                },
                VIDEO: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.VIDEO
                    }, "AbstractLoader.VIDEO")
                },
                SPRITESHEET: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SPRITESHEET
                    }, "AbstractLoader.SPRITESHEET")
                },
                SVG: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SVG
                    }, "AbstractLoader.SVG")
                },
                TEXT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.TEXT
                    }, "AbstractLoader.TEXT")
                },
                XML: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.XML
                    }, "AbstractLoader.XML")
                }
            })
        } catch (r) {}
        n.getItem = function() {
            return this._item
        };
        n.getResult = function(n) {
            return n ? this._rawResult : this._result
        };
        n.getTag = function() {
            return this._tag
        };
        n.setTag = function(n) {
            this._tag = n
        };
        n.load = function() {
            this._createRequest();
            this._request.on("complete", this, this);
            this._request.on("progress", this, this);
            this._request.on("loadStart", this, this);
            this._request.on("abort", this, this);
            this._request.on("timeout", this, this);
            this._request.on("error", this, this);
            var n = new createjs.Event("initialize");
            n.loader = this._request;
            this.dispatchEvent(n);
            this._request.load()
        };
        n.cancel = function() {
            this.canceled = !0;
            this.destroy()
        };
        n.destroy = function() {
            this._request && (this._request.removeAllEventListeners(), this._request.destroy());
            this._request = null;
            this._item = null;
            this._rawResult = null;
            this._result = null;
            this._loadItems = null;
            this.removeAllEventListeners()
        };
        n.getLoadedItems = function() {
            return this._loadedItems
        };
        n._createRequest = function() {
            this._request = this._preferXHR ? new createjs.XHRRequest(this._item) : new createjs.TagRequest(this._item, this._tag || this._createTag(), this._tagSrcAttribute)
        };
        n._createTag = function() {
            return null
        };
        n._sendLoadStart = function() {
            this._isCanceled() || this.dispatchEvent("loadstart")
        };
        n._sendProgress = function(n) {
            if (!this._isCanceled()) {
                var t = null;
                typeof n == "number" ? (this.progress = n, t = new createjs.ProgressEvent(this.progress)) : (t = n, this.progress = n.loaded / n.total, t.progress = this.progress, (isNaN(this.progress) || this.progress == Infinity) && (this.progress = 0));
                this.hasEventListener("progress") && this.dispatchEvent(t)
            }
        };
        n._sendComplete = function() {
            if (!this._isCanceled()) {
                this.loaded = !0;
                var n = new createjs.Event("complete");
                n.rawResult = this._rawResult;
                this._result != null && (n.result = this._result);
                this.dispatchEvent(n)
            }
        };
        n._sendError = function(n) {
            !this._isCanceled() && this.hasEventListener("error") && (n == null && (n = new createjs.ErrorEvent("PRELOAD_ERROR_EMPTY")), this.dispatchEvent(n))
        };
        n._isCanceled = function() {
            return window.createjs == null || this.canceled ? !0 : !1
        };
        n.resultFormatter = null;
        n.handleEvent = function(n) {
            switch (n.type) {
                case "complete":
                    this._rawResult = n.target._response;
                    var t = this.resultFormatter && this.resultFormatter(this);
                    t instanceof Function ? t.call(this, createjs.proxy(this._resultFormatSuccess, this), createjs.proxy(this._resultFormatFailed, this)) : (this._result = t || this._rawResult, this._sendComplete());
                    break;
                case "progress":
                    this._sendProgress(n);
                    break;
                case "error":
                    this._sendError(n);
                    break;
                case "loadstart":
                    this._sendLoadStart();
                    break;
                case "abort":
                case "timeout":
                    this._isCanceled() || this.dispatchEvent(new createjs.ErrorEvent("PRELOAD_" + n.type.toUpperCase() + "_ERROR"))
            }
        };
        n._resultFormatSuccess = function(n) {
            this._result = n;
            this._sendComplete()
        };
        n._resultFormatFailed = function(n) {
            this._sendError(n)
        };
        n.toString = function() {
            return "[PreloadJS AbstractLoader]"
        };
        createjs.AbstractLoader = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.AbstractLoader_constructor(n, t, i);
            this.resultFormatter = this._formatResult;
            this._tagSrcAttribute = "src";
            this.on("initialize", this._updateXHR, this)
        }
        var n = createjs.extend(t, createjs.AbstractLoader);
        n.load = function() {
            this._tag || (this._tag = this._createTag(this._item.src));
            this._tag.preload = "auto";
            this._tag.load();
            this.AbstractLoader_load()
        };
        n._createTag = function() {};
        n._createRequest = function() {
            this._request = this._preferXHR ? new createjs.XHRRequest(this._item) : new createjs.MediaTagRequest(this._item, this._tag || this._createTag(), this._tagSrcAttribute)
        };
        n._updateXHR = function(n) {
            n.loader.setResponseType && n.loader.setResponseType("blob")
        };
        n._formatResult = function(n) {
            if (this._tag.removeEventListener && this._tag.removeEventListener("canplaythrough", this._loadedHandler), this._tag.onstalled = null, this._preferXHR) {
                var t = window.URL || window.webkitURL,
                    i = n.getResult(!0);
                n.getTag().src = t.createObjectURL(i)
            }
            return n.getTag()
        };
        createjs.AbstractMediaLoader = createjs.promote(t, "AbstractLoader")
    }(),
    function() {
        "use strict";
        var t = function(n) {
                this._item = n
            },
            n = createjs.extend(t, createjs.EventDispatcher);
        n.load = function() {};
        n.destroy = function() {};
        n.cancel = function() {};
        createjs.AbstractRequest = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.AbstractRequest_constructor(n);
            this._tag = t;
            this._tagSrcAttribute = i;
            this._loadedHandler = createjs.proxy(this._handleTagComplete, this);
            this._addedToDOM = !1
        }
        var n = createjs.extend(t, createjs.AbstractRequest);
        n.load = function() {
            this._tag.onload = createjs.proxy(this._handleTagComplete, this);
            this._tag.onreadystatechange = createjs.proxy(this._handleReadyStateChange, this);
            this._tag.onerror = createjs.proxy(this._handleError, this);
            var n = new createjs.Event("initialize");
            n.loader = this._tag;
            this.dispatchEvent(n);
            this._loadTimeout = setTimeout(createjs.proxy(this._handleTimeout, this), this._item.loadTimeout);
            this._tag[this._tagSrcAttribute] = this._item.src;
            this._tag.parentNode == null && (createjs.DomUtils.appendToBody(this._tag), this._addedToDOM = !0)
        };
        n.destroy = function() {
            this._clean();
            this._tag = null;
            this.AbstractRequest_destroy()
        };
        n._handleReadyStateChange = function() {
            clearTimeout(this._loadTimeout);
            var n = this._tag;
            (n.readyState == "loaded" || n.readyState == "complete") && this._handleTagComplete()
        };
        n._handleError = function() {
            this._clean();
            this.dispatchEvent("error")
        };
        n._handleTagComplete = function() {
            this._rawResult = this._tag;
            this._result = this.resultFormatter && this.resultFormatter(this) || this._rawResult;
            this._clean();
            this.dispatchEvent("complete")
        };
        n._handleTimeout = function() {
            this._clean();
            this.dispatchEvent(new createjs.Event("timeout"))
        };
        n._clean = function() {
            this._tag.onload = null;
            this._tag.onreadystatechange = null;
            this._tag.onerror = null;
            this._addedToDOM && this._tag.parentNode != null && this._tag.parentNode.removeChild(this._tag);
            clearTimeout(this._loadTimeout)
        };
        n._handleStalled = function() {};
        createjs.TagRequest = createjs.promote(t, "AbstractRequest")
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.AbstractRequest_constructor(n);
            this._tag = t;
            this._tagSrcAttribute = i;
            this._loadedHandler = createjs.proxy(this._handleTagComplete, this)
        }
        var n = createjs.extend(t, createjs.TagRequest),
            i = t;
        n.load = function() {
            var t = createjs.proxy(this._handleStalled, this),
                n;
            this._stalledCallback = t;
            n = createjs.proxy(this._handleProgress, this);
            this._handleProgress = n;
            this._tag.addEventListener("stalled", t);
            this._tag.addEventListener("progress", n);
            this._tag.addEventListener && this._tag.addEventListener("canplaythrough", this._loadedHandler, !1);
            this.TagRequest_load()
        };
        n._handleReadyStateChange = function() {
            clearTimeout(this._loadTimeout);
            var n = this._tag;
            (n.readyState == "loaded" || n.readyState == "complete") && this._handleTagComplete()
        };
        n._handleStalled = function() {};
        n._handleProgress = function(n) {
            if (n && (!(n.loaded > 0) || n.total != 0)) {
                var t = new createjs.ProgressEvent(n.loaded, n.total);
                this.dispatchEvent(t)
            }
        };
        n._clean = function() {
            this._tag.removeEventListener && this._tag.removeEventListener("canplaythrough", this._loadedHandler);
            this._tag.removeEventListener("stalled", this._stalledCallback);
            this._tag.removeEventListener("progress", this._progressCallback);
            this.TagRequest__clean()
        };
        createjs.MediaTagRequest = createjs.promote(t, "TagRequest")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.AbstractRequest_constructor(n);
            this._request = null;
            this._loadTimeout = null;
            this._xhrLevel = 1;
            this._response = null;
            this._rawResponse = null;
            this._canceled = !1;
            this._handleLoadStartProxy = createjs.proxy(this._handleLoadStart, this);
            this._handleProgressProxy = createjs.proxy(this._handleProgress, this);
            this._handleAbortProxy = createjs.proxy(this._handleAbort, this);
            this._handleErrorProxy = createjs.proxy(this._handleError, this);
            this._handleTimeoutProxy = createjs.proxy(this._handleTimeout, this);
            this._handleLoadProxy = createjs.proxy(this._handleLoad, this);
            this._handleReadyStateChangeProxy = createjs.proxy(this._handleReadyStateChange, this);
            !this._createXHR(n)
        }
        var n = createjs.extend(t, createjs.AbstractRequest);
        t.ACTIVEX_VERSIONS = ["Msxml2.XMLHTTP.6.0", "Msxml2.XMLHTTP.5.0", "Msxml2.XMLHTTP.4.0", "MSXML2.XMLHTTP.3.0", "MSXML2.XMLHTTP", "Microsoft.XMLHTTP"];
        n.getResult = function(n) {
            return n && this._rawResponse ? this._rawResponse : this._response
        };
        n.cancel = function() {
            this.canceled = !0;
            this._clean();
            this._request.abort()
        };
        n.load = function() {
            if (this._request == null) {
                this._handleError();
                return
            }
            this._request.addEventListener != null ? (this._request.addEventListener("loadstart", this._handleLoadStartProxy, !1), this._request.addEventListener("progress", this._handleProgressProxy, !1), this._request.addEventListener("abort", this._handleAbortProxy, !1), this._request.addEventListener("error", this._handleErrorProxy, !1), this._request.addEventListener("timeout", this._handleTimeoutProxy, !1), this._request.addEventListener("load", this._handleLoadProxy, !1), this._request.addEventListener("readystatechange", this._handleReadyStateChangeProxy, !1)) : (this._request.onloadstart = this._handleLoadStartProxy, this._request.onprogress = this._handleProgressProxy, this._request.onabort = this._handleAbortProxy, this._request.onerror = this._handleErrorProxy, this._request.ontimeout = this._handleTimeoutProxy, this._request.onload = this._handleLoadProxy, this._request.onreadystatechange = this._handleReadyStateChangeProxy);
            this._xhrLevel == 1 && (this._loadTimeout = setTimeout(createjs.proxy(this._handleTimeout, this), this._item.loadTimeout));
            try {
                this._item.values ? this._request.send(createjs.URLUtils.formatQueryString(this._item.values)) : this._request.send()
            } catch (n) {
                this.dispatchEvent(new createjs.ErrorEvent("XHR_SEND", null, n))
            }
        };
        n.setResponseType = function(n) {
            n === "blob" && (n = window.URL ? "blob" : "arraybuffer", this._responseType = n);
            this._request.responseType = n
        };
        n.getAllResponseHeaders = function() {
            return this._request.getAllResponseHeaders instanceof Function ? this._request.getAllResponseHeaders() : null
        };
        n.getResponseHeader = function(n) {
            return this._request.getResponseHeader instanceof Function ? this._request.getResponseHeader(n) : null
        };
        n._handleProgress = function(n) {
            if (n && (!(n.loaded > 0) || n.total != 0)) {
                var t = new createjs.ProgressEvent(n.loaded, n.total);
                this.dispatchEvent(t)
            }
        };
        n._handleLoadStart = function() {
            clearTimeout(this._loadTimeout);
            this.dispatchEvent("loadstart")
        };
        n._handleAbort = function(n) {
            this._clean();
            this.dispatchEvent(new createjs.ErrorEvent("XHR_ABORTED", null, n))
        };
        n._handleError = function(n) {
            this._clean();
            this.dispatchEvent(new createjs.ErrorEvent(n.message))
        };
        n._handleReadyStateChange = function() {
            this._request.readyState == 4 && this._handleLoad()
        };
        n._handleLoad = function() {
            var n, t;
            if (!this.loaded) {
                if (this.loaded = !0, n = this._checkError(), n) {
                    this._handleError(n);
                    return
                }
                if (this._response = this._getResponse(), this._responseType === "arraybuffer") try {
                    this._response = new Blob([this._response])
                } catch (i) {
                    window.BlobBuilder = window.BlobBuilder || window.WebKitBlobBuilder || window.MozBlobBuilder || window.MSBlobBuilder;
                    i.name === "TypeError" && window.BlobBuilder && (t = new BlobBuilder, t.append(this._response), this._response = t.getBlob())
                }
                this._clean();
                this.dispatchEvent(new createjs.Event("complete"))
            }
        };
        n._handleTimeout = function(n) {
            this._clean();
            this.dispatchEvent(new createjs.ErrorEvent("PRELOAD_TIMEOUT", null, n))
        };
        n._checkError = function() {
            var n = parseInt(this._request.status);
            return n >= 400 && n <= 599 ? new Error(n) : n == 0 ? /^https?:/.test(location.protocol) ? new Error(0) : null : null
        };
        n._getResponse = function() {
            if (this._response != null) return this._response;
            if (this._request.response != null) return this._request.response;
            try {
                if (this._request.responseText != null) return this._request.responseText
            } catch (n) {}
            try {
                if (this._request.responseXML != null) return this._request.responseXML
            } catch (n) {}
            return null
        };
        n._createXHR = function(n) {
            var f = createjs.URLUtils.isCrossDomain(n),
                i = {},
                t = null,
                u, o, h, e, r;
            if (window.XMLHttpRequest) t = new XMLHttpRequest, f && t.withCredentials === undefined && window.XDomainRequest && (t = new XDomainRequest);
            else {
                for (u = 0, o = s.ACTIVEX_VERSIONS.length; u < o; u++) {
                    h = s.ACTIVEX_VERSIONS[u];
                    try {
                        t = new ActiveXObject(h);
                        break
                    } catch (c) {}
                }
                if (t == null) return !1
            }
            if (n.mimeType == null && createjs.RequestUtils.isText(n.type) && (n.mimeType = "text/plain; charset=utf-8"), n.mimeType && t.overrideMimeType && t.overrideMimeType(n.mimeType), this._xhrLevel = typeof t.responseType == "string" ? 2 : 1, e = null, e = n.method == createjs.Methods.GET ? createjs.URLUtils.buildURI(n.src, n.values) : n.src, t.open(n.method || createjs.Methods.GET, e, !0), f && t instanceof XMLHttpRequest && this._xhrLevel == 1 && (i.Origin = location.origin), n.values && n.method == createjs.Methods.POST && (i["Content-Type"] = "application/x-www-form-urlencoded"), f || i["X-Requested-With"] || (i["X-Requested-With"] = "XMLHttpRequest"), n.headers)
                for (r in n.headers) i[r] = n.headers[r];
            for (r in i) t.setRequestHeader(r, i[r]);
            return t instanceof XMLHttpRequest && n.withCredentials !== undefined && (t.withCredentials = n.withCredentials), this._request = t, !0
        };
        n._clean = function() {
            clearTimeout(this._loadTimeout);
            this._request.removeEventListener != null ? (this._request.removeEventListener("loadstart", this._handleLoadStartProxy), this._request.removeEventListener("progress", this._handleProgressProxy), this._request.removeEventListener("abort", this._handleAbortProxy), this._request.removeEventListener("error", this._handleErrorProxy), this._request.removeEventListener("timeout", this._handleTimeoutProxy), this._request.removeEventListener("load", this._handleLoadProxy), this._request.removeEventListener("readystatechange", this._handleReadyStateChangeProxy)) : (this._request.onloadstart = null, this._request.onprogress = null, this._request.onabort = null, this._request.onerror = null, this._request.ontimeout = null, this._request.onload = null, this._request.onreadystatechange = null)
        };
        n.toString = function() {
            return "[PreloadJS XHRRequest]"
        };
        createjs.XHRRequest = createjs.promote(t, "AbstractRequest")
    }(),
    function() {
        "use strict";

        function i(n, t, i) {
            this.AbstractLoader_constructor();
            this._plugins = [];
            this._typeCallbacks = {};
            this._extensionCallbacks = {};
            this.next = null;
            this.maintainScriptOrder = !0;
            this.stopOnError = !1;
            this._maxConnections = 1;
            this._availableLoaders = [createjs.FontLoader, createjs.ImageLoader, createjs.JavaScriptLoader, createjs.CSSLoader, createjs.JSONLoader, createjs.JSONPLoader, createjs.SoundLoader, createjs.ManifestLoader, createjs.SpriteSheetLoader, createjs.XMLLoader, createjs.SVGLoader, createjs.BinaryLoader, createjs.VideoLoader, createjs.TextLoader];
            this._defaultLoaderLength = this._availableLoaders.length;
            this.init(n, t, i)
        }
        var n = createjs.extend(i, createjs.AbstractLoader),
            t = i;
        try {
            Object.defineProperties(t, {
                POST: {
                    get: createjs.deprecate(function() {
                        return createjs.Methods.POST
                    }, "AbstractLoader.POST")
                },
                GET: {
                    get: createjs.deprecate(function() {
                        return createjs.Methods.GET
                    }, "AbstractLoader.GET")
                },
                BINARY: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.BINARY
                    }, "AbstractLoader.BINARY")
                },
                CSS: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.CSS
                    }, "AbstractLoader.CSS")
                },
                FONT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.FONT
                    }, "AbstractLoader.FONT")
                },
                FONTCSS: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.FONTCSS
                    }, "AbstractLoader.FONTCSS")
                },
                IMAGE: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.IMAGE
                    }, "AbstractLoader.IMAGE")
                },
                JAVASCRIPT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JAVASCRIPT
                    }, "AbstractLoader.JAVASCRIPT")
                },
                JSON: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JSON
                    }, "AbstractLoader.JSON")
                },
                JSONP: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JSONP
                    }, "AbstractLoader.JSONP")
                },
                MANIFEST: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.MANIFEST
                    }, "AbstractLoader.MANIFEST")
                },
                SOUND: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SOUND
                    }, "AbstractLoader.SOUND")
                },
                VIDEO: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.VIDEO
                    }, "AbstractLoader.VIDEO")
                },
                SPRITESHEET: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SPRITESHEET
                    }, "AbstractLoader.SPRITESHEET")
                },
                SVG: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SVG
                    }, "AbstractLoader.SVG")
                },
                TEXT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.TEXT
                    }, "AbstractLoader.TEXT")
                },
                XML: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.XML
                    }, "AbstractLoader.XML")
                }
            })
        } catch (r) {}
        n.init = function(n, t, i) {
            this.preferXHR = !0;
            this._preferXHR = !0;
            this.setPreferXHR(n);
            this._paused = !1;
            this._basePath = t;
            this._crossOrigin = i;
            this._loadStartWasDispatched = !1;
            this._currentlyLoadingScript = null;
            this._currentLoads = [];
            this._loadQueue = [];
            this._loadQueueBackup = [];
            this._loadItemsById = {};
            this._loadItemsBySrc = {};
            this._loadedResults = {};
            this._loadedRawResults = {};
            this._numItems = 0;
            this._numItemsLoaded = 0;
            this._scriptOrder = [];
            this._loadedScripts = [];
            this._lastProgress = NaN
        };
        n.registerLoader = function(n) {
            if (n && n.canLoadItem) {
                if (this._availableLoaders.indexOf(n) != -1) throw new Error("loader already exists.");
            } else throw new Error("loader is of an incorrect type.");
            this._availableLoaders.unshift(n)
        };
        n.unregisterLoader = function(n) {
            var t = this._availableLoaders.indexOf(n);
            t != -1 && t < this._defaultLoaderLength - 1 && this._availableLoaders.splice(t, 1)
        };
        n.setPreferXHR = function(n) {
            return this.preferXHR = n != !1 && window.XMLHttpRequest != null, this.preferXHR
        };
        n.removeAll = function() {
            this.remove()
        };
        n.remove = function(n) {
            var u = null,
                f, e, i, o, t, r;
            if (n && !Array.isArray(n)) u = [n];
            else if (n) u = n;
            else if (arguments.length > 0) return;
            if (f = !1, u) {
                while (u.length) {
                    for (i = u.pop(), o = this.getResult(i), t = this._loadQueue.length - 1; t >= 0; t--)
                        if (r = this._loadQueue[t].getItem(), r.id == i || r.src == i) {
                            this._loadQueue.splice(t, 1)[0].cancel();
                            break
                        }
                    for (t = this._loadQueueBackup.length - 1; t >= 0; t--)
                        if (r = this._loadQueueBackup[t].getItem(), r.id == i || r.src == i) {
                            this._loadQueueBackup.splice(t, 1)[0].cancel();
                            break
                        }
                    if (o) this._disposeItem(this.getItem(i));
                    else
                        for (t = this._currentLoads.length - 1; t >= 0; t--)
                            if (r = this._currentLoads[t].getItem(), r.id == i || r.src == i) {
                                this._currentLoads.splice(t, 1)[0].cancel();
                                f = !0;
                                break
                            }
                }
                f && this._loadNext()
            } else {
                this.close();
                for (e in this._loadItemsById) this._disposeItem(this._loadItemsById[e]);
                this.init(this.preferXHR, this._basePath)
            }
        };
        n.reset = function() {
            var i, t, n, r;
            this.close();
            for (i in this._loadItemsById) this._disposeItem(this._loadItemsById[i]);
            for (t = [], n = 0, r = this._loadQueueBackup.length; n < r; n++) t.push(this._loadQueueBackup[n].getItem());
            this.loadManifest(t, !1)
        };
        n.installPlugin = function(n) {
            var t, i, r;
            if (n != null && n.getPreloadHandlers != null) {
                if (this._plugins.push(n), t = n.getPreloadHandlers(), t.scope = n, t.types != null)
                    for (i = 0, r = t.types.length; i < r; i++) this._typeCallbacks[t.types[i]] = t;
                if (t.extensions != null)
                    for (i = 0, r = t.extensions.length; i < r; i++) this._extensionCallbacks[t.extensions[i]] = t
            }
        };
        n.setMaxConnections = function(n) {
            this._maxConnections = n;
            !this._paused && this._loadQueue.length > 0 && this._loadNext()
        };
        n.loadFile = function(n, t, i) {
            if (n == null) {
                var r = new createjs.ErrorEvent("PRELOAD_NO_FILE");
                this._sendError(r);
                return
            }
            this._addItem(n, null, i);
            t !== !1 ? this.setPaused(!1) : this.setPaused(!0)
        };
        n.loadManifest = function(n, i, r) {
            var u = null,
                o = null,
                f, e, s;
            if (Array.isArray(n)) {
                if (n.length == 0) {
                    f = new createjs.ErrorEvent("PRELOAD_MANIFEST_EMPTY");
                    this._sendError(f);
                    return
                }
                u = n
            } else if (typeof n == "string") u = [{
                src: n,
                type: t.MANIFEST
            }];
            else if (typeof n == "object") n.src !== undefined ? (n.type == null ? n.type = t.MANIFEST : n.type != t.MANIFEST && (f = new createjs.ErrorEvent("PRELOAD_MANIFEST_TYPE"), this._sendError(f)), u = [n]) : n.manifest !== undefined && (u = n.manifest, o = n.path);
            else {
                f = new createjs.ErrorEvent("PRELOAD_MANIFEST_NULL");
                this._sendError(f);
                return
            }
            for (e = 0, s = u.length; e < s; e++) this._addItem(u[e], o, r);
            i !== !1 ? this.setPaused(!1) : this.setPaused(!0)
        };
        n.load = function() {
            this.setPaused(!1)
        };
        n.getItem = function(n) {
            return this._loadItemsById[n] || this._loadItemsBySrc[n]
        };
        n.getResult = function(n, t) {
            var r = this._loadItemsById[n] || this._loadItemsBySrc[n],
                i;
            return r == null ? null : (i = r.id, t && this._loadedRawResults[i]) ? this._loadedRawResults[i] : this._loadedResults[i]
        };
        n.getItems = function(n) {
            var r = [],
                t, u, i;
            for (t in this._loadItemsById)(u = this._loadItemsById[t], i = this.getResult(t), n !== !0 || i != null) && r.push({
                item: u,
                result: i,
                rawResult: this.getResult(t, !0)
            });
            return r
        };
        n.setPaused = function(n) {
            this._paused = n;
            this._paused || this._loadNext()
        };
        n.close = function() {
            while (this._currentLoads.length) this._currentLoads.pop().cancel();
            this._scriptOrder.length = 0;
            this._loadedScripts.length = 0;
            this.loadStartWasDispatched = !1;
            this._itemCount = 0;
            this._lastProgress = NaN
        };
        n._addItem = function(n, t, i) {
            var u = this._createLoadItem(n, t, i),
                r;
            u != null && (r = this._createLoader(u), r != null && ("plugins" in r && (r.plugins = this._plugins), u._loader = r, this._loadQueue.push(r), this._loadQueueBackup.push(r), this._numItems++, this._updateProgress(), (this.maintainScriptOrder && u.type == createjs.Types.JAVASCRIPT || u.maintainOrder === !0) && (this._scriptOrder.push(u), this._loadedScripts.push(null))))
        };
        n._createLoadItem = function(n, t, i) {
            var r = createjs.LoadItem.create(n),
                u, f, e, h, o, c, s;
            if (r == null) return null;
            if (u = "", f = i || this._basePath, r.src instanceof Object) {
                if (!r.type) return null;
                t ? (u = t, o = createjs.URLUtils.parseURI(t), f == null || o.absolute || o.relative || (u = f + u)) : f != null && (u = f)
            } else e = createjs.URLUtils.parseURI(r.src), e.extension && (r.ext = e.extension), r.type == null && (r.type = createjs.RequestUtils.getTypeByExtension(r.ext)), h = r.src, e.absolute || e.relative || (t ? (u = t, o = createjs.URLUtils.parseURI(t), h = t + h, f == null || o.absolute || o.relative || (u = f + u)) : f != null && (u = f)), r.src = u + r.src;
            if (r.path = u, (r.id === undefined || r.id === null || r.id === "") && (r.id = h), c = this._typeCallbacks[r.type] || this._extensionCallbacks[r.ext], c) {
                if (s = c.callback.call(c.scope, r, this), s === !1) return null;
                s === !0 || s != null && (r._loader = s);
                e = createjs.URLUtils.parseURI(r.src);
                e.extension != null && (r.ext = e.extension)
            }
            return this._loadItemsById[r.id] = r, this._loadItemsBySrc[r.src] = r, r.crossOrigin == null && (r.crossOrigin = this._crossOrigin), r
        };
        n._createLoader = function(n) {
            var r, t, i;
            if (n._loader != null) return n._loader;
            for (r = this.preferXHR, t = 0; t < this._availableLoaders.length; t++)
                if (i = this._availableLoaders[t], i && i.canLoadItem(n)) return new i(n, r);
            return null
        };
        n._loadNext = function() {
            var n, t;
            if (!this._paused)
                for (this._loadStartWasDispatched || (this._sendLoadStart(), this._loadStartWasDispatched = !0), this._numItems == this._numItemsLoaded ? (this.loaded = !0, this._sendComplete(), this.next && this.next.load && this.next.load()) : this.loaded = !1, n = 0; n < this._loadQueue.length; n++) {
                    if (this._currentLoads.length >= this._maxConnections) break;
                    (t = this._loadQueue[n], this._canStartLoad(t)) && (this._loadQueue.splice(n, 1), n--, this._loadItem(t))
                }
        };
        n._loadItem = function(n) {
            n.on("fileload", this._handleFileLoad, this);
            n.on("progress", this._handleProgress, this);
            n.on("complete", this._handleFileComplete, this);
            n.on("error", this._handleError, this);
            n.on("fileerror", this._handleFileError, this);
            this._currentLoads.push(n);
            this._sendFileStart(n.getItem());
            n.load()
        };
        n._handleFileLoad = function(n) {
            n.target = null;
            this.dispatchEvent(n)
        };
        n._handleFileError = function(n) {
            var t = new createjs.ErrorEvent("FILE_LOAD_ERROR", null, n.item);
            this._sendError(t)
        };
        n._handleError = function(n) {
            var t = n.target,
                i;
            this._numItemsLoaded++;
            this._finishOrderedItem(t, !0);
            this._updateProgress();
            i = new createjs.ErrorEvent("FILE_LOAD_ERROR", null, t.getItem());
            this._sendError(i);
            this.stopOnError ? this.setPaused(!0) : (this._removeLoadItem(t), this._cleanLoadItem(t), this._loadNext())
        };
        n._handleFileComplete = function(n) {
            var t = n.target,
                r = t.getItem(),
                u = t.getResult(),
                i;
            this._loadedResults[r.id] = u;
            i = t.getResult(!0);
            i != null && i !== u && (this._loadedRawResults[r.id] = i);
            this._saveLoadedItems(t);
            this._removeLoadItem(t);
            this._finishOrderedItem(t) || this._processFinishedLoad(r, t);
            this._cleanLoadItem(t)
        };
        n._saveLoadedItems = function(n) {
            var r = n.getLoadedItems(),
                i, t;
            if (r !== null)
                for (i = 0; i < r.length; i++) t = r[i].item, this._loadItemsBySrc[t.src] = t, this._loadItemsById[t.id] = t, this._loadedResults[t.id] = r[i].result, this._loadedRawResults[t.id] = r[i].rawResult
        };
        n._finishOrderedItem = function(n, t) {
            var i = n.getItem(),
                r;
            return this.maintainScriptOrder && i.type == createjs.Types.JAVASCRIPT || i.maintainOrder ? (n instanceof createjs.JavaScriptLoader && (this._currentlyLoadingScript = !1), r = createjs.indexOf(this._scriptOrder, i), r == -1) ? !1 : (this._loadedScripts[r] = t === !0 ? !0 : i, this._checkScriptLoadOrder(), !0) : !1
        };
        n._checkScriptLoadOrder = function() {
            for (var n, i, r, u = this._loadedScripts.length, t = 0; t < u; t++) {
                if (n = this._loadedScripts[t], n === null) break;
                n !== !0 && (i = this._loadedResults[n.id], n.type == createjs.Types.JAVASCRIPT && createjs.DomUtils.appendToHead(i), r = n._loader, this._processFinishedLoad(n, r), this._loadedScripts[t] = !0)
            }
        };
        n._processFinishedLoad = function(n, t) {
            if (this._numItemsLoaded++, !this.maintainScriptOrder && n.type == createjs.Types.JAVASCRIPT) {
                var i = t.getTag();
                createjs.DomUtils.appendToHead(i)
            }
            this._updateProgress();
            this._sendFileComplete(n, t);
            this._loadNext()
        };
        n._canStartLoad = function(n) {
            var i, r, t, u;
            if (!this.maintainScriptOrder || n.preferXHR || (i = n.getItem(), i.type != createjs.Types.JAVASCRIPT)) return !0;
            if (this._currentlyLoadingScript) return !1;
            for (r = this._scriptOrder.indexOf(i), t = 0; t < r;) {
                if (u = this._loadedScripts[t], u == null) return !1;
                t++
            }
            return this._currentlyLoadingScript = !0, !0
        };
        n._removeLoadItem = function(n) {
            for (var i = this._currentLoads.length, t = 0; t < i; t++)
                if (this._currentLoads[t] == n) {
                    this._currentLoads.splice(t, 1);
                    break
                }
        };
        n._cleanLoadItem = function(n) {
            var t = n.getItem();
            t && delete t._loader
        };
        n._handleProgress = function(n) {
            var t = n.target;
            this._sendFileProgress(t.getItem(), t.progress);
            this._updateProgress()
        };
        n._updateProgress = function() {
            var n = this._numItemsLoaded / this._numItems,
                i = this._numItems - this._numItemsLoaded,
                r, t, u;
            if (i > 0) {
                for (r = 0, t = 0, u = this._currentLoads.length; t < u; t++) r += this._currentLoads[t].progress;
                n += r / i * (i / this._numItems)
            }
            this._lastProgress != n && (this._sendProgress(n), this._lastProgress = n)
        };
        n._disposeItem = function(n) {
            delete this._loadedResults[n.id];
            delete this._loadedRawResults[n.id];
            delete this._loadItemsById[n.id];
            delete this._loadItemsBySrc[n.src]
        };
        n._sendFileProgress = function(n, t) {
            if (!this._isCanceled() && !this._paused && this.hasEventListener("fileprogress")) {
                var i = new createjs.Event("fileprogress");
                i.progress = t;
                i.loaded = t;
                i.total = 1;
                i.item = n;
                this.dispatchEvent(i)
            }
        };
        n._sendFileComplete = function(n, t) {
            if (!this._isCanceled() && !this._paused) {
                var i = new createjs.Event("fileload");
                i.loader = t;
                i.item = n;
                i.result = this._loadedResults[n.id];
                i.rawResult = this._loadedRawResults[n.id];
                n.completeHandler && n.completeHandler(i);
                this.hasEventListener("fileload") && this.dispatchEvent(i)
            }
        };
        n._sendFileStart = function(n) {
            var t = new createjs.Event("filestart");
            t.item = n;
            this.hasEventListener("filestart") && this.dispatchEvent(t)
        };
        n.toString = function() {
            return "[PreloadJS LoadQueue]"
        };
        createjs.LoadQueue = createjs.promote(i, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n) {
            this.AbstractLoader_constructor(n, !0, createjs.Types.TEXT)
        }
        var i = createjs.extend(n, createjs.AbstractLoader),
            t = n;
        t.canLoadItem = function(n) {
            return n.type == createjs.Types.TEXT
        };
        createjs.TextLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n) {
            this.AbstractLoader_constructor(n, !0, createjs.Types.BINARY);
            this.on("initialize", this._updateXHR, this)
        }
        var t = createjs.extend(n, createjs.AbstractLoader),
            i = n;
        i.canLoadItem = function(n) {
            return n.type == createjs.Types.BINARY
        };
        t._updateXHR = function(n) {
            n.loader.setResponseType("arraybuffer")
        };
        createjs.BinaryLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.CSS);
            this.resultFormatter = this._formatResult;
            this._tagSrcAttribute = "href";
            this._tag = t ? createjs.Elements.style() : createjs.Elements.link();
            this._tag.rel = "stylesheet";
            this._tag.type = "text/css"
        }
        var t = createjs.extend(n, createjs.AbstractLoader),
            i = n;
        i.canLoadItem = function(n) {
            return n.type == createjs.Types.CSS
        };
        t._formatResult = function(n) {
            var t, i;
            return this._preferXHR ? (t = n.getTag(), t.styleSheet ? t.styleSheet.cssText = n.getResult(!0) : (i = createjs.Elements.text(n.getResult(!0)), t.appendChild(i))) : t = this._tag, createjs.DomUtils.appendToHead(t), t
        };
        createjs.CSSLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractLoader_constructor(n, t, n.type);
            this._faces = {};
            this._watched = [];
            this._count = 0;
            this._watchInterval = null;
            this._loadTimeout = null;
            this._injectCSS = n.injectCSS === undefined ? !0 : n.injectCSS;
            this.dispatchEvent("initialize")
        }
        var t = createjs.extend(n, createjs.AbstractLoader);
        n.canLoadItem = function(n) {
            return n.type == createjs.Types.FONT || n.type == createjs.Types.FONTCSS
        };
        n.sampleText = "abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        n._ctx = document.createElement("canvas").getContext("2d");
        n._referenceFonts = ["serif", "monospace"];
        n.WEIGHT_REGEX = /[- ._]*(thin|normal|book|regular|medium|black|heavy|[1-9]00|(?:extra|ultra|semi|demi)?[- ._]*(?:light|bold))[- ._]*/ig;
        n.STYLE_REGEX = /[- ._]*(italic|oblique)[- ._]*/ig;
        n.FONT_FORMAT = {
            woff2: "woff2",
            woff: "woff",
            ttf: "truetype",
            otf: "truetype"
        };
        n.FONT_WEIGHT = {
            thin: 100,
            extralight: 200,
            ultralight: 200,
            light: 300,
            semilight: 300,
            demilight: 300,
            book: "normal",
            regular: "normal",
            semibold: 600,
            demibold: 600,
            extrabold: 800,
            ultrabold: 800,
            black: 900,
            heavy: 900
        };
        n.WATCH_DURATION = 10;
        t.load = function() {
            var t, n;
            if (this.type == createjs.Types.FONTCSS) {
                if (t = this._watchCSS(), !t) {
                    this.AbstractLoader_load();
                    return
                }
            } else this._item.src instanceof Array ? this._watchFontArray() : (n = this._defFromSrc(this._item.src), this._watchFont(n), this._injectStyleTag(this._cssFromDef(n)));
            this._loadTimeout = setTimeout(createjs.proxy(this._handleTimeout, this), this._item.loadTimeout);
            this.dispatchEvent("loadstart")
        };
        t._handleTimeout = function() {
            this._stopWatching();
            this.dispatchEvent(new createjs.ErrorEvent("PRELOAD_TIMEOUT"))
        };
        t._createRequest = function() {
            return this._request
        };
        t.handleEvent = function(n) {
            switch (n.type) {
                case "complete":
                    this._rawResult = n.target._response;
                    this._result = !0;
                    this._parseCSS(this._rawResult);
                    break;
                case "error":
                    this._stopWatching();
                    this.AbstractLoader_handleEvent(n)
            }
        };
        t._watchCSS = function() {
            var n = this._item.src;
            return (n instanceof HTMLStyleElement && (this._injectCSS && !n.parentNode && (document.head || document.getElementsByTagName("head")[0]).appendChild(n), this._injectCSS = !1, n = "\n" + n.textContent), n.search(/\n|\r|@font-face/i) !== -1) ? (this._parseCSS(n), !0) : (this._request = new createjs.XHRRequest(this._item), !1)
        };
        t._parseCSS = function(n) {
            for (var i = /@font-face\s*\{([^}]+)}/g, t;;) {
                if (t = i.exec(n), !t) break;
                this._watchFont(this._parseFontFace(t[1]))
            }
            this._injectStyleTag(n)
        };
        t._watchFontArray = function() {
            for (var n, r = this._item.src, u = "", t, i = r.length - 1; i >= 0; i--) n = r[i], t = typeof n == "string" ? this._defFromSrc(n) : this._defFromObj(n), this._watchFont(t), u += this._cssFromDef(t) + "\n";
            this._injectStyleTag(u)
        };
        t._injectStyleTag = function(n) {
            if (this._injectCSS) {
                var i = document.head || document.getElementsByTagName("head")[0],
                    t = document.createElement("style");
                t.type = "text/css";
                t.styleSheet ? t.styleSheet.cssText = n : t.appendChild(document.createTextNode(n));
                i.appendChild(t)
            }
        };
        t._parseFontFace = function(n) {
            var t = this._getCSSValue(n, "font-family"),
                i = this._getCSSValue(n, "src");
            return !t || !i ? null : this._defFromObj({
                family: t,
                src: i,
                style: this._getCSSValue(n, "font-style"),
                weight: this._getCSSValue(n, "font-weight")
            })
        };
        t._watchFont = function(n) {
            n && !this._faces[n.id] && (this._faces[n.id] = n, this._watched.push(n), this._count++, this._calculateReferenceSizes(n), this._startWatching())
        };
        t._startWatching = function() {
            this._watchInterval == null && (this._watchInterval = setInterval(createjs.proxy(this._watch, this), n.WATCH_DURATION))
        };
        t._stopWatching = function() {
            clearInterval(this._watchInterval);
            clearTimeout(this._loadTimeout);
            this._watchInterval = null
        };
        t._watch = function() {
            for (var t, o, r, s, u, i = this._watched, h = n._referenceFonts, e = i.length, f = e - 1; f >= 0; f--)
                for (t = i[f], o = t.refs, r = o.length - 1; r >= 0; r--)
                    if (s = this._getTextWidth(t.family + "," + h[r], t.weight, t.style), s != o[r]) {
                        u = new createjs.Event("fileload");
                        t.type = "font-family";
                        u.item = t;
                        this.dispatchEvent(u);
                        i.splice(f, 1);
                        break
                    }
            e !== i.length && (u = new createjs.ProgressEvent(this._count - i.length, this._count), this.dispatchEvent(u));
            e === 0 && (this._stopWatching(), this._sendComplete())
        };
        t._calculateReferenceSizes = function(t) {
            for (var r = n._referenceFonts, u = t.refs = [], i = 0; i < r.length; i++) u[i] = this._getTextWidth(r[i], t.weight, t.style)
        };
        t._defFromSrc = function(t) {
            var o = /[- ._]+/g,
                i = t,
                c = null,
                r, u, f, e, s, h;
            return r = i.search(/[?#]/), r !== -1 && (i = i.substr(0, r)), r = i.lastIndexOf("."), r !== -1 && (c = i.substr(r + 1), i = i.substr(0, r)), r = i.lastIndexOf("/"), r !== -1 && (i = i.substr(r + 1)), u = i, f = u.match(n.WEIGHT_REGEX), f && (f = f[0], u = u.replace(f, ""), f = f.replace(o, "").toLowerCase()), e = i.match(n.STYLE_REGEX), e && (u = u.replace(e[0], ""), e = "italic"), u = u.replace(o, ""), s = "local('" + i.replace(o, " ") + "'), url('" + t + "')", h = n.FONT_FORMAT[c], h && (s += " format('" + h + "')"), this._defFromObj({
                family: u,
                weight: n.FONT_WEIGHT[f] || f,
                style: e,
                src: s
            })
        };
        t._defFromObj = function(n) {
            var t = {
                family: n.family,
                src: n.src,
                style: n.style || "normal",
                weight: n.weight || "normal"
            };
            return t.id = t.family + ";" + t.style + ";" + t.weight, t
        };
        t._cssFromDef = function(n) {
            return "@font-face {\n\tfont-family: '" + n.family + "';\n\tfont-style: " + n.style + ";\n\tfont-weight: " + n.weight + ";\n\tsrc: " + n.src + ";\n}"
        };
        t._getTextWidth = function(t, i, r) {
            var u = n._ctx;
            return u.font = r + " " + i + " 72px " + t, u.measureText(n.sampleText).width
        };
        t._getCSSValue = function(n, t) {
            var r = new RegExp(t + ":s*([^;}]+?)s*[;}]"),
                i = r.exec(n);
            return !i || !i[1] ? null : i[1]
        };
        createjs.FontLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function t(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.IMAGE);
            this.resultFormatter = this._formatResult;
            this._tagSrcAttribute = "src";
            createjs.DomUtils.isImageTag(n) ? this._tag = n : createjs.DomUtils.isImageTag(n.src) ? this._tag = n.src : createjs.DomUtils.isImageTag(n.tag) && (this._tag = n.tag);
            this._tag != null ? this._preferXHR = !1 : this._tag = createjs.Elements.img();
            this.on("initialize", this._updateXHR, this)
        }
        var n = createjs.extend(t, createjs.AbstractLoader),
            i = t;
        i.canLoadItem = function(n) {
            return n.type == createjs.Types.IMAGE
        };
        n.load = function() {
            if (this._tag.src != "" && this._tag.complete) {
                this._sendComplete();
                return
            }
            var n = this._item.crossOrigin;
            n == !0 && (n = "Anonymous");
            n == null || createjs.URLUtils.isLocal(this._item) || (this._tag.crossOrigin = n);
            this.AbstractLoader_load()
        };
        n._updateXHR = function(n) {
            n.loader.mimeType = "text/plain; charset=x-user-defined-binary";
            n.loader.setResponseType && n.loader.setResponseType("blob")
        };
        n._formatResult = function() {
            return this._formatImage
        };
        n._formatImage = function(n, t) {
            var i = this._tag,
                r = window.URL || window.webkitURL,
                u;
            this._preferXHR && (r ? (this.getResult(!0) && (u = r.createObjectURL(this.getResult(!0)), i.src = u), i.addEventListener("load", this._cleanUpURL, !1), i.addEventListener("error", this._cleanUpURL, !1)) : i.src = this._item.src);
            i.complete ? n(i) : (i.onload = createjs.proxy(function() {
                n(this._tag);
                i.onload = i.onerror = null
            }, this), i.onerror = createjs.proxy(function(n) {
                t(new createjs.ErrorEvent("IMAGE_FORMAT", null, n));
                i.onload = i.onerror = null
            }, this))
        };
        n._cleanUpURL = function(n) {
            var t = window.URL || window.webkitURL;
            t.revokeObjectURL(n.target.src)
        };
        createjs.ImageLoader = createjs.promote(t, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.JAVASCRIPT);
            this.resultFormatter = this._formatResult;
            this._tagSrcAttribute = "src";
            this.setTag(createjs.Elements.script())
        }
        var t = createjs.extend(n, createjs.AbstractLoader),
            i = n;
        i.canLoadItem = function(n) {
            return n.type == createjs.Types.JAVASCRIPT
        };
        t._formatResult = function(n) {
            var t = n.getTag();
            return this._preferXHR && (t.text = n.getResult(!0)), t
        };
        createjs.JavaScriptLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n) {
            this.AbstractLoader_constructor(n, !0, createjs.Types.JSON);
            this.resultFormatter = this._formatResult
        }
        var t = createjs.extend(n, createjs.AbstractLoader),
            i = n;
        i.canLoadItem = function(n) {
            return n.type == createjs.Types.JSON
        };
        t._formatResult = function(n) {
            var t = null,
                r;
            try {
                t = createjs.DataUtils.parseJSON(n.getResult(!0))
            } catch (i) {
                return r = new createjs.ErrorEvent("JSON_FORMAT", null, i), this._sendError(r), i
            }
            return t
        };
        createjs.JSONLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.AbstractLoader_constructor(n, !1, createjs.Types.JSONP);
            this.setTag(createjs.Elements.script());
            this.getTag().type = "text/javascript"
        }
        var n = createjs.extend(t, createjs.AbstractLoader),
            i = t;
        i.canLoadItem = function(n) {
            return n.type == createjs.Types.JSONP
        };
        n.cancel = function() {
            this.AbstractLoader_cancel();
            this._dispose()
        };
        n.load = function() {
            if (this._item.callback == null) throw new Error("callback is required for loading JSONP requests.");
            if (window[this._item.callback] != null) throw new Error("JSONP callback '" + this._item.callback + "' already exists on window. You need to specify a different callback or re-name the current one.");
            window[this._item.callback] = createjs.proxy(this._handleLoad, this);
            createjs.DomUtils.appendToBody(this._tag);
            this._loadTimeout = setTimeout(createjs.proxy(this._handleTimeout, this), this._item.loadTimeout);
            this._tag.src = this._item.src
        };
        n._handleLoad = function(n) {
            this._result = this._rawResult = n;
            this._sendComplete();
            this._dispose()
        };
        n._handleTimeout = function() {
            this._dispose();
            this.dispatchEvent(new createjs.ErrorEvent("timeout"))
        };
        n._dispose = function() {
            createjs.DomUtils.removeChild(this._tag);
            delete window[this._item.callback];
            clearTimeout(this._loadTimeout)
        };
        createjs.JSONPLoader = createjs.promote(t, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function i(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.MANIFEST);
            this.plugins = null;
            this._manifestQueue = null
        }
        var n = createjs.extend(i, createjs.AbstractLoader),
            t = i;
        t.MANIFEST_PROGRESS = .25;
        t.canLoadItem = function(n) {
            return n.type == createjs.Types.MANIFEST
        };
        n.load = function() {
            this.AbstractLoader_load()
        };
        n._createRequest = function() {
            var n = this._item.callback;
            this._request = n != null ? new createjs.JSONPLoader(this._item) : new createjs.JSONLoader(this._item)
        };
        n.handleEvent = function(n) {
            switch (n.type) {
                case "complete":
                    this._rawResult = n.target.getResult(!0);
                    this._result = n.target.getResult();
                    this._sendProgress(t.MANIFEST_PROGRESS);
                    this._loadManifest(this._result);
                    return;
                case "progress":
                    n.loaded *= t.MANIFEST_PROGRESS;
                    this.progress = n.loaded / n.total;
                    (isNaN(this.progress) || this.progress == Infinity) && (this.progress = 0);
                    this._sendProgress(n);
                    return
            }
            this.AbstractLoader_handleEvent(n)
        };
        n.destroy = function() {
            this.AbstractLoader_destroy();
            this._manifestQueue.close()
        };
        n._loadManifest = function(n) {
            var t, i, r;
            if (n && n.manifest) {
                t = this._manifestQueue = new createjs.LoadQueue(this._preferXHR);
                t.on("fileload", this._handleManifestFileLoad, this);
                t.on("progress", this._handleManifestProgress, this);
                t.on("complete", this._handleManifestComplete, this, !0);
                t.on("error", this._handleManifestError, this, !0);
                for (i = 0, r = this.plugins.length; i < r; i++) t.installPlugin(this.plugins[i]);
                t.loadManifest(n)
            } else this._sendComplete()
        };
        n._handleManifestFileLoad = function(n) {
            n.target = null;
            this.dispatchEvent(n)
        };
        n._handleManifestComplete = function() {
            this._loadedItems = this._manifestQueue.getItems(!0);
            this._sendComplete()
        };
        n._handleManifestProgress = function(n) {
            this.progress = n.progress * (1 - t.MANIFEST_PROGRESS) + t.MANIFEST_PROGRESS;
            this._sendProgress(this.progress)
        };
        n._handleManifestError = function(n) {
            var t = new createjs.Event("fileerror");
            t.item = n.data;
            this.dispatchEvent(t)
        };
        createjs.ManifestLoader = createjs.promote(i, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractMediaLoader_constructor(n, t, createjs.Types.SOUND);
            createjs.DomUtils.isAudioTag(n) ? this._tag = n : createjs.DomUtils.isAudioTag(n.src) ? this._tag = n : createjs.DomUtils.isAudioTag(n.tag) && (this._tag = createjs.DomUtils.isAudioTag(n) ? n : n.src);
            this._tag != null && (this._preferXHR = !1)
        }
        var t = createjs.extend(n, createjs.AbstractMediaLoader),
            i = n;
        i.canLoadItem = function(n) {
            return n.type == createjs.Types.SOUND
        };
        t._createTag = function(n) {
            var t = createjs.Elements.audio();
            return t.autoplay = !1, t.preload = "none", t.src = n, t
        };
        createjs.SoundLoader = createjs.promote(n, "AbstractMediaLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractMediaLoader_constructor(n, t, createjs.Types.VIDEO);
            createjs.DomUtils.isVideoTag(n) || createjs.DomUtils.isVideoTag(n.src) ? (this.setTag(createjs.DomUtils.isVideoTag(n) ? n : n.src), this._preferXHR = !1) : this.setTag(this._createTag())
        }
        var t = createjs.extend(n, createjs.AbstractMediaLoader),
            i = n;
        t._createTag = function() {
            return createjs.Elements.video()
        };
        i.canLoadItem = function(n) {
            return n.type == createjs.Types.VIDEO
        };
        createjs.VideoLoader = createjs.promote(n, "AbstractMediaLoader")
    }(),
    function() {
        "use strict";

        function i(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.SPRITESHEET);
            this._manifestQueue = null
        }
        var n = createjs.extend(i, createjs.AbstractLoader),
            t = i;
        t.SPRITESHEET_PROGRESS = .25;
        t.canLoadItem = function(n) {
            return n.type == createjs.Types.SPRITESHEET
        };
        n.destroy = function() {
            this.AbstractLoader_destroy();
            this._manifestQueue.close()
        };
        n._createRequest = function() {
            var n = this._item.callback;
            this._request = n != null ? new createjs.JSONPLoader(this._item) : new createjs.JSONLoader(this._item)
        };
        n.handleEvent = function(n) {
            switch (n.type) {
                case "complete":
                    this._rawResult = n.target.getResult(!0);
                    this._result = n.target.getResult();
                    this._sendProgress(t.SPRITESHEET_PROGRESS);
                    this._loadManifest(this._result);
                    return;
                case "progress":
                    n.loaded *= t.SPRITESHEET_PROGRESS;
                    this.progress = n.loaded / n.total;
                    (isNaN(this.progress) || this.progress == Infinity) && (this.progress = 0);
                    this._sendProgress(n);
                    return
            }
            this.AbstractLoader_handleEvent(n)
        };
        n._loadManifest = function(n) {
            if (n && n.images) {
                var t = this._manifestQueue = new createjs.LoadQueue(this._preferXHR, this._item.path, this._item.crossOrigin);
                t.on("complete", this._handleManifestComplete, this, !0);
                t.on("fileload", this._handleManifestFileLoad, this);
                t.on("progress", this._handleManifestProgress, this);
                t.on("error", this._handleManifestError, this, !0);
                t.loadManifest(n.images)
            }
        };
        n._handleManifestFileLoad = function(n) {
            var i = n.result,
                t, r;
            i != null && (t = this.getResult().images, r = t.indexOf(n.item.src), t[r] = i)
        };
        n._handleManifestComplete = function() {
            this._result = new createjs.SpriteSheet(this._result);
            this._loadedItems = this._manifestQueue.getItems(!0);
            this._sendComplete()
        };
        n._handleManifestProgress = function(n) {
            this.progress = n.progress * (1 - t.SPRITESHEET_PROGRESS) + t.SPRITESHEET_PROGRESS;
            this._sendProgress(this.progress)
        };
        n._handleManifestError = function(n) {
            var t = new createjs.Event("fileerror");
            t.item = n.data;
            this.dispatchEvent(t)
        };
        createjs.SpriteSheetLoader = createjs.promote(i, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.SVG);
            this.resultFormatter = this._formatResult;
            this._tagSrcAttribute = "data";
            t ? this.setTag(createjs.Elements.svg()) : (this.setTag(createjs.Elements.object()), this.getTag().type = "image/svg+xml")
        }
        var t = createjs.extend(n, createjs.AbstractLoader),
            i = n;
        i.canLoadItem = function(n) {
            return n.type == createjs.Types.SVG
        };
        t._formatResult = function(n) {
            var r = createjs.DataUtils.parseXML(n.getResult(!0)),
                t = n.getTag(),
                i;
            return !this._preferXHR && document.body.contains(t) && document.body.removeChild(t), r.documentElement != null ? (i = r.documentElement, document.importNode && (i = document.importNode(i, !0)), t.appendChild(i), t) : r
        };
        createjs.SVGLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n) {
            this.AbstractLoader_constructor(n, !0, createjs.Types.XML);
            this.resultFormatter = this._formatResult
        }
        var t = createjs.extend(n, createjs.AbstractLoader),
            i = n;
        i.canLoadItem = function(n) {
            return n.type == createjs.Types.XML
        };
        t._formatResult = function(n) {
            return createjs.DataUtils.parseXML(n.getResult(!0))
        };
        createjs.XMLLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        var n = createjs.SoundJS = createjs.SoundJS || {};
        n.version = "NEXT";
        n.buildDate = "Thu, 14 Sep 2017 22:19:45 GMT"
    }(),
    function() {
        "use strict";

        function n() {
            throw "BrowserDetect cannot be instantiated";
        }
        var t = n.agent = window.navigator.userAgent;
        n.isWindowPhone = t.indexOf("IEMobile") > -1 || t.indexOf("Windows Phone") > -1;
        n.isFirefox = t.indexOf("Firefox") > -1;
        n.isOpera = window.opera != null;
        n.isChrome = t.indexOf("Chrome") > -1;
        n.isIOS = (t.indexOf("iPod") > -1 || t.indexOf("iPhone") > -1 || t.indexOf("iPad") > -1) && !n.isWindowPhone;
        n.isAndroid = t.indexOf("Android") > -1 && !n.isWindowPhone;
        n.isBlackberry = t.indexOf("Blackberry") > -1;
        n.isEdge = t.indexOf("Edg") > -1;
        createjs.BrowserDetect = n
    }(),
    function() {
        "use strict";
        var t = function() {
                this.interrupt = null;
                this.delay = null;
                this.offset = null;
                this.loop = null;
                this.volume = null;
                this.pan = null;
                this.startTime = null;
                this.duration = null
            },
            i = t.prototype = {},
            n = t;
        n.create = function(t) {
            if (typeof t == "string") return console && (console.warn || console.log)("Deprecated behaviour. Sound.play takes a configuration object instead of individual arguments. See docs for info."), (new createjs.PlayPropsConfig).set({
                interrupt: t
            });
            if (t == null || t instanceof n || t instanceof Object) return (new createjs.PlayPropsConfig).set(t);
            if (t == null) throw new Error("PlayProps configuration not recognized.");
        };
        i.set = function(n) {
            if (n != null)
                for (var t in n) this[t] = n[t];
            return this
        };
        i.toString = function() {
            return "[PlayPropsConfig]"
        };
        createjs.PlayPropsConfig = n
    }(),
    function() {
        "use strict";

        function r() {
            throw "Sound cannot be instantiated";
        }

        function t(n, t) {
            this.init(n, t)
        }
        var n = r,
            i;
        n.INTERRUPT_ANY = "any";
        n.INTERRUPT_EARLY = "early";
        n.INTERRUPT_LATE = "late";
        n.INTERRUPT_NONE = "none";
        n.PLAY_INITED = "playInited";
        n.PLAY_SUCCEEDED = "playSucceeded";
        n.PLAY_INTERRUPTED = "playInterrupted";
        n.PLAY_FINISHED = "playFinished";
        n.PLAY_FAILED = "playFailed";
        n.SUPPORTED_EXTENSIONS = ["mp3", "ogg", "opus", "mpeg", "wav", "m4a", "mp4", "aiff", "wma", "mid"];
        n.EXTENSION_MAP = {
            m4a: "mp4"
        };
        n.FILE_PATTERN = /^(?:(\w+:)\/{2}(\w+(?:\.\w+)*\/?))?([/.]*?(?:[^?]+)?\/)?((?:[^/?]+)\.(\w+))(?:\?(\S+)?)?$/;
        n.defaultInterruptBehavior = n.INTERRUPT_NONE;
        n.alternateExtensions = [];
        n.activePlugin = null;
        n._masterVolume = 1;
        n._getMasterVolume = function() {
            return this._masterVolume
        };
        n.getVolume = createjs.deprecate(n._getMasterVolume, "Sound.getVolume");
        n._setMasterVolume = function(t) {
            var r, i, u;
            if (Number(t) != null && (t = Math.max(0, Math.min(1, t)), n._masterVolume = t, !this.activePlugin || !this.activePlugin.setVolume || !this.activePlugin.setVolume(t)))
                for (r = this._instances, i = 0, u = r.length; i < u; i++) r[i].setMasterVolume(t)
        };
        n.setVolume = createjs.deprecate(n._setMasterVolume, "Sound.setVolume");
        n._masterMute = !1;
        n._getMute = function() {
            return this._masterMute
        };
        n.getMute = createjs.deprecate(n._getMute, "Sound.getMute");
        n._setMute = function(n) {
            var i, t, r;
            if (n != null && (this._masterMute = n, !this.activePlugin || !this.activePlugin.setMute || !this.activePlugin.setMute(n)))
                for (i = this._instances, t = 0, r = i.length; t < r; t++) i[t].setMasterMute(n)
        };
        n.setMute = createjs.deprecate(n._setMute, "Sound.setMute");
        n._getCapabilities = function() {
            return n.activePlugin == null ? null : n.activePlugin._capabilities
        };
        n.getCapabilities = createjs.deprecate(n._getCapabilities, "Sound.getCapabilities");
        Object.defineProperties(n, {
            volume: {
                get: n._getMasterVolume,
                set: n._setMasterVolume
            },
            muted: {
                get: n._getMute,
                set: n._setMute
            },
            capabilities: {
                get: n._getCapabilities
            }
        });
        n._pluginsRegistered = !1;
        n._lastID = 0;
        n._instances = [];
        n._idHash = {};
        n._preloadHash = {};
        n._defaultPlayPropsHash = {};
        n.addEventListener = null;
        n.removeEventListener = null;
        n.removeAllEventListeners = null;
        n.dispatchEvent = null;
        n.hasEventListener = null;
        n._listeners = null;
        createjs.EventDispatcher.initialize(n);
        n.getPreloadHandlers = function() {
            return {
                callback: createjs.proxy(n.initLoad, n),
                types: ["sound"],
                extensions: n.SUPPORTED_EXTENSIONS
            }
        };
        n._handleLoadComplete = function(t) {
            var u = t.target.getItem().src,
                i, f, r, t;
            if (n._preloadHash[u])
                for (i = 0, f = n._preloadHash[u].length; i < f; i++)(r = n._preloadHash[u][i], n._preloadHash[u][i] = !0, n.hasEventListener("fileload")) && (t = new createjs.Event("fileload"), t.src = r.src, t.id = r.id, t.data = r.data, t.sprite = r.sprite, n.dispatchEvent(t))
        };
        n._handleLoadError = function(t) {
            var u = t.target.getItem().src,
                i, f, r, t;
            if (n._preloadHash[u])
                for (i = 0, f = n._preloadHash[u].length; i < f; i++)(r = n._preloadHash[u][i], n._preloadHash[u][i] = !1, n.hasEventListener("fileerror")) && (t = new createjs.Event("fileerror"), t.src = r.src, t.id = r.id, t.data = r.data, t.sprite = r.sprite, n.dispatchEvent(t))
        };
        n._registerPlugin = function(t) {
            return t.isSupported() ? (n.activePlugin = new t, !0) : !1
        };
        n.registerPlugins = function(t) {
            n._pluginsRegistered = !0;
            for (var i = 0, r = t.length; i < r; i++)
                if (n._registerPlugin(t[i])) return !0;
            return !1
        };
        n.initializeDefaultPlugins = function() {
            return n.activePlugin != null ? !0 : n._pluginsRegistered ? !1 : n.registerPlugins([createjs.WebAudioPlugin, createjs.HTMLAudioPlugin]) ? !0 : !1
        };
        n.isReady = function() {
            return n.activePlugin != null
        };
        n.initLoad = function(t) {
            return t.type == "video" ? !0 : n._registerSound(t)
        };
        n._registerSound = function(i) {
            var f, r, e, u, s, o;
            if (!n.initializeDefaultPlugins() || (i.src instanceof Object ? (f = n._parseSrc(i.src), f.src = i.path + f.src) : f = n._parsePath(i.src), f == null)) return !1;
            if (i.src = f.src, i.type = "sound", r = i.data, e = null, r != null && (isNaN(r.channels) ? isNaN(r) || (e = parseInt(r)) : e = parseInt(r.channels), r.audioSprite))
                for (s = r.audioSprite.length; s--;) u = r.audioSprite[s], n._idHash[u.id] = {
                    src: i.src,
                    startTime: parseInt(u.startTime),
                    duration: parseInt(u.duration)
                }, u.defaultPlayProps && (n._defaultPlayPropsHash[u.id] = createjs.PlayPropsConfig.create(u.defaultPlayProps));
            return i.id != null && (n._idHash[i.id] = {
                src: i.src
            }), o = n.activePlugin.register(i), t.create(i.src, e), r != null && isNaN(r) ? i.data.channels = e || t.maxPerChannel() : i.data = e || t.maxPerChannel(), o.type && (i.type = o.type), i.defaultPlayProps && (n._defaultPlayPropsHash[i.src] = createjs.PlayPropsConfig.create(i.defaultPlayProps)), o
        };
        n.registerSound = function(t, i, r, u, f) {
            var e = {
                    src: t,
                    id: i,
                    data: r,
                    defaultPlayProps: f
                },
                o;
            if (t instanceof Object && t.src && (u = i, e = t), e = createjs.LoadItem.create(e), e.path = u, u == null || e.src instanceof Object || (e.src = u + e.src), o = n._registerSound(e), !o) return !1;
            if (n._preloadHash[e.src] || (n._preloadHash[e.src] = []), n._preloadHash[e.src].push(e), n._preloadHash[e.src].length == 1) {
                o.on("complete", this._handleLoadComplete, this);
                o.on("error", this._handleLoadError, this);
                n.activePlugin.preload(o)
            } else if (n._preloadHash[e.src][0] == !0) return !0;
            return e
        };
        n.registerSounds = function(n, t) {
            var r = [],
                i, u;
            for (n.path && (t = t ? t + n.path : n.path, n = n.manifest), i = 0, u = n.length; i < u; i++) r[i] = createjs.Sound.registerSound(n[i].src, n[i].id, n[i].data, t, n[i].defaultPlayProps);
            return r
        };
        n.removeSound = function(i, r) {
            var u, f;
            if (n.activePlugin == null || (i instanceof Object && i.src && (i = i.src), i instanceof Object ? u = n._parseSrc(i) : (i = n._getSrcById(i).src, u = n._parsePath(i)), u == null)) return !1;
            i = u.src;
            r != null && (i = r + i);
            for (f in n._idHash) n._idHash[f].src == i && delete n._idHash[f];
            return t.removeSrc(i), delete n._preloadHash[i], n.activePlugin.removeSound(i), !0
        };
        n.removeSounds = function(n, t) {
            var r = [],
                i, u;
            for (n.path && (t = t ? t + n.path : n.path, n = n.manifest), i = 0, u = n.length; i < u; i++) r[i] = createjs.Sound.removeSound(n[i].src, t);
            return r
        };
        n.removeAllSounds = function() {
            n._idHash = {};
            n._preloadHash = {};
            t.removeAll();
            n.activePlugin && n.activePlugin.removeAllSounds()
        };
        n.loadComplete = function(t) {
            if (!n.isReady()) return !1;
            var i = n._parsePath(t);
            return (t = i ? n._getSrcById(i.src).src : n._getSrcById(t).src, n._preloadHash[t] == undefined) ? !1 : n._preloadHash[t][0] == !0
        };
        n._parsePath = function(t) {
            var i;
            if (typeof t != "string" && (t = t.toString()), i = t.match(n.FILE_PATTERN), i == null) return !1;
            for (var f = i[4], r = i[5], e = n.capabilities, u = 0; !e[r];)
                if (r = n.alternateExtensions[u++], u > n.alternateExtensions.length) return null;
            return t = t.replace("." + i[5], "." + r), {
                name: f,
                src: t,
                extension: r
            }
        };
        n._parseSrc = function(t) {
            var i = {
                    name: undefined,
                    src: undefined,
                    extension: undefined
                },
                f = n.capabilities,
                r, u;
            for (r in t)
                if (t.hasOwnProperty(r) && f[r]) {
                    i.src = t[r];
                    i.extension = r;
                    break
                }
            return i.src ? (u = i.src.lastIndexOf("/"), i.name = u != -1 ? i.src.slice(u + 1) : i.src, i) : !1
        };
        n.play = function(t, i) {
            var r, f, u, e;
            return createjs.WebAudioPlugin && createjs.WebAudioPlugin.context && (r = createjs.WebAudioPlugin.context, (r.state === "interrupted" || r.state === "suspended") && r.resume()), f = createjs.PlayPropsConfig.create(i), u = n.createInstance(t, f.startTime, f.duration), r && (u.audioCtx = r), e = n._playInstance(u, f), e || u._playFailed(), u
        };
        n.createInstance = function(i, r, u) {
            var o, f, e;
            return n.initializeDefaultPlugins() ? (o = n._defaultPlayPropsHash[i], i = n._getSrcById(i), f = n._parsePath(i.src), e = null, f != null && f.src != null ? (t.create(f.src), r == null && (r = i.startTime), e = n.activePlugin.create(f.src, r, u || i.duration), o = o || n._defaultPlayPropsHash[f.src], o && e.applyPlayProps(o)) : e = new createjs.DefaultSoundInstance(i, r, u), e.uniqueId = n._lastID++, e) : new createjs.DefaultSoundInstance(i, r, u)
        };
        n.stop = function() {
            for (var n = this._instances, t = n.length; t--;) n[t].stop()
        };
        n.setDefaultPlayProps = function(t, i) {
            t = n._getSrcById(t);
            n._defaultPlayPropsHash[n._parsePath(t.src).src] = createjs.PlayPropsConfig.create(i)
        };
        n.getDefaultPlayProps = function(t) {
            return t = n._getSrcById(t), n._defaultPlayPropsHash[n._parsePath(t.src).src]
        };
        n._playInstance = function(t, i) {
            var r = n._defaultPlayPropsHash[t.src] || {},
                u, f;
            if (i.interrupt == null && (i.interrupt = r.interrupt || n.defaultInterruptBehavior), i.delay == null && (i.delay = r.delay || 0), i.offset == null && (i.offset = t.position), i.loop == null && (i.loop = t.loop), i.volume == null && (i.volume = t.volume), i.pan == null && (i.pan = t.pan), i.delay == 0) {
                if (u = n._beginPlaying(t, i), !u) return !1
            } else f = setTimeout(function() {
                n._beginPlaying(t, i)
            }, i.delay), t.delayTimeoutId = f;
            return this._instances.push(t), !0
        };
        n._beginPlaying = function(n, i) {
            var u, r;
            return t.add(n, i.interrupt) ? (u = n._beginPlaying(i), !u) ? (r = createjs.indexOf(this._instances, n), r > -1 && this._instances.splice(r, 1), !1) : !0 : !1
        };
        n._getSrcById = function(t) {
            return n._idHash[t] || {
                src: t
            }
        };
        n._playFinished = function(n) {
            t.remove(n);
            var i = createjs.indexOf(this._instances, n);
            i > -1 && this._instances.splice(i, 1)
        };
        createjs.Sound = r;
        t.channels = {};
        t.create = function(n, i) {
            var r = t.get(n);
            return r == null ? (t.channels[n] = new t(n, i), !0) : !1
        };
        t.removeSrc = function(n) {
            var i = t.get(n);
            return i == null ? !1 : (i._removeAll(), delete t.channels[n], !0)
        };
        t.removeAll = function() {
            for (var n in t.channels) t.channels[n]._removeAll();
            t.channels = {}
        };
        t.add = function(n, i) {
            var r = t.get(n.src);
            return r == null ? !1 : r._add(n, i)
        };
        t.remove = function(n) {
            var i = t.get(n.src);
            return i == null ? !1 : (i._remove(n), !0)
        };
        t.maxPerChannel = function() {
            return i.maxDefault
        };
        t.get = function(n) {
            return t.channels[n]
        };
        i = t.prototype;
        i.constructor = t;
        i.src = null;
        i.max = null;
        i.maxDefault = 100;
        i.length = 0;
        i.init = function(n, t) {
            this.src = n;
            this.max = t || this.maxDefault;
            this.max == -1 && (this.max = this.maxDefault);
            this._instances = []
        };
        i._get = function(n) {
            return this._instances[n]
        };
        i._add = function(n, t) {
            return this._getSlot(t, n) ? (this._instances.push(n), this.length++, !0) : !1
        };
        i._remove = function(n) {
            var t = createjs.indexOf(this._instances, n);
            return t == -1 ? !1 : (this._instances.splice(t, 1), this.length--, !0)
        };
        i._removeAll = function() {
            for (var n = this.length - 1; n >= 0; n--) this._instances[n].stop()
        };
        i._getSlot = function(n) {
            var t, i, u, f;
            if (n != r.INTERRUPT_NONE && (i = this._get(0), i == null)) return !0;
            for (u = 0, f = this.max; u < f; u++) {
                if (t = this._get(u), t == null) return !0;
                if (t.playState == r.PLAY_FINISHED || t.playState == r.PLAY_INTERRUPTED || t.playState == r.PLAY_FAILED) {
                    i = t;
                    break
                }
                n != r.INTERRUPT_NONE && (n == r.INTERRUPT_EARLY && t.position < i.position || n == r.INTERRUPT_LATE && t.position > i.position) && (i = t)
            }
            return i != null ? (i._interrupt(), this._remove(i), !0) : !1
        };
        i.toString = function() {
            return "[Sound SoundChannel]"
        }
    }(),
    function() {
        "use strict";
        var t = function(n, t, i, r) {
                this.EventDispatcher_constructor();
                this.src = n;
                this.uniqueId = -1;
                this.playState = null;
                this.delayTimeoutId = null;
                this._volume = 1;
                Object.defineProperty(this, "volume", {
                    get: this._getVolume,
                    set: this._setVolume
                });
                this._pan = 0;
                Object.defineProperty(this, "pan", {
                    get: this._getPan,
                    set: this._setPan
                });
                this._startTime = Math.max(0, t || 0);
                Object.defineProperty(this, "startTime", {
                    get: this._getStartTime,
                    set: this._setStartTime
                });
                this._duration = Math.max(0, i || 0);
                Object.defineProperty(this, "duration", {
                    get: this._getDuration,
                    set: this._setDuration
                });
                this._playbackResource = null;
                Object.defineProperty(this, "playbackResource", {
                    get: this._getPlaybackResource,
                    set: this._setPlaybackResource
                });
                r !== !1 && r !== !0 && this._setPlaybackResource(r);
                this._position = 0;
                Object.defineProperty(this, "position", {
                    get: this._getPosition,
                    set: this._setPosition
                });
                this._loop = 0;
                Object.defineProperty(this, "loop", {
                    get: this._getLoop,
                    set: this._setLoop
                });
                this._muted = !1;
                Object.defineProperty(this, "muted", {
                    get: this._getMuted,
                    set: this._setMuted
                });
                this._paused = !1;
                Object.defineProperty(this, "paused", {
                    get: this._getPaused,
                    set: this._setPaused
                })
            },
            n = createjs.extend(t, createjs.EventDispatcher);
        n.play = function(n) {
            var t = createjs.PlayPropsConfig.create(n);
            if (this.playState == createjs.Sound.PLAY_SUCCEEDED) {
                this.applyPlayProps(t);
                this._paused && this._setPaused(!1);
                return
            }
            return this._cleanUp(), createjs.Sound._playInstance(this, t), this
        };
        n.stop = function() {
            return this._position = 0, this._paused = !1, this._handleStop(), this._cleanUp(), this.playState = createjs.Sound.PLAY_FINISHED, this
        };
        n.destroy = function() {
            this._cleanUp();
            this.src = null;
            this.playbackResource = null;
            this.removeAllEventListeners()
        };
        n.applyPlayProps = function(n) {
            return n.offset != null && this._setPosition(n.offset), n.loop != null && this._setLoop(n.loop), n.volume != null && this._setVolume(n.volume), n.pan != null && this._setPan(n.pan), n.startTime != null && (this._setStartTime(n.startTime), this._setDuration(n.duration)), this
        };
        n.toString = function() {
            return "[AbstractSoundInstance]"
        };
        n._getPaused = function() {
            return this._paused
        };
        n._setPaused = function(n) {
            if ((n === !0 || n === !1) && this._paused != n) return n == !0 && this.playState != createjs.Sound.PLAY_SUCCEEDED ? void 0 : (this._paused = n, n ? this._pause() : this._resume(), clearTimeout(this.delayTimeoutId), this)
        };
        n._setVolume = function(n) {
            return n == this._volume ? this : (this._volume = Math.max(0, Math.min(1, n)), this._muted || this._updateVolume(), this)
        };
        n._getVolume = function() {
            return this._volume
        };
        n._setMuted = function(n) {
            if (n === !0 || n === !1) return this._muted = n, this._updateVolume(), this
        };
        n._getMuted = function() {
            return this._muted
        };
        n._setPan = function(n) {
            return n == this._pan ? this : (this._pan = Math.max(-1, Math.min(1, n)), this._updatePan(), this)
        };
        n._getPan = function() {
            return this._pan
        };
        n._getPosition = function() {
            return this._paused || this.playState != createjs.Sound.PLAY_SUCCEEDED || (this._position = this._calculateCurrentPosition()), this._position
        };
        n._setPosition = function(n) {
            return this._position = Math.max(0, n), this.playState == createjs.Sound.PLAY_SUCCEEDED && this._updatePosition(), this
        };
        n._getStartTime = function() {
            return this._startTime
        };
        n._setStartTime = function(n) {
            return n == this._startTime ? this : (this._startTime = Math.max(0, n || 0), this._updateStartTime(), this)
        };
        n._getDuration = function() {
            return this._duration
        };
        n._setDuration = function(n) {
            return n == this._duration ? this : (this._duration = Math.max(0, n || 0), this._updateDuration(), this)
        };
        n._setPlaybackResource = function(n) {
            return this._playbackResource = n, this._duration == 0 && this._playbackResource && this._setDurationFromSource(), this
        };
        n._getPlaybackResource = function() {
            return this._playbackResource
        };
        n._getLoop = function() {
            return this._loop
        };
        n._setLoop = function(n) {
            this._playbackResource != null && (this._loop != 0 && n == 0 ? this._removeLooping(n) : this._loop == 0 && n != 0 && this._addLooping(n));
            this._loop = n
        };
        n._sendEvent = function(n) {
            var t = new createjs.Event(n);
            this.dispatchEvent(t)
        };
        n._cleanUp = function() {
            clearTimeout(this.delayTimeoutId);
            this._handleCleanUp();
            this._paused = !1;
            createjs.Sound._playFinished(this)
        };
        n._interrupt = function() {
            this._cleanUp();
            this.playState = createjs.Sound.PLAY_INTERRUPTED;
            this._sendEvent("interrupted")
        };
        n._beginPlaying = function(n) {
            return this._setPosition(n.offset), this._setLoop(n.loop), this._setVolume(n.volume), this._setPan(n.pan), n.startTime != null && (this._setStartTime(n.startTime), this._setDuration(n.duration)), this._playbackResource != null && this._position < this._duration ? (this._paused = !1, this._handleSoundReady(), this.playState = createjs.Sound.PLAY_SUCCEEDED, this._sendEvent("succeeded"), !0) : (this._playFailed(), !1)
        };
        n._playFailed = function() {
            this._cleanUp();
            this.playState = createjs.Sound.PLAY_FAILED;
            this._sendEvent("failed")
        };
        n._handleSoundComplete = function() {
            if (this._position = 0, this._loop != 0) {
                this._loop--;
                this._handleLoop();
                this._sendEvent("loop");
                return
            }
            this._cleanUp();
            this.playState = createjs.Sound.PLAY_FINISHED;
            this._sendEvent("complete")
        };
        n._handleSoundReady = function() {};
        n._updateVolume = function() {};
        n._updatePan = function() {};
        n._updateStartTime = function() {};
        n._updateDuration = function() {};
        n._setDurationFromSource = function() {};
        n._calculateCurrentPosition = function() {};
        n._updatePosition = function() {};
        n._removeLooping = function() {};
        n._addLooping = function() {};
        n._pause = function() {};
        n._resume = function() {};
        n._handleStop = function() {};
        n._handleCleanUp = function() {};
        n._handleLoop = function() {};
        createjs.AbstractSoundInstance = createjs.promote(t, "EventDispatcher");
        createjs.DefaultSoundInstance = createjs.AbstractSoundInstance
    }(),
    function() {
        "use strict";
        var t = function() {
                this._capabilities = null;
                this._loaders = {};
                this._audioSources = {};
                this._soundInstances = {};
                this._volume = 1;
                this._loaderClass;
                this._soundInstanceClass
            },
            n = t.prototype;
        t._capabilities = null;
        t.isSupported = function() {
            return !0
        };
        n.register = function(n) {
            var t = this._loaders[n.src];
            if (t && !t.canceled) return this._loaders[n.src];
            this._audioSources[n.src] = !0;
            this._soundInstances[n.src] = [];
            t = new this._loaderClass(n);
            t.on("complete", this._handlePreloadComplete, this);
            return this._loaders[n.src] = t, t
        };
        n.preload = function(n) {
            n.on("error", this._handlePreloadError, this);
            n.load()
        };
        n.isPreloadStarted = function(n) {
            return this._audioSources[n] != null
        };
        n.isPreloadComplete = function(n) {
            return !(this._audioSources[n] == null || this._audioSources[n] == !0)
        };
        n.removeSound = function(n) {
            var t, i;
            if (this._soundInstances[n]) {
                for (t = this._soundInstances[n].length; t--;) i = this._soundInstances[n][t], i.destroy();
                delete this._soundInstances[n];
                delete this._audioSources[n];
                this._loaders[n] && this._loaders[n].destroy();
                delete this._loaders[n]
            }
        };
        n.removeAllSounds = function() {
            for (var n in this._audioSources) this.removeSound(n)
        };
        n.create = function(n, t, i) {
            this.isPreloadStarted(n) || this.preload(this.register(n));
            var r = new this._soundInstanceClass(n, t, i, this._audioSources[n]);
            return this._soundInstances[n] && this._soundInstances[n].push(r), r.setMasterVolume && r.setMasterVolume(createjs.Sound.volume), r.setMasterMute && r.setMasterMute(createjs.Sound.muted), r
        };
        n.setVolume = function(n) {
            return this._volume = n, this._updateVolume(), !0
        };
        n.getVolume = function() {
            return this._volume
        };
        n.setMute = function() {
            return this._updateVolume(), !0
        };
        n.toString = function() {
            return "[AbstractPlugin]"
        };
        n._handlePreloadComplete = function(n) {
            var t = n.target.getItem().src,
                i, r, u;
            for (this._audioSources[t] = n.result, i = 0, r = this._soundInstances[t].length; i < r; i++) u = this._soundInstances[t][i], u.setPlaybackResource(this._audioSources[t]), this._soundInstances[t] = null
        };
        n._handlePreloadError = function() {};
        n._updateVolume = function() {};
        createjs.AbstractPlugin = t
    }(),
    function() {
        "use strict";

        function n(n) {
            this.AbstractLoader_constructor(n, !0, createjs.Types.SOUND)
        }
        var t = createjs.extend(n, createjs.AbstractLoader);
        n.context = null;
        t.toString = function() {
            return "[WebAudioLoader]"
        };
        t._createRequest = function() {
            this._request = new createjs.XHRRequest(this._item, !1);
            this._request.setResponseType("arraybuffer")
        };
        t._sendComplete = function() {
            n.context.decodeAudioData(this._rawResult, createjs.proxy(this._handleAudioDecoded, this), createjs.proxy(this._sendError, this))
        };
        t._handleAudioDecoded = function(n) {
            this._result = n;
            this.AbstractLoader__sendComplete()
        };
        createjs.WebAudioLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function i(n, i, r, u) {
            this.AbstractSoundInstance_constructor(n, i, r, u);
            this.gainNode = t.context.createGain();
            this.panNode = t.context.createPanner();
            this.panNode.panningModel = t._panningModel;
            this.panNode.connect(this.gainNode);
            this._updatePan();
            this.sourceNode = null;
            this._soundCompleteTimeout = null;
            this._sourceNodeNext = null;
            this._playbackStartTime = 0;
            this._endedHandler = createjs.proxy(this._handleSoundComplete, this)
        }
        var n = createjs.extend(i, createjs.AbstractSoundInstance),
            t = i;
        t.context = null;
        t._scratchBuffer = null;
        t.destinationNode = null;
        t._panningModel = "equalpower";
        n.destroy = function() {
            this.AbstractSoundInstance_destroy();
            this.panNode.disconnect(0);
            this.panNode = null;
            this.gainNode.disconnect(0);
            this.gainNode = null
        };
        n.toString = function() {
            return "[WebAudioSoundInstance]"
        };
        n._updatePan = function() {
            this.panNode.setPosition(this._pan, 0, -.5)
        };
        n._removeLooping = function() {
            this._sourceNodeNext = this._cleanUpAudioNode(this._sourceNodeNext)
        };
        n._addLooping = function() {
            this.playState == createjs.Sound.PLAY_SUCCEEDED && (this._sourceNodeNext = this._createAndPlayAudioNode(this._playbackStartTime, 0))
        };
        n._setDurationFromSource = function() {
            this._duration = this.playbackResource.duration * 1e3
        };
        n._handleCleanUp = function() {
            this.sourceNode && this.playState == createjs.Sound.PLAY_SUCCEEDED && (this.sourceNode = this._cleanUpAudioNode(this.sourceNode), this._sourceNodeNext = this._cleanUpAudioNode(this._sourceNodeNext));
            this.gainNode.numberOfOutputs != 0 && this.gainNode.disconnect(0);
            clearTimeout(this._soundCompleteTimeout);
            this._playbackStartTime = 0
        };
        n._cleanUpAudioNode = function(n) {
            if (n) {
                if (n.stop(0), n.disconnect(0), createjs.BrowserDetect.isIOS) try {
                    n.buffer = t._scratchBuffer
                } catch (i) {}
                n = null
            }
            return n
        };
        n._handleSoundReady = function() {
            this.gainNode.connect(t.destinationNode);
            var n = this._duration * .001,
                i = Math.min(Math.max(0, this._position) * .001, n);
            this.sourceNode = this._createAndPlayAudioNode(t.context.currentTime - n, i);
            this._playbackStartTime = this.sourceNode.startTime - i;
            this._soundCompleteTimeout = setTimeout(this._endedHandler, (n - i) * 1e3);
            this._loop != 0 && (this._sourceNodeNext = this._createAndPlayAudioNode(this._playbackStartTime, 0))
        };
        n._createAndPlayAudioNode = function(n, i) {
            var r = t.context.createBufferSource(),
                u;
            return r.buffer = this.playbackResource, r.connect(this.panNode), u = this._duration * .001, r.startTime = n + u, r.start(r.startTime, i + this._startTime * .001, u - i), r
        };
        n._pause = function() {
            this._position = (t.context.currentTime - this._playbackStartTime) * 1e3;
            this.sourceNode = this._cleanUpAudioNode(this.sourceNode);
            this._sourceNodeNext = this._cleanUpAudioNode(this._sourceNodeNext);
            this.gainNode.numberOfOutputs != 0 && this.gainNode.disconnect(0);
            clearTimeout(this._soundCompleteTimeout)
        };
        n._resume = function() {
            this._handleSoundReady()
        };
        n._updateVolume = function() {
            var n = this._muted ? 0 : this._volume;
            n != this.gainNode.gain.value && (this.gainNode.gain.value = n)
        };
        n._calculateCurrentPosition = function() {
            return (t.context.currentTime - this._playbackStartTime) * 1e3
        };
        n._updatePosition = function() {
            this.sourceNode = this._cleanUpAudioNode(this.sourceNode);
            this._sourceNodeNext = this._cleanUpAudioNode(this._sourceNodeNext);
            clearTimeout(this._soundCompleteTimeout);
            this._paused || this._handleSoundReady()
        };
        n._handleLoop = function() {
            this._cleanUpAudioNode(this.sourceNode);
            this.sourceNode = this._sourceNodeNext;
            this._playbackStartTime = this.sourceNode.startTime;
            this._sourceNodeNext = this._createAndPlayAudioNode(this._playbackStartTime, 0);
            this._soundCompleteTimeout = setTimeout(this._endedHandler, this._duration)
        };
        n._updateDuration = function() {
            this.playState == createjs.Sound.PLAY_SUCCEEDED && (this._pause(), this._resume())
        };
        createjs.WebAudioSoundInstance = createjs.promote(i, "AbstractSoundInstance")
    }(),
    function() {
        "use strict";

        function t() {
            this.AbstractPlugin_constructor();
            this._panningModel = n._panningModel;
            this.context = n.context;
            this.dynamicsCompressorNode = this.context.createDynamicsCompressor();
            this.dynamicsCompressorNode.connect(this.context.destination);
            this.gainNode = this.context.createGain();
            this.gainNode.connect(this.dynamicsCompressorNode);
            createjs.WebAudioSoundInstance.destinationNode = this.gainNode;
            this._capabilities = n._capabilities;
            this._loaderClass = createjs.WebAudioLoader;
            this._soundInstanceClass = createjs.WebAudioSoundInstance;
            this._addPropsToClasses()
        }
        var i = createjs.extend(t, createjs.AbstractPlugin),
            n = t;
        n._capabilities = null;
        n._panningModel = "equalpower";
        n.context = null;
        n._scratchBuffer = null;
        n._unlocked = !1;
        n.DEFAULT_SAMPLE_RATE = 44100;
        n.isSupported = function() {
            var t = createjs.BrowserDetect.isIOS || createjs.BrowserDetect.isAndroid || createjs.BrowserDetect.isBlackberry;
            return location.protocol == "file:" && !t && !this._isFileXHRSupported() ? !1 : (n._generateCapabilities(), n.context == null) ? !1 : !0
        };
        n.playEmptySound = function() {
            if (n.context != null) {
                var t = n.context.createBufferSource();
                t.buffer = n._scratchBuffer;
                t.connect(n.context.destination);
                t.start(0, 0, 0)
            }
        };
        n._isFileXHRSupported = function() {
            return document.location.host
        };
        n._generateCapabilities = function() {
            var t, u, e, r, o, i, f;
            if (n._capabilities == null) {
                if ((t = document.createElement("audio"), t.canPlayType == null) || n.context == null && (n.context = n._createAudioContext(), n.context == null)) return null;
                for (n._scratchBuffer == null && (n._scratchBuffer = n.context.createBuffer(1, 1, 22050)), n._compatibilitySetUp(), ("ontouchstart" in window) && n.context.state != "running" && (n._unlock(), document.addEventListener("mousedown", n._unlock, !0), document.addEventListener("touchstart", n._unlock, !0), document.addEventListener("touchend", n._unlock, !0)), n._capabilities = {
                        panning: !0,
                        volume: !0,
                        tracks: -1
                    }, u = createjs.Sound.SUPPORTED_EXTENSIONS, e = createjs.Sound.EXTENSION_MAP, r = 0, o = u.length; r < o; r++) i = u[r], f = e[i] || i, n._capabilities[i] = t.canPlayType("audio/" + i) != "no" && t.canPlayType("audio/" + i) != "" || t.canPlayType("audio/" + f) != "no" && t.canPlayType("audio/" + f) != "";
                n.context.destination.numberOfChannels < 2 && (n._capabilities.panning = !1)
            }
        };
        n._createAudioContext = function() {
            var r = window.AudioContext || window.webkitAudioContext,
                t, u, i;
            return r == null ? null : (t = new r, console.warn("The AudioContext is ready"), /(iPhone|iPad)/i.test(navigator.userAgent) && t.sampleRate !== n.DEFAULT_SAMPLE_RATE && (u = t.createBuffer(1, 1, n.DEFAULT_SAMPLE_RATE), i = t.createBufferSource(), i.buffer = u, i.connect(t.destination), i.start(0), i.disconnect(), t.close(), t = new r), t)
        };
        n._compatibilitySetUp = function() {
            if (n._panningModel = "equalpower", !n.context.createGain) {
                n.context.createGain = n.context.createGainNode;
                var t = n.context.createBufferSource();
                t.__proto__.start = t.__proto__.noteGrainOn;
                t.__proto__.stop = t.__proto__.noteOff;
                n._panningModel = 0
            }
        };
        n._unlock = function() {
            n._unlocked || (n.playEmptySound(), n.context.state == "running" && (document.removeEventListener("mousedown", n._unlock, !0), document.removeEventListener("touchend", n._unlock, !0), document.removeEventListener("touchstart", n._unlock, !0), n._unlocked = !0))
        };
        i.toString = function() {
            return "[WebAudioPlugin]"
        };
        i._addPropsToClasses = function() {
            var t = this._soundInstanceClass;
            t.context = this.context;
            t._scratchBuffer = n._scratchBuffer;
            t.destinationNode = this.gainNode;
            t._panningModel = this._panningModel;
            this._loaderClass.context = this.context
        };
        i._updateVolume = function() {
            var n = createjs.Sound._masterMute ? 0 : this._volume;
            n != this.gainNode.gain.value && (this.gainNode.gain.value = n)
        };
        createjs.WebAudioPlugin = createjs.promote(t, "AbstractPlugin")
    }(),
    function() {
        "use strict";

        function r() {
            throw "HTMLAudioTagPool cannot be instantiated";
        }

        function i() {
            this._tags = []
        }
        var n = r,
            t;
        n._tags = {};
        n._tagPool = new i;
        n._tagUsed = {};
        n.get = function(t) {
            var i = n._tags[t];
            return i == null ? (i = n._tags[t] = n._tagPool.get(), i.src = t) : n._tagUsed[t] ? (i = n._tagPool.get(), i.src = t) : n._tagUsed[t] = !0, i
        };
        n.set = function(t, i) {
            i == n._tags[t] ? n._tagUsed[t] = !1 : n._tagPool.set(i)
        };
        n.remove = function(t) {
            var i = n._tags[t];
            return i == null ? !1 : (n._tagPool.set(i), delete n._tags[t], delete n._tagUsed[t], !0)
        };
        n.getDuration = function(t) {
            var i = n._tags[t];
            return i == null || !i.duration ? 0 : i.duration * 1e3
        };
        createjs.HTMLAudioTagPool = r;
        t = i.prototype;
        t.constructor = i;
        t.get = function() {
            var n;
            return n = this._tags.length == 0 ? this._createTag() : this._tags.pop(), n.parentNode == null && document.body.appendChild(n), n
        };
        t.set = function(n) {
            var t = createjs.indexOf(this._tags, n);
            t == -1 && (this._tags.src = null, this._tags.push(n))
        };
        t.toString = function() {
            return "[TagPool]"
        };
        t._createTag = function() {
            var n = document.createElement("audio");
            return n.autoplay = !1, n.preload = "none", n
        }
    }(),
    function() {
        "use strict";

        function t(n, t, i, r) {
            this.AbstractSoundInstance_constructor(n, t, i, r);
            this._audioSpriteStopTime = null;
            this._delayTimeoutId = null;
            this._endedHandler = createjs.proxy(this._handleSoundComplete, this);
            this._readyHandler = createjs.proxy(this._handleTagReady, this);
            this._stalledHandler = createjs.proxy(this._playFailed, this);
            this._audioSpriteEndHandler = createjs.proxy(this._handleAudioSpriteLoop, this);
            this._loopHandler = createjs.proxy(this._handleSoundComplete, this);
            i ? this._audioSpriteStopTime = (t + i) * .001 : this._duration = createjs.HTMLAudioTagPool.getDuration(this.src)
        }
        var n = createjs.extend(t, createjs.AbstractSoundInstance);
        n.setMasterVolume = function() {
            this._updateVolume()
        };
        n.setMasterMute = function() {
            this._updateVolume()
        };
        n.toString = function() {
            return "[HTMLAudioSoundInstance]"
        };
        n._removeLooping = function() {
            this._playbackResource != null && (this._playbackResource.loop = !1, this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1))
        };
        n._addLooping = function() {
            this._playbackResource == null || this._audioSpriteStopTime || (this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1), this._playbackResource.loop = !0)
        };
        n._handleCleanUp = function() {
            var n = this._playbackResource;
            if (n != null) {
                n.pause();
                n.loop = !1;
                n.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_ENDED, this._endedHandler, !1);
                n.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_READY, this._readyHandler, !1);
                n.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_STALLED, this._stalledHandler, !1);
                n.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1);
                n.removeEventListener(createjs.HTMLAudioPlugin._TIME_UPDATE, this._audioSpriteEndHandler, !1);
                try {
                    n.currentTime = this._startTime
                } catch (t) {}
                createjs.HTMLAudioTagPool.set(this.src, n);
                this._playbackResource = null
            }
        };
        n._beginPlaying = function(n) {
            return this._playbackResource = createjs.HTMLAudioTagPool.get(this.src), this.AbstractSoundInstance__beginPlaying(n)
        };
        n._handleSoundReady = function() {
            if (this._playbackResource.readyState !== 4) {
                var n = this._playbackResource;
                n.addEventListener(createjs.HTMLAudioPlugin._AUDIO_READY, this._readyHandler, !1);
                n.addEventListener(createjs.HTMLAudioPlugin._AUDIO_STALLED, this._stalledHandler, !1);
                n.preload = "auto";
                n.load();
                return
            }
            this._updateVolume();
            this._playbackResource.currentTime = (this._startTime + this._position) * .001;
            this._audioSpriteStopTime ? this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._TIME_UPDATE, this._audioSpriteEndHandler, !1) : (this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._AUDIO_ENDED, this._endedHandler, !1), this._loop != 0 && (this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1), this._playbackResource.loop = !0));
            this._playbackResource.play()
        };
        n._handleTagReady = function() {
            this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_READY, this._readyHandler, !1);
            this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_STALLED, this._stalledHandler, !1);
            this._handleSoundReady()
        };
        n._pause = function() {
            this._playbackResource.pause()
        };
        n._resume = function() {
            this._playbackResource.play()
        };
        n._updateVolume = function() {
            if (this._playbackResource != null) {
                var n = this._muted || createjs.Sound._masterMute ? 0 : this._volume * createjs.Sound._masterVolume;
                n != this._playbackResource.volume && (this._playbackResource.volume = n)
            }
        };
        n._calculateCurrentPosition = function() {
            return this._playbackResource.currentTime * 1e3 - this._startTime
        };
        n._updatePosition = function() {
            this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1);
            this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._handleSetPositionSeek, !1);
            try {
                this._playbackResource.currentTime = (this._position + this._startTime) * .001
            } catch (n) {
                this._handleSetPositionSeek(null)
            }
        };
        n._handleSetPositionSeek = function() {
            this._playbackResource != null && (this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._handleSetPositionSeek, !1), this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1))
        };
        n._handleAudioSpriteLoop = function() {
            this._playbackResource.currentTime <= this._audioSpriteStopTime || (this._playbackResource.pause(), this._loop == 0 ? this._handleSoundComplete(null) : (this._position = 0, this._loop--, this._playbackResource.currentTime = this._startTime * .001, this._paused || this._playbackResource.play(), this._sendEvent("loop")))
        };
        n._handleLoop = function() {
            this._loop == 0 && (this._playbackResource.loop = !1, this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1))
        };
        n._updateStartTime = function() {
            this._audioSpriteStopTime = (this._startTime + this._duration) * .001;
            this.playState == createjs.Sound.PLAY_SUCCEEDED && (this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_ENDED, this._endedHandler, !1), this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._TIME_UPDATE, this._audioSpriteEndHandler, !1))
        };
        n._updateDuration = function() {
            this._audioSpriteStopTime = (this._startTime + this._duration) * .001;
            this.playState == createjs.Sound.PLAY_SUCCEEDED && (this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_ENDED, this._endedHandler, !1), this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._TIME_UPDATE, this._audioSpriteEndHandler, !1))
        };
        n._setDurationFromSource = function() {
            this._duration = createjs.HTMLAudioTagPool.getDuration(this.src);
            this._playbackResource = null
        };
        createjs.HTMLAudioSoundInstance = createjs.promote(t, "AbstractSoundInstance")
    }(),
    function() {
        "use strict";

        function i() {
            this.AbstractPlugin_constructor();
            this._capabilities = n._capabilities;
            this._loaderClass = createjs.SoundLoader;
            this._soundInstanceClass = createjs.HTMLAudioSoundInstance
        }
        var t = createjs.extend(i, createjs.AbstractPlugin),
            n = i;
        n.MAX_INSTANCES = 30;
        n._AUDIO_READY = "canplaythrough";
        n._AUDIO_ENDED = "ended";
        n._AUDIO_SEEKED = "seeked";
        n._AUDIO_STALLED = "stalled";
        n._TIME_UPDATE = "timeupdate";
        n._capabilities = null;
        n.isSupported = function() {
            return n._generateCapabilities(), n._capabilities != null
        };
        n._generateCapabilities = function() {
            var t, u, e, r, o, i, f;
            if (n._capabilities == null) {
                if (t = document.createElement("audio"), t.canPlayType == null) return null;
                for (n._capabilities = {
                        panning: !1,
                        volume: !0,
                        tracks: -1
                    }, u = createjs.Sound.SUPPORTED_EXTENSIONS, e = createjs.Sound.EXTENSION_MAP, r = 0, o = u.length; r < o; r++) i = u[r], f = e[i] || i, n._capabilities[i] = t.canPlayType("audio/" + i) != "no" && t.canPlayType("audio/" + i) != "" || t.canPlayType("audio/" + f) != "no" && t.canPlayType("audio/" + f) != ""
            }
        };
        t.register = function(n) {
            var i = createjs.HTMLAudioTagPool.get(n.src),
                t = this.AbstractPlugin_register(n);
            return t.setTag(i), t
        };
        t.removeSound = function(n) {
            this.AbstractPlugin_removeSound(n);
            createjs.HTMLAudioTagPool.remove(n)
        };
        t.create = function(n, t, i) {
            var r = this.AbstractPlugin_create(n, t, i);
            return r.playbackResource = null, r
        };
        t.toString = function() {
            return "[HTMLAudioPlugin]"
        };
        t.setVolume = t.getVolume = t.setMute = null;
        createjs.HTMLAudioPlugin = createjs.promote(i, "AbstractPlugin")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.EventDispatcher_constructor();
            this.ignoreGlobalPause = !1;
            this.loop = 0;
            this.useTicks = !1;
            this.reversed = !1;
            this.bounce = !1;
            this.timeScale = 1;
            this.duration = 0;
            this.position = 0;
            this.rawPosition = -1;
            this._paused = !0;
            this._next = null;
            this._prev = null;
            this._parent = null;
            this._labels = null;
            this._labelList = null;
            this._status = -1;
            this._lastTick = 0;
            n && (this.useTicks = !!n.useTicks, this.ignoreGlobalPause = !!n.ignoreGlobalPause, this.loop = n.loop === !0 ? -1 : n.loop || 0, this.reversed = !!n.reversed, this.bounce = !!n.bounce, this.timeScale = n.timeScale || 1, n.onChange && this.addEventListener("change", n.onChange), n.onComplete && this.addEventListener("complete", n.onComplete))
        }
        var n = createjs.extend(t, createjs.EventDispatcher);
        n._setPaused = function(n) {
            return createjs.Tween._register(this, n), this
        };
        n.setPaused = createjs.deprecate(n._setPaused, "AbstractTween.setPaused");
        n._getPaused = function() {
            return this._paused
        };
        n.getPaused = createjs.deprecate(n._getPaused, "AbstactTween.getPaused");
        n._getCurrentLabel = function(n) {
            var i = this.getLabels(),
                t, r;
            for (n == null && (n = this.position), t = 0, r = i.length; t < r; t++)
                if (n < i[t].position) break;
            return t === 0 ? null : i[t - 1].label
        };
        n.getCurrentLabel = createjs.deprecate(n._getCurrentLabel, "AbstractTween.getCurrentLabel");
        try {
            Object.defineProperties(n, {
                paused: {
                    set: n._setPaused,
                    get: n._getPaused
                },
                currentLabel: {
                    get: n._getCurrentLabel
                }
            })
        } catch (i) {}
        n.advance = function(n, t) {
            this.setPosition(this.rawPosition + n * this.timeScale, t)
        };
        n.setPosition = function(n, t, i, r) {
            var u = this.duration,
                h = this.loop,
                o = this.rawPosition,
                s = 0,
                e = 0,
                f = !1,
                c;
            if (n < 0 && (n = 0), u === 0) {
                if (f = !0, o !== -1) return f
            } else {
                if (s = n / u | 0, e = n - s * u, f = h !== -1 && n >= h * u + u, f && (n = (e = u) * (s = h) + u), n === o) return f;
                c = !this.reversed != !(this.bounce && s % 2);
                c && (e = u - e)
            }
            this.position = e;
            this.rawPosition = n;
            this._updatePosition(i, f);
            f && (this.paused = !0);
            r && r(this);
            t || this._runActions(o, n, i, !i && o === -1);
            this.dispatchEvent("change");
            f && this.dispatchEvent("complete")
        };
        n.calculatePosition = function(n) {
            var t = this.duration,
                u = this.loop,
                r = 0,
                i = 0,
                f;
            return t === 0 ? 0 : (u !== -1 && n >= u * t + t ? (i = t, r = u) : n < 0 ? i = 0 : (r = n / t | 0, i = n - r * t), f = !this.reversed != !(this.bounce && r % 2), f ? t - i : i)
        };
        n.getLabels = function() {
            var n = this._labelList,
                t, i;
            if (!n) {
                n = this._labelList = [];
                t = this._labels;
                for (i in t) n.push({
                    label: i,
                    position: t[i]
                });
                n.sort(function(n, t) {
                    return n.position - t.position
                })
            }
            return n
        };
        n.setLabels = function(n) {
            this._labels = n;
            this._labelList = null
        };
        n.addLabel = function(n, t) {
            var i, r, u;
            if (this._labels || (this._labels = {}), this._labels[n] = t, i = this._labelList, i) {
                for (r = 0, u = i.length; r < u; r++)
                    if (t < i[r].position) break;
                i.splice(r, 0, {
                    label: n,
                    position: t
                })
            }
        };
        n.gotoAndPlay = function(n) {
            this.paused = !1;
            this._goto(n)
        };
        n.gotoAndStop = function(n) {
            this.paused = !0;
            this._goto(n)
        };
        n.resolve = function(n) {
            var t = Number(n);
            return isNaN(t) && (t = this._labels && this._labels[n]), t
        };
        n.toString = function() {
            return "[AbstractTween]"
        };
        n.clone = function() {
            throw "AbstractTween can not be cloned.";
        };
        n._init = function(n) {
            n && n.paused || (this.paused = !1);
            n && n.position != null && this.setPosition(n.position)
        };
        n._updatePosition = function() {};
        n._goto = function(n) {
            var t = this.resolve(n);
            t != null && this.setPosition(t, !1, !0)
        };
        n._runActions = function(n, t, i, r) {
            var l, o;
            if (this._actionHead || this.tweens) {
                var f = this.duration,
                    p = this.reversed,
                    a = this.bounce,
                    c = this.loop,
                    u, e, h, s;
                if (f === 0 ? (u = e = h = s = 0, p = a = !1) : (u = n / f | 0, e = t / f | 0, h = n - u * f, s = t - e * f), c !== -1 && (e > c && (s = f, e = c), u > c && (h = f, u = c)), i) return this._runActionsRange(s, s, i, r);
                if (u !== e || h !== s || i || r) u === -1 && (u = h = 0);
                else return;
                l = n <= t;
                o = u;
                do {
                    var w = !p != !(a && o % 2),
                        v = o === u ? h : l ? 0 : f,
                        y = o === e ? s : l ? f : 0;
                    if (w && (v = f - v, y = f - y), (!a || o === u || v !== y) && this._runActionsRange(v, y, i, r || o !== u && !a)) return !0;
                    r = !1
                } while (l && ++o <= e || !l && --o >= e)
            }
        };
        n._runActionsRange = function() {};
        createjs.AbstractTween = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function n(t, r) {
            this.AbstractTween_constructor(r);
            this.pluginData = null;
            this.target = t;
            this.passive = !1;
            this._stepHead = new i(null, 0, 0, {}, null, !0);
            this._stepTail = this._stepHead;
            this._stepPosition = 0;
            this._actionHead = null;
            this._actionTail = null;
            this._plugins = null;
            this._pluginIds = null;
            this._injected = null;
            r && (this.pluginData = r.pluginData, r.override && n.removeTweens(t));
            this.pluginData || (this.pluginData = {});
            this._init(r)
        }

        function i(n, t, i, r, u, f) {
            this.next = null;
            this.prev = n;
            this.t = t;
            this.d = i;
            this.props = r;
            this.ease = u;
            this.passive = f;
            this.index = n ? n.index + 1 : 0
        }

        function r(n, t, i, r, u) {
            this.next = null;
            this.prev = n;
            this.t = t;
            this.d = 0;
            this.scope = i;
            this.funct = r;
            this.params = u
        }
        var t = createjs.extend(n, createjs.AbstractTween);
        n.IGNORE = {};
        n._tweens = [];
        n._plugins = null;
        n._tweenHead = null;
        n._tweenTail = null;
        n._inTick = 0;
        n.get = function(t, i) {
            return new n(t, i)
        };
        n.tick = function(t, i) {
            for (var r = n._tweenHead, e = n._inTick = Date.now(), f, u; r;) f = r._next, u = r._status, r._lastTick = e, u === 1 ? r._status = 0 : u === -1 ? n._delist(r) : i && !r.ignoreGlobalPause || r._paused || r.advance(r.useTicks ? 1 : t), r = f;
            n._inTick = 0
        };
        n.handleEvent = function(n) {
            n.type === "tick" && this.tick(n.delta, n.paused)
        };
        n.removeTweens = function(t) {
            var i, r;
            if (t.tweenjs_count) {
                for (i = n._tweenHead; i;) r = i._next, i.target === t && n._register(i, !0), i = r;
                t.tweenjs_count = 0
            }
        };
        n.removeAllTweens = function() {
            for (var t = n._tweenHead, i; t;) i = t._next, t._paused = !0, t.target && (t.target.tweenjs_count = 0), t._next = t._prev = null, t = i;
            n._tweenHead = n._tweenTail = null
        };
        n.hasActiveTweens = function(t) {
            return t ? !!t.tweenjs_count : !!n._tweenHead
        };
        n._installPlugin = function(t) {
            for (var u = t.priority = t.priority || 0, r = n._plugins = n._plugins || [], i = 0, f = r.length; i < f; i++)
                if (u < r[i].priority) break;
            r.splice(i, 0, t)
        };
        n._register = function(t, i) {
            var r = t.target,
                u;
            !i && t._paused ? (r && (r.tweenjs_count = r.tweenjs_count ? r.tweenjs_count + 1 : 1), u = n._tweenTail, u ? (n._tweenTail = u._next = t, t._prev = u) : n._tweenHead = n._tweenTail = t, t._status = n._inTick ? 1 : 0, !n._inited && createjs.Ticker && (createjs.Ticker.addEventListener("tick", n), n._inited = !0)) : i && !t._paused && (r && r.tweenjs_count--, n._inTick && t._lastTick !== n._inTick || n._delist(t), t._status = -1);
            t._paused = i
        };
        n._delist = function(t) {
            var i = t._next,
                r = t._prev;
            i ? i._prev = r : n._tweenTail = r;
            r ? r._next = i : n._tweenHead = i;
            t._next = t._prev = null
        };
        t.wait = function(n, t) {
            return n > 0 && this._addStep(+n, this._stepTail.props, null, t), this
        };
        t.to = function(n, t, i) {
            (t == null || t < 0) && (t = 0);
            var r = this._addStep(+t, null, i);
            return this._appendProps(n, r), this
        };
        t.label = function(n) {
            return this.addLabel(n, this.duration), this
        };
        t.call = function(n, t, i) {
            return this._addAction(i || this.target, n, t || [this])
        };
        t.set = function(n, t) {
            return this._addAction(t || this.target, this._set, [n])
        };
        t.play = function(n) {
            return this._addAction(n || this, this._set, [{
                paused: !1
            }])
        };
        t.pause = function(n) {
            return this._addAction(n || this, this._set, [{
                paused: !0
            }])
        };
        t.w = t.wait;
        t.t = t.to;
        t.c = t.call;
        t.s = t.set;
        t.toString = function() {
            return "[Tween]"
        };
        t.clone = function() {
            throw "Tween can not be cloned.";
        };
        t._addPlugin = function(n) {
            var u = this._pluginIds || (this._pluginIds = {}),
                r = n.ID,
                t, f, i, e;
            if (r && !u[r]) {
                for (u[r] = !0, t = this._plugins || (this._plugins = []), f = n.priority || 0, i = 0, e = t.length; i < e; i++)
                    if (f < t[i].priority) {
                        t.splice(i, 0, n);
                        return
                    }
                t.push(n)
            }
        };
        t._updatePosition = function(n, t) {
            var i = this._stepHead.next,
                r = this.position,
                f = this.duration,
                u, e;
            if (this.target && i) {
                for (u = i.next; u && u.t <= r;) i = i.next, u = i.next;
                e = t ? f === 0 ? 1 : r / f : (r - i.t) / i.d;
                this._updateTargetProps(i, e, t)
            }
            this._stepPosition = i ? r - i.t : 0
        };
        t._updateTargetProps = function(t, i, r) {
            var e, u, o, a, l, v, s, f, h, y, c;
            if (!(this.passive = !!t.passive)) {
                l = t.prev.props;
                v = t.props;
                (a = t.ease) && (i = a(i, 0, 1, 1));
                s = this._plugins;
                n: for (f in l) {
                    if (u = l[f], o = v[f], e = u !== o && typeof u == "number" ? u + (o - u) * i : i >= 1 ? o : u, s)
                        for (h = 0, y = s.length; h < y; h++) {
                            if (c = s[h].change(this, t, f, e, i, r), c === n.IGNORE) continue n;
                            c !== undefined && (e = c)
                        }
                    this.target[f] = e
                }
            }
        };
        t._runActionsRange = function(n, t, i, r) {
            var e = n > t,
                u = e ? this._actionTail : this._actionHead,
                o = t,
                s = n,
                h, f;
            for (e && (o = n, s = t), h = this.position; u;) {
                if (f = u.t, (f === t || f > s && f < o || r && f === n) && (u.funct.apply(u.scope, u.params), h !== this.position)) return !0;
                u = e ? u.prev : u.next
            }
        };
        t._appendProps = function(t, i, r) {
            var w = this._stepHead.props,
                b = this.target,
                o = n._plugins,
                u, e, h, f, v, y = i.prev,
                l = y.props,
                p = i.props || (i.props = this._cloneProps(l)),
                c = {},
                a, s;
            for (u in t)
                if (t.hasOwnProperty(u) && (c[u] = p[u] = t[u], w[u] === undefined)) {
                    if (f = undefined, o)
                        for (e = o.length - 1; e >= 0; e--)
                            if (h = o[e].init(this, u, f), h !== undefined && (f = h), f === n.IGNORE) {
                                delete p[u];
                                delete c[u];
                                break
                            }
                    f !== n.IGNORE && (f === undefined && (f = b[u]), l[u] = f === undefined ? null : f)
                }
            for (u in c)
                for (h = t[u], s = y;
                    (a = s) && (s = a.prev);)
                    if (s.props !== a.props) {
                        if (s.props[u] !== undefined) break;
                        s.props[u] = l[u]
                    }
            if (r !== !1 && (o = this._plugins))
                for (e = o.length - 1; e >= 0; e--) o[e].step(this, i, c);
            (v = this._injected) && (this._injected = null, this._appendProps(v, i, !1));
            this.step = i
        };
        t._injectProp = function(n, t) {
            var i = this._injected || (this._injected = {});
            i[n] = t
        };
        t._addStep = function(n, t, r, u) {
            var f = new i(this._stepTail, this.duration, n, t, r, u || !1);
            return this.duration += n, this._stepTail = this._stepTail.next = f
        };
        t._addAction = function(n, t, i) {
            var u = new r(this._actionTail, this.duration, n, t, i);
            return this._actionTail ? this._actionTail.next = u : this._actionHead = u, this._actionTail = u, this
        };
        t._set = function(n) {
            for (var t in n) this[t] = n[t]
        };
        t._cloneProps = function(n) {
            var t = {};
            for (var i in n) t[i] = n[i];
            return t
        };
        createjs.Tween = createjs.promote(n, "AbstractTween")
    }(),
    function() {
        "use strict";

        function t(n) {
            var t, i;
            n instanceof Array || n == null && arguments.length > 1 ? (t = n, i = arguments[1], n = arguments[2]) : n && (t = n.tweens, i = n.labels);
            this.AbstractTween_constructor(n);
            this.tweens = [];
            t && this.addTween.apply(this, t);
            this.setLabels(i);
            this._init(n)
        }
        var n = createjs.extend(t, createjs.AbstractTween);
        n.addTween = function(n) {
            var t, i, r;
            if (n._parent && n._parent.removeTween(n), t = arguments.length, t > 1) {
                for (i = 0; i < t; i++) this.addTween(arguments[i]);
                return arguments[t - 1]
            }
            return t === 0 ? null : (this.tweens.push(n), n._parent = this, n.paused = !0, r = n.duration, n.loop > 0 && (r *= n.loop + 1), r > this.duration && (this.duration = r), this.rawPosition >= 0 && n.setPosition(this.rawPosition), n)
        };
        n.removeTween = function(n) {
            var u = arguments.length,
                i, r, t;
            if (u > 1) {
                for (i = !0, t = 0; t < u; t++) i = i && this.removeTween(arguments[t]);
                return i
            }
            if (u === 0) return !0;
            for (r = this.tweens, t = r.length; t--;)
                if (r[t] === n) return r.splice(t, 1), n._parent = null, n.duration >= this.duration && this.updateDuration(), !0;
            return !1
        };
        n.updateDuration = function() {
            var n, r, t, i;
            for (this.duration = 0, n = 0, r = this.tweens.length; n < r; n++) t = this.tweens[n], i = t.duration, t.loop > 0 && (i *= t.loop + 1), i > this.duration && (this.duration = i)
        };
        n.toString = function() {
            return "[Timeline]"
        };
        n.clone = function() {
            throw "Timeline can not be cloned.";
        };
        n._updatePosition = function(n) {
            for (var i = this.position, t = 0, r = this.tweens.length; t < r; t++) this.tweens[t].setPosition(i, !0, n)
        };
        n._runActionsRange = function(n, t, i, r) {
            for (var f = this.position, u = 0, e = this.tweens.length; u < e; u++)
                if (this.tweens[u]._runActions(n, t, i, r), f !== this.position) return !0
        };
        createjs.Timeline = createjs.promote(t, "AbstractTween")
    }(),
    function() {
        "use strict";

        function n() {
            throw "Ease cannot be instantiated.";
        }
        n.linear = function(n) {
            return n
        };
        n.none = n.linear;
        n.get = function(n) {
            return n < -1 ? n = -1 : n > 1 && (n = 1),
                function(t) {
                    return n == 0 ? t : n < 0 ? t * (t * -n + 1 + n) : t * ((2 - t) * n + (1 - n))
                }
        };
        n.getPowIn = function(n) {
            return function(t) {
                return Math.pow(t, n)
            }
        };
        n.getPowOut = function(n) {
            return function(t) {
                return 1 - Math.pow(1 - t, n)
            }
        };
        n.getPowInOut = function(n) {
            return function(t) {
                return (t *= 2) < 1 ? .5 * Math.pow(t, n) : 1 - .5 * Math.abs(Math.pow(2 - t, n))
            }
        };
        n.quadIn = n.getPowIn(2);
        n.quadOut = n.getPowOut(2);
        n.quadInOut = n.getPowInOut(2);
        n.cubicIn = n.getPowIn(3);
        n.cubicOut = n.getPowOut(3);
        n.cubicInOut = n.getPowInOut(3);
        n.quartIn = n.getPowIn(4);
        n.quartOut = n.getPowOut(4);
        n.quartInOut = n.getPowInOut(4);
        n.quintIn = n.getPowIn(5);
        n.quintOut = n.getPowOut(5);
        n.quintInOut = n.getPowInOut(5);
        n.sineIn = function(n) {
            return 1 - Math.cos(n * Math.PI / 2)
        };
        n.sineOut = function(n) {
            return Math.sin(n * Math.PI / 2)
        };
        n.sineInOut = function(n) {
            return -.5 * (Math.cos(Math.PI * n) - 1)
        };
        n.getBackIn = function(n) {
            return function(t) {
                return t * t * ((n + 1) * t - n)
            }
        };
        n.backIn = n.getBackIn(1.7);
        n.getBackOut = function(n) {
            return function(t) {
                return --t * t * ((n + 1) * t + n) + 1
            }
        };
        n.backOut = n.getBackOut(1.7);
        n.getBackInOut = function(n) {
            return n *= 1.525,
                function(t) {
                    return (t *= 2) < 1 ? .5 * t * t * ((n + 1) * t - n) : .5 * ((t -= 2) * t * ((n + 1) * t + n) + 2)
                }
        };
        n.backInOut = n.getBackInOut(1.7);
        n.circIn = function(n) {
            return -(Math.sqrt(1 - n * n) - 1)
        };
        n.circOut = function(n) {
            return Math.sqrt(1 - --n * n)
        };
        n.circInOut = function(n) {
            return (n *= 2) < 1 ? -.5 * (Math.sqrt(1 - n * n) - 1) : .5 * (Math.sqrt(1 - (n -= 2) * n) + 1)
        };
        n.bounceIn = function(t) {
            return 1 - n.bounceOut(1 - t)
        };
        n.bounceOut = function(n) {
            return n < 1 / 2.75 ? 7.5625 * n * n : n < 2 / 2.75 ? 7.5625 * (n -= 1.5 / 2.75) * n + .75 : n < 2.5 / 2.75 ? 7.5625 * (n -= 2.25 / 2.75) * n + .9375 : 7.5625 * (n -= 2.625 / 2.75) * n + .984375
        };
        n.bounceInOut = function(t) {
            return t < .5 ? n.bounceIn(t * 2) * .5 : n.bounceOut(t * 2 - 1) * .5 + .5
        };
        n.getElasticIn = function(n, t) {
            var i = Math.PI * 2;
            return function(r) {
                if (r == 0 || r == 1) return r;
                var u = t / i * Math.asin(1 / n);
                return -(n * Math.pow(2, 10 * (r -= 1)) * Math.sin((r - u) * i / t))
            }
        };
        n.elasticIn = n.getElasticIn(1, .3);
        n.getElasticOut = function(n, t) {
            var i = Math.PI * 2;
            return function(r) {
                var u;
                return r == 0 || r == 1 ? r : (u = t / i * Math.asin(1 / n), n * Math.pow(2, -10 * r) * Math.sin((r - u) * i / t) + 1)
            }
        };
        n.elasticOut = n.getElasticOut(1, .3);
        n.getElasticInOut = function(n, t) {
            var i = Math.PI * 2;
            return function(r) {
                var u = t / i * Math.asin(1 / n);
                return (r *= 2) < 1 ? -.5 * n * Math.pow(2, 10 * (r -= 1)) * Math.sin((r - u) * i / t) : n * Math.pow(2, -10 * (r -= 1)) * Math.sin((r - u) * i / t) * .5 + 1
            }
        };
        n.elasticInOut = n.getElasticInOut(1, .3 * 1.5);
        createjs.Ease = n
    }(),
    function() {
        "use strict";

        function t() {
            throw "MotionGuidePlugin cannot be instantiated.";
        }
        var n = t;
        n.priority = 0;
        n.ID = "MotionGuide";
        n.install = function() {
            return createjs.Tween._installPlugin(t), createjs.Tween.IGNORE
        };
        n.init = function(t, i) {
            i == "guide" && t._addPlugin(n)
        };
        n.step = function(t, i, r) {
            var s, u, o, f, h;
            for (s in r)
                if (s === "guide") {
                    if (u = i.props.guide, o = n._solveGuideData(r.guide, u), u.valid = !o, f = u.endData, t._injectProp("x", f.x), t._injectProp("y", f.y), o || !u.orient) break;
                    if (h = i.prev.props.rotation === undefined ? t.target.rotation || 0 : i.prev.props.rotation, u.startOffsetRot = h - u.startData.rotation, u.orient == "fixed") u.endAbsRot = f.rotation + u.startOffsetRot, u.deltaRotation = 0;
                    else {
                        var c = r.rotation === undefined ? t.target.rotation || 0 : r.rotation,
                            e = c - u.endData.rotation - u.startOffsetRot,
                            l = e % 360;
                        u.endAbsRot = c;
                        switch (u.orient) {
                            case "auto":
                                u.deltaRotation = e;
                                break;
                            case "cw":
                                u.deltaRotation = (l + 360) % 360 + 360 * Math.abs(e / 360 | 0);
                                break;
                            case "ccw":
                                u.deltaRotation = (l - 360) % 360 + -360 * Math.abs(e / 360 | 0)
                        }
                    }
                    t._injectProp("rotation", u.endAbsRot)
                }
        };
        n.change = function(t, i, r, u, f) {
            var e = i.props.guide;
            if (e && i.props !== i.prev.props && e !== i.prev.props.guide) {
                if (r === "guide" && !e.valid || r == "x" || r == "y" || r === "rotation" && e.orient) return createjs.Tween.IGNORE;
                n._ratioToPositionData(f, e, t.target)
            }
        };
        n.debug = function(t, i, r) {
            var o, c, h, f, u;
            if (t = t.guide || t, o = n._findPathProblems(t), o && console.error("MotionGuidePlugin Error found: \n" + o), !i) return o;
            var u, e = t.path,
                a = e.length,
                s = 3,
                l = 9;
            for (i.save(), i.lineCap = "round", i.lineJoin = "miter", i.beginPath(), i.moveTo(e[0], e[1]), u = 2; u < a; u += 4) i.quadraticCurveTo(e[u], e[u + 1], e[u + 2], e[u + 3]);
            if (i.strokeStyle = "black", i.lineWidth = s * 1.5, i.stroke(), i.strokeStyle = "white", i.lineWidth = s, i.stroke(), i.closePath(), c = r.length, r && c)
                for (h = {}, f = {}, n._solveGuideData(t, h), u = 0; u < c; u++) h.orient = "fixed", n._ratioToPositionData(r[u], h, f), i.beginPath(), i.moveTo(f.x, f.y), i.lineTo(f.x + Math.cos(f.rotation * .0174533) * l, f.y + Math.sin(f.rotation * .0174533) * l), i.strokeStyle = "black", i.lineWidth = s * 1.5, i.stroke(), i.strokeStyle = "red", i.lineWidth = s, i.stroke(), i.closePath();
            return i.restore(), o
        };
        n._solveGuideData = function(t, i) {
            var k = undefined,
                f, rt, y, p, it, w, b;
            if (k = n.debug(t)) return k;
            f = i.path = t.path;
            rt = i.orient = t.orient;
            i.subLines = [];
            i.totalLength = 0;
            i.startOffsetRot = 0;
            i.deltaRotation = 0;
            i.startData = {
                ratio: 0
            };
            i.endData = {
                ratio: 1
            };
            i.animSpan = 1;
            var ut = f.length,
                l = 10,
                h, c, d, g, a, v, r, u, e, s = {};
            for (h = f[0], c = f[1], r = 2; r < ut; r += 4) {
                d = f[r];
                g = f[r + 1];
                a = f[r + 2];
                v = f[r + 3];
                var o = {
                        weightings: [],
                        estLength: 0,
                        portion: 0
                    },
                    nt = h,
                    tt = c;
                for (u = 1; u <= l; u++) n._getParamsForCurve(h, c, d, g, a, v, u / l, !1, s), y = s.x - nt, p = s.y - tt, e = Math.sqrt(y * y + p * p), o.weightings.push(e), o.estLength += e, nt = s.x, tt = s.y;
                for (i.totalLength += o.estLength, u = 0; u < l; u++) e = o.estLength, o.weightings[u] = o.weightings[u] / e;
                i.subLines.push(o);
                h = a;
                c = v
            }
            for (e = i.totalLength, it = i.subLines.length, r = 0; r < it; r++) i.subLines[r].portion = i.subLines[r].estLength / e;
            w = isNaN(t.start) ? 0 : t.start;
            b = isNaN(t.end) ? 1 : t.end;
            n._ratioToPositionData(w, i, i.startData);
            n._ratioToPositionData(b, i, i.endData);
            i.startData.ratio = w;
            i.endData.ratio = b;
            i.animSpan = i.endData.ratio - i.startData.ratio
        };
        n._ratioToPositionData = function(t, i, r) {
            for (var c = i.subLines, v, e, u, s = 0, y = 10, l = t * i.animSpan + i.startData.ratio, a, p, o, h = c.length, f = 0; f < h; f++) {
                if (e = c[f].portion, s + e >= l) {
                    u = f;
                    break
                }
                s += e
            }
            for (u === undefined && (u = h - 1, s -= e), a = c[u].weightings, p = e, h = a.length, f = 0; f < h; f++) {
                if (e = a[f] * p, s + e >= l) break;
                s += e
            }
            return u = u * 4 + 2, v = f / y + (l - s) / e * (1 / y), o = i.path, n._getParamsForCurve(o[u - 2], o[u - 1], o[u], o[u + 1], o[u + 2], o[u + 3], v, i.orient, r), i.orient && (t >= .99999 && t <= 1.00001 && i.endAbsRot !== undefined ? r.rotation = i.endAbsRot : r.rotation += i.startOffsetRot + t * i.deltaRotation), r
        };
        n._getParamsForCurve = function(n, t, i, r, u, f, e, o, s) {
            var h = 1 - e;
            s.x = h * h * n + 2 * h * e * i + e * e * u;
            s.y = h * h * t + 2 * h * e * r + e * e * f;
            o && (s.rotation = 57.2957795 * Math.atan2((r - t) * h + (f - r) * e, (i - n) * h + (u - i) * e))
        };
        n._findPathProblems = function(n) {
            var o = n.path,
                i = o && o.length || 0,
                r, u, f, e, t;
            if (i < 6 || (i - 2) % 4) return r = "\tCannot parse 'path' array due to invalid number of entries in path. ", r += "There should be an odd number of points, at least 3 points, and 2 entries per point (x & y). ", r += "See 'CanvasRenderingContext2D.quadraticCurveTo' for details as 'path' models a quadratic bezier.\n\n", r + ("Only [ " + i + " ] values found. Expected: " + Math.max(Math.ceil((i - 2) / 4) * 4 + 2, 6));
            for (u = 0; u < i; u++)
                if (isNaN(o[u])) return "All data in path array must be numeric";
            return (f = n.start, isNaN(f) && !(f === undefined)) ? "'start' out of bounds. Expected 0 to 1, got: " + f : (e = n.end, isNaN(e) && e !== undefined) ? "'end' out of bounds. Expected 0 to 1, got: " + e : (t = n.orient, t && t != "fixed" && t != "auto" && t != "cw" && t != "ccw") ? 'Invalid orientation value. Expected ["fixed", "auto", "cw", "ccw", undefined], got: ' + t : undefined
        };
        createjs.MotionGuidePlugin = t
    }(),
    function() {
        "use strict";
        var n = createjs.TweenJS = createjs.TweenJS || {};
        n.version = "NEXT";
        n.buildDate = "Thu, 14 Sep 2017 22:19:45 GMT"
    }();
this.createjs = this.createjs || {},
    function() {
        "use strict";

        function t() {
            throw "CSSPlugin cannot be instantiated.";
        }

        function i(t, i) {
            for (var o, e, f, u = [!1, t];;) {
                if (!(o = n.TRANSFORM_RE.exec(t))) break;
                "*" !== o[3] ? (e = [o[1]], f = i && i[u.length], !i || f && e[0] === f[0] || (console.log("transforms don't match: ", e[0], f && f[0]), i = null), r(o[2], f, e), u.push(e)) : u.push(i[u.length])
            }
            return u[0] = !!i, u
        }

        function r(t, i, r) {
            for (;;) {
                var u = n.TRANSFORM_VALUE_RE.exec(t);
                if (!u) return r;
                r || (r = []);
                r.push(+u[1], u[2]);
                i && i[r.length - 1] !== u[2] && (console.log("transform units don't match: ", r[0], i[r.length - 1], u[2]), i = null)
            }
        }
        var n = t;
        n.priority = 100;
        n.ID = "CSS";
        n.VALUE_RE = /^(-?[\d.]+)([a-z%]*)$/;
        n.TRANSFORM_VALUE_RE = /(?:^| |,)(-?[\d.]+)([a-z%]*)/g;
        n.TRANSFORM_RE = /(\w+?)\(([^)]+)\)|(?:^| )(\*)(?:$| )/g;
        n.compute = !1;
        n.install = function() {
            createjs.Tween._installPlugin(t)
        };
        n.init = function(r, u, f) {
            var o = r.pluginData,
                c, l, a, e, s, h;
            if (!o.CSS_disabled && r.target instanceof HTMLElement && (e = f || (c = r.target, l = u, (a = o.CSS_compute) || null == a && n.compute ? window.getComputedStyle(c)[l] : c.style[l]), void 0 !== e)) return (r._addPlugin(t), s = o.CSS || (o.CSS = {}), "transform" === u) ? (s[u] = "_t", i(e)) : (h = n.VALUE_RE.exec(e), null === h ? (s[u] = "", e) : (s[u] = h[2], parseFloat(h[1])))
        };
        n.step = function(n, t, r) {
            r.transform && (t.props.transform = i(t.props.transform, t.prev.props.transform))
        };
        n.change = function(n, t, i, r, u) {
            var f = n.pluginData.CSS[i];
            if (void 0 !== f) return "transform" === i ? r = function(n, t, i) {
                var f, r, o, u, s, e, h;
                if (1 === i) return t[1];
                if (0 === i || !t[0]) return n[1];
                for (u = "", s = n.length, f = 2; f < s; f++) {
                    for (e = n[f], h = t[f], u += e[0] + "(", r = 1, o = e.length; r < o; r += 2) u += e[r] + (h[r] - e[r]) * i, u += h[r + 1] || e[r + 1], r < o - 2 && (u += ", ");
                    u += ")";
                    f < s - 1 && (u += " ")
                }
                return u
            }(t.prev.props[i], t.props[i], u) : r += f, n.target.style[i] = r, createjs.Tween.IGNORE
        };
        createjs.CSSPlugin = n
    }();
createjs.CSSPlugin.install();
this.createjs = this.createjs || {},
    function() {
        "use strict";

        function t() {
            throw "DotPlugin cannot be instantiated.";
        }
        var n = t;
        n.priority = 100;
        n.ID = "Dot";
        n.install = function() {
            createjs.Tween._installPlugin(t)
        };
        n.init = function(n, i, r) {
            var u = n.pluginData;
            if (!u.Dot_disabled && "." === i[0]) {
                n._addPlugin(t);
                for (var f = n.target, o = i.split("."), e = 1, h = o.length; e < h - 1; e++)
                    if (!(f = f[o[e]])) return createjs.Tween.IGNORE;
                var s = o[e],
                    c = f[s],
                    l = void 0 === r ? c : r;
                return u.Dot = u.Dot || {}, u.Dot[i] = {
                    t: f,
                    n: s
                }, l
            }
        };
        n.step = function() {};
        n.change = function(n, t, i, r) {
            var u, f = n.pluginData.Dot;
            if (f && (u = f[i])) return u.t[u.n] = r, createjs.Tween.IGNORE
        };
        createjs.DotPlugin = n
    }();
this.createjs = this.createjs || {},
    function() {
        "use strict";

        function t() {
            throw "RelativePlugin plugin cannot be instantiated.";
        }
        var n = t;
        n.ID = "Relative";
        n.install = function() {
            createjs.Tween._installPlugin(t)
        };
        n.init = function(t) {
            t.pluginData.Relative_disabled || t._addPlugin(n)
        };
        n.step = function(n, t, i) {
            var u, r, e, f;
            for (u in i) r = i[u], "string" == typeof r && (e = t.prev.props[u], f = r[0], "+" !== f && "-" !== f || isNaN(r = +r + e) || (t.props[u] = r))
        };
        n.change = function() {};
        createjs.RelativePlugin = n
    }();
createjs.DotPlugin.install();
createjs.RelativePlugin.install();
window.addEventListener("DOMContentLoaded", function() {
    var n = document.createElement("style");
    n.innerHTML = "canvas {-webkit-tap-highlight-color: transparent;}";
    document.body.appendChild(n)
});