﻿var pad;
var panel;
var background;
var button_start;
var button_back;
var feedback;
var problem;
var product;
var obstacle = new Array();
var obstacle_max = 5;
var obstacle_total = new Array();
var rope;
var hook;
const goal_num = 10;
var level = 1;
var level_max = 5;
var number1;
var number2;
var wall = new Array();
var wall_total = 9;
var wall_x1 = new Array();
var wall_x2 = new Array();
var wall_y1 = new Array();
var wall_y2 = new Array();
var reward = new Array();
var reward_total = 10;
var intersection_x;
var intersection_y;
var intersection_length;
var rope_length;
var rope_min_length = 0;
var max_rope_length = 700;
var answer;
var box = new Array();
var box_dimension = 60;
var box_initial_x = -120;
var box_initial_y = -105;
var hit_counter;
var selection = new Array();
var selection_total = 4;
var selection_initial_x = 100;
var selection_initial_y = 600;
var selection_width = 190;
var end;
var elapsed_time = 0;
var start_time = 0;
var render_run = false;
var render_frame_rate = 10;
var rope_run = false;
var inital_sound = false;
var sound_initial;
var sound_success;
var sound_failure;
var sound_final_success;
var sound_catch;
var sound_hit;
var sound_load1 = false;
var sound_load2 = false;
var sound_load3 = false;
function init() {
    document.getElementById("game_container").style.display = "inline";
    document.getElementById("loading_div").style.display = "none";
    setInteractiveParameters();
    set_data();
    sound_initial = new Howl({ src: ["sound/sound_initial.mp3", "sound_initial.ogg", "/shared/sound/sound_initial.wav"] });
    sound_success = new Howl({ src: ["sound/sound_success.mp3", "sound_success.ogg", "sound/sound_success.wav"] });
    sound_failure = new Howl({ src: ["sound/sound_failure.mp3", "sound/sound_failure.ogg", "sound/sound_failure.wav"] });
    sound_hit = new Howl({ src: ["sound/sound_hit.mp3", "sound/sound_hit.ogg", "=sound/sound_hit.wav"] });
    sound_catch = new Howl({ src: ["sound/sound_catch.mp3", "sound/sound_catch.ogg", "sound/sound_catch.wav"] });
    sound_final_success = new Howl({ src: ["sound/sound_final_success.mp3", "sound/sound_final_success.ogg", "sound/sound_final_success.wav"] });
    background = new MovieClip(document.getElementById("background").cloneNode(true));
    background.x = 0;
    background.y = 0;
    background.transform();
    background.instance.setAttribute("display", "none");
    stage.appendChild(background.instance);
    problem = new MovieClip(document.getElementById("problem").cloneNode(true));
    problem.x = 390;
    problem.y = 450;
    problem.transform();
    problem.text = new MovieClip(problem.instance.querySelector("#text_container"));
    stage.appendChild(problem.instance);
    for (i = 1; i <= wall_total; i++) {
        wall[i] = new MovieClip(document.getElementById("wall").cloneNode(true));
    }
    rope = new MovieClip(document.getElementById("rope").cloneNode(true));
    rope.x = 0;
    rope.y = 0;
    rope.transform();
    rope.move_total = 10;
    stage.appendChild(rope.instance);
    for (var i = 1; i <= reward_total; i++) {
        reward[i] = new MovieClip(document.getElementById("reward").cloneNode(true));
        reward[i].hitRadius = 15;
        reward[i].scale = 1;
        reward[i].instance.setAttribute("data-id", i);
        reward[i].frame_total = 10;
        reward[i].frames = new Array();
        for (var m = 1; m <= reward[i].frame_total; m++) {
            reward[i].frames[m] = reward[i].instance.querySelector("#frame" + m);
        }
        reward[i].instance.setAttribute("display", "none");
        stage.appendChild(reward[i].instance);
    }
    hook = new MovieClip(document.getElementById("hook").cloneNode(true));
    hook.x = 0;
    hook.y = 0;
    hook.transform();
    stage.appendChild(hook.instance);
    product = new MovieClip(document.getElementById("product").cloneNode(true));
    product.scale = 1.1;
    product.transform();
    product.hitRadius = 30;
    product.frame_total = 3;
    product.frames = new Array();
    for (var m = 1; m <= product.frame_total; m++) {
        product.frames[m] = product.instance.querySelector("#frame" + m);
    }
    product.start = [1];
    product.shoot = [2];
    product.fly = [3];
    stage.appendChild(product.instance);
    for (var i = 1; i <= obstacle_max; i++) {
        obstacle[i] = new MovieClip(document.getElementById("obstacle").cloneNode(true));
        obstacle[i].scale = 0.8;
        obstacle[i].hitRadius = 15;
        obstacle[i].frame_total = 2;
        obstacle[i].frames = new Array();
        for (var m = 1; m <= obstacle[i].frame_total; m++) {
            obstacle[i].frames[m] = obstacle[i].instance.querySelector("#frame" + m);
        }
        obstacle[i].animationTimerValue = 200;
        obstacle[i].fly = [1, 2];
        obstacle[i].animationComplete = function () {
            if (!end) {
                this.playFrames(this.fly);
            }
        };
        obstacle[i].pick_target = function () {
            this.force = generateRandom(20, 100) / 40;
            this.target_x = generateRandom(150, 700);
            this.target_y = generateRandom(200, 600);
            this.angle = getDirection(this.target_x, this.x, this.target_y, this.y);
            this.target_distance = getDistance(this.target_x, this.x, this.target_y, this.y);
            this.vx = Math.cos(this.angle) * this.force;
            this.vy = Math.sin(this.angle) * this.force;
            this.rotation = (this.angle * 180) / Math.PI;
            this.move_counter = 0;
            this.move_total = Math.floor(this.target_distance / this.force);
        };
        obstacle[i].instance.setAttribute("display", "none");
        stage.appendChild(obstacle[i].instance);
    }
    pad = new MovieClip(document.getElementById("pad").cloneNode(true));
    pad.x = 0;
    pad.y = 0;
    pad.transform();
    pad.instance.setAttribute("pointer-events", "none");
    stage.appendChild(pad.instance);
    panel = new MovieClip(document.getElementById("panel").cloneNode(true));
    panel.initial_x = 390;
    panel.initial_y = 180;
    panel.inital_scale = 1;
    panel.target_x = 390;
    panel.target_y = 340;
    panel.target_scale = 1.5;
    panel.x = panel.initial_x;
    panel.y = panel.initial_y;
    panel.scale = panel.inital_scale;
    panel.large = false;
    panel.transform();
    panel.tweenComplete = function () {
        if (this.large) {
            problem.text.instance.textContent = goal_num.toLocaleString('fa') + " = " + "؟" + " + " + number1.toLocaleString('fa');
            layout_selections();
        }
    };
    stage.appendChild(panel.instance);
    for (var i = 1; i <= 10; i++) {
        box[i] = new MovieClip(document.getElementById("box").cloneNode(true));
        if (i <= 5) {
            box[i].x = box_initial_x + (i - 1) * box_dimension;
            box[i].y = box_initial_y;
        } else {
            box[i].x = box_initial_x + (i - 6) * box_dimension;
            box[i].y = box_initial_y + box_dimension;
        }
        box[i].transform();
        box[i].reward = new MovieClip(document.getElementById("reward").cloneNode(true));
        box[i].reward.scale = 1;
        box[i].reward.transform();
        box[i].reward.frame_total = 10;
        box[i].reward.frames = new Array();
        for (var m = 1; m <= box[i].reward.frame_total; m++) {
            box[i].reward.frames[m] = box[i].reward.instance.querySelector("#frame" + m);
        }
        box[i].instance.appendChild(box[i].reward.instance);
        panel.instance.appendChild(box[i].instance);
    }
    for (var i = 1; i <= selection_total; i++) {
        selection[i] = new MovieClip(document.getElementById("button_choice").cloneNode(true));
        selection[i].x = selection_initial_x + (i - 1) * selection_width;
        selection[i].y = selection_initial_y;
        selection[i].scale = 2;
        selection[i].transform();
        selection[i].text = new MovieClip(selection[i].instance.querySelector("#text_container"));
        selection[i].instance.setAttribute("data-id", i);
        selection[i].instance.setAttribute("display", "none");
        stage.appendChild(selection[i].instance);
    }
    button_start = new MovieClip(document.getElementById("button_start").cloneNode(true));
    button_start.x = 390;
    button_start.y = 650;
    button_start.scale = 2;
    button_start.transform();
    button_start.text = new MovieClip(button_start.instance.querySelector("#text_container"));
    button_start.text.instance.textContent = "مرحله " + level.toLocaleString('fa');
    button_back = new MovieClip(document.getElementById('button_back').cloneNode(true));
    button_back.x = 190; button_back.y = 650; button_back.scale = 1.1; button_back.transform();
    stage.appendChild(button_back.instance);
    button_back.instance.setAttribute("display", "none");
    stage.appendChild(button_start.instance);
    feedback = new MovieClip(document.getElementById("feedback").cloneNode(true));
    feedback.x = 390;
    feedback.y = 490;
    feedback.transform();
    feedback.text1 = new MovieClip(feedback.instance.querySelector("#text_container1"));
    feedback.text2 = new MovieClip(feedback.instance.querySelector("#text_container2"));
    stage.appendChild(feedback.instance);
    feedback.text1.instance.textContent = ".برای جمع‌آوری جواهرات روی شروع کلیک کن";
    feedback.text2.instance.textContent = "!مراقب خفّاش ها باش";
    addPointerListeners();
    requestAnimationFrame(move_timer_handler);
}
function move_timer_handler(timestamp) {
    elapsed_time = timestamp - start_time;
    if (render_run && elapsed_time >= render_frame_rate) {
        start_time = timestamp;
        if (rope_run) {
            if (rope.move_counter < rope.move_total) {
                rope.move_counter++;
                if (rope.complete) {
                    rope.x1 += rope.vx;
                    rope.y1 += rope.vy;
                    rope.instance.setAttribute("x1", rope.x1);
                    rope.instance.setAttribute("y1", rope.y1);
                    product.x = rope.x1;
                    product.y = rope.y1;
                    product.transform();
                    if (rope.first_complete) {
                        product.playFrames(product.fly);
                    }
                } else {
                    rope.x2 += rope.vx;
                    rope.y2 += rope.vy;
                    rope.instance.setAttribute("x2", rope.x2);
                    rope.instance.setAttribute("y2", rope.y2);
                    hook.x = rope.x2;
                    hook.y = rope.y2;
                    hook.transform();
                }
            } else {
                if (rope.complete) {
                    rope_run = false;
                    rope.x1 = intersection_x;
                    rope.y1 = intersection_y;
                    rope.saved_x1 = rope.x1;
                    rope.saved_y1 = rope.y1;
                    rope.instance.setAttribute("x1", rope.x1);
                    rope.instance.setAttribute("y1", rope.y1);
                    rope.wall_id = rope.next_wall_id;
                    product.x = rope.x1;
                    product.y = rope.y1;
                    product.rotation = wall[rope.wall_id].angle + 270;
                    product.transform();
                    product.playFrames(product.start);
                    hook.instance.setAttribute("display", "none");
                    for (var i = 1; i <= reward_total; i++) {
                        if (!reward[i].hit && hitTestDistance(product, reward[i])) {
                            sound_catch.play();
                            reward[i].hit = true;
                            reward[i].instance.setAttribute("display", "none");
                            var id = reward[i].id;
                            if (id == level + level - 1) {
                                for (var m = 1; m <= hit_counter; m++) {
                                    if (box[m].id == level + level) {
                                        box[m].id = id;
                                        box[m].reward.playFrames([box[m].id]);
                                        id = level + level;
                                        break;
                                    }
                                }
                            }
                            hit_counter++;
                            box[hit_counter].id = id;
                            box[hit_counter].reward.playFrames([box[hit_counter].id]);
                            box[hit_counter].reward.instance.setAttribute("display", "inline");
                            if (hit_counter == 10) {
                                render_run = false;
                                end = true;
                                feedback.text1.instance.textContent = "به جای علامت سوال چه عددی قرار دهیم؟";
                                feedback.text2.instance.textContent = "";
                                background.instance.setAttribute("display", "none");
                                panel.large = true;
                                panel.tweenStart(500, panel.target_x, panel.target_y, panel.target_scale, "current", "current");
                                product.instance.setAttribute("display", "none");
                                for (var i = 1; i <= obstacle_max; i++) {
                                    obstacle[i].instance.setAttribute("display", "none");
                                }
                            }
                        }
                    }
                    if (!end) {
                        pad.instance.setAttribute("pointer-events", "all");
                    }
                } else {
                    rope.move_counter = 0;
                    rope.complete = true;
                    rope.first_complete = true;
                    rope.x2 = intersection_x;
                    rope.y2 = intersection_y;
                    rope.instance.setAttribute("x2", rope.x2);
                    rope.instance.setAttribute("y2", rope.y2);
                }
            }
        }
        for (var i = 1; i <= obstacle_total[level]; i++) {
            obstacle[i].move_counter++;
            if (obstacle[i].move_counter < obstacle[i].move_total) {
                obstacle[i].x += obstacle[i].vx;
                obstacle[i].y += obstacle[i].vy;
                if (!end && hitTestDistance(obstacle[i], product)) {
                    render_run = false;
                    rope_run = false;
                    console.log("برخورد کردی که")
                    sound_hit.play();
                    end = true;
                    feedback.text1.instance.textContent = "!تو با خفّاش برخورد کردی";
                    feedback.text2.instance.textContent = ".بیا دوباره امتحان کنیم";
                    pad.instance.setAttribute("pointer-events", "none");
                    button_start.instance.setAttribute("display", "inline");
                }
            } else {
                obstacle[i].x = obstacle[i].target_x;
                obstacle[i].y = obstacle[i].target_y;
                obstacle[i].pick_target();
            }
            obstacle[i].transform();
        }
    }
    requestAnimationFrame(move_timer_handler);
}
function start_game() {
    if (level == 1)
        SendLogToServer("game_started", level, 0, "");
    end = false;
    display_level();
    for (var i = 1; i <= 10; i++) {
        box[i].reward.instance.setAttribute("display", "none");
    }
    if (panel.large) {
        panel.large = false;
        panel.tweenStart(500, panel.initial_x, panel.initial_y, panel.inital_scale, "current", "current");
    }
    product.playFrames(product.start);
    feedback.text1.instance.textContent = "";
    feedback.text2.instance.textContent = "";
    problem.text.instance.textContent = "";
    pad.instance.setAttribute("pointer-events", "all");
    render_run = true;
}
function display_level() {
    hit_counter = 0;
    number1 = generateRandom(1, 9);
    number2 = 10 - number1;
    for (i = 1; i <= wall_total; i++) {
        wall[i].x1 = wall_x1[i];
        wall[i].x2 = wall_x2[i];
        wall[i].y1 = wall_y1[i];
        wall[i].y2 = wall_y2[i];
        wall[i].instance.setAttribute("x1", wall[i].x1);
        wall[i].instance.setAttribute("x2", wall[i].x2);
        wall[i].instance.setAttribute("y1", wall[i].y1);
        wall[i].instance.setAttribute("y2", wall[i].y2);
        wall[i].angle = (getDirection(wall[i].x1, wall[i].x2, wall[i].y1, wall[i].y2) * 180) / Math.PI;
    }
    rope.wall_id = generateRandom(1, wall_total);
    var x1 = wall[rope.wall_id].x1;
    var x2 = wall[rope.wall_id].x2;
    var y1 = wall[rope.wall_id].y1;
    var y2 = wall[rope.wall_id].y2;
    var u = generateRandom(2, 9) / 10;
    rope.x1 = x1 + u * (x2 - x1);
    rope.x2 = rope.x1;
    rope.y1 = y1 + u * (y2 - y1);
    rope.y2 = rope.y1;
    rope.saved_x1 = rope.x1;
    rope.saved_y1 = rope.y1;
    rope.instance.setAttribute("x1", rope.x1);
    rope.instance.setAttribute("x2", rope.x2);
    rope.instance.setAttribute("y1", rope.y1);
    rope.instance.setAttribute("y2", rope.y2);
    product.x = rope.x1;
    product.y = rope.y1;
    product.rotation = wall[rope.wall_id].angle + 270;
    product.transform();
    product.playFrames(product.start);
    product.instance.setAttribute("display", "inline");
    hook.instance.setAttribute("display", "none");
    for (var i = 1; i <= obstacle_max; i++) {
        obstacle[i].instance.setAttribute("display", "none");
    }
    for (var i = 1; i <= obstacle_total[level]; i++) {
        obstacle[i].x = generateRandom(250, 600);
        obstacle[i].y = generateRandom(300, 500);
        obstacle[i].transform();
        obstacle[i].playFrames(obstacle[i].fly);
        obstacle[i].pick_target();
        obstacle[i].instance.setAttribute("display", "inline");
    }
    var list = new Array();
    var valid;
    for (var i = 1; i <= reward_total; i++) {
        do {
            valid = true;
            list[i] = new Array();
            list[i][0] = generateRandom(1, wall_total);
            list[i][1] = generateRandom(2, 9) / 10;
            if (list[i][0] == rope.wall_id) {
                valid = false;
            } else {
                for (var m = 1; m <= list.length - 1; m++) {
                    if (list[i][0] == list[m][0] && list[i][1] == list[m][1]) {
                        if (i != m) {
                            valid = false;
                        }
                    }
                }
            }
        } while (!valid);
    }
    for (var i = 1; i <= reward_total; i++) {
        var ran_wall = list[i][0];
        var x1 = wall[ran_wall].x1;
        var x2 = wall[ran_wall].x2;
        var y1 = wall[ran_wall].y1;
        var y2 = wall[ran_wall].y2;
        var u = list[i][1];
        reward[i].x = x1 + u * (x2 - x1);
        reward[i].y = y1 + u * (y2 - y1);
        reward[i].transform();
        reward[i].hit = false;
        if (i <= number1) {
            reward[i].id = level + level - 1;
        } else {
            reward[i].id = level + level;
        }
        reward[i].playFrames([reward[i].id]);
        reward[i].instance.setAttribute("display", "inline");
    }
}
function layout_selections() {
    var ran;
    var list_number = new Array();
    var list = new Array();
    for (i = 1; i <= reward_total; i++) {
        if (i != number2) {
            list_number.push(i);
        }
    }
    for (i = 1; i <= selection_total; i++) {
        ran = generateRandom(0, list_number.length - 1);
        list[i] = list_number[ran];
        list_number.splice(ran, 1);
    }
    for (i = 1; i <= selection_total; i++) {
        selection[i].instance.setAttribute("display", "inline");
        selection[i].text.instance.textContent = list[i].toLocaleString('fa');
    }
    correct = generateRandom(1, selection_total);
    selection[correct].text.instance.textContent = number2.toLocaleString('fa');
}
function start_handler(event) {
    button_back.instance.setAttribute("display", "none");
    event.preventDefault();
    if (event.isPrimary) {
        if (!inital_sound) {
            inital_sound = true;
            sound_initial.play();
        }
        button_start.instance.setAttribute("display", "none");
        document.getElementById('text_container2').setAttribute("display", "none");
        document.getElementById('text_container1').setAttribute("display", "none");
        background.instance.setAttribute("display", "inline");
        start_game();
    }
}
function target_handler(event) {
    event.preventDefault();
    if (event.isPrimary) {
        this.setAttribute("pointer-events", "none");
        stagePointer.x = event.clientX;
        stagePointer.y = event.clientY;
        var m = stage.getScreenCTM();
        stagePointer = stagePointer.matrixTransform(m.inverse());
        rope.angle = getDirection(stagePointer.x, rope.x1, stagePointer.y, rope.y1);
        rope.vx = Math.cos(rope.angle) * max_rope_length;
        rope.vy = Math.sin(rope.angle) * max_rope_length;
        rope.x2 = rope.x1 + rope.vx;
        rope.y2 = rope.y1 + rope.vy;
        rope.valid = false;
        var x3 = rope.x1;
        var x4;
        var y3 = rope.y1;
        var y4;
        var x1;
        var x2;
        var y1;
        var y2;
        var u1;
        var u2;
        var min_valid;
        for (i = 1; i <= wall_total; i++) {
            if (i != rope.wall_id) {
                x4 = rope.x2;
                y4 = rope.y2;
                x1 = wall[i].x1;
                x2 = wall[i].x2;
                y1 = wall[i].y1;
                y2 = wall[i].y2;
                u1 = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
                u2 = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
                if (u1 >= 0 && u1 <= 1 && u2 >= 0 && u2 <= 1) {
                    intersection_x = x1 + u1 * (x2 - x1);
                    intersection_y = y1 + u1 * (y2 - y1);
                    x4 = intersection_x;
                    y4 = intersection_y;
                    min_valid = true;
                    for (m = 1; m <= wall_total; m++) {
                        if (m != rope.wall_id && m != i) {
                            x1 = wall[m].x1;
                            x2 = wall[m].x2;
                            y1 = wall[m].y1;
                            y2 = wall[m].y2;
                            u1 = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
                            u2 = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
                            if (u1 >= 0 && u1 <= 1 && u2 >= 0 && u2 <= 1) {
                                min_valid = false;
                            }
                        }
                    }
                    if (min_valid) {
                        intersection_length = getDistance(rope.x1, intersection_x, rope.y1, intersection_y);
                        if (intersection_length > rope_min_length) {
                            rope.valid = true;
                            rope.next_wall_id = i;
                            break;
                        }
                    }
                }
            }
        }
        if (rope.valid) {
            product.playFrames(product.shoot);
            hook.instance.setAttribute("display", "inline");
            hook.rotation = (rope.angle * 180) / Math.PI;
            hook.transform();
            product.rotation = (rope.angle * 180) / Math.PI;
            product.transform();
            rope.complete = false;
            rope.force = intersection_length / rope.move_total;
            rope.vx = Math.cos(rope.angle) * rope.force;
            rope.vy = Math.sin(rope.angle) * rope.force;
            rope.x2 = rope.x1;
            rope.y2 = rope.y1;
            rope.move_counter = 0;
            rope_run = true;
        } else {
            this.setAttribute("pointer-events", "all");
        }
    }
}
  // if (level < level_max) {
            //     SendLogToServer("level_completed", level, 0, "");
            //     level++;
            //     sound_success.play();
            //     // فرض بر این است که number1، number2 و goal_num از خارج تعریف شده‌اند و مقادیر آن‌ها مشخص است

            //     // تعیین متن خط اول و خط دوم
            //     const firstLineText = "آفرین عزیزم";
            //     const secondLineText = `${number1.toLocaleString('fa')} + ${number2.toLocaleString('fa')} = ${goal_num.toLocaleString('fa')}`;

            //     // قرار دادن متن در عناصر
            //     document.getElementById('text_container1').textContent = firstLineText;
            //     document.getElementById('text_container2').textContent = secondLineText;

            //     // نمایش گروه (گرافیکی)
            //     document.getElementById('feedback').setAttribute('display', 'inline');

            //     //   feedback.text1.instance.textContent =   number1.toLocaleString('fa') + " + " + number2.toLocaleString('fa') + " = " + goal_num.toLocaleString('fa') + "!آفرین عزیزم" + "                                                                                                     ";
            //     button_start.text.instance.textContent = "مرحله " + level.toLocaleString('fa');
            //     button_start.instance.setAttribute("display", "inline");
            // }
function select_handler(event) {
    event.preventDefault();
    if (event.isPrimary) {
        for (var i = 1; i <= selection_total; i++) {
            selection[i].instance.setAttribute("display", "none");
        }
        if (this.getAttribute("data-id") == correct) {
          
            if (level < level_max) {
                SendLogToServer("level_completed", level, 0, "");
                level++;
                sound_success.play();
            
                const firstLineText = "!آفرین عزیزم";
                const secondLineText = `${number1.toLocaleString('fa')} + ${number2.toLocaleString('fa')} = ${goal_num.toLocaleString('fa')}`;
            
              
                document.getElementById('text_container1').textContent = firstLineText;
                document.getElementById('text_container2').textContent = secondLineText;
            
             
                const feedbackGroup = document.getElementById('feedback');
                feedbackGroup.setAttribute('display', 'inline');
                document.getElementById('text_container2').setAttribute("display", "inline");
                document.getElementById('text_container1').setAttribute("display", "inline");
            
                document.getElementById('text_container1').setAttribute('x', '50%'); 
                document.getElementById('text_container1').setAttribute('y', '520');  
            
                document.getElementById('text_container2').setAttribute('x', '50%'); 
                document.getElementById('text_container2').setAttribute('y', '550');  
            
   
                button_start.text.instance.textContent = "مرحله " + level.toLocaleString('fa');
                button_start.instance.setAttribute("display", "inline");
            }
            
            else {
                SendLogToServer("game_completed", level, 0, "");
                sound_final_success.play();


                var completionMessage = document.getElementById("completionMessage");
                completionMessage.style.display = "block";

 
                button_back.instance.setAttribute("display", "none");
                button_start.instance.setAttribute("display", "none");
                level = 1;

                setTimeout(function () {
                    completionMessage.style.display = "none"; 

                   
                    button_start.instance.setAttribute("display", "inline");
                    button_start.text.instance.textContent = "مرحله " + level.toLocaleString('fa');
                },
                    4000);


            }
         }
       
        else {
            SendLogToServer("level_failed", level, 0, "");
            sound_failure.play();
            
  
            const firstLineText ="!"+"جواب اشتباه است";
            const secondLineText = `${number1.toLocaleString('fa')} + ${number2.toLocaleString('fa')} = ${goal_num.toLocaleString('fa')}: پاسخ صحیح`;
            
      
            document.getElementById('text_container1').textContent = firstLineText;
            document.getElementById('text_container2').textContent = secondLineText;
            

            const feedbackGroup = document.getElementById('feedback');
            feedbackGroup.setAttribute('display', 'inline');
            document.getElementById('text_container2').setAttribute("display", "inline");
            document.getElementById('text_container1').setAttribute("display", "inline");

            const existingRect = feedbackGroup.querySelector("rect");
            if (existingRect) {
                feedbackGroup.removeChild(existingRect);
            }
        
   
            document.getElementById('text_container1').setAttribute('x', '50%'); 
            document.getElementById('text_container1').setAttribute('y', '528');  
        
            document.getElementById('text_container2').setAttribute('x', '50%'); 
            document.getElementById('text_container2').setAttribute('y', '556'); 
        
        
            button_start.text.instance.textContent = "مرحله " + level.toLocaleString('fa');
            button_start.instance.setAttribute("display", "inline");
        }
        
        feedback.text2.instance.textContent = "";

    }
}
 // else {
        //     SendLogToServer("level_failed", level, 0, "");
        //     sound_failure.play();
        //     feedback.text1.instance.textContent = number1.toLocaleString('fa') + " + " + number2.toLocaleString('fa') + " = " + goal_num.toLocaleString('fa') + ":اشتباه است! پاسخ صحیح";
        //     button_start.text.instance.textContent = "مرحله " + level.toLocaleString('fa');
        //     button_start.instance.setAttribute("display", "inline");
        // }
function set_data() {
    wall_x1[1] = 50;
    wall_x2[1] = 123;
    wall_y1[1] = 460;
    wall_y2[1] = 250;
    wall_x1[2] = wall_x2[1];
    wall_x2[2] = 427;
    wall_y1[2] = wall_y2[1];
    wall_y2[2] = 180;
    wall_x1[3] = wall_x2[2];
    wall_x2[3] = 666;
    wall_y1[3] = wall_y2[2];
    wall_y2[3] = 360;
    wall_x1[4] = wall_x2[3];
    wall_x2[4] = 710;
    wall_y1[4] = wall_y2[3];
    wall_y2[4] = 480;
    wall_x1[5] = wall_x2[4];
    wall_x2[5] = 591;
    wall_y1[5] = wall_y2[4];
    wall_y2[5] = 654;
    wall_x1[6] = wall_x2[5];
    wall_x2[6] = 372;
    wall_y1[6] = wall_y2[5];
    wall_y2[6] = 724;
    wall_x1[7] = wall_x2[6];
    wall_x2[7] = 180;
    wall_y1[7] = wall_y2[6];
    wall_y2[7] = 646;
    wall_x1[8] = wall_x2[7];
    wall_x2[8] = 123;
    wall_y1[8] = wall_y2[7];
    wall_y2[8] = 643;
    wall_x1[9] = wall_x2[8];
    wall_x2[9] = wall_x1[1];
    wall_y1[9] = wall_y2[8];
    wall_y2[9] = wall_y1[1];
    obstacle_total[1] = 1;
    obstacle_total[2] = 2;
    obstacle_total[3] = 3;
    obstacle_total[4] = 4;
    obstacle_total[5] = 5;
}
function addPointerListeners() {
    button_start.instance.addEventListener("pointerdown", start_handler, false);
    pad.instance.addEventListener("pointerdown", target_handler, false);
    for (var i = 1; i <= selection_total; i++) {
        selection[i].instance.addEventListener("pointerdown", select_handler, false);
    }
}
function SendLogToServer(_status, _level = 0, _score = 0, _description = "") {
    const data = {
        id: findGetParameter('id'),
        key: findGetParameter('key'),
        GameName: 'cavern',
        status: _status,
        level: _level,
        score: _score,
        description: _description
    };
    $.ajax({
        url: findGetParameter('callback'),
        method: 'POST',
        data: data,
        dataType: 'JSON',
        error: err => {
            console.log(err);
            console.log("cannot connect to server")
        },
        success: function (resp) {
            if (resp.status == 'success') {
                //console.log("OK");
                //console.log(resp);
                console.log(data);
            } else {
                //console.log("failed");
            }
        }
    })
}
function findGetParameter(parameterName) {
    var result = null,
        tmp = [];
    location.search
        .substr(1)
        .split("&")
        .forEach(function (item) {
            tmp = item.split("=");
            if (tmp[0] === parameterName) result = decodeURIComponent(tmp[1]);
        });
    return result;
}
