function move_complete_player() {
    switch (this.move_phase) {
        case "drop1":
            sound_catch.play();
            card_move(30, 100, "none", "drop2");
            cast[0].sprite_animation = "catch1";
            cast[0].frame = 0;
            break;
        case "drop2":
            card_move(-40, 100, "none", "drop3");
            cast[0].sprite_animation = "catch2";
            cast[0].frame = 0;
            break;
        case "drop3":
            cast[0].sprite_animation = "catch3";
            cast[0].frame = 0;
            setTimeout(new_problem, 200);
            break;
        case "drop4":
            player[0].y = player_start_y;
            card_move(570, 500, "out", "drop1");
            break;
    }
}

function move() {
    if (this.moving) {
        var time_change = get_time() - this.move_start_time;
        var ease_ratio;
        if (time_change >= this.move_total_time) {
            ease_ratio = 1;
            this.x = this.move_total_x * ease_ratio + this.move_start_x;
            this.y = this.move_total_y * ease_ratio + this.move_start_y;
            this.moving = false;
            this.move_complete();
        } else {
            var time_ratio = time_change / this.move_total_time;
            switch (this.ease_type) {
                case "none":
                    ease_ratio = time_ratio;
                    break;
                case "in":
                    ease_ratio = ease_in(time_ratio);
                    break;
                case "out":
                    ease_ratio = ease_out(time_ratio);
                    break;
            }
            this.x = this.move_total_x * ease_ratio + this.move_start_x;
            this.y = this.move_total_y * ease_ratio + this.move_start_y;
        }
    }
}

function get_time() {
    var d = new Date();
    return d.getTime();
}

function ease_in(pass) {
    return Math.pow(pass, 2);
}

function ease_out(pass) {
    return 1 - Math.pow(1 - pass, 2);
}