function create_item_map(type) {
    var matter = data[type].matter;
    var index = matter.length;
    matter[index] = new Object;
    matter[index].matter = matter;
    matter[index].type = type;
    matter[index].callback = new Array;
    matter[index].frame = data[type].frame;
    matter[index].move = data[type].move;
    matter[index].move_complete = data[type].move_complete;
    return matter[index];
}

function place_item_map(item, x, y, animation) {
    item.active = true;
    item.moving = false;
    item.x = x;
    item.y = y;
    item.sprite_animation = animation;
    return item;
}

function render_prepare() {
    var ran;
    var sprite_render;
    var local_data;
    var type;
    var animation_title;
    var animation_length;
    var frame;
    var x;
    var y;
    render_list = new Array;
    for (var k = 0; k < live_data.length; k++) {
        local_data = live_data[k];
        type = local_data.type;
        sprite_render = data[type].sprite_type[data[type].sprite_id];
        if (data[type].matter == background) {
            frame = local_data.frame;
            animation_title = local_data.sprite_animation;
            x = local_data.x;
            y = local_data.y;
            render_list.push([sprite_render, animation_title, frame, x, y]);
        }
    }
    for (var k = 0; k < live_data.length; k++) {
        local_data = live_data[k];
        type = local_data.type;
        sprite_render = data[type].sprite_type[data[type].sprite_id];
        if (data[type].matter == player) {
            frame = local_data.frame;
            animation_title = local_data.sprite_animation;
            local_data.move();
            x = local_data.x;
            y = local_data.y;
            render_list.push([sprite_render, animation_title, frame, x, y]);
        }
    }
    for (var k = 0; k < live_data.length; k++) {
        local_data = live_data[k];
        type = local_data.type;
        sprite_render = data[type].sprite_type[data[type].sprite_id];
        if (data[type].matter == cast) {
            frame = local_data.frame;
            animation_title = local_data.sprite_animation;
            animation_length = sprite_render.animation[local_data.sprite_animation].length - 1;
            if (local_data.frame < animation_length) {
                local_data.frame++;
            }
            x = local_data.x;
            y = local_data.y;
            render_list.push([sprite_render, animation_title, frame, x, y]);
            if (local_data.callback[local_data.frame] != null && local_data.callback[local_data.frame].length > 0) {
                local_data.callback[local_data.frame][0]();
                local_data.callback[local_data.frame].shift();
            }
        }
    }
    for (var k = 0; k < live_data.length; k++) {
        local_data = live_data[k];
        type = local_data.type;
        sprite_render = data[type].sprite_type[data[type].sprite_id];
        if (data[type].matter == effect && local_data.active) {
            frame = local_data.frame;
            animation_title = local_data.sprite_animation;
            animation_length = sprite_render.animation[local_data.sprite_animation].length - 1;
            if (local_data.frame < animation_length) {
                local_data.frame++;
            } else {
                local_data.active = false;
            }
            x = local_data.x;
            y = local_data.y;
            render_list.push([sprite_render, animation_title, frame, x, y]);
        }
    }
    render_ready = true;
}

function render_map(timestamp) {
    var elapsed_time = timestamp - start_time;
    if (render_ready && elapsed_time >= 100) {
        context.clearRect(0, 0, 780, 750);
        var counter = 0;
        for (var i = 0; i < render_list.length; i++) {
            draw_sprite(render_list[i][0], render_list[i][1], render_list[i][2], render_list[i][3], render_list[i][4]);
        }
        render_ready = false;
        start_time = timestamp;
        render_prepare();
    }
    if (render_map_run) {
        requestAnimationFrame(render_map);
    }
}

function draw_sprite(sprite, animation_title, frame_number, x, y) {
    var animation_data = sprite.animation[animation_title][frame_number];
    context.drawImage(sprite, animation_data[0], animation_data[1], animation_data[2], animation_data[3], x, y, animation_data[2], animation_data[3]);
}