/*
 * Contributed by Rahul Jhaveri on 26/04/17.
 * JhavTech Studios Pty Ltd (2017)
 * http://www.jhavtech.com.au
 */

var Tiling = function() {};
Tiling.prototype = new Object();

Tiling.prototype.init = function() {
	this.setDimensions(this.dimensions, false);
	this.setDragRegion(this.dragRegion);
	this.setDropRegion(this.dropRegion);
	this.setDraggable(this.draggable);
	this.setSnapTo(this.snapTo);
	this.setTileType(this.tileType, false);
	this.draw();
	if (this.tile_mc!=undefined) this.tile_mc.style.display = "none";
	if (this.glow_mc!=undefined) this.glow_mc.style.display = "none";
};

Tiling.prototype.getDimensions = function() {
	return this.dimensions;
};

Tiling.prototype.setDimensions = function(dimensions, redraw) {
	redraw = (redraw == undefined ? true : redraw);
	this.dimensions = dimensions;
	if (redraw) {
		this.draw();
	}
};

Tiling.prototype.getDragRegion = function() {
	return this.dragRegion;
};

Tiling.prototype.setDragRegion = function(dragRegion) {
	this.dragRegion = dragRegion;
};

Tiling.prototype.getDropRegion = function() {
	return this.dropRegion;
};

Tiling.prototype.setDropRegion = function(dropRegion) {
	this.dropRegion = dropRegion;
};

Tiling.prototype.getDraggable = function() {
	return this.draggable;
};

Tiling.prototype.doMouseMoveAction = function(e) {
	if (rSelectedDragItem!=null) {
		var rObjClientRectOne, rClientRectOne;
		var rChild, rMainParentId;
		var rMouseX = rMouseY = 0;
		
		rMainParentId = this.objMain.id;
		
		rObjClientRectOne = document.getElementById("divMainPanel");
		rClientRectOne = rObjClientRectOne.getBoundingClientRect();	

		var touch = undefined;
		//if (e.originalEvent.touches) touch = e.originalEvent.touches[0];
		if (e.touches) touch = e.touches[0];
		var pos_x, pos_y;
		if (touch==undefined) {
			pos_x = e.pageX;
			pos_y = e.pageY;
		} else {
			pos_x = touch.pageX;
			pos_y = touch.pageY;			
		}
		
		var x = y = 0;
		if (isMobile.any()) {
			rMouseX = pos_x-document.getElementById("divMainPanel").offsetLeft;
			rMouseY = pos_y-document.getElementById("divMainPanel").offsetTop;
			
			x = rMouseX - this.offset[0];
			y = rMouseY - this.offset[1];
		} else {
			rMouseX = (pos_x - rClientRectOne.left)*(document.getElementById("divMainPanel").offsetWidth/rClientRectOne.width);
			rMouseY = (pos_y - rClientRectOne.top)*(document.getElementById("divMainPanel").offsetHeight/rClientRectOne.height);			
			
			x = rMouseX - 17.5;
			y = rMouseY - 17.5;			
		}
		
		var dragRegion = this.dragRegion;
		if (dragRegion.length != 0) {
			x = Math.min((dragRegion[1][0]-this.dimensions[1]*35), Math.max(dragRegion[0][0], x));
			y = Math.min((dragRegion[1][1]-this.dimensions[0]*35), Math.max(dragRegion[0][1], y));
		}
		this.objMain.style.left = Math.round(x) + "px";
		this.objMain.style.top = Math.round(y) + "px";
	}
};

Tiling.prototype.doMouseMove = function(e) {
	this.doMouseMoveAction(e, this);
};

Tiling.prototype.doMouseUpAction = function(e) {
	if (rSelectedDragItem!=null) {
		rSelectedDragItem = null;
		var dragRegion = this.dragRegion;
		var dropRegion = this.dropRegion;
		this.xRaw = Number(this.objMain.style.left.split("px")[0]);
		this.yRaw = Number(this.objMain.style.top.split("px")[0]);
		if (this.snapTo) {
			if (dragRegion.length == 0) {
				this.objMain.style.left = (Math.round((Number(this.objMain.style.left.split("px")[0])/35))*35) + "px";
				this.objMain.style.top = (Math.round((Number(this.objMain.style.top.split("px")[0])/35))*35) + "px";
			} else {
				this.objMain.style.left = (dragRegion[0][0]+Math.round((Number(this.objMain.style.left.split("px")[0])-dragRegion[0][0])/35)*35) + "px";
				this.objMain.style.top = (dragRegion[0][1]+Math.round((Number(this.objMain.style.top.split("px")[0])-dragRegion[0][1])/35)*35) + "px";
				this.objMain.style.left =  ((Number(this.objMain.style.left.split("px")[0])) - (Number(this.objMain.style.left.split("px")[0])+this.dimensions[1]*35>dragRegion[1][0] ? 35 : 0)) + "px";
				this.objMain.style.top = ((Number(this.objMain.style.top.split("px")[0])) - (Number(this.objMain.style.top.split("px")[0])+this.dimensions[0]*35>dragRegion[1][1] ? 35 : 0)) + "px";
			}
		}
		if (this.dropRegion.length != 0 && (Number(this.objMain.style.left.split("px")[0])<dropRegion[0][0] || Number(this.objMain.style.top.split("px")[0])<dropRegion[0][1] || Number(this.objMain.style.left.split("px")[0])+this.dimensions[1]*35>dropRegion[1][0] || Number(this.objMain.style.top.split("px")[0])+this.dimensions[0]*35>dropRegion[1][1])) {
			this.objMain.style.left = this.xStart + "px";
			this.objMain.style.top = this.yStart + "px";
			this.inDropRegion = false;
		} else {
			this.inDropRegion = true;
		}
		
		delete this.offset;
		delete this.xStart;
		delete this.yStart;

		this.onDrop();
	}
};

Tiling.prototype.doMouseUp = function(e) {
	this.doMouseUpAction(e, this);
};

Tiling.prototype.doSetDraggable = function(e) {
	if (this.draggable) {
		this.objMain.getElementsByTagName("div")[1].removeAttribute("class");
	}
	
	rSelectedDragItem = this;
	var rThis = this;
	
	var touch = undefined;
	//if (e.originalEvent.touches) touch = e.originalEvent.touches[0];
	if (e.touches) touch = e.touches[0];
	var pos_x, pos_y;
	if (touch==undefined) {
		pos_x = e.pageX;
		pos_y = e.pageY;
	} else {
		pos_x = touch.pageX;
		pos_y = touch.pageY;			
	}	

	var rMouseX = pos_x - Number(this.objMain.style.left.split("px")[0]);
	var rMouseY = pos_y - Number(this.objMain.style.top.split("px")[0]);
	
	this.offset = [rMouseX, rMouseY];
	this.xStart = Number(this.objMain.style.left.split("px")[0]);
	this.yStart = Number(this.objMain.style.top.split("px")[0]);

	rEventHanler = function(e) { rThis.doMouseMove(e); };
	this.objMain.addEventListener("mousemove", rEventHanler , false);
	this.objMain.addEventListener("touchmove", rEventHanler , false);
};

Tiling.prototype.setDraggable = function(draggable) {
	var rThis = this;
	this.draggable = draggable;
	if (draggable) {
		rEventHanler = function(e) { rThis.doSetDraggable(e); };
		this.objMain.addEventListener("mousedown", rEventHanler , false);
		this.objMain.addEventListener("touchstart", rEventHanler , false);
		
		rEventHanler = function(e) { rThis.doMouseUp(e); };
		this.objMain.addEventListener("mouseup", rEventHanler , false);
		this.objMain.addEventListener("touchend", rEventHanler , false);
	} else {
		delete this.offset;
		delete this.onPress;
	}
};

Tiling.prototype.getSnapTo = function() {
	return this.snapTo;
};

Tiling.prototype.setSnapTo = function(snapTo) {
	this.snapTo = snapTo;
};

Tiling.prototype.getTileType = function() {
	return this.tileType;
};

Tiling.prototype.setTileType = function(tileType, redraw) {
	redraw = (redraw == undefined ? true : redraw);
	this.tileType = tileType;
	if (redraw) {
		this.draw();
	}
};

Tiling.prototype.regionLocation = function(region_mc) {
	return [(Number(this.objMain.style.top.split("px")[0])-Math.floor(Number(region_mc.objMain.style.top.split("px")[0])))/region_mc.cellSize[0], (Number(this.objMain.style.left.split("px")[0])-Math.floor(Number(region_mc.objMain.style.left.split("px")[0])))/region_mc.cellSize[1]];
};

Tiling.prototype.getArea = function() {
	var dimensions = this.dimensions;
	return dimensions[0]*dimensions[1];
};

Tiling.prototype.draw = function() {
	var i, j, level, name;
	var dimensions = this.dimensions;
	var tileType = this.tileType;
	for (name in this.objMain) {
		if (name.substring(0, 4) == "tile" && (name.indexOf("tile_mc") < 0 && name.indexOf("glow_mc") < 0)) {
			delete this[name];
		}
	}
	level = 1;
	var rHTML = "";
	for (i=0; i<dimensions[0]; i++) {
		for (j=0; j<dimensions[1]; j++) {
			var rTName = this.objMain.id + "_tile_mc_" + i + "_" + j;
			if (this.draggable) {
				rHTML += '<div id="' + rTName + '" name="' + rTName + '" style="position:absolute; width:35px; height:35px; left:' + (j*35) + 'px; top:' + (i*35) + 'px; cursor:pointer; border:0px solid #00ff00;">';
			} else {
				rHTML += '<div id="' + rTName + '" name="' + rTName + '" style="position:absolute; width:35px; height:35px; left:' + (j*35) + 'px; top:' + (i*35) + 'px; border:0px solid #00ff00;">';
			}
			rHTML += '<img src="' + rImageBasePath + 'tiling_' + String(tileType+1) + '.png" />';
			rHTML += '</div>';
		}
	}
	rTName = this.objMain.id + "_glow_mc";
	if (this.draggable) {
		rHTML += '<div id="' + rTName + '" name="' + rTName + '" class="effect1" style="position:absolute; width:' + this.objMain.style.width + '; height:' + this.objMain.style.height + '; left:0px; top:0px;">';
	} else {
		rHTML += '<div id="' + rTName + '" name="' + rTName + '" style="position:absolute; width:' + this.objMain.style.width + '; height:' + this.objMain.style.height + '; left:0px; top:0px;">';
	}
	rHTML += '</div>';	
	this.objMain.innerHTML = this.objMain.innerHTML + rHTML;
};