/*
 * Contributed by Rahul Jhaveri on 26/04/17.
 * JhavTech Studios Pty Ltd (2017)
 * http://www.jhavtech.com.au
 */

var Region = function() {};
Region.prototype = new Object();

Region.prototype.init = function() {
	this.setCover(this.cover, false);
	this.setCellSize(this.cellSize, false);
	this.setCellColour(this.cellColour, false);
	this.setCellAlpha(this.cellAlpha, false);
	this.setBorderColourExternal(this.borderColourExternal, false);
	this.setBorderColourInternal(this.borderColourInternal, false);
	this.setBorderAlphaExternal(this.borderAlphaExternal, false);
	this.setBorderAlphaInternal(this.borderAlphaInternal, false);
	this.setBorderThicknessExternal(this.borderThicknessExternal, false);
	this.draw(0);
	//this.marker_mc.style.display = "none";
}

Region.prototype.getCover = function() {
	return this.cover;
};

Region.prototype.setCover = function(cover, redraw) {
	redraw = (redraw == undefined ? true : redraw);
	this.cover = cover;
	if (redraw) {
		this.draw();
	}
};


Region.prototype.getCellSize = function() {
	return this.cellSize;
};

Region.prototype.setCellSize = function(cellSize, redraw) {
	redraw = (redraw == undefined ? true : redraw);
	this.cellSize = cellSize;
	if (redraw) {
		this.draw();
	}
};


Region.prototype.getCellColour = function() {
	return this.cellColour;
};

Region.prototype.setCellColour = function(cellColour, redraw) {
	redraw = (redraw == undefined ? true : redraw);
	this.cellColour = cellColour;
	if (redraw) {
		this.draw();
	}
};

Region.prototype.getCellAlpha = function() {
	return this.cellColour;
};

Region.prototype.setCellAlpha = function(cellAlpha, redraw) {
	redraw = (redraw == undefined ? true : redraw);
	this.cellAlpha = cellAlpha;
	if (redraw) {
		this.draw();
	}
};

Region.prototype.getBorderColourExternal = function() {
	return this.borderColourExternal;
};

Region.prototype.setBorderColourExternal = function(borderColourExternal, redraw) {
	redraw = (redraw == undefined ? true : redraw);
	this.borderColourExternal = borderColourExternal;
	if (redraw) {
		this.draw();
	}
};

Region.prototype.getBorderColourInternal = function() {
	return this.borderColourInternal;
};

Region.prototype.setBorderColourInternal = function(borderColourInternal, redraw) {
	redraw = (redraw == undefined ? true : redraw);
	this.borderColourInternal = borderColourInternal;
	if (redraw) {
		this.draw();
	}
};

Region.prototype.getBorderAlphaExternal = function() {
	return this.borderAlphaExternal;
};

Region.prototype.setBorderAlphaExternal = function(borderAlphaExternal, redraw) {
	redraw = (redraw == undefined ? true : redraw);
	this.borderAlphaExternal = borderAlphaExternal;
	if (redraw) {
		this.draw();
	}
};

Region.prototype.getBorderAlphaInternal = function() {
	return this.borderAlphaInternal;
};

Region.prototype.setBorderAlphaInternal = function(borderAlphaInternal, redraw) {
	redraw = (redraw == undefined ? true : redraw);
	this.borderAlphaInternal = borderAlphaInternal;
	if (redraw) {
		this.draw();
	}
};

Region.prototype.getBorderThicknessExternal = function() {
	return this.borderThicknessExternal;
};

Region.prototype.setBorderThicknessExternal = function(borderThicknessExternal, redraw) {
	redraw = (redraw == undefined ? true : redraw);
	this.borderThicknessExternal = borderThicknessExternal;
	if (redraw) {
		this.draw();
	}
};

Region.prototype.containsTiling = function(tiling_mc) {
	var contains = true;
	var P = new Object();
	for (var i = 0; i<=tiling_mc.dimensions[0]; i++) {
		for (var j = 0; j<=tiling_mc.dimensions[1]; j++) {
			var rObj = tiling_mc.objMain;
			var rRect = rObj.getBoundingClientRect();
			P.x = Number(tiling_mc.objMain.style.left.split("px")[0])+j*Number(tiling_mc.tile_mc.style.width.split("px")[0]);
			P.y = Number(tiling_mc.objMain.style.top.split("px")[0])+i*Number(tiling_mc.tile_mc.style.height.split("px")[0]);
			P.x = rRect.left;
			P.y = rRect.top;
			var element = document.elementFromPoint(P.x, P.y);
			//if (element.id.toUpperCase()==this.objMain.id.toUpperCase()) {
				//contains = true;
			//}
		}
	}
	return contains;
};

Region.prototype.addCover = function(tiling_mc) {
	var added = false;
	var cover = this.cover;
	var coverNew = new Array(cover.length);
	for (var i = 0; i<cover.length; i++) {
		coverNew[i] = cover[i].concat();
	}
	var cellSize = this.cellSize;
	if (this.containsTiling(tiling_mc)) {
		added = true;
		var P = new Object();
		for (var i = 0; i<tiling_mc.dimensions[0]; i++) {
			if (added) {
				for (var j = 0; j<tiling_mc.dimensions[1]; j++) {
					P.x = Number(tiling_mc.objMain.style.left.split("px")[0])+j*35;
					P.y = Number(tiling_mc.objMain.style.top.split("px")[0])+i*35;
					P.x = Number(P.x)-Number(this.objMain.style.left.split("px")[0]);
					P.y = Number(P.y)-Number(this.objMain.style.top.split("px")[0]);

					if (coverNew[Math.floor(P.y/cellSize[0])][Math.floor(P.x/cellSize[1])] == 0) {
						coverNew[Math.floor(P.y/cellSize[0])][Math.floor(P.x/cellSize[1])] = 1;
					} else {
						added = false;
						break;
					}
				}
			}
		}
	}
	if (added) {
		this.cover = coverNew.concat();
	}
	return added;
};

Region.prototype.draw = function() {
	if (this.cover!=undefined && this.cover.length>0) {
		var cover = this.cover;
		var cellSize = this.cellSize;
		var cellColour = this.cellColour;
		var cellAlpha = this.cellAlpha;
		var borderColourExternal = this.borderColourExternal;
		var borderColourInternal = this.borderColourInternal;
		var borderAlphaExternal = this.borderAlphaExternal;
		borderAlphaExternal = 100;
		var borderAlphaInternal = this.borderAlphaInternal;
		borderAlphaInternal = 50;
		var borderThicknessExternal = (this.borderThicknessExternal == undefined ? 1 : this.borderThicknessExternal);
		var external;
		var rLW, rColor, rAlpha;
		var c = this.canvas;
		var ctx = this.context;
		ctx.clearRect(0, 0, c.width, c.height);
		
		for (var i = 0; i<cover.length; i++) {
			for (var j = 0; j<cover[i].length; j++) {
				if (cover[i][j]>-1) {
					var x = j*cellSize[1] + 1;
					var y = i*cellSize[0] + 1;
					
					ctx.beginPath();
					ctx.moveTo(x, y);
					ctx.fillStyle = "rgba(" + hexToR(cellColour) + ", " + hexToG(cellColour) + ", " + hexToB(cellColour) + ", " + cellAlpha + ")";
					
					external = i == 0 || i>0 && cover[i-1][j] == -1;
					rLW = external ? borderThicknessExternal : 1;
					ctx.lineWidth = rLW;
					rColor = external ? borderColourExternal : borderColourInternal;
					rAlpha = (external ? borderAlphaExternal : borderAlphaInternal*(borderColourInternal != cellColour));
					rAlpha = Number(rAlpha/100);
					ctx.strokeStyle = "rgba(" + hexToR(rColor) + ", " + hexToG(rColor) + ", " + hexToB(rColor) + ", " + rAlpha + ")";
					ctx.lineTo(x+cellSize[1], y);
					
					external = j == cover[0].length-1 || j<cover[0].length-1 && cover[i][j+1] == -1;
					rLW = external ? borderThicknessExternal : 1;
					ctx.lineWidth = rLW;
					rColor = external ? borderColourExternal : borderColourInternal;
					rAlpha = (external ? borderAlphaExternal : borderAlphaInternal*(borderColourInternal != cellColour));
					rAlpha = Number(rAlpha/100);
					ctx.strokeStyle = "rgba(" + hexToR(rColor) + ", " + hexToG(rColor) + ", " + hexToB(rColor) + ", " + rAlpha + ")";
					ctx.lineTo(x+cellSize[1], y+cellSize[0]);
					
					external = i == cover.length-1 || i<cover.length-1 && cover[i+1][j] == -1;
					rLW = external ? borderThicknessExternal : 1;
					ctx.lineWidth = rLW;
					rColor = external ? borderColourExternal : borderColourInternal;
					rAlpha = (external ? borderAlphaExternal : borderAlphaInternal*(borderColourInternal != cellColour));
					rAlpha = Number(rAlpha/100);
					ctx.strokeStyle = "rgba(" + hexToR(rColor) + ", " + hexToG(rColor) + ", " + hexToB(rColor) + ", " + rAlpha + ")";
					ctx.lineTo(x, y+cellSize[0]);
					
					external = j == 0 || j>0 && cover[i][j-1] == -1;
					rLW = external ? borderThicknessExternal : 1;
					ctx.lineWidth = rLW;
					rColor = external ? borderColourExternal : borderColourInternal;
					rAlpha = (external ? borderAlphaExternal : borderAlphaInternal*(borderColourInternal != cellColour));
					rAlpha = Number(rAlpha/100);
					ctx.strokeStyle = "rgba(" + hexToR(rColor) + ", " + hexToG(rColor) + ", " + hexToB(rColor) + ", " + rAlpha + ")";
					ctx.lineTo(x, y);
					
					ctx.closePath();
					ctx.fill();
				}
			}
		}
		
		for (var i = 0; i<cover.length; i++) {
			for (var j = 0; j<cover[i].length; j++) {
				if (cover[i][j]>-1) {
					var x = j*cellSize[1] + 1;
					var y = i*cellSize[0] + 1;

					ctx.fillStyle = "rgba(" + hexToR(cellColour) + ", " + hexToG(cellColour) + ", " + hexToB(cellColour) + ", " + cellAlpha + ")";
					
					ctx.beginPath();
					ctx.moveTo(x, y);					
					external = i == 0 || i>0 && cover[i-1][j] == -1;
					rLW = external ? borderThicknessExternal : 1;
					rLW = external ? 1 : 0.3;
					ctx.lineWidth = rLW;
					rColor = external ? borderColourExternal : borderColourInternal;
					rAlpha = (external ? borderAlphaExternal : borderAlphaInternal*(borderColourInternal != cellColour));
					rAlpha = Number(rAlpha/100);
					ctx.strokeStyle = "rgba(" + hexToR(rColor) + ", " + hexToG(rColor) + ", " + hexToB(rColor) + ", " + rAlpha + ")";
					ctx.lineTo(x+cellSize[1], y);
					ctx.closePath();
					ctx.stroke();
					
					ctx.beginPath();
					ctx.moveTo(x+cellSize[1], y);					
					external = j == cover[0].length-1 || j<cover[0].length-1 && cover[i][j+1] == -1;
					rLW = external ? borderThicknessExternal : 1;
					rLW = external ? 1 : 0.3;
					ctx.lineWidth = rLW;
					rColor = external ? borderColourExternal : borderColourInternal;
					rAlpha = (external ? borderAlphaExternal : borderAlphaInternal*(borderColourInternal != cellColour));
					rAlpha = Number(rAlpha/100);
					ctx.strokeStyle = "rgba(" + hexToR(rColor) + ", " + hexToG(rColor) + ", " + hexToB(rColor) + ", " + rAlpha + ")";
					ctx.lineTo(x+cellSize[1], y+cellSize[0]);
					ctx.closePath();
					ctx.stroke();					
					
					ctx.beginPath();
					ctx.moveTo(x+cellSize[1], y+cellSize[0]);					
					external = i == cover.length-1 || i<cover.length-1 && cover[i+1][j] == -1;
					rLW = external ? borderThicknessExternal : 1;
					rLW = external ? 1 : 0.3;
					ctx.lineWidth = rLW;
					rColor = external ? borderColourExternal : borderColourInternal;
					rAlpha = (external ? borderAlphaExternal : borderAlphaInternal*(borderColourInternal != cellColour));
					rAlpha = Number(rAlpha/100);
					ctx.strokeStyle = "rgba(" + hexToR(rColor) + ", " + hexToG(rColor) + ", " + hexToB(rColor) + ", " + rAlpha + ")";
					ctx.lineTo(x, y+cellSize[0]);
					ctx.closePath();
					ctx.stroke();					
					
					ctx.beginPath();
					ctx.moveTo(x, y+cellSize[0]);					
					external = j == 0 || j>0 && cover[i][j-1] == -1;
					rLW = external ? borderThicknessExternal : 1;
					rLW = external ? 1 : 0.3;
					ctx.lineWidth = rLW;
					rColor = external ? borderColourExternal : borderColourInternal;
					rAlpha = (external ? borderAlphaExternal : borderAlphaInternal*(borderColourInternal != cellColour));
					rAlpha = Number(rAlpha/100);
					ctx.strokeStyle = "rgba(" + hexToR(rColor) + ", " + hexToG(rColor) + ", " + hexToB(rColor) + ", " + rAlpha + ")";
					ctx.lineTo(x, y);
					ctx.closePath();
					ctx.stroke();					
				}
			}
		}		
	}
};

Region.prototype.coverIsFull = function() {
	var cover = this.cover;
	var done = true;
	for (var i = 0; i<cover.length; i++) {
		for (var j = 0; j<cover[0].length; j++) {
			if (cover[i][j] == 0) {
				done = false;
				break;
			}
		}
	}
	return done;
};