/*
 * Contributed by Rahul Jhaveri on 26/04/17.
 * JhavTech Studios Pty Ltd (2017)
 * http://www.jhavtech.com.au
 */

var isMobile = {
    Android: function() {
        return /Android/i.test(navigator.userAgent);
    },
    BlackBerry: function() {
        return /BlackBerry/i.test(navigator.userAgent);
    },
    iOS: function() {
        return /iPhone|iPad|iPod/i.test(navigator.userAgent);
    },
    Windows: function() {
        return /IEMobile/i.test(navigator.userAgent);
    },
    any: function() {
        return (isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Windows());
    }
};

var rOSName="Unknown OS";
if (navigator.appVersion.indexOf("Win")!=-1) rOSName="Windows";
if (navigator.appVersion.indexOf("Mac")!=-1) rOSName="MacOS";
if (navigator.appVersion.indexOf("X11")!=-1) rOSName="UNIX";
if (navigator.appVersion.indexOf("Linux")!=-1) rOSName="Linux";

var isOpera = !!window.opera || navigator.userAgent.indexOf(' OPR/') >= 0;
var isFirefox = typeof InstallTrigger !== 'undefined';
var isSafari = Object.prototype.toString.call(window.HTMLElement).indexOf('Constructor') > 0;
var isChrome = !!window.chrome && !isOpera;
var isIE = false || !!document.documentMode;

var rFullScreen = true;
var rScaling = false;
var rMainDiv = null;
var rObjClientRect = null;
var rClientRect = null;
var rMainDivScaleProportional = true;
var rMainDivScaleX = 1;
var rMainDivScaleY = 1;

var rIMGPreLoader = new PxLoader();
var rPXmage;

rIMGPreLoader.addProgressListener(function(e) {
	var rPercent = (e.completedCount/e.totalCount)*100;
	var rPercentRound = rPercent.toFixed(0);
	$("#divLoaderBar").css('width', rPercentRound + '%');
	$("#divLoaderText").html('<font color="#ffffff">' + rPercentRound + '%</font> Loaded');
	if (e.completedCount>=e.totalCount) {
		$("#divLoaderBar").css('width', '100%');
		$("#divLoaderText").html('<font color="#ffffff">100%</font> Loaded');
		$('#divLoaderPanel').fadeOut(1000, function() {
			if (isMobile.any()) {
				doBegin();
			} else {
				doBegin();
			}
		});
	}
});

function doBegin() {
	doInit();
}

function doSetScale(rObjName, rMainDivScaleX, rMainDivScaleY) {
	$("#" + rObjName).css('-moz-transform', 'scale(' + rMainDivScaleX + ',' + rMainDivScaleY + ')');
	$("#" + rObjName).css('-webkit-transform', 'scale(' + rMainDivScaleX + ',' + rMainDivScaleY + ')');
	$("#" + rObjName).css('-ms-transform', 'scale(' + rMainDivScaleX + ',' + rMainDivScaleY + ')');
	$("#" + rObjName).css('-o-transform', 'scale(' + rMainDivScaleX + ',' + rMainDivScaleY + ')');
	$("#" + rObjName).css('transform', 'scale(' + rMainDivScaleX + ',' + rMainDivScaleY + ')');
}

function doFullScreen(rMainDiv, rMainDivScaleProportional) {
	var rCurrentWidth = rMainDiv.outerWidth();
	var rCurrentHeight = rMainDiv.outerHeight();
	
	var rAvailableHeight = window.innerHeight;
	var rAvailableWidth = window.innerWidth;

	rMainDivScaleX = rAvailableWidth / rCurrentWidth;
	rMainDivScaleY = rAvailableHeight / rCurrentHeight;

	if (rMainDivScaleProportional) {
		rMainDivScaleX = Math.min(rMainDivScaleX, rMainDivScaleY);
		rMainDivScaleY = rMainDivScaleX;
	}

	var translationX = Math.round((rAvailableWidth - (rCurrentWidth * rMainDivScaleX)) / 2);
	var translationY = Math.round((rAvailableHeight - (rCurrentHeight * rMainDivScaleY)) / 2);
	
	rMainDiv.css({
		"position": "fixed",
		"left": translationX + "px",
		"top": 0 + "px",
		// "top": translationY + "px",
		"-webkit-transform": "scale(" + rMainDivScaleX + ", " + rMainDivScaleY + ")",
		"-webkit-transform-origin": "0 0",
		"-moz-transform": "scale(" + rMainDivScaleX + ", " + rMainDivScaleY + ")",
		"-moz-transform-origin": "0 0",
		"-khtml-transform": "scale(" + rMainDivScaleX + ", " + rMainDivScaleY + ")",
		"-khtml-transform-origin": "0 0",
		"-ms-transform": "scale(" + rMainDivScaleX + ", " + rMainDivScaleY + ")",
		"-ms-transform-origin": "0 0",
		"-o-transform": "scale(" + rMainDivScaleX + ", " + rMainDivScaleY + ")",
		"-o-transform-origin": "0 0",
		"transform": "scale(" + rMainDivScaleX + ", " + rMainDivScaleY + ")",
		"transform-origin": "0 0"
	});

	rObjClientRect = document.getElementById(rMainDiv.attr('id'));
	rClientRect = rObjClientRect.getBoundingClientRect();	
}

$( document ).ready(function() {
	rMainDiv = $("#divMainContainer");
	rObjClientRect = document.getElementById(rMainDiv.attr('id'));
	rClientRect = rObjClientRect.getBoundingClientRect();
	
	if (rFullScreen) {
		doFullScreen(rMainDiv, rMainDivScaleProportional);
		if ("onorientationchange" in window) {
			window.addEventListener("orientationchange", function() { setTimeout(function() { doFullScreen(rMainDiv, rMainDivScaleProportional); }, 500) });
		} else if ("ondeviceorientation" in window) {
			window.addEventListener("deviceorientation", function() { setTimeout(function() { doFullScreen(rMainDiv, rMainDivScaleProportional); }, 500) });
		}
		if (!isMobile.any()) {
			window.addEventListener('resize', function() {
				doFullScreen(rMainDiv, rMainDivScaleProportional);
			}, true);
		}
	} else {
		if(rScaling){
			doSetScale(rMainDiv.attr('id'), rMainDivScaleX, rMainDivScaleY);
			rMainDiv.css('left', '50%');
			rMainDiv.css('margin-left', ((rClientRect.width/2)*-1) + (rClientRect.left*-1) + "px");
			rMainDiv.css('top', '50%');
			rMainDiv.css('margin-top', ((rClientRect.height/2)*-1) + (rClientRect.top*-1) + "px");
		} else {
			rMainDiv.css('left', '50%');
			rMainDiv.css('margin-left', ((rClientRect.width/2)*-1) + (rClientRect.left*-1) + "px");
			rMainDiv.css('top', '50%');
			rMainDiv.css('margin-top', ((rClientRect.height/2)*-1) + (rClientRect.top*-1) + "px");
		}

		rObjClientRect = document.getElementById(rMainDiv.attr('id'));
		rClientRect = rObjClientRect.getBoundingClientRect();		
	}
//	rIMGPreLoader.start();
});