/*
 * Contributed by Rahul Jhaveri on 26/04/17.
 * JhavTech Studios Pty Ltd (2017)
 * http://www.jhavtech.com.au
 */

Math.pad = function(n, d) {
	var s = n.toString();
	if (s.length>=d) {
		return s;
	} else {
		return Math.pad("0"+n, d);
	}
};

Math.randomInterval = function(a, b, integer) {
	integer = (integer == undefined ? true : integer);
	if (integer) {
		return Math.round((a-0.5)+Math.random()*(b-a+0.9));
	} else {
		return a+Math.random()*(b-a);
	}
};

Array.scalarProduct= function(scalar,vector) {
	var result = vector.concat();
	for (var i = 0; i<vector.length; i++) {
		result[i] *= scalar;
	}
	return result;
};

Array.vectorSum = function(array) {
	var result = array[0].concat();
	for (var i = 1; i<array.length; i++) {
		for (var j = 0; j<array[0].length; j++) {
			result[j] += array[i][j];
		}
	}
	return result;
};

Array.match = function(array1, array2, accuracy) {
	accuracy = (accuracy == undefined ? 5 : accuracy);
	var match = false;
	if (typeof array1 == "number" && typeof array2 == "number") {
		match = Math.round(array1, accuracy) == Math.round(array2, accuracy);
	} else if (typeof array1 == "string" && typeof array2 == "string") {
		match = array1 == array2;
	} else {
		if (typeof array1 == typeof array2) {
			if (array1.length == array2.length) {
				if (array1.length == 0) {
					match = true;
				} else {
					match = Array.match(array1[0], array2[0], accuracy) && Array.match(array1.slice(1), array2.slice(1), accuracy);
				}
			}
		}
	}
	return match;
};

main.compareEstimate = function(estimate, actual, correct) {
	var level;
	switch (true) {
		case (estimate<actual) :
			level = 0;
			break;
		case (estimate>actual) :
			level = 1;
			break;
		default :
			level = 2;
			break;
	}
	main.setFeedback("find area", "compare estimate : "+correct, level, [estimate, actual]);
};

function doResetAnimationObject() {
	main.divInputEstimate.removeAttribute("readonly");
	main.divAreaInput_1.removeAttribute("readonly");
	main.divAreaInput_2.removeAttribute("readonly");
	main.divAreaInput_3.removeAttribute("readonly");
	main.divAreaInput_4.removeAttribute("readonly");
	main.divAreaInput_5.removeAttribute("readonly");
	main.divAreaInput_6.removeAttribute("readonly");
	main.divAreaInput_7.removeAttribute("readonly");
	
	$("#divInputBG_2").show();
	$("#divSquarePanel").css("opacity", 1);
	$("#divSquarePanel").show();	
	$("#divEstimatePanel").show();	
	$("#divFindAreaBtn").css("cursor", "pointer");	
	$("#divFindAreaBtn").show();	
	
	$("#divMyAreaEstimateLeftPanel").hide();	
	$("#divMyAreaText_1").css("left", "250px");	
	$("#divMyAreaText_1").css("top", "163px");	
	$("#divMyAreaText_1").css("font-size", "18px");	
	$("#divMyAreaText_2").css("left", "324px");	
	$("#divMyAreaText_2").css("top", "163px");	
	$("#divMyAreaText_2").css("font-size", "18px");
	$("#divMyAreaText_3").css("left", "427px");	
	$("#divMyAreaText_3").css("top", "159px");	
	$("#divMyAreaText_3").css("font-size", "24px");
	$("#divMyAreaText_4").css("left", "472px");	
	$("#divMyAreaText_4").css("top", "162px");	
	$("#divMyAreaText_4").css("font-size", "18px");
	
	$("#divText_AresA").show();
	$("#divText_X_1").show();
	$("#divInputBG_3").show();
	$("#divInputBG_4").show();
	$("#divText_AresB").show();
	$("#divCheckBtn").show();
	$("#divLine").show();
	
	$("#divAreaCheckPanel_A").hide();
	$("#divSquaresText_1").hide();
	$("#divSquaresText_1").css("left", "522px");
	$("#divSquaresText_1").css("top", "109px");
/*	
	if(isMobile.any()){
		$("#divAreaInput_1").css('left', '352px');
		$("#divAreaInput_1").css('top', '99px');
	}else{
		$("#divAreaInput_1").css('left', '364px');
		$("#divAreaInput_1").css('top', '105px');
	}	
*/	
	$("#divAreaInput_1").show();
/*	
	if(isMobile.any()){
		$("#divAreaInput_2").css('left', '352px');
		$("#divAreaInput_2").css('top', '99px');
	}else{
		$("#divAreaInput_2").css('left', '364px');
		$("#divAreaInput_2").css('top', '105px');
	}	
*/	
	$("#divAreaInput_2").show();
	$("#divAreaInput_3").hide();
	$("#divAreaInput_3").css("width", "38px");
	$("#divAreaInput_3").css("left", "474px");
	$("#divCheckBtn").css("left", "473px");
	$("#divCheckBtn").css("top", "100px");
	$("#divInputBG_5").hide();
	main.divInputEstimate.value = "";
	main.divAreaInput_1.value = "";
	main.divAreaInput_2.value = "";
	main.divAreaInput_3.value = "";
	main.divAreaInput_4.value = "";
	main.divAreaInput_5.value = "";
	main.divAreaInput_6.value = "";
	main.divAreaInput_7.value = "";
	$("#divEqual_1").css("left", "454px");
	$("#divEqual_1").css("top", "109px");
	$("#divEqual_1").hide();
	
	$("#divAreaCheckPanel_B").hide();
	$("#divAreaInput_6").css("width", "38px");
	$("#divAreaInput_6").css("left", "475px");
	$("#divAreaInput_6").css("top", "145px");
	$("#divSquaresText_2").hide();
	$("#divSquaresText_2").css("left", "522px");
	$("#divSquaresText_2").css("top", "149px");
	$("#divInputBG_8").hide();
	$("#divEqual_2").hide();
	
	$("#divTotalArea_1").hide();
	$("#divTotalAreaText").css("left", "306px");
	$("#divTotalAreaText").css("top", "189px");
	$("#divSquaresText_3").css("left", "408px");
	$("#divSquaresText_3").css("top", "189px");
	$("#divInputBG_9").css("left", "359px");
	$("#divInputBG_9").css("top", "185px");
	$("#divText_X_2").show();
	$("#divAreaInput_4").show();
	$("#divAreaInput_5").show();
	$("#divAreaInput_6").show();
	$("#divInputBG_9").css("opacity", 1);
	$("#divAreaInput_7").show();
	$("#divAreaInput_7").css("left", "364px");
	$("#divAreaInput_7").css("top", "186px");
	$("#divLine").css("left", "364px");
	$("#divLine").css("top", "183px");
	$("#divSymbol_Plus").hide();
	$("#divSymbol_Plus").css("left", "474px");
	$("#divSymbol_Plus").css("top", "125px");
}

function doReset() {
	main.divSection_2 = document.getElementById("divSection_2");
	main.reset_btn = document.getElementById("divResetBtn");
	main.clown_mc = document.getElementById("divClown");
	
	main.region0_mc = new Region();
	main.region0_mc.objMain = document.getElementById("region0_mc");
	main.region0_mc.cover = [];
	main.region0_mc.shapeType = 0;
	
	main.counterRows0_mc = document.getElementById("counterRows0_mc");
	main.counterRows0_mc.style.opacity = 0;
	main.counterRows1_mc = document.getElementById("counterRows1_mc");
	main.counterRows1_mc.style.opacity = 0;
	
	main.counterColumns0_mc = document.getElementById("counterColumns0_mc");
	main.counterColumns0_mc.style.opacity = 0;
	main.counterColumns1_mc = document.getElementById("counterColumns1_mc");
	main.counterColumns1_mc.style.opacity = 0;
	
	main.counterRows0_mc_fly = document.getElementById("counterRows0_mc_fly");
	main.counterRows1_mc_fly = document.getElementById("counterRows1_mc_fly");
	main.counterColumns0_mc_fly = document.getElementById("counterColumns0_mc_fly");
	main.counterColumns1_mc_fly = document.getElementById("counterColumns1_mc_fly");
	
	main.formula_mc = {};
	
	main.divInputEstimate = document.getElementById("divInputEstimate");
	main.divAreaInput_1 = document.getElementById("divAreaInput_1");
	main.divAreaInput_2 = document.getElementById("divAreaInput_2");
	main.divAreaInput_3 = document.getElementById("divAreaInput_3");
	main.divAreaInput_4 = document.getElementById("divAreaInput_4");
	main.divAreaInput_5 = document.getElementById("divAreaInput_5");
	main.divAreaInput_6 = document.getElementById("divAreaInput_6");	
	main.divAreaInput_7 = document.getElementById("divAreaInput_7");
	
	main.divCheckBtn = document.getElementById("divCheckBtn");
	
	main.feedback_mc = document.getElementById("feedback_mc");
	
	main.legend_mc = document.getElementById("divSquarePanel");
	
	main.tilingMove0_mc = new Tiling();
	main.tilingMove0_mc.objMain = document.getElementById("tilingMove0_mc");
	main.tilingMove0_mc.tile_mc = main.tilingMove0_mc.objMain.getElementsByTagName("div")[0];
	
	main.tilingMove1_mc = new Tiling();
	main.tilingMove1_mc.objMain = document.getElementById("tilingMove1_mc");
	main.tilingMove1_mc.tile_mc = main.tilingMove1_mc.objMain.getElementsByTagName("div")[0];
	
	main.divFindAreaBtn = document.getElementById("divFindAreaBtn");
	main.hand0_mc = document.getElementById("hand0_mc");
	main.hand1_mc = document.getElementById("hand1_mc");
	
	main.counterRows0_mc.style.zIndex = 3000;
	main.counterRows1_mc.style.zIndex = 3000;
	main.counterColumns0_mc.style.zIndex = 3000;
	main.counterColumns1_mc.style.zIndex = 3000;

	main.counterRows0_mc_fly.style.zIndex = 3000;
	main.counterRows1_mc_fly.style.zIndex = 3000;
	main.counterColumns0_mc_fly.style.zIndex = 3000;
	main.counterColumns1_mc_fly.style.zIndex = 3000;	
	
	main.hand0_mc.style.zIndex = 4000;
	main.hand1_mc.style.zIndex = 4000;
	
	rEstimateFA = "ESTIMATE";
}

main.reset = function() {
	rPulseObjId = "";
	rPulseCountTwo = 0;
	rPulseCountTwo = 0;

	rCounter0Mc = null;
	rCounter1Mc = null;
	rCounter0McId = "";
	rCounter1McId = "";	
	
	rRegionDepthCount = 1000;
	rTileDepthCount = 2000;
	rEstimateFA = "ESTIMATE";
	
	rMouseDownOneFired = false;
	rMouseDownTwoFired = false;
	rMouseDownThreeFired = false;
	doResetAnimationObject();
	
	for (name in main.region0_mc) {
		if (name.substr(0, 6) == "tiling") {
			var rChild = document.getElementById(name);
			if (rChild!=null && rChild!=undefined && rChild!="") {
				rChild.parentNode.removeChild(rChild);
				delete main.region0_mc[name];
			}
		}
	}	
	
	for (var i = 0; i<main.region0_mc.cover.length; i++) {
		for (var j = 0; j<main.region0_mc.cover[0].length; j++) {
			main.region0_mc.cover[i][j] = (main.region0_mc.cover[i][j] == -1 ? -1 : 0);
		}
	}
	/*
	if(isMobile.any()){
		$("#divInputEstimate").css('left', '413px');
		$("#divInputEstimate").css('top', '152px');
	}else{
		$("#divInputEstimate").css('left', '425px');
		$("#divInputEstimate").css('top', '158px');
	}
	*/
	/*
	var rHTML = "";
	rHTML += '<canvas id="region0_mc_canvas" name="region0_mc_canvas" width="350" height="275" style="position:absolute; left:0px; top:0px; border:0px solid #00ff00;">';
	rHTML += '</canvas>';
	rHTML += '<div id="region0_mc_marker_mc" name="region0_mc_marker_mc" style="position:absolute; left:0px; top:0px; width:100%; height:100%; border:1px solid #000000; display:none;">';
	rHTML += '</div>';
	main.region0_mc.objMain.innerHTML = rHTML;
	*/
	main.region0_mc.canvas = main.region0_mc.objMain.getElementsByTagName("canvas")[0];
	main.region0_mc.context = main.region0_mc.canvas.getContext("2d");
	main.region0_mc.marker_mc = main.region0_mc.objMain.getElementsByTagName("div")[0];	
	
	main.tilingMove0_mc.objMain.style.display = "none";
	main.tilingMove1_mc.objMain.style.display = "none";
	
	var rChildElement = document.getElementById("tilingMoveLarge0_mc");
	if (rChildElement!=null && rChildElement!=undefined && rChildElement!="") {
		rChildElement.parentNode.removeChild(rChildElement);
	}
	
	rChildElement = document.getElementById("tilingMoveLarge1_mc");
	if (rChildElement!=null && rChildElement!=undefined && rChildElement!="") {
		rChildElement.parentNode.removeChild(rChildElement);
	}	
	
	for (var i = 0; i<main.region0_mc.cover.length; i++) {
		for (var j = 0; j<main.region0_mc.cover[0].length; j++) {
			main.region0_mc.cover[i][j] = (main.region0_mc.cover[i][j] == -1 ? -1 : 0);
		}
	}

	if (document.getElementById("columnGuideRegion_mc")!=null && document.getElementById("columnGuideRegion_mc")!=undefined && document.getElementById("columnGuideRegion_mc")!="") {
		document.getElementById("columnGuideRegion_mc").parentNode.removeChild(document.getElementById("columnGuideRegion_mc"));
	}
	if (document.getElementById("rowGuideRegion_mc")!=null && document.getElementById("rowGuideRegion_mc")!=undefined && document.getElementById("rowGuideRegion_mc")!="") {
		document.getElementById("rowGuideRegion_mc").parentNode.removeChild(document.getElementById("rowGuideRegion_mc"));
	}
	if (document.getElementById("dragChoiceRegion0_mc")!=null && document.getElementById("dragChoiceRegion0_mc")!=undefined && document.getElementById("dragChoiceRegion0_mc")!="") {
		document.getElementById("dragChoiceRegion0_mc").parentNode.removeChild(document.getElementById("dragChoiceRegion0_mc"));
	}
	if (document.getElementById("dragChoiceRegion1_mc")!=null && document.getElementById("dragChoiceRegion1_mc")!=undefined && document.getElementById("dragChoiceRegion1_mc")!="") {
		document.getElementById("dragChoiceRegion1_mc").parentNode.removeChild(document.getElementById("dragChoiceRegion1_mc"));
	}	
	
	main.hand0_mc.style.opacity = 0;
	main.hand0_mc.style.display = "none";
	main.hand1_mc.style.opacity = 0;
	main.hand1_mc.style.display = "none";
	
	//main.nextStep_mc.style.opacity = 0;
	//main.nextStep_mc.style.display = "none";
	//main.showMeAgain_mc.style.opacity = 0;
	//main.showMeAgain_mc.style.display = "none";
	//main.counterRows0_mc.style.opacity = 0;
	//main.counterColumns0_mc.style.opacity = 0;
	//main.counterRows1_mc.style.opacity = 0;
	//main.counterRows1_mc.style.opacity = 0;
	//main.findArea_mc.style.opacity = 0;
	//main.findArea_mc.style.display = "none";
	
	main.counterRows0_mc.innerHTML = "1";
	main.counterColumns0_mc.innerHTML = "1";
	main.counterRows1_mc.innerHTML = "1";
	main.counterColumns1_mc.innerHTML = "1";
	
	main.counterRows0_mc.style.opacity = 0;
	main.counterColumns0_mc.style.opacity = 0;
	main.counterRows1_mc.style.opacity = 0;
	main.counterColumns1_mc.style.opacity = 0;
	if (main.region0_mc.shapeType!=0) {
		main.counterRows0_mc.style.top = (Number(main.region0_mc.objMain.style.top.split("px")[0])+(0.5*main.region0_mc.shapeSizeBound[0])*main.region0_mc.cellSize[0]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterRows0_mc[1] + "px";
	}
	
	//main.continueTiling1_mc.objMain.style.display = "none";
	//main.continueTiling2_mc.objMain.style.display = "none";
	
	//this.formula_mc.gotoAndStop(1);
	//this.formula_mc._alpha = this.formula_mc._visible=0;
	//main.estimate_mc.gotoAndStop(1);
	
	main.region0_mc.setCellColour(main.cellColour, true);

	document.getElementById("divOutline0_mc").style.display = "none";
	document.getElementById("divOutline1_mc").style.display = "none";

	//main.reward_mc.gotoAndPlay(1);
	
	main.region0_mc.setBorderColourInternal(main.borderColourLight, true);
	
	$("#flyValueTxt").hide();
	$("#divTimesTablePanel").hide();
	
	clearInterval(rLittleMonkeyAniTimer);
	rLittleMonkeyAniTimer = 0;
	$("#divLittleMonkey").hide();
	clearInterval(rMonkeyRewardAniTimer);
	rMonkeyRewardAniTimer = 0;
	$("#divMonkeyReward").hide();
	$("#imgMonkeyRewardAni").attr("src", "assets/images/monkey_reward/ani_1.png");
	clearInterval(rConfettiFallingTimer);
	rConfettiFallingTimer = 0;
	$("#divConfettiFalling").hide();
	$("#imgConfettiFallin").attr("src", "assets/images/confetti_falling/ani_1.png");
	
	$("#divMonkeyBody1").show();
	$("#divMonkeyHead1").show();
	
	for (var i=0; i<rArrTFLoc.length; i++) {
		if (isMobile.iOS()) {
			$("#" + rArrTFLoc[i].ID).css('left', rArrTFLoc[i].X - 13 + "px");
			$("#" + rArrTFLoc[i].ID).css('top', rArrTFLoc[i].Y - 7 + "px");
		} else {
			$("#" + rArrTFLoc[i].ID).css('left', rArrTFLoc[i].X + 1 + "px");
			$("#" + rArrTFLoc[i].ID).css('top', rArrTFLoc[i].Y + "px");
		}
	}
	
	doLoadTabIndexItems();
};


main.setFeedback = function(section, tag, level, replacements) {
	replacements = (replacements == undefined ? [] : replacements);
	if (section != main.feedback_mc.getAttribute("sectionOld") || tag != main.feedback_mc.getAttribute("tagOld") || level != main.feedback_mc.getAttribute("levelOld")) {
		main.feedback_mc.setAttribute("sectionOld", section);
		main.feedback_mc.setAttribute("tagOld", tag);
		main.feedback_mc.setAttribute("levelOld", level);
		var textNew = main.extractFeedbackPhrase(section, tag, level, true);
		main.feedback_mc.innerHTML = textNew;
		for (var i = 0; i<replacements.length; i++) {
			main.feedback_mc.innerHTML = main.feedback_mc.innerHTML.replace("#"+i, replacements[i]);
		}

		var rFrame = rCloneCurrentFrame % 3 + 1;
		clearInterval(rClownAniTimer);
		rClownAniTimer = 0;			
		rClownAniFrameCount = 1;
		if (rFrame==1) {
			rClownAniTotalFrameCount = 61;
			rClownAniImagePath = rImageBasePath + "clown_1/ani_";
		} else {
		if (rFrame==2) {
			rClownAniTotalFrameCount = 90;
			rClownAniImagePath = rImageBasePath + "clown_intro/ani_";
		} else {
		if (rFrame==3) {
			rClownAniTotalFrameCount = 30;
			rClownAniImagePath = rImageBasePath + "clown_2/ani_";
		} } }
		rClownAniLoop = true;
		rClownAniLoopFrameId = 1;
		rClownAniTimer = setInterval("doClownAni()", 1000/12);		
		rCloneCurrentFrame = rFrame;
	}
};

main.extractFeedbackPhrase = function(section, tag, level, html) {
	html = (html == undefined ? false : true);
	var feedback = "";
	for (var i = 0; i<rData.feedbackdata.length; i++) {
		for (var j = 0; j<rData.feedbackdata[i].feedphrase.length; j++) {
			if (rData.feedbackdata[i].feedphrase[j].tag==tag && rData.feedbackdata[i].feedphrase[j].level==level) {
				feedback = rData.feedbackdata[i].feedphrase[j].text;
				break;
			}
		}
	}
	if (feedback == "") {
		feedback = "unknown feedback : tag "+tag+", level "+level;
	}
	return feedback;
};

main.createRandomCovering = function() {
	var shapeType = main.region0_mc.shapeType;
	var shapeHeight, shapeWidth;
	var holeHeight, holeWidth;
	var coverOld;
	if (main.region0_mc.cover!=undefined && main.region0_mc.cover.length>0) {
		coverOld = main.region0_mc.cover.slice();
	}
	do {
		if (shapeType == 0) {
			shapeHeight = Math.randomInterval(2, main.maxShapeHeight);
			shapeWidth = Math.randomInterval(2, main.maxShapeWidth);
			holeHeight = 0;
			holeWidth = 0;
		} else {
			shapeHeight = Math.randomInterval(4, main.maxShapeHeight);
			shapeWidth = Math.randomInterval(4, main.maxShapeWidth);
			holeHeight = Math.randomInterval(2, shapeHeight-2);
			holeWidth = Math.randomInterval(2, shapeWidth-2);
		}
		//
		var cover = [];
		for (var i = 0; i<shapeHeight; i++) {
			cover.push([]);
			for (var j = 0; j<shapeWidth; j++) {
				cover[i].push(0);
			}
		}
		if (shapeType != 0) {
			for (var i = 0; i<holeHeight; i++) {
				for (var j = 0; j<holeWidth; j++) {
					cover[(shapeType == 1 || shapeType == 2 ? i : shapeHeight-1-i)][(shapeType == 1 || shapeType == 4 ? j : shapeWidth-1-j)] = -1;
				}
			}
		}
	} while (Array.match(coverOld, cover));
	main.region0_mc.cover = cover;
	main.region0_mc.shapeSizeBound = [shapeHeight, shapeWidth];
	main.region0_mc.shapeSizeHole = [holeHeight, holeWidth];
	main.region0_mc.objMain.style.left = (main.region0_mc.xStart+0.5*(main.maxShapeWidth-shapeWidth)*main.region0_mc.cellSize[1]) + "px";
	main.region0_mc.objMain.style.top = (main.region0_mc.yStart+0.5*(main.maxShapeHeight-shapeHeight)*main.region0_mc.cellSize[0]) + "px";
	return cover;
};

main.stage00_initialise = function(step) {
	main.reset();
	switch (step) {
		case 0 :
			main.stage = 0;
			main.stage00_initialise(1);
				break;
		case 1 :
			clearInterval(rClownAniTimer);
			rClownAniTimer = 0;			
			rClownAniFrameCount = 1;
			rClownAniTotalFrameCount = 61;
			rClownAniImagePath = rImageBasePath + "clown_1/ani_";
			rClownAniLoop = true;
			rClownAniLoopFrameId = 1;
			rClownAniTimer = setInterval("doClownAni()", 1000/12);
			
			main.region0_mc.shapeSizeHole = [2, 2];
			main.region0_mc.shapeSizeBound = [];
			main.region0_mc.cellSize = [35, 35];
			main.region0_mc.cellColour = main.cellColour;
			main.region0_mc.cellAlpha = 100;
			main.region0_mc.borderColourExternal = "#000000";
			main.region0_mc.borderColourInternal = main.borderColourLight;
			main.region0_mc.borderAlphaExternal = main.borderAlphaExternal;
			main.region0_mc.borderAlphaInternal = main.borderAlphaInternal;

			main.region0_mc.xStart = Number(main.region0_mc.objMain.style.left.split("px")[0]);
			main.region0_mc.yStart = Number(main.region0_mc.objMain.style.top.split("px")[0]);
			
			main.tilingMove0_mc.dimensions = main.tilingMove1_mc.dimensions=[1, 1];
			main.tilingMove0_mc.draggable = main.tilingMove1_mc.draggable=true;
			main.tilingMove0_mc.snapTo = main.tilingMove1_mc.snapTo=true;
			main.tilingMove0_mc.tile_mc.getElementsByTagName("img")[0].src = rImageBasePath + "tiling_1.png";
			main.tilingMove0_mc.tileType = 0;
			main.tilingMove1_mc.tileType = 1;

			//main.continueTiling1_mc._alpha = 0;
			//main.continueTiling2_mc._alpha = 0;
			//main.continueTiling1_mc._visible = false;
			//main.continueTiling2_mc._visible = false;

			main.hand0_mc.style.opacity = 0;
			main.hand1_mc.style.opacity = 0;

			main.counterRows1_mc.style.opacity = 0;
			main.counterColumns1_mc.style.opacity = 0;

			//main.formula_mc.style.opacity = 0;
			//main.timesTable_mc.style.opacity = 0;
			//main.cover_mc.fade(0, main.fadeSpeed);
			//main.findArea_mc._alpha = main.findArea_mc._visible=0;
			//main.replay_mc._alpha = main.replay_mc._visible=0;
			//main.next_mc._alpha = main.next_mc._visible=0;
			
			//main.reset_btn.onPress = function() {
				//main.reset();
				//main.stage01_estimateArea(0);
			//};
			doCreateShape();
			break;
	}
};

function doCreateShape() {
	main.reset();
	//main.region0_mc.shapeType = -1;
	if (main.region0_mc.shapeType == -1) {
		main.region0_mc.shapeType = 1;
		main.region0_mc.cover = [[-1, -1, 0, 0], [-1, -1, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0]];
		main.region0_mc.shapeSizeHole = [2, 2];
		var shapeWidth = 4;
		var shapeHeight = 4;
		main.region0_mc.objMain.style.left = (main.region0_mc.xStart+(0.5*(main.maxShapeWidth-shapeWidth)*main.region0_mc.cellSize[1])) + "px";
		main.region0_mc.objMain.style.top = (main.region0_mc.yStart+(0.5*(main.maxShapeHeight-shapeHeight)*main.region0_mc.cellSize[0])) + "px";
	} else {
		main.region0_mc.shapeType = Math.randomInterval(1, 4);
		main.createRandomCovering();
	}
	main.region0_mc.shapeSizeBound = [main.region0_mc.cover.length, main.region0_mc.cover[0].length];
	main.region0_mc.init();
	switch (main.region0_mc.shapeType) {
		case 1 :
			main.counterRows0_mc.style.left = (Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeBound[1]*main.region0_mc.cellSize[1]+main.counterOffset[0]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterRows0_mc[0] + "px";
			main.counterRows0_mc.style.top = (Number(main.region0_mc.objMain.style.top.split("px")[0])+(0.5*main.region0_mc.shapeSizeBound[0])*main.region0_mc.cellSize[0]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterRows0_mc[1] + "px";
			main.counterColumns0_mc.style.left = (Number(main.region0_mc.objMain.style.left.split("px")[0])+(main.region0_mc.shapeSizeHole[1]+0.5*(main.region0_mc.shapeSizeBound[1]-main.region0_mc.shapeSizeHole[1]))*main.region0_mc.cellSize[1]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterColumns0_mc[0] + "px";
			main.counterColumns0_mc.style.top = (Number(main.region0_mc.objMain.style.top.split("px")[0])-main.counterOffset[1]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterColumns0_mc[1] + "px";
			break;
		case 2 :
			main.counterRows0_mc.style.left = (Number(main.region0_mc.objMain.style.left.split("px")[0])-main.counterOffset[0]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterRows0_mc[0] + "px";
			main.counterRows0_mc.style.top = (Number(main.region0_mc.objMain.style.top.split("px")[0])+(0.5*main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0])) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterRows0_mc[1] + "px";
			main.counterColumns0_mc.style.left = (Number(main.region0_mc.objMain.style.left.split("px")[0])+0.5*(main.region0_mc.shapeSizeBound[1]-main.region0_mc.shapeSizeHole[1])*main.region0_mc.cellSize[1]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterColumns0_mc[0] + "px";
			main.counterColumns0_mc.style.top = (Number(main.region0_mc.objMain.style.top.split("px")[0])-main.counterOffset[1]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterColumns0_mc[1] + "px";
			break;
		case 3 :
			main.counterRows0_mc.style.left = (Number(main.region0_mc.objMain.style.left.split("px")[0])-main.counterOffset[0]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterRows0_mc[0] + "px";
			main.counterRows0_mc.style.top = (Number(main.region0_mc.objMain.style.top.split("px")[0])+0.5*main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterRows0_mc[1] + "px";
			main.counterColumns0_mc.style.left = (Number(main.region0_mc.objMain.style.left.split("px")[0])+0.5*(main.region0_mc.shapeSizeBound[1]-main.region0_mc.shapeSizeHole[1])*main.region0_mc.cellSize[1]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterColumns0_mc[0] + "px";
			main.counterColumns0_mc.style.top = (Number(main.region0_mc.objMain.style.top.split("px")[0])+main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0]+main.counterOffset[1]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterColumns0_mc[1] + "px";
			break;
		case 4 :
			main.counterRows0_mc.style.left = (Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeBound[1]*main.region0_mc.cellSize[1]+main.counterOffset[0]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterRows0_mc[0] + "px";
			main.counterRows0_mc.style.top = (Number(main.region0_mc.objMain.style.top.split("px")[0])+0.5*main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterRows0_mc[1] + "px";
			main.counterColumns0_mc.style.left = (Number(main.region0_mc.objMain.style.left.split("px")[0])+(main.region0_mc.shapeSizeHole[1]+0.5*(main.region0_mc.shapeSizeBound[1]-main.region0_mc.shapeSizeHole[1]))*main.region0_mc.cellSize[1]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterColumns0_mc[0] + "px";
			main.counterColumns0_mc.style.top = (Number(main.region0_mc.objMain.style.top.split("px")[0])+main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0]+main.counterOffset[1]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterColumns0_mc[1] + "px";
			break;
	}
	main.stage01_estimateArea(0);
}

main.stage01_estimateArea = function(step) {
	switch (step) {
		case 0 :
			main.stage = 1;
			main.setFeedback("estimate area", "instruction", 0);
			$("#" + main.legend_mc.id).stop().animate(
				{
					opacity:1
				}, main.fadeSpeed,
				function() {
					
				}
			);
			break;
	}
};

function doFindAreaBtnClickForFirst() {
	if (main.divInputEstimate.value == "") {
		doPlayAudio("uhoh");
	} else {
		rEstimateFA = "FA";
		doMyAreaEstimate_1();
		main.stage02_coverRegion(0);
	}
}

main.stage02_coverRegion = function(step) {
	switch (step) {
		case 0 :
			main.stage = 2;
			main.stage02_coverRegion(1);
			break;
		case 1 :
			main.region0_mc.setBorderColourInternal(main.cellColour, true);
			$("#" + main.legend_mc.id).stop().animate(
				{
					opacity:0
				}, main.fadeSpeed,
				function() {
					
				}
			);
			$("#" + main.counterRows0_mc.id).stop().animate(
				{
					opacity:1
				}, main.fadeSpeed,
				function() {
				}
			);
			$("#" + main.counterColumns0_mc.id).stop().animate(
				{
					opacity:1
				}, main.fadeSpeed,
				function() {
				}
			);
			
			rPulseObjId = main.tilingMove0_mc.objMain.getElementsByTagName("div")[1].id;
			rPulseCount = 0;
			doPulseAni();
			//this.tilingMove0_mc.pulseGlow(main.pulseRepetitions, main.pulseDuration, main.pulseAlphaMin, true);
			main.createRowOrColumn(0, 2);
			main.tilingMove0_mc.objMain.style.display = "block";
			main.tilingMove1_mc.objMain.style.display = "none";
			break;
		case 2 :
			main.dragRowOrColumn(0, 3);
			break;
		case 3 :
			//main.reward_mc.gotoAndPlay("reward");
			doMonkeyRewardImgSet();
			if (document.getElementById("tilingMoveLarge0_mc")!=null && document.getElementById("tilingMoveLarge0_mc")!=undefined && document.getElementById("tilingMoveLarge0_mc")!="") {
				document.getElementById("tilingMoveLarge0_mc").parentNode.removeChild(document.getElementById("tilingMoveLarge0_mc"));
			}
			if (main.region0_mc.shapeType == 0) {
				main.stage02_coverRegion(5);
			} else {
				$("#" + main.counterRows0_mc.id).stop().animate(
					{
						opacity:0.5
					}, main.fadeSpeed,
					function() {
					}
				);
				
				$("#" + main.counterColumns0_mc.id).stop().animate(
					{
						opacity:0.5
					}, main.fadeSpeed,
					function() {
					}
				);

				$("#" + main.counterRows1_mc.id).stop().animate(
					{
						opacity:1
					}, main.fadeSpeed,
					function() {
						
					}
				);
				
				$("#" + main.counterColumns1_mc.id).stop().animate(
					{
						opacity:1
					}, main.fadeSpeed,
					function() {
						
					}
				);				
				//this.tilingMove1_mc.pulseGlow(main.pulseRepetitions, main.pulseDuration, main.pulseAlphaMin, true);
				
				rPulseObjId = main.tilingMove1_mc.objMain.getElementsByTagName("div")[1].id;
				rPulseCount = 0;
				doPulseAni();
			
				main.createRowOrColumn(1, 4);
				main.tilingMove0_mc.objMain.style.display = "none";
				main.tilingMove1_mc.objMain.style.display = "block";
			}
			break;
		case 4 :
			main.dragRowOrColumn(1, 5);
			break;
		case 5 :
			//main.reward_mc.gotoAndPlay("reward");
			doMonkeyRewardImgSet();
			if (document.getElementById("tilingMoveLarge1_mc")!=null && document.getElementById("tilingMoveLarge1_mc")!=undefined && document.getElementById("tilingMoveLarge1_mc")!="") {
				document.getElementById("tilingMoveLarge1_mc").parentNode.removeChild(document.getElementById("tilingMoveLarge1_mc"));
			}
			main.stage03_findArea(0);
			break;
	}
	
	doLoadTabIndexItems();
};

function doCreateTile(name, left, top, parent, object, glow, tile, dim) {
	rDivElementParent = document.createElement("div");
	rDivElementParent.id = name;
	rDivElementParent.name = name;
	rDivElementParent.style.position = "absolute";
	rDivElementParent.style.width = (dim[1]*35) + "px";
	rDivElementParent.style.height = (dim[0]*35) + "px";
	rDivElementParent.style.left = left + "px";
	rDivElementParent.style.top = top + "px";
	if (glow) {
		rDivElementParent.style.cursor = "pointer";
		rDivElementParent.style.zIndex = rTileDepthCount++;
	} else {
		rDivElementParent.style.cursor = "default";
	}
	rDivElementParent.style.border = "0px solid blue";

	rDivElementChild = document.createElement("div");
	rDivElementChild.id = name + "_tile_mc";
	rDivElementChild.name = name + "_tile_mc";
	rDivElementChild.style.position = "absoute";
	rDivElementChild.style.width = "35px";
	rDivElementChild.style.height = "35px";
	rDivElementChild.style.left = "0px";
	rDivElementChild.style.top = "0px";
	
	rImgElement = document.createElement("img");
	rImgElement.style.position = "absoute";
	rImgElement.style.left = "0px";
	rImgElement.style.top = "0px";
	rImgElement.src = rImageBasePath + "tiling_" + String(tile+1) + ".png";
	rDivElementChild.appendChild(rImgElement);
	rDivElementParent.appendChild(rDivElementChild);
	object.tile_mc = rDivElementChild;
		
	rDivElementChild = document.createElement("div");
	rDivElementChild.id = name + "_glow_mc";
	rDivElementChild.name = name + "_glow_mc";
	rDivElementChild.style.position = "absolute";
	rDivElementChild.style.width = (dim[1]*35) + "px";
	rDivElementChild.style.height = (dim[0]*35) + "px";
	rDivElementChild.style.left = "0px";
	rDivElementChild.style.top = "0px";
	rDivElementParent.style.border = "0px solid green";
	if (glow) {
		rDivElementChild.setAttribute("class", "effect");
	}
	rDivElementParent.appendChild(rDivElementChild);
	object.glow_mc = rDivElementChild;
	
	rDivElementParent.style.display = "block";
	rDivElementParent.setAttribute("tabindex", 1);
	parent.appendChild(rDivElementParent);
	object.objMain = rDivElementParent;

	doLoadTabIndexItems();
}

function doCreateRegion(name, left, top, parent, object) {
	rDivElementParent = document.createElement("div");
	rDivElementParent.id = name;
	rDivElementParent.name = name;
	rDivElementParent.style.position = "absolute";
	rDivElementParent.style.width = "350px";
	rDivElementParent.style.height = "275px";
	rDivElementParent.style.left = left + "px";
	rDivElementParent.style.top = top + "px";
	rDivElementParent.style.zIndex = rRegionDepthCount++;

	rCanvasElement = document.createElement("canvas");
	rCanvasElement.id = name + "_canvas";
	rCanvasElement.name = name + "_canvas";
	rCanvasElement.style.position = "absolute";
	rCanvasElement.width = "350";
	rCanvasElement.height = "275";
	rCanvasElement.style.width = "350px";
	rCanvasElement.style.height = "275px";
	rCanvasElement.style.left = "0px";
	rCanvasElement.style.top = "0px";

	rDivElementChild = document.createElement("div");
	rDivElementChild.id = name + "_marker_mc";
	rDivElementChild.name = name + "_marker_mc";
	rDivElementChild.style.position = "absolute";
	rDivElementChild.style.width = "100%";
	rDivElementChild.style.height = "100%";
	rDivElementChild.style.left = "0px";
	rDivElementChild.style.top = "0px";
	rDivElementChild.style.display = "none";
	rDivElementChild.style.border = "1px solid #000000";

	rDivElementParent.appendChild(rCanvasElement);
	rDivElementParent.appendChild(rDivElementChild);
	parent.appendChild(rDivElementParent);
	
	object.objMain = rDivElementParent;
	object.canvas = rCanvasElement;
	object.context = rCanvasElement.getContext("2d");
	object.marker_mc = rDivElementChild;	
}

function doHandBtnClickAction(rId) {
	clearInterval(rHandAniTimer);
	rHandAniTimer = 0;
	rHandAniFrameCount = 1;
	main.hand0_mc.getElementsByTagName("img")[0].src = rImageBasePath + "hand_move/ani_" + rHandAniFrameCount + '.png';
	main.hand1_mc.getElementsByTagName("img")[0].src = rImageBasePath + "hand_move/ani_" + rHandAniFrameCount + '.png';	
	if (rId==0) {
		main.setFeedback("cover region", "create row or column : continue tiling confirm", 0);
		main.tilingMove0_mc.objMain.style.display = "block";
		
		rPulseObjId = main.tilingMove0_mc.objMain.getElementsByTagName("div")[1].id;
		rPulseCount = 0;
		doPulseAni();		
		
		//main.tilingMove0_mc.pulseGlow(main.pulseRepetitions, main.pulseDuration, main.pulseAlphaMin, true);
		$("#" + main.hand0_mc.id).stop().animate(
			{
				opacity:0
			}, main.fadeSpeed, 
			function() {
				main.hand0_mc.style.display = "none";
			}
		);
		$("#" + main.hand1_mc.id).stop().animate(
			{
				opacity:0
			}, main.fadeSpeed, 
			function() {
				main.hand1_mc.style.display = "none";
			}
		);

		$("#" + main.region0_mc.dragChoiceRegion0_mc.objMain.id).stop().animate(
			{
				opacity:0
			}, main.fadeSpeed, 
			function() {
				main.region0_mc.dragChoiceRegion0_mc.objMain.style.display = "none";
			}
		);
		$("#" + main.region0_mc.dragChoiceRegion1_mc.objMain.id).stop().animate(
			{
				opacity:0
			}, main.fadeSpeed, 
			function() {
				main.region0_mc.dragChoiceRegion1_mc.objMain.style.display = "none";
			}
		);
	} else {
		main.setFeedback("cover region", "create row or column : start dragging confirm", 0);
		var counterOffset;
		switch (main.region0_mc.shapeType) {
			case 1 :
				counterOffset = 0.5*main.region0_mc.shapeSizeHole[0];
				break;
			case 2 :
				counterOffset = 0.5*main.region0_mc.shapeSizeHole[0];
				break;
			case 3 :
				counterOffset = main.region0_mc.shapeSizeBound[0]-0.5*main.region0_mc.shapeSizeHole[0];
				break;
			case 4 :
				counterOffset = main.region0_mc.shapeSizeBound[0]-0.5*main.region0_mc.shapeSizeHole[0];
				break;
		}
		$("#" + main.counterRows0_mc.id).stop().animate(
			{
				left:main.counterRows0_mc.style.left,
				top:Number(main.region0_mc.objMain.style.top.split("px")[0])+(counterOffset*main.region0_mc.cellSize[0]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterRows0_mc[1]  + "px"
			}, main.flySpeed, 
			function() {
				
			}
		);
		main.stage02_coverRegion(2);
		$("#" + main.hand0_mc.id).stop().animate(
			{
				opacity:0
			}, main.fadeSpeed, 
			function() {
				main.hand0_mc.style.display = "none";
			}
		);
		$("#" + main.hand1_mc.id).stop().animate(
			{
				opacity:0
			}, main.fadeSpeed, 
			function() {
				main.hand1_mc.style.display = "none";
			}
		);

		$("#" + main.region0_mc.dragChoiceRegion0_mc.objMain.id).stop().animate(
			{
				opacity:0
			}, main.fadeSpeed, 
			function() {
				main.region0_mc.dragChoiceRegion0_mc.objMain.style.display = "none";
			}
		);
		$("#" + main.region0_mc.dragChoiceRegion1_mc.objMain.id).stop().animate(
			{
				opacity:0
			}, main.fadeSpeed, 
			function() {
				main.region0_mc.dragChoiceRegion1_mc.objMain.style.display = "none";
			}
		);
	}
	
	doLoadTabIndexItems()
}

main.setContinueTiling1 = function() {
	main.tilingMove0_mc.objMain.style.display = "none";
	main.hand0_mc.style.display = "block";
	main.hand1_mc.style.display = "block";
	$("#" + main.hand0_mc.id).stop().animate(
		{
			opacity:1
		}, main.fadeSpeed, 
		function() {
			doLoadTabIndexItems();
		}
	);
	$("#" + main.hand1_mc.id).stop().animate(
		{
			opacity:1
		}, main.fadeSpeed, 
		function() {
			doLoadTabIndexItems();
		}
	);	
	main.setFeedback("cover region", "create row or column : continue tiling query", 0);
	var rowCover = [];
	var dragChoiceCover0 = [];
	var dragChoiceCover1 = [];
	for (var i = 0; i<main.region0_mc.shapeSizeBound[0]; i++) {
		dragChoiceCover0.push([0]);
	}
	for (var i = 0; i<main.region0_mc.shapeSizeBound[1]-main.region0_mc.shapeSizeHole[1]; i++) {
		rowCover.push(0);
	}
	for (var i = 0; i<main.region0_mc.shapeSizeHole[0]; i++) {
		dragChoiceCover1.push(rowCover);
	}
	switch (main.region0_mc.shapeType) {
		case 1 :
			dragChoiceRegionPosition0 = [(main.region0_mc.shapeSizeBound[1]-1)*main.region0_mc.cellSize[1], 0];
			dragChoiceRegionPosition1 = [main.region0_mc.shapeSizeHole[1]*main.region0_mc.cellSize[1], 0];
			handParamaters0 = [Number(main.region0_mc.objMain.style.left.split("px")[0])+(main.region0_mc.shapeSizeBound[1]-0.5)*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+main.region0_mc.shapeSizeHole[0]*main.region0_mc.cellSize[0], -90, 100];
			handParamaters1 = [Number(main.region0_mc.objMain.style.left.split("px")[0])+(main.region0_mc.shapeSizeBound[1]-1)*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+(main.region0_mc.shapeSizeHole[0]/2)*main.region0_mc.cellSize[0], 0, 100];
			break;
		case 2 :
			dragChoiceRegionPosition0 = [0, 0];
			dragChoiceRegionPosition1 = [0, 0];
			handParamaters0 = [Number(main.region0_mc.objMain.style.left.split("px")[0])+0.5*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+main.region0_mc.shapeSizeHole[0]*main.region0_mc.cellSize[0], -90, 100];
			handParamaters1 = [Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+(main.region0_mc.shapeSizeHole[0]/2)*main.region0_mc.cellSize[0], 0, -100];
			break;
		case 3 :
			dragChoiceRegionPosition0 = [0, 0];
			dragChoiceRegionPosition1 = [0, (main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0])*main.region0_mc.cellSize[0]];
			handParamaters0 = [Number(main.region0_mc.objMain.style.left.split("px")[0])+0.5*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0])*main.region0_mc.cellSize[0], 90, 100];
			handParamaters1 = [Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]/2)*main.region0_mc.cellSize[0], 0, -100];
			break;
		case 4 :
			dragChoiceRegionPosition0 = [(main.region0_mc.shapeSizeBound[1]-1)*main.region0_mc.cellSize[1], 0];
			dragChoiceRegionPosition1 = [main.region0_mc.shapeSizeHole[1]*main.region0_mc.cellSize[1], (main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0])*main.region0_mc.cellSize[0]];
			handParamaters0 = [Number(main.region0_mc.objMain.style.left.split("px")[0])+(main.region0_mc.shapeSizeBound[1]-0.5)*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0])*main.region0_mc.cellSize[0], 90, 100];
			handParamaters1 = [Number(main.region0_mc.objMain.style.left.split("px")[0])+(main.region0_mc.shapeSizeBound[1]-1)*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]/2)*main.region0_mc.cellSize[0], 0, 100];
			break;
	}
	main.hand0_mc.style.left = handParamaters0[0] + rArrHandOffset[main.region0_mc.shapeType-1].hand0_mc[0] + "px";
	main.hand0_mc.style.top = handParamaters0[1] + rArrHandOffset[main.region0_mc.shapeType-1].hand0_mc[1] + "px";
	main.hand0_mc.style.transform = "rotate(" + handParamaters0[2] + "deg) scale(" + (handParamaters0[3]/100) + ", 1)";

	main.hand1_mc.style.left = handParamaters1[0] + rArrHandOffset[main.region0_mc.shapeType-1].hand1_mc[0] + "px";
	main.hand1_mc.style.top = handParamaters1[1] + rArrHandOffset[main.region0_mc.shapeType-1].hand1_mc[1] + "px";
	main.hand1_mc.style.transform = "rotate(" + handParamaters1[2] + "deg) scale(" + (handParamaters1[3]/100) + ", 1)";
	
	clearInterval(rHandAniTimer);
	rHandAniTimer = 0;
	rHandAniFrameCount = 1;
	main.hand0_mc.getElementsByTagName("img")[0].src = rImageBasePath + "hand_move/ani_" + rHandAniFrameCount + '.png';
	main.hand1_mc.getElementsByTagName("img")[0].src = rImageBasePath + "hand_move/ani_" + rHandAniFrameCount + '.png';	
	rHandAniTimer = setInterval("doHandAni()", 100);
	
	
	var rLeft = 0;
	var rTop = 0;
	main.region0_mc.dragChoiceRegion0_mc = new Region();
	rLeft = dragChoiceRegionPosition0[0];
	rTop = dragChoiceRegionPosition0[1];
	doCreateRegion("dragChoiceRegion0_mc", rLeft, rTop, main.region0_mc.objMain, main.region0_mc.dragChoiceRegion0_mc);
	main.region0_mc.dragChoiceRegion0_mc.cover = dragChoiceCover0;
	main.region0_mc.dragChoiceRegion0_mc.cellSize = main.region0_mc.cellSize;
	main.region0_mc.dragChoiceRegion0_mc.cellColour = "#000000";
	main.region0_mc.dragChoiceRegion0_mc.cellAlpha = 0;
	main.region0_mc.dragChoiceRegion0_mc.borderColourExternal = main.borderColourLight;
	main.region0_mc.dragChoiceRegion0_mc.borderColourInternal = main.borderColourLight;
	main.region0_mc.dragChoiceRegion0_mc.borderAlphaExternal = 100;
	main.region0_mc.dragChoiceRegion0_mc.borderAlphaInternal = 100;
	main.region0_mc.dragChoiceRegion0_mc.objMain.style.opacity = 0;
	main.region0_mc.dragChoiceRegion0_mc.init();
	
	main.region0_mc.dragChoiceRegion0_mc.objMain.style.opacity = 0;
	$("#" + main.region0_mc.dragChoiceRegion0_mc.objMain.id).stop().animate(
		{
			opacity:1
		}, main.fadeSpeed, 
		function() {
			
		}
	);
	
	main.region0_mc.dragChoiceRegion1_mc = new Region();
	rLeft = dragChoiceRegionPosition1[0];
	rTop = dragChoiceRegionPosition1[1];
	doCreateRegion("dragChoiceRegion1_mc", rLeft, rTop, main.region0_mc.objMain, main.region0_mc.dragChoiceRegion1_mc);
	main.region0_mc.dragChoiceRegion1_mc.cover = dragChoiceCover1;
	main.region0_mc.dragChoiceRegion1_mc.cellSize = main.region0_mc.cellSize;
	main.region0_mc.dragChoiceRegion1_mc.cellColour = "#000000";
	main.region0_mc.dragChoiceRegion1_mc.cellAlpha = 0;
	main.region0_mc.dragChoiceRegion1_mc.borderColourExternal = main.borderColourLight;
	main.region0_mc.dragChoiceRegion1_mc.borderColourInternal = main.borderColourLight;
	main.region0_mc.dragChoiceRegion1_mc.borderAlphaExternal = 100;
	main.region0_mc.dragChoiceRegion1_mc.borderAlphaInternal = 100;
	main.region0_mc.dragChoiceRegion1_mc.objMain.style.opacity = 0;
	main.region0_mc.dragChoiceRegion1_mc.init();
	
	main.region0_mc.dragChoiceRegion1_mc.objMain.style.opacity = 0;
	$("#" + main.region0_mc.dragChoiceRegion1_mc.objMain.id).stop().animate(
		{
			opacity:1
		}, main.fadeSpeed, 
		function() {
			
		}
	);
	
	doLoadTabIndexItems()
};

function doMouseDownOne(rThis) {
	if (!rMouseDownOneFired) {
		rMouseDownOneFired = true;
		rMouseDownTwoFired = true;
		main.setFeedback("cover region", "drag row or column : continue tiling confirm", 0);
		main.tilingMove1_mc.objMain.style.display = "none";
		var rChild = main.region0_mc["tiling"+Math.pad((main.region0_mc.objMain.childElementCount-0), 2)+"_mc"].objMain;
		rChild.parentNode.removeChild(rChild);
	}
	
	doLoadTabIndexItems()
}

function doMouseDownTwo() {
	if (!rMouseDownTwoFired) {
		rMouseDownOneFired = true;
		rMouseDownTwoFired = true;
		main.setFeedback("cover region", "drag row or column : continue tiling confirm", 1);
		var rChild = document.getElementById("tilingMoveLarge0_mc");
		if (rChild!=null && rChild!=undefined && rChild!="") {
			rChild.parentNode.removeChild(rChild);
		}
		var counterOffset;
		switch (main.region0_mc.shapeType) {
			case 1 :
				counterOffset = 0.5*main.region0_mc.shapeSizeHole[0];
				break;
			case 2 :
				counterOffset = 0.5*main.region0_mc.shapeSizeHole[0];
				break;
			case 3 :
				counterOffset = main.region0_mc.shapeSizeBound[0]-0.5*main.region0_mc.shapeSizeHole[0];
				break;
			case 4 :
				counterOffset = main.region0_mc.shapeSizeBound[0]-0.5*main.region0_mc.shapeSizeHole[0];
				break;
		}
		
		$("#" + main.counterRows0_mc.id).stop().animate(
			{
				left:main.counterRows0_mc.style.left,
				top:Number(main.region0_mc.objMain.style.top.split("px")[0])+(counterOffset*main.region0_mc.cellSize[0]) + rArrCounterFOffset[main.region0_mc.shapeType-1].counterRows0_mc[1]  + "px"
			}, main.flySpeed, 
			function() {
				
			}
		);	
		
		$("#" + main.counterColumns0_mc.id).stop().animate(
			{
				opacity:1
			}, main.fadeSpeed, 
			function() {
				
			}
		);

		$("#" + main.counterRows1_mc.id).stop().animate(
			{
				opacity:1
			}, main.fadeSpeed, 
			function() {
				
			}
		);

		$("#" + main.counterColumns1_mc.id).stop().animate(
			{
				opacity:1
			}, main.fadeSpeed, 
			function() {
				
			}
		);	

		//main.reward_mc.loop++;
	}
	
	doLoadTabIndexItems()
}

main.setContinueTiling2 = function() {
	main.tilingMove1_mc.objMain.style.display = "block";

	rPulseObjId = main.tilingMove1_mc.objMain.getElementsByTagName("div")[1].id;
	rPulseCount = 0;
	doPulseAni();
	
	//this.tilingMove1_mc.pulseGlow(main.pulseRepetitions, main.pulseDuration, main.pulseAlphaMin, true);
	main.createRowOrColumn(1, 4);
	main.setFeedback("cover region", "drag row or column : continue tiling query", 0);
	
	//main.tilingMoveLarge0_mc.onPressExisting2 = doMouseDownOne;
	rEventHanler = function(e) { doMouseDownOne(main.tilingMoveLarge0_mc); };
	main.tilingMoveLarge0_mc.objMain.addEventListener("mousedown", rEventHanler , false);
	main.tilingMoveLarge0_mc.objMain.addEventListener("touchstart", rEventHanler , false);
	
	main.tilingMove1_mc.onPressExisting2 = doMouseDownTwo;
	rEventHanler = function(e) { doMouseDownTwo(); };
	main.tilingMove1_mc.objMain.addEventListener("mousedown", rEventHanler , false);
	main.tilingMove1_mc.objMain.addEventListener("touchstart", rEventHanler , false);
	
	doLoadTabIndexItems()
};

main.createRowOrColumn = function(tilingMoveIndex, nextStep) {
	var tilingMove_mc = main["tilingMove"+tilingMoveIndex+"_mc"];
	
	main.setFeedback("cover region", "create row or column : initial instruction", tilingMoveIndex);
	var x = Number(main.region0_mc.objMain.style.left.split("px")[0]);
	var y = Number(main.region0_mc.objMain.style.top.split("px")[0]);
	var shapeSizeBound = main.region0_mc.shapeSizeBound;
	var shapeSizeHole = main.region0_mc.shapeSizeHole;
	var cellSize = main.region0_mc.cellSize;
	var rLeft, rTop;

	switch (main.region0_mc.shapeType) {
		case 0 :
			tilingMove_mc.objMain.style.left = x + "px";
			tilingMove_mc.objMain.style.top = y + "px";
			tilingMove_mc.dragRegion = main.tilingMove0_mc.dropRegion=[[x, y], [x+shapeSizeBound[1]*cellSize[1], y+shapeSizeBound[0]*cellSize[0]]];
			break;
		case 1 :
			switch (tilingMoveIndex) {
				case 0 :
					tilingMove_mc.objMain.style.left = (x+(shapeSizeBound[1]-1)*cellSize[1]) + "px";
					tilingMove_mc.objMain.style.top = y + "px";
					tilingMove_mc.dragRegion = tilingMove_mc.dropRegion=[[x+shapeSizeHole[1]*cellSize[1], y], [x+shapeSizeBound[1]*cellSize[1], y+shapeSizeBound[0]*cellSize[0]]];
					break;
				case 1 :
					tilingMove_mc.objMain.style.left = x + "px";
					tilingMove_mc.objMain.style.top = (y+(shapeSizeBound[0]-1)*cellSize[0]) + "px";
					tilingMove_mc.dragRegion = tilingMove_mc.dropRegion=[[x, y+shapeSizeHole[0]*cellSize[0]], [x+(main.region0_mc.cover[shapeSizeBound[0]-1][shapeSizeHole[1]] == 1 ? shapeSizeHole[1] : shapeSizeBound[1])*cellSize[1], y+shapeSizeBound[0]*cellSize[0]]];
					break;
				}
			break;
		case 2 :
			switch (tilingMoveIndex) {
				case 0 :
					tilingMove_mc.objMain.style.left = x + "px";
					tilingMove_mc.objMain.style.top = y + "px";
					tilingMove_mc.dragRegion = tilingMove_mc.dropRegion=[[x, y], [x+(shapeSizeBound[1]-shapeSizeHole[1])*cellSize[1], y+shapeSizeBound[0]*cellSize[0]]];
					break;
				case 1 :
					tilingMove_mc.objMain.style.left = (x+(shapeSizeBound[1]-1)*cellSize[1]) + "px";
					tilingMove_mc.objMain.style.top = (y+(shapeSizeBound[0]-1)*cellSize[0]) + "px";
					tilingMove_mc.dragRegion = tilingMove_mc.dropRegion=[[x+(main.region0_mc.cover[shapeSizeBound[0]-1][0] == 1 ? shapeSizeBound[1]-shapeSizeHole[1] : 0)*cellSize[1], y+shapeSizeHole[0]*cellSize[0]], [x+shapeSizeBound[1]*cellSize[1], y+shapeSizeBound[0]*cellSize[0]]];
					break;
				}
			break;
		case 3 :
			switch (tilingMoveIndex) {
				case 0 :
					tilingMove_mc.objMain.style.left = x + "px";
					tilingMove_mc.objMain.style.top = (y+(shapeSizeBound[0]-1)*cellSize[0]) + "px";
					tilingMove_mc.dragRegion = tilingMove_mc.dropRegion=[[x, y], [x+(shapeSizeBound[1]-shapeSizeHole[1])*cellSize[1], y+shapeSizeBound[0]*cellSize[0]]];
					break;
				case 1 :
					tilingMove_mc.objMain.style.left = (x+(shapeSizeBound[1]-1)*cellSize[1]) + "px";
					tilingMove_mc.objMain.style.top = y + "px";
					tilingMove_mc.dragRegion = tilingMove_mc.dropRegion=[[x+(main.region0_mc.cover[0][0] == 1 ? shapeSizeBound[1]-shapeSizeHole[1] : 0)*cellSize[1], y], [x+shapeSizeBound[1]*cellSize[1], y+(shapeSizeBound[0]-shapeSizeHole[0])*cellSize[0]]];
					break;
				}
			break;
		case 4 :
			switch (tilingMoveIndex) {
				case 0 :
					tilingMove_mc.objMain.style.left = (x+(shapeSizeBound[1]-1)*cellSize[1]) + "px";
					tilingMove_mc.objMain.style.top = (y+(shapeSizeBound[0]-1)*cellSize[0]) + "px";
					tilingMove_mc.dragRegion = tilingMove_mc.dropRegion=[[x+shapeSizeHole[1]*cellSize[1], y], [x+shapeSizeBound[1]*cellSize[1], y+shapeSizeBound[0]*cellSize[0]]];
					break;
				case 1 :
					tilingMove_mc.objMain.style.left = x + "px";
					tilingMove_mc.objMain.style.top = y + "px";
					tilingMove_mc.dragRegion = tilingMove_mc.dropRegion=[[x, y], [x+(main.region0_mc.cover[0][shapeSizeBound[1]-1] == 1 ? shapeSizeHole[1] : shapeSizeBound[1])*cellSize[1], y+(shapeSizeBound[0]-shapeSizeHole[0])*cellSize[0]]];
					break;
				}
			break;
	}
	if (tilingMoveIndex == 1) {
		var rTVal = 0;
		switch (main.region0_mc.shapeType) {
			case 1 :
				main.counterRows1_mc.style.left = Number(main.region0_mc.objMain.style.left.split("px")[0])-main.counterOffset[0] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterRows1_mc[0] + "px";
				main.counterRows1_mc.style.top = Number(main.region0_mc.objMain.style.top.split("px")[0])+(main.region0_mc.shapeSizeHole[0]+0.5*(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]))*main.region0_mc.cellSize[0] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterRows1_mc[1] + "px";
				if (Number(main.counterRows0_mc.innerHTML) == main.region0_mc.shapeSizeBound[0]) {
					rTVal = Number(main.region0_mc.objMain.style.left.split("px")[0]) + ((main.region0_mc.shapeSizeHole[1]/2)*main.region0_mc.cellSize[1]) + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[0];
				} else {
					rTVal = Number(main.region0_mc.objMain.style.left.split("px")[0]) + ((main.region0_mc.shapeSizeBound[1]/2)*main.region0_mc.cellSize[1]) + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[0];
				}
				main.counterColumns1_mc.style.left = rTVal + "px";
				main.counterColumns1_mc.style.top = Number(main.region0_mc.objMain.style.top.split("px")[0])+main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0]+main.counterOffset[1] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[1] + "px";
				break;
			case 2 :
				main.counterRows1_mc.style.left = Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeBound[1]*main.region0_mc.cellSize[1]+main.counterOffset[0] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterRows1_mc[0] + "px";
				main.counterRows1_mc.style.top = Number(main.region0_mc.objMain.style.top.split("px")[0])+(main.region0_mc.shapeSizeHole[0]+0.5*(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]))*main.region0_mc.cellSize[0] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterRows1_mc[1] + "px";
				if (Number(main.counterRows0_mc.innerHTML) == main.region0_mc.shapeSizeBound[0]) {
					rTVal = Number(main.region0_mc.objMain.style.left.split("px")[0]) + ((main.region0_mc.shapeSizeBound[1]-(main.region0_mc.shapeSizeHole[1]/2))*main.region0_mc.cellSize[1]) + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[0];
				} else {
					rTVal = Number(main.region0_mc.objMain.style.left.split("px")[0]) + ((main.region0_mc.shapeSizeBound[1]/2)*main.region0_mc.cellSize[1]) + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[0];
				}
				main.counterColumns1_mc.style.left = rTVal + "px";				
				main.counterColumns1_mc.style.top = Number(main.region0_mc.objMain.style.top.split("px")[0])+main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0]+main.counterOffset[1] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[1] + "px";
				break;
			case 3 :
				main.counterRows1_mc.style.left = Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeBound[1]*main.region0_mc.cellSize[1]+main.counterOffset[0] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterRows1_mc[0] + "px";
				main.counterRows1_mc.style.top = Number(main.region0_mc.objMain.style.top.split("px")[0])+0.5*(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0])*main.region0_mc.cellSize[0] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterRows1_mc[1] + "px";
				if (Number(main.counterRows0_mc.innerHTML) == main.region0_mc.shapeSizeBound[0]) {
					rTVal = Number(main.region0_mc.objMain.style.left.split("px")[0]) + ((main.region0_mc.shapeSizeBound[1]-(main.region0_mc.shapeSizeHole[1]/2))*main.region0_mc.cellSize[1]) + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[0];
				} else {
					rTVal = Number(main.region0_mc.objMain.style.left.split("px")[0]) + ((main.region0_mc.shapeSizeBound[1]/2)*main.region0_mc.cellSize[1]) + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[0];
				}
				main.counterColumns1_mc.style.left = rTVal + "px";
				main.counterColumns1_mc.style.top = Number(main.region0_mc.objMain.style.top.split("px")[0])-main.counterOffset[1] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[1] + "px";
				break;
			case 4 :
				main.counterRows1_mc.style.left = Number(main.region0_mc.objMain.style.left.split("px")[0])-main.counterOffset[0] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterRows1_mc[0] + "px";
				main.counterRows1_mc.style.top = Number(main.region0_mc.objMain.style.top.split("px")[0])+0.5*(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0])*main.region0_mc.cellSize[0] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterRows1_mc[1] + "px";
				if (Number(main.counterRows0_mc.innerHTML) == main.region0_mc.shapeSizeBound[0]) {
					rTVal = Number(main.region0_mc.objMain.style.left.split("px")[0]) + ((main.region0_mc.shapeSizeHole[1]/2)*main.region0_mc.cellSize[1]) + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[0];
				} else {
					rTVal = Number(main.region0_mc.objMain.style.left.split("px")[0]) + ((main.region0_mc.shapeSizeBound[1]/2)*main.region0_mc.cellSize[1]) + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[0];
				}
				main.counterColumns1_mc.style.left = rTVal + "px";
				main.counterColumns1_mc.style.top = Number(main.region0_mc.objMain.style.top.split("px")[0])-main.counterOffset[1] + rArrCounterSOffset[main.region0_mc.shapeType-1].counterColumns1_mc[1] + "px";
				break;
		}
	}

	tilingMove_mc.dropStart = 0;
	tilingMove_mc.dropCount = 0;
	tilingMove_mc.coverCount = 1;

	tilingMove_mc.x0 = Number(tilingMove_mc.objMain.style.left.split("px")[0]);
	tilingMove_mc.y0 = Number(tilingMove_mc.objMain.style.top.split("px")[0]);
	tilingMove_mc.nextStep = nextStep;
	var depth = main.region0_mc.objMain.childElementCount + 1;
	var name = "tiling"+Math.pad(depth, 2)+"_mc";
	rArrInactiveShapes.push(name);
	tilingMove_mc.objName = name;
	
	rLeft = (Number(tilingMove_mc.objMain.style.left.split("px")[0])-Number(main.region0_mc.objMain.style.left.split("px")[0]));
	rTop = (Number(tilingMove_mc.objMain.style.top.split("px")[0])-Number(main.region0_mc.objMain.style.top.split("px")[0]));
	
	main.region0_mc[name] = new Tiling();
	doCreateTile(name, rLeft, rTop, main.region0_mc.objMain, main.region0_mc[name], false, tilingMove_mc.tileType, [1, 1]);
	main.region0_mc[name].objMain = document.getElementById(name);
	main.region0_mc[name].dimensions = [1, 1];
	main.region0_mc[name].dragRegion = [];
	main.region0_mc[name].dropRegion = [];
	main.region0_mc[name].draggable = false;
	main.region0_mc[name].snapTo = false;
	main.region0_mc[name].tileType = tilingMove_mc.tileType;
	main.region0_mc[name].init();
	
	main.region0_mc.addCover(tilingMove_mc);
	tilingMove_mc.initialTiling_mc = main.region0_mc[name];
	
	tilingMove_mc.init();
	
	tilingMove_mc.onDrop = function() {
		if (this.dropStart == 0) {
			this.dropCount++;
			switch (true) {
				case Number(this.objMain.style.top.split("px")[0]) == this.y0 && Number(this.objMain.style.left.split("px")[0]) != this.x0 :
					this.dropStart = 1;
					this.onDrop();
					break;
				case Number(this.objMain.style.left.split("px")[0]) == this.x0 && Number(this.objMain.style.top.split("px")[0]) != this.y0 :
					this.dropStart = 2;
					this.onDrop();
					break;
				default :
					switch (this.dropCount) {
						case 1 :
							tag = "create row or column : placement hint";
							level = 0;
							break;
						case 2 :
							tag = "create row or column : show placement grid";
							level = 0;
							var rowGuideCover = [[]];
							for (var i = 0; i<(this.dragRegion[1][0]-this.dragRegion[0][0])/main.region0_mc.cellSize[1]; i++) {
								rowGuideCover[0].push(0);
							}
							var rChild = document.getElementById("rowGuideRegion_mc");
							if (rChild!=null) {
								rChild.parentNode.removeChild(rChild);
							}
							rChild = document.getElementById("rowGuideRegion_mc");							
							main.region0_mc.rowGuideRegion_mc = new Region();
							rLeft = this.dragRegion[0][0]-Number(main.region0_mc.objMain.style.left.split("px")[0]);
							rTop = this.y0-Number(main.region0_mc.objMain.style.top.split("px")[0]);
							doCreateRegion("rowGuideRegion_mc", rLeft, rTop, main.region0_mc.objMain, main.region0_mc.rowGuideRegion_mc);
							main.region0_mc.rowGuideRegion_mc.cover = rowGuideCover;
							main.region0_mc.rowGuideRegion_mc.cellSize = main.region0_mc.cellSize;
							main.region0_mc.rowGuideRegion_mc.cellColour = main.cellColour;
							main.region0_mc.rowGuideRegion_mc.cellAlpha = 100;
							main.region0_mc.rowGuideRegion_mc.borderColourExternal = main.borderColourLight;
							main.region0_mc.rowGuideRegion_mc.borderColourInternal = main.borderColourLight;
							main.region0_mc.rowGuideRegion_mc.borderAlphaExternal = 100;
							main.region0_mc.rowGuideRegion_mc.borderAlphaInternal = 100;
							main.region0_mc.rowGuideRegion_mc.objMain.style.opacity = 0;
							main.region0_mc.rowGuideRegion_mc.init();

							$("#" + main.region0_mc.rowGuideRegion_mc.objMain.id).animate(
								{
									opacity:1
								}, main.fadeSpeed, 
								function() {
									
								}
							);

							var columnGuideCover = [];
							for (var i = 0; i<(this.dragRegion[1][1]-this.dragRegion[0][1])/main.region0_mc.cellSize[0]; i++) {
								columnGuideCover.push([0]);
							}
							rChild = document.getElementById("columnGuideRegion_mc");
							if (rChild!=null) {
								rChild.parentNode.removeChild(rChild);
							}
							rChild = document.getElementById("columnGuideRegion_mc");
							
							main.region0_mc.columnGuideRegion_mc = new Region();
							rLeft = this.x0-Number(main.region0_mc.objMain.style.left.split("px")[0]);
							rTop = this.dragRegion[0][1]-Number(main.region0_mc.objMain.style.top.split("px")[0]);
							doCreateRegion("columnGuideRegion_mc", rLeft, rTop, main.region0_mc.objMain, main.region0_mc.columnGuideRegion_mc);
							main.region0_mc.columnGuideRegion_mc.cover = columnGuideCover;
							main.region0_mc.columnGuideRegion_mc.cellSize = main.region0_mc.cellSize;
							main.region0_mc.columnGuideRegion_mc.cellColour = main.cellColour;
							main.region0_mc.columnGuideRegion_mc.cellAlpha = 100;
							main.region0_mc.columnGuideRegion_mc.borderColourExternal = main.borderColourLight;
							main.region0_mc.columnGuideRegion_mc.borderColourInternal = main.borderColourLight;
							main.region0_mc.columnGuideRegion_mc.borderAlphaExternal = 100;
							main.region0_mc.columnGuideRegion_mc.borderAlphaInternal = 100;
							main.region0_mc.columnGuideRegion_mc.objMain.style.opacity = 0;
							main.region0_mc.columnGuideRegion_mc.init();

							$("#" + main.region0_mc.columnGuideRegion_mc.objMain.id).animate(
								{
									opacity:1
								}, main.fadeSpeed, 
								function() {
									
								}
							);
							main.region0_mc.rowGuideRegion_mc.objMain.style.zIndex = this.initialTiling_mc.objMain.style.zIndex;
							main.region0_mc.columnGuideRegion_mc.objMain.style.zIndex = this.initialTiling_mc.objMain.style.zIndex;
							this.initialTiling_mc.objMain.style.zIndex = this.initialTiling_mc.objMain.style.zIndex + 1;
							break;
						case 3 :
							tag = "create row or column : place square";
							level = Math.round(Math.random());
							switch (level) {
								case 0 :
									var offset = [(2*Number(this.x0 == this.dragRegion[0][0])-1)*main.region0_mc.cellSize[1], 0];
									break;
								case 1 :
									var offset = [0, (2*Number(this.y0 == this.dragRegion[0][1])-1)*main.region0_mc.cellSize[0]];
									break;
							}
							
							this.draggable = false;
							
							var rThis, rThisX0, rThisY0;
							var rArrTempVal = Array.vectorSum([[this.x0, this.y0], offset]);
							rThis = this;
							rThisX0 = rArrTempVal[0] + "px";
							rThisY0 = rArrTempVal[1] + "px";
							$("#" + this.objMain.id).stop().animate(
								{
									left:rThisX0,
									top:rThisY0
								}, main.flySpeed, 
								function() {
									rThis.draggable = true;
									rThis.onDrop();									
								}
							);
							
							//this.fly(Array.vectorSum([[this.x0, this.y0], offset]), main.flySpeed);
							//this.glow_mc.fade(0, main.fadeSpeed);
							/*
							this.onEnterFrame = function() {
								if (this.fly_mc == undefined) {
									delete this.onEnterFrame;
									this.draggable = true;
									this.onDrop();
								}
							};
							*/
							break;
					}
					this.objMain.style.left = this.xRaw + "px";
					this.objMain.style.top = this.yRaw + "px";
					if (this.dropCount<3) {
						rPulseObjId = this.objMain.getElementsByTagName("div")[1].id;
						rPulseCount = 0;
						doPulseAni();						
						
						//this.pulseGlow(main.pulseRepetitions, main.pulseDuration, main.pulseAlphaMin, true);
					}
					main.setFeedback("cover region", tag, level);
					break;
			}
		} else {
			if (main.region0_mc.columnGuideRegion_mc!=undefined) {
				$("#" + main.region0_mc.columnGuideRegion_mc.objMain.id).animate(
					{
						opacity:0
					}, main.fadeSpeed, 
					function() {
						
					}
				);
			}
			
			if (main.region0_mc.columnGuideRegion_mc!=undefined) {
				$("#" + main.region0_mc.rowGuideRegion_mc.objMain.id).animate(
					{
						opacity:0
					}, main.fadeSpeed, 
					function() {
						
					}
				);
			}
			if (main.region0_mc.addCover(this)) {
				if (++this.coverCount == 2) {
					this.dragRegionFull = this.dragRegion.slice();
					this.objMain.setAttribute("dragRegionFull", this.dragRegionFull[0][0] + "~" + this.dragRegionFull[0][1] + "~" + this.dragRegionFull[1][0] + "~" + this.dragRegionFull[1][1]);
					switch (this.dropStart) {
						case 1 :
							this.dragRegion[0][1] = this.y0;
							this.dragRegion[1][1] = this.y0+main.region0_mc.cellSize[0];
							break;
						case 2 :
							this.dragRegion[0][0] = this.x0;
							this.dragRegion[1][0] = this.x0+main.region0_mc.cellSize[1];
							break;
					}
				}
				var level;
				var dragRegionHeight = (this.dragRegion[1][1]-this.dragRegion[0][1])/main.region0_mc.cellSize[0];
				var dragRegionWidth = (this.dragRegion[1][0]-this.dragRegion[0][0])/main.region0_mc.cellSize[1];
				switch (this.coverCount) {
					case (this.dropStart == 1 ? dragRegionWidth : dragRegionHeight)-1 :
						level = 6+this.dropStart-1;
						break;
					case (this.dropStart == 1 ? dragRegionWidth : dragRegionHeight) :
						level = 8+(this.dropStart-1)+2*Number(main.region0_mc.shapeType == 0);
						break;
					case 2 :
						level = 0+this.dropStart-1;
						break;
					case 3 :
						level = 2+this.dropStart-1;
						break;
					default :
						level = 4+this.dropStart-1;
						break;
				}
				main.setFeedback("cover region", "create row or column : drop", level);
				var depth = main.region0_mc.objMain.childElementCount + 1;
				var name = "tiling"+Math.pad(depth, 2)+"_mc";
				main.region0_mc[name] = new Tiling();
				rLeft = (Number(this.objMain.style.left.split("px")[0])-Number(main.region0_mc.objMain.style.left.split("px")[0]));
				rTop = (Number(this.objMain.style.top.split("px")[0])-Number(main.region0_mc.objMain.style.top.split("px")[0]));
				main.region0_mc[name] = new Tiling();
				doCreateTile(name, rLeft, rTop, main.region0_mc.objMain, main.region0_mc[name], false, this.tileType, [1, 1]);
				main.region0_mc[name].dimensions = [1, 1];
				main.region0_mc[name].dragRegion = [];
				main.region0_mc[name].dropRegion = [];
				main.region0_mc[name].draggable = false;
				main.region0_mc[name].snapTo = false;
				main.region0_mc[name].tileType = this.tileType;
				
				rPulseObjId = this.objMain.getElementsByTagName("div")[1].id;
				rPulseCount = 0;
				doPulseAni();				
				
				//this.pulseGlow(main.pulseRepetitions, main.pulseDuration, main.pulseAlphaMin, true);
				var counter_mc = (this.dropStart == 1 ? main["counterColumns"+tilingMoveIndex+"_mc"] : main["counterRows"+tilingMoveIndex+"_mc"]);
				counter_mc.innerHTML = Number(counter_mc.innerHTML) + 1;
				var done = true;
				switch (this.dropStart) {
					case 1 :
						for (var i = (this.dragRegion[0][0]-Number(main.region0_mc.objMain.style.left.split("px")[0]))/main.region0_mc.cellSize[1]; i<(this.dragRegion[1][0]-Number(main.region0_mc.objMain.style.left.split("px")[0]))/main.region0_mc.cellSize[1]; i++) {
							if (main.region0_mc.cover[(this.dragRegion[0][1]-Number(main.region0_mc.objMain.style.top.split("px")[0]))/main.region0_mc.cellSize[0]][i] == 0) {
								done = false;
								break;
							}
						}
						break;
					case 2 :
						for (var i = (this.dragRegion[0][1]-Number(main.region0_mc.objMain.style.top.split("px")[0]))/main.region0_mc.cellSize[0]; i<(this.dragRegion[1][1]-Number(main.region0_mc.objMain.style.top.split("px")[0]))/main.region0_mc.cellSize[0]; i++) {
							if (main.region0_mc.cover[i][(this.dragRegion[0][0]-Number(main.region0_mc.objMain.style.left.split("px")[0]))/main.region0_mc.cellSize[1]] == 0) {
								done = false;
								break;
							}
						}
						break;
				}
				if (done) {
					this.objMain.style.display = "none";
					main.stage02_coverRegion(this.nextStep);
				} else {
					if (this == main.tilingMove0_mc) {
						var done = true;
						switch (main.region0_mc.shapeType) {
							case 0 :
								done = false;
								break;
							case 1 :
								for (var i = 0; i<main.region0_mc.shapeSizeBound[0]; i++) {
									if (i<main.region0_mc.shapeSizeHole[0] && main.region0_mc.cover[i][main.region0_mc.shapeSizeBound[1]-1] == 0 || i>=main.region0_mc.shapeSizeHole[0] && main.region0_mc.cover[i][main.region0_mc.shapeSizeBound[1]-1] != 0) {
										done = false;
										break;
									}
								}
								break;
							case 2 :
								for (var i = 0; i<main.region0_mc.shapeSizeBound[0]; i++) {
									if (i<main.region0_mc.shapeSizeHole[0] && main.region0_mc.cover[i][0] == 0 || i>=main.region0_mc.shapeSizeHole[0] && main.region0_mc.cover[i][0] != 0) {
										done = false;
										break;
									}
								}
								break;
							case 3 :
								for (var i = 0; i<main.region0_mc.shapeSizeBound[0]; i++) {
									if (i<(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]) && main.region0_mc.cover[i][0] != 0 || i>=(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]) && main.region0_mc.cover[i][0] == 0) {
										done = false;
										break;
									}
								}
								break;
							case 4 :
								for (var i = 0; i<main.region0_mc.shapeSizeBound[0]; i++) {
									if (i<(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]) && main.region0_mc.cover[i][main.region0_mc.shapeSizeBound[1]-1] != 0 || i>=(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]) && main.region0_mc.cover[i][main.region0_mc.shapeSizeBound[1]-1] == 0) {
										done = false;
										break;
									}
								}
								break;
						}
					}
					if (done) {
						main.setContinueTiling1();
					} else {
						this.dropCount = 0;
					}
				}
			} else {
				this.objMain.style.left = this.xRaw + "px";
				this.objMain.style.top = this.yRaw + "px";
				
				rPulseObjId = this.objMain.getElementsByTagName("div")[1].id;
				rPulseCount = 0;
				doPulseAni();				
				
				//this.pulseGlow(main.pulseRepetitions, main.pulseDuration, main.pulseAlphaMin, true);
				main.setFeedback("cover region", "create row or column : duplicate tiling warning", 0);
			}
		}
		if (this.draggable) {
			this.objMain.getElementsByTagName("div")[1].setAttribute("class", "effect");
		}
		
		doLoadTabIndexItems();
	};
	
	doLoadTabIndexItems();
};

function doMouseDownThree(e, rThis) {
	if (!rMouseDownThreeFired) {
		//rMouseDownThreeFired = true;
		//rThis.objMain.removeAttribute("class");
	}
}

main.dragRowOrColumn = function(tilingMoveIndex, nextStep) {
	var tilingMove_mc = main["tilingMove"+tilingMoveIndex+"_mc"];
	var dimensionsLarge;
	var rTempVal = tilingMove_mc.objMain.getAttribute("dragRegionFull").split("~");
	var dragRegionLarge = [];
	dragRegionLarge.push([Number(rTempVal[0]), Number(rTempVal[1])]);
	dragRegionLarge.push([Number(rTempVal[2]), Number(rTempVal[3])]);
	var positionLarge;
	switch (tilingMove_mc.dropStart) {
		case 1 :
			dimensionsLarge = [1, tilingMove_mc.coverCount];
			switch (main.region0_mc.shapeType) {
				case 0 :
					dragRegionLarge = [[Number(main.region0_mc.objMain.style.left.split("px")[0]), Number(main.region0_mc.objMain.style.top.split("px")[0])], [Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeBound[1]*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0]]];
					positionLarge = dragRegionLarge[0];
					break;
				case 1 :
					switch (tilingMoveIndex) {
						case 0 :
							positionLarge = dragRegionLarge[0];
							break;
						case 1 :
							positionLarge = [dragRegionLarge[0][0], dragRegionLarge[1][1]-main.region0_mc.cellSize[0]];
							break;
						}
					break;
				case 2 :
					switch (tilingMoveIndex) {
						case 0 :
							positionLarge = dragRegionLarge[0];
							break;
						case 1 :
							positionLarge = [dragRegionLarge[0][0], dragRegionLarge[1][1]-main.region0_mc.cellSize[0]];
							break;
						}
					break;
				case 3 :
					switch (tilingMoveIndex) {
						case 0 :
							positionLarge = [dragRegionLarge[0][0], dragRegionLarge[1][1]-main.region0_mc.cellSize[0]];
							break;
						case 1 :
							positionLarge = dragRegionLarge[0];
							break;
						}
					break;
				case 4 :
					switch (tilingMoveIndex) {
						case 0 :
							dragRegionLarge = [[Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeHole[1]*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])], [Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeBound[1]*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0]]];
							positionLarge = [dragRegionLarge[0][0], dragRegionLarge[1][1]-main.region0_mc.cellSize[0]];
							break;
						case 1 :
							positionLarge = dragRegionLarge[0];
							break;
						}
					break;
			}
			break;
		case 2 :
			dimensionsLarge = [tilingMove_mc.coverCount, 1];
			switch (main.region0_mc.shapeType) {
				case 0 :
					dragRegionLarge = [[Number(main.region0_mc.objMain.style.left.split("px")[0]), Number(main.region0_mc.objMain.style.top.split("px")[0])], [Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeBound[1]*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0]]];
					positionLarge = dragRegionLarge[0];
					break;
				case 1 :
					switch (tilingMoveIndex) {
						case 0 :
							dragRegionLarge = [[Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeHole[1]*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])], [Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeBound[1]*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+tilingMove_mc.coverCount*main.region0_mc.cellSize[0]]];
							positionLarge = [dragRegionLarge[1][0]-main.region0_mc.cellSize[1], dragRegionLarge[0][1]];
							break;
						case 1 :
							positionLarge = dragRegionLarge[0];
							break;
						}
					break;
				case 2 :
					switch (tilingMoveIndex) {
						case 0 :
							dragRegionLarge = [tilingMove_mc.dragRegion[0], [tilingMove_mc.dragRegion[1][0]+(main.region0_mc.shapeSizeBound[1]-main.region0_mc.shapeSizeHole[1]-1)*main.region0_mc.cellSize[1], tilingMove_mc.dragRegion[0][1]+tilingMove_mc.coverCount*main.region0_mc.cellSize[0]]];
							positionLarge = dragRegionLarge[0];
							break;
						case 1 :
							positionLarge = [dragRegionLarge[1][0]-main.region0_mc.cellSize[1], dragRegionLarge[0][1]];
							break;
						}
					break;
				case 3 :
					switch (tilingMoveIndex) {
						case 0 :
							dragRegionLarge = [[Number(main.region0_mc.objMain.style.left.split("px")[0]), Number(main.region0_mc.objMain.style.top.split("px")[0])+(main.region0_mc.shapeSizeBound[0]-tilingMove_mc.coverCount)*main.region0_mc.cellSize[0]], [Number(main.region0_mc.objMain.style.left.split("px")[0])+(main.region0_mc.shapeSizeBound[1]-main.region0_mc.shapeSizeHole[1])*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0]]];
							positionLarge = dragRegionLarge[0];
							break;
						case 1 :
							positionLarge = [Number(main.region0_mc.objMain.style.left.split("px")[0])+(main.region0_mc.shapeSizeBound[1]-1)*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])];
							break;
						}
					break;
				case 4 :
					switch (tilingMoveIndex) {
						case 0 :
							dragRegionLarge = [[Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeHole[1]*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+(main.region0_mc.shapeSizeBound[0]-tilingMove_mc.coverCount)*main.region0_mc.cellSize[0]], [Number(main.region0_mc.objMain.style.left.split("px")[0])+main.region0_mc.shapeSizeBound[1]*main.region0_mc.cellSize[1], Number(main.region0_mc.objMain.style.top.split("px")[0])+main.region0_mc.shapeSizeBound[0]*main.region0_mc.cellSize[0]]];
							positionLarge = [dragRegionLarge[1][0]-main.region0_mc.cellSize[0], dragRegionLarge[0][1]];
							break;
						case 1 :
							positionLarge = dragRegionLarge[0];
							break;
						}
					break;
			}
			break;
	}

	var depth = main.divSection_2.childElementCount + 1;
	var name = "tilingMoveLarge"+tilingMoveIndex+"_mc";
	main[name] = new Tiling();
	doCreateTile(name, positionLarge[0], positionLarge[1], main.divSection_2, main[name], true, tilingMoveIndex, dimensionsLarge);
	main[name].dimensions = dimensionsLarge;
	main[name].dragRegion = dragRegionLarge;
	main[name].dropRegion = dragRegionLarge;
	main[name].draggable = true;
	main[name].snapTo = true;
	main[name].tileType = tilingMoveIndex;
	main[name].init();
	
	
	var tilingMoveLarge_mc = main["tilingMoveLarge"+tilingMoveIndex+"_mc"];

	tilingMoveLarge_mc.x0 = Number(tilingMoveLarge_mc.objMain.style.left.split("px")[0]);
	tilingMoveLarge_mc.y0 = Number(tilingMoveLarge_mc.objMain.style.top.split("px")[0]);

	rPulseObjId = tilingMoveLarge_mc.objMain.getElementsByTagName("div")[1].id;
	rPulseCount = 0;
	doPulseAni();	
	
	//tilingMoveLarge_mc.pulseGlow(this.pulseRepetitions, this.pulseDuration, this.pulseAlphaMin, true);

	rEventHanler = function(e) { doMouseDownThree(e, tilingMoveLarge_mc); };
	tilingMoveLarge_mc.objMain.addEventListener("mousedown", rEventHanler , false);
	tilingMoveLarge_mc.objMain.addEventListener("touchstart", rEventHanler , false);
	
	tilingMoveLarge_mc.nextStep = nextStep;
	tilingMoveLarge_mc.coverCount = 1;

	tilingMoveLarge_mc.onDrop = function() {
		if (main.region0_mc.addCover(this)) {
			++this.coverCount;
			var depth = main.region0_mc.objMain.childElementCount + 1;
			var name = "tiling"+Math.pad(depth, 2)+"_mc";
			main.region0_mc[name] = new Tiling();
			
			doCreateTile(name, Number(this.objMain.style.left.split("px")[0])-Number(main.region0_mc.objMain.style.left.split("px")[0]), Number(this.objMain.style.top.split("px")[0])-Number(main.region0_mc.objMain.style.top.split("px")[0]), main.region0_mc.objMain, main.region0_mc[name], false, this.tileType, this.dimensions);
			main.region0_mc[name].dimensions = this.dimensions;
			main.region0_mc[name].dragRegion = [];
			main.region0_mc[name].dropRegion = [];
			main.region0_mc[name].draggable = false;
			main.region0_mc[name].snapTo = false;
			main.region0_mc[name].tileType = this.tileType;
			main.region0_mc[name].init();			

			rPulseObjId = this.objMain.getElementsByTagName("div")[1].id;
			rPulseCount = 0;
			doPulseAni();			
			//this.pulseGlow(main.pulseRepetitions, main.pulseDuration, main.pulseAlphaMin, true);

			var counter_mc = (tilingMove_mc.dropStart == 1 ? main["counterRows"+tilingMoveIndex+"_mc"] : main["counterColumns"+tilingMoveIndex+"_mc"]);
			counter_mc.innerHTML = Number(counter_mc.innerHTML) + 1;
			var done = true;
			var row0 = (this.dragRegion[0][1]-Number(main.region0_mc.objMain.style.top.split("px")[0]))/main.region0_mc.cellSize[0];
			var row1 = (this.dragRegion[1][1]-Number(main.region0_mc.objMain.style.top.split("px")[0]))/main.region0_mc.cellSize[0];
			var column0 = (this.dragRegion[0][0]-Number(main.region0_mc.objMain.style.left.split("px")[0]))/main.region0_mc.cellSize[1];
			var column1 = (this.dragRegion[1][0]-Number(main.region0_mc.objMain.style.left.split("px")[0]))/main.region0_mc.cellSize[1];
			for (var i = row0; i<row1; i++) {
				for (var j = column0; j<column1; j++) {
					if (main.region0_mc.cover[i][j] == 0) {
						done = false;
						break;
					}
				}
			}
			if (done) {
				main.stage02_coverRegion(this.nextStep);
				if (document.getElementById(this.objMain.id)!=null && document.getElementById(this.objMain.id)!=undefined && document.getElementById(this.objMain.id)!="") {
					this.objMain.parentNode.removeChild(this.objMain);
				}
			} else {
				if (tilingMoveIndex == 0 && main.region0_mc.shapeType>0) {
					done = true;
					for (var i = row0; i<row1; i++) {
						for (var j = column0; j<column1; j++) {
							switch (tilingMove_mc.dropStart) {
								case 1 :
									switch (main.region0_mc.shapeType) {
										case 1 :
											if (i<main.region0_mc.shapeSizeHole[0] && main.region0_mc.cover[i][j] == 0 || i>=main.region0_mc.shapeSizeHole[0] && main.region0_mc.cover[i][j] != 0) {
												done = false;
											}
											break;
										case 2 :
											if (i<main.region0_mc.shapeSizeHole[0] && main.region0_mc.cover[i][j] == 0 || i>=main.region0_mc.shapeSizeHole[0] && main.region0_mc.cover[i][j] != 0) {
												done = false;
											}
											break;
										case 3 :
											if (i<(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]) && main.region0_mc.cover[i][j] != 0 || i>=(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]) && main.region0_mc.cover[i][j] == 0) {
												done = false;
											}
											break;
										case 4 :
											if (i<(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]) && main.region0_mc.cover[i][j] != 0 || i>=(main.region0_mc.shapeSizeBound[0]-main.region0_mc.shapeSizeHole[0]) && main.region0_mc.cover[i][j] == 0) {
												done = false;
											}
											break;
									}
									break;
								case 2 :
									switch (main.region0_mc.shapeType) {
										case 1 :
											done = false;
											break;
										case 2 :
											done = false;
											break;
										case 3 :
											done = false;
											break;
										case 4 :
											if (j<main.region0_mc.shapeSizeHole[1] && main.region0_mc.cover[i][j] == 0 || j>=main.region0_mc.shapeSizeHole[1] && main.region0_mc.cover[i][j] != 0) {
												done = false;
											}
											break;
									}
									break;
							}
						}
					}
				}
				if (done) {
					main.setContinueTiling2();
				} else {
					var level;
					var dragRegionHeight = (this.dragRegion[1][1]-this.dragRegion[0][1])/main.region0_mc.cellSize[0];
					var dragRegionWidth = (this.dragRegion[1][0]-this.dragRegion[0][0])/main.region0_mc.cellSize[1];
					switch (this.coverCount) {
					case (tilingMove_mc.dropStart == 1 ? dragRegionHeight : dragRegionWidth)-1 :
						level = 6+tilingMove_mc.dropStart-1;
						break;
					case 2 :
						level = 0+(tilingMove_mc.dropStart-1)+2*Number(main.region0_mc.shapeType == 0);
						break;
					default :
						level = 4+tilingMove_mc.dropStart-1;
						break;
					}
					main.setFeedback("cover region", "drag row or column : drop", level);
				}
			}
		} else {
			this._x = this.xRaw + "px";
			this._y = this.yRaw + "px";
			
			rPulseObjId = this.objMain.getElementsByTagName("div")[1].id;
			rPulseCount = 0;
			doPulseAni();			
			
			//this.pulseGlow(main.pulseRepetitions, main.pulseDuration, main.pulseAlphaMin, true);
			main.setFeedback("cover region", "drag row or column : duplicate tiling warning", tilingMove_mc.dropStart-1);
		}
		if (this.draggable) {
			this.objMain.getElementsByTagName("div")[1].setAttribute("class", "effect");
		}
		
		doLoadTabIndexItems();
	};
	
	doLoadTabIndexItems();
};

main.stage03_findArea = function(step) {
	switch (step) {
		case 0 :
			main.stage = 3;
			$("#" + main.counterRows0_mc.id).stop().animate(
				{
					opacity:1
				}, main.fadeSpeed, 
				function() {
				}
			);
			$("#" + main.counterColumns0_mc.id).stop().animate(
				{
					opacity:1
				}, main.fadeSpeed, 
				function() {
					
				}
			);			
			main.region0_mc.setCellColour("#FFFFFF");
			if (main.region0_mc.shapeType == 0) {
				main.region0_mc.rectangleSelection = 0;
				main.stage03_findArea(1);
			} else {
				main.setFeedback("cover region", "drag row or column : tiling complete", 0);
				for (var name in main.region0_mc) {
					if (name.substr(0, 6) == "tiling") {
						main.region0_mc[name].objMain.style.zIndex = 2500;
						main.region0_mc[name].objMain.style.cursor = "pointer";
						main.region0_mc[name].objMain.onmousedown = function() {
							/*
							main.region0_mc.rectangleSelection = main.region0_mc[this.id].tileType;
							main.stage03_findArea(1);
							*/
						};
					}
				}
			}
			if (main.region0_mc.shapeType != 0) {
				var x0 = y0 = x1 = y1 = 0;
	
				document.getElementById("divOutline0_mc").style.opacity = 0;
				document.getElementById("divOutline1_mc").style.opacity = 0;
				
				document.getElementById("divOutline0_mc").style.display = "block";
				document.getElementById("divOutline1_mc").style.display = "block";

				document.getElementById("divOutline0_mc").style.cursor = "pointer";
				document.getElementById("divOutline1_mc").style.cursor = "pointer";

				document.getElementById("divOutline0_mc").setAttribute("tileType", 0);
				document.getElementById("divOutline1_mc").setAttribute("tileType", 1);
				
				/*
				document.getElementById("divOutline0_mc").onclick = function() {
					if (this.style.cursor=="pointer") {
						rCounter0McId = "";
						rCounter1McId = "";						
						main.region0_mc.rectangleSelection = this.getAttribute("tileType");
						main.stage03_findArea(1);						
					}
				}
				document.getElementById("divOutline1_mc").onclick = function() {
					if (this.style.cursor=="pointer") {
						rCounter0McId = "";
						rCounter1McId = "";							
						main.region0_mc.rectangleSelection = this.getAttribute("tileType");
						main.stage03_findArea(1);						
					}
				}
				*/
				
				document.getElementById("divOutline0_mc").style.width = Number(main.counterColumns0_mc.innerHTML)*(main.region0_mc.cellSize[1]) + "px";
				document.getElementById("divOutline0_mc").style.height = Number(main.counterRows0_mc.innerHTML)*(main.region0_mc.cellSize[0]) + "px";
				
				document.getElementById("divOutline1_mc").style.width = Number(main.counterColumns1_mc.innerHTML)*(main.region0_mc.cellSize[1]) + "px";
				document.getElementById("divOutline1_mc").style.height = Number(main.counterRows1_mc.innerHTML)*(main.region0_mc.cellSize[0]) + "px";				

				document.getElementById("divOutline0_mc").style.borderLeft = "3px solid " + main.cellColourGuide;
				document.getElementById("divOutline0_mc").style.borderTop = "3px solid " + main.cellColourGuide;
				document.getElementById("divOutline0_mc").style.borderRight = "3px solid " + main.cellColourGuide;
				document.getElementById("divOutline0_mc").style.borderBottom = "3px solid " + main.cellColourGuide;
				
				document.getElementById("divOutline1_mc").style.borderLeft = "3px solid " + main.cellColourGuide;
				document.getElementById("divOutline1_mc").style.borderTop = "3px solid " + main.cellColourGuide;
				document.getElementById("divOutline1_mc").style.borderRight = "3px solid " + main.cellColourGuide;
				document.getElementById("divOutline1_mc").style.borderBottom = "3px solid " + main.cellColourGuide;
				
				switch (main.region0_mc.shapeType) {
					case 1 :
						x0 = main.region0_mc.shapeSizeHole[1]*main.region0_mc.cellSize[1];
						y1 = main.region0_mc.shapeSizeHole[0]*main.region0_mc.cellSize[0];
						break;
					case 2 :
						x1 = (main.region0_mc.shapeSizeBound[1]-Number(main.counterColumns1_mc.innerHTML))*main.region0_mc.cellSize[1];
						y1 = main.region0_mc.shapeSizeHole[0]*main.region0_mc.cellSize[0];
						break;
					case 3 :
						y0 = (main.region0_mc.shapeSizeBound[0]-Number(main.counterRows0_mc.innerHTML))*main.region0_mc.cellSize[0];
						x1 = (main.region0_mc.shapeSizeBound[1]-Number(main.counterColumns1_mc.innerHTML))*main.region0_mc.cellSize[1];
						break;
					case 4 :
						x0 = (main.region0_mc.shapeSizeBound[1]-Number(main.counterColumns0_mc.innerHTML))*main.region0_mc.cellSize[1];
						y0 = (main.region0_mc.shapeSizeBound[0]-Number(main.counterRows0_mc.innerHTML))*main.region0_mc.cellSize[0];
						break;
				}
				document.getElementById("divOutline0_mc").style.left = x0 - 3 + "px";
				document.getElementById("divOutline0_mc").style.top = y0 - 3 + "px";
				
				document.getElementById("divOutline1_mc").style.left = x1 - 3 + "px";
				document.getElementById("divOutline1_mc").style.top = y1 - 3 + "px";
				
				var rRectOutLine0 = document.getElementById("divOutline0_mc").getBoundingClientRect();
				var rRectOutLine1 = document.getElementById("divOutline1_mc").getBoundingClientRect();
				
				switch (main.region0_mc.shapeType) {
					case 1:
						if (Math.round(rRectOutLine0.right)==Math.round(rRectOutLine1.right)) {

							document.getElementById("divOutline0_mc").style.top = y0 - 3 + "px";
							
							document.getElementById("divOutline1_mc").style.left = x1 - 3 + "px";
						} else {

							document.getElementById("divOutline1_mc").style.left = x1 - 3 + "px";
							
							document.getElementById("divOutline0_mc").style.top = y0 - 3 + "px";
						}
						break;
					case 2:
						if (Math.round(rRectOutLine0.left)==Math.round(rRectOutLine1.left)) {

							document.getElementById("divOutline0_mc").style.top = y0 - 3 + "px";
							
							document.getElementById("divOutline1_mc").style.left = x1 - 3 + "px";
						} else {

							document.getElementById("divOutline1_mc").style.left = x1 + "px";
							
							document.getElementById("divOutline0_mc").style.top = y0 - 3 + "px";
						}
						break;						
					case 3:
						if (Math.round(rRectOutLine0.left)==Math.round(rRectOutLine1.left)) {

							document.getElementById("divOutline0_mc").style.top = y0 + "px";
							
							document.getElementById("divOutline1_mc").style.left = x1 - 3 + "px";
						} else {

							document.getElementById("divOutline1_mc").style.left = x1 + "px";
							
							document.getElementById("divOutline0_mc").style.top = y0 - 3 + "px";
						}
						break;
					case 4:
						if (Math.round(rRectOutLine0.right)==Math.round(rRectOutLine1.right)) {

							document.getElementById("divOutline0_mc").style.top = y0 + "px";
							
							document.getElementById("divOutline1_mc").style.left = x1 - 3 + "px";
						} else {
							document.getElementById("divOutline1_mc").style.left = x1 - 3 + "px";
							
							document.getElementById("divOutline0_mc").style.top = y0 - 3 + "px";
						}
						break;						
					default:
						break;
				}
				
				switch (main.region0_mc.shapeType) {
					case 1:
						if (Math.round(rRectOutLine0.right)==Math.round(rRectOutLine1.right)) {
							document.getElementById("divOutline0_mc").style.borderBottom = "none";
						} else {
							document.getElementById("divOutline1_mc").style.borderRight = "none";
						}
						break;
					case 2:
						if (Math.round(rRectOutLine0.left)==Math.round(rRectOutLine1.left)) {
							document.getElementById("divOutline0_mc").style.borderBottom = "none";
						} else {
							document.getElementById("divOutline1_mc").style.borderLeft = "none";
						}
						break;						
					case 3:
						if (Math.round(rRectOutLine0.left)==Math.round(rRectOutLine1.left)) {
							document.getElementById("divOutline0_mc").style.borderTop = "none";
						} else {
							document.getElementById("divOutline1_mc").style.borderLeft = "none";
						}
						break;
					case 4:
						if (Math.round(rRectOutLine0.right)==Math.round(rRectOutLine1.right)) {
							document.getElementById("divOutline0_mc").style.borderTop = "none";
						} else {
							document.getElementById("divOutline1_mc").style.borderRight = "none";
						}
						break;						
					default:
						break;
				}
				
				$("#divOutline0_mc, #divOutline1_mc").stop().animate(
					{
						opacity:1
					}, main.fadeSpeed, 
					function(){
						doLoadTabIndexItems();
					}
				);
				
				rPulseObjId = "divOutline0_mc";
				rPulseCount = 0;
				doPulseAni();

				rPulseObjIdTwo = "divOutline1_mc";
				rPulseCountTwo = 0;
				doPulseAniTwo();				
				
				//main.region0_mc.outline0_mc.pulse(5, 5, 30, true);
				//main.region0_mc.outline1_mc.pulse(5, 5, 30, true);
			}
			break;
		case 1 :
			if (main.region0_mc.shapeType != 0) {
				document.getElementById("divOutline0_mc").style.cursor = "default";
				document.getElementById("divOutline1_mc").style.cursor = "default";
			}
			$("#divOutline0_mc, #divOutline1_mc").stop().animate(
				{
					opacity:0
				}, main.fadeSpeed, 
				function(){
					
				}
			);
			main.formula_mc.stage = 1;
			for (var name in main.region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					main.region0_mc[name].objMain.onmousedown = function() {
					};					
				}
			}
			if (main.region0_mc.shapeType != 0) {
				var tiling_mc;
				for (var name in main.region0_mc) {
					if (name.substr(0, 6) == "tiling") {
						tiling_mc = main.region0_mc[name].objMain;
						if (main.region0_mc[tiling_mc.id].tileType == 1-main.region0_mc.rectangleSelection) {
							$("#" + tiling_mc.id).stop().animate(
								{
									opacity:main.counterAlpha/100
								}, main.fadeSpeed, 
								function() {
									
								}
							);							
						}
					}
				}
				var rTempMc = main["counterRows"+(1-main.region0_mc.rectangleSelection)+"_mc"];
				$("#" + rTempMc.id).stop().animate(
					{
						opacity:main.counterAlpha/100
					}, main.fadeSpeed, 
					function() {
						
					}
				);
				
				rTempMc = main["counterColumns"+(1-main.region0_mc.rectangleSelection)+"_mc"];
				$("#" + rTempMc.id).stop().animate(
					{
						opacity:main.counterAlpha/100
					}, main.fadeSpeed, 
					function() {
						
					}
				);				
			}
			
			doMyAreaEstimate_2();
			main.setFeedback("find area", "formula prompt", 0);
			main.input0Previous = undefined;
			main.input1Previous = undefined;
			main.formula_mc.attempt = 0;
			main.formula_mc.counterRowsCorrect = main["counterRows"+main.region0_mc.rectangleSelection+"_mc"].innerHTML;
			main.formula_mc.counterColumnsCorrect = main["counterColumns"+main.region0_mc.rectangleSelection+"_mc"].innerHTML;
			main.divCheckBtn.onclick = function() {
				if (main.processDimensions(0, main.region0_mc.rectangleSelection)) {
					main.stage03_findArea(2);
				}				
			}
			
			//document.getElementById("divOutline0_mc").style.opacity = 0;
			//document.getElementById("divOutline1_mc").style.opacity = 0;
			break;
		case 2 :
			//main.reward_mc.gotoAndPlay("reward");
			doMonkeyRewardImgSet();
			main.formula_mc.stage++;
			doMyAreaEstimate_3();
			main.input2Previous = undefined;
			main.formula_mc.attempt = 0;
			main.divCheckBtn.onclick = function() {
				if (main.processProduct(0)) {
					if (main.region0_mc.shapeType == 0) {
						//main.reward_mc.gotoAndPlay("finale");
						doMonkeyFinaleImgSet();
						//main.compareEstimate(Number(main.estimate_mc.input_mc.divInputEstimate.text), Number(main.formula_mc.input00_mc.divInputEstimate.text)*Number(main.formula_mc.input01_mc.divInputEstimate.text), (main.formula_mc.attempt<3 ? "correct" : "incorrect"));
						//main.formula_mc.gotoAndPlay("rectangleEnd");
						//Key.removeListener(main.enterKey);
					} else {
						main.stage03_findArea(3);
					}
				}
			};
			break;
		case 3 :
			//main.reward_mc.gotoAndPlay("reward");
			doMonkeyRewardImgSet();
			main.formula_mc.stage++;
			//main.formula_mc.play();
			doMyAreaEstimate_4();
			var tiling_mc;
			for (var name in main.region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					tiling_mc = main.region0_mc[name];
					if (tiling_mc.tileType == main.region0_mc.rectangleSelection) {
						$("#" + tiling_mc.objMain.id).stop().animate(
							{
								opacity:main.counterAlpha/100
							}, main.fadeSpeed, 
							function() {
								
							}
						);						
					}
				}
			}
			var tiling_mc;
			for (var name in main.region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					tiling_mc = main.region0_mc[name];
					if (tiling_mc.tileType == 1-main.region0_mc.rectangleSelection) {
						$("#" + tiling_mc.objMain.id).stop().animate(
							{
								opacity:1
							}, main.fadeSpeed, 
							function() {
								
							}
						);
					}
				}
			}
			
			var rTempMc = main["counterRows"+main.region0_mc.rectangleSelection+"_mc"];
			$("#" + rTempMc.id).stop().animate(
				{
					opacity:main.counterAlpha/100
				}, main.fadeSpeed, 
				function() {
					
				}
			);
			
			rTempMc = main["counterColumns"+main.region0_mc.rectangleSelection+"_mc"];
			$("#" + rTempMc.id).stop().animate(
				{
					opacity:main.counterAlpha/100
				}, main.fadeSpeed, 
				function() {
					
				}
			);

			rTempMc = main["counterRows"+(1-main.region0_mc.rectangleSelection)+"_mc"];
			$("#" + rTempMc.id).stop().animate(
				{
					opacity:1
				}, main.fadeSpeed, 
				function() {
					
				}
			);

			rTempMc = main["counterColumns"+(1-main.region0_mc.rectangleSelection)+"_mc"];
			$("#" + rTempMc.id).stop().animate(
				{
					opacity:1
				}, main.fadeSpeed, 
				function() {
					
				}
			);			
			
			main.setFeedback("find area", "formula prompt", 1);
			main.input0Previous = undefined;
			main.input1Previous = undefined;
			main.formula_mc.attempt = 0;
			main.formula_mc.counterRowsCorrect = main["counterRows"+(1-main.region0_mc.rectangleSelection)+"_mc"].innerHTML;
			main.formula_mc.counterColumnsCorrect = main["counterColumns"+(1-main.region0_mc.rectangleSelection)+"_mc"].innerHTML;
			main.divCheckBtn.onclick = function() {
				if (main.processDimensions(1, 1-main.region0_mc.rectangleSelection)) {
					main.stage03_findArea(4);
				}
			};
			break;
		case 4 :
			//main.reward_mc.gotoAndPlay("reward");
			doMonkeyRewardImgSet();
			main.formula_mc.stage++;
			//main.formula_mc.play();
			doMyAreaEstimate_5();
			main.input2Previous = undefined;
			main.formula_mc.attempt = 0;
			main.divCheckBtn.onclick = function() {
				if (main.processProduct(1)) {
					main.stage03_findArea(5);
				}
			};
			break;
		case 5 :
			//main.reward_mc.gotoAndPlay("reward");
			doMonkeyRewardImgSet();
			main.formula_mc.stage++;
			doMyAreaEstimate_6();
			//main.formula_mc.play();
			main.setFeedback("find area", "sum instruction", 0);
			var tiling_mc;
			for (var name in main.region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					tiling_mc = main.region0_mc[name];
					if (tiling_mc.tileType == main.region0_mc.rectangleSelection) {
						$("#" + tiling_mc.objMain.id).stop().animate(
							{
								opacity:1
							}, main.fadeSpeed, 
							function() {
								
							}
						);						
					}
				}
			}
			var rTempMc = main["counterRows"+main.region0_mc.rectangleSelection+"_mc"];
			$("#" + rTempMc.id).stop().animate(
				{
					opacity:1
				}, main.fadeSpeed, 
				function() {
					
				}
			);
			
			rTempMc = main["counterColumns"+main.region0_mc.rectangleSelection+"_mc"];
			$("#" + rTempMc.id).stop().animate(
				{
					opacity:1
				}, main.fadeSpeed, 
				function() {
					
				}
			);			
			main.formula_mc.attempt = 0;
			main.divCheckBtn.onclick = function() {
				if (main.processSum()) {
					main.stage03_findArea(6);
				}
			};
			break;
		case 6 :
			//main.reward_mc.gotoAndPlay("finale");
			doMonkeyFinaleImgSet();
			main.formula_mc.stage++;
			doMyAreaEstimate_7();
			//main.formula_mc.play();
			main.region0_mc.setCellColour(main.cellColour, true);
			var tiling_mc;
			for (var name in main.region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					tiling_mc = main.region0_mc[name];
					$("#" + tiling_mc.objMain.id).stop().animate(
						{
							opacity:0
						}, main.fadeSpeed, 
						function() {
							
						}
					);					
				}
			}
			var rTempMc = main.counterRows0_mc;
			$("#" + rTempMc.id).stop().animate(
				{
					opacity:0
				}, main.fadeSpeed, 
				function() {
					
				}
			);
			
			rTempMc = main.counterColumns0_mc;
			$("#" + rTempMc.id).stop().animate(
				{
					opacity:0
				}, main.fadeSpeed, 
				function() {
					
				}
			);

			rTempMc = main.counterRows1_mc;
			$("#" + rTempMc.id).stop().animate(
				{
					opacity:0
				}, main.fadeSpeed, 
				function() {
					
				}
			);

			rTempMc = main.counterColumns1_mc;
			$("#" + rTempMc.id).stop().animate(
				{
					opacity:0
				}, main.fadeSpeed, 
				function() {
					
				}
			);			
			main.region0_mc.setBorderColourInternal(main.borderColourLight, true);
			break;
	}
	doLoadTabIndexItems();
};

main.flyNumbers = function(formulaIndex, rectangleIndex, flySource, flyDestination) {
	var flySource_mc;
	var flySource_mc_fly;
	switch (flySource) {
		case 0 :
			flySource_mc = this["counterRows"+rectangleIndex+"_mc"];
			flySource_mc_fly = this["counterRows"+rectangleIndex+"_mc_fly"];
			break;
		case 1 :
			flySource_mc = this["counterColumns"+rectangleIndex+"_mc"];
			flySource_mc_fly = this["counterColumns"+rectangleIndex+"_mc_fly"];
			break;
	}
	flySource_mc_fly.innerHTML = flySource_mc.innerHTML;
	flySource_mc_fly.style.left = flySource_mc.style.left;
	flySource_mc_fly.style.top = flySource_mc.style.top;
	flySource_mc_fly.style.transform = "rotate(0deg)";
	flySource_mc_fly.style.display = "block";

	var flyDestination_mc;
	var rLeft, rTop;
	if (formulaIndex==0) {
		switch (flyDestination) {
			case 0:
				flyDestination_mc = main.divAreaInput_1;
				rLeft = "360px";
				rTop = "109px";
				break;
			case 1:
				flyDestination_mc = main.divAreaInput_2;
				rLeft = "415px";
				rTop = "109px";				
				break;				
			default:
				break;
		}
	} else {
		switch (flyDestination) {
			case 0:
				flyDestination_mc = main.divAreaInput_4;
				rLeft = "360px";
				rTop = "146px";				
				break;
			case 1:
				flyDestination_mc = main.divAreaInput_5;
				rLeft = "415px";
				rTop = "146px";				
				break;				
			default:
				break;
		}		
	}
	rTabingEnabled = false;
	$("#divDisablePanel").show();
	$("#" + flySource_mc_fly.id).animate(
		{
			transform:"rotate(360deg)",
			left:rLeft,
			top:rTop
		}, 2500, 
		function() {
			flyDestination_mc.value = flySource_mc_fly.innerHTML;
			flySource_mc_fly.style.display = "none";
			$("#divDisablePanel").hide();
			rTabingEnabled = true;
			
			doLoadTabIndexItems();
		}
	);
};

main.processDimensions = function(formulaIndex, rectangleIndex) {
	var proceed = false;
	var input0_mc, input1_mc;
	if (formulaIndex==0) {
		input0_mc = main.divAreaInput_1;
		input1_mc = main.divAreaInput_2;
	} else {
		input0_mc = main.divAreaInput_4;
		input1_mc = main.divAreaInput_5;		
	}
	var input0 = input0_mc.value;
	var input1 = input1_mc.value;
	if (input0 != main.input0Previous || input1 != main.input1Previous) {
		main.input0Previous = input0;
		main.input1Previous = input1;
		var counterRows_mc = main["counterRows"+rectangleIndex+"_mc"];
		var counterColumns_mc = main["counterColumns"+rectangleIndex+"_mc"];
		var counterRows = main.formula_mc.counterRowsCorrect;
		var counterColumns = main.formula_mc.counterColumnsCorrect;
		var tilingMove_mc = main["tilingMove"+rectangleIndex+"_mc"];
		var stopAnimation = function () {
			counterRows_mc.style.opacity = 1;
			counterColumns_mc.style.opacity = 1;
			counterRows_mc.innerHTML = counterRows;
			counterColumns_innerHTML = counterColumns;
			clearInterval(main.rFIFOTimer);
			main.rFIFOTimer = 0;
			//delete main.onEnterFrame;
			var tiling_mc;
			for (var name in region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					tiling_mc = region0_mc[name];
					if (tiling_mc.tileType == rectangleIndex) {
						clearInterval(window[tiling_mc.objMain.id]);
						window[tiling_mc.objMain.id] = 0;
						//delete tiling_mc.onEnterFrame;
						//tiling_mc.fade_mc.removeMovieClip();
						tiling_mc.fade_mc = undefined;
						tiling_mc.objMain.style.opacity = 1;
					}
				}
			}
		};
		if (input0 == counterRows && input1 == counterColumns || input1 == counterRows && input0 == counterColumns) {
			this.setFeedback("find area", "both correct", 0);
			stopAnimation();
			proceed = true;
		} else {
			doPlayAudio("uhoh");
			var tag;
			var index = 0;
			var replacements = [];
			var focus_mc;
			switch (true) {
				case (input0 == "" && input1 == "") :
					tag = "both missing";
					index = tilingMove_mc.dropStart-1;
					focus_mc = input0_mc;
					break;
				case (input0 == "" && input1 != "" && !(input1 == counterRows || input1 == counterColumns) || input1 == "" && input0 != "" && !(input0 == counterRows || input0 == counterColumns)) :
					tag = "one missing and one incorrect";
					index = tilingMove_mc.dropStart-1;
					focus_mc = (input0 == "" ? input1_mc : input0_mc);
					break;
				case (input0 == counterRows && input1 == "" || input0 == "" && input1 == counterRows) :
					tag = (tilingMove_mc.dropStart == 1 ? "row count correct and square count missing" : "square count correct and column count missing");
					index = Number(input1 == counterRows);
					focus_mc = (input0 == counterRows ? input1_mc : input0_mc);
					break;
				case (input0 == counterRows && input1 != counterColumns || input0 != counterColumns && input1 == counterRows) :
					tag = (tilingMove_mc.dropStart == 1 ? "row count correct and square count incorrect" : "square count correct and column count incorrect");
					replacements = [(input0 == counterRows ? input1 : input0)];
					index = Number(input1 == counterRows);
					focus_mc = (input0 == counterRows ? input1_mc : input0_mc);
					break;
				case (input0 == counterColumns && input1 == "" || input0 == "" && input1 == counterColumns) :
					tag = (tilingMove_mc.dropStart == 2 ? "column count correct and square count missing" : "square count correct and row count missing");
					index = Number(input1 == counterColumns);
					focus_mc = (input0 == counterColumns ? input1_mc : input0_mc);
					break;
				case (input0 == counterColumns && input1 != counterRows || input0 != counterRows && input1 == counterColumns) :
					tag = (tilingMove_mc.dropStart == 2 ? "column count correct and square count incorrect" : "square count correct and row count incorrect");
					replacements = [(input0 == counterColumns ? input1 : input0)];
					index = Number(input1 == counterColumns);
					focus_mc = (input0 == counterColumns ? input1_mc : input0_mc);
					break;
				default :
					tag = "both incorrect";
					index = tilingMove_mc.dropStart-1;
					focus_mc = input0_mc;
					break;
			}
			//delete input0_mc.onEnterFrame;
			//delete input1_mc.onEnterFrame;
			//delete input0_mc.input_txt.onSetFocus;
			//delete input1_mc.input_txt.onSetFocus;
			//Selection.setFocus(focus_mc.input_txt);
			focus_mc.focus();
			main.formula_mc.attempt++;
			switch (main.formula_mc.attempt) {
				case 1 :
					main.setFeedback("find area", tag, index, replacements);
					break;
				case 2 :
					main.setFeedback("find area", "rebuild covering", tilingMove_mc.dropStart-1);
					main.step = 1;
					main.rectangleIndex = rectangleIndex;
					clearInterval(main.rFIFOTimer);
					main.rFIFOTimer = 0;
					main.rFIFOTimer = setInterval("doFIFO()", 1000/24);
					break;
				case 3 :
					stopAnimation();
					this.setFeedback("find area", "complete formula", tilingMove_mc.dropStart-1, (tilingMove_mc.dropStart == 1 ? [counterColumns_mc.innerHTML, counterRows_mc.innerHTML] : [counterRows_mc.innerHTML, counterColumns_mc.innerHTML]));
					switch (true) {
						case (input0 == counterRows && input1 != counterColumns) :
							main.flyNumbers(formulaIndex, rectangleIndex, 1, 1);
							break;
						case (input1 == counterRows && input0 != counterColumns) :
							main.flyNumbers(formulaIndex, rectangleIndex, 1, 0);
							break;
						case (input0 == counterColumns && input1 != counterRows) :
							main.flyNumbers(formulaIndex, rectangleIndex, 0, 1);
							break;
						case (input1 == counterColumns && input0 == "") :
							main.flyNumbers(formulaIndex, rectangleIndex, 0, 0);
							break;
						default :
							main.flyNumbers(formulaIndex, rectangleIndex, 0, 0);
							main.flyNumbers(formulaIndex, rectangleIndex, 1, 1);
							break;
					}
					proceed = true;
					break;
			}
		}
	}
	
	doLoadTabIndexItems();
	return proceed;
};

main.processProduct = function(formulaIndex) {
	var proceed = false;
	var input0_mc, input1_mc, input2_mc;
	if (formulaIndex==0) {
		input0_mc = main.divAreaInput_1;
		input1_mc = main.divAreaInput_2;
		input2_mc = main.divAreaInput_3;
	} else {
		input0_mc = main.divAreaInput_4;
		input1_mc = main.divAreaInput_5;
		input2_mc = main.divAreaInput_6;
	}
	var input0 = input0_mc.value;
	var input1 = input1_mc.value;
	var input2 = input2_mc.value;
	
	var flySource_mc = document.getElementById("n" + Math.pad(Number(input0), 2) + Math.pad(Number(input1), 2) + "_mc");
	if (input2 != main.input2Previous) {
		main.input2Previous = input2;
		if (input2 == input0*input1) {
			document.getElementById(flySource_mc.id).style.color = "#000000";
			$("#divTimesTablePanel").stop().animate(
				{
					'opacity': 0
				}, main.fadeSpeed,
				function(){
					$("#divTimesTablePanel").hide();
				}
			);
			proceed = true;
		} else {
			doPlayAudio("uhoh");
			input2_mc.focus();
			main.formula_mc.attempt++;
			switch (main.formula_mc.attempt) {
				case 1 :
					main.setFeedback("find area", "product "+(input2 == "" ? "missing" : "incorrect"), 0);
					break;
				case 2 :
					rTabingEnabled = false;
					$("#divDisablePanel").show();
					$("#divTimesTablePanel").css("opacity", 1);
					$("#divTimesTablePanel").show();
					main.setFeedback("find area", "product incorrect", 1);
					$("#divTimesTablePanel").stop().animate(
						{
							'opacity': 1
						}, main.fadeSpeed
					);
					$("#bar0_mc").css('top', '-1px');
					$("#bar1_mc").css('left', '2px');
					$("#bar0_mc").stop().animate(
						{
							'top': (input0 * 24) + 'px',
						}, 1000,
						function(){
							$("#divDisablePanel").hide();
							rTabingEnabled = true;
						}
					);
					$("#bar1_mc").stop().animate(
						{
							'left': (input1 * 33) + 'px',
						}, 1000
					);
					document.getElementById(flySource_mc.id).style.color = "#ff0000";
					break;
				case 3 :
					$("#divTimesTablePanel").css("opacity", 1);
					$("#divTimesTablePanel").show();
					var flyDestination_mc;
					flyDestination_mc = formulaIndex;
					
					$("#flyValueTxt").css("opacity", 1);
					$("#flyValueTxt").show();
					var rTempCurValueX = Number(document.getElementById(flySource_mc.id).style.left.split("px")[0]) + 273;
					var rTempCurValueY = Number(document.getElementById(flySource_mc.id).style.top.split("px")[0]) + 234;
					
					document.getElementById("flyValueTxt").innerHTML = document.getElementById("n"+Math.pad(Number(input0), 2)+Math.pad(Number(input1), 2)+"_mc").innerHTML;
					
					$("#flyValueTxt").css("left", rTempCurValueX + "px");
					$("#flyValueTxt").css("top", rTempCurValueY + "px");
					$("#flyValueTxt").css("color", "#000000");

					$("#flyValueTxt").css("transform", "rotate(0deg) scale(0.6)");
					
					document.getElementById(flySource_mc.id).style.color = "#000000";
					rTabingEnabled = false;
					$("#divDisablePanel").show();
					if(formulaIndex==0){
						$("#flyValueTxt").stop().animate(
							{
								'left': '474px',
								'top': rAreaAOutputFieldX + 'px',
								transform:"{rotate(360deg), scale(1)}"
							}, main.flySpeed + 1000,
							function(){
								input2_mc.value = flySource_mc.innerHTML;
								$("#divTimesTablePanel").stop().animate(
									{
										'opacity': 0
									}, main.fadeSpeed,
									function(){
										$("#divTimesTablePanel").hide();
										$("#divDisablePanel").hide();
										rTabingEnabled = true;
									}
								);
								$("#flyValueTxt").hide();
							}
						);
					}else{
						$("#flyValueTxt").stop().animate(
							{
								'left': '474px',
								'top': rAreaBOutputFieldX + 'px',
								transform:"rotate(360deg) scale(1)"
							}, main.flySpeed + 1000,
							function(){
								input2_mc.value = flySource_mc.innerHTML;
								$("#divTimesTablePanel").stop().animate(
									{
										'opacity': 0
									}, main.fadeSpeed,
									function(){
										$("#divTimesTablePanel").hide();
										$("#divDisablePanel").hide();
										rTabingEnabled = true;
									}
								);
								$("#flyValueTxt").hide();
							}
						);
					}
					proceed = true;
					break;
			}
		}
	}
	
	doLoadTabIndexItems();
	return proceed;
};

main.processSum = function() {
	if (Number(main.divAreaInput_7.value) == Number(main.divAreaInput_3.value)+Number(main.divAreaInput_6.value)) {
		main.compareEstimate(Number(main.divInputEstimate.value), Number(main.divAreaInput_7.value), "correct");
		SendLogToServer("game_completed", 0, 0, "game_completed");
		return true;
	} else {
		doPlayAudio("uhoh");
		if (Number(main.divAreaInput_7.value) != Number(main.formula_mc.input2Previous)) {
			main.formula_mc.input2Previous = Number(main.divAreaInput_7.value);
			main.formula_mc.attempt++;
			var tag = (main.formula_mc.attempt == 1 ? (main.divAreaInput_7.value == "" ? "missing" : "incorrect") : "incorrect")+" sum";
			if (main.formula_mc.attempt<3) {
				main.setFeedback("find area", tag, main.formula_mc.attempt-1, [Number(main.divAreaInput_3.value)+Number(main.divAreaInput_6.value)]);
				main.divAreaInput_7.focus();
				return false;
			} else {
				main.divAreaInput_7.value = Number(main.divAreaInput_3.value)+Number(main.divAreaInput_6.value);
				main.compareEstimate(Number(main.divInputEstimate.value), Number(main.divAreaInput_7.value), "incorrect");
				return true;
			}
		}
	}
	
	doLoadTabIndexItems();
};

main.tileRectangle = function(rectangleIndex, step) {
	switch (main["tilingMove"+rectangleIndex+"_mc"].dropStart) {
		case 1 :
			counter0_mc = main["counterColumns"+rectangleIndex+"_mc"];
			counter1_mc = main["counterRows"+rectangleIndex+"_mc"];
			break;
		case 2 :
			counter0_mc = main["counterRows"+rectangleIndex+"_mc"];
			counter1_mc = main["counterColumns"+rectangleIndex+"_mc"];
			break;
	}
	switch (step) {
		case 1 :
			counter0_mc.innerHTML = 0;
			counter1_mc.fade_mc = "fade_mc";
			$("#" + counter1_mc.id).stop().animate(
				{
					opacity:0
				}, main.fadeSpeed, 
				function() {
				}
			);			
			var tiling_mc;
			for (var name in main.region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					tiling_mc = main.region0_mc[name];
					if (tiling_mc.tileType == rectangleIndex) {
						$("#" + tiling_mc.objMain.id).stop().animate(
							{
								opacity:main.counterAlpha/100
							}, main.fadeSpeed, 
							function() {
								counter1_mc.fade_mc = "";
							}
						);						
					}
				}
			}
			return step+1;
			break;
		case 2 :
			if (counter1_mc.fade_mc == "") {
				return step+1;
			} else {
				return step+0;
			}
			break;
		case 3 :
			var tiling_arr = new Array();
			var tiling_mc;
			for (var name in main.region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					tiling_mc = main.region0_mc[name];
					if (tiling_mc.tileType == rectangleIndex && tiling_mc.getArea() == 1) {
						tiling_arr.push(name);
					}
				}
			}
			//tiling_arr.sort();
			rFIFOIndex = 0;
			rFIFOTilingDone = false;
			rArrTiling.length = 0;
			for (var i=0; i<tiling_arr.length; i++) {
				rArrTiling.push(tiling_arr[i]);
			}
			//rArrTiling = tiling_arr;
			//rArrTiling.sort(function(a, b){return a-b});
			for (var j = 0; j<tiling_arr.length; j++) {
				var name = tiling_arr[j];
				tiling_mc = main.region0_mc[name];
				tiling_mc.counter_mc = counter0_mc;
				tiling_mc.onEnterFrame = "onEnterFrame";
				tiling_mc.fade_mc = {};
				tiling_mc.fade_mc.onEnterFrame = "onEnterFrame";
			}
			doFIFOTiling();
			return step+1;
			break;
		case 4 :
			var proceed = true;
			/*
			for (var name in main.region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					tiling_mc = main.region0_mc[name];
					if (tiling_mc.tileType == rectangleIndex && tiling_mc.getArea() == 1) {
						if(proceed && tiling_mc.onEnterFrame == undefined && tiling_mc.fade_mc == undefined) {
							proceed = true;
						} else {
							proceed = false;
						}
					}
				}
			}
			*/
			if (rFIFOTilingDone) {
				proceed = true;
			} else {
				proceed = false;;
			}
			
			if (proceed) {
				return step+1;
			} else {
				return step+0;
			}
			break;
		case 5 :
			doLoadTabIndexItems();		
			//counter0_mc.pulse(2, 3, 20, true);
			/*
			rCounter0Mc = counter0_mc;
			rCounter0McId = counter0_mc.id
			rPulseObjId = rCounter0McId;
			rPulseCount = 0;
			doPulseAni();
			*/
			counter0_mc.pulse_mc = "";
			return step+1;
			break;
		case 6 :
			if (counter0_mc.pulse_mc == "") {
				return step+1;
			} else {
				return step+0;
			}
			//return step+Number(counter0_mc.pulse_mc == undefined);
			//return step+1;
			break;
		case 7 :
			$("#" + counter1_mc.id).stop().animate(
				{
					opacity:1
				}, main.fadeSpeed, 
				function() {
					
				}
			);
			counter1_mc.innerHTML = 0;
			for (var name in main.region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					if (main.region0_mc[name].tileType == rectangleIndex) {
						tiling_mc = main.region0_mc[name];
						$("#" + tiling_mc.objMain.id).stop().animate(
							{
								opacity:main.counterAlpha/100
							}, main.fadeSpeed, 
							function() {
								counter1_mc.fade_mc = "";
							}
						);						
					}
				}
			}
			return step+1;
			break;
		case 8 :
			if (counter1_mc.fade_mc == "") {
				return step+1;
			} else {
				return step+0;
			}
			//return step+Number(counter1_mc.fade_mc == undefined);
			break;
		case 9 :
			var tiling_mc;
			var tiling_arr = new Array();
			for (var name in this.region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					tiling_mc = this.region0_mc[name];
					if (tiling_mc.tileType == rectangleIndex) {
						if (tiling_mc.getArea() == 1) {
							$("#" + tiling_mc.objMain.id).stop().animate(
								{
									opacity:1
								}, main.fadeSpeed, 
								function() {
								}
							);							
						} else {
							tiling_arr.push(name);
						}
					}
				}
			}
			counter1_mc.innerHTML = Number(counter1_mc.innerHTML)+1;
			//tiling_arr.sort();
			rFIFOIndex = 0;
			rFIFOTilingDone = false;
			rArrTiling.length = 0;
			for (var i=0; i<tiling_arr.length; i++) {
				rArrTiling.push(tiling_arr[i]);
			}			
			//rArrTiling = tiling_arr;
			//rArrTiling.sort(function(a, b){return a-b});
			for (var j = 0; j<tiling_arr.length; j++) {
				var name = tiling_arr[j];
				tiling_mc = main.region0_mc[name];
				tiling_mc.counter_mc = counter1_mc;
				tiling_mc.onEnterFrame = "onEnterFrame";
				tiling_mc.fade_mc = {};
				tiling_mc.fade_mc.onEnterFrame = "onEnterFrame";		
			}
			doFIFOTiling();			
			/*
			for (var j = 0; j<tiling_arr.length; j++) {
				name = tiling_arr[j];
				tiling_mc = this.region0_mc[name];
				tiling_mc.fadeStart = t+dt*i++;
				tiling_mc.counter_mc = counter1_mc;
				tiling_mc.onEnterFrame = function() {
					if (getTimer()>this.fadeStart) {
						this.fade(100, main.fadeSpeed);
						this.onEnterFrame = function() {
							if (this.fade_mc != undefined) {
								this.counter_mc.counter_txt.text++;
								delete this.onEnterFrame;
							}
						};
					}
				};
			}
			*/
			return step+1;
			break;
		case 10 :
			var proceed = true;
			/*
			for (var name in main.region0_mc) {
				if (name.substr(0, 6) == "tiling") {
					tiling_mc = main.region0_mc[name];
					if (tiling_mc.tileType == rectangleIndex) {
						if(proceed && tiling_mc.onEnterFrame == undefined && tiling_mc.fade_mc == undefined) {
							proceed = true;
						} else {
							proceed = false;
						}
					}					
				}
			}
			*/
			if (rFIFOTilingDone) {
				proceed = true;
				$("#divDisablePanel").hide();
				doLoadTabIndexItems();
			} else {
				proceed = false;;
			}
			if (proceed) {
				return step+1;
			} else {
				return step+0;
			}			
			break;
		case 11 :
			//counter1_mc.pulse(2, 3, 20, true);
			/*
			rCounter1Mc = counter1_mc;
			rCounter1McId = counter1_mc.id
			rPulseObjId = rCounter1McId;
			rPulseCount = 0;
			doPulseAni();
			*/
			counter1_mc.pulse_mc = "";
			return step+1;
			break;
		case 12 :
			if (counter1_mc.pulse_mc == "") {
				return step;
			} else {
				return 0;
			}
			//return (counter1_mc.pulse_mc == undefined ? step : 0);
			break;
	}
	
	doLoadTabIndexItems();
};

function doPlayAudio(rFileName) {
	rAudioLastPlayed = rFileName;
	document.getElementById('audPlayer').src = rAudioBasePath + rFileName + ".mp3";
	document.getElementById('audPlayer').play();
}

function doPauseAudio() {
	document.getElementById('audPlayer').pause();
}

function doRePlayAudio() {
	document.getElementById('audPlayer').src = rAudioBasePath + rAudioLastPlayed + ".mp3";
	document.getElementById('audPlayer').play();
}

function hexToR(h) {return parseInt((cutHex(h)).substring(0,2),16)}
function hexToG(h) {return parseInt((cutHex(h)).substring(2,4),16)}
function hexToB(h) {return parseInt((cutHex(h)).substring(4,6),16)}
function cutHex(h) {return (h.charAt(0)=="#") ? h.substring(1,7):h}

var specialKeys = new Array();
specialKeys.push(8);//Bakcspace
specialKeys.push(9);//Tab
specialKeys.push(35);//Home
specialKeys.push(36);//End
specialKeys.push(37);//Left
specialKeys.push(38);//Up
specialKeys.push(39);//Right
specialKeys.push(40);//Down
function IsNumeric(e) {
	var keyCode = e.which ? e.which : e.keyCode;
	var ret = ((keyCode >= 48 && keyCode <= 57) || specialKeys.indexOf(keyCode) != -1);
	return ret;
}