/*!
 * CreateJS
 * Visit http://createjs.com/ for documentation, updates and examples.
 *
 * Copyright (c) 2010 gskinner.com, inc.
 * Maintained by ZIM - 2021 - https://zimjs.com
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
var createjs = createjs || {};
createjs.stageTransformable = !0;
createjs.willReadFrequently = !0;
createjs.extend = function(n, t) {
    "use strict";

    function i() {
        this.constructor = n
    }
    return i.prototype = t.prototype, n.prototype = new i
};
createjs.promote = function(n, t) {
    "use strict";
    var i = n.prototype,
        r = Object.getPrototypeOf && Object.getPrototypeOf(i) || i.__proto__,
        u;
    if (r)
        for (u in i[(t += "_") + "constructor"] = r.constructor, r) i.hasOwnProperty(u) && "function" == typeof r[u] && (i[t + u] = r[u]);
    return n
};
createjs.indexOf = function(n, t) {
        "use strict";
        for (var i = 0, r = n.length; i < r; i++)
            if (t === n[i]) return i;
        return -1
    },
    function() {
        "use strict";

        function n() {
            throw "UID cannot be instantiated";
        }
        n._nextID = 0;
        n.get = function() {
            return n._nextID++
        };
        createjs.UID = n
    }();
createjs.deprecate = function(n, t) {
        "use strict";
        return function() {
            var i = "Deprecated property or method '" + t + "'. See docs for info.";
            return console && (console.warn ? console.warn(i) : console.log(i)), n && n.apply(this, arguments)
        }
    },
    function() {
        "use strict";

        function t(n, t, i) {
            this.type = n;
            this.target = null;
            this.currentTarget = null;
            this.eventPhase = 0;
            this.bubbles = !!t;
            this.cancelable = !!i;
            this.timeStamp = (new Date).getTime();
            this.defaultPrevented = !1;
            this.propagationStopped = !1;
            this.immediatePropagationStopped = !1;
            this.removed = !1
        }
        var n = t.prototype;
        n.preventDefault = function() {
            this.defaultPrevented = this.cancelable && !0
        };
        n.stopPropagation = function() {
            this.propagationStopped = !0
        };
        n.stopImmediatePropagation = function() {
            this.immediatePropagationStopped = this.propagationStopped = !0
        };
        n.remove = function() {
            this.removed = !0
        };
        n.clone = function() {
            return new t(this.type, this.bubbles, this.cancelable)
        };
        n.set = function(n) {
            for (var t in n) this[t] = n[t];
            return this
        };
        n.toString = function() {
            return "[Event (type=" + this.type + ")]"
        };
        createjs.Event = t
    }(),
    function() {
        "use strict";

        function t() {
            this._listeners = null;
            this._captureListeners = null
        }
        var n = t.prototype;
        t.initialize = function(t) {
            t.addEventListener = n.addEventListener;
            t.on = n.on;
            t.removeEventListener = t.off = n.removeEventListener;
            t.removeAllEventListeners = n.removeAllEventListeners;
            t.hasEventListener = n.hasEventListener;
            t.dispatchEvent = n.dispatchEvent;
            t._dispatchEvent = n._dispatchEvent;
            t.willTrigger = n.willTrigger
        };
        n.addEventListener = function(n, t, i) {
            var r = i ? this._captureListeners = this._captureListeners || {} : this._listeners = this._listeners || {},
                u = r[n];
            return u && this.removeEventListener(n, t, i), (u = r[n]) ? u.push(t) : r[n] = [t], t
        };
        n.on = function(n, t, i, r, u, f) {
            return t.handleEvent && (i = i || t, t = t.handleEvent), i = i || this, this.addEventListener(n, function(n) {
                t.call(i, n, u);
                r && n.remove()
            }, f)
        };
        n.removeEventListener = function(n, t, i) {
            var f = i ? this._captureListeners : this._listeners,
                r, u, e;
            if (f && (r = f[n], r))
                for (u = 0, e = r.length; u < e; u++)
                    if (r[u] == t) {
                        1 == e ? delete f[n] : r.splice(u, 1);
                        break
                    }
        };
        n.off = n.removeEventListener;
        n.removeAllEventListeners = function(n) {
            n ? (this._listeners && delete this._listeners[n], this._captureListeners && delete this._captureListeners[n]) : this._listeners = this._captureListeners = null
        };
        n.dispatchEvent = function(n, t, i) {
            var e, u, f, o, r;
            if ("string" == typeof n) {
                if (e = this._listeners, !(t || e && e[n])) return !0;
                n = new createjs.Event(n, t, i)
            } else n.target && n.clone && (n = n.clone());
            try {
                n.target = this
            } catch (n) {}
            if (n.bubbles && this.parent) {
                for (u = this, f = [u]; u.parent;) f.push(u = u.parent);
                for (o = f.length, r = o - 1; 0 <= r && !n.propagationStopped; r--) f[r]._dispatchEvent(n, 1 + (0 == r));
                for (r = 1; r < o && !n.propagationStopped; r++) f[r]._dispatchEvent(n, 3)
            } else this._dispatchEvent(n, 2);
            return !n.defaultPrevented
        };
        n.hasEventListener = function(n) {
            var t = this._listeners,
                i = this._captureListeners;
            return !!(t && t[n] || i && i[n])
        };
        n.willTrigger = function(n) {
            for (var t = this; t;) {
                if (t.hasEventListener(n)) return !0;
                t = t.parent
            }
            return !1
        };
        n.toString = function() {
            return "[EventDispatcher]"
        };
        n._dispatchEvent = function(n, t) {
            var f, i, e = t <= 2 ? this._captureListeners : this._listeners,
                u, r;
            if (n && e && (i = e[n.type]) && (f = i.length)) {
                try {
                    n.currentTarget = this
                } catch (n) {}
                try {
                    n.eventPhase = 0 | t
                } catch (n) {}
                for (n.removed = !1, i = i.slice(), u = 0; u < f && !n.immediatePropagationStopped; u++) r = i[u], r.handleEvent ? r.handleEvent(n) : r(n), n.removed && (this.off(n.type, r, 1 == t), n.removed = !1)
            }
            2 === t && this._dispatchEvent(n, 2.1)
        };
        createjs.EventDispatcher = t
    }(),
    function() {
        "use strict";

        function n() {
            throw "Ticker cannot be instantiated.";
        }
        n.RAF_SYNCHED = "synched";
        n.RAF = "raf";
        n.TIMEOUT = "timeout";
        n.timingMode = null;
        n.maxDelta = 0;
        n.paused = !1;
        n.removeEventListener = null;
        n.removeAllEventListeners = null;
        n.dispatchEvent = null;
        n.hasEventListener = null;
        n._listeners = null;
        createjs.EventDispatcher.initialize(n);
        n._addEventListener = n.addEventListener;
        n.addEventListener = function() {
            return n._inited || n.init(), n._addEventListener.apply(n, arguments)
        };
        n._inited = !1;
        n._startTime = 0;
        n._pausedTime = 0;
        n._ticks = 0;
        n._pausedTicks = 0;
        n._interval = 50;
        n._lastTime = 0;
        n._times = null;
        n._tickTimes = null;
        n._timerId = null;
        n._raf = !0;
        n._setInterval = function(t) {
            n._interval = t;
            n._inited && n._setupTick()
        };
        n.setInterval = createjs.deprecate(n._setInterval, "Ticker.setInterval");
        n._getInterval = function() {
            return n._interval
        };
        n.getInterval = createjs.deprecate(n._getInterval, "Ticker.getInterval");
        n._setFPS = function(t) {
            n._setInterval(1e3 / t)
        };
        n.setFPS = createjs.deprecate(n._setFPS, "Ticker.setFPS");
        n._getFPS = function() {
            return 1e3 / n._interval
        };
        n.getFPS = createjs.deprecate(n._getFPS, "Ticker.getFPS");
        try {
            Object.defineProperties(n, {
                interval: {
                    get: n._getInterval,
                    set: n._setInterval
                },
                framerate: {
                    get: n._getFPS,
                    set: n._setFPS
                }
            })
        } catch (t) {
            console.log(t)
        }
        n.init = function() {
            n._inited || (n._inited = !0, n._times = [], n._tickTimes = [], n._startTime = n._getTime(), n._times.push(n._lastTime = 0), n.interval = n._interval)
        };
        n.reset = function() {
            var t;
            n._raf ? (t = window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || window.oCancelAnimationFrame || window.msCancelAnimationFrame) && t(n._timerId) : clearTimeout(n._timerId);
            n.removeAllEventListeners("tick");
            n._timerId = n._times = n._tickTimes = null;
            n._startTime = n._lastTime = n._ticks = n._pausedTime = 0;
            n._inited = !1
        };
        n.getMeasuredTickTime = function(t) {
            var u = 0,
                i = n._tickTimes,
                r;
            if (!i || i.length < 1) return -1;
            for (t = Math.min(i.length, t || 0 | n._getFPS()), r = 0; r < t; r++) u += i[r];
            return u / t
        };
        n.getMeasuredFPS = function(t) {
            var i = n._times;
            return !i || i.length < 2 ? -1 : (t = Math.min(i.length - 1, t || 0 | n._getFPS()), 1e3 / ((i[0] - i[t]) / t))
        };
        n.getTime = function(t) {
            return n._startTime ? n._getTime() - (t ? n._pausedTime : 0) : -1
        };
        n.getEventTime = function(t) {
            return n._startTime ? (n._lastTime || n._startTime) - (t ? n._pausedTime : 0) : -1
        };
        n.getTicks = function(t) {
            return n._ticks - (t ? n._pausedTicks : 0)
        };
        n._handleSynch = function() {
            n._timerId = null;
            n._setupTick();
            n._getTime() - n._lastTime >= .97 * (n._interval - 1) && n._tick()
        };
        n._handleRAF = function() {
            n._timerId = null;
            n._setupTick();
            n._tick()
        };
        n._handleTimeout = function() {
            n._timerId = null;
            n._setupTick();
            n._tick()
        };
        n._setupTick = function() {
            var t, i;
            if (null == n._timerId) {
                if (t = n.timingMode, (t == n.RAF_SYNCHED || t == n.RAF) && (i = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame, i)) return n._timerId = i(t == n.RAF ? n._handleRAF : n._handleSynch), void(n._raf = !0);
                n._raf = !1;
                n._timerId = setTimeout(n._handleTimeout, n._interval)
            }
        };
        n._tick = function() {
            var t, r, f = n.paused,
                i = n._getTime(),
                u = i - n._lastTime;
            for (n._lastTime = i, n._ticks++, f && (n._pausedTicks++, n._pausedTime += u), n.hasEventListener("tick") && (t = new createjs.Event("tick"), r = n.maxDelta, t.delta = r && r < u ? r : u, t.paused = f, t.time = i, t.runTime = i - n._pausedTime, n.dispatchEvent(t)), n._tickTimes.unshift(n._getTime() - i); 100 < n._tickTimes.length;) n._tickTimes.pop();
            for (n._times.unshift(i); 100 < n._times.length;) n._times.pop()
        };
        var t = window,
            i = t.performance.now || t.performance.mozNow || t.performance.msNow || t.performance.oNow || t.performance.webkitNow;
        n._getTime = function() {
            return (i && i.call(t.performance) || (new Date).getTime()) - n._startTime
        };
        createjs.Ticker = n
    }(),
    function() {
        "use strict";

        function n(n) {
            this.readyState = n.readyState;
            this._video = n;
            this._canvas = null;
            this._lastTime = -1;
            this.readyState < 2 && n.addEventListener("canplaythrough", this._videoReady.bind(this))
        }
        var t = n.prototype;
        t.getImage = function() {
            if (!(this.readyState < 2)) {
                var i, n = this._canvas,
                    t = this._video;
                return n || ((n = this._canvas = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas")).width = t.videoWidth, n.height = t.videoHeight), 2 <= t.readyState && t.currentTime !== this._lastTime && ((i = n.getContext("2d")).clearRect(0, 0, n.width, n.height), i.drawImage(t, 0, 0, n.width, n.height), this._lastTime = t.currentTime), n
            }
        };
        t._videoReady = function() {
            this.readyState = 2
        };
        createjs.VideoBuffer = n
    }(),
    function() {
        "use strict";

        function t(n, t, i, r, u, f, e, o, s, h, c) {
            this.Event_constructor(n, t, i);
            this.stageX = r;
            this.stageY = u;
            this.rawX = null == s ? r : s;
            this.rawY = null == h ? u : h;
            this.nativeEvent = f;
            this.pointerID = e;
            this.primary = !!o;
            this.relatedTarget = c
        }
        var n = createjs.extend(t, createjs.Event);
        n._get_localX = function() {
            return this.currentTarget.globalToLocal(this.rawX, this.rawY).x
        };
        n._get_localY = function() {
            return this.currentTarget.globalToLocal(this.rawX, this.rawY).y
        };
        n._get_isTouch = function() {
            return -1 !== this.pointerID
        };
        try {
            Object.defineProperties(n, {
                localX: {
                    get: n._get_localX
                },
                localY: {
                    get: n._get_localY
                },
                isTouch: {
                    get: n._get_isTouch
                }
            })
        } catch (t) {}
        n.clone = function() {
            return new t(this.type, this.bubbles, this.cancelable, this.stageX, this.stageY, this.nativeEvent, this.pointerID, this.primary, this.rawX, this.rawY)
        };
        n.toString = function() {
            return "[MouseEvent (type=" + this.type + " stageX=" + this.stageX + " stageY=" + this.stageY + ")]"
        };
        createjs.MouseEvent = createjs.promote(t, "Event")
    }(),
    function() {
        "use strict";

        function t(n, t, i, r, u, f) {
            this.setValues(n, t, i, r, u, f)
        }
        var n = t.prototype;
        t.DEG_TO_RAD = Math.PI / 180;
        t.identity = null;
        n.setValues = function(n, t, i, r, u, f) {
            return this.a = null == n ? 1 : n, this.b = t || 0, this.c = i || 0, this.d = null == r ? 1 : r, this.tx = u || 0, this.ty = f || 0, this
        };
        n.append = function(n, t, i, r, u, f) {
            var e = this.a,
                o = this.b,
                s = this.c,
                h = this.d;
            return 1 == n && 0 == t && 0 == i && 1 == r || (this.a = e * n + s * t, this.b = o * n + h * t, this.c = e * i + s * r, this.d = o * i + h * r), this.tx = e * u + s * f + this.tx, this.ty = o * u + h * f + this.ty, this
        };
        n.prepend = function(n, t, i, r, u, f) {
            var e = this.a,
                o = this.c,
                s = this.tx;
            return this.a = n * e + i * this.b, this.b = t * e + r * this.b, this.c = n * o + i * this.d, this.d = t * o + r * this.d, this.tx = n * s + i * this.ty + u, this.ty = t * s + r * this.ty + f, this
        };
        n.appendMatrix = function(n) {
            return this.append(n.a, n.b, n.c, n.d, n.tx, n.ty)
        };
        n.prependMatrix = function(n) {
            return this.prepend(n.a, n.b, n.c, n.d, n.tx, n.ty)
        };
        n.appendTransform = function(n, i, r, u, f, e, o, s, h) {
            var l, c = f % 360 ? (c = f * t.DEG_TO_RAD, l = Math.cos(c), Math.sin(c)) : (l = 1, 0);
            return e || o ? (e *= t.DEG_TO_RAD, o *= t.DEG_TO_RAD, this.append(Math.cos(o), Math.sin(o), -Math.sin(e), Math.cos(e), n, i), this.append(l * r, c * r, -c * u, l * u, 0, 0)) : this.append(l * r, c * r, -c * u, l * u, n, i), (s || h) && (this.tx -= s * this.a + h * this.c, this.ty -= s * this.b + h * this.d), this
        };
        n.prependTransform = function(n, i, r, u, f, e, o, s, h) {
            var l, c = f % 360 ? (c = f * t.DEG_TO_RAD, l = Math.cos(c), Math.sin(c)) : (l = 1, 0);
            return (s || h) && (this.tx -= s, this.ty -= h), e || o ? (e *= t.DEG_TO_RAD, o *= t.DEG_TO_RAD, this.prepend(l * r, c * r, -c * u, l * u, 0, 0), this.prepend(Math.cos(o), Math.sin(o), -Math.sin(e), Math.cos(e), n, i)) : this.prepend(l * r, c * r, -c * u, l * u, n, i), this
        };
        n.rotate = function(n) {
            n *= t.DEG_TO_RAD;
            var i = Math.cos(n),
                r = Math.sin(n),
                u = this.a,
                n = this.b;
            return this.a = u * i + this.c * r, this.b = n * i + this.d * r, this.c = -u * r + this.c * i, this.d = -n * r + this.d * i, this
        };
        n.skew = function(n, i) {
            return n *= t.DEG_TO_RAD, i *= t.DEG_TO_RAD, this.append(Math.cos(i), Math.sin(i), -Math.sin(n), Math.cos(n), 0, 0), this
        };
        n.scale = function(n, t) {
            return this.a *= n, this.b *= n, this.c *= t, this.d *= t, this
        };
        n.translate = function(n, t) {
            return this.tx += this.a * n + this.c * t, this.ty += this.b * n + this.d * t, this
        };
        n.identity = function() {
            return this.a = this.d = 1, this.b = this.c = this.tx = this.ty = 0, this
        };
        n.invert = function() {
            var t = this.a,
                i = this.b,
                r = this.c,
                u = this.d,
                f = this.tx,
                n = t * u - i * r;
            return this.a = u / n, this.b = -i / n, this.c = -r / n, this.d = t / n, this.tx = (r * this.ty - u * f) / n, this.ty = -(t * this.ty - i * f) / n, this
        };
        n.isIdentity = function() {
            return 0 === this.tx && 0 === this.ty && 1 === this.a && 0 === this.b && 0 === this.c && 1 === this.d
        };
        n.equals = function(n) {
            return this.tx === n.tx && this.ty === n.ty && this.a === n.a && this.b === n.b && this.c === n.c && this.d === n.d
        };
        n.transformPoint = function(n, t, i) {
            return (i = i || {}).x = n * this.a + t * this.c + this.tx, i.y = n * this.b + t * this.d + this.ty, i
        };
        n.decompose = function(n) {
            null == n && (n = {});
            n.x = this.tx;
            n.y = this.ty;
            n.scaleX = Math.sqrt(this.a * this.a + this.b * this.b);
            n.scaleY = Math.sqrt(this.c * this.c + this.d * this.d);
            var r = Math.atan2(-this.c, this.d),
                i = Math.atan2(this.b, this.a);
            return Math.abs(1 - r / i) < 1e-5 ? (n.rotation = i / t.DEG_TO_RAD, this.a < 0 && 0 <= this.d && (n.rotation += n.rotation <= 0 ? 180 : -180), n.skewX = n.skewY = 0) : (n.skewX = r / t.DEG_TO_RAD, n.skewY = i / t.DEG_TO_RAD), n
        };
        n.copy = function(n) {
            return this.setValues(n.a, n.b, n.c, n.d, n.tx, n.ty)
        };
        n.clone = function() {
            return new t(this.a, this.b, this.c, this.d, this.tx, this.ty)
        };
        n.toString = function() {
            return "[Matrix2D (a=" + this.a + " b=" + this.b + " c=" + this.c + " d=" + this.d + " tx=" + this.tx + " ty=" + this.ty + ")]"
        };
        t.identity = new t;
        createjs.Matrix2D = t
    }(),
    function() {
        "use strict";

        function t(n, t, i, r, u) {
            this.setValues(n, t, i, r, u)
        }
        var n = t.prototype;
        n.setValues = function(n, t, i, r, u) {
            return this.visible = null == n || !!n, this.alpha = null == t ? 1 : t, this.shadow = i, this.compositeOperation = r, this.matrix = u || this.matrix && this.matrix.identity() || new createjs.Matrix2D, this
        };
        n.append = function(n, t, i, r, u) {
            return this.alpha *= t, this.shadow = i || this.shadow, this.compositeOperation = r || this.compositeOperation, this.visible = this.visible && n, u && this.matrix.appendMatrix(u), this
        };
        n.prepend = function(n, t, i, r, u) {
            return this.alpha *= t, this.shadow = this.shadow || i, this.compositeOperation = this.compositeOperation || r, this.visible = this.visible && n, u && this.matrix.prependMatrix(u), this
        };
        n.identity = function() {
            return this.visible = !0, this.alpha = 1, this.shadow = this.compositeOperation = null, this.matrix.identity(), this
        };
        n.clone = function() {
            return new t(this.alpha, this.shadow, this.compositeOperation, this.visible, this.matrix.clone())
        };
        createjs.DisplayProps = t
    }(),
    function() {
        "use strict";

        function t(n, t) {
            this.setValues(n, t)
        }
        var n = t.prototype;
        n.setValues = function(n, t) {
            return this.x = n || 0, this.y = t || 0, this
        };
        n.copy = function(n) {
            return this.x = n.x, this.y = n.y, this
        };
        n.subtract = function(n) {
            return new createjs.Point(this.x - n.x, this.y - n.y)
        };
        n.add = function(n) {
            return new createjs.Point(this.x + n.x, this.y + n.y)
        };
        n.angle = function(n) {
            return null == n ? Math.atan2(this.y, this.x) : n.subtract(this).angle()
        };
        n.length = function() {
            return Math.sqrt(this.x * this.x + this.y * this.y)
        };
        n.distance = function(n) {
            return n.subtract(this).length()
        };
        n.project = function(n, t) {
            return new createjs.Point(this.x + Math.cos(n) * t, this.y + Math.sin(n) * t)
        };
        n.interpolate = function(n, t) {
            return new createjs.Point(this.x + (n.x - this.x) * t, this.y + (n.y - this.y) * t)
        };
        n.average = function(n) {
            return this.interpolate(n, .5)
        };
        n.clone = function() {
            return new t(this.x, this.y)
        };
        n.toString = function() {
            return "[Point (x=" + this.x + " y=" + this.y + ")]"
        };
        createjs.Point = t
    }(),
    function() {
        "use strict";

        function t(n, t, i, r) {
            this.setValues(n, t, i, r)
        }
        var n = t.prototype;
        n.setValues = function(n, t, i, r) {
            return this.x = n || 0, this.y = t || 0, this.width = i || 0, this.height = r || 0, this
        };
        n.extend = function(n, t, i, r) {
            return r = r || 0, n + (i = i || 0) > this.x + this.width && (this.width = n + i - this.x), t + r > this.y + this.height && (this.height = t + r - this.y), n < this.x && (this.width += this.x - n, this.x = n), t < this.y && (this.height += this.y - t, this.y = t), this
        };
        n.pad = function(n, t, i, r) {
            return this.x -= t, this.y -= n, this.width += t + r, this.height += n + i, this
        };
        n.copy = function(n) {
            return this.setValues(n.x, n.y, n.width, n.height)
        };
        n.contains = function(n, t, i, r) {
            return i = i || 0, r = r || 0, n >= this.x && n + i <= this.x + this.width && t >= this.y && t + r <= this.y + this.height
        };
        n.union = function(n) {
            return this.clone().extend(n.x, n.y, n.width, n.height)
        };
        n.intersection = function(n) {
            var i = n.x,
                r = n.y,
                u = i + n.width,
                n = r + n.height;
            return this.x > i && (i = this.x), this.y > r && (r = this.y), this.x + this.width < u && (u = this.x + this.width), this.y + this.height < n && (n = this.y + this.height), u <= i || n <= r ? null : new t(i, r, u - i, n - r)
        };
        n.intersects = function(n) {
            return n.x <= this.x + this.width && this.x <= n.x + n.width && n.y <= this.y + this.height && this.y <= n.y + n.height
        };
        n.isEmpty = function() {
            return this.width <= 0 || this.height <= 0
        };
        n.clone = function() {
            return new t(this.x, this.y, this.width, this.height)
        };
        n.toString = function() {
            return "[Rectangle (x=" + this.x + " y=" + this.y + " width=" + this.width + " height=" + this.height + ")]"
        };
        createjs.Rectangle = t
    }(),
    function() {
        "use strict";

        function t(n, t, i, r, u, f, e) {
            n.addEventListener && (this.target = n, this.overLabel = null == i ? "over" : i, this.outLabel = null == t ? "out" : t, this.downLabel = null == r ? "down" : r, this.play = u, this._isPressed = !1, this._isOver = !1, this._enabled = !1, n.mouseChildren = !1, this.enabled = !0, this.handleEvent({}), f && (e && (f.actionsEnabled = !1, f.gotoAndStop && f.gotoAndStop(e)), n.hitArea = f))
        }
        var n = t.prototype;
        n._setEnabled = function(n) {
            var t;
            n != this._enabled && (t = this.target, (this._enabled = n) ? (t.cursor = "pointer", t.addEventListener("rollover", this), t.addEventListener("rollout", this), t.addEventListener("mousedown", this), t.addEventListener("pressup", this), t._reset && (t.__reset = t._reset, t._reset = this._reset)) : (t.cursor = null, t.removeEventListener("rollover", this), t.removeEventListener("rollout", this), t.removeEventListener("mousedown", this), t.removeEventListener("pressup", this), t.__reset && (t._reset = t.__reset, delete t.__reset)))
        };
        n.setEnabled = createjs.deprecate(n._setEnabled, "ButtonHelper.setEnabled");
        n._getEnabled = function() {
            return this._enabled
        };
        n.getEnabled = createjs.deprecate(n._getEnabled, "ButtonHelper.getEnabled");
        try {
            Object.defineProperties(n, {
                enabled: {
                    get: n._getEnabled,
                    set: n._setEnabled
                }
            })
        } catch (t) {}
        n.toString = function() {
            return "[ButtonHelper]"
        };
        n.handleEvent = function(n) {
            var t = this.target,
                n = n.type,
                n = "mousedown" == n ? (this._isPressed = !0, this.downLabel) : "pressup" == n ? (this._isPressed = !1, this._isOver ? this.overLabel : this.outLabel) : "rollover" == n ? (this._isOver = !0, this._isPressed ? this.downLabel : this.overLabel) : (this._isOver = !1, this._isPressed ? this.overLabel : this.outLabel);
            this.play ? t.gotoAndPlay && t.gotoAndPlay(n) : t.gotoAndStop && t.gotoAndStop(n)
        };
        n._reset = function() {
            var n = this.paused;
            this.__reset();
            this.paused = n
        };
        createjs.ButtonHelper = t
    }(),
    function() {
        "use strict";

        function n(n, t, i, r) {
            this.color = n || "black";
            this.offsetX = t || 0;
            this.offsetY = i || 0;
            this.blur = r || 0
        }
        var t = n.prototype;
        n.identity = new n("transparent", 0, 0, 0);
        t.toString = function() {
            return "[Shadow]"
        };
        t.clone = function() {
            return new n(this.color, this.offsetX, this.offsetY, this.blur)
        };
        createjs.Shadow = n
    }(),
    function() {
        "use strict";

        function t(n) {
            this.EventDispatcher_constructor();
            this.complete = !0;
            this.framerate = 0;
            this._animations = null;
            this._frames = null;
            this._images = null;
            this._data = null;
            this._loadCount = 0;
            this._frameHeight = 0;
            this._frameWidth = 0;
            this._numFrames = 0;
            this._regX = 0;
            this._regY = 0;
            this._spacing = 0;
            this._margin = 0;
            this._parseData(n)
        }
        var n = createjs.extend(t, createjs.EventDispatcher);
        n._getAnimations = function() {
            return this._animations.slice()
        };
        n.getAnimations = createjs.deprecate(n._getAnimations, "SpriteSheet.getAnimations");
        try {
            Object.defineProperties(n, {
                animations: {
                    get: n._getAnimations
                }
            })
        } catch (t) {}
        n.getNumFrames = function(n) {
            return null == n ? this._frames ? this._frames.length : this._numFrames || 0 : (n = this._data[n], null == n ? 0 : n.frames.length)
        };
        n.getAnimation = function(n) {
            return this._data[n]
        };
        n.getFrame = function(n) {
            var t;
            return this._frames && (t = this._frames[n]) ? t : null
        };
        n.getFrameBounds = function(n, t) {
            return n = this.getFrame(n), n ? (t || new createjs.Rectangle).setValues(-n.regX, -n.regY, n.rect.width, n.rect.height) : null
        };
        n.toString = function() {
            return "[SpriteSheet]"
        };
        n.clone = function() {
            throw "SpriteSheet cannot be cloned.";
        };
        n._parseData = function(n) {
            var r, h, u, s, c, f, o, t, i, l, e;
            if (null != n) {
                if (this.framerate = n.framerate || 0, n.images && 0 < (h = n.images.length))
                    for (e = this._images = [], r = 0; r < h; r++) f = n.images[r], "string" == typeof f && (c = f, (f = document.createElement("img")).src = c), e.push(f), f.getContext || f.naturalWidth || (this._loadCount++, this.complete = !1, function(n, t) {
                        f.onload = function() {
                            n._handleImageLoad(t)
                        }
                    }(this, c), function(n, t) {
                        f.onerror = function() {
                            n._handleImageError(t)
                        }
                    }(this, c));
                if (null != n.frames)
                    if (Array.isArray(n.frames))
                        for (this._frames = [], r = 0, h = (e = n.frames).length; r < h; r++) o = e[r], this._frames.push({
                            image: this._images[o[4] || 0],
                            rect: new createjs.Rectangle(o[0], o[1], o[2], o[3]),
                            regX: o[5] || 0,
                            regY: o[6] || 0
                        });
                    else u = n.frames, this._frameWidth = u.width, this._frameHeight = u.height, this._regX = u.regX || 0, this._regY = u.regY || 0, this._spacing = u.spacing || 0, this._margin = u.margin || 0, this._numFrames = u.count, 0 == this._loadCount && this._calculateFrames();
                if (this._animations = [], null != (u = n.animations))
                    for (s in this._data = {}, u) {
                        if (t = {
                                name: s
                            }, i = u[s], "number" == typeof i) e = t.frames = [i];
                        else if (Array.isArray(i))
                            if (1 == i.length) t.frames = [i[0]];
                            else
                                for (t.speed = i[3], t.next = i[2], e = t.frames = [], r = i[0]; r <= i[1]; r++) e.push(r);
                        else t.speed = i.speed, t.next = i.next, l = i.frames, e = t.frames = "number" == typeof l ? [l] : l.slice(0);
                        !0 !== t.next && void 0 !== t.next || (t.next = s);
                        (!1 === t.next || e.length < 2 && t.next == s) && (t.next = null);
                        t.speed || (t.speed = 1);
                        this._animations.push(s);
                        this._data[s] = t
                    }
            }
        };
        n._handleImageLoad = function() {
            0 == --this._loadCount && (this._calculateFrames(), this.complete = !0, this.dispatchEvent("complete"))
        };
        n._handleImageError = function(n) {
            var t = new createjs.Event("error");
            t.src = n;
            this.dispatchEvent(t);
            0 == --this._loadCount && this.dispatchEvent("complete")
        };
        n._calculateFrames = function() {
            var i, o, r;
            if (!this._frames && 0 != this._frameWidth) {
                this._frames = [];
                var c = this._numFrames || 1e5,
                    u = 0,
                    f = this._frameWidth,
                    e = this._frameHeight,
                    h = this._spacing,
                    t = this._margin;
                n: for (i = 0, o = this._images; i < o.length; i++)
                    for (var n = o[i], l = n.width || n.naturalWidth, a = n.height || n.naturalHeight, s = t; s <= a - t - e;) {
                        for (r = t; r <= l - t - f;) {
                            if (c <= u) break n;
                            u++;
                            this._frames.push({
                                image: n,
                                rect: new createjs.Rectangle(r, s, f, e),
                                regX: this._regX,
                                regY: this._regY
                            });
                            r += f + h
                        }
                        s += e + h
                    }
                this._numFrames = u
            }
        };
        createjs.SpriteSheet = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function i() {
            this.command = null;
            this._stroke = null;
            this._strokeStyle = null;
            this._oldStrokeStyle = null;
            this._strokeDash = null;
            this._oldStrokeDash = null;
            this._strokeIgnoreScale = !1;
            this._fill = null;
            this._instructions = [];
            this._commitIndex = 0;
            this._activeInstructions = [];
            this._dirty = !1;
            this._storeIndex = 0;
            this.clear()
        }
        var n = i.prototype,
            t = i,
            r;
        i.getRGB = function(n, t, i, r) {
            return null != n && null == i && (r = t, i = 255 & n, t = n >> 8 & 255, n = n >> 16 & 255), null == r ? "rgb(" + n + "," + t + "," + i + ")" : "rgba(" + n + "," + t + "," + i + "," + r + ")"
        };
        i.getHSL = function(n, t, i, r) {
            return null == r ? "hsl(" + n % 360 + "," + t + "%," + i + "%)" : "hsla(" + n % 360 + "," + t + "%," + i + "%," + r + ")"
        };
        i.BASE_64 = {
            A: 0,
            B: 1,
            C: 2,
            D: 3,
            E: 4,
            F: 5,
            G: 6,
            H: 7,
            I: 8,
            J: 9,
            K: 10,
            L: 11,
            M: 12,
            N: 13,
            O: 14,
            P: 15,
            Q: 16,
            R: 17,
            S: 18,
            T: 19,
            U: 20,
            V: 21,
            W: 22,
            X: 23,
            Y: 24,
            Z: 25,
            a: 26,
            b: 27,
            c: 28,
            d: 29,
            e: 30,
            f: 31,
            g: 32,
            h: 33,
            i: 34,
            j: 35,
            k: 36,
            l: 37,
            m: 38,
            n: 39,
            o: 40,
            p: 41,
            q: 42,
            r: 43,
            s: 44,
            t: 45,
            u: 46,
            v: 47,
            w: 48,
            x: 49,
            y: 50,
            z: 51,
            0: 52,
            1: 53,
            2: 54,
            3: 55,
            4: 56,
            5: 57,
            6: 58,
            7: 59,
            8: 60,
            9: 61,
            "+": 62,
            "/": 63
        };
        i.STROKE_CAPS_MAP = ["butt", "round", "square"];
        i.STROKE_JOINTS_MAP = ["miter", "round", "bevel"];
        r = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas");
        r.getContext && (i._ctx = r.getContext("2d"), r.width = r.height = 1);
        n._getInstructions = function() {
            return this._updateInstructions(), this._instructions
        };
        n.getInstructions = createjs.deprecate(n._getInstructions, "Graphics.getInstructions");
        try {
            Object.defineProperties(n, {
                instructions: {
                    get: n._getInstructions
                }
            })
        } catch (n) {}
        n.isEmpty = function() {
            return !(this._instructions.length || this._activeInstructions.length)
        };
        n.draw = function(n, t) {
            this._updateInstructions();
            for (var r = this._instructions, i = this._storeIndex, u = r.length; i < u; i++) r[i].exec(n, t)
        };
        n.drawAsPath = function(n) {
            this._updateInstructions();
            for (var i, r = this._instructions, t = this._storeIndex, u = r.length; t < u; t++) !1 !== (i = r[t]).path && i.exec(n)
        };
        n.moveTo = function(n, i) {
            return this.append(new t.MoveTo(n, i), !0)
        };
        n.lineTo = function(n, i) {
            return this.append(new t.LineTo(n, i))
        };
        n.arcTo = function(n, i, r, u, f) {
            return this.append(new t.ArcTo(n, i, r, u, f))
        };
        n.arc = function(n, i, r, u, f, e) {
            return this.append(new t.Arc(n, i, r, u, f, e))
        };
        n.quadraticCurveTo = function(n, i, r, u) {
            return this.append(new t.QuadraticCurveTo(n, i, r, u))
        };
        n.bezierCurveTo = function(n, i, r, u, f, e) {
            return this.append(new t.BezierCurveTo(n, i, r, u, f, e))
        };
        n.rect = function(n, i, r, u) {
            return this.append(new t.Rect(n, i, r, u))
        };
        n.closePath = function() {
            return this._activeInstructions.length ? this.append(new t.ClosePath) : this
        };
        n.clear = function() {
            return this._instructions.length = this._activeInstructions.length = this._commitIndex = 0, this._strokeStyle = this._oldStrokeStyle = this._stroke = this._fill = this._strokeDash = this._oldStrokeDash = null, this._dirty = this._strokeIgnoreScale = !1, this
        };
        n.beginFill = function(n) {
            return this._setFill(n ? new t.Fill(n) : null)
        };
        n.beginLinearGradientFill = function(n, i, r, u, f, e) {
            return this._setFill((new t.Fill).linearGradient(n, i, r, u, f, e))
        };
        n.beginRadialGradientFill = function(n, i, r, u, f, e, o, s) {
            return this._setFill((new t.Fill).radialGradient(n, i, r, u, f, e, o, s))
        };
        n.beginBitmapFill = function(n, i, r) {
            return this._setFill(new t.Fill(null, r).bitmap(n, i))
        };
        n.endFill = function() {
            return this.beginFill()
        };
        n.setStrokeStyle = function(n, i, r, u, f) {
            return this._updateInstructions(!0), this._strokeStyle = this.command = new t.StrokeStyle(n, i, r, u, f), this._stroke && (this._stroke.ignoreScale = f), this._strokeIgnoreScale = f, this
        };
        n.setStrokeDash = function(n, i) {
            return this._updateInstructions(!0), this._strokeDash = this.command = new t.StrokeDash(n, i), this
        };
        n.beginStroke = function(n) {
            return this._setStroke(n ? new t.Stroke(n) : null)
        };
        n.beginLinearGradientStroke = function(n, i, r, u, f, e) {
            return this._setStroke((new t.Stroke).linearGradient(n, i, r, u, f, e))
        };
        n.beginRadialGradientStroke = function(n, i, r, u, f, e, o, s) {
            return this._setStroke((new t.Stroke).radialGradient(n, i, r, u, f, e, o, s))
        };
        n.beginBitmapStroke = function(n, i) {
            return this._setStroke((new t.Stroke).bitmap(n, i))
        };
        n.endStroke = function() {
            return this.beginStroke()
        };
        n.curveTo = n.quadraticCurveTo;
        n.drawRect = n.rect;
        n.drawRoundRect = function(n, t, i, r, u) {
            return this.drawRoundRectComplex(n, t, i, r, u, u, u, u)
        };
        n.drawRoundRectComplex = function(n, i, r, u, f, e, o, s) {
            return this.append(new t.RoundRect(n, i, r, u, f, e, o, s))
        };
        n.drawCircle = function(n, i, r) {
            return this.append(new t.Circle(n, i, r))
        };
        n.drawEllipse = function(n, i, r, u) {
            return this.append(new t.Ellipse(n, i, r, u))
        };
        n.drawPolyStar = function(n, i, r, u, f, e) {
            return this.append(new t.PolyStar(n, i, r, u, f, e))
        };
        n.drawPolygon = function(n, i) {
            return this.append(new t.Polygon(n, i))
        };
        n.append = function(n, t) {
            return this._activeInstructions.push(n), this.command = n, t || (this._dirty = !0), this
        };
        n.decodePath = function(n) {
            for (var y, l, u, p, t, w = [this.moveTo, this.lineTo, this.quadraticCurveTo, this.bezierCurveTo, this.closePath], b = [2, 2, 4, 6, 0], r = 0, k = n.length, e = [], o = 0, s = 0, f = i.BASE_64; r < k;) {
                var a = n.charAt(r),
                    h = f[a],
                    c = h >> 3,
                    v = w[c];
                if (!v || 3 & h) throw "bad path data (@" + r + "): " + a;
                for (y = b[c], c || (o = s = 0), r++, l = 2 + (h >> 2 & 1), u = e.length = 0; u < y; u++) p = (t = f[n.charAt(r)]) >> 5 ? -1 : 1, t = (31 & t) << 6 | f[n.charAt(r + 1)], 3 == l && (t = t << 6 | f[n.charAt(r + 2)]), t = p * t / 10, u % 2 ? o = t += o : s = t += s, e[u] = t, r += l;
                v.apply(this, e)
            }
            return this
        };
        n.store = function() {
            return this._updateInstructions(!0), this._storeIndex = this._instructions.length, this
        };
        n.unstore = function() {
            return this._storeIndex = 0, this
        };
        n.clone = function() {
            var n = new i;
            return n.command = this.command, n._stroke = this._stroke, n._strokeStyle = this._strokeStyle, n._strokeDash = this._strokeDash, n._strokeIgnoreScale = this._strokeIgnoreScale, n._fill = this._fill, n._instructions = this._instructions.slice(), n._commitIndex = this._commitIndex, n._activeInstructions = this._activeInstructions.slice(), n._dirty = this._dirty, n._storeIndex = this._storeIndex, n
        };
        n.toString = function() {
            return "[Graphics]"
        };
        n.mt = n.moveTo;
        n.lt = n.lineTo;
        n.at = n.arcTo;
        n.bt = n.bezierCurveTo;
        n.qt = n.quadraticCurveTo;
        n.a = n.arc;
        n.r = n.rect;
        n.cp = n.closePath;
        n.c = n.clear;
        n.f = n.beginFill;
        n.lf = n.beginLinearGradientFill;
        n.rf = n.beginRadialGradientFill;
        n.bf = n.beginBitmapFill;
        n.ef = n.endFill;
        n.ss = n.setStrokeStyle;
        n.sd = n.setStrokeDash;
        n.s = n.beginStroke;
        n.ls = n.beginLinearGradientStroke;
        n.rs = n.beginRadialGradientStroke;
        n.bs = n.beginBitmapStroke;
        n.es = n.endStroke;
        n.dr = n.drawRect;
        n.rr = n.drawRoundRect;
        n.rc = n.drawRoundRectComplex;
        n.dc = n.drawCircle;
        n.de = n.drawEllipse;
        n.dp = n.drawPolyStar;
        n.pg = n.drawPolygon;
        n.p = n.decodePath;
        n._updateInstructions = function(n) {
            var t = this._instructions,
                u = this._activeInstructions,
                o = this._commitIndex,
                f, e, r;
            if (this._dirty && u.length) {
                for (t.length = o, t.push(i.beginCmd), f = u.length, e = t.length, t.length = e + f, r = 0; r < f; r++) t[r + e] = u[r];
                this._fill && t.push(this._fill);
                this._stroke && (this._strokeDash !== this._oldStrokeDash && t.push(this._strokeDash), this._strokeStyle !== this._oldStrokeStyle && t.push(this._strokeStyle), n && (this._oldStrokeStyle = this._strokeStyle, this._oldStrokeDash = this._strokeDash), t.push(this._stroke));
                this._dirty = !1
            }
            n && (u.length = 0, this._commitIndex = t.length)
        };
        n._setFill = function(n) {
            return this._updateInstructions(!0), this.command = this._fill = n, this
        };
        n._setStroke = function(n) {
            return this._updateInstructions(!0), (this.command = this._stroke = n) && (n.ignoreScale = this._strokeIgnoreScale), this
        };
        (t.LineTo = function(n, t) {
            this.x = n;
            this.y = t
        }).prototype.exec = function(n) {
            n.lineTo(this.x, this.y)
        };
        (t.MoveTo = function(n, t) {
            this.x = n;
            this.y = t
        }).prototype.exec = function(n) {
            n.moveTo(this.x, this.y)
        };
        (t.ArcTo = function(n, t, i, r, u) {
            this.x1 = n;
            this.y1 = t;
            this.x2 = i;
            this.y2 = r;
            this.radius = u
        }).prototype.exec = function(n) {
            n.arcTo(this.x1, this.y1, this.x2, this.y2, this.radius)
        };
        (t.Arc = function(n, t, i, r, u, f) {
            this.x = n;
            this.y = t;
            this.radius = i;
            this.startAngle = r;
            this.endAngle = u;
            this.anticlockwise = !!f
        }).prototype.exec = function(n) {
            n.arc(this.x, this.y, this.radius, this.startAngle, this.endAngle, this.anticlockwise)
        };
        (t.QuadraticCurveTo = function(n, t, i, r) {
            this.cpx = n;
            this.cpy = t;
            this.x = i;
            this.y = r
        }).prototype.exec = function(n) {
            n.quadraticCurveTo(this.cpx, this.cpy, this.x, this.y)
        };
        (t.BezierCurveTo = function(n, t, i, r, u, f) {
            this.cp1x = n;
            this.cp1y = t;
            this.cp2x = i;
            this.cp2y = r;
            this.x = u;
            this.y = f
        }).prototype.exec = function(n) {
            n.bezierCurveTo(this.cp1x, this.cp1y, this.cp2x, this.cp2y, this.x, this.y)
        };
        (t.Rect = function(n, t, i, r) {
            this.x = n;
            this.y = t;
            this.w = i;
            this.h = r
        }).prototype.exec = function(n) {
            n.rect(this.x, this.y, this.w, this.h)
        };
        (t.ClosePath = function() {}).prototype.exec = function(n) {
            n.closePath()
        };
        (t.BeginPath = function() {}).prototype.exec = function(n) {
            n.beginPath()
        };
        (n = (t.Fill = function(n, t) {
            this.style = n;
            this.matrix = t
        }).prototype).exec = function(n) {
            var t;
            this.style && (n.fillStyle = this.style, (t = this.matrix) && (n.save(), n.transform(t.a, t.b, t.c, t.d, t.tx, t.ty)), n.fill(), t && n.restore())
        };
        n.linearGradient = function(n, t, r, u, f, e) {
            for (var s = this.style = i._ctx.createLinearGradient(r, u, f, e), o = 0, h = n.length; o < h; o++) s.addColorStop(t[o], n[o]);
            return s.props = {
                colors: n,
                ratios: t,
                x0: r,
                y0: u,
                x1: f,
                y1: e,
                type: "linear"
            }, this
        };
        n.radialGradient = function(n, t, r, u, f, e, o, s) {
            for (var c = this.style = i._ctx.createRadialGradient(r, u, f, e, o, s), h = 0, l = n.length; h < l; h++) c.addColorStop(t[h], n[h]);
            return c.props = {
                colors: n,
                ratios: t,
                x0: r,
                y0: u,
                r0: f,
                x1: e,
                y1: o,
                r1: s,
                type: "radial"
            }, this
        };
        n.bitmap = function(n, t, r) {
            return r && (this.matrix = r), (n.naturalWidth || n.getContext || 2 <= n.readyState) && ((this.style = i._ctx.createPattern(n, t || "")).props = {
                image: n,
                repetition: t,
                type: "bitmap"
            }), this
        };
        n.path = !1;
        (n = (t.Stroke = function(n, t) {
            this.style = n;
            this.ignoreScale = t
        }).prototype).exec = function(n) {
            this.style && (n.strokeStyle = this.style, this.ignoreScale && (n.save(), n.setTransform(1, 0, 0, 1, 0, 0)), n.stroke(), this.ignoreScale && n.restore())
        };
        n.linearGradient = t.Fill.prototype.linearGradient;
        n.radialGradient = t.Fill.prototype.radialGradient;
        n.bitmap = t.Fill.prototype.bitmap;
        n.path = !1;
        (n = (t.StrokeStyle = function(n, t, i, r, u) {
            this.width = n;
            this.caps = t;
            this.joints = i;
            this.miterLimit = r;
            this.ignoreScale = u
        }).prototype).exec = function(n) {
            n.lineWidth = null == this.width ? "1" : this.width;
            n.lineCap = null == this.caps ? "butt" : isNaN(this.caps) ? this.caps : i.STROKE_CAPS_MAP[this.caps];
            n.lineJoin = null == this.joints ? "miter" : isNaN(this.joints) ? this.joints : i.STROKE_JOINTS_MAP[this.joints];
            n.miterLimit = null == this.miterLimit ? "10" : this.miterLimit;
            n.ignoreScale = null != this.ignoreScale && this.ignoreScale
        };
        n.path = !1;
        (t.StrokeDash = function(n, t) {
            this.segments = n;
            this.offset = t || 0
        }).prototype.exec = function(n) {
            n.setLineDash && (n.setLineDash(this.segments || t.StrokeDash.EMPTY_SEGMENTS), n.lineDashOffset = this.offset || 0)
        };
        t.StrokeDash.EMPTY_SEGMENTS = [];
        (t.RoundRect = function(n, t, i, r, u, f, e, o) {
            this.x = n;
            this.y = t;
            this.w = i;
            this.h = r;
            this.radiusTL = u;
            this.radiusTR = f;
            this.radiusBR = e;
            this.radiusBL = o
        }).prototype.exec = function(n) {
            var o = (s < h ? s : h) / 2,
                c = 0,
                l = 0,
                a = 0,
                v = 0,
                t = this.x,
                i = this.y,
                s = this.w,
                h = this.h,
                r = this.radiusTL,
                u = this.radiusTR,
                f = this.radiusBR,
                e = this.radiusBL;
            r < 0 && (r *= c = -1);
            o < r && (r = o);
            u < 0 && (u *= l = -1);
            o < u && (u = o);
            f < 0 && (f *= a = -1);
            o < f && (f = o);
            e < 0 && (e *= v = -1);
            o < e && (e = o);
            n.moveTo(t + s - u, i);
            n.arcTo(t + s + u * l, i - u * l, t + s, i + u, u);
            n.lineTo(t + s, i + h - f);
            n.arcTo(t + s + f * a, i + h + f * a, t + s - f, i + h, f);
            n.lineTo(t + e, i + h);
            n.arcTo(t - e * v, i + h + e * v, t, i + h - e, e);
            n.lineTo(t, i + r);
            n.arcTo(t - r * c, i - r * c, t + r, i, r);
            n.closePath()
        };
        (t.Circle = function(n, t, i) {
            this.x = n;
            this.y = t;
            this.radius = i
        }).prototype.exec = function(n) {
            n.arc(this.x, this.y, this.radius, 0, 2 * Math.PI)
        };
        (t.Ellipse = function(n, t, i, r) {
            this.x = n;
            this.y = t;
            this.w = i;
            this.h = r
        }).prototype.exec = function(n) {
            var r = this.x,
                u = this.y,
                i = this.w,
                t = this.h,
                f = i / 2 * .5522848,
                e = t / 2 * .5522848,
                o = r + i,
                s = u + t,
                i = r + i / 2,
                t = u + t / 2;
            n.moveTo(r, t);
            n.bezierCurveTo(r, t - e, i - f, u, i, u);
            n.bezierCurveTo(i + f, u, o, t - e, o, t);
            n.bezierCurveTo(o, t + e, i + f, s, i, s);
            n.bezierCurveTo(i - f, s, r, t + e, r, t)
        };
        (t.PolyStar = function(n, t, i, r, u, f) {
            this.x = n;
            this.y = t;
            this.radius = i;
            this.sides = r;
            this.pointSize = u;
            this.angle = f
        }).prototype.exec = function(n) {
            var u = this.x,
                f = this.y,
                i = this.radius,
                t = (this.angle || 0) / 180 * Math.PI,
                e = this.sides,
                o = 1 - (this.pointSize || 0),
                s = Math.PI / e,
                r;
            for (n.moveTo(u + Math.cos(t) * i, f + Math.sin(t) * i), r = 0; r < e + 1 && (t += s, 1 == o || (n.lineTo(u + Math.cos(t) * i * o, f + Math.sin(t) * i * o), r != e)); r++) t += s, n.lineTo(u + Math.cos(t) * i, f + Math.sin(t) * i);
            n.closePath()
        };
        (t.Polygon = function(n, t) {
            this.points = n;
            null == t && (t = !0);
            this.close = t
        }).prototype.exec = function(n) {
            var t, u, f = this.points,
                e = this.close,
                r = f[0],
                i;
            for (n.moveTo(r[0], r[1]), i = 1; i < f.length; i++) t = f[i], 1 == i && (u = [t[0], t[1]]), n.lineTo(t[0], t[1]);
            e && (n.lineTo(r[0], r[1]), n.lineTo(u[0], u[1]));
            n.closePath()
        };
        i.beginCmd = new t.BeginPath;
        createjs.Graphics = i
    }(),
    function() {
        "use strict";

        function t() {
            this.EventDispatcher_constructor();
            this.alpha = 1;
            this.cacheCanvas = null;
            this.bitmapCache = null;
            this.id = createjs.UID.get();
            this.mouseEnabled = !0;
            this.tickEnabled = !0;
            this.name = null;
            this.parent = null;
            this.regX = 0;
            this.regY = 0;
            this.rotation = 0;
            this.scaleX = 1;
            this.scaleY = 1;
            this.skewX = 0;
            this.skewY = 0;
            this.shadow = null;
            this.visible = !0;
            this.x = 0;
            this.y = 0;
            this.transformMatrix = null;
            this.compositeOperation = null;
            this.snapToPixel = !0;
            this.filters = null;
            this.mask = null;
            this.hitArea = null;
            this.cursor = null;
            this._props = new createjs.DisplayProps;
            this._rectangle = new createjs.Rectangle;
            this._bounds = null;
            this._webGLRenderStyle = t._StageGL_NONE
        }
        var n = createjs.extend(t, createjs.EventDispatcher),
            i;
        t._MOUSE_EVENTS = ["click", "dblclick", "mousedown", "mouseout", "mouseover", "pressmove", "pressup", "rollout", "rollover"];
        t.suppressCrossDomainErrors = !1;
        t._snapToPixelEnabled = !1;
        t._StageGL_NONE = 0;
        t._StageGL_SPRITE = 1;
        t._StageGL_BITMAP = 2;
        i = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas");
        i.getContext && (t._hitTestCanvas = i, t._hitTestContext = i.getContext("2d", createjs.willReadFrequently ? {
            willReadFrequently: !0
        } : void 0), i.width = i.height = 1);
        n._getStage = function() {
            for (var n = this, t = createjs.Stage; n.parent;) n = n.parent;
            return n instanceof t ? n : null
        };
        n.getStage = createjs.deprecate(n._getStage, "DisplayObject.getStage");
        try {
            Object.defineProperties(n, {
                stage: {
                    get: n._getStage
                },
                cacheID: {
                    get: function() {
                        return this.bitmapCache && this.bitmapCache.cacheID
                    },
                    set: function(n) {
                        this.bitmapCache && (this.bitmapCache.cacheID = n)
                    }
                },
                scale: {
                    get: function() {
                        return this.scaleX
                    },
                    set: function(n) {
                        this.scaleX = this.scaleY = n
                    }
                }
            })
        } catch (n) {}
        n.isVisible = function() {
            return !!(this.visible && 0 < this.alpha && 0 != this.scaleX && 0 != this.scaleY)
        };
        n.draw = function(n, t) {
            var i = this.bitmapCache;
            return !(!i || t) && i.draw(n)
        };
        n.updateContext = function(n) {
            var u = this,
                r = u.mask,
                i = u._props.matrix,
                f;
            r && r.graphics && !r.graphics.isEmpty() && (r.getMatrix(i), n.transform(i.a, i.b, i.c, i.d, i.tx, i.ty), r.graphics.drawAsPath(n), n.clip(), i.invert(), n.transform(i.a, i.b, i.c, i.d, i.tx, i.ty));
            this.getMatrix(i);
            f = i.tx;
            r = i.ty;
            t._snapToPixelEnabled && u.snapToPixel && (f = f + (f < 0 ? -.5 : .5) | 0, r = r + (r < 0 ? -.5 : .5) | 0);
            n.transform(i.a, i.b, i.c, i.d, f, r);
            n.globalAlpha *= u.alpha;
            u.compositeOperation && (n.globalCompositeOperation = u.compositeOperation);
            u.shadow && this._applyShadow(n, u.shadow)
        };
        n.cache = function(n, t, i, r, u, f, e, o) {
            this.bitmapCache || (this.bitmapCache = new createjs.BitmapCache);
            this.bitmapCache.define(this, n, t, i, r, u, f, e, o)
        };
        n.updateCache = function(n, t) {
            if (!this.bitmapCache) throw "cache() must be called before updateCache()";
            this.bitmapCache.update(n, t)
        };
        n.uncache = function() {
            this.bitmapCache && (this.bitmapCache.release(), this.bitmapCache = void 0)
        };
        n.getCacheDataURL = function() {
            return this.bitmapCache ? this.bitmapCache.getCacheDataURL() : null
        };
        n.localToGlobal = function(n, t, i) {
            return i = this.getConcatenatedMatrix(this._props.matrix).transformPoint(n, t, i || new createjs.Point), this.stage && createjs.stageTransformable && (i = this.stage.getConcatenatedMatrix(this._mtx).invert().transformPoint(i.x, i.y)), i
        };
        n.globalToLocal = function(n, t, i) {
            var r;
            return this.stage && createjs.stageTransformable && (n = (r = this.stage.getConcatenatedMatrix(this._mtx).transformPoint(n, t)).x, t = r.y), this.getConcatenatedMatrix(this._props.matrix).invert().transformPoint(n, t, i || new createjs.Point)
        };
        n.localToLocal = function(n, t, i, r) {
            return r = this.localToGlobal(n, t, r), i.globalToLocal(r.x, r.y, r)
        };
        n.setTransform = function(n, t, i, r, u, f, e, o, s) {
            return this.x = n || 0, this.y = t || 0, this.scaleX = null == i ? 1 : i, this.scaleY = null == r ? 1 : r, this.rotation = u || 0, this.skewX = f || 0, this.skewY = e || 0, this.regX = o || 0, this.regY = s || 0, this
        };
        n.getMatrix = function(n) {
            var t = this,
                n = n && n.identity() || new createjs.Matrix2D;
            return t.transformMatrix ? n.copy(t.transformMatrix) : n.appendTransform(t.x, t.y, t.scaleX, t.scaleY, t.rotation, t.skewX, t.skewY, t.regX, t.regY)
        };
        n.getConcatenatedMatrix = function(n) {
            for (var t = this, i = this.getMatrix(n); t = t.parent;) i.prependMatrix(t.getMatrix(t._props.matrix));
            return i
        };
        n.getConcatenatedDisplayProps = function(n) {
            n = n ? n.identity() : new createjs.DisplayProps;
            for (var t = this, i = t.getMatrix(n.matrix); n.prepend(t.visible, t.alpha, t.shadow, t.compositeOperation), t != this && i.prependMatrix(t.getMatrix(t._props.matrix)), t = t.parent;);
            return n
        };
        n.hitTest = function(n, i) {
            var r = t._hitTestContext;
            return r.setTransform(1, 0, 0, 1, -n, -i), this.draw(r), i = this._testHit(r), r.setTransform(1, 0, 0, 1, 0, 0), r.clearRect(0, 0, 2, 2), i
        };
        n.set = function(n) {
            for (var t in n) this[t] = n[t];
            return this
        };
        n.getBounds = function() {
            var n, t;
            return this._bounds ? this._rectangle.copy(this._bounds) : (n = this.cacheCanvas, n) ? (t = this._cacheScale, this._rectangle.setValues(this._cacheOffsetX, this._cacheOffsetY, n.width / t, n.height / t)) : null
        };
        n.getTransformedBounds = function() {
            return this._getBounds()
        };
        n.setBounds = function(n, t, i, r) {
            this._bounds = null != n ? (this._bounds || new createjs.Rectangle).setValues(n, t, i, r) : n
        };
        n.clone = function() {
            return this._cloneProps(new t)
        };
        n.toString = function() {
            return "[DisplayObject (name=" + this.name + ")]"
        };
        n._updateState = null;
        n._cloneProps = function(n) {
            return n.alpha = this.alpha, n.mouseEnabled = this.mouseEnabled, n.tickEnabled = this.tickEnabled, n.name = this.name, n.regX = this.regX, n.regY = this.regY, n.rotation = this.rotation, n.scaleX = this.scaleX, n.scaleY = this.scaleY, n.shadow = this.shadow, n.skewX = this.skewX, n.skewY = this.skewY, n.visible = this.visible, n.x = this.x, n.y = this.y, n.compositeOperation = this.compositeOperation, n.snapToPixel = this.snapToPixel, n.filters = null == this.filters ? null : this.filters.slice(0), n.mask = this.mask, n.hitArea = this.hitArea, n.cursor = this.cursor, n._bounds = this._bounds, n
        };
        n._applyShadow = function(n, t) {
            t = t || Shadow.identity;
            n.shadowColor = t.color;
            n.shadowOffsetX = t.offsetX;
            n.shadowOffsetY = t.offsetY;
            n.shadowBlur = t.blur
        };
        n._tick = function(n) {
            var t = this._listeners;
            t && t.tick && (n.target = null, n.propagationStopped = n.immediatePropagationStopped = !1, this.dispatchEvent(n))
        };
        n._testHit = function(n) {
            try {
                var i = 1 < n.getImageData(0, 0, 1, 1).data[3]
            } catch (n) {
                if (!t.suppressCrossDomainErrors) throw "An error has occurred. This is most likely due to security restrictions on reading canvas pixel data with local or cross-domain images.";
            }
            return i
        };
        n._getBounds = function(n, t) {
            return this._transformBounds(this.getBounds(), n, t)
        };
        n._transformBounds = function(n, t, i) {
            if (!n) return n;
            var u = n.x,
                f = n.y,
                o = n.width,
                e = n.height,
                r = this._props.matrix,
                r = i ? r.identity() : this.getMatrix(r);
            (u || f) && r.appendTransform(0, 0, 1, 1, 0, 0, 0, -u, -f);
            t && r.prependMatrix(t);
            var h = o * r.a,
                c = o * r.b,
                l = e * r.c,
                a = e * r.d,
                s = r.tx,
                i = r.ty,
                t = s,
                o = s,
                e = i,
                r = i;
            return (u = h + s) < t ? t = u : o < u && (o = u), (u = h + l + s) < t ? t = u : o < u && (o = u), (u = l + s) < t ? t = u : o < u && (o = u), (f = c + i) < e ? e = f : r < f && (r = f), (f = c + a + i) < e ? e = f : r < f && (r = f), (f = a + i) < e ? e = f : r < f && (r = f), n.setValues(t, e, o - t, r - e)
        };
        n._hasMouseEventListener = function() {
            for (var i = t._MOUSE_EVENTS, n = 0, r = i.length; n < r; n++)
                if (this.hasEventListener(i[n])) return !0;
            return !!this.cursor
        };
        createjs.DisplayObject = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function t() {
            this.DisplayObject_constructor();
            this.children = [];
            this.mouseChildren = !0;
            this.tickChildren = !0
        }
        var n = createjs.extend(t, createjs.DisplayObject);
        n._getNumChildren = function() {
            return this.children.length
        };
        n.getNumChildren = createjs.deprecate(n._getNumChildren, "Container.getNumChildren");
        try {
            Object.defineProperties(n, {
                numChildren: {
                    get: n._getNumChildren
                }
            })
        } catch (n) {}
        n.initialize = t;
        n.isVisible = function() {
            var n = this.cacheCanvas || this.children.length;
            return !!(this.visible && 0 < this.alpha && 0 != this.scaleX && 0 != this.scaleY && n)
        };
        n.draw = function(n, t) {
            var i;
            if (this.DisplayObject_draw(n, t)) return !0;
            for (var u = this.children.slice(), r = 0, f = u.length; r < f; r++) i = u[r], i.isVisible() && (n.save(), i.updateContext(n), i.draw(n), n.restore());
            return !0
        };
        n.addChild = function(n) {
            var i, r, t, u;
            if (null == n) return n;
            if (i = arguments.length, 1 < i) {
                for (r = 0; r < i; r++) this.addChild(arguments[r]);
                return arguments[i - 1]
            }
            return t = n.parent, u = t === this, t && t._removeChildAt(createjs.indexOf(t.children, n), u), (n.parent = this).children.push(n), u || n.dispatchEvent("added"), n
        };
        n.addChildAt = function(n, t) {
            var i = arguments.length,
                f = arguments[i - 1],
                r, u, e;
            if (f < 0 || f > this.children.length) return arguments[i - 2];
            if (2 < i) {
                for (r = 0; r < i - 1; r++) this.addChildAt(arguments[r], f + r);
                return arguments[i - 2]
            }
            return u = n.parent, e = u === this, u && u._removeChildAt(createjs.indexOf(u.children, n), e), (n.parent = this).children.splice(t, 0, n), e || n.dispatchEvent("added"), n
        };
        n.removeChild = function(n) {
            var r = arguments.length,
                t, i;
            if (1 < r) {
                for (t = !0, i = 0; i < r; i++) t = t && this.removeChild(arguments[i]);
                return t
            }
            return this._removeChildAt(createjs.indexOf(this.children, n))
        };
        n.removeChildAt = function(n) {
            var u = arguments.length,
                i, r, t;
            if (1 < u) {
                for (i = [], t = 0; t < u; t++) i[t] = arguments[t];
                for (i.sort(function(n, t) {
                        return t - n
                    }), r = !0, t = 0; t < u; t++) r = r && this._removeChildAt(i[t]);
                return r
            }
            return this._removeChildAt(n)
        };
        n.removeAllChildren = function() {
            for (var n = this.children; n.length;) this._removeChildAt(0)
        };
        n.getChildAt = function(n) {
            return this.children[n]
        };
        n.getChildByName = function(n) {
            for (var i = this.children, t = 0, r = i.length; t < r; t++)
                if (i[t].name == n) return i[t];
            return null
        };
        n.sortChildren = function(n) {
            this.children.sort(n)
        };
        n.getChildIndex = function(n) {
            return createjs.indexOf(this.children, n)
        };
        n.swapChildrenAt = function(n, t) {
            var i = this.children,
                r = i[n],
                u = i[t];
            r && u && (i[n] = u, i[t] = r)
        };
        n.swapChildren = function(n, t) {
            for (var u, f, r = this.children, i = 0, e = r.length; i < e && (r[i] == n && (u = i), r[i] == t && (f = i), null == u || null == f); i++);
            i != e && (r[u] = t, r[f] = n)
        };
        n.setChildIndex = function(n, t) {
            var r = this.children,
                u = r.length,
                i;
            if (!(n.parent != this || t < 0 || u <= t)) {
                for (i = 0; i < u && r[i] != n; i++);
                i != u && i != t && (r.splice(i, 1), r.splice(t, 0, n))
            }
        };
        n.contains = function(n) {
            for (; n;) {
                if (n == this) return !0;
                n = n.parent
            }
            return !1
        };
        n.hitTest = function(n, t) {
            return null != this.getObjectUnderPoint(n, t)
        };
        n.getObjectsUnderPoint = function(n, t, i) {
            var r = [],
                t = this.localToGlobal(n, t);
            return this._getObjectsUnderPoint(t.x, t.y, r, 0 < i, 1 == i), r
        };
        n.getObjectUnderPoint = function(n, t, i) {
            return t = this.localToGlobal(n, t), this._getObjectsUnderPoint(t.x, t.y, null, 0 < i, 1 == i)
        };
        n.getBounds = function() {
            return this._getBounds(null, !0)
        };
        n.getTransformedBounds = function() {
            return this._getBounds()
        };
        n.clone = function(n) {
            var i = this._cloneProps(new t);
            return n && this._cloneChildren(i), i
        };
        n.toString = function() {
            return "[Container (name=" + this.name + ")]"
        };
        n._tick = function(n) {
            var t, i;
            if (this.tickChildren)
                for (t = this.children.length - 1; 0 <= t; t--) i = this.children[t], i.tickEnabled && i._tick && i._tick(n);
            this.DisplayObject__tick(n)
        };
        n._cloneChildren = function(n) {
            var i;
            n.children.length && n.removeAllChildren();
            for (var r = n.children, t = 0, u = this.children.length; t < u; t++) i = this.children[t].clone(!0), i.parent = n, r.push(i)
        };
        n._removeChildAt = function(n, t) {
            if (n < 0 || n > this.children.length - 1) return !1;
            var i = this.children[n];
            return i && (i.parent = null), this.children.splice(n, 1), t || i.dispatchEvent("removed"), !0
        };
        n._getObjectsUnderPoint = function(n, i, r, u, f, e) {
            var v, y, w, c, p, l, o, h, a, s;
            if (this.stage && createjs.stageTransformable && (v = n, y = i, n = (w = this.stage.getConcatenatedMatrix(this._mtx).transformPoint(n, i)).x, i = w.y), !(e = e || 0) && !this._testMask(this, n, i)) return null;
            for (c = createjs.DisplayObject._hitTestContext, f = f || u && this._hasMouseEventListener(), p = this.children, l = p.length - 1; 0 <= l; l--)
                if (o = p[l], h = o.hitArea, o.visible && (h || o.isVisible()) && (!u || o.mouseEnabled) && (h || this._testMask(o, n, i)))
                    if (!h && o instanceof t) {
                        if (s = o._getObjectsUnderPoint(null != v ? v : n, null != y ? y : i, r, u, f, e + 1), !r && s) return u && !this.mouseChildren ? this : s
                    } else if ((!u || f || o._hasMouseEventListener()) && (a = o.getConcatenatedDisplayProps(o._props), s = a.matrix, h && (s.appendMatrix(h.getMatrix(h._props.matrix)), a.alpha = h.alpha), c.globalAlpha = a.alpha, c.setTransform(s.a, s.b, s.c, s.d, s.tx - n, s.ty - i), (h || o).draw(c), this._testHit(c))) {
                if (c.setTransform(1, 0, 0, 1, 0, 0), c.clearRect(0, 0, 2, 2), !r) return u && !this.mouseChildren ? this : o;
                r.push(o)
            }
            return null
        };
        n._testMask = function(n, t, i) {
            var u = n.mask;
            if (!u || !u.graphics || u.graphics.isEmpty()) return !0;
            var r = this._props.matrix,
                n = n.parent,
                r = n ? n.getConcatenatedMatrix(r) : r.identity();
            return r = u.getMatrix(u._props.matrix).prependMatrix(r), n = createjs.DisplayObject._hitTestContext, n.setTransform(r.a, r.b, r.c, r.d, r.tx - t, r.ty - i), u.graphics.drawAsPath(n), n.fillStyle = "#000", n.fill(), !!this._testHit(n) && (n.setTransform(1, 0, 0, 1, 0, 0), n.clearRect(0, 0, 2, 2), !0)
        };
        n._getBounds = function(n, t) {
            var i = this.DisplayObject_getBounds(),
                r, e;
            if (i) return this._transformBounds(i, n, t);
            r = this._props.matrix;
            r = t ? r.identity() : this.getMatrix(r);
            n && r.prependMatrix(n);
            for (var o = this.children.length, u = null, f = 0; f < o; f++) e = this.children[f], e.visible && (i = e._getBounds(r)) && (u ? u.extend(i.x, i.y, i.width, i.height) : u = i.clone());
            return u
        };
        createjs.Container = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t(n, t) {
            this.Container_constructor();
            !1 === t && createjs && createjs.DisplayObject && (createjs.DisplayObject._hitTestContext = createjs.DisplayObject._hitTestCanvas.getContext("2d", {
                willReadFrequently: !1
            }), createjs.willReadFrequently = !1);
            this.autoClear = !0;
            this.canvas = "string" == typeof n ? document.getElementById(n) : n;
            this.mouseX = 0;
            this.mouseY = 0;
            this.drawRect = null;
            this.snapToPixelEnabled = !1;
            this.mouseInBounds = !1;
            this.tickOnUpdate = !0;
            this.mouseMoveOutside = !1;
            this.preventSelection = !0;
            this._pointerData = {};
            this._pointerCount = 0;
            this._primaryPointerID = null;
            this._mouseOverIntervalID = null;
            this._nextStage = null;
            this._prevStage = null;
            this.enableDOMEvents(!0)
        }
        var n = createjs.extend(t, createjs.Container);
        n._get_nextStage = function() {
            return this._nextStage
        };
        n._set_nextStage = function(n) {
            this._nextStage && (this._nextStage._prevStage = null);
            n && (n._prevStage = this);
            this._nextStage = n
        };
        try {
            Object.defineProperties(n, {
                nextStage: {
                    get: n._get_nextStage,
                    set: n._set_nextStage
                }
            })
        } catch (t) {}
        n.update = function(n) {
            var t;
            this.canvas && (this.tickOnUpdate && this.tick(n), !1 !== this.dispatchEvent("drawstart", !1, !0) && (createjs.DisplayObject._snapToPixelEnabled = this.snapToPixelEnabled, t = this.drawRect, (n = this.canvas.getContext("2d")).setTransform(1, 0, 0, 1, 0, 0), this.autoClear && (t ? n.clearRect(t.x, t.y, t.width, t.height) : n.clearRect(0, 0, this.canvas.width + 1, this.canvas.height + 1)), n.save(), this.drawRect && (n.beginPath(), n.rect(t.x, t.y, t.width, t.height), n.clip()), this.updateContext(n), this.draw(n, !1), n.restore(), this.dispatchEvent("drawend")))
        };
        n.tick = function(n) {
            var i, t;
            if (this.tickEnabled && !1 !== this.dispatchEvent("tickstart", !1, !0)) {
                if (i = new createjs.Event("tick"), n)
                    for (t in n) n.hasOwnProperty(t) && (i[t] = n[t]);
                this._tick(i);
                this.dispatchEvent("tickend")
            }
        };
        n.handleEvent = function(n) {
            "tick" == n.type && this.update(n)
        };
        n.clear = function() {
            var n;
            this.canvas && ((n = this.canvas.getContext("2d")).setTransform(1, 0, 0, 1, 0, 0), n.clearRect(0, 0, this.canvas.width + 1, this.canvas.height + 1))
        };
        n.toDataURL = function(n, t) {
            var r, u, i = this.canvas.getContext("2d"),
                f = this.canvas.width,
                e = this.canvas.height;
            return n && (r = i.getImageData(0, 0, f, e), u = i.globalCompositeOperation, i.globalCompositeOperation = "destination-over", i.fillStyle = n, i.fillRect(0, 0, f, e)), t = this.canvas.toDataURL(t || "image/png"), n && (i.putImageData(r, 0, 0), i.globalCompositeOperation = u), t
        };
        n.enableMouseOver = function(n) {
            if (this._mouseOverIntervalID && (clearInterval(this._mouseOverIntervalID), this._mouseOverIntervalID = null, 0 == n && this._testMouseOver(!0)), null == n) n = 20;
            else if (n <= 0) return;
            var t = this;
            this._mouseOverIntervalID = setInterval(function() {
                t._testMouseOver()
            }, 1e3 / Math.min(50, n))
        };
        n.enableDOMEvents = function(n) {
            var i, u, t, n, r;
            if (null == n && (n = !0), t = this._eventListeners, !n && t) {
                for (i in t)(u = t[i]).t.removeEventListener(i, u.f, !1);
                this._eventListeners = null
            } else if (n && !t && this.canvas) {
                n = window.addEventListener ? window : document;
                r = this;
                for (i in (t = this._eventListeners = {}).mouseup = {
                        t: n,
                        f: function(n) {
                            r._handleMouseUp(n)
                        }
                    }, t.mousemove = {
                        t: n,
                        f: function(n) {
                            r._handleMouseMove(n)
                        }
                    }, t.dblclick = {
                        t: this.canvas,
                        f: function(n) {
                            r._handleDoubleClick(n)
                        }
                    }, t.mousedown = {
                        t: this.canvas,
                        f: function(n) {
                            r._handleMouseDown(n)
                        }
                    }, t)(u = t[i]).t.addEventListener(i, u.f, !1)
            }
        };
        n.clone = function() {
            throw "Stage cannot be cloned.";
        };
        n.toString = function() {
            return "[Stage (name=" + this.name + ")]"
        };
        n._getElementRect = function(n) {
            var i;
            try {
                i = n.getBoundingClientRect()
            } catch (r) {
                i = {
                    top: n.offsetTop,
                    left: n.offsetLeft,
                    width: n.offsetWidth,
                    height: n.offsetHeight
                }
            }
            var r = (window.pageXOffset || document.scrollLeft || 0) - (document.clientLeft || document.body.clientLeft || 0),
                u = (window.pageYOffset || document.scrollTop || 0) - (document.clientTop || document.body.clientTop || 0),
                t = window.getComputedStyle ? getComputedStyle(n, null) : n.currentStyle,
                f = parseInt(t.paddingLeft) + parseInt(t.borderLeftWidth),
                e = parseInt(t.paddingTop) + parseInt(t.borderTopWidth),
                o = parseInt(t.paddingRight) + parseInt(t.borderRightWidth),
                t = parseInt(t.paddingBottom) + parseInt(t.borderBottomWidth);
            return {
                left: i.left + r + f,
                right: i.right + r - o,
                top: i.top + u + e,
                bottom: i.bottom + u - t
            }
        };
        n._getPointerData = function(n) {
            return this._pointerData[n] || (this._pointerData[n] = {
                x: 0,
                y: 0
            })
        };
        n._handleMouseMove = function(n) {
            n = n || window.event;
            this._handlePointerMove(-1, n, n.pageX, n.pageY)
        };
        n._handlePointerMove = function(n, t, i, r, u) {
            var e, f;
            this._prevStage && void 0 === u || this.canvas && (e = this._nextStage, u = (f = this._getPointerData(n)).inBounds, this._updatePointerPosition(n, t, i, r), (u || f.inBounds || this.mouseMoveOutside) && (-1 === n && f.inBounds == !u && this._dispatchMouseEvent(this, u ? "mouseleave" : "mouseenter", !1, n, f, t), this._dispatchMouseEvent(this, "stagemousemove", !1, n, f, t), this._dispatchMouseEvent(f.target, "pressmove", !0, n, f, t)), e && e._handlePointerMove(n, t, i, r, null))
        };
        n._updatePointerPosition = function(n, t, i, r) {
            var u = this._getElementRect(this.canvas),
                e, o, f;
            i -= u.left;
            r -= u.top;
            e = this.canvas.width;
            o = this.canvas.height;
            i /= (u.right - u.left) / e;
            r /= (u.bottom - u.top) / o;
            u = this._getPointerData(n);
            createjs.stageTransformable ? (this._mtx = this.getConcatenatedMatrix(this._mtx).invert(), (u.inBounds = 0 <= i && 0 <= r && i <= e - 1 && r <= o - 1) ? (u.x = i, u.y = r, f = this._mtx.transformPoint(u.x, u.y), u.x = f.x, u.y = f.y) : this.mouseMoveOutside && (u.x = i < 0 ? 0 : e - 1 < i ? e - 1 : i, u.y = r < 0 ? 0 : o - 1 < r ? o - 1 : r, f = this._mtx.transformPoint(u.x, u.y), u.x = f.x, u.y = f.y), u.rawX = i, u.rawY = r, f = this._mtx.transformPoint(u.rawX, u.rawY), u.rawX = f.x, u.rawY = f.y) : ((u.inBounds = 0 <= i && 0 <= r && i <= e - 1 && r <= o - 1) ? (u.x = i, u.y = r) : this.mouseMoveOutside && (u.x = i < 0 ? 0 : e - 1 < i ? e - 1 : i, u.y = r < 0 ? 0 : o - 1 < r ? o - 1 : r), u.rawX = i, u.rawY = r);
            u.posEvtObj = t;
            n !== this._primaryPointerID && -1 !== n || (this.mouseX = u.x, this.mouseY = u.y, this.mouseInBounds = u.inBounds)
        };
        n._handleMouseUp = function(n) {
            this._handlePointerUp(-1, n, !1)
        };
        n._handlePointerUp = function(n, t, i, r) {
            var f, e, o = this._nextStage,
                u = this._getPointerData(n);
            this._prevStage && void 0 === r || (f = null, e = u.target, r || !e && !o || (f = this._getObjectsUnderPoint(u.x, u.y, null, !0)), u.down && (this._dispatchMouseEvent(this, "stagemouseup", !1, n, u, t, f), u.down = !1), f == e && this._dispatchMouseEvent(e, "click", !0, n, u, t), this._dispatchMouseEvent(e, "pressup", !0, n, u, t), i ? (n == this._primaryPointerID && (this._primaryPointerID = null), delete this._pointerData[n]) : u.target = null, o && o._handlePointerUp(n, t, i, r || f && this))
        };
        n._handleMouseDown = function(n) {
            this._handlePointerDown(-1, n, n.pageX, n.pageY)
        };
        n._handlePointerDown = function(n, t, i, r, u) {
            this.preventSelection && t.preventDefault();
            null != this._primaryPointerID && -1 !== n || (this._primaryPointerID = n);
            null != r && this._updatePointerPosition(n, t, i, r);
            var e = null,
                o = this._nextStage,
                f = this._getPointerData(n);
            u || (e = f.target = this._getObjectsUnderPoint(f.x, f.y, null, !0));
            f.inBounds && (this._dispatchMouseEvent(this, "stagemousedown", !1, n, f, t, e), f.down = !0);
            this._dispatchMouseEvent(e, "mousedown", !0, n, f, t);
            o && o._handlePointerDown(n, t, i, r, u || e && this)
        };
        n._testMouseOver = function(n, t, i) {
            var o, f;
            if (!this._prevStage || void 0 !== t)
                if (o = this._nextStage, this._mouseOverIntervalID) {
                    if (this.canvas) {
                        if (f = this._getPointerData(-1), !f || !n && this.mouseX == this._mouseOverX && this.mouseY == this._mouseOverY && this.mouseInBounds) return;
                        var r, y, e = f.posEvtObj,
                            p = i || e && e.target == this.canvas,
                            u = null,
                            v = -1,
                            a = "";
                        !t && (n || this.mouseInBounds && p) && (u = this._getObjectsUnderPoint(this.mouseX, this.mouseY, null, !0), this._mouseOverX = this.mouseX, this._mouseOverY = this.mouseY);
                        for (var s = this._mouseOverTarget || [], h = s[s.length - 1], c = this._mouseOverTarget = [], l = u; l;) c.unshift(l), a = a || l.cursor, l = l.parent;
                        for (this.canvas.style.cursor = a, !t && i && (i.canvas.style.cursor = a), r = 0, y = c.length; r < y && c[r] == s[r]; r++) v = r;
                        for (h != u && this._dispatchMouseEvent(h, "mouseout", !0, -1, f, e, u), r = s.length - 1; v < r; r--) this._dispatchMouseEvent(s[r], "rollout", !1, -1, f, e, u);
                        for (r = c.length - 1; v < r; r--) this._dispatchMouseEvent(c[r], "rollover", !1, -1, f, e, h);
                        h != u && this._dispatchMouseEvent(u, "mouseover", !0, -1, f, e, h)
                    }
                    o && o._testMouseOver(n, t || u && this, i || p && this)
                } else o && o._testMouseOver(n, t, i)
        };
        n._handleDoubleClick = function(n, t) {
            var i = null,
                u = this._nextStage,
                r = this._getPointerData(-1);
            t || (i = this._getObjectsUnderPoint(r.x, r.y, null, !0), this._dispatchMouseEvent(i, "dblclick", !0, -1, r, n));
            u && u._handleDoubleClick(n, t || i && this)
        };
        n._dispatchMouseEvent = function(n, t, i, r, u, f, e) {
            n && (i || n.hasEventListener(t)) && (e = new createjs.MouseEvent(t, i, !1, u.x, u.y, f, r, r === this._primaryPointerID || -1 === r, u.rawX, u.rawY, e), n.dispatchEvent(e))
        };
        createjs.Stage = createjs.promote(t, "Container")
    }(),
    function() {
        "use strict";

        function n(t, i) {
            if (this.Stage_constructor(t), void 0 !== i) {
                if ("object" != typeof i) throw "Invalid options object";
                var r = i.premultiply,
                    u = i.transparent,
                    f = i.antialias,
                    e = i.preserveBuffer,
                    o = i.autoPurge
            }
            this.vocalDebug = !1;
            this._preserveBuffer = e || !1;
            this._antialias = f || !1;
            this._transparent = u || !1;
            this._premultiply = r || !1;
            this._autoPurge = void 0;
            this.autoPurge = o;
            this._viewportWidth = 0;
            this._viewportHeight = 0;
            this._projectionMatrix = null;
            this._webGLContext = null;
            this._clearColor = {
                r: .5,
                g: .5,
                b: .5,
                a: 0
            };
            this._maxCardsPerBatch = n.DEFAULT_MAX_BATCH_SIZE;
            this._activeShader = null;
            this._vertices = null;
            this._vertexPositionBuffer = null;
            this._uvs = null;
            this._uvPositionBuffer = null;
            this._indices = null;
            this._textureIndexBuffer = null;
            this._alphas = null;
            this._alphaBuffer = null;
            this._textureDictionary = [];
            this._textureIDs = {};
            this._batchTextures = [];
            this._baseTextures = [];
            this._batchTextureCount = 8;
            this._lastTextureInsert = -1;
            this._batchID = 0;
            this._drawID = 0;
            this._slotBlacklist = [];
            this._isDrawing = 0;
            this._lastTrackedCanvas = 0;
            this.isCacheControlled = !1;
            this._cacheContainer = new createjs.Container;
            this._initializeWebGL()
        }
        var t = createjs.extend(n, createjs.Stage);
        n.buildUVRects = function(n, t, i) {
            var u, r;
            if (!n || !n._frames) return null;
            void 0 === t && (t = -1);
            void 0 === i && (i = !1);
            for (var e = -1 != t && i ? t : 0, o = -1 != t && i ? t + 1 : n._frames.length, f = e; f < o; f++) r = n._frames[f], r.uvRect || r.image.width <= 0 || r.image.height <= 0 || (u = r.rect, r.uvRect = {
                t: u.y / r.image.height,
                l: u.x / r.image.width,
                b: (u.y + u.height) / r.image.height,
                r: (u.x + u.width) / r.image.width
            });
            return n._frames[-1 != t ? t : 0].uvRect || {
                t: 0,
                l: 0,
                b: 1,
                r: 1
            }
        };
        n.isWebGLActive = function(n) {
            return n && n instanceof WebGLRenderingContext && "undefined" != typeof WebGLRenderingContext
        };
        n.VERTEX_PROPERTY_COUNT = 6;
        n.INDICIES_PER_CARD = 6;
        n.DEFAULT_MAX_BATCH_SIZE = 1e4;
        n.WEBGL_MAX_INDEX_NUM = Math.pow(2, 16);
        n.UV_RECT = {
            t: 0,
            l: 0,
            b: 1,
            r: 1
        };
        try {
            n.COVER_VERT = new Float32Array([-1, 1, 1, 1, -1, -1, 1, 1, 1, -1, -1, -1]);
            n.COVER_UV = new Float32Array([0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1]);
            n.COVER_UV_FLIP = new Float32Array([0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0])
        } catch (t) {}
        n.REGULAR_VERTEX_HEADER = (n.REGULAR_VARYING_HEADER = "precision mediump float;varying vec2 vTextureCoord;varying lowp float indexPicker;varying lowp float alphaValue;") + "attribute vec2 vertexPosition;attribute vec2 uvPosition;attribute lowp float textureIndex;attribute lowp float objectAlpha;uniform mat4 pMatrix;";
        n.REGULAR_FRAGMENT_HEADER = n.REGULAR_VARYING_HEADER + "uniform sampler2D uSampler[{{count}}];";
        n.REGULAR_VERTEX_BODY = "void main(void) {gl_Position = vec4((vertexPosition.x * pMatrix[0][0]) + pMatrix[3][0],(vertexPosition.y * pMatrix[1][1]) + pMatrix[3][1],pMatrix[3][2],1.0);alphaValue = objectAlpha;indexPicker = textureIndex;vTextureCoord = uvPosition;}";
        n.REGULAR_FRAGMENT_BODY = "void main(void) {vec4 color = vec4(1.0, 0.0, 0.0, 1.0);if (indexPicker <= 0.5) {color = texture2D(uSampler[0], vTextureCoord);{{alternates}}}{{fragColor}}}";
        n.REGULAR_FRAG_COLOR_NORMAL = "gl_FragColor = vec4(color.rgb, color.a * alphaValue);";
        n.REGULAR_FRAG_COLOR_PREMULTIPLY = "if(color.a > 0.0035) {gl_FragColor = vec4(color.rgb/color.a, color.a * alphaValue);} else {gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);}";
        n.PARTICLE_VERTEX_BODY = n.REGULAR_VERTEX_BODY;
        n.PARTICLE_FRAGMENT_BODY = n.REGULAR_FRAGMENT_BODY;
        n.COVER_VERTEX_HEADER = (n.COVER_VARYING_HEADER = "precision mediump float;varying highp vec2 vRenderCoord;varying highp vec2 vTextureCoord;") + "attribute vec2 vertexPosition;attribute vec2 uvPosition;uniform float uUpright;";
        n.COVER_FRAGMENT_HEADER = n.COVER_VARYING_HEADER + "uniform sampler2D uSampler;";
        n.COVER_VERTEX_BODY = "void main(void) {gl_Position = vec4(vertexPosition.x, vertexPosition.y, 0.0, 1.0);vRenderCoord = uvPosition;vTextureCoord = vec2(uvPosition.x, abs(uUpright - uvPosition.y));}";
        n.COVER_FRAGMENT_BODY = "void main(void) {vec4 color = texture2D(uSampler, vRenderCoord);gl_FragColor = color;}";
        t._get_isWebGL = function() {
            return !!this._webGLContext
        };
        t._set_autoPurge = function(n) {
            -1 != (n = isNaN(n) ? 1200 : n) && (n = n < 10 ? 10 : n);
            this._autoPurge = n
        };
        t._get_autoPurge = function() {
            return Number(this._autoPurge)
        };
        try {
            Object.defineProperties(t, {
                isWebGL: {
                    get: t._get_isWebGL
                },
                autoPurge: {
                    get: t._get_autoPurge,
                    set: t._set_autoPurge
                }
            })
        } catch (t) {}
        t._initializeWebGL = function() {
            if (this.canvas) {
                if (!this._webGLContext || this._webGLContext.canvas !== this.canvas) {
                    var n = {
                            depth: !1,
                            alpha: this._transparent,
                            stencil: !0,
                            antialias: this._antialias,
                            premultipliedAlpha: this._premultiply,
                            preserveDrawingBuffer: this._preserveBuffer
                        },
                        n = this._webGLContext = this._fetchWebGLContext(this.canvas, n);
                    if (!n) return null;
                    this.updateSimultaneousTextureCount(n.getParameter(n.MAX_TEXTURE_IMAGE_UNITS));
                    this._maxTextureSlots = n.getParameter(n.MAX_COMBINED_TEXTURE_IMAGE_UNITS);
                    this._createBuffers(n);
                    this._initTextures(n);
                    n.disable(n.DEPTH_TEST);
                    n.enable(n.BLEND);
                    n.blendFuncSeparate(n.SRC_ALPHA, n.ONE_MINUS_SRC_ALPHA, n.ONE, n.ONE_MINUS_SRC_ALPHA);
                    n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL, this._premultiply);
                    this._webGLContext.clearColor(this._clearColor.r, this._clearColor.g, this._clearColor.b, this._clearColor.a);
                    this.updateViewport(this._viewportWidth || this.canvas.width, this._viewportHeight || this.canvas.height)
                }
            } else this._webGLContext = null;
            return this._webGLContext
        };
        t.update = function(n) {
            this.canvas && (this.tickOnUpdate && this.tick(n), this.dispatchEvent("drawstart"), this.autoClear && this.clear(), this._webGLContext ? (this._batchDraw(this, this._webGLContext), -1 == this._autoPurge || this._drawID % (this._autoPurge / 2 | 0) || this.purgeTextures(this._autoPurge)) : ((n = this.canvas.getContext("2d")).save(), this.updateContext(n), this.draw(n, !1), n.restore()), this.dispatchEvent("drawend"))
        };
        t.clear = function() {
            var r, t, i;
            this.canvas && (n.isWebGLActive(this._webGLContext) ? (r = this._webGLContext, t = this._clearColor, i = this._transparent ? t.a : 1, this._webGLContext.clearColor(t.r * i, t.g * i, t.b * i, i), r.clear(r.COLOR_BUFFER_BIT), this._webGLContext.clearColor(t.r, t.g, t.b, t.a)) : this.Stage_clear())
        };
        t.draw = function(t, i) {
            if (t === this._webGLContext && n.isWebGLActive(this._webGLContext)) {
                var r = this._webGLContext;
                return this._batchDraw(this, r, i), !0
            }
            return this.Stage_draw(t, i)
        };
        t.cacheDraw = function(t, i, r) {
            if (n.isWebGLActive(this._webGLContext)) {
                var u = this._webGLContext;
                return this._cacheDraw(u, t, i, r), !0
            }
            return !1
        };
        t.protectTextureSlot = function(n, t) {
            if (n > this._maxTextureSlots || n < 0) throw "Slot outside of acceptable range";
            this._slotBlacklist[n] = !!t
        };
        t.getTargetRenderTexture = function(n, t, i) {
            var u = !1,
                r = this._webGLContext;
            if (void 0 !== n.__lastRT && n.__lastRT === n.__rtA && (u = !0), !(r = u ? (void 0 === n.__rtB ? n.__rtB = this.getRenderBufferTexture(t, i) : (t == n.__rtB._width && i == n.__rtB._height || this.resizeTexture(n.__rtB, t, i), this.setTextureParams(r)), n.__rtB) : (void 0 === n.__rtA ? n.__rtA = this.getRenderBufferTexture(t, i) : (t == n.__rtA._width && i == n.__rtA._height || this.resizeTexture(n.__rtA, t, i), this.setTextureParams(r)), n.__rtA))) throw "Problems creating render textures, known causes include using too much VRAM by not releasing WebGL texture instances";
            return n.__lastRT = r
        };
        t.releaseTexture = function(n) {
            var t, r, i;
            if (n) {
                if (n.children)
                    for (t = 0, r = n.children.length; t < r; t++) this.releaseTexture(n.children[t]);
                if (n.cacheCanvas && n.uncache(), i = void 0, void 0 !== n._storeID) {
                    if (n === this._textureDictionary[n._storeID]) return this._killTextureObject(n), void(n._storeID = void 0);
                    i = n
                } else if (2 === n._webGLRenderStyle) i = n.image;
                else if (1 === n._webGLRenderStyle) {
                    for (t = 0, r = n.spriteSheet._images.length; t < r; t++) this.releaseTexture(n.spriteSheet._images[t]);
                    return
                }
                void 0 !== i ? (this._killTextureObject(this._textureDictionary[i._storeID]), i._storeID = void 0) : this.vocalDebug && console.log("No associated texture found on release")
            }
        };
        t.purgeTextures = function(n) {
            var t;
            null == n && (n = 100);
            for (var r = this._textureDictionary, u = r.length, i = 0; i < u; i++) t = r[i], t && t._drawID + n <= this._drawID && this._killTextureObject(t)
        };
        t.updateSimultaneousTextureCount = function(n) {
            var i = this._webGLContext,
                t = !1;
            for ((n < 1 || isNaN(n)) && (n = 1), this._batchTextureCount = n; !t;) try {
                this._activeShader = this._fetchShaderProgram(i);
                t = !0
            } catch (n) {
                if (1 == this._batchTextureCount) throw "Cannot compile shader " + n;
                this._batchTextureCount -= 4;
                this._batchTextureCount < 1 && (this._batchTextureCount = 1);
                this.vocalDebug && console.log("Reducing desired texture count due to errors: " + this._batchTextureCount)
            }
        };
        t.updateViewport = function(n, t) {
            this._viewportWidth = 0 | n;
            this._viewportHeight = 0 | t;
            t = this._webGLContext;
            t && (t.viewport(0, 0, this._viewportWidth, this._viewportHeight), this._projectionMatrix = new Float32Array([2 / this._viewportWidth, 0, 0, 0, 0, -2 / this._viewportHeight, 1, 0, 0, 0, 1, 0, -1, 1, .1, 0]), this._projectionMatrixFlip = new Float32Array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]), this._projectionMatrixFlip.set(this._projectionMatrix), this._projectionMatrixFlip[5] *= -1, this._projectionMatrixFlip[13] *= -1)
        };
        t.getFilterShader = function(n) {
            n = n || this;
            var i = this._webGLContext,
                t = this._activeShader;
            if (n._builtShader) t = n._builtShader, n.shaderParamSetup && (i.useProgram(t), n.shaderParamSetup(i, this, t));
            else try {
                t = this._fetchShaderProgram(i, "filter", n.VTX_SHADER_BODY, n.FRAG_SHADER_BODY, n.shaderParamSetup && n.shaderParamSetup.bind(n));
                (n._builtShader = t)._name = n.toString()
            } catch (n) {
                console && console.log("SHADER SWITCH FAILURE", n)
            }
            return t
        };
        t.getBaseTexture = function(n, t) {
            var i = Math.ceil(0 < n ? n : 1) || 1,
                r = Math.ceil(0 < t ? t : 1) || 1,
                n = this._webGLContext,
                t = n.createTexture();
            return this.resizeTexture(t, i, r), this.setTextureParams(n, !1), t
        };
        t.resizeTexture = function(n, t, i) {
            var r = this._webGLContext;
            r.bindTexture(r.TEXTURE_2D, n);
            r.texImage2D(r.TEXTURE_2D, 0, r.RGBA, t, i, 0, r.RGBA, r.UNSIGNED_BYTE, null);
            n.width = t;
            n.height = i
        };
        t.getRenderBufferTexture = function(n, t) {
            var i = this._webGLContext,
                r = this.getBaseTexture(n, t),
                u;
            return r ? (u = i.createFramebuffer(), u ? (r.width = n, r.height = t, i.bindFramebuffer(i.FRAMEBUFFER, u), i.framebufferTexture2D(i.FRAMEBUFFER, i.COLOR_ATTACHMENT0, i.TEXTURE_2D, r, 0), (u._renderTexture = r)._frameBuffer = u, r._storeID = this._textureDictionary.length, this._textureDictionary[r._storeID] = r, i.bindFramebuffer(i.FRAMEBUFFER, null), r) : null) : null
        };
        t.setTextureParams = function(n, t) {
            t && this._antialias ? (n.texParameteri(n.TEXTURE_2D, n.TEXTURE_MIN_FILTER, n.LINEAR), n.texParameteri(n.TEXTURE_2D, n.TEXTURE_MAG_FILTER, n.LINEAR)) : (n.texParameteri(n.TEXTURE_2D, n.TEXTURE_MIN_FILTER, n.NEAREST), n.texParameteri(n.TEXTURE_2D, n.TEXTURE_MAG_FILTER, n.NEAREST));
            n.texParameteri(n.TEXTURE_2D, n.TEXTURE_WRAP_S, n.CLAMP_TO_EDGE);
            n.texParameteri(n.TEXTURE_2D, n.TEXTURE_WRAP_T, n.CLAMP_TO_EDGE)
        };
        t.setClearColor = function(n) {
            var i, r, u, f, t;
            "string" == typeof n ? 0 == n.indexOf("#") ? (4 == n.length && (n = "#" + n.charAt(1) + n.charAt(1) + n.charAt(2) + n.charAt(2) + n.charAt(3) + n.charAt(3)), i = Number("0x" + n.slice(1, 3)) / 255, r = Number("0x" + n.slice(3, 5)) / 255, u = Number("0x" + n.slice(5, 7)) / 255, f = Number("0x" + n.slice(7, 9)) / 255) : 0 == n.indexOf("rgba(") && (t = n.slice(5, -1).split(","), i = Number(t[0]) / 255, r = Number(t[1]) / 255, u = Number(t[2]) / 255, f = Number(t[3])) : (i = ((4278190080 & n) >>> 24) / 255, r = ((16711680 & n) >>> 16) / 255, u = ((65280 & n) >>> 8) / 255, f = (255 & n) / 255);
            this._clearColor.r = i || 0;
            this._clearColor.g = r || 0;
            this._clearColor.b = u || 0;
            this._clearColor.a = f || 0;
            this._webGLContext && this._webGLContext.clearColor(this._clearColor.r, this._clearColor.g, this._clearColor.b, this._clearColor.a)
        };
        t.toString = function() {
            return "[StageGL (name=" + this.name + ")]"
        };
        t._fetchWebGLContext = function(n, t) {
            var i, r;
            try {
                i = n.getContext("webgl", t) || n.getContext("experimental-webgl", t)
            } catch (n) {}
            return i ? (i.viewportWidth = n.width, i.viewportHeight = n.height) : (r = "Could not initialize WebGL", console.error ? console.error(r) : console.log(r)), i
        };
        t._fetchShaderProgram = function(t, i, r, u, f) {
            var o, s, c, h;
            switch (t.useProgram(null), i) {
                case "filter":
                    s = n.COVER_VERTEX_HEADER + (r || n.COVER_VERTEX_BODY);
                    o = n.COVER_FRAGMENT_HEADER + (u || n.COVER_FRAGMENT_BODY);
                    break;
                case "particle":
                    s = n.REGULAR_VERTEX_HEADER + n.PARTICLE_VERTEX_BODY;
                    o = n.REGULAR_FRAGMENT_HEADER + n.PARTICLE_FRAGMENT_BODY;
                    break;
                case "override":
                    s = n.REGULAR_VERTEX_HEADER + (r || n.REGULAR_VERTEX_BODY);
                    o = n.REGULAR_FRAGMENT_HEADER + (u || n.REGULAR_FRAGMENT_BODY);
                    break;
                case "regular":
                default:
                    s = n.REGULAR_VERTEX_HEADER + n.REGULAR_VERTEX_BODY;
                    o = n.REGULAR_FRAGMENT_HEADER + n.REGULAR_FRAGMENT_BODY
            }
            var l = this._createShader(t, t.VERTEX_SHADER, s),
                a = this._createShader(t, t.FRAGMENT_SHADER, o),
                e = t.createProgram();
            if (t.attachShader(e, l), t.attachShader(e, a), t.linkProgram(e), e._type = i, !t.getProgramParameter(e, t.LINK_STATUS)) throw t.useProgram(this._activeShader), t.getProgramInfoLog(e);
            switch (t.useProgram(e), i) {
                case "filter":
                    e.vertexPositionAttribute = t.getAttribLocation(e, "vertexPosition");
                    t.enableVertexAttribArray(e.vertexPositionAttribute);
                    e.uvPositionAttribute = t.getAttribLocation(e, "uvPosition");
                    t.enableVertexAttribArray(e.uvPositionAttribute);
                    e.samplerUniform = t.getUniformLocation(e, "uSampler");
                    t.uniform1i(e.samplerUniform, 0);
                    e.uprightUniform = t.getUniformLocation(e, "uUpright");
                    t.uniform1f(e.uprightUniform, 0);
                    f && f(t, this, e);
                    break;
                case "override":
                case "particle":
                case "regular":
                default:
                    for (e.vertexPositionAttribute = t.getAttribLocation(e, "vertexPosition"), t.enableVertexAttribArray(e.vertexPositionAttribute), e.uvPositionAttribute = t.getAttribLocation(e, "uvPosition"), t.enableVertexAttribArray(e.uvPositionAttribute), e.textureIndexAttribute = t.getAttribLocation(e, "textureIndex"), t.enableVertexAttribArray(e.textureIndexAttribute), e.alphaAttribute = t.getAttribLocation(e, "objectAlpha"), t.enableVertexAttribArray(e.alphaAttribute), c = [], h = 0; h < this._batchTextureCount; h++) c[h] = h;
                    e.samplerData = c;
                    e.samplerUniform = t.getUniformLocation(e, "uSampler");
                    t.uniform1iv(e.samplerUniform, c);
                    e.pMatrixUniform = t.getUniformLocation(e, "pMatrix")
            }
            return t.useProgram(this._activeShader), e
        };
        t._createShader = function(t, i, r) {
            r = r.replace(/{{count}}/g, this._batchTextureCount);
            for (var f = "", u = 1; u < this._batchTextureCount; u++) f += "} else if (indexPicker <= " + u + ".5) { color = texture2D(uSampler[" + u + "], vTextureCoord);";
            if (r = (r = r.replace(/{{alternates}}/g, f)).replace(/{{fragColor}}/g, this._premultiply ? n.REGULAR_FRAG_COLOR_PREMULTIPLY : n.REGULAR_FRAG_COLOR_NORMAL), i = t.createShader(i), t.shaderSource(i, r), t.compileShader(i), !t.getShaderParameter(i, t.COMPILE_STATUS)) throw t.getShaderInfoLog(i);
            return i
        };
        t._createBuffers = function(t) {
            var u, f = this._maxCardsPerBatch * n.INDICIES_PER_CARD,
                r = this._vertexPositionBuffer = t.createBuffer(),
                o, h, c;
            t.bindBuffer(t.ARRAY_BUFFER, r);
            u = 2;
            for (var s = this._vertices = new Float32Array(f * u), i = 0, e = s.length; i < e; i += u) s[i] = s[i + 1] = 0;
            for (t.bufferData(t.ARRAY_BUFFER, s, t.DYNAMIC_DRAW), r.itemSize = u, r.numItems = f, r = this._uvPositionBuffer = t.createBuffer(), t.bindBuffer(t.ARRAY_BUFFER, r), u = 2, o = this._uvs = new Float32Array(f * u), i = 0, e = o.length; i < e; i += u) o[i] = o[i + 1] = 0;
            for (t.bufferData(t.ARRAY_BUFFER, o, t.DYNAMIC_DRAW), r.itemSize = u, r.numItems = f, r = this._textureIndexBuffer = t.createBuffer(), t.bindBuffer(t.ARRAY_BUFFER, r), u = 1, h = this._indices = new Float32Array(f * u), i = 0, e = h.length; i < e; i++) h[i] = 0;
            for (t.bufferData(t.ARRAY_BUFFER, h, t.DYNAMIC_DRAW), r.itemSize = u, r.numItems = f, r = this._alphaBuffer = t.createBuffer(), t.bindBuffer(t.ARRAY_BUFFER, r), u = 1, c = this._alphas = new Float32Array(f * u), i = 0, e = c.length; i < e; i++) c[i] = 1;
            t.bufferData(t.ARRAY_BUFFER, c, t.DYNAMIC_DRAW);
            r.itemSize = u;
            r.numItems = f
        };
        t._initTextures = function() {
            var n, t;
            for (this._lastTextureInsert = -1, this._textureDictionary = [], this._textureIDs = {}, this._baseTextures = [], this._batchTextures = [], n = 0; n < this._batchTextureCount; n++)
                if (t = this.getBaseTexture(), !(this._baseTextures[n] = this._batchTextures[n] = t)) throw "Problems creating basic textures, known causes include using too much VRAM by not releasing WebGL texture instances";
        };
        t._loadTextureImage = function(n, t) {
            var i = t.src,
                r;
            return i || (t._isCanvas = !0, i = t.src = "canvas_" + this._lastTrackedCanvas++), r = this._textureIDs[i], void 0 === r && (r = this._textureIDs[i] = this._textureDictionary.length), void 0 === this._textureDictionary[r] && (this._textureDictionary[r] = this.getBaseTexture()), i = this._textureDictionary[r], i ? (i._batchID = this._batchID, i._storeID = r, i._imageData = t, this._insertTextureInBatch(n, i), t._storeID = r, t.complete || t.naturalWidth || t._isCanvas ? this._updateTextureImageData(n, t) : t.addEventListener("load", this._updateTextureImageData.bind(this, n, t))) : (t = "Problem creating desired texture, known causes include using too much VRAM by not releasing WebGL texture instances", console.error && console.error(t) || console.log(t), (i = this._baseTextures[0])._batchID = this._batchID, i._storeID = -1, i._imageData = i, this._insertTextureInBatch(n, i)), i
        };
        t._updateTextureImageData = function(n, t) {
            var u = t.width & t.width - 1 || t.height & t.height - 1,
                i = this._textureDictionary[t._storeID],
                r;
            n.activeTexture(n.TEXTURE0 + i._activeIndex);
            n.bindTexture(n.TEXTURE_2D, i);
            i.isPOT = !u;
            this.setTextureParams(n, i.isPOT);
            try {
                n.texImage2D(n.TEXTURE_2D, 0, n.RGBA, n.RGBA, n.UNSIGNED_BYTE, t)
            } catch (n) {
                r = "\nAn error has occurred. This is most likely due to security restrictions on WebGL images with local or cross-domain origins";
                console.error ? (console.error(r), console.error(n)) : console && (console.log(r), console.log(n))
            }
            t._invalid = !1;
            i._w = t.width;
            i._h = t.height;
            this.vocalDebug && (u && console.warn("NPOT(Non Power of Two) Texture: " + t.src), (t.width > n.MAX_TEXTURE_SIZE || t.height > n.MAX_TEXTURE_SIZE) && console && console.error("Oversized Texture: " + t.width + "x" + t.height + " vs " + n.MAX_TEXTURE_SIZE + "max"))
        };
        t._insertTextureInBatch = function(n, t) {
            var r;
            if (this._batchTextures[t._activeIndex] !== t) {
                var i = -1,
                    f = (this._lastTextureInsert + 1) % this._batchTextureCount,
                    u = f;
                do
                    if (this._batchTextures[u]._batchID != this._batchID && !this._slotBlacklist[u]) {
                        i = u;
                        break
                    }
                while ((u = (u + 1) % this._batchTextureCount) !== f); -
                1 === i && (this.batchReason = "textureOverflow", this._drawBuffers(n), this.batchCardCount = 0, i = f);
                (this._batchTextures[i] = t)._activeIndex = i;
                (r = t._imageData) && r._invalid && void 0 !== t._drawID ? this._updateTextureImageData(n, r) : (n.activeTexture(n.TEXTURE0 + i), n.bindTexture(n.TEXTURE_2D, t), this.setTextureParams(n));
                this._lastTextureInsert = i
            } else r = t._imageData, null != t._storeID && r && r._invalid && this._updateTextureImageData(n, r);
            t._drawID = this._drawID;
            t._batchID = this._batchID
        };
        t._killTextureObject = function(n) {
            var t, i;
            if (n) {
                if (t = this._webGLContext, void 0 !== n._storeID && 0 <= n._storeID) {
                    for (i in this._textureDictionary[n._storeID] = void 0, this._textureIDs) this._textureIDs[i] == n._storeID && delete this._textureIDs[i];
                    n._imageData && (n._imageData._storeID = void 0);
                    n._imageData = n._storeID = void 0
                }
                void 0 !== n._activeIndex && this._batchTextures[n._activeIndex] === n && (this._batchTextures[n._activeIndex] = this._baseTextures[n._activeIndex]);
                try {
                    n._frameBuffer && t.deleteFramebuffer(n._frameBuffer);
                    n._frameBuffer = void 0
                } catch (n) {
                    this.vocalDebug && console.log(n)
                }
                try {
                    t.deleteTexture(n)
                } catch (n) {
                    this.vocalDebug && console.log(n)
                }
            }
        };
        t._backupBatchTextures = function(n, t) {
            var r = this._webGLContext,
                i;
            for (this._backupTextures || (this._backupTextures = []), void 0 === t && (t = this._backupTextures), i = 0; i < this._batchTextureCount; i++) r.activeTexture(r.TEXTURE0 + i), n ? this._batchTextures[i] = t[i] : (t[i] = this._batchTextures[i], this._batchTextures[i] = this._baseTextures[i]), r.bindTexture(r.TEXTURE_2D, this._batchTextures[i]), this.setTextureParams(r, this._batchTextures[i].isPOT);
            n && t === this._backupTextures && (this._backupTextures = [])
        };
        t._batchDraw = function(n, t, i) {
            0 < this._isDrawing && this._drawBuffers(t);
            this._isDrawing++;
            this._drawID++;
            this.batchCardCount = 0;
            this.depth = 0;
            this._appendToBatchGroup(n, t, new createjs.Matrix2D, this.alpha, i);
            this.batchReason = "drawFinish";
            this._drawBuffers(t);
            this._isDrawing--
        };
        t._cacheDraw = function(n, t, i, r) {
            var o = this._activeShader,
                s = this._slotBlacklist,
                e = this._maxTextureSlots - 1,
                h = this._viewportWidth,
                c = this._viewportHeight,
                u, f;
            this.protectTextureSlot(e, !0);
            u = t.getMatrix();
            (u = u.clone()).scale(1 / r.scale, 1 / r.scale);
            (u = u.invert()).translate(-r.offX / r.scale * t.scaleX, -r.offY / r.scale * t.scaleY);
            f = this._cacheContainer;
            f.children = [t];
            f.transformMatrix = u;
            this._backupBatchTextures(!1);
            i && i.length ? this._drawFilters(t, i, r) : this.isCacheControlled ? (n.clear(n.COLOR_BUFFER_BIT), this._batchDraw(f, n, !0)) : (n.activeTexture(n.TEXTURE0 + e), t.cacheCanvas = this.getTargetRenderTexture(t, r._drawWidth, r._drawHeight), t = t.cacheCanvas, n.bindFramebuffer(n.FRAMEBUFFER, t._frameBuffer), this.updateViewport(r._drawWidth, r._drawHeight), this._projectionMatrix = this._projectionMatrixFlip, n.clear(n.COLOR_BUFFER_BIT), this._batchDraw(f, n, !0), n.bindFramebuffer(n.FRAMEBUFFER, null), this.updateViewport(h, c));
            this._backupBatchTextures(!0);
            this.protectTextureSlot(e, !1);
            this._activeShader = o;
            this._slotBlacklist = s
        };
        t._drawFilters = function(n, t, i) {
            var u, r = this._webGLContext,
                o = this._maxTextureSlots - 1,
                s = this._viewportWidth,
                h = this._viewportHeight,
                l = this._cacheContainer,
                a = t.length;
            r.activeTexture(r.TEXTURE0 + o);
            u = this.getTargetRenderTexture(n, i._drawWidth, i._drawHeight);
            r.bindFramebuffer(r.FRAMEBUFFER, u._frameBuffer);
            this.updateViewport(i._drawWidth, i._drawHeight);
            r.clear(r.COLOR_BUFFER_BIT);
            this._batchDraw(l, r, !0);
            r.activeTexture(r.TEXTURE0);
            r.bindTexture(r.TEXTURE_2D, u);
            this.setTextureParams(r);
            for (var f = !1, c = 0, e = t[c]; this._activeShader = this.getFilterShader(e), this._activeShader && (r.activeTexture(r.TEXTURE0 + o), u = this.getTargetRenderTexture(n, i._drawWidth, i._drawHeight), r.bindFramebuffer(r.FRAMEBUFFER, u._frameBuffer), r.viewport(0, 0, i._drawWidth, i._drawHeight), r.clear(r.COLOR_BUFFER_BIT), this._drawCover(r, f), r.activeTexture(r.TEXTURE0), r.bindTexture(r.TEXTURE_2D, u), this.setTextureParams(r), (1 < a || t[0]._multiPass) && (f = !f), e = null !== e._multiPass ? e._multiPass : t[++c]), e;);
            this.isCacheControlled ? (r.bindFramebuffer(r.FRAMEBUFFER, null), this.updateViewport(s, h), this._activeShader = this.getFilterShader(this), r.clear(r.COLOR_BUFFER_BIT), this._drawCover(r, f)) : (f && (r.activeTexture(r.TEXTURE0 + o), u = this.getTargetRenderTexture(n, i._drawWidth, i._drawHeight), r.bindFramebuffer(r.FRAMEBUFFER, u._frameBuffer), this._activeShader = this.getFilterShader(this), r.viewport(0, 0, i._drawWidth, i._drawHeight), r.clear(r.COLOR_BUFFER_BIT), this._drawCover(r, !f)), r.bindFramebuffer(r.FRAMEBUFFER, null), this.updateViewport(s, h), n.cacheCanvas = u)
        };
        t._appendToBatchGroup = function(t, i, r, u, f) {
            var p, w, b, d, g, ut, rt, e, v, k, nt, h, s, l, ft, c, o;
            for (t._glMtx || (t._glMtx = new createjs.Matrix2D), g = t._glMtx, g.copy(r), t.transformMatrix ? g.appendMatrix(t.transformMatrix) : g.appendTransform(t.x, t.y, t.scaleX, t.scaleY, t.rotation, t.skewX, t.skewY, t.regX, t.regY), ut = t.children.length, rt = 0; rt < ut; rt++)
                if (e = t.children[rt], e.visible && u)
                    if ((!e.cacheCanvas || f) && (e._updateState && e._updateState(), e.children)) this._appendToBatchGroup(e, i, g, e.alpha * u);
                    else {
                        if (this.batchCardCount + 1 > this._maxCardsPerBatch && (this.batchReason = "vertexOverflow", this._drawBuffers(i), this.batchCardCount = 0), e._glMtx || (e._glMtx = new createjs.Matrix2D), s = e._glMtx, s.copy(g), e.transformMatrix ? s.appendMatrix(e.transformMatrix) : s.appendTransform(e.x, e.y, e.scaleX, e.scaleY, e.rotation, e.skewX, e.skewY, e.regX, e.regY), c = e.cacheCanvas && !f, 2 === e._webGLRenderStyle || c) v = !f && e.cacheCanvas || e.image;
                        else {
                            if (1 !== e._webGLRenderStyle) continue;
                            if (null === (k = e.spriteSheet.getFrame(e.currentFrame))) continue;
                            v = k.image
                        }
                        var y = this._uvs,
                            a = this._vertices,
                            tt = this._indices,
                            it = this._alphas;
                        if (v) {
                            if (void 0 === v._storeID) nt = this._loadTextureImage(i, v), this._insertTextureInBatch(i, nt);
                            else {
                                if (!(nt = this._textureDictionary[v._storeID])) {
                                    this.vocalDebug && console.log("Texture should not be looked up while not being stored.");
                                    continue
                                }
                                nt._batchID !== this._batchID && this._insertTextureInBatch(i, nt)
                            }
                            ft = nt._activeIndex;
                            2 === e._webGLRenderStyle || c ? d = !c && e.sourceRect ? (e._uvRect || (e._uvRect = {}), h = e.sourceRect, (l = e._uvRect).t = h.y / v.height, l.l = h.x / v.width, l.b = (h.y + h.height) / v.height, l.r = (h.x + h.width) / v.width, w = p = 0, b = h.width + p, h.height + w) : (l = n.UV_RECT, c ? (p = (h = e.bitmapCache).x + h._filterOffX / h.scale, w = h.y + h._filterOffY / h.scale, b = h._drawWidth / h.scale + p, h._drawHeight / h.scale + w) : (w = p = 0, b = v.width + p, v.height + w)) : 1 === e._webGLRenderStyle && (o = k.rect, l = (l = k.uvRect) || n.buildUVRects(e.spriteSheet, e.currentFrame, !1), p = -k.regX, w = -k.regY, b = o.width - k.regX, d = o.height - k.regY);
                            c = this.batchCardCount * n.INDICIES_PER_CARD;
                            o = 2 * c;
                            a[o] = p * s.a + w * s.c + s.tx;
                            a[1 + o] = p * s.b + w * s.d + s.ty;
                            a[2 + o] = p * s.a + d * s.c + s.tx;
                            a[3 + o] = p * s.b + d * s.d + s.ty;
                            a[4 + o] = b * s.a + w * s.c + s.tx;
                            a[5 + o] = b * s.b + w * s.d + s.ty;
                            a[6 + o] = a[2 + o];
                            a[7 + o] = a[3 + o];
                            a[8 + o] = a[4 + o];
                            a[9 + o] = a[5 + o];
                            a[10 + o] = b * s.a + d * s.c + s.tx;
                            a[11 + o] = b * s.b + d * s.d + s.ty;
                            y[o] = l.l;
                            y[1 + o] = l.t;
                            y[2 + o] = l.l;
                            y[3 + o] = l.b;
                            y[4 + o] = l.r;
                            y[5 + o] = l.t;
                            y[6 + o] = l.l;
                            y[7 + o] = l.b;
                            y[8 + o] = l.r;
                            y[9 + o] = l.t;
                            y[10 + o] = l.r;
                            y[11 + o] = l.b;
                            tt[c] = tt[1 + c] = tt[2 + c] = tt[3 + c] = tt[4 + c] = tt[5 + c] = ft;
                            it[c] = it[1 + c] = it[2 + c] = it[3 + c] = it[4 + c] = it[5 + c] = e.alpha * u;
                            this.batchCardCount++
                        }
                    }
        };
        t._drawBuffers = function(t) {
            var r, u;
            if (!(this.batchCardCount <= 0)) {
                this.vocalDebug && console.log("Draw[" + this._drawID + ":" + this._batchID + "] : " + this.batchReason);
                var i = this._activeShader,
                    f = this._vertexPositionBuffer,
                    e = this._textureIndexBuffer,
                    o = this._uvPositionBuffer,
                    s = this._alphaBuffer;
                for (t.useProgram(i), t.bindBuffer(t.ARRAY_BUFFER, f), t.vertexAttribPointer(i.vertexPositionAttribute, f.itemSize, t.FLOAT, !1, 0, 0), t.bufferSubData(t.ARRAY_BUFFER, 0, this._vertices), t.bindBuffer(t.ARRAY_BUFFER, e), t.vertexAttribPointer(i.textureIndexAttribute, e.itemSize, t.FLOAT, !1, 0, 0), t.bufferSubData(t.ARRAY_BUFFER, 0, this._indices), t.bindBuffer(t.ARRAY_BUFFER, o), t.vertexAttribPointer(i.uvPositionAttribute, o.itemSize, t.FLOAT, !1, 0, 0), t.bufferSubData(t.ARRAY_BUFFER, 0, this._uvs), t.bindBuffer(t.ARRAY_BUFFER, s), t.vertexAttribPointer(i.alphaAttribute, s.itemSize, t.FLOAT, !1, 0, 0), t.bufferSubData(t.ARRAY_BUFFER, 0, this._alphas), t.uniformMatrix4fv(i.pMatrixUniform, t.FALSE, this._projectionMatrix), r = 0; r < this._batchTextureCount; r++) u = this._batchTextures[r], t.activeTexture(t.TEXTURE0 + r), t.bindTexture(t.TEXTURE_2D, u), this.setTextureParams(t, u.isPOT);
                t.drawArrays(t.TRIANGLES, 0, this.batchCardCount * n.INDICIES_PER_CARD);
                this._batchID++
            }
        };
        t._drawCover = function(t, i) {
            0 < this._isDrawing && this._drawBuffers(t);
            this.vocalDebug && console.log("Draw[" + this._drawID + ":" + this._batchID + "] : Cover");
            var r = this._activeShader,
                u = this._vertexPositionBuffer,
                f = this._uvPositionBuffer;
            t.clear(t.COLOR_BUFFER_BIT);
            t.useProgram(r);
            t.bindBuffer(t.ARRAY_BUFFER, u);
            t.vertexAttribPointer(r.vertexPositionAttribute, u.itemSize, t.FLOAT, !1, 0, 0);
            t.bufferSubData(t.ARRAY_BUFFER, 0, n.COVER_VERT);
            t.bindBuffer(t.ARRAY_BUFFER, f);
            t.vertexAttribPointer(r.uvPositionAttribute, f.itemSize, t.FLOAT, !1, 0, 0);
            t.bufferSubData(t.ARRAY_BUFFER, 0, i ? n.COVER_UV_FLIP : n.COVER_UV);
            t.uniform1i(r.samplerUniform, 0);
            t.uniform1f(r.uprightUniform, i ? 0 : 1);
            t.drawArrays(t.TRIANGLES, 0, n.INDICIES_PER_CARD)
        };
        createjs.StageGL = createjs.promote(n, "Stage")
    }(),
    function() {
        function t(n) {
            this.DisplayObject_constructor();
            "string" == typeof n ? (this.image = document.createElement("img"), this.image.src = n) : this.image = n;
            this.sourceRect = null;
            this._webGLRenderStyle = createjs.DisplayObject._StageGL_BITMAP
        }
        var n = createjs.extend(t, createjs.DisplayObject);
        n.initialize = t;
        n.isVisible = function() {
            var n = this.image,
                n = this.cacheCanvas || n && (n.naturalWidth || n.getContext || 2 <= n.readyState);
            return !!(this.visible && 0 < this.alpha && 0 != this.scaleX && 0 != this.scaleY && n)
        };
        n.draw = function(n, t) {
            if (this.DisplayObject_draw(n, t)) return !0;
            var r, u, e, o, s, f = this.image,
                i = this.sourceRect;
            return f.getImage && (f = f.getImage()), f && (i ? (r = i.x, u = i.y, e = r + i.width, o = u + i.height, r < (t = s = 0) && (s -= r, r = 0), (i = f.width) < e && (e = i), u < 0 && (t -= u, u = 0), (i = f.height) < o && (o = i), n.drawImage(f, r, u, e - r, o - u, s, t, e - r, o - u)) : n.drawImage(f, 0, 0)), !0
        };
        n.cache = function(n, t, i, r, u, f, e, o) {
            this.bitmapCache || (this.bitmapCache = new createjs.BitmapCache);
            this.bitmapCache.define(this, n, t, i, r, u, f, e, o)
        };
        n.updateCache = function(n, t) {
            if (!this.bitmapCache) throw "cache() must be called before updateCache()";
            this.bitmapCache.update(n, t)
        };
        n.uncache = function() {
            this.bitmapCache && (this.bitmapCache.release(), this.bitmapCache = void 0)
        };
        n.getCacheDataURL = function() {
            return this.bitmapCache ? this.bitmapCache.getDataURL() : null
        };
        n.getBounds = function() {
            var t = this.DisplayObject_getBounds(),
                n;
            return t ? t : (n = this.image, t = this.sourceRect || n, n && (n.naturalWidth || n.getContext || 2 <= n.readyState) ? this._rectangle.setValues(0, 0, t.width, t.height) : null)
        };
        n.clone = function(n) {
            var i = this.image;
            return i && n && (i = i.cloneNode()), i = new t(i), this.sourceRect && (i.sourceRect = this.sourceRect.clone()), this._cloneProps(i), i
        };
        n.toString = function() {
            return "[Bitmap (name=" + this.name + ")]"
        };
        createjs.Bitmap = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t(n, t) {
            this.DisplayObject_constructor();
            this.currentFrame = 0;
            this.currentAnimation = null;
            this.paused = !0;
            this.spriteSheet = n;
            this.currentAnimationFrame = 0;
            this.framerate = 0;
            this._animation = null;
            this._currentFrame = null;
            this._skipAdvance = !1;
            this._webGLRenderStyle = createjs.DisplayObject._StageGL_SPRITE;
            null != t && this.gotoAndPlay(t)
        }
        var n = createjs.extend(t, createjs.DisplayObject);
        n.initialize = t;
        n.isVisible = function() {
            var n = this.cacheCanvas || this.spriteSheet.complete;
            return !!(this.visible && 0 < this.alpha && 0 != this.scaleX && 0 != this.scaleY && n)
        };
        n.draw = function(n, t) {
            if (this.DisplayObject_draw(n, t)) return !0;
            this._normalizeFrame();
            var i = this.spriteSheet.getFrame(0 | this._currentFrame);
            return i ? (t = i.rect, t.width && t.height && n.drawImage(i.image, t.x, t.y, t.width, t.height, -i.regX, -i.regY, t.width, t.height), !0) : !1
        };
        n.play = function() {
            this.paused = !1
        };
        n.stop = function() {
            this.paused = !0
        };
        n.gotoAndPlay = function(n) {
            this.paused = !1;
            this._skipAdvance = !0;
            this._goto(n)
        };
        n.gotoAndStop = function(n) {
            this.paused = !0;
            this._goto(n)
        };
        n.advance = function(n) {
            var t = this.framerate || this.spriteSheet.framerate,
                t = t && null != n ? n / (1e3 / t) : 1;
            this._normalizeFrame(t)
        };
        n.getBounds = function() {
            return this.DisplayObject_getBounds() || this.spriteSheet.getFrameBounds(this.currentFrame, this._rectangle)
        };
        n.clone = function() {
            return this._cloneProps(new t(this.spriteSheet))
        };
        n.toString = function() {
            return "[Sprite (name=" + this.name + ")]"
        };
        n._cloneProps = function(n) {
            return this.DisplayObject__cloneProps(n), n.currentFrame = this.currentFrame, n.currentAnimation = this.currentAnimation, n.paused = this.paused, n.currentAnimationFrame = this.currentAnimationFrame, n.framerate = this.framerate, n._animation = this._animation, n._currentFrame = this._currentFrame, n._skipAdvance = this._skipAdvance, n
        };
        n._tick = function(n) {
            this.paused || (this._skipAdvance || this.advance(n && n.delta), this._skipAdvance = !1);
            this.DisplayObject__tick(n)
        };
        n._normalizeFrame = function(n) {
            var t, f, u, e;
            n = n || 0;
            var i = this._animation,
                o = this.paused,
                r = this._currentFrame;
            if (i) {
                if (f = i.speed || 1, u = this.currentAnimationFrame, (t = i.frames.length) <= u + n * f) {
                    if (e = i.next, this._dispatchAnimationEnd(i, r, o, e, t - 1)) return;
                    if (e) return this._goto(e, n - (t - u) / f);
                    this.paused = !0;
                    u = i.frames.length - 1
                } else u += n * f;
                this.currentAnimationFrame = u;
                this._currentFrame = i.frames[0 | u]
            } else if (r = this._currentFrame += n, t = this.spriteSheet.getNumFrames(), t <= r && 0 < t && !this._dispatchAnimationEnd(i, r, o, t - 1) && (this._currentFrame -= t) >= t) return this._normalizeFrame();
            r = 0 | this._currentFrame;
            this.currentFrame != r && (this.currentFrame = r, this.dispatchEvent("change"))
        };
        n._dispatchAnimationEnd = function(n, t, i, r, u) {
            var f, e = n ? n.name : null;
            return this.hasEventListener("animationend") && ((f = new createjs.Event("animationend")).name = e, f.next = r, this.dispatchEvent(f)), t = this._animation != n || this._currentFrame != t, t || i || !this.paused || (this.currentAnimationFrame = u, t = !0), t
        };
        n._goto = function(n, t) {
            var i;
            this.currentAnimationFrame = 0;
            isNaN(n) ? (i = this.spriteSheet.getAnimation(n)) && (this._animation = i, this.currentAnimation = n, this._normalizeFrame(t)) : (this.currentAnimation = this._animation = null, this._currentFrame = n, this._normalizeFrame())
        };
        createjs.Sprite = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.DisplayObject_constructor();
            this.graphics = n || new createjs.Graphics
        }
        var n = createjs.extend(t, createjs.DisplayObject);
        n.isVisible = function() {
            var n = this.cacheCanvas || this.graphics && !this.graphics.isEmpty();
            return !!(this.visible && 0 < this.alpha && 0 != this.scaleX && 0 != this.scaleY && n)
        };
        n.draw = function(n, t) {
            return this.DisplayObject_draw(n, t) || this.graphics.draw(n, this), !0
        };
        n.clone = function(n) {
            return n = n && this.graphics ? this.graphics.clone() : this.graphics, this._cloneProps(new t(n))
        };
        n.toString = function() {
            return "[Shape (name=" + this.name + ")]"
        };
        createjs.Shape = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.DisplayObject_constructor();
            this.text = n;
            this.font = t;
            this.color = i;
            this.textAlign = "left";
            this.textBaseline = "top";
            this.maxWidth = null;
            this.outline = 0;
            this.lineHeight = 0;
            this.lineWidth = null
        }
        var n = createjs.extend(t, createjs.DisplayObject),
            i = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas");
        i.getContext && (t._workingContext = i.getContext("2d"), i.width = i.height = 1);
        t.H_OFFSETS = {
            start: 0,
            left: 0,
            center: -.5,
            end: -1,
            right: -1
        };
        t.V_OFFSETS = {
            top: 0,
            hanging: -.01,
            middle: -.4,
            alphabetic: -.8,
            ideographic: -.85,
            bottom: -1
        };
        n.isVisible = function() {
            var n = this.cacheCanvas || null != this.text && "" !== this.text;
            return !!(this.visible && 0 < this.alpha && 0 != this.scaleX && 0 != this.scaleY && n)
        };
        n.draw = function(n, t) {
            return this.DisplayObject_draw(n, t) ? !0 : (t = this.color || "#000", this.outline ? (n.strokeStyle = t, n.lineWidth = +this.outline) : n.fillStyle = t, this._drawText(this._prepContext(n)), !0)
        };
        n.getMeasuredWidth = function() {
            return this._getMeasuredWidth(this.text)
        };
        n.getMeasuredLineHeight = function() {
            return 1.2 * this._getMeasuredWidth("M")
        };
        n.getMeasuredHeight = function() {
            return this._drawText(null, {}).height
        };
        n.getBounds = function() {
            var n = this.DisplayObject_getBounds();
            if (n) return n;
            if (null == this.text || "" === this.text) return null;
            var i = this._drawText(null, {}),
                r = this.maxWidth && this.maxWidth < i.width ? this.maxWidth : i.width,
                u = r * t.H_OFFSETS[this.textAlign || "left"],
                n = (this.lineHeight || this.getMeasuredLineHeight()) * t.V_OFFSETS[this.textBaseline || "top"];
            return this._rectangle.setValues(u, n, r, i.height)
        };
        n.getMetrics = function() {
            var n = {
                lines: []
            };
            return n.lineHeight = this.lineHeight || this.getMeasuredLineHeight(), n.vOffset = n.lineHeight * t.V_OFFSETS[this.textBaseline || "top"], this._drawText(null, n, n.lines)
        };
        n.clone = function() {
            return this._cloneProps(new t(this.text, this.font, this.color))
        };
        n.toString = function() {
            return "[Text (text=" + (20 < this.text.length ? this.text.substr(0, 17) + "..." : this.text) + ")]"
        };
        n._cloneProps = function(n) {
            return this.DisplayObject__cloneProps(n), n.textAlign = this.textAlign, n.textBaseline = this.textBaseline, n.maxWidth = this.maxWidth, n.outline = this.outline, n.lineHeight = this.lineHeight, n.lineWidth = this.lineWidth, n
        };
        n._prepContext = function(n) {
            return n.font = this.font || "10px sans-serif", n.textAlign = this.textAlign || "left", n.textBaseline = this.textBaseline || "top", n.lineJoin = "miter", n.miterLimit = 2.5, n
        };
        n._drawText = function(n, i, r) {
            var a = !!n,
                v, f, u, e, l, s, y, p, o, g, k;
            a || ((n = t._workingContext).save(), this._prepContext(n));
            for (var w = this.lineHeight || this.getMeasuredLineHeight(), h = 0, c = 0, d = String(this.text).split(/(?:\r\n|\r|\n)/), b = 0, nt = d.length; b < nt; b++) {
                if (u = d[b], e = null, null != this.lineWidth && (e = n.measureText(u).width) > this.lineWidth) {
                    if (/[\u4e00-\u9fa5]+/.test(u))
                        for (v = u.split(/(\s)/), f = [], l = 0; l < v.length; l++) {
                            for (s = "", y = 0; y < v[l].length; y++) p = v[l][y], 255 < p.charCodeAt(0) ? ("" != s && f.push(s), f.push(p), s = "") : s += p;
                            "" != s && f.push(s)
                        } else f = u.split(/(\s)/);
                    for (u = f[0], e = n.measureText(u).width, o = 1, g = f.length; o < g; o += 2) k = n.measureText(f[o] + f[o + 1]).width, e + k > this.lineWidth ? (a && this._drawTextLine(n, u, c * w), r && r.push(u), h < e && (h = e), u = f[o + 1], e = n.measureText(u).width, c++) : (u += f[o] + f[o + 1], e += k)
                }
                a && this._drawTextLine(n, u, c * w);
                r && r.push(u);
                i && null == e && (e = n.measureText(u).width);
                h < e && (h = e);
                c++
            }
            return i && (i.width = h, i.height = c * w), a || n.restore(), i
        };
        n._splitWords = function(n) {
            return n.split(/([ \f\n\r\t\v\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff])/)
        };
        n._drawTextLine = function(n, t, i) {
            this.outline ? n.strokeText(t, 0, i, this.maxWidth || 65535) : n.fillText(t, 0, i, this.maxWidth || 65535)
        };
        n._getMeasuredWidth = function(n) {
            var i = t._workingContext;
            return i.save(), n = this._prepContext(i).measureText(n).width, i.restore(), n
        };
        createjs.Text = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t(n, t) {
            this.Container_constructor();
            this.text = n || "";
            this.spriteSheet = t;
            this.lineHeight = 0;
            this.letterSpacing = 0;
            this.spaceWidth = 0;
            this._oldProps = {
                text: 0,
                spriteSheet: 0,
                lineHeight: 0,
                letterSpacing: 0,
                spaceWidth: 0
            };
            this._oldStage = null;
            this._drawAction = null
        }
        var n = createjs.extend(t, createjs.Container);
        t.maxPoolSize = 100;
        t._spritePool = [];
        n.draw = function(n, t) {
            this.DisplayObject_draw(n, t) || (this._updateState(), this.Container_draw(n, t))
        };
        n.getBounds = function() {
            return this._updateText(), this.Container_getBounds()
        };
        n.isVisible = function() {
            var n = this.cacheCanvas || this.spriteSheet && this.spriteSheet.complete && this.text;
            return !!(this.visible && 0 < this.alpha && 0 !== this.scaleX && 0 !== this.scaleY && n)
        };
        n.clone = function() {
            return this._cloneProps(new t(this.text, this.spriteSheet))
        };
        n.addChild = n.addChildAt = n.removeChild = n.removeChildAt = n.removeAllChildren = function() {};
        n._updateState = function() {
            this._updateText()
        };
        n._cloneProps = function(n) {
            return this.Container__cloneProps(n), n.lineHeight = this.lineHeight, n.letterSpacing = this.letterSpacing, n.spaceWidth = this.spaceWidth, n
        };
        n._getFrameIndex = function(n, t) {
            var i, r = t.getAnimation(n);
            return r || (n != (i = n.toUpperCase()) || n != (i = n.toLowerCase()) || (i = null), i && (r = t.getAnimation(i))), r && r.frames[0]
        };
        n._getFrame = function(n, t) {
            return n = this._getFrameIndex(n, t), null == n ? n : t.getFrame(n)
        };
        n._getLineHeight = function(n) {
            return n = this._getFrame("1", n) || this._getFrame("T", n) || this._getFrame("L", n) || n.getFrame(0), n ? n.rect.height : 1
        };
        n._getSpaceWidth = function(n) {
            return n = this._getFrame("1", n) || this._getFrame("l", n) || this._getFrame("e", n) || this._getFrame("a", n) || n.getFrame(0), n ? n.rect.width : 1
        };
        n._updateText = function() {
            var n, u, o = 0,
                p = 0,
                l = this._oldProps,
                w = !1,
                a = this.spaceWidth,
                v = this.lineHeight,
                f = this.spriteSheet,
                e = t._spritePool,
                s = this.children,
                h = 0,
                c = s.length,
                y, i, b, k, r;
            for (u in l) l[u] != this[u] && (l[u] = this[u], w = !0);
            if (w) {
                for (y = !!this._getFrame(" ", f), y || a || (a = this._getSpaceWidth(f)), v = v || this._getLineHeight(f), i = 0, b = this.text.length; i < b; i++) r = this.text.charAt(i), " " != r || y ? "\n" != r && "\r" != r ? null != (k = this._getFrameIndex(r, f)) && (h < c ? n = s[h] : (s.push(n = e.length ? e.pop() : new createjs.Sprite), n.parent = this, c++), n.spriteSheet = f, n.gotoAndStop(k), n.x = o, n.y = p, h++, o += n.getBounds().width + this.letterSpacing) : ("\r" == r && "\n" == this.text.charAt(i + 1) && i++, o = 0, p += v) : o += a;
                for (; h < c;) e.push(n = s.pop()), n.parent = null, c--;
                e.length > t.maxPoolSize && (e.length = t.maxPoolSize)
            }
        };
        createjs.BitmapText = createjs.promote(t, "Container")
    }(),
    function() {
        "use strict";

        function t(n) {
            var r, u, i, f;
            this.Container_constructor();
            t.inited || t.init();
            n instanceof String || 1 < arguments.length ? (r = n, u = arguments[1], i = arguments[2], f = arguments[3], null == i && (i = -1), n = null) : n && (r = n.mode, u = n.startPosition, i = n.loop, f = n.labels);
            n = n || {
                labels: f
            };
            this.mode = r || t.INDEPENDENT;
            this.startPosition = u || 0;
            this.loop = !0 === i ? -1 : i || 0;
            this.currentFrame = 0;
            this.paused = n.paused || !1;
            this.actionsEnabled = !0;
            this.autoReset = !0;
            this.frameBounds = this.frameBounds || n.frameBounds;
            this.framerate = null;
            n.useTicks = n.paused = !0;
            this.timeline = new createjs.Timeline(n);
            this._synchOffset = 0;
            this._rawPosition = -1;
            this._bound_resolveState = this._resolveState.bind(this);
            this._t = 0;
            this._managed = {}
        }

        function i() {
            throw "MovieClipPlugin cannot be instantiated.";
        }
        var n = createjs.extend(t, createjs.Container);
        t.INDEPENDENT = "independent";
        t.SINGLE_FRAME = "single";
        t.SYNCHED = "synched";
        t.inited = !1;
        t.init = function() {
            t.inited || (i.install(), t.inited = !0)
        };
        n._getLabels = function() {
            return this.timeline.getLabels()
        };
        n.getLabels = createjs.deprecate(n._getLabels, "MovieClip.getLabels");
        n._getCurrentLabel = function() {
            return this.timeline.currentLabel
        };
        n.getCurrentLabel = createjs.deprecate(n._getCurrentLabel, "MovieClip.getCurrentLabel");
        n._getDuration = function() {
            return this.timeline.duration
        };
        n.getDuration = createjs.deprecate(n._getDuration, "MovieClip.getDuration");
        try {
            Object.defineProperties(n, {
                labels: {
                    get: n._getLabels
                },
                currentLabel: {
                    get: n._getCurrentLabel
                },
                totalFrames: {
                    get: n._getDuration
                },
                duration: {
                    get: n._getDuration
                }
            })
        } catch (n) {}
        n.initialize = t;
        n.isVisible = function() {
            return !!(this.visible && 0 < this.alpha && 0 != this.scaleX && 0 != this.scaleY)
        };
        n.draw = function(n, t) {
            return this.DisplayObject_draw(n, t) || (this._updateState(), this.Container_draw(n, t)), !0
        };
        n.play = function() {
            this.paused = !1
        };
        n.stop = function() {
            this.paused = !0
        };
        n.gotoAndPlay = function(n) {
            this.paused = !1;
            this._goto(n)
        };
        n.gotoAndStop = function(n) {
            this.paused = !0;
            this._goto(n)
        };
        n.advance = function(n) {
            var f = t.INDEPENDENT,
                r, i, n, u;
            if (this.mode === f) {
                for (r = this, i = r.framerate;
                    (r = r.parent) && null === i;) r.mode === f && (i = r._framerate);
                if (this._framerate = i, !(this.totalFrames <= 1))
                    for (n = null !== i && -1 !== i && null !== n ? n / (1e3 / i) + this._t : 1, u = 0 | n, this._t = n - u; !this.paused && u--;) this._updateTimeline(this._rawPosition + 1, !1)
            }
        };
        n.clone = function() {
            throw "MovieClip cannot be cloned.";
        };
        n.toString = function() {
            return "[MovieClip (name=" + this.name + ")]"
        };
        n._updateState = function() {
            -1 !== this._rawPosition && this.mode === t.INDEPENDENT || this._updateTimeline(-1)
        };
        n._tick = function(n) {
            this.advance(n && n.delta);
            this.Container__tick(n)
        };
        n._goto = function(n) {
            n = this.timeline.resolve(n);
            null != n && (this._t = 0, this._updateTimeline(n, !0))
        };
        n._reset = function() {
            this._rawPosition = -1;
            this._t = this.currentFrame = 0;
            this.paused = !1
        };
        n._updateTimeline = function(n, i) {
            var r = this.mode !== t.INDEPENDENT,
                u = this.timeline;
            r && (n = this.startPosition + (this.mode === t.SINGLE_FRAME ? 0 : this._synchOffset));
            n < 0 && (n = 0);
            this._rawPosition === n && !r || (this._rawPosition = n, u.loop = this.loop, u.setPosition(n, r || !this.actionsEnabled, i, this._bound_resolveState))
        };
        n._renderFirstFrame = function() {
            var n = this.timeline,
                t = n.rawPosition;
            n.setPosition(0, !0, !0, this._bound_resolveState);
            n.rawPosition = t
        };
        n._resolveState = function() {
            var f, e = this.timeline,
                t, i, r, n, u;
            for (f in this.currentFrame = e.position, this._managed) this._managed[f] = 1;
            for (var o = e.tweens, n = 0, s = o.length; n < s; n++) t = o[n], i = t.target, i === this || t.passive || (t = t._stepPosition, i instanceof createjs.DisplayObject ? this._addManagedChild(i, t) : this._setState(i.state, t));
            for (r = this.children, n = r.length - 1; 0 <= n; n--) u = r[n].id, 1 === this._managed[u] && (this.removeChildAt(n), delete this._managed[u])
        };
        n._setState = function(n, t) {
            var i;
            if (n)
                for (i = n.length - 1; 0 <= i; i--) {
                    var r, u = n[i],
                        f = u.t,
                        e = u.p;
                    for (r in e) f[r] = e[r];
                    this._addManagedChild(f, t)
                }
        };
        n._addManagedChild = function(n, i) {
            n._off || (this.addChildAt(n, 0), n instanceof t && (n._synchOffset = i, n.mode === t.INDEPENDENT && n.autoReset && !this._managed[n.id] && n._reset()), this._managed[n.id] = 2)
        };
        n._getBounds = function(n, t) {
            var i = this.DisplayObject_getBounds();
            return i || this.frameBounds && (i = this._rectangle.copy(this.frameBounds[this.currentFrame])), i ? this._transformBounds(i, n, t) : this.Container__getBounds(n, t)
        };
        createjs.MovieClip = createjs.promote(t, "Container");
        i.priority = 100;
        i.ID = "MovieClip";
        i.install = function() {
            createjs.Tween._installPlugin(i)
        };
        i.init = function(n, r) {
            "startPosition" === r && n.target instanceof t && n._addPlugin(i)
        };
        i.step = function() {};
        i.change = function(n, t, i, r, u) {
            if ("startPosition" === i) return (1 === u ? t : t.prev).props[i]
        }
    }(),
    function() {
        "use strict";

        function n() {
            throw "SpriteSheetUtils cannot be instantiated";
        }
        var t = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas");
        t.getContext && (n._workingCanvas = t, n._workingContext = t.getContext("2d"), t.width = t.height = 1);
        n.extractFrame = function(t, i) {
            isNaN(i) && (i = t.getAnimation(i).frames[0]);
            var r = t.getFrame(i);
            return r ? (t = r.rect, i = n._workingCanvas, i.width = t.width, i.height = t.height, n._workingContext.drawImage(r.image, t.x, t.y, t.width, t.height, 0, 0, t.width, t.height), t = document.createElement("img"), t.src = i.toDataURL("image/png"), t) : null
        };
        n.addFlippedFrames = createjs.deprecate(null, "SpriteSheetUtils.addFlippedFrames");
        n.mergeAlpha = createjs.deprecate(null, "SpriteSheetUtils.mergeAlpha");
        n._flip = function(t, i, r, u) {
            for (var f, o, s, y, b, h, p, tt, a = t._images, c = n._workingCanvas, v = n._workingContext, k = a.length / i, e = 0; e < k; e++) f = a[e], f.__tmp = e, v.setTransform(1, 0, 0, 1, 0, 0), v.clearRect(0, 0, c.width + 1, c.height + 1), c.width = f.width, c.height = f.height, v.setTransform(r ? -1 : 1, 0, 0, u ? -1 : 1, r ? f.width : 0, u ? f.height : 0), v.drawImage(f, 0, 0), o = document.createElement("img"), o.src = c.toDataURL("image/png"), o.width = f.width || f.naturalWidth, o.height = f.height || f.naturalHeight, a.push(o);
            for (var l = t._frames, d = l.length / i, e = 0; e < d; e++) s = (f = l[e]).rect.clone(), y = {
                image: o = a[f.image.__tmp + k * i],
                rect: s,
                regX: f.regX,
                regY: f.regY
            }, r && (s.x = (o.width || o.naturalWidth) - s.x - s.width, y.regX = s.width - f.regX), u && (s.y = (o.height || o.naturalHeight) - s.y - s.height, y.regY = s.height - f.regY), l.push(y);
            var g = "_" + (r ? "h" : "") + (u ? "v" : ""),
                w = t._animations,
                nt = t._data,
                it = w.length / i;
            for (e = 0; e < it; e++) {
                for (b = w[e], h = {
                        name: b + g,
                        speed: (f = nt[b]).speed,
                        next: f.next,
                        frames: []
                    }, f.next && (h.next += g), p = 0, tt = (l = f.frames).length; p < tt; p++) h.frames.push(l[p] + d * i);
                nt[h.name] = h;
                w.push(h.name)
            }
        };
        createjs.SpriteSheetUtils = n
    }(),
    function() {
        "use strict";

        function t(n) {
            this.EventDispatcher_constructor();
            this.maxWidth = 2048;
            this.maxHeight = 2048;
            this.spriteSheet = null;
            this.scale = 1;
            this.padding = 1;
            this.timeSlice = .3;
            this.progress = -1;
            this.framerate = n || 0;
            this._frames = [];
            this._animations = {};
            this._data = null;
            this._nextFrameIndex = 0;
            this._index = 0;
            this._timerID = null;
            this._scale = 1
        }
        var n = createjs.extend(t, createjs.EventDispatcher);
        t.ERR_DIMENSIONS = "frame dimensions exceed max spritesheet dimensions";
        t.ERR_RUNNING = "a build is already running";
        n.addFrame = function(n, i, r, u, f) {
            if (this._data) throw t.ERR_RUNNING;
            return i = i || n.bounds || n.nominalBounds, !i && n.getBounds && (i = n.getBounds()), i ? (r = r || 1, this._frames.push({
                source: n,
                sourceRect: i,
                scale: r,
                funct: u,
                data: f,
                index: this._frames.length,
                height: i.height * r
            }) - 1) : null
        };
        n.addAnimation = function(n, i, r, u) {
            if (this._data) throw t.ERR_RUNNING;
            this._animations[n] = {
                frames: i,
                next: r,
                speed: u
            }
        };
        n.addMovieClip = function(n, i, r, u, f, e) {
            var h, c, k, a, v, s;
            if (this._data) throw t.ERR_RUNNING;
            if (h = n.frameBounds, c = i || n.bounds || n.nominalBounds, !c && n.getBounds && (c = n.getBounds()), c || h) {
                for (var l, w = this._frames.length, b = n.timeline.duration, o = 0; o < b; o++) k = h && h[o] ? h[o] : c, this.addFrame(n, k, r, this._setupMovieClipFrame, {
                    i: o,
                    f: u,
                    d: f
                });
                v = n.timeline._labels;
                s = [];
                for (a in v) s.push({
                    index: v[a],
                    label: a
                });
                if (s.length)
                    for (s.sort(function(n, t) {
                            return n.index - t.index
                        }), o = 0, l = s.length; o < l; o++) {
                        for (var y = s[o].label, d = w + s[o].index, g = w + (o == l - 1 ? b : s[o + 1].index), nt = [], p = d; p < g; p++) nt.push(p);
                        (!e || (y = e(y, n, d, g))) && this.addAnimation(y, nt, !0)
                    }
            }
        };
        n.build = function() {
            if (this._data) throw t.ERR_RUNNING;
            for (this._startBuild(); this._drawNext(););
            return this._endBuild(), this.spriteSheet
        };
        n.buildAsync = function(n) {
            if (this._data) throw t.ERR_RUNNING;
            this.timeSlice = n;
            this._startBuild();
            var i = this;
            this._timerID = setTimeout(function() {
                i._run()
            }, 50 - 50 * Math.max(.01, Math.min(.99, this.timeSlice || .3)))
        };
        n.stopAsync = function() {
            clearTimeout(this._timerID);
            this._data = null
        };
        n.clone = function() {
            throw "SpriteSheetBuilder cannot be cloned.";
        };
        n.toString = function() {
            return "[SpriteSheetBuilder]"
        };
        n._startBuild = function() {
            var s = this.padding || 0,
                f, n, o, i;
            if (this.progress = 0, this.spriteSheet = null, this._index = 0, this._scale = this.scale, f = [], this._data = {
                    images: [],
                    frames: f,
                    framerate: this.framerate,
                    animations: this._animations
                }, n = this._frames.slice(), n.sort(function(n, t) {
                    return n.height <= t.height ? -1 : 1
                }), n[n.length - 1].height + 2 * s > this.maxHeight) throw t.ERR_DIMENSIONS;
            for (var r = 0, u = 0, e = 0; n.length;) i = this._fillRow(n, r, e, f, s), i.w > u && (u = i.w), r += i.h, i.h && n.length || ((o = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas")).width = this._getSize(u, this.maxWidth), o.height = this._getSize(r, this.maxHeight), this._data.images[e] = o, i.h || (u = r = 0, e++))
        };
        n._setupMovieClipFrame = function(n, t) {
            var i = n.actionsEnabled;
            n.actionsEnabled = !1;
            n.gotoAndStop(t.i);
            n.actionsEnabled = i;
            t.f && t.f(n, t.d, t.i)
        };
        n._getSize = function(n, t) {
            for (var i = 4; Math.pow(2, ++i) < n;);
            return Math.min(t, Math.pow(2, i))
        };
        n._fillRow = function(n, i, r, u, f) {
            for (var v = this.maxWidth, p = this.maxHeight - (i += f), h = f, a = 0, c = n.length - 1; 0 <= c; c--) {
                var o = n[c],
                    s = this._scale * o.scale,
                    e = o.sourceRect,
                    y = o.source,
                    w = Math.floor(s * e.x - f),
                    b = Math.floor(s * e.y - f),
                    l = Math.ceil(s * e.height + 2 * f),
                    e = Math.ceil(s * e.width + 2 * f);
                if (v < e) throw t.ERR_DIMENSIONS;
                p < l || v < h + e || (o.img = r, o.rect = new createjs.Rectangle(h, i, e, l), a = a || l, n.splice(c, 1), u[o.index] = [h, i, e, l, r, Math.round(-w + s * y.regX - f), Math.round(-b + s * y.regY - f)], h += e)
            }
            return {
                w: h,
                h: a
            }
        };
        n._endBuild = function() {
            this.spriteSheet = new createjs.SpriteSheet(this._data);
            this._data = null;
            this.progress = 1;
            this.dispatchEvent("complete")
        };
        n._run = function() {
            for (var r, t, n = 50 * Math.max(.01, Math.min(.99, this.timeSlice || .3)), u = (new Date).getTime() + n, i = !1; u > (new Date).getTime();)
                if (!this._drawNext()) {
                    i = !0;
                    break
                }
            i ? this._endBuild() : (t = this)._timerID = setTimeout(function() {
                t._run()
            }, 50 - n);
            r = this.progress = this._index / this._frames.length;
            this.hasEventListener("progress") && ((n = new createjs.Event("progress")).progress = r, this.dispatchEvent(n))
        };
        n._drawNext = function() {
            var n = this._frames[this._index],
                r = n.scale * this._scale,
                i = n.rect,
                u = n.sourceRect,
                t = this._data.images[n.img].getContext("2d");
            return n.funct && n.funct(n.source, n.data), t.save(), t.beginPath(), t.rect(i.x, i.y, i.width, i.height), t.clip(), t.translate(Math.ceil(i.x - u.x * r), Math.ceil(i.y - u.y * r)), t.scale(r, r), n.source.draw(t), t.restore(), ++this._index < this._frames.length
        };
        createjs.SpriteSheetBuilder = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.DisplayObject_constructor();
            "string" == typeof n && (n = document.getElementById(n));
            this.mouseEnabled = !1;
            var t = n.style;
            t.position = "absolute";
            t.transformOrigin = t.WebkitTransformOrigin = t.msTransformOrigin = t.MozTransformOrigin = t.OTransformOrigin = "0% 0%";
            this.htmlElement = n;
            this._oldProps = null;
            this._oldStage = null;
            this._drawAction = null
        }
        var n = createjs.extend(t, createjs.DisplayObject);
        n.isVisible = function() {
            return null != this.htmlElement
        };
        n.draw = function() {
            return !0
        };
        n.cache = function() {};
        n.uncache = function() {};
        n.updateCache = function() {};
        n.hitTest = function() {};
        n.localToGlobal = function() {};
        n.globalToLocal = function() {};
        n.localToLocal = function() {};
        n.clone = function() {
            throw "DOMElement cannot be cloned.";
        };
        n.toString = function() {
            return "[DOMElement (name=" + this.name + ")]"
        };
        n._tick = function(n) {
            var t = this.stage;
            t && t !== this._oldStage && (this._drawAction && t.off("drawend", this._drawAction), this._drawAction = t.on("drawend", this._handleDrawEnd, this), this._oldStage = t);
            this.DisplayObject__tick(n)
        };
        n._handleDrawEnd = function() {
            var i, f, t, n, u, r = this.htmlElement;
            r && (i = r.style, t = (f = this.getConcatenatedDisplayProps(this._props)).matrix, (u = f.visible ? "visible" : "hidden") != i.visibility && (i.visibility = u), f.visible && (n = 1e4, (u = (r = this._oldProps) && r.matrix) && u.equals(t) || (u = "matrix(" + (t.a * n | 0) / n + "," + (t.b * n | 0) / n + "," + (t.c * n | 0) / n + "," + (t.d * n | 0) / n + "," + (t.tx + .5 | 0), i.transform = i.WebkitTransform = i.OTransform = i.msTransform = u + "," + (t.ty + .5 | 0) + ")", i.MozTransform = u + "px," + (t.ty + .5 | 0) + "px)", (r = r || (this._oldProps = new createjs.DisplayProps(!0, null))).matrix.copy(t)), r.alpha != f.alpha && (i.opacity = "" + (f.alpha * n | 0) / n, r.alpha = f.alpha)))
        };
        createjs.DOMElement = createjs.promote(t, "DisplayObject")
    }(),
    function() {
        "use strict";

        function t() {
            this.usesContext = !1;
            this._multiPass = null;
            this.VTX_SHADER_BODY = null;
            this.FRAG_SHADER_BODY = null
        }
        var n = t.prototype;
        n.getBounds = function(n) {
            return n
        };
        n.shaderParamSetup = function() {};
        n.applyFilter = function(n, t, i, r, u, f, e, o) {
            f = f || n;
            null == e && (e = t);
            null == o && (o = i);
            try {
                var s = n.getImageData(t, i, r, u)
            } catch (n) {
                return !1
            }
            return !!this._applyFilter(s) && (f.putImageData(s, e, o), !0)
        };
        n.toString = function() {
            return "[Filter]"
        };
        n.clone = function() {
            return new t
        };
        n._applyFilter = function() {
            return !0
        };
        createjs.Filter = t
    }(),
    function() {
        "use strict";

        function t() {
            this.width = void 0;
            this.height = void 0;
            this.x = void 0;
            this.y = void 0;
            this.scale = 1;
            this.offX = 0;
            this.offY = 0;
            this.cacheID = 0;
            this._filterOffX = 0;
            this._filterOffY = 0;
            this._cacheDataURLID = 0;
            this._cacheDataURL = null;
            this._rtl = null;
            this._willReadFrequently = null;
            this._drawWidth = 0;
            this._drawHeight = 0
        }
        var n = t.prototype;
        t.getFilterBounds = function(n, t) {
            var u, f, r, i;
            if (t = t || new createjs.Rectangle, u = n.filters, f = u && u.length, !!f <= 0) return t;
            for (r = 0; r < f; r++) i = u[r], i && i.getBounds && (i = i.getBounds()) && (0 == r ? t.setValues(i.x, i.y, i.width, i.height) : t.extend(i.x, i.y, i.width, i.height));
            return t
        };
        n.toString = function() {
            return "[BitmapCache]"
        };
        n.define = function(n, t, i, r, u, f, e, o, s) {
            if (!n) throw "No symbol to cache";
            this._options = e;
            this.target = n;
            this.width = 1 <= r ? r : 1;
            this.height = 1 <= u ? u : 1;
            this.x = t || 0;
            this.y = i || 0;
            this.scale = f || 1;
            this._rtl = o;
            this._willReadFrequently = s;
            this.update()
        };
        n.update = function(n, i) {
            if (!this.target) throw "define() must be called before update()";
            var r = t.getFilterBounds(this.target),
                u = this.target.cacheCanvas;
            this._drawWidth = Math.ceil(this.width * this.scale) + r.width;
            this._drawHeight = Math.ceil(this.height * this.scale) + r.height;
            u && this._drawWidth == u.width && this._drawHeight == u.height || this._updateSurface();
            this._filterOffX = r.x;
            this._filterOffY = r.y;
            this.offX = this.x * this.scale + this._filterOffX;
            this.offY = this.y * this.scale + this._filterOffY;
            this._drawToCache(n, i || this._rtl);
            this.cacheID = this.cacheID ? this.cacheID + 1 : 1
        };
        n.release = function() {
            var n;
            this._webGLCache ? (this._webGLCache.isCacheControlled || (this.__lastRT && (this.__lastRT = void 0), this.__rtA && this._webGLCache._killTextureObject(this.__rtA), this.__rtB && this._webGLCache._killTextureObject(this.__rtB), this.target && this.target.cacheCanvas && this._webGLCache._killTextureObject(this.target.cacheCanvas)), this._webGLCache = !1) : (n = this.target.stage) instanceof createjs.StageGL && n.releaseTexture(this.target.cacheCanvas);
            this.target = this.target.cacheCanvas = null;
            this.cacheID = this._cacheDataURLID = this._cacheDataURL = void 0;
            this.width = this.height = this.x = this.y = this.offX = this.offY = 0;
            this.scale = 1
        };
        n.getCacheDataURL = function() {
            var n = this.target && this.target.cacheCanvas;
            return n ? (this.cacheID != this._cacheDataURLID && (this._cacheDataURLID = this.cacheID, this._cacheDataURL = n.toDataURL ? n.getCacheDataURL() : null), this._cacheDataURL) : null
        };
        n.draw = function(n) {
            return !!this.target && (n.drawImage(this.target.cacheCanvas, this.x + this._filterOffX / this.scale, this.y + this._filterOffY / this.scale, this._drawWidth / this.scale, this._drawHeight / this.scale), !0)
        };
        n._updateSurface = function() {
            var t, n;
            if (!this._options || !this._options.useGL) return (t = this.target.cacheCanvas) || (t = this.target.cacheCanvas = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas"), this._willReadFrequently && t.getContext("2d", {
                willReadFrequently: !0
            })), t.width = this._drawWidth, void(t.height = this._drawHeight);
            if (!this._webGLCache)
                if ("stage" === this._options.useGL) {
                    if (!this.target.stage || !this.target.stage.isWebGL) {
                        n = "Cannot use 'stage' for cache because the object's parent stage is ";
                        throw n += this.target.stage ? "non WebGL." : "not set, please addChild to the correct stage.";
                    }
                    this.target.cacheCanvas = !0;
                    this._webGLCache = this.target.stage
                } else if ("new" === this._options.useGL) this.target.cacheCanvas = document.createElement("canvas"), this._webGLCache = new createjs.StageGL(this.target.cacheCanvas, {
                antialias: !0,
                transparent: !0,
                autoPurge: -1
            }), this._webGLCache.isCacheControlled = !0;
            else {
                if (!(this._options.useGL instanceof createjs.StageGL)) throw "Invalid option provided to useGL, expected ['stage', 'new', StageGL, undefined], got " + this._options.useGL;
                this.target.cacheCanvas = !0;
                this._webGLCache = this._options.useGL;
                this._webGLCache.isCacheControlled = !0
            }
            t = this.target.cacheCanvas;
            n = this._webGLCache;
            n.isCacheControlled && (t.width = this._drawWidth, t.height = this._drawHeight, n.updateViewport(this._drawWidth, this._drawHeight));
            this.target.filters ? (n.getTargetRenderTexture(this.target, this._drawWidth, this._drawHeight), n.getTargetRenderTexture(this.target, this._drawWidth, this._drawHeight)) : n.isCacheControlled || n.getTargetRenderTexture(this.target, this._drawWidth, this._drawHeight)
        };
        n._drawToCache = function(n, t) {
            var u = this.target.cacheCanvas,
                r = this.target,
                i = this._webGLCache;
            i ? (i.cacheDraw(r, r.filters, this), (u = this.target.cacheCanvas).width = this._drawWidth, u.height = this._drawHeight) : (i = r.filters && r.filters.length ? u.getContext("2d", createjs.willReadFrequently ? {
                willReadFrequently: !0
            } : void 0) : u.getContext("2d"), t && (i.direction = "rtl"), n || i.clearRect(0, 0, this._drawWidth + 1, this._drawHeight + 1), i.save(), i.globalCompositeOperation = n, i.setTransform(this.scale, 0, 0, this.scale, -this._filterOffX, -this._filterOffY), i.translate(-this.x, -this.y), r.draw(i, !0), i.restore(), r.filters && r.filters.length && this._applyFilters(i));
            u._invalid = !0
        };
        n._applyFilters = function(n) {
            for (var t, r = this.target.filters, u = this._drawWidth, f = this._drawHeight, e = 0, i = r[e]; i.usesContext ? (t && (n.putImageData(t, 0, 0), t = null), i.applyFilter(n, 0, 0, u, f)) : (t = t || n.getImageData(0, 0, u, f), i._applyFilter(t)), i = null !== i._multiPass ? i._multiPass : r[++e], i;);
            t && n.putImageData(t, 0, 0)
        };
        createjs.BitmapCache = t
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.Filter_constructor();
            this._blurX = n;
            this._blurXTable = [];
            this._lastBlurX = null;
            this._blurY = t;
            this._blurYTable = [];
            this._lastBlurY = null;
            this._quality;
            this._lastQuality = null;
            this.FRAG_SHADER_TEMPLATE = "uniform float xWeight[{{blurX}}];uniform float yWeight[{{blurY}}];uniform vec2 textureOffset;void main(void) {vec4 color = vec4(0.0);float xAdj = ({{blurX}}.0-1.0)/2.0;float yAdj = ({{blurY}}.0-1.0)/2.0;vec2 sampleOffset;for(int i=0; i<{{blurX}}; i++) {for(int j=0; j<{{blurY}}; j++) {sampleOffset = vRenderCoord + (textureOffset * vec2(float(i)-xAdj, float(j)-yAdj));color += texture2D(uSampler, sampleOffset) * (xWeight[i] * yWeight[j]);}}gl_FragColor = color.rgba;}";
            (isNaN(i) || i < 1) && (i = 1);
            this.setQuality(0 | i)
        }
        var n = createjs.extend(t, createjs.Filter);
        n.getBlurX = function() {
            return this._blurX
        };
        n.getBlurY = function() {
            return this._blurY
        };
        n.setBlurX = function(n) {
            (isNaN(n) || n < 0) && (n = 0);
            this._blurX = n
        };
        n.setBlurY = function(n) {
            (isNaN(n) || n < 0) && (n = 0);
            this._blurY = n
        };
        n.getQuality = function() {
            return this._quality
        };
        n.setQuality = function(n) {
            (isNaN(n) || n < 0) && (n = 0);
            this._quality = 0 | n
        };
        n._getShader = function() {
            var t = this._lastBlurX !== this._blurX,
                i = this._lastBlurY !== this._blurY,
                n = this._lastQuality !== this._quality;
            return t || i || n ? ((t || n) && (this._blurXTable = this._getTable(this._blurX * this._quality)), (i || n) && (this._blurYTable = this._getTable(this._blurY * this._quality)), this._updateShader(), this._lastBlurX = this._blurX, this._lastBlurY = this._blurY, void(this._lastQuality = this._quality)) : this._compiledShader
        };
        n._setShader = function() {
            this._compiledShader
        };
        try {
            Object.defineProperties(n, {
                blurX: {
                    get: n.getBlurX,
                    set: n.setBlurX
                },
                blurY: {
                    get: n.getBlurY,
                    set: n.setBlurY
                },
                quality: {
                    get: n.getQuality,
                    set: n.setQuality
                },
                _builtShader: {
                    get: n._getShader,
                    set: n._setShader
                }
            })
        } catch (n) {
            console.log(n)
        }
        n._getTable = function(n) {
            var u, f;
            if (n <= 1) return [1];
            for (var t = [], n = Math.ceil(2 * n), i = (n += n % 2 ? 0 : 1) / 2 | 0, r = -i; r <= i; r++) u = r / i * 4.2, t.push(1 / Math.sqrt(2 * Math.PI) * Math.pow(Math.E, -Math.pow(u, 2) / 4));
            return f = t.reduce(function(n, t) {
                return n + t
            }), t.map(function(n) {
                return n / f
            })
        };
        n._updateShader = function() {
            var n;
            void 0 !== this._blurX && void 0 !== this._blurY && (n = (n = (n = this.FRAG_SHADER_TEMPLATE).replace(/\{\{blurX\}\}/g, this._blurXTable.length.toFixed(0))).replace(/\{\{blurY\}\}/g, this._blurYTable.length.toFixed(0)), this.FRAG_SHADER_BODY = n)
        };
        n.shaderParamSetup = function(n, t, i) {
            n.uniform1fv(n.getUniformLocation(i, "xWeight"), this._blurXTable);
            n.uniform1fv(n.getUniformLocation(i, "yWeight"), this._blurYTable);
            n.uniform2f(n.getUniformLocation(i, "textureOffset"), 2 / (t._viewportWidth * this._quality), 2 / (t._viewportHeight * this._quality))
        };
        t.MUL_TABLE = [1, 171, 205, 293, 57, 373, 79, 137, 241, 27, 391, 357, 41, 19, 283, 265, 497, 469, 443, 421, 25, 191, 365, 349, 335, 161, 155, 149, 9, 278, 269, 261, 505, 245, 475, 231, 449, 437, 213, 415, 405, 395, 193, 377, 369, 361, 353, 345, 169, 331, 325, 319, 313, 307, 301, 37, 145, 285, 281, 69, 271, 267, 263, 259, 509, 501, 493, 243, 479, 118, 465, 459, 113, 446, 55, 435, 429, 423, 209, 413, 51, 403, 199, 393, 97, 3, 379, 375, 371, 367, 363, 359, 355, 351, 347, 43, 85, 337, 333, 165, 327, 323, 5, 317, 157, 311, 77, 305, 303, 75, 297, 294, 73, 289, 287, 71, 141, 279, 277, 275, 68, 135, 67, 133, 33, 262, 260, 129, 511, 507, 503, 499, 495, 491, 61, 121, 481, 477, 237, 235, 467, 232, 115, 457, 227, 451, 7, 445, 221, 439, 218, 433, 215, 427, 425, 211, 419, 417, 207, 411, 409, 203, 202, 401, 399, 396, 197, 49, 389, 387, 385, 383, 95, 189, 47, 187, 93, 185, 23, 183, 91, 181, 45, 179, 89, 177, 11, 175, 87, 173, 345, 343, 341, 339, 337, 21, 167, 83, 331, 329, 327, 163, 81, 323, 321, 319, 159, 79, 315, 313, 39, 155, 309, 307, 153, 305, 303, 151, 75, 299, 149, 37, 295, 147, 73, 291, 145, 289, 287, 143, 285, 71, 141, 281, 35, 279, 139, 69, 275, 137, 273, 17, 271, 135, 269, 267, 133, 265, 33, 263, 131, 261, 130, 259, 129, 257, 1];
        t.SHG_TABLE = [0, 9, 10, 11, 9, 12, 10, 11, 12, 9, 13, 13, 10, 9, 13, 13, 14, 14, 14, 14, 10, 13, 14, 14, 14, 13, 13, 13, 9, 14, 14, 14, 15, 14, 15, 14, 15, 15, 14, 15, 15, 15, 14, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 12, 14, 15, 15, 13, 15, 15, 15, 15, 16, 16, 16, 15, 16, 14, 16, 16, 14, 16, 13, 16, 16, 16, 15, 16, 13, 16, 15, 16, 14, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13, 14, 16, 16, 15, 16, 16, 10, 16, 15, 16, 14, 16, 16, 14, 16, 16, 14, 16, 16, 14, 15, 16, 16, 16, 14, 15, 14, 15, 13, 16, 16, 15, 17, 17, 17, 17, 17, 17, 14, 15, 17, 17, 16, 16, 17, 16, 15, 17, 16, 17, 11, 17, 16, 17, 16, 17, 16, 17, 17, 16, 17, 17, 16, 17, 17, 16, 16, 17, 17, 17, 16, 14, 17, 17, 17, 17, 15, 16, 14, 16, 15, 16, 13, 16, 15, 16, 14, 16, 15, 16, 12, 16, 15, 16, 17, 17, 17, 17, 17, 13, 16, 15, 17, 17, 17, 16, 15, 17, 17, 17, 16, 15, 17, 17, 14, 16, 17, 17, 16, 17, 17, 16, 15, 17, 16, 14, 17, 16, 15, 17, 16, 17, 17, 16, 17, 15, 16, 17, 14, 17, 16, 15, 17, 16, 17, 13, 17, 16, 17, 17, 16, 17, 14, 17, 16, 17, 16, 17, 16, 17, 9];
        n.getBounds = function(n) {
            var i = 0 | this.blurX,
                r = 0 | this.blurY,
                t;
            return i <= 0 && r <= 0 ? n : (t = Math.pow(this.quality, .2), (n || new createjs.Rectangle).pad(r * t + 1, i * t + 1, r * t + 1, i * t + 1))
        };
        n.clone = function() {
            return new t(this.blurX, this.blurY, this.quality)
        };
        n.toString = function() {
            return "[BlurFilter]"
        };
        n._applyFilter = function(n) {
            var g = this._blurX >> 1,
                v, y, ut, o;
            if (isNaN(g) || g < 0 || (v = this._blurY >> 1, isNaN(v) || v < 0) || 0 == g && 0 == v) return !1;
            y = this.quality;
            (isNaN(y) || y < 1) && (y = 1);
            3 < (y |= 0) && (y = 3);
            y < 1 && (y = 1);
            for (var i = n.data, a = 0, nt = 0, e = 0, r = 0, lt = 0, f = 0, at = 0, p = 0, w = 0, b = 0, k = 0, ft = 0, et = 0, ot = 0, h = 0, vt = g + g + 1 | 0, yt = v + v + 1 | 0, d = 0 | n.width, st = 0 | n.height, ht = d - 1 | 0, rt = st - 1 | 0, it = 1 + g | 0, tt = 1 + v | 0, ct = {
                    r: 0,
                    b: 0,
                    g: 0,
                    a: 0
                }, s = ct, e = 1; e < vt; e++) s = s.n = {
                r: 0,
                b: 0,
                g: 0,
                a: 0
            };
            for (s.n = ct, ut = {
                    r: 0,
                    b: 0,
                    g: 0,
                    a: 0
                }, o = ut, e = 1; e < yt; e++) o = o.n = {
                r: 0,
                b: 0,
                g: 0,
                a: 0
            };
            o.n = ut;
            for (var u = null, pt = 0 | t.MUL_TABLE[g], wt = 0 | t.SHG_TABLE[g], bt = 0 | t.MUL_TABLE[v], kt = 0 | t.SHG_TABLE[v]; 0 < y--;) {
                at = f = 0;
                for (var c = pt, l = wt, nt = st; - 1 < --nt;) {
                    for (p = it * (ft = i[0 | f]), w = it * (et = i[f + 1 | 0]), b = it * (ot = i[f + 2 | 0]), k = it * (h = i[f + 3 | 0]), s = ct, e = it; - 1 < --e;) s.r = ft, s.g = et, s.b = ot, s.a = h, s = s.n;
                    for (e = 1; e < it; e++) r = f + ((ht < e ? ht : e) << 2) | 0, p += s.r = i[r], w += s.g = i[r + 1], b += s.b = i[r + 2], k += s.a = i[r + 3], s = s.n;
                    for (u = ct, a = 0; a < d; a++) i[f++] = p * c >>> l, i[f++] = w * c >>> l, i[f++] = b * c >>> l, i[f++] = k * c >>> l, r = at + ((r = a + g + 1) < ht ? r : ht) << 2, p -= u.r - (u.r = i[r]), w -= u.g - (u.g = i[r + 1]), b -= u.b - (u.b = i[r + 2]), k -= u.a - (u.a = i[r + 3]), u = u.n;
                    at += d
                }
                for (c = bt, l = kt, a = 0; a < d; a++) {
                    for (p = tt * (ft = i[f = a << 2 | 0]) | 0, w = tt * (et = i[f + 1 | 0]) | 0, b = tt * (ot = i[f + 2 | 0]) | 0, k = tt * (h = i[f + 3 | 0]) | 0, o = ut, e = 0; e < tt; e++) o.r = ft, o.g = et, o.b = ot, o.a = h, o = o.n;
                    for (lt = d, e = 1; e <= v; e++) f = lt + a << 2, p += o.r = i[f], w += o.g = i[f + 1], b += o.b = i[f + 2], k += o.a = i[f + 3], o = o.n, e < rt && (lt += d);
                    if (f = a, u = ut, 0 < y)
                        for (nt = 0; nt < st; nt++) i[(r = f << 2) + 3] = h = k * c >>> l, 0 < h ? (i[r] = p * c >>> l, i[r + 1] = w * c >>> l, i[r + 2] = b * c >>> l) : i[r] = i[r + 1] = i[r + 2] = 0, r = a + ((r = nt + tt) < rt ? r : rt) * d << 2, p -= u.r - (u.r = i[r]), w -= u.g - (u.g = i[r + 1]), b -= u.b - (u.b = i[r + 2]), k -= u.a - (u.a = i[r + 3]), u = u.n, f += d;
                    else
                        for (nt = 0; nt < st; nt++) i[(r = f << 2) + 3] = h = k * c >>> l, 0 < h ? (h = 255 / h, i[r] = (p * c >>> l) * h, i[r + 1] = (w * c >>> l) * h, i[r + 2] = (b * c >>> l) * h) : i[r] = i[r + 1] = i[r + 2] = 0, r = a + ((r = nt + tt) < rt ? r : rt) * d << 2, p -= u.r - (u.r = i[r]), w -= u.g - (u.g = i[r + 1]), b -= u.b - (u.b = i[r + 2]), k -= u.a - (u.a = i[r + 3]), u = u.n, f += d
                }
            }
            return !0
        };
        createjs.BlurFilter = createjs.promote(t, "Filter")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.Filter_constructor();
            this.alphaMap = n;
            this._alphaMap = null;
            this._mapData = null;
            this._mapTexture = null;
            this.FRAG_SHADER_BODY = "uniform sampler2D uAlphaSampler;void main(void) {vec4 color = texture2D(uSampler, vRenderCoord);vec4 alphaMap = texture2D(uAlphaSampler, vTextureCoord);gl_FragColor = vec4(color.rgb, color.a * (alphaMap.r * ceil(alphaMap.a)));}"
        }
        var n = createjs.extend(t, createjs.Filter);
        n.shaderParamSetup = function(n, t, i) {
            this._mapTexture || (this._mapTexture = n.createTexture());
            n.activeTexture(n.TEXTURE1);
            n.bindTexture(n.TEXTURE_2D, this._mapTexture);
            t.setTextureParams(n);
            n.texImage2D(n.TEXTURE_2D, 0, n.RGBA, n.RGBA, n.UNSIGNED_BYTE, this.alphaMap);
            n.uniform1i(n.getUniformLocation(i, "uAlphaSampler"), 1)
        };
        n.clone = function() {
            var n = new t(this.alphaMap);
            return n._alphaMap = this._alphaMap, n._mapData = this._mapData, n
        };
        n.toString = function() {
            return "[AlphaMapFilter]"
        };
        n._applyFilter = function(n) {
            if (!this.alphaMap) return !0;
            if (!this._prepAlphaMap()) return !1;
            for (var i = n.data, r = this._mapData, t = 0, u = i.length; t < u; t += 4) i[t + 3] = r[t] || 0;
            return !0
        };
        n._prepAlphaMap = function() {
            var i, n, t, r;
            if (!this.alphaMap) return !1;
            if (this.alphaMap == this._alphaMap && this._mapData) return !0;
            this._mapData = null;
            n = this._alphaMap = this.alphaMap;
            t = n;
            n instanceof HTMLCanvasElement ? i = t.getContext("2d", createjs.willReadFrequently ? {
                willReadFrequently: !0
            } : void 0) : ((t = createjs.createCanvas ? createjs.createCanvas() : document.createElement("canvas")).width = n.width, t.height = n.height, (i = t.getContext("2d", createjs.willReadFrequently ? {
                willReadFrequently: !0
            } : void 0)).drawImage(n, 0, 0));
            try {
                r = i.getImageData(0, 0, n.width, n.height)
            } catch (i) {
                return !1
            }
            return this._mapData = r.data, !0
        };
        createjs.AlphaMapFilter = createjs.promote(t, "Filter")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.Filter_constructor();
            this.mask = n;
            this.usesContext = !0;
            this.FRAG_SHADER_BODY = "uniform sampler2D uAlphaSampler;void main(void) {vec4 color = texture2D(uSampler, vRenderCoord);vec4 alphaMap = texture2D(uAlphaSampler, vTextureCoord);gl_FragColor = vec4(color.rgb, color.a * alphaMap.a);}"
        }
        var n = createjs.extend(t, createjs.Filter);
        n.shaderParamSetup = function(n, t, i) {
            this._mapTexture || (this._mapTexture = n.createTexture());
            n.activeTexture(n.TEXTURE1);
            n.bindTexture(n.TEXTURE_2D, this._mapTexture);
            t.setTextureParams(n);
            n.texImage2D(n.TEXTURE_2D, 0, n.RGBA, n.RGBA, n.UNSIGNED_BYTE, this.mask);
            n.uniform1i(n.getUniformLocation(i, "uAlphaSampler"), 1)
        };
        n.applyFilter = function(n, t, i, r, u, f, e, o) {
            return !this.mask || (null == e && (e = t), null == o && (o = i), (f = f || n).save(), n == f && (f.globalCompositeOperation = "destination-in", f.drawImage(this.mask, e, o), f.restore(), !0))
        };
        n.clone = function() {
            return new t(this.mask)
        };
        n.toString = function() {
            return "[AlphaMaskFilter]"
        };
        createjs.AlphaMaskFilter = createjs.promote(t, "Filter")
    }(),
    function() {
        "use strict";

        function t(n, t, i, r, u, f, e, o) {
            this.Filter_constructor();
            this.redMultiplier = null != n ? n : 1;
            this.greenMultiplier = null != t ? t : 1;
            this.blueMultiplier = null != i ? i : 1;
            this.alphaMultiplier = null != r ? r : 1;
            this.redOffset = u || 0;
            this.greenOffset = f || 0;
            this.blueOffset = e || 0;
            this.alphaOffset = o || 0;
            this.FRAG_SHADER_BODY = "uniform vec4 uColorMultiplier;uniform vec4 uColorOffset;void main(void) {vec4 color = texture2D(uSampler, vRenderCoord);gl_FragColor = (color * uColorMultiplier) + uColorOffset;}"
        }
        var n = createjs.extend(t, createjs.Filter);
        n.shaderParamSetup = function(n, t, i) {
            n.uniform4f(n.getUniformLocation(i, "uColorMultiplier"), this.redMultiplier, this.greenMultiplier, this.blueMultiplier, this.alphaMultiplier);
            n.uniform4f(n.getUniformLocation(i, "uColorOffset"), this.redOffset / 255, this.greenOffset / 255, this.blueOffset / 255, this.alphaOffset / 255)
        };
        n.toString = function() {
            return "[ColorFilter]"
        };
        n.clone = function() {
            return new t(this.redMultiplier, this.greenMultiplier, this.blueMultiplier, this.alphaMultiplier, this.redOffset, this.greenOffset, this.blueOffset, this.alphaOffset)
        };
        n._applyFilter = function(n) {
            for (var i = n.data, r = i.length, t = 0; t < r; t += 4) i[t] = i[t] * this.redMultiplier + this.redOffset, i[t + 1] = i[t + 1] * this.greenMultiplier + this.greenOffset, i[t + 2] = i[t + 2] * this.blueMultiplier + this.blueOffset, i[t + 3] = i[t + 3] * this.alphaMultiplier + this.alphaOffset;
            return !0
        };
        createjs.ColorFilter = createjs.promote(t, "Filter")
    }(),
    function() {
        "use strict";

        function n(n, t, i, r) {
            this.setColor(n, t, i, r)
        }
        var t = n.prototype;
        n.DELTA_INDEX = [0, .01, .02, .04, .05, .06, .07, .08, .1, .11, .12, .14, .15, .16, .17, .18, .2, .21, .22, .24, .25, .27, .28, .3, .32, .34, .36, .38, .4, .42, .44, .46, .48, .5, .53, .56, .59, .62, .65, .68, .71, .74, .77, .8, .83, .86, .89, .92, .95, .98, 1, 1.06, 1.12, 1.18, 1.24, 1.3, 1.36, 1.42, 1.48, 1.54, 1.6, 1.66, 1.72, 1.78, 1.84, 1.9, 1.96, 2, 2.12, 2.25, 2.37, 2.5, 2.62, 2.75, 2.87, 3, 3.2, 3.4, 3.6, 3.8, 4, 4.3, 4.7, 4.9, 5, 5.5, 6, 6.5, 6.8, 7, 7.3, 7.5, 7.8, 8, 8.4, 8.7, 9, 9.4, 9.6, 9.8, 10];
        n.LENGTH = (n.IDENTITY_MATRIX = [1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1]).length;
        t.setColor = function(n, t, i, r) {
            return this.reset().adjustColor(n, t, i, r)
        };
        t.reset = function() {
            return this.copy(n.IDENTITY_MATRIX)
        };
        t.adjustColor = function(n, t, i, r) {
            return this.adjustHue(r), this.adjustContrast(t), this.adjustBrightness(n), this.adjustSaturation(i)
        };
        t.adjustBrightness = function(n) {
            return 0 == n || isNaN(n) || (n = this._cleanValue(n, 255), this._multiplyMatrix([1, 0, 0, 0, n, 0, 1, 0, 0, n, 0, 0, 1, 0, n, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1])), this
        };
        t.adjustContrast = function(t) {
            return 0 == t || isNaN(t) || (i = (t = this._cleanValue(t, 100)) < 0 ? 127 + t / 100 * 127 : 127 * (i = 0 == (i = t % 1) ? n.DELTA_INDEX[t] : n.DELTA_INDEX[t << 0] * (1 - i) + n.DELTA_INDEX[1 + (t << 0)] * i) + 127, this._multiplyMatrix([i / 127, 0, 0, 0, .5 * (127 - i), 0, i / 127, 0, 0, .5 * (127 - i), 0, 0, i / 127, 0, .5 * (127 - i), 0, 0, 0, 1, 0, 0, 0, 0, 0, 1])), this;
            var i
        };
        t.adjustSaturation = function(n) {
            return 0 == n || isNaN(n) ? this : (n = 1 + (0 < (n = this._cleanValue(n, 100)) ? 3 * n / 100 : n / 100), this._multiplyMatrix([.3086 * (1 - n) + n, .6094 * (1 - n), .082 * (1 - n), 0, 0, .3086 * (1 - n), .6094 * (1 - n) + n, .082 * (1 - n), 0, 0, .3086 * (1 - n), .6094 * (1 - n), .082 * (1 - n) + n, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1]), this)
        };
        t.adjustHue = function(n) {
            if (0 == n || isNaN(n)) return this;
            n = this._cleanValue(n, 180) / 180 * Math.PI;
            var t = Math.cos(n),
                i = Math.sin(n),
                u = .213,
                r = .715,
                n = .072;
            return this._multiplyMatrix([u + .787 * t + i * -u, r + t * -r + i * -r, n + t * -n + .928 * i, 0, 0, u + t * -u + .143 * i, r + t * (1 - r) + .14 * i, n + t * -n + -.283 * i, 0, 0, u + t * -u + -.787 * i, r + t * -r + i * r, n + .928 * t + i * n, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1]), this
        };
        t.concat = function(t) {
            return (t = this._fixMatrix(t)).length != n.LENGTH || this._multiplyMatrix(t), this
        };
        t.clone = function() {
            return (new n).copy(this)
        };
        t.toArray = function() {
            for (var i = [], t = 0, r = n.LENGTH; t < r; t++) i[t] = this[t];
            return i
        };
        t.copy = function(t) {
            for (var r = n.LENGTH, i = 0; i < r; i++) this[i] = t[i];
            return this
        };
        t.toString = function() {
            return "[ColorMatrix]"
        };
        t._multiplyMatrix = function(n) {
            for (var t, f, r, u = [], i = 0; i < 5; i++) {
                for (t = 0; t < 5; t++) u[t] = this[t + 5 * i];
                for (t = 0; t < 5; t++) {
                    for (f = 0, r = 0; r < 5; r++) f += n[t + 5 * r] * u[r];
                    this[t + 5 * i] = f
                }
            }
        };
        t._cleanValue = function(n, t) {
            return Math.min(t, Math.max(-t, n))
        };
        t._fixMatrix = function(t) {
            return t instanceof n && (t = t.toArray()), t.length < n.LENGTH ? t = t.slice(0, t.length).concat(n.IDENTITY_MATRIX.slice(t.length, n.LENGTH)) : t.length > n.LENGTH && (t = t.slice(0, n.LENGTH)), t
        };
        createjs.ColorMatrix = n
    }(),
    function() {
        "use strict";

        function t(n) {
            this.Filter_constructor();
            this.matrix = n;
            this.FRAG_SHADER_BODY = "uniform mat4 uColorMatrix;uniform vec4 uColorMatrixOffset;void main(void) {vec4 color = texture2D(uSampler, vRenderCoord);mat4 m = uColorMatrix;vec4 newColor = vec4(0,0,0,0);newColor.r = color.r*m[0][0] + color.g*m[0][1] + color.b*m[0][2] + color.a*m[0][3];newColor.g = color.r*m[1][0] + color.g*m[1][1] + color.b*m[1][2] + color.a*m[1][3];newColor.b = color.r*m[2][0] + color.g*m[2][1] + color.b*m[2][2] + color.a*m[2][3];newColor.a = color.r*m[3][0] + color.g*m[3][1] + color.b*m[3][2] + color.a*m[3][3];gl_FragColor = newColor + uColorMatrixOffset;}"
        }
        var n = createjs.extend(t, createjs.Filter);
        n.shaderParamSetup = function(n, t, i) {
            var r = this.matrix,
                u = new Float32Array([r[0], r[1], r[2], r[3], r[5], r[6], r[7], r[8], r[10], r[11], r[12], r[13], r[15], r[16], r[17], r[18]]);
            n.uniformMatrix4fv(n.getUniformLocation(i, "uColorMatrix"), !1, u);
            n.uniform4f(n.getUniformLocation(i, "uColorMatrixOffset"), r[4] / 255, r[9] / 255, r[14] / 255, r[19] / 255)
        };
        n.toString = function() {
            return "[ColorMatrixFilter]"
        };
        n.clone = function() {
            return new t(this.matrix)
        };
        n._applyFilter = function(n) {
            for (var r, u, f, e, i = n.data, o = i.length, n = this.matrix, s = n[0], h = n[1], c = n[2], l = n[3], a = n[4], v = n[5], y = n[6], p = n[7], w = n[8], b = n[9], k = n[10], d = n[11], g = n[12], nt = n[13], tt = n[14], it = n[15], rt = n[16], ut = n[17], ft = n[18], et = n[19], t = 0; t < o; t += 4) r = i[t], u = i[t + 1], f = i[t + 2], e = i[t + 3], i[t] = r * s + u * h + f * c + e * l + a, i[t + 1] = r * v + u * y + f * p + e * w + b, i[t + 2] = r * k + u * d + f * g + e * nt + tt, i[t + 3] = r * it + u * rt + f * ut + e * ft + et;
            return !0
        };
        createjs.ColorMatrixFilter = createjs.promote(t, "Filter")
    }(),
    function() {
        "use strict";

        function n() {
            throw "Touch cannot be instantiated";
        }
        n.isSupported = function() {
            return !!("ontouchstart" in window || window.MSPointerEvent && 0 < window.navigator.msMaxTouchPoints || window.PointerEvent && 0 < window.navigator.maxTouchPoints)
        };
        n.enable = function(t, i, r, u) {
            return !!(t && t.canvas && n.isSupported()) && (t.__touch || (t.__touch = {
                pointers: {},
                multitouch: !i,
                preventDefault: !r,
                count: 0
            }, u ? "ontouchstart" in window ? n._enable(t) : (window.PointerEvent || window.MSPointerEvent) && n._IE_enable(t) : "ontouchstart" in window || createjs.BrowserDetect.isChrome || createjs.BrowserDetect.isEdge || createjs.BrowserDetect.isFirefox ? n._enable(t) : (window.PointerEvent || window.MSPointerEvent) && n._IE_enable(t)), !0)
        };
        n.disable = function(t) {
            t && t.__touch && ("ontouchstart" in window || createjs.BrowserDetect.isChrome || createjs.BrowserDetect.isFirefox ? n._disable(t) : (window.PointerEvent || window.MSPointerEvent) && n._IE_disable(t), delete t.__touch)
        };
        n._enable = function(t) {
            var i = t.canvas,
                r = t.__touch.f = function(i) {
                    n._handleEvent(t, i)
                };
            i.addEventListener("pointerdown", function(n) {
                t.__touch && t.__touch.preventDefault || ("touch" == n.pointerType ? t.enableDOMEvents(!1) : "mouse" == n.pointerType && t.enableDOMEvents(!0))
            }, !1);
            i.addEventListener("touchstart", r, !1);
            i.addEventListener("touchmove", r, !1);
            i.addEventListener("touchend", r, !1);
            i.addEventListener("touchcancel", r, !1)
        };
        n._disable = function(n) {
            var t = n.canvas;
            t && (n = n.__touch.f, t.removeEventListener("touchstart", n, !1), t.removeEventListener("touchmove", n, !1), t.removeEventListener("touchend", n, !1), t.removeEventListener("touchcancel", n, !1))
        };
        n._handleEvent = function(n, t) {
            var i, u;
            if (n) {
                n.__touch && n.__touch.preventDefault && t.preventDefault && t.preventDefault();
                for (var e = t.changedTouches, r = t.type, f = 0, o = e.length; f < o; f++) i = e[f], u = i.identifier, i.target == n.canvas && ("touchstart" === r ? this._handleStart(n, u, t, i.pageX, i.pageY) : "touchmove" === r ? this._handleMove(n, u, t, i.pageX, i.pageY) : "touchend" !== r && "touchcancel" !== r || this._handleEnd(n, u, t))
            }
        };
        n._IE_enable = function(t) {
            var r = t.canvas,
                i = t.__touch.f = function(i) {
                    n._IE_handleEvent(t, i)
                };
            r.style["-webkit-tap-highlight-color"] = "transparent";
            void 0 === window.PointerEvent ? (r.addEventListener("MSPointerDown", i, !1), window.addEventListener("MSPointerMove", i, !1), window.addEventListener("MSPointerUp", i, !1), window.addEventListener("MSPointerCancel", i, !1), t.__touch && t.__touch.preventDefault && (r.style.msTouchAction = "none")) : (r.addEventListener("pointerdown", i, !1), window.addEventListener("pointermove", i, !1), window.addEventListener("pointerup", i, !1), window.addEventListener("pointercancel", i, !1), t.__touch && t.__touch.preventDefault && (r.style.touchAction = "none"));
            t.__touch.activeIDs = {}
        };
        n._IE_disable = function(n) {
            var t = n.__touch.f;
            void 0 === window.PointerEvent ? (window.removeEventListener("MSPointerMove", t, !1), window.removeEventListener("MSPointerUp", t, !1), window.removeEventListener("MSPointerCancel", t, !1), n.canvas && n.canvas.removeEventListener("MSPointerDown", t, !1)) : (window.removeEventListener("pointermove", t, !1), window.removeEventListener("pointerup", t, !1), window.removeEventListener("pointercancel", t, !1), n.canvas && n.canvas.removeEventListener("pointerdown", t, !1))
        };
        n._IE_handleEvent = function(n, t) {
            if (n) {
                n.__touch && n.__touch.preventDefault && t.preventDefault && t.preventDefault();
                var i = t.type,
                    r = t.pointerId,
                    u = n.__touch.activeIDs;
                if ("MSPointerDown" === i || "pointerdown" === i) {
                    if (t.srcElement == n.canvas) switch (u[r] = !0, this._handleStart(n, r, t, t.pageX, t.pageY), t.pointerType) {
                        case "mouse":
                            n.enableDOMEvents(!0);
                            break;
                        case "touch":
                            n.enableDOMEvents(!1)
                    }
                } else u[r] && ("MSPointerMove" === i || "pointermove" === i ? this._handleMove(n, r, t, t.pageX, t.pageY) : "MSPointerUp" !== i && "MSPointerCancel" !== i && "pointerup" !== i && "pointercancel" !== i || (delete u[r], this._handleEnd(n, r, t)))
            }
        };
        n._handleStart = function(n, t, i, r, u) {
            var e, f = n.__touch;
            !f.multitouch && f.count || (e = f.pointers)[t] || (e[t] = !0, f.count++, n._handlePointerDown(t, i, r, u))
        };
        n._handleMove = function(n, t, i, r, u) {
            n.__touch.pointers[t] && n._handlePointerMove(t, i, r, u)
        };
        n._handleEnd = function(n, t, i) {
            var r = n.__touch,
                u = r.pointers;
            u[t] && (r.count--, n._handlePointerUp(t, i, !0), delete u[t])
        };
        createjs.Touch = n
    }(),
    function() {
        "use strict";
        var n = createjs.EaselJS = createjs.EaselJS || {};
        n.version = "1.0.0";
        n.buildDate = "Thu, 12 Oct 2017 16:34:05 GMT"
    }(),
    function() {
        "use strict";
        var n = createjs.PreloadJS = createjs.PreloadJS || {};
        n.version = "NEXT";
        n.buildDate = "Thu, 14 Sep 2017 22:19:45 GMT"
    }(),
    function() {
        "use strict";
        createjs.proxy = function(n, t) {
            var i = Array.prototype.slice.call(arguments, 2);
            return function() {
                return n.apply(t, Array.prototype.slice.call(arguments, 0).concat(i))
            }
        }
    }(),
    function() {
        "use strict";

        function n(n, t, i) {
            this.Event_constructor("error");
            this.title = n;
            this.message = t;
            this.data = i
        }
        createjs.extend(n, createjs.Event).clone = function() {
            return new createjs.ErrorEvent(this.title, this.message, this.data)
        };
        createjs.ErrorEvent = createjs.promote(n, "Event")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.Event_constructor("progress");
            this.loaded = n;
            this.total = null == t ? 1 : t;
            this.progress = 0 == t ? 0 : this.loaded / this.total
        }
        createjs.extend(n, createjs.Event).clone = function() {
            return new createjs.ProgressEvent(this.loaded, this.total)
        };
        createjs.ProgressEvent = createjs.promote(n, "Event")
    }(window),
    function() {
        function s(t, i) {
            function y(n) {
                var o, u, c, t, s, f, r;
                if (y[n] !== h) return y[n];
                if ("bug-string-char-index" == n) o = "a" != "a" [0];
                else if ("json" == n) o = y("json-stringify") && y("json-parse");
                else {
                    if (c = '{"a":[1,true,false,null,"\\u0000\\b\\n\\f\\r\\t"]}', "json-stringify" == n) {
                        if (t = i.stringify, s = "function" == typeof t && a, s) {
                            (u = function() {
                                return 1
                            }).toJSON = u;
                            try {
                                s = "0" === t(0) && "0" === t(new yt) && '""' == t(new ht) && t(e) === h && t(h) === h && t() === h && "1" === t(u) && "[1]" == t([u]) && "[null]" == t([h]) && "null" == t(null) && "[null,null,null]" == t([h, e, null]) && t({
                                    a: [u, !0, !1, null, "\0\b\n\f\r\t"]
                                }) == c && "1" === t(null, u) && "[\n 1,\n 2\n]" == t([1, 2], null, 1) && '"-271821-04-20T00:00:00.000Z"' == t(new k(-864e13)) && '"+275760-09-13T00:00:00.000Z"' == t(new k(864e13)) && '"-000001-01-01T00:00:00.000Z"' == t(new k(-621987552e5)) && '"1969-12-31T23:59:59.999Z"' == t(new k(-1))
                            } catch (n) {
                                s = !1
                            }
                        }
                        o = s
                    }
                    if ("json-parse" == n) {
                        if (f = i.parse, "function" == typeof f) try {
                            if (0 === f("0") && !f(!1) && (r = 5 == (u = f(c)).a.length && 1 === u.a[0], r)) {
                                try {
                                    r = !f('"\t"')
                                } catch (n) {}
                                if (r) try {
                                    r = 1 !== f("01")
                                } catch (n) {}
                                if (r) try {
                                    r = 1 !== f("1.")
                                } catch (n) {}
                            }
                        } catch (n) {
                            r = !1
                        }
                        o = r
                    }
                }
                return y[n] = !!o
            }
            t = t || n.Object();
            i = i || n.Object();
            var yt = t.Number || n.Number,
                ht = t.String || n.String,
                ft = t.Object || n.Object,
                k = t.Date || n.Date,
                pt = t.SyntaxError || n.SyntaxError,
                wt = t.TypeError || n.TypeError,
                bt = t.Math || n.Math,
                t = t.JSON || n.JSON;
            "object" == typeof t && t && (i.stringify = t.stringify, i.parse = t.parse);
            var o, tt, h, p, d, g, nt, w, c, ct, b, lt, l, et, it, at, vt, u, rt, f, v, ut, ot, st, ft = ft.prototype,
                e = ft.toString,
                a = new k(-0xc782b5b800cec);
            try {
                a = -109252 == a.getUTCFullYear() && 0 === a.getUTCMonth() && 1 === a.getUTCDate() && 10 == a.getUTCHours() && 37 == a.getUTCMinutes() && 6 == a.getUTCSeconds() && 708 == a.getUTCMilliseconds()
            } catch (t) {}
            return y("json") || (p = "[object Function]", d = "[object Number]", g = "[object String]", nt = "[object Array]", w = y("bug-string-char-index"), a || (c = bt.floor, ct = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334], b = function(n, t) {
                return ct[t] + 365 * (n - 1970) + c((n - 1969 + (t = +(1 < t))) / 4) - c((n - 1901 + t) / 100) + c((n - 1601 + t) / 400)
            }), (o = ft.hasOwnProperty) || (o = function(n) {
                var i, t = {
                    __proto__: null
                };
                return t.__proto__ = {
                    toString: 1
                }, o = t.toString != e ? function(n) {
                    var t = this.__proto__,
                        n = n in (this.__proto__ = null, this);
                    return this.__proto__ = t, n
                } : (i = t.constructor, function(n) {
                    var t = (this.constructor || i).prototype;
                    return n in this && !(n in t && this[n] === t[n])
                }), t = null, o.call(this, n)
            }), tt = function(n, t) {
                var u, i, s, f = 0;
                for (s in (u = function() {
                        this.valueOf = 0
                    }).prototype.valueOf = 0, i = new u) o.call(i, s) && f++;
                return u = i = null, (tt = f ? 2 == f ? function(n, t) {
                    var i, r = {},
                        u = e.call(n) == p;
                    for (i in n)(!u || "prototype" != i) && !o.call(r, i) && (r[i] = 1) && o.call(n, i) && t(i)
                } : function(n, t) {
                    var i, r, u = e.call(n) == p;
                    for (i in n) u && "prototype" == i || !o.call(n, i) || (r = "constructor" === i) || t(i);
                    (r || o.call(n, i = "constructor")) && t(i)
                } : (i = ["valueOf", "toString", "toLocaleString", "propertyIsEnumerable", "isPrototypeOf", "hasOwnProperty", "constructor"], function(n, t) {
                    var u, f, s = e.call(n) == p,
                        h = !s && "function" != typeof n.constructor && r[typeof n.hasOwnProperty] && n.hasOwnProperty || o;
                    for (u in n) s && "prototype" == u || !h.call(n, u) || t(u);
                    for (f = i.length; u = i[--f]; h.call(n, u) && t(u));
                }))(n, t)
            }, y("json-stringify") || (lt = {
                92: "\\\\",
                34: '\\"',
                8: "\\b",
                12: "\\f",
                10: "\\n",
                13: "\\r",
                9: "\\t"
            }, l = function(n, t) {
                return ("000000" + (t || 0)).slice(-n)
            }, et = function(n) {
                for (var i, r = '"', t = 0, u = n.length, f = !w || 10 < u, e = f && (w ? n.split("") : n); t < u; t++) {
                    i = n.charCodeAt(t);
                    switch (i) {
                        case 8:
                        case 9:
                        case 10:
                        case 12:
                        case 13:
                        case 34:
                        case 92:
                            r += lt[i];
                            break;
                        default:
                            if (i < 32) {
                                r += "\\u00" + l(2, i.toString(16));
                                break
                            }
                            r += f ? e[t] : n.charAt(t)
                    }
                }
                return r + '"'
            }, it = function(n, t, i, r, u, f, s) {
                var a, k, v, rt, p, ot, st, ht, w, ct, ft, ut, y, lt;
                try {
                    a = t[n]
                } catch (n) {}
                if ("object" == typeof a && a)
                    if ("[object Date]" != (k = e.call(a)) || o.call(a, "toJSON")) "function" == typeof a.toJSON && (k != d && k != g && k != nt || o.call(a, "toJSON")) && (a = a.toJSON(n));
                    else if (-1 / 0 < a && a < 1 / 0) {
                    if (b) {
                        for (p = c(a / 864e5), v = c(p / 365.2425) + 1970 - 1; b(v + 1, 0) <= p; v++);
                        for (rt = c((p - b(v, 0)) / 30.42); b(v, rt + 1) <= p; rt++);
                        p = 1 + p - b(v, rt);
                        ot = c((y = (a % 864e5 + 864e5) % 864e5) / 36e5) % 24;
                        st = c(y / 6e4) % 60;
                        ht = c(y / 1e3) % 60;
                        y = y % 1e3
                    } else v = a.getUTCFullYear(), rt = a.getUTCMonth(), p = a.getUTCDate(), ot = a.getUTCHours(), st = a.getUTCMinutes(), ht = a.getUTCSeconds(), y = a.getUTCMilliseconds();
                    a = (v <= 0 || 1e4 <= v ? (v < 0 ? "-" : "+") + l(6, v < 0 ? -v : v) : l(4, v)) + "-" + l(2, rt + 1) + "-" + l(2, p) + "T" + l(2, ot) + ":" + l(2, st) + ":" + l(2, ht) + "." + l(3, y) + "Z"
                } else a = null;
                if (i && (a = i.call(t, n, a)), null === a) return "null";
                if ("[object Boolean]" == (k = e.call(a))) return "" + a;
                if (k == d) return -1 / 0 < a && a < 1 / 0 ? "" + a : "null";
                if (k == g) return et("" + a);
                if ("object" == typeof a) {
                    for (ut = s.length; ut--;)
                        if (s[ut] === a) throw wt();
                    if (s.push(a), w = [], y = f, f += u, k == nt) {
                        for (ft = 0, ut = a.length; ft < ut; ft++) ct = it(ft, a, i, r, u, f, s), w.push(ct === h ? "null" : ct);
                        lt = w.length ? u ? "[\n" + f + w.join(",\n" + f) + "\n" + y + "]" : "[" + w.join(",") + "]" : "[]"
                    } else tt(r || a, function(n) {
                        var t = it(n, a, i, r, u, f, s);
                        t !== h && w.push(et(n) + ":" + (u ? " " : "") + t)
                    }), lt = w.length ? u ? "{\n" + f + w.join(",\n" + f) + "\n" + y + "}" : "{" + w.join(",") + "}" : "{}";
                    return s.pop(), lt
                }
            }, i.stringify = function(n, t, i) {
                var f, c, s, u, o, h, l;
                if (r[typeof t] && t)
                    if ((u = e.call(t)) == p) c = t;
                    else if (u == nt)
                    for (s = {}, h = 0, l = t.length; h < l; o = t[h++], (u = e.call(o)) != g && u != d || (s[o] = 1));
                if (i)
                    if ((u = e.call(i)) == d) {
                        if (0 < (i -= i % 1))
                            for (f = "", 10 < i && (i = 10); f.length < i; f += " ");
                    } else u == g && (f = i.length <= 10 ? i : i.slice(0, 10));
                return it("", ((o = {})[""] = n, o), c, s, f, "", [])
            }), y("json-parse") || (at = ht.fromCharCode, vt = {
                92: "\\",
                34: '"',
                47: "/",
                98: "\b",
                116: "\t",
                110: "\n",
                102: "\f",
                114: "\r"
            }, f = function() {
                throw u = rt = null, pt();
            }, v = function() {
                for (var r, e, i, s, n, t = rt, o = t.length; u < o;) switch (n = t.charCodeAt(u)) {
                    case 9:
                    case 10:
                    case 13:
                    case 32:
                        u++;
                        break;
                    case 123:
                    case 125:
                    case 91:
                    case 93:
                    case 58:
                    case 44:
                        return r = w ? t.charAt(u) : t[u], u++, r;
                    case 34:
                        for (r = "@", u++; u < o;)
                            if ((n = t.charCodeAt(u)) < 32) f();
                            else if (92 == n) switch (n = t.charCodeAt(++u)) {
                            case 92:
                            case 34:
                            case 47:
                            case 98:
                            case 116:
                            case 110:
                            case 102:
                            case 114:
                                r += vt[n];
                                u++;
                                break;
                            case 117:
                                for (e = ++u, i = u + 4; u < i; u++) 48 <= (n = t.charCodeAt(u)) && n <= 57 || 97 <= n && n <= 102 || 65 <= n && n <= 70 || f();
                                r += at("0x" + t.slice(e, u));
                                break;
                            default:
                                f()
                        } else {
                            if (34 == n) break;
                            for (n = t.charCodeAt(u), e = u; 32 <= n && 92 != n && 34 != n;) n = t.charCodeAt(++u);
                            r += t.slice(e, u)
                        }
                        if (34 == t.charCodeAt(u)) return u++, r;
                        f();
                    default:
                        if (e = u, 45 == n && (s = !0, n = t.charCodeAt(++u)), 48 <= n && n <= 57) {
                            for (48 == n && 48 <= (n = t.charCodeAt(u + 1)) && n <= 57 && f(), s = !1; u < o && 48 <= (n = t.charCodeAt(u)) && n <= 57; u++);
                            if (46 == t.charCodeAt(u)) {
                                for (i = ++u; i < o && 48 <= (n = t.charCodeAt(i)) && n <= 57; i++);
                                i == u && f();
                                u = i
                            }
                            if (101 == (n = t.charCodeAt(u)) || 69 == n) {
                                for (43 != (n = t.charCodeAt(++u)) && 45 != n || u++, i = u; i < o && 48 <= (n = t.charCodeAt(i)) && n <= 57; i++);
                                i == u && f();
                                u = i
                            }
                            return +t.slice(e, u)
                        }
                        if (s && f(), "true" == t.slice(u, u + 4)) return u += 4, !0;
                        if ("false" == t.slice(u, u + 5)) return u += 5, !1;
                        if ("null" == t.slice(u, u + 4)) return u += 4, null;
                        f()
                }
                return "$"
            }, ut = function(n) {
                var t, i;
                if ("$" == n && f(), "string" == typeof n) {
                    if ("@" == (w ? n.charAt(0) : n[0])) return n.slice(1);
                    if ("[" == n) {
                        for (t = [];
                            "]" != (n = v()); i = i || !0) i && ("," != n || "]" == (n = v())) && f(), "," == n && f(), t.push(ut(n));
                        return t
                    }
                    if ("{" == n) {
                        for (t = {};
                            "}" != (n = v()); i = i || !0) i && ("," != n || "}" == (n = v())) && f(), "," != n && "string" == typeof n && "@" == (w ? n.charAt(0) : n[0]) && ":" == v() || f(), t[n.slice(1)] = ut(v());
                        return t
                    }
                    f()
                }
                return n
            }, ot = function(n, t, i) {
                i = st(n, t, i);
                i === h ? delete n[t] : n[t] = i
            }, st = function(n, t, i) {
                var u, r = n[t];
                if ("object" == typeof r && r)
                    if (e.call(r) == nt)
                        for (u = r.length; u--;) ot(r, u, i);
                    else tt(r, function(n) {
                        ot(r, n, i)
                    });
                return i.call(n, t, r)
            }, i.parse = function(n, t) {
                var i;
                return u = 0, rt = "" + n, i = ut(v()), "$" != v() && f(), u = rt = null, t && e.call(t) == p ? st(((n = {})[""] = i, n), "", t) : i
            })), i.runInContext = s, i
        }
        var u, f, e, i, h = "function" == typeof define && define.amd,
            r = {
                "function": !0,
                object: !0
            },
            o = r[typeof exports] && exports && !exports.nodeType && exports,
            n = r[typeof window] && window || this,
            t = o && r[typeof module] && module && !module.nodeType && "object" == typeof global && global;
        t && (t.global === t || t.window === t || t.self === t) && (n = t);
        o && !h ? s(n, o) : (u = n.JSON, f = n.JSON3, e = !1, i = s(n, n.JSON3 = {
            noConflict: function() {
                return e || (e = !0, n.JSON = u, n.JSON3 = f, u = f = null), i
            }
        }), n.JSON = {
            parse: i.parse,
            stringify: i.stringify
        });
        h && define(function() {
            return i
        })
    }.call(this),
    function() {
        var n = {
            a: function() {
                return n.el("a")
            },
            svg: function() {
                return n.el("svg")
            },
            object: function() {
                return n.el("object")
            },
            image: function() {
                return n.el("image")
            },
            img: function() {
                return n.el("img")
            },
            style: function() {
                return n.el("style")
            },
            link: function() {
                return n.el("link")
            },
            script: function() {
                return n.el("script")
            },
            audio: function() {
                return n.el("audio")
            },
            video: function() {
                return n.el("video")
            },
            text: function(n) {
                return document.createTextNode(n)
            },
            el: function(n) {
                return document.createElement(n)
            }
        };
        createjs.Elements = n
    }(),
    function() {
        var n = {
            ABSOLUTE_PATT: /^(?:\w+:)?\/{2}/i,
            RELATIVE_PATT: /^[./]*?\//i,
            EXTENSION_PATT: /\/?[^/]+\.(\w{1,5})$/i,
            parseURI: function(t) {
                var i = {
                        absolute: !1,
                        relative: !1,
                        protocol: null,
                        hostname: null,
                        port: null,
                        pathname: null,
                        search: null,
                        hash: null,
                        host: null
                    },
                    r, u, f;
                if (null == t) return i;
                u = createjs.Elements.a();
                for (r in u.href = t, i) r in u && (i[r] = u[r]);
                return f = t.indexOf("?"), -1 < f && (t = t.substr(0, f)), n.ABSOLUTE_PATT.test(t) ? i.absolute = !0 : n.RELATIVE_PATT.test(t) && (i.relative = !0), (t = t.match(n.EXTENSION_PATT)) && (i.extension = t[1].toLowerCase()), i
            },
            formatQueryString: function(n, t) {
                if (null == n) throw new Error("You must specify data.");
                var r, i = [];
                for (r in n) i.push(r + "=" + escape(n[r]));
                return t && (i = i.concat(t)), i.join("&")
            },
            buildURI: function(n, t) {
                if (null == t) return n;
                var u, i = [],
                    r = n.indexOf("?");
                return -1 != r && (u = n.slice(r + 1), i = i.concat(u.split("&"))), -1 != r ? n.slice(0, r) + "?" + this.formatQueryString(t, i) : n + "?" + this.formatQueryString(t, i)
            },
            isCrossDomain: function(n) {
                var t = createjs.Elements.a();
                return t.href = n.src, n = createjs.Elements.a(), n.href = location.href, "" != t.hostname && (t.port != n.port || t.protocol != n.protocol || t.hostname != n.hostname)
            },
            isLocal: function(n) {
                var t = createjs.Elements.a();
                return t.href = n.src, "" == t.hostname && "file:" == t.protocol
            }
        };
        createjs.URLUtils = n
    }(),
    function() {
        var n = {
            container: null,
            appendToHead: function(t) {
                n.getHead().appendChild(t)
            },
            appendToBody: function(t) {
                var i;
                null == n.container && (n.container = document.createElement("div"), n.container.id = "preloadjs-container", (i = n.container.style).visibility = "hidden", i.position = "absolute", i.width = n.container.style.height = "10px", i.overflow = "hidden", i.transform = i.msTransform = i.webkitTransform = i.oTransform = "translate(-10px, -10px)", n.getBody().appendChild(n.container));
                n.container.appendChild(t)
            },
            getHead: function() {
                return document.head || document.getElementsByTagName("head")[0]
            },
            getBody: function() {
                return document.body || document.getElementsByTagName("body")[0]
            },
            removeChild: function(n) {
                n.parent && n.parent.removeChild(n)
            },
            isImageTag: function(n) {
                return n instanceof HTMLImageElement
            },
            isAudioTag: function(n) {
                return !!window.HTMLAudioElement && n instanceof HTMLAudioElement
            },
            isVideoTag: function(n) {
                return !!window.HTMLVideoElement && n instanceof HTMLVideoElement
            }
        };
        createjs.DomUtils = n
    }(),
    function() {
        var n = {
            parseXML: function(n) {
                var t = null;
                try {
                    window.DOMParser && (t = (new DOMParser).parseFromString(n, "text/xml"))
                } catch (n) {}
                if (!t) try {
                    (t = new ActiveXObject("Microsoft.XMLDOM")).async = !1;
                    t.loadXML(n)
                } catch (n) {
                    t = null
                }
                return t
            },
            parseJSON: function(n) {
                if (null == n) return null;
                try {
                    return JSON.parse(n)
                } catch (n) {
                    throw n;
                }
            }
        };
        createjs.DataUtils = n
    }(),
    function() {
        createjs.Types = {
            BINARY: "binary",
            CSS: "css",
            FONT: "font",
            FONTCSS: "fontcss",
            IMAGE: "image",
            JAVASCRIPT: "javascript",
            JSON: "json",
            JSONP: "jsonp",
            MANIFEST: "manifest",
            SOUND: "sound",
            VIDEO: "video",
            SPRITESHEET: "spritesheet",
            SVG: "svg",
            TEXT: "text",
            XML: "xml"
        }
    }(),
    function() {
        createjs.Methods = {
            POST: "POST",
            GET: "GET"
        }
    }(),
    function() {
        "use strict";

        function t() {
            this.src = null;
            this.type = null;
            this.id = null;
            this.maintainOrder = !1;
            this.callback = null;
            this.data = null;
            this.method = createjs.Methods.GET;
            this.values = null;
            this.headers = null;
            this.withCredentials = !1;
            this.mimeType = null;
            this.crossOrigin = null;
            this.loadTimeout = n.LOAD_TIMEOUT_DEFAULT
        }
        var i = t.prototype = {},
            n = t;
        n.LOAD_TIMEOUT_DEFAULT = 8e3;
        n.create = function(i) {
            if ("string" == typeof i) {
                var r = new t;
                return r.src = i, r
            }
            if (i instanceof n) return i;
            if (i instanceof Object && i.src) return null == i.loadTimeout && (i.loadTimeout = n.LOAD_TIMEOUT_DEFAULT), i;
            throw new Error("Type not recognized.");
        };
        i.set = function(n) {
            for (var t in n) this[t] = n[t];
            return this
        };
        createjs.LoadItem = n
    }(),
    function() {
        var n = {
            isBinary: function(n) {
                switch (n) {
                    case createjs.Types.IMAGE:
                    case createjs.Types.BINARY:
                        return !0;
                    default:
                        return !1
                }
            },
            isText: function(n) {
                switch (n) {
                    case createjs.Types.TEXT:
                    case createjs.Types.JSON:
                    case createjs.Types.MANIFEST:
                    case createjs.Types.XML:
                    case createjs.Types.CSS:
                    case createjs.Types.SVG:
                    case createjs.Types.JAVASCRIPT:
                    case createjs.Types.SPRITESHEET:
                        return !0;
                    default:
                        return !1
                }
            },
            getTypeByExtension: function(n) {
                if (null == n) return createjs.Types.TEXT;
                switch (n.toLowerCase()) {
                    case "jpeg":
                    case "jpg":
                    case "gif":
                    case "png":
                    case "webp":
                    case "bmp":
                        return createjs.Types.IMAGE;
                    case "ogg":
                    case "mp3":
                    case "webm":
                        return createjs.Types.SOUND;
                    case "mp4":
                    case "webm":
                    case "ts":
                        return createjs.Types.VIDEO;
                    case "json":
                        return createjs.Types.JSON;
                    case "xml":
                        return createjs.Types.XML;
                    case "css":
                        return createjs.Types.CSS;
                    case "js":
                        return createjs.Types.JAVASCRIPT;
                    case "svg":
                        return createjs.Types.SVG;
                    default:
                        return createjs.Types.TEXT
                }
            }
        };
        createjs.RequestUtils = n
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.EventDispatcher_constructor();
            this.loaded = !1;
            this.canceled = !1;
            this.progress = 0;
            this.type = i;
            this.resultFormatter = null;
            this._item = n ? createjs.LoadItem.create(n) : null;
            this._preferXHR = t;
            this._result = null;
            this._rawResult = null;
            this._loadedItems = null;
            this._tagSrcAttribute = null;
            this._tag = null
        }
        var n = createjs.extend(t, createjs.EventDispatcher),
            i = t;
        try {
            Object.defineProperties(i, {
                POST: {
                    get: createjs.deprecate(function() {
                        return createjs.Methods.POST
                    }, "AbstractLoader.POST")
                },
                GET: {
                    get: createjs.deprecate(function() {
                        return createjs.Methods.GET
                    }, "AbstractLoader.GET")
                },
                BINARY: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.BINARY
                    }, "AbstractLoader.BINARY")
                },
                CSS: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.CSS
                    }, "AbstractLoader.CSS")
                },
                FONT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.FONT
                    }, "AbstractLoader.FONT")
                },
                FONTCSS: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.FONTCSS
                    }, "AbstractLoader.FONTCSS")
                },
                IMAGE: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.IMAGE
                    }, "AbstractLoader.IMAGE")
                },
                JAVASCRIPT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JAVASCRIPT
                    }, "AbstractLoader.JAVASCRIPT")
                },
                JSON: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JSON
                    }, "AbstractLoader.JSON")
                },
                JSONP: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JSONP
                    }, "AbstractLoader.JSONP")
                },
                MANIFEST: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.MANIFEST
                    }, "AbstractLoader.MANIFEST")
                },
                SOUND: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SOUND
                    }, "AbstractLoader.SOUND")
                },
                VIDEO: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.VIDEO
                    }, "AbstractLoader.VIDEO")
                },
                SPRITESHEET: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SPRITESHEET
                    }, "AbstractLoader.SPRITESHEET")
                },
                SVG: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SVG
                    }, "AbstractLoader.SVG")
                },
                TEXT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.TEXT
                    }, "AbstractLoader.TEXT")
                },
                XML: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.XML
                    }, "AbstractLoader.XML")
                }
            })
        } catch (t) {}
        n.getItem = function() {
            return this._item
        };
        n.getResult = function(n) {
            return n ? this._rawResult : this._result
        };
        n.getTag = function() {
            return this._tag
        };
        n.setTag = function(n) {
            this._tag = n
        };
        n.load = function() {
            this._createRequest();
            this._request.on("complete", this, this);
            this._request.on("progress", this, this);
            this._request.on("loadStart", this, this);
            this._request.on("abort", this, this);
            this._request.on("timeout", this, this);
            this._request.on("error", this, this);
            var n = new createjs.Event("initialize");
            n.loader = this._request;
            this.dispatchEvent(n);
            this._request.load()
        };
        n.cancel = function() {
            this.canceled = !0;
            this.destroy()
        };
        n.destroy = function() {
            this._request && (this._request.removeAllEventListeners(), this._request.destroy());
            this._request = null;
            this._item = null;
            this._rawResult = null;
            this._result = null;
            this._loadItems = null;
            this.removeAllEventListeners()
        };
        n.getLoadedItems = function() {
            return this._loadedItems
        };
        n._createRequest = function() {
            this._request = this._preferXHR ? new createjs.XHRRequest(this._item) : new createjs.TagRequest(this._item, this._tag || this._createTag(), this._tagSrcAttribute)
        };
        n._createTag = function() {
            return null
        };
        n._sendLoadStart = function() {
            this._isCanceled() || this.dispatchEvent("loadstart")
        };
        n._sendProgress = function(n) {
            var t;
            this._isCanceled() || (t = null, "number" == typeof n ? (this.progress = n, t = new createjs.ProgressEvent(this.progress)) : (t = n, this.progress = n.loaded / n.total, t.progress = this.progress, !isNaN(this.progress) && this.progress != 1 / 0 || (this.progress = 0)), this.hasEventListener("progress") && this.dispatchEvent(t))
        };
        n._sendComplete = function() {
            var n;
            this._isCanceled() || (this.loaded = !0, (n = new createjs.Event("complete")).rawResult = this._rawResult, null != this._result && (n.result = this._result), this.dispatchEvent(n))
        };
        n._sendError = function(n) {
            !this._isCanceled() && this.hasEventListener("error") && (null == n && (n = new createjs.ErrorEvent("PRELOAD_ERROR_EMPTY")), this.dispatchEvent(n))
        };
        n._isCanceled = function() {
            return !(null != window.createjs && !this.canceled)
        };
        n.resultFormatter = null;
        n.handleEvent = function(n) {
            switch (n.type) {
                case "complete":
                    this._rawResult = n.target._response;
                    var t = this.resultFormatter && this.resultFormatter(this);
                    t instanceof Function ? t.call(this, createjs.proxy(this._resultFormatSuccess, this), createjs.proxy(this._resultFormatFailed, this)) : (this._result = t || this._rawResult, this._sendComplete());
                    break;
                case "progress":
                    this._sendProgress(n);
                    break;
                case "error":
                    this._sendError(n);
                    break;
                case "loadstart":
                    this._sendLoadStart();
                    break;
                case "abort":
                case "timeout":
                    this._isCanceled() || this.dispatchEvent(new createjs.ErrorEvent("PRELOAD_" + n.type.toUpperCase() + "_ERROR"))
            }
        };
        n._resultFormatSuccess = function(n) {
            this._result = n;
            this._sendComplete()
        };
        n._resultFormatFailed = function(n) {
            this._sendError(n)
        };
        n.toString = function() {
            return "[PreloadJS AbstractLoader]"
        };
        createjs.AbstractLoader = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.AbstractLoader_constructor(n, t, i);
            this.resultFormatter = this._formatResult;
            this._tagSrcAttribute = "src";
            this.on("initialize", this._updateXHR, this)
        }
        var n = createjs.extend(t, createjs.AbstractLoader);
        n.load = function() {
            this._tag || (this._tag = this._createTag(this._item.src));
            this._tag.preload = "auto";
            this._tag.load();
            this.AbstractLoader_load()
        };
        n._createTag = function() {};
        n._createRequest = function() {
            this._request = this._preferXHR ? new createjs.XHRRequest(this._item) : new createjs.MediaTagRequest(this._item, this._tag || this._createTag(), this._tagSrcAttribute)
        };
        n._updateXHR = function(n) {
            n.loader.setResponseType && n.loader.setResponseType("blob")
        };
        n._formatResult = function(n) {
            var t, i;
            return this._tag.removeEventListener && this._tag.removeEventListener("canplaythrough", this._loadedHandler), this._tag.onstalled = null, this._preferXHR && (t = window.URL || window.webkitURL, i = n.getResult(!0), n.getTag().src = t.createObjectURL(i)), n.getTag()
        };
        createjs.AbstractMediaLoader = createjs.promote(t, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function t(n) {
            this._item = n
        }
        var n = createjs.extend(t, createjs.EventDispatcher);
        n.load = function() {};
        n.destroy = function() {};
        n.cancel = function() {};
        createjs.AbstractRequest = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.AbstractRequest_constructor(n);
            this._tag = t;
            this._tagSrcAttribute = i;
            this._loadedHandler = createjs.proxy(this._handleTagComplete, this);
            this._addedToDOM = !1
        }
        var n = createjs.extend(t, createjs.AbstractRequest);
        n.load = function() {
            this._tag.onload = createjs.proxy(this._handleTagComplete, this);
            this._tag.onreadystatechange = createjs.proxy(this._handleReadyStateChange, this);
            this._tag.onerror = createjs.proxy(this._handleError, this);
            var n = new createjs.Event("initialize");
            n.loader = this._tag;
            this.dispatchEvent(n);
            this._loadTimeout = setTimeout(createjs.proxy(this._handleTimeout, this), this._item.loadTimeout);
            this._tag[this._tagSrcAttribute] = this._item.src;
            null == this._tag.parentNode && (createjs.DomUtils.appendToBody(this._tag), this._addedToDOM = !0)
        };
        n.destroy = function() {
            this._clean();
            this._tag = null;
            this.AbstractRequest_destroy()
        };
        n._handleReadyStateChange = function() {
            clearTimeout(this._loadTimeout);
            var n = this._tag;
            "loaded" != n.readyState && "complete" != n.readyState || this._handleTagComplete()
        };
        n._handleError = function() {
            this._clean();
            this.dispatchEvent("error")
        };
        n._handleTagComplete = function() {
            this._rawResult = this._tag;
            this._result = this.resultFormatter && this.resultFormatter(this) || this._rawResult;
            this._clean();
            this.dispatchEvent("complete")
        };
        n._handleTimeout = function() {
            this._clean();
            this.dispatchEvent(new createjs.Event("timeout"))
        };
        n._clean = function() {
            this._tag.onload = null;
            this._tag.onreadystatechange = null;
            this._tag.onerror = null;
            this._addedToDOM && null != this._tag.parentNode && this._tag.parentNode.removeChild(this._tag);
            clearTimeout(this._loadTimeout)
        };
        n._handleStalled = function() {};
        createjs.TagRequest = createjs.promote(t, "AbstractRequest")
    }(),
    function() {
        "use strict";

        function t(n, t, i) {
            this.AbstractRequest_constructor(n);
            this._tag = t;
            this._tagSrcAttribute = i;
            this._loadedHandler = createjs.proxy(this._handleTagComplete, this)
        }
        var n = createjs.extend(t, createjs.TagRequest);
        n.load = function() {
            var t = createjs.proxy(this._handleStalled, this),
                n;
            this._stalledCallback = t;
            n = createjs.proxy(this._handleProgress, this);
            this._handleProgress = n;
            this._tag.addEventListener("stalled", t);
            this._tag.addEventListener("progress", n);
            this._tag.addEventListener && this._tag.addEventListener("canplaythrough", this._loadedHandler, !1);
            this.TagRequest_load()
        };
        n._handleReadyStateChange = function() {
            clearTimeout(this._loadTimeout);
            var n = this._tag;
            "loaded" != n.readyState && "complete" != n.readyState || this._handleTagComplete()
        };
        n._handleStalled = function() {};
        n._handleProgress = function(n) {
            !n || 0 < n.loaded && 0 == n.total || (n = new createjs.ProgressEvent(n.loaded, n.total), this.dispatchEvent(n))
        };
        n._clean = function() {
            this._tag.removeEventListener && this._tag.removeEventListener("canplaythrough", this._loadedHandler);
            this._tag.removeEventListener("stalled", this._stalledCallback);
            this._tag.removeEventListener("progress", this._progressCallback);
            this.TagRequest__clean()
        };
        createjs.MediaTagRequest = createjs.promote(t, "TagRequest")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.AbstractRequest_constructor(n);
            this._request = null;
            this._loadTimeout = null;
            this._xhrLevel = 1;
            this._response = null;
            this._rawResponse = null;
            this._canceled = !1;
            this._handleLoadStartProxy = createjs.proxy(this._handleLoadStart, this);
            this._handleProgressProxy = createjs.proxy(this._handleProgress, this);
            this._handleAbortProxy = createjs.proxy(this._handleAbort, this);
            this._handleErrorProxy = createjs.proxy(this._handleError, this);
            this._handleTimeoutProxy = createjs.proxy(this._handleTimeout, this);
            this._handleLoadProxy = createjs.proxy(this._handleLoad, this);
            this._handleReadyStateChangeProxy = createjs.proxy(this._handleReadyStateChange, this);
            this._createXHR(n)
        }
        var n = createjs.extend(t, createjs.AbstractRequest);
        t.ACTIVEX_VERSIONS = ["Msxml2.XMLHTTP.6.0", "Msxml2.XMLHTTP.5.0", "Msxml2.XMLHTTP.4.0", "MSXML2.XMLHTTP.3.0", "MSXML2.XMLHTTP", "Microsoft.XMLHTTP"];
        n.getResult = function(n) {
            return n && this._rawResponse ? this._rawResponse : this._response
        };
        n.cancel = function() {
            this.canceled = !0;
            this._clean();
            this._request.abort()
        };
        n.load = function() {
            if (null != this._request) {
                null != this._request.addEventListener ? (this._request.addEventListener("loadstart", this._handleLoadStartProxy, !1), this._request.addEventListener("progress", this._handleProgressProxy, !1), this._request.addEventListener("abort", this._handleAbortProxy, !1), this._request.addEventListener("error", this._handleErrorProxy, !1), this._request.addEventListener("timeout", this._handleTimeoutProxy, !1), this._request.addEventListener("load", this._handleLoadProxy, !1), this._request.addEventListener("readystatechange", this._handleReadyStateChangeProxy, !1)) : (this._request.onloadstart = this._handleLoadStartProxy, this._request.onprogress = this._handleProgressProxy, this._request.onabort = this._handleAbortProxy, this._request.onerror = this._handleErrorProxy, this._request.ontimeout = this._handleTimeoutProxy, this._request.onload = this._handleLoadProxy, this._request.onreadystatechange = this._handleReadyStateChangeProxy);
                1 == this._xhrLevel && (this._loadTimeout = setTimeout(createjs.proxy(this._handleTimeout, this), this._item.loadTimeout));
                try {
                    this._item.values ? this._request.send(createjs.URLUtils.formatQueryString(this._item.values)) : this._request.send()
                } catch (n) {
                    this.dispatchEvent(new createjs.ErrorEvent("XHR_SEND", null, n))
                }
            } else this._handleError()
        };
        n.setResponseType = function(n) {
            "blob" === n && (n = window.URL ? "blob" : "arraybuffer", this._responseType = n);
            this._request.responseType = n
        };
        n.getAllResponseHeaders = function() {
            return this._request.getAllResponseHeaders instanceof Function ? this._request.getAllResponseHeaders() : null
        };
        n.getResponseHeader = function(n) {
            return this._request.getResponseHeader instanceof Function ? this._request.getResponseHeader(n) : null
        };
        n._handleProgress = function(n) {
            !n || 0 < n.loaded && 0 == n.total || (n = new createjs.ProgressEvent(n.loaded, n.total), this.dispatchEvent(n))
        };
        n._handleLoadStart = function() {
            clearTimeout(this._loadTimeout);
            this.dispatchEvent("loadstart")
        };
        n._handleAbort = function(n) {
            this._clean();
            this.dispatchEvent(new createjs.ErrorEvent("XHR_ABORTED", null, n))
        };
        n._handleError = function(n) {
            this._clean();
            this.dispatchEvent(new createjs.ErrorEvent(n.message))
        };
        n._handleReadyStateChange = function() {
            4 == this._request.readyState && this._handleLoad()
        };
        n._handleLoad = function(n) {
            if (!this.loaded) {
                this.loaded = !0;
                var t = this._checkError();
                if (t) this._handleError(t);
                else {
                    if (this._response = this._getResponse(), "arraybuffer" === this._responseType) try {
                        this._response = new Blob([this._response])
                    } catch (n) {
                        window.BlobBuilder = window.BlobBuilder || window.WebKitBlobBuilder || window.MozBlobBuilder || window.MSBlobBuilder;
                        "TypeError" === n.name && window.BlobBuilder && ((t = new BlobBuilder).append(this._response), this._response = t.getBlob())
                    }
                    this._clean();
                    this.dispatchEvent(new createjs.Event("complete"))
                }
            }
        };
        n._handleTimeout = function(n) {
            this._clean();
            this.dispatchEvent(new createjs.ErrorEvent("PRELOAD_TIMEOUT", null, n))
        };
        n._checkError = function() {
            var n = parseInt(this._request.status);
            return 400 <= n && n <= 599 ? new Error(n) : 0 == n && /^https?:/.test(location.protocol) ? new Error(0) : null
        };
        n._getResponse = function() {
            if (null != this._response) return this._response;
            if (null != this._request.response) return this._request.response;
            try {
                if (null != this._request.responseText) return this._request.responseText
            } catch (n) {}
            try {
                if (null != this._request.responseXML) return this._request.responseXML
            } catch (n) {}
            return null
        };
        n._createXHR = function(n) {
            var f = createjs.URLUtils.isCrossDomain(n),
                i = {},
                t = null,
                u, o, h, e, r;
            if (window.XMLHttpRequest) t = new XMLHttpRequest, f && void 0 === t.withCredentials && window.XDomainRequest && (t = new XDomainRequest);
            else {
                for (u = 0, o = s.ACTIVEX_VERSIONS.length; u < o; u++) {
                    h = s.ACTIVEX_VERSIONS[u];
                    try {
                        t = new ActiveXObject(h);
                        break
                    } catch (n) {}
                }
                if (null == t) return !1
            }
            if (null == n.mimeType && createjs.RequestUtils.isText(n.type) && (n.mimeType = "text/plain; charset=utf-8"), n.mimeType && t.overrideMimeType && t.overrideMimeType(n.mimeType), this._xhrLevel = "string" == typeof t.responseType ? 2 : 1, e = null, e = n.method == createjs.Methods.GET ? createjs.URLUtils.buildURI(n.src, n.values) : n.src, t.open(n.method || createjs.Methods.GET, e, !0), f && t instanceof XMLHttpRequest && 1 == this._xhrLevel && (i.Origin = location.origin), n.values && n.method == createjs.Methods.POST && (i["Content-Type"] = "application/x-www-form-urlencoded"), f || i["X-Requested-With"] || (i["X-Requested-With"] = "XMLHttpRequest"), n.headers)
                for (r in n.headers) i[r] = n.headers[r];
            for (r in i) t.setRequestHeader(r, i[r]);
            return t instanceof XMLHttpRequest && void 0 !== n.withCredentials && (t.withCredentials = n.withCredentials), this._request = t, !0
        };
        n._clean = function() {
            clearTimeout(this._loadTimeout);
            null != this._request.removeEventListener ? (this._request.removeEventListener("loadstart", this._handleLoadStartProxy), this._request.removeEventListener("progress", this._handleProgressProxy), this._request.removeEventListener("abort", this._handleAbortProxy), this._request.removeEventListener("error", this._handleErrorProxy), this._request.removeEventListener("timeout", this._handleTimeoutProxy), this._request.removeEventListener("load", this._handleLoadProxy), this._request.removeEventListener("readystatechange", this._handleReadyStateChangeProxy)) : (this._request.onloadstart = null, this._request.onprogress = null, this._request.onabort = null, this._request.onerror = null, this._request.ontimeout = null, this._request.onload = null, this._request.onreadystatechange = null)
        };
        n.toString = function() {
            return "[PreloadJS XHRRequest]"
        };
        createjs.XHRRequest = createjs.promote(t, "AbstractRequest")
    }(),
    function() {
        "use strict";

        function i(n, t, i) {
            this.AbstractLoader_constructor();
            this._plugins = [];
            this._typeCallbacks = {};
            this._extensionCallbacks = {};
            this.next = null;
            this.maintainScriptOrder = !0;
            this.stopOnError = !1;
            this._maxConnections = 1;
            this._availableLoaders = [createjs.FontLoader, createjs.ImageLoader, createjs.JavaScriptLoader, createjs.CSSLoader, createjs.JSONLoader, createjs.JSONPLoader, createjs.SoundLoader, createjs.ManifestLoader, createjs.SpriteSheetLoader, createjs.XMLLoader, createjs.SVGLoader, createjs.BinaryLoader, createjs.VideoLoader, createjs.TextLoader];
            this._defaultLoaderLength = this._availableLoaders.length;
            this.init(n, t, i)
        }
        var n = createjs.extend(i, createjs.AbstractLoader),
            t = i;
        try {
            Object.defineProperties(t, {
                POST: {
                    get: createjs.deprecate(function() {
                        return createjs.Methods.POST
                    }, "AbstractLoader.POST")
                },
                GET: {
                    get: createjs.deprecate(function() {
                        return createjs.Methods.GET
                    }, "AbstractLoader.GET")
                },
                BINARY: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.BINARY
                    }, "AbstractLoader.BINARY")
                },
                CSS: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.CSS
                    }, "AbstractLoader.CSS")
                },
                FONT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.FONT
                    }, "AbstractLoader.FONT")
                },
                FONTCSS: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.FONTCSS
                    }, "AbstractLoader.FONTCSS")
                },
                IMAGE: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.IMAGE
                    }, "AbstractLoader.IMAGE")
                },
                JAVASCRIPT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JAVASCRIPT
                    }, "AbstractLoader.JAVASCRIPT")
                },
                JSON: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JSON
                    }, "AbstractLoader.JSON")
                },
                JSONP: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.JSONP
                    }, "AbstractLoader.JSONP")
                },
                MANIFEST: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.MANIFEST
                    }, "AbstractLoader.MANIFEST")
                },
                SOUND: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SOUND
                    }, "AbstractLoader.SOUND")
                },
                VIDEO: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.VIDEO
                    }, "AbstractLoader.VIDEO")
                },
                SPRITESHEET: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SPRITESHEET
                    }, "AbstractLoader.SPRITESHEET")
                },
                SVG: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.SVG
                    }, "AbstractLoader.SVG")
                },
                TEXT: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.TEXT
                    }, "AbstractLoader.TEXT")
                },
                XML: {
                    get: createjs.deprecate(function() {
                        return createjs.Types.XML
                    }, "AbstractLoader.XML")
                }
            })
        } catch (i) {}
        n.init = function(n, t, i) {
            this.preferXHR = !0;
            this._preferXHR = !0;
            this.setPreferXHR(n);
            this._paused = !1;
            this._basePath = t;
            this._crossOrigin = i;
            this._loadStartWasDispatched = !1;
            this._currentlyLoadingScript = null;
            this._currentLoads = [];
            this._loadQueue = [];
            this._loadQueueBackup = [];
            this._loadItemsById = {};
            this._loadItemsBySrc = {};
            this._loadedResults = {};
            this._loadedRawResults = {};
            this._numItems = 0;
            this._numItemsLoaded = 0;
            this._scriptOrder = [];
            this._loadedScripts = [];
            this._lastProgress = NaN
        };
        n.registerLoader = function(n) {
            if (!n || !n.canLoadItem) throw new Error("loader is of an incorrect type.");
            if (-1 != this._availableLoaders.indexOf(n)) throw new Error("loader already exists.");
            this._availableLoaders.unshift(n)
        };
        n.unregisterLoader = function(n) {
            n = this._availableLoaders.indexOf(n); - 1 != n && n < this._defaultLoaderLength - 1 && this._availableLoaders.splice(n, 1)
        };
        n.setPreferXHR = function(n) {
            return this.preferXHR = 0 != n && null != window.XMLHttpRequest, this.preferXHR
        };
        n.removeAll = function() {
            this.remove()
        };
        n.remove = function(n) {
            var u = null,
                f, t, r, e;
            if (n && !Array.isArray(n)) u = [n];
            else if (n) u = n;
            else if (0 < arguments.length) return;
            if (f = !1, u) {
                for (; u.length;) {
                    for (var i = u.pop(), o = this.getResult(i), t = this._loadQueue.length - 1; 0 <= t; t--)
                        if ((r = this._loadQueue[t].getItem()).id == i || r.src == i) {
                            this._loadQueue.splice(t, 1)[0].cancel();
                            break
                        }
                    for (t = this._loadQueueBackup.length - 1; 0 <= t; t--)
                        if ((r = this._loadQueueBackup[t].getItem()).id == i || r.src == i) {
                            this._loadQueueBackup.splice(t, 1)[0].cancel();
                            break
                        }
                    if (o) this._disposeItem(this.getItem(i));
                    else
                        for (t = this._currentLoads.length - 1; 0 <= t; t--)
                            if (r = this._currentLoads[t].getItem(), r.id == i || r.src == i) {
                                this._currentLoads.splice(t, 1)[0].cancel();
                                f = !0;
                                break
                            }
                }
                f && this._loadNext()
            } else {
                for (e in this.close(), this._loadItemsById) this._disposeItem(this._loadItemsById[e]);
                this.init(this.preferXHR, this._basePath)
            }
        };
        n.reset = function() {
            for (var i in this.close(), this._loadItemsById) this._disposeItem(this._loadItemsById[i]);
            for (var t = [], n = 0, r = this._loadQueueBackup.length; n < r; n++) t.push(this._loadQueueBackup[n].getItem());
            this.loadManifest(t, !1)
        };
        n.installPlugin = function(n) {
            var t, i, r;
            if (null != n && null != n.getPreloadHandlers) {
                if (this._plugins.push(n), t = n.getPreloadHandlers(), t.scope = n, null != t.types)
                    for (i = 0, r = t.types.length; i < r; i++) this._typeCallbacks[t.types[i]] = t;
                if (null != t.extensions)
                    for (i = 0, r = t.extensions.length; i < r; i++) this._extensionCallbacks[t.extensions[i]] = t
            }
        };
        n.setMaxConnections = function(n) {
            this._maxConnections = n;
            !this._paused && 0 < this._loadQueue.length && this._loadNext()
        };
        n.loadFile = function(n, t, i) {
            null != n ? (this._addItem(n, null, i), !1 !== t ? this.setPaused(!1) : this.setPaused(!0)) : (t = new createjs.ErrorEvent("PRELOAD_NO_FILE"), this._sendError(t))
        };
        n.loadManifest = function(n, i, r) {
            var u = null,
                o = null,
                f, e, s;
            if (Array.isArray(n)) {
                if (0 == n.length) return f = new createjs.ErrorEvent("PRELOAD_MANIFEST_EMPTY"), void this._sendError(f);
                u = n
            } else if ("string" == typeof n) u = [{
                src: n,
                type: t.MANIFEST
            }];
            else {
                if ("object" != typeof n) return f = new createjs.ErrorEvent("PRELOAD_MANIFEST_NULL"), void this._sendError(f);
                void 0 !== n.src ? (null == n.type ? n.type = t.MANIFEST : n.type != t.MANIFEST && (f = new createjs.ErrorEvent("PRELOAD_MANIFEST_TYPE"), this._sendError(f)), u = [n]) : void 0 !== n.manifest && (u = n.manifest, o = n.path)
            }
            for (e = 0, s = u.length; e < s; e++) this._addItem(u[e], o, r);
            !1 !== i ? this.setPaused(!1) : this.setPaused(!0)
        };
        n.load = function() {
            this.setPaused(!1)
        };
        n.getItem = function(n) {
            return this._loadItemsById[n] || this._loadItemsBySrc[n]
        };
        n.getResult = function(n, t) {
            return (n = this._loadItemsById[n] || this._loadItemsBySrc[n], null == n) ? null : (n = n.id, (t && this._loadedRawResults[n] ? this._loadedRawResults : this._loadedResults)[n])
        };
        n.getItems = function(n) {
            var t, r = [],
                u, i;
            for (t in this._loadItemsById) u = this._loadItemsById[t], i = this.getResult(t), !0 === n && null == i || r.push({
                item: u,
                result: i,
                rawResult: this.getResult(t, !0)
            });
            return r
        };
        n.setPaused = function(n) {
            this._paused = n;
            this._paused || this._loadNext()
        };
        n.close = function() {
            for (; this._currentLoads.length;) this._currentLoads.pop().cancel();
            this._scriptOrder.length = 0;
            this._loadedScripts.length = 0;
            this.loadStartWasDispatched = !1;
            this._itemCount = 0;
            this._lastProgress = NaN
        };
        n._addItem = function(n, t, i) {
            t = this._createLoadItem(n, t, i);
            null == t || null != (i = this._createLoader(t)) && ("plugins" in i && (i.plugins = this._plugins), t._loader = i, this._loadQueue.push(i), this._loadQueueBackup.push(i), this._numItems++, this._updateProgress(), (this.maintainScriptOrder && t.type == createjs.Types.JAVASCRIPT || !0 === t.maintainOrder) && (this._scriptOrder.push(t), this._loadedScripts.push(null)))
        };
        n._createLoadItem = function(n, t, i) {
            var r = createjs.LoadItem.create(n),
                f, e, u;
            if (null == r) return null;
            if (n = "", i = i || this._basePath, r.src instanceof Object) {
                if (!r.type) return null;
                t ? (n = t, e = createjs.URLUtils.parseURI(t), null == i || e.absolute || e.relative || (n = i + n)) : null != i && (n = i)
            } else f = createjs.URLUtils.parseURI(r.src), f.extension && (r.ext = f.extension), null == r.type && (r.type = createjs.RequestUtils.getTypeByExtension(r.ext)), u = r.src, f.absolute || f.relative || (t ? (n = t, e = createjs.URLUtils.parseURI(t), u = t + u, null == i || e.absolute || e.relative || (n = i + n)) : null != i && (n = i)), r.src = n + r.src;
            if (r.path = n, void 0 !== r.id && null !== r.id && "" !== r.id || (r.id = u), u = this._typeCallbacks[r.type] || this._extensionCallbacks[r.ext], u) {
                if (u = u.callback.call(u.scope, r, this), !1 === u) return null;
                !0 === u || null != u && (r._loader = u);
                null != (f = createjs.URLUtils.parseURI(r.src)).extension && (r.ext = f.extension)
            }
            return this._loadItemsById[r.id] = r, null == (this._loadItemsBySrc[r.src] = r).crossOrigin && (r.crossOrigin = this._crossOrigin), r
        };
        n._createLoader = function(n) {
            var r, t, i;
            if (null != n._loader) return n._loader;
            for (r = this.preferXHR, t = 0; t < this._availableLoaders.length; t++)
                if (i = this._availableLoaders[t], i && i.canLoadItem(n)) return new i(n, r);
            return null
        };
        n._loadNext = function() {
            var n, t;
            if (!this._paused)
                for (this._loadStartWasDispatched || (this._sendLoadStart(), this._loadStartWasDispatched = !0), this._numItems == this._numItemsLoaded ? (this.loaded = !0, this._sendComplete(), this.next && this.next.load && this.next.load()) : this.loaded = !1, n = 0; n < this._loadQueue.length && !(this._currentLoads.length >= this._maxConnections); n++) t = this._loadQueue[n], this._canStartLoad(t) && (this._loadQueue.splice(n, 1), n--, this._loadItem(t))
        };
        n._loadItem = function(n) {
            n.on("fileload", this._handleFileLoad, this);
            n.on("progress", this._handleProgress, this);
            n.on("complete", this._handleFileComplete, this);
            n.on("error", this._handleError, this);
            n.on("fileerror", this._handleFileError, this);
            this._currentLoads.push(n);
            this._sendFileStart(n.getItem());
            n.load()
        };
        n._handleFileLoad = function(n) {
            n.target = null;
            this.dispatchEvent(n)
        };
        n._handleFileError = function(n) {
            n = new createjs.ErrorEvent("FILE_LOAD_ERROR", null, n.item);
            this._sendError(n)
        };
        n._handleError = function(n) {
            var t = n.target;
            this._numItemsLoaded++;
            this._finishOrderedItem(t, !0);
            this._updateProgress();
            n = new createjs.ErrorEvent("FILE_LOAD_ERROR", null, t.getItem());
            this._sendError(n);
            this.stopOnError ? this.setPaused(!0) : (this._removeLoadItem(t), this._cleanLoadItem(t), this._loadNext())
        };
        n._handleFileComplete = function(n) {
            var t = n.target,
                i = t.getItem(),
                r = t.getResult();
            this._loadedResults[i.id] = r;
            n = t.getResult(!0);
            null != n && n !== r && (this._loadedRawResults[i.id] = n);
            this._saveLoadedItems(t);
            this._removeLoadItem(t);
            this._finishOrderedItem(t) || this._processFinishedLoad(i, t);
            this._cleanLoadItem(t)
        };
        n._saveLoadedItems = function(n) {
            var r = n.getLoadedItems(),
                i, t;
            if (null !== r)
                for (i = 0; i < r.length; i++) t = r[i].item, this._loadItemsBySrc[t.src] = t, this._loadItemsById[t.id] = t, this._loadedResults[t.id] = r[i].result, this._loadedRawResults[t.id] = r[i].rawResult
        };
        n._finishOrderedItem = function(n, t) {
            var i = n.getItem();
            return this.maintainScriptOrder && i.type == createjs.Types.JAVASCRIPT || i.maintainOrder ? (n instanceof createjs.JavaScriptLoader && (this._currentlyLoadingScript = !1), n = createjs.indexOf(this._scriptOrder, i), -1 == n ? !1 : (this._loadedScripts[n] = !0 === t || i, this._checkScriptLoadOrder(), !0)) : !1
        };
        n._checkScriptLoadOrder = function() {
            for (var i, n, r = this._loadedScripts.length, t = 0; t < r; t++) {
                if (n = this._loadedScripts[t], null === n) break;
                !0 !== n && (i = this._loadedResults[n.id], n.type == createjs.Types.JAVASCRIPT && createjs.DomUtils.appendToHead(i), i = n._loader, this._processFinishedLoad(n, i), this._loadedScripts[t] = !0)
            }
        };
        n._processFinishedLoad = function(n, t) {
            var i;
            this._numItemsLoaded++;
            this.maintainScriptOrder || n.type != createjs.Types.JAVASCRIPT || (i = t.getTag(), createjs.DomUtils.appendToHead(i));
            this._updateProgress();
            this._sendFileComplete(n, t);
            this._loadNext()
        };
        n._canStartLoad = function(n) {
            if (!this.maintainScriptOrder || n.preferXHR || (n = n.getItem(), n.type != createjs.Types.JAVASCRIPT)) return !0;
            if (this._currentlyLoadingScript) return !1;
            for (var i = this._scriptOrder.indexOf(n), t = 0; t < i;) {
                if (null == this._loadedScripts[t]) return !1;
                t++
            }
            return this._currentlyLoadingScript = !0
        };
        n._removeLoadItem = function(n) {
            for (var i = this._currentLoads.length, t = 0; t < i; t++)
                if (this._currentLoads[t] == n) {
                    this._currentLoads.splice(t, 1);
                    break
                }
        };
        n._cleanLoadItem = function(n) {
            n = n.getItem();
            n && delete n._loader
        };
        n._handleProgress = function(n) {
            n = n.target;
            this._sendFileProgress(n.getItem(), n.progress);
            this._updateProgress()
        };
        n._updateProgress = function() {
            var n = this._numItemsLoaded / this._numItems,
                t = this._numItems - this._numItemsLoaded;
            if (0 < t) {
                for (var r = 0, i = 0, u = this._currentLoads.length; i < u; i++) r += this._currentLoads[i].progress;
                n += r / t * (t / this._numItems)
            }
            this._lastProgress != n && (this._sendProgress(n), this._lastProgress = n)
        };
        n._disposeItem = function(n) {
            delete this._loadedResults[n.id];
            delete this._loadedRawResults[n.id];
            delete this._loadItemsById[n.id];
            delete this._loadItemsBySrc[n.src]
        };
        n._sendFileProgress = function(n, t) {
            var i;
            this._isCanceled() || this._paused || this.hasEventListener("fileprogress") && ((i = new createjs.Event("fileprogress")).progress = t, i.loaded = t, i.total = 1, i.item = n, this.dispatchEvent(i))
        };
        n._sendFileComplete = function(n, t) {
            var i;
            this._isCanceled() || this._paused || ((i = new createjs.Event("fileload")).loader = t, i.item = n, i.result = this._loadedResults[n.id], i.rawResult = this._loadedRawResults[n.id], n.completeHandler && n.completeHandler(i), this.hasEventListener("fileload") && this.dispatchEvent(i))
        };
        n._sendFileStart = function(n) {
            var t = new createjs.Event("filestart");
            t.item = n;
            this.hasEventListener("filestart") && this.dispatchEvent(t)
        };
        n.toString = function() {
            return "[PreloadJS LoadQueue]"
        };
        createjs.LoadQueue = createjs.promote(i, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n) {
            this.AbstractLoader_constructor(n, !0, createjs.Types.TEXT)
        }
        createjs.extend(n, createjs.AbstractLoader);
        n.canLoadItem = function(n) {
            return n.type == createjs.Types.TEXT
        };
        createjs.TextLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n) {
            this.AbstractLoader_constructor(n, !0, createjs.Types.BINARY);
            this.on("initialize", this._updateXHR, this)
        }
        var t = createjs.extend(n, createjs.AbstractLoader);
        n.canLoadItem = function(n) {
            return n.type == createjs.Types.BINARY
        };
        t._updateXHR = function(n) {
            n.loader.setResponseType("arraybuffer")
        };
        createjs.BinaryLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.CSS);
            this.resultFormatter = this._formatResult;
            this._tagSrcAttribute = "href";
            this._tag = t ? createjs.Elements.style() : createjs.Elements.link();
            this._tag.rel = "stylesheet";
            this._tag.type = "text/css"
        }
        var t = createjs.extend(n, createjs.AbstractLoader);
        n.canLoadItem = function(n) {
            return n.type == createjs.Types.CSS
        };
        t._formatResult = function(n) {
            var t;
            return this._preferXHR ? (t = n.getTag()).styleSheet ? t.styleSheet.cssText = n.getResult(!0) : (n = createjs.Elements.text(n.getResult(!0)), t.appendChild(n)) : t = this._tag, createjs.DomUtils.appendToHead(t), t
        };
        createjs.CSSLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractLoader_constructor(n, t, n.type);
            this._faces = {};
            this._watched = [];
            this._count = 0;
            this._watchInterval = null;
            this._loadTimeout = null;
            this._injectCSS = void 0 === n.injectCSS || n.injectCSS;
            this.dispatchEvent("initialize")
        }
        var t = createjs.extend(n, createjs.AbstractLoader);
        n.canLoadItem = function(n) {
            return n.type == createjs.Types.FONT || n.type == createjs.Types.FONTCSS
        };
        n.sampleText = "abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        n._ctx = document.createElement("canvas").getContext("2d");
        n._referenceFonts = ["serif", "monospace"];
        n.WEIGHT_REGEX = /[- ._]*(thin|normal|book|regular|medium|black|heavy|[1-9]00|(?:extra|ultra|semi|demi)?[- ._]*(?:light|bold))[- ._]*/gi;
        n.STYLE_REGEX = /[- ._]*(italic|oblique)[- ._]*/gi;
        n.FONT_FORMAT = {
            woff2: "woff2",
            woff: "woff",
            ttf: "truetype",
            otf: "truetype"
        };
        n.FONT_WEIGHT = {
            thin: 100,
            extralight: 200,
            ultralight: 200,
            light: 300,
            semilight: 300,
            demilight: 300,
            book: "normal",
            regular: "normal",
            semibold: 600,
            demibold: 600,
            extrabold: 800,
            ultrabold: 800,
            black: 900,
            heavy: 900
        };
        n.WATCH_DURATION = 10;
        t.load = function() {
            var n;
            if (this.type == createjs.Types.FONTCSS) {
                if (!this._watchCSS()) return void this.AbstractLoader_load()
            } else this._item.src instanceof Array ? this._watchFontArray() : (n = this._defFromSrc(this._item.src), this._watchFont(n), this._injectStyleTag(this._cssFromDef(n)));
            this._loadTimeout = setTimeout(createjs.proxy(this._handleTimeout, this), this._item.loadTimeout);
            this.dispatchEvent("loadstart")
        };
        t._handleTimeout = function() {
            this._stopWatching();
            this.dispatchEvent(new createjs.ErrorEvent("PRELOAD_TIMEOUT"))
        };
        t._createRequest = function() {
            return this._request
        };
        t.handleEvent = function(n) {
            switch (n.type) {
                case "complete":
                    this._rawResult = n.target._response;
                    this._result = !0;
                    this._parseCSS(this._rawResult);
                    break;
                case "error":
                    this._stopWatching();
                    this.AbstractLoader_handleEvent(n)
            }
        };
        t._watchCSS = function() {
            var n = this._item.src;
            return n instanceof HTMLStyleElement && (this._injectCSS && !n.parentNode && (document.head || document.getElementsByTagName("head")[0]).appendChild(n), this._injectCSS = !1, n = "\n" + n.textContent), -1 !== n.search(/\n|\r|@font-face/i) ? (this._parseCSS(n), !0) : (this._request = new createjs.XHRRequest(this._item), !1)
        };
        t._parseCSS = function(n) {
            for (var t, i = /@font-face\s*\{([^}]+)}/g;;) {
                if (t = i.exec(n), !t) break;
                this._watchFont(this._parseFontFace(t[1]))
            }
            this._injectStyleTag(n)
        };
        t._watchFontArray = function() {
            for (var n, i = this._item.src, r = "", t = i.length - 1; 0 <= t; t--) n = i[t], n = "string" == typeof n ? this._defFromSrc(n) : this._defFromObj(n), this._watchFont(n), r += this._cssFromDef(n) + "\n";
            this._injectStyleTag(r)
        };
        t._injectStyleTag = function(n) {
            var i, t;
            this._injectCSS && (i = document.head || document.getElementsByTagName("head")[0], (t = document.createElement("style")).type = "text/css", t.styleSheet ? t.styleSheet.cssText = n : t.appendChild(document.createTextNode(n)), i.appendChild(t))
        };
        t._parseFontFace = function(n) {
            var t = this._getCSSValue(n, "font-family"),
                i = this._getCSSValue(n, "src");
            return t && i ? this._defFromObj({
                family: t,
                src: i,
                style: this._getCSSValue(n, "font-style"),
                weight: this._getCSSValue(n, "font-weight")
            }) : null
        };
        t._watchFont = function(n) {
            n && !this._faces[n.id] && (this._faces[n.id] = n, this._watched.push(n), this._count++, this._calculateReferenceSizes(n), this._startWatching())
        };
        t._startWatching = function() {
            null == this._watchInterval && (this._watchInterval = setInterval(createjs.proxy(this._watch, this), n.WATCH_DURATION))
        };
        t._stopWatching = function() {
            clearInterval(this._watchInterval);
            clearTimeout(this._loadTimeout);
            this._watchInterval = null
        };
        t._watch = function() {
            for (var r, i = this._watched, s = n._referenceFonts, e = i.length, u = e - 1; 0 <= u; u--)
                for (var t = i[u], o = t.refs, f = o.length - 1; 0 <= f; f--)
                    if (this._getTextWidth(t.family + "," + s[f], t.weight, t.style) != o[f]) {
                        r = new createjs.Event("fileload");
                        t.type = "font-family";
                        r.item = t;
                        this.dispatchEvent(r);
                        i.splice(u, 1);
                        break
                    }
            e !== i.length && (r = new createjs.ProgressEvent(this._count - i.length, this._count), this.dispatchEvent(r));
            0 === e && (this._stopWatching(), this._sendComplete())
        };
        t._calculateReferenceSizes = function(t) {
            for (var r = n._referenceFonts, u = t.refs = [], i = 0; i < r.length; i++) u[i] = this._getTextWidth(r[i], t.weight, t.style)
        };
        t._defFromSrc = function(t) {
            var o = /[- ._]+/g,
                i = t,
                e = null,
                r = i.search(/[?#]/),
                u, f;
            return -1 !== r && (i = i.substr(0, r)), -1 !== (r = i.lastIndexOf(".")) && (e = i.substr(r + 1), i = i.substr(0, r)), -1 !== (r = i.lastIndexOf("/")) && (i = i.substr(r + 1)), u = i, f = u.match(n.WEIGHT_REGEX), f && (f = f[0], u = u.replace(f, ""), f = f.replace(o, "").toLowerCase()), r = i.match(n.STYLE_REGEX), r && (u = u.replace(r[0], ""), r = "italic"), u = u.replace(o, ""), t = "local('" + i.replace(o, " ") + "'), url('" + t + "')", e = n.FONT_FORMAT[e], e && (t += " format('" + e + "')"), this._defFromObj({
                family: u,
                weight: n.FONT_WEIGHT[f] || f,
                style: r,
                src: t
            })
        };
        t._defFromObj = function(n) {
            return n = {
                family: n.family,
                src: n.src,
                style: n.style || "normal",
                weight: n.weight || "normal"
            }, n.id = n.family + ";" + n.style + ";" + n.weight, n
        };
        t._cssFromDef = function(n) {
            return "@font-face {\n\tfont-family: '" + n.family + "';\n\tfont-style: " + n.style + ";\n\tfont-weight: " + n.weight + ";\n\tsrc: " + n.src + ";\n}"
        };
        t._getTextWidth = function(t, i, r) {
            var u = n._ctx;
            return u.font = r + " " + i + " 72px " + t, u.measureText(n.sampleText).width
        };
        t._getCSSValue = function(n, t) {
            return n = new RegExp(t + ":s*([^;}]+?)s*[;}]").exec(n), n && n[1] ? n[1] : null
        };
        createjs.FontLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function t(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.IMAGE);
            this.resultFormatter = this._formatResult;
            this._tagSrcAttribute = "src";
            createjs.DomUtils.isImageTag(n) ? this._tag = n : createjs.DomUtils.isImageTag(n.src) ? this._tag = n.src : createjs.DomUtils.isImageTag(n.tag) && (this._tag = n.tag);
            null != this._tag ? this._preferXHR = !1 : this._tag = createjs.Elements.img();
            this.on("initialize", this._updateXHR, this)
        }
        var n = createjs.extend(t, createjs.AbstractLoader);
        t.canLoadItem = function(n) {
            return n.type == createjs.Types.IMAGE
        };
        n.load = function() {
            var n;
            "" != this._tag.src && this._tag.complete ? this._sendComplete() : (1 == (n = this._item.crossOrigin) && (n = "Anonymous"), null == n || createjs.URLUtils.isLocal(this._item) || (this._tag.crossOrigin = n), this.AbstractLoader_load())
        };
        n._updateXHR = function(n) {
            n.loader.mimeType = "text/plain; charset=x-user-defined-binary";
            n.loader.setResponseType && n.loader.setResponseType("blob")
        };
        n._formatResult = function() {
            return this._formatImage
        };
        n._formatImage = function(n, t) {
            var i = this._tag,
                r = window.URL || window.webkitURL;
            this._preferXHR && (r ? (this.getResult(!0) && (r = r.createObjectURL(this.getResult(!0)), i.src = r), i.addEventListener("load", this._cleanUpURL, !1), i.addEventListener("error", this._cleanUpURL, !1)) : i.src = this._item.src);
            i.complete ? n(i) : (i.onload = createjs.proxy(function() {
                n(this._tag);
                i.onload = i.onerror = null
            }, this), i.onerror = createjs.proxy(function(n) {
                t(new createjs.ErrorEvent("IMAGE_FORMAT", null, n));
                i.onload = i.onerror = null
            }, this))
        };
        n._cleanUpURL = function(n) {
            (window.URL || window.webkitURL).revokeObjectURL(n.target.src)
        };
        createjs.ImageLoader = createjs.promote(t, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.JAVASCRIPT);
            this.resultFormatter = this._formatResult;
            this._tagSrcAttribute = "src";
            this.setTag(createjs.Elements.script())
        }
        var t = createjs.extend(n, createjs.AbstractLoader);
        n.canLoadItem = function(n) {
            return n.type == createjs.Types.JAVASCRIPT
        };
        t._formatResult = function(n) {
            var t = n.getTag();
            return this._preferXHR && (t.text = n.getResult(!0)), t
        };
        createjs.JavaScriptLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n) {
            this.AbstractLoader_constructor(n, !0, createjs.Types.JSON);
            this.resultFormatter = this._formatResult
        }
        var t = createjs.extend(n, createjs.AbstractLoader);
        n.canLoadItem = function(n) {
            return n.type == createjs.Types.JSON
        };
        t._formatResult = function(n) {
            var t = null,
                i;
            try {
                t = createjs.DataUtils.parseJSON(n.getResult(!0))
            } catch (n) {
                return i = new createjs.ErrorEvent("JSON_FORMAT", null, n), this._sendError(i), n
            }
            return t
        };
        createjs.JSONLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.AbstractLoader_constructor(n, !1, createjs.Types.JSONP);
            this.setTag(createjs.Elements.script());
            this.getTag().type = "text/javascript"
        }
        var n = createjs.extend(t, createjs.AbstractLoader);
        t.canLoadItem = function(n) {
            return n.type == createjs.Types.JSONP
        };
        n.cancel = function() {
            this.AbstractLoader_cancel();
            this._dispose()
        };
        n.load = function() {
            if (null == this._item.callback) throw new Error("callback is required for loading JSONP requests.");
            if (null != window[this._item.callback]) throw new Error("JSONP callback '" + this._item.callback + "' already exists on window. You need to specify a different callback or re-name the current one.");
            window[this._item.callback] = createjs.proxy(this._handleLoad, this);
            createjs.DomUtils.appendToBody(this._tag);
            this._loadTimeout = setTimeout(createjs.proxy(this._handleTimeout, this), this._item.loadTimeout);
            this._tag.src = this._item.src
        };
        n._handleLoad = function(n) {
            this._result = this._rawResult = n;
            this._sendComplete();
            this._dispose()
        };
        n._handleTimeout = function() {
            this._dispose();
            this.dispatchEvent(new createjs.ErrorEvent("timeout"))
        };
        n._dispose = function() {
            createjs.DomUtils.removeChild(this._tag);
            delete window[this._item.callback];
            clearTimeout(this._loadTimeout)
        };
        createjs.JSONPLoader = createjs.promote(t, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function i(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.MANIFEST);
            this.plugins = null;
            this._manifestQueue = null
        }
        var n = createjs.extend(i, createjs.AbstractLoader),
            t = i;
        t.MANIFEST_PROGRESS = .25;
        t.canLoadItem = function(n) {
            return n.type == createjs.Types.MANIFEST
        };
        n.load = function() {
            this.AbstractLoader_load()
        };
        n._createRequest = function() {
            var n = this._item.callback;
            this._request = new(null != n ? createjs.JSONPLoader : createjs.JSONLoader)(this._item)
        };
        n.handleEvent = function(n) {
            switch (n.type) {
                case "complete":
                    return this._rawResult = n.target.getResult(!0), this._result = n.target.getResult(), this._sendProgress(t.MANIFEST_PROGRESS), void this._loadManifest(this._result);
                case "progress":
                    return n.loaded *= t.MANIFEST_PROGRESS, this.progress = n.loaded / n.total, !isNaN(this.progress) && this.progress != 1 / 0 || (this.progress = 0), void this._sendProgress(n)
            }
            this.AbstractLoader_handleEvent(n)
        };
        n.destroy = function() {
            this.AbstractLoader_destroy();
            this._manifestQueue.close()
        };
        n._loadManifest = function(n) {
            var t, i, r;
            if (n && n.manifest) {
                for (t = this._manifestQueue = new createjs.LoadQueue(this._preferXHR), t.on("fileload", this._handleManifestFileLoad, this), t.on("progress", this._handleManifestProgress, this), t.on("complete", this._handleManifestComplete, this, !0), t.on("error", this._handleManifestError, this, !0), i = 0, r = this.plugins.length; i < r; i++) t.installPlugin(this.plugins[i]);
                t.loadManifest(n)
            } else this._sendComplete()
        };
        n._handleManifestFileLoad = function(n) {
            n.target = null;
            this.dispatchEvent(n)
        };
        n._handleManifestComplete = function() {
            this._loadedItems = this._manifestQueue.getItems(!0);
            this._sendComplete()
        };
        n._handleManifestProgress = function(n) {
            this.progress = n.progress * (1 - t.MANIFEST_PROGRESS) + t.MANIFEST_PROGRESS;
            this._sendProgress(this.progress)
        };
        n._handleManifestError = function(n) {
            var t = new createjs.Event("fileerror");
            t.item = n.data;
            this.dispatchEvent(t)
        };
        createjs.ManifestLoader = createjs.promote(i, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractMediaLoader_constructor(n, t, createjs.Types.SOUND);
            createjs.DomUtils.isAudioTag(n) || createjs.DomUtils.isAudioTag(n.src) ? this._tag = n : createjs.DomUtils.isAudioTag(n.tag) && (this._tag = createjs.DomUtils.isAudioTag(n) ? n : n.src);
            null != this._tag && (this._preferXHR = !1)
        }
        var t = createjs.extend(n, createjs.AbstractMediaLoader);
        n.canLoadItem = function(n) {
            return n.type == createjs.Types.SOUND
        };
        t._createTag = function(n) {
            var t = createjs.Elements.audio();
            return t.autoplay = !1, t.preload = "none", t.src = n, t
        };
        createjs.SoundLoader = createjs.promote(n, "AbstractMediaLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractMediaLoader_constructor(n, t, createjs.Types.VIDEO);
            createjs.DomUtils.isVideoTag(n) || createjs.DomUtils.isVideoTag(n.src) ? (this.setTag(createjs.DomUtils.isVideoTag(n) ? n : n.src), this._preferXHR = !1) : this.setTag(this._createTag())
        }
        var t = n;
        createjs.extend(n, createjs.AbstractMediaLoader)._createTag = function() {
            return createjs.Elements.video()
        };
        t.canLoadItem = function(n) {
            return n.type == createjs.Types.VIDEO
        };
        createjs.VideoLoader = createjs.promote(n, "AbstractMediaLoader")
    }(),
    function() {
        "use strict";

        function i(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.SPRITESHEET);
            this._manifestQueue = null
        }
        var n = createjs.extend(i, createjs.AbstractLoader),
            t = i;
        t.SPRITESHEET_PROGRESS = .25;
        t.canLoadItem = function(n) {
            return n.type == createjs.Types.SPRITESHEET
        };
        n.destroy = function() {
            this.AbstractLoader_destroy();
            this._manifestQueue.close()
        };
        n._createRequest = function() {
            var n = this._item.callback;
            this._request = new(null != n ? createjs.JSONPLoader : createjs.JSONLoader)(this._item)
        };
        n.handleEvent = function(n) {
            switch (n.type) {
                case "complete":
                    return this._rawResult = n.target.getResult(!0), this._result = n.target.getResult(), this._sendProgress(t.SPRITESHEET_PROGRESS), void this._loadManifest(this._result);
                case "progress":
                    return n.loaded *= t.SPRITESHEET_PROGRESS, this.progress = n.loaded / n.total, !isNaN(this.progress) && this.progress != 1 / 0 || (this.progress = 0), void this._sendProgress(n)
            }
            this.AbstractLoader_handleEvent(n)
        };
        n._loadManifest = function(n) {
            var t;
            n && n.images && ((t = this._manifestQueue = new createjs.LoadQueue(this._preferXHR, this._item.path, this._item.crossOrigin)).on("complete", this._handleManifestComplete, this, !0), t.on("fileload", this._handleManifestFileLoad, this), t.on("progress", this._handleManifestProgress, this), t.on("error", this._handleManifestError, this, !0), t.loadManifest(n.images))
        };
        n._handleManifestFileLoad = function(n) {
            var t, i = n.result;
            null != i && (n = (t = this.getResult().images).indexOf(n.item.src), t[n] = i)
        };
        n._handleManifestComplete = function() {
            this._result = new createjs.SpriteSheet(this._result);
            this._loadedItems = this._manifestQueue.getItems(!0);
            this._sendComplete()
        };
        n._handleManifestProgress = function(n) {
            this.progress = n.progress * (1 - t.SPRITESHEET_PROGRESS) + t.SPRITESHEET_PROGRESS;
            this._sendProgress(this.progress)
        };
        n._handleManifestError = function(n) {
            var t = new createjs.Event("fileerror");
            t.item = n.data;
            this.dispatchEvent(t)
        };
        createjs.SpriteSheetLoader = createjs.promote(i, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n, t) {
            this.AbstractLoader_constructor(n, t, createjs.Types.SVG);
            this.resultFormatter = this._formatResult;
            this._tagSrcAttribute = "data";
            t ? this.setTag(createjs.Elements.svg()) : (this.setTag(createjs.Elements.object()), this.getTag().type = "image/svg+xml")
        }
        var t = createjs.extend(n, createjs.AbstractLoader);
        n.canLoadItem = function(n) {
            return n.type == createjs.Types.SVG
        };
        t._formatResult = function(n) {
            var t = createjs.DataUtils.parseXML(n.getResult(!0)),
                n = n.getTag();
            return (!this._preferXHR && document.body.contains(n) && document.body.removeChild(n), null == t.documentElement) ? t : (t = t.documentElement, document.importNode && (t = document.importNode(t, !0)), n.appendChild(t), n)
        };
        createjs.SVGLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function n(n) {
            this.AbstractLoader_constructor(n, !0, createjs.Types.XML);
            this.resultFormatter = this._formatResult
        }
        var t = createjs.extend(n, createjs.AbstractLoader);
        n.canLoadItem = function(n) {
            return n.type == createjs.Types.XML
        };
        t._formatResult = function(n) {
            return createjs.DataUtils.parseXML(n.getResult(!0))
        };
        createjs.XMLLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        var n = createjs.SoundJS = createjs.SoundJS || {};
        n.version = "NEXT";
        n.buildDate = "Thu, 14 Sep 2017 22:19:45 GMT"
    }(),
    function() {
        "use strict";

        function n() {
            throw "BrowserDetect cannot be instantiated";
        }
        var t = n.agent = window.navigator.userAgent;
        n.isWindowPhone = -1 < t.indexOf("IEMobile") || -1 < t.indexOf("Windows Phone");
        n.isFirefox = -1 < t.indexOf("Firefox");
        n.isOpera = null != window.opera;
        n.isChrome = -1 < t.indexOf("Chrome");
        n.isIOS = (-1 < t.indexOf("iPod") || -1 < t.indexOf("iPhone") || -1 < t.indexOf("iPad")) && !n.isWindowPhone;
        n.isAndroid = -1 < t.indexOf("Android") && !n.isWindowPhone;
        n.isBlackberry = -1 < t.indexOf("Blackberry");
        n.isEdge = -1 < t.indexOf("Edg");
        createjs.BrowserDetect = n
    }(),
    function() {
        "use strict";

        function t() {
            this.interrupt = null;
            this.delay = null;
            this.offset = null;
            this.loop = null;
            this.volume = null;
            this.pan = null;
            this.startTime = null;
            this.duration = null
        }
        var i = t.prototype = {},
            n = t;
        n.create = function(t) {
            if ("string" == typeof t) return console && (console.warn || console.log)("Deprecated behaviour. Sound.play takes a configuration object instead of individual arguments. See docs for info."), (new createjs.PlayPropsConfig).set({
                interrupt: t
            });
            if (null == t || t instanceof n || t instanceof Object) return (new createjs.PlayPropsConfig).set(t);
            if (null == t) throw new Error("PlayProps configuration not recognized.");
        };
        i.set = function(n) {
            if (null != n)
                for (var t in n) this[t] = n[t];
            return this
        };
        i.toString = function() {
            return "[PlayPropsConfig]"
        };
        createjs.PlayPropsConfig = n
    }(),
    function() {
        "use strict";

        function r() {
            throw "Sound cannot be instantiated";
        }

        function t(n, t) {
            this.init(n, t)
        }
        var n = r,
            i;
        n.INTERRUPT_ANY = "any";
        n.INTERRUPT_EARLY = "early";
        n.INTERRUPT_LATE = "late";
        n.INTERRUPT_NONE = "none";
        n.PLAY_INITED = "playInited";
        n.PLAY_SUCCEEDED = "playSucceeded";
        n.PLAY_INTERRUPTED = "playInterrupted";
        n.PLAY_FINISHED = "playFinished";
        n.PLAY_FAILED = "playFailed";
        n.SUPPORTED_EXTENSIONS = ["mp3", "ogg", "opus", "mpeg", "wav", "m4a", "mp4", "aiff", "wma", "mid"];
        n.EXTENSION_MAP = {
            m4a: "mp4"
        };
        n.FILE_PATTERN = /^(?:(\w+:)\/{2}(\w+(?:\.\w+)*\/?))?([/.]*?(?:[^?]+)?\/)?((?:[^/?]+)\.(\w+))(?:\?(\S+)?)?$/;
        n.defaultInterruptBehavior = n.INTERRUPT_NONE;
        n.alternateExtensions = [];
        n.activePlugin = null;
        n._masterVolume = 1;
        n._getMasterVolume = function() {
            return this._masterVolume
        };
        n.getVolume = createjs.deprecate(n._getMasterVolume, "Sound.getVolume");
        n._setMasterVolume = function(t) {
            if (null != Number(t) && (t = Math.max(0, Math.min(1, t)), n._masterVolume = t, !this.activePlugin || !this.activePlugin.setVolume || !this.activePlugin.setVolume(t)))
                for (var r = this._instances, i = 0, u = r.length; i < u; i++) r[i].setMasterVolume(t)
        };
        n.setVolume = createjs.deprecate(n._setMasterVolume, "Sound.setVolume");
        n._masterMute = !1;
        n._getMute = function() {
            return this._masterMute
        };
        n.getMute = createjs.deprecate(n._getMute, "Sound.getMute");
        n._setMute = function(n) {
            if (null != n && (this._masterMute = n, !this.activePlugin || !this.activePlugin.setMute || !this.activePlugin.setMute(n)))
                for (var i = this._instances, t = 0, r = i.length; t < r; t++) i[t].setMasterMute(n)
        };
        n.setMute = createjs.deprecate(n._setMute, "Sound.setMute");
        n._getCapabilities = function() {
            return null == n.activePlugin ? null : n.activePlugin._capabilities
        };
        n.getCapabilities = createjs.deprecate(n._getCapabilities, "Sound.getCapabilities");
        Object.defineProperties(n, {
            volume: {
                get: n._getMasterVolume,
                set: n._setMasterVolume
            },
            muted: {
                get: n._getMute,
                set: n._setMute
            },
            capabilities: {
                get: n._getCapabilities
            }
        });
        n._pluginsRegistered = !1;
        n._lastID = 0;
        n._instances = [];
        n._idHash = {};
        n._preloadHash = {};
        n._defaultPlayPropsHash = {};
        n.addEventListener = null;
        n.removeEventListener = null;
        n.removeAllEventListeners = null;
        n.dispatchEvent = null;
        n.hasEventListener = null;
        n._listeners = null;
        createjs.EventDispatcher.initialize(n);
        n.getPreloadHandlers = function() {
            return {
                callback: createjs.proxy(n.initLoad, n),
                types: ["sound"],
                extensions: n.SUPPORTED_EXTENSIONS
            }
        };
        n._handleLoadComplete = function(t) {
            var u = t.target.getItem().src,
                i, f, r;
            if (n._preloadHash[u])
                for (i = 0, f = n._preloadHash[u].length; i < f; i++) r = n._preloadHash[u][i], n._preloadHash[u][i] = !0, n.hasEventListener("fileload") && ((t = new createjs.Event("fileload")).src = r.src, t.id = r.id, t.data = r.data, t.sprite = r.sprite, n.dispatchEvent(t))
        };
        n._handleLoadError = function(t) {
            var u = t.target.getItem().src,
                i, f, r;
            if (n._preloadHash[u])
                for (i = 0, f = n._preloadHash[u].length; i < f; i++) r = n._preloadHash[u][i], n._preloadHash[u][i] = !1, n.hasEventListener("fileerror") && ((t = new createjs.Event("fileerror")).src = r.src, t.id = r.id, t.data = r.data, t.sprite = r.sprite, n.dispatchEvent(t))
        };
        n._registerPlugin = function(t) {
            return !!t.isSupported() && (n.activePlugin = new t, !0)
        };
        n.registerPlugins = function(t) {
            n._pluginsRegistered = !0;
            for (var i = 0, r = t.length; i < r; i++)
                if (n._registerPlugin(t[i])) return !0;
            return !1
        };
        n.initializeDefaultPlugins = function() {
            return null != n.activePlugin || !n._pluginsRegistered && !!n.registerPlugins([createjs.WebAudioPlugin, createjs.HTMLAudioPlugin])
        };
        n.isReady = function() {
            return null != n.activePlugin
        };
        n.initLoad = function(t) {
            return "video" == t.type || n._registerSound(t)
        };
        n._registerSound = function(i) {
            var r, e, f, o, u;
            if (!n.initializeDefaultPlugins() || (i.src instanceof Object ? (u = n._parseSrc(i.src)).src = i.path + u.src : u = n._parsePath(i.src), null == u)) return !1;
            if (i.src = u.src, i.type = "sound", r = i.data, e = null, null != r && (isNaN(r.channels) ? isNaN(r) || (e = parseInt(r)) : e = parseInt(r.channels), r.audioSprite))
                for (o = r.audioSprite.length; o--;) f = r.audioSprite[o], n._idHash[f.id] = {
                    src: i.src,
                    startTime: parseInt(f.startTime),
                    duration: parseInt(f.duration)
                }, f.defaultPlayProps && (n._defaultPlayPropsHash[f.id] = createjs.PlayPropsConfig.create(f.defaultPlayProps));
            return null != i.id && (n._idHash[i.id] = {
                src: i.src
            }), u = n.activePlugin.register(i), t.create(i.src, e), null != r && isNaN(r) ? i.data.channels = e || t.maxPerChannel() : i.data = e || t.maxPerChannel(), u.type && (i.type = u.type), i.defaultPlayProps && (n._defaultPlayPropsHash[i.src] = createjs.PlayPropsConfig.create(i.defaultPlayProps)), u
        };
        n.registerSound = function(t, i, r, u, f) {
            if (f = {
                    src: t,
                    id: i,
                    data: r,
                    defaultPlayProps: f
                }, t instanceof Object && t.src && (u = i, f = t), null == ((f = createjs.LoadItem.create(f)).path = u) || f.src instanceof Object || (f.src = u + f.src), u = n._registerSound(f), !u) return !1;
            if (n._preloadHash[f.src] || (n._preloadHash[f.src] = []), n._preloadHash[f.src].push(f), 1 == n._preloadHash[f.src].length) u.on("complete", this._handleLoadComplete, this), u.on("error", this._handleLoadError, this), n.activePlugin.preload(u);
            else if (1 == n._preloadHash[f.src][0]) return !0;
            return f
        };
        n.registerSounds = function(n, t) {
            var r = [],
                i, u;
            for (n.path && (t ? t += n.path : t = n.path, n = n.manifest), i = 0, u = n.length; i < u; i++) r[i] = createjs.Sound.registerSound(n[i].src, n[i].id, n[i].data, t, n[i].defaultPlayProps);
            return r
        };
        n.removeSound = function(i, r) {
            if (null == n.activePlugin) return !1;
            var f, u;
            if (i instanceof Object && i.src && (i = i.src), null == (f = i instanceof Object ? n._parseSrc(i) : (i = n._getSrcById(i).src, n._parsePath(i)))) return !1;
            for (u in i = f.src, null != r && (i = r + i), n._idHash) n._idHash[u].src == i && delete n._idHash[u];
            return t.removeSrc(i), delete n._preloadHash[i], n.activePlugin.removeSound(i), !0
        };
        n.removeSounds = function(n, t) {
            var r = [],
                i, u;
            for (n.path && (t ? t += n.path : t = n.path, n = n.manifest), i = 0, u = n.length; i < u; i++) r[i] = createjs.Sound.removeSound(n[i].src, t);
            return r
        };
        n.removeAllSounds = function() {
            n._idHash = {};
            n._preloadHash = {};
            t.removeAll();
            n.activePlugin && n.activePlugin.removeAllSounds()
        };
        n.loadComplete = function(t) {
            if (!n.isReady()) return !1;
            var i = n._parsePath(t);
            return t = (i ? n._getSrcById(i.src) : n._getSrcById(t)).src, null != n._preloadHash[t] && 1 == n._preloadHash[t][0]
        };
        n._parsePath = function(t) {
            var i;
            if ("string" != typeof t && (t = t.toString()), i = t.match(n.FILE_PATTERN), null == i) return !1;
            for (var f = i[4], r = i[5], e = n.capabilities, u = 0; !e[r];)
                if (r = n.alternateExtensions[u++], u > n.alternateExtensions.length) return null;
            return {
                name: f,
                src: t = t.replace("." + i[5], "." + r),
                extension: r
            }
        };
        n._parseSrc = function(t) {
            var r, i = {
                    name: void 0,
                    src: void 0,
                    extension: void 0
                },
                f = n.capabilities,
                u;
            for (r in t)
                if (t.hasOwnProperty(r) && f[r]) {
                    i.src = t[r];
                    i.extension = r;
                    break
                }
            return i.src ? (u = i.src.lastIndexOf("/"), i.name = -1 != u ? i.src.slice(u + 1) : i.src, i) : !1
        };
        n.play = function(t, i) {
            var r;
            return createjs.WebAudioPlugin && createjs.WebAudioPlugin.context && ("interrupted" !== (r = createjs.WebAudioPlugin.context).state && "suspended" !== r.state || r.resume()), i = createjs.PlayPropsConfig.create(i), t = n.createInstance(t, i.startTime, i.duration), r && (t.audioCtx = r), n._playInstance(t, i) || t._playFailed(), t
        };
        n.createInstance = function(i, r, u) {
            var o, f, e;
            return n.initializeDefaultPlugins() ? (o = n._defaultPlayPropsHash[i], i = n._getSrcById(i), f = n._parsePath(i.src), e = null, null != f && null != f.src ? (t.create(f.src), null == r && (r = i.startTime), e = n.activePlugin.create(f.src, r, u || i.duration), (o = o || n._defaultPlayPropsHash[f.src]) && e.applyPlayProps(o)) : e = new createjs.DefaultSoundInstance(i, r, u), e.uniqueId = n._lastID++, e) : new createjs.DefaultSoundInstance(i, r, u)
        };
        n.stop = function() {
            for (var n = this._instances, t = n.length; t--;) n[t].stop()
        };
        n.setDefaultPlayProps = function(t, i) {
            t = n._getSrcById(t);
            n._defaultPlayPropsHash[n._parsePath(t.src).src] = createjs.PlayPropsConfig.create(i)
        };
        n.getDefaultPlayProps = function(t) {
            return t = n._getSrcById(t), n._defaultPlayPropsHash[n._parsePath(t.src).src]
        };
        n._playInstance = function(t, i) {
            var r = n._defaultPlayPropsHash[t.src] || {};
            if (null == i.interrupt && (i.interrupt = r.interrupt || n.defaultInterruptBehavior), null == i.delay && (i.delay = r.delay || 0), null == i.offset && (i.offset = t.position), null == i.loop && (i.loop = t.loop), null == i.volume && (i.volume = t.volume), null == i.pan && (i.pan = t.pan), 0 == i.delay) {
                if (!n._beginPlaying(t, i)) return !1
            } else r = setTimeout(function() {
                n._beginPlaying(t, i)
            }, i.delay), t.delayTimeoutId = r;
            return this._instances.push(t), !0
        };
        n._beginPlaying = function(n, i) {
            return t.add(n, i.interrupt) ? n._beginPlaying(i) ? !0 : (n = createjs.indexOf(this._instances, n), -1 < n && this._instances.splice(n, 1), !1) : !1
        };
        n._getSrcById = function(t) {
            return n._idHash[t] || {
                src: t
            }
        };
        n._playFinished = function(n) {
            t.remove(n);
            n = createjs.indexOf(this._instances, n); - 1 < n && this._instances.splice(n, 1)
        };
        createjs.Sound = r;
        t.channels = {};
        t.create = function(n, i) {
            return null == t.get(n) && (t.channels[n] = new t(n, i), !0)
        };
        t.removeSrc = function(n) {
            var i = t.get(n);
            return null != i && (i._removeAll(), delete t.channels[n], !0)
        };
        t.removeAll = function() {
            for (var n in t.channels) t.channels[n]._removeAll();
            t.channels = {}
        };
        t.add = function(n, i) {
            var r = t.get(n.src);
            return null != r && r._add(n, i)
        };
        t.remove = function(n) {
            var i = t.get(n.src);
            return null != i && (i._remove(n), !0)
        };
        t.maxPerChannel = function() {
            return i.maxDefault
        };
        t.get = function(n) {
            return t.channels[n]
        };
        i = t.prototype;
        i.constructor = t;
        i.src = null;
        i.max = null;
        i.maxDefault = 100;
        i.length = 0;
        i.init = function(n, t) {
            this.src = n;
            this.max = t || this.maxDefault; - 1 == this.max && (this.max = this.maxDefault);
            this._instances = []
        };
        i._get = function(n) {
            return this._instances[n]
        };
        i._add = function(n, t) {
            return !!this._getSlot(t, n) && (this._instances.push(n), this.length++, !0)
        };
        i._remove = function(n) {
            return n = createjs.indexOf(this._instances, n), -1 != n && (this._instances.splice(n, 1), this.length--, !0)
        };
        i._removeAll = function() {
            for (var n = this.length - 1; 0 <= n; n--) this._instances[n].stop()
        };
        i._getSlot = function(n) {
            var t, i, u, f;
            if (n != r.INTERRUPT_NONE && null == (i = this._get(0))) return !0;
            for (u = 0, f = this.max; u < f; u++) {
                if (null == (t = this._get(u))) return !0;
                if (t.playState == r.PLAY_FINISHED || t.playState == r.PLAY_INTERRUPTED || t.playState == r.PLAY_FAILED) {
                    i = t;
                    break
                }
                n != r.INTERRUPT_NONE && (n == r.INTERRUPT_EARLY && t.position < i.position || n == r.INTERRUPT_LATE && t.position > i.position) && (i = t)
            }
            return null != i && (i._interrupt(), this._remove(i), !0)
        };
        i.toString = function() {
            return "[Sound SoundChannel]"
        }
    }(),
    function() {
        "use strict";

        function t(n, t, i, r) {
            this.EventDispatcher_constructor();
            this.src = n;
            this.uniqueId = -1;
            this.playState = null;
            this.delayTimeoutId = null;
            this._volume = 1;
            Object.defineProperty(this, "volume", {
                get: this._getVolume,
                set: this._setVolume
            });
            this._pan = 0;
            Object.defineProperty(this, "pan", {
                get: this._getPan,
                set: this._setPan
            });
            this._startTime = Math.max(0, t || 0);
            Object.defineProperty(this, "startTime", {
                get: this._getStartTime,
                set: this._setStartTime
            });
            this._duration = Math.max(0, i || 0);
            Object.defineProperty(this, "duration", {
                get: this._getDuration,
                set: this._setDuration
            });
            this._playbackResource = null;
            Object.defineProperty(this, "playbackResource", {
                get: this._getPlaybackResource,
                set: this._setPlaybackResource
            });
            !1 !== r && !0 !== r && this._setPlaybackResource(r);
            this._position = 0;
            Object.defineProperty(this, "position", {
                get: this._getPosition,
                set: this._setPosition
            });
            this._loop = 0;
            Object.defineProperty(this, "loop", {
                get: this._getLoop,
                set: this._setLoop
            });
            this._muted = !1;
            Object.defineProperty(this, "muted", {
                get: this._getMuted,
                set: this._setMuted
            });
            this._paused = !1;
            Object.defineProperty(this, "paused", {
                get: this._getPaused,
                set: this._setPaused
            })
        }
        var n = createjs.extend(t, createjs.EventDispatcher);
        n.play = function(n) {
            return n = createjs.PlayPropsConfig.create(n), this.playState == createjs.Sound.PLAY_SUCCEEDED ? (this.applyPlayProps(n), void(this._paused && this._setPaused(!1))) : (this._cleanUp(), createjs.Sound._playInstance(this, n), this)
        };
        n.stop = function() {
            return this._position = 0, this._paused = !1, this._handleStop(), this._cleanUp(), this.playState = createjs.Sound.PLAY_FINISHED, this
        };
        n.destroy = function() {
            this._cleanUp();
            this.src = null;
            this.playbackResource = null;
            this.removeAllEventListeners()
        };
        n.applyPlayProps = function(n) {
            return null != n.offset && this._setPosition(n.offset), null != n.loop && this._setLoop(n.loop), null != n.volume && this._setVolume(n.volume), null != n.pan && this._setPan(n.pan), null != n.startTime && (this._setStartTime(n.startTime), this._setDuration(n.duration)), this
        };
        n.toString = function() {
            return "[AbstractSoundInstance]"
        };
        n._getPaused = function() {
            return this._paused
        };
        n._setPaused = function(n) {
            if ((!0 === n || !1 === n) && this._paused != n && (1 != n || this.playState == createjs.Sound.PLAY_SUCCEEDED)) return (this._paused = n) ? this._pause() : this._resume(), clearTimeout(this.delayTimeoutId), this
        };
        n._setVolume = function(n) {
            return n == this._volume || (this._volume = Math.max(0, Math.min(1, n)), this._muted || this._updateVolume()), this
        };
        n._getVolume = function() {
            return this._volume
        };
        n._setMuted = function(n) {
            if (!0 === n || !1 === n) return this._muted = n, this._updateVolume(), this
        };
        n._getMuted = function() {
            return this._muted
        };
        n._setPan = function(n) {
            return n == this._pan || (this._pan = Math.max(-1, Math.min(1, n)), this._updatePan()), this
        };
        n._getPan = function() {
            return this._pan
        };
        n._getPosition = function() {
            return this._paused || this.playState != createjs.Sound.PLAY_SUCCEEDED || (this._position = this._calculateCurrentPosition()), this._position
        };
        n._setPosition = function(n) {
            return this._position = Math.max(0, n), this.playState == createjs.Sound.PLAY_SUCCEEDED && this._updatePosition(), this
        };
        n._getStartTime = function() {
            return this._startTime
        };
        n._setStartTime = function(n) {
            return n == this._startTime || (this._startTime = Math.max(0, n || 0), this._updateStartTime()), this
        };
        n._getDuration = function() {
            return this._duration
        };
        n._setDuration = function(n) {
            return n == this._duration || (this._duration = Math.max(0, n || 0), this._updateDuration()), this
        };
        n._setPlaybackResource = function(n) {
            return this._playbackResource = n, 0 == this._duration && this._playbackResource && this._setDurationFromSource(), this
        };
        n._getPlaybackResource = function() {
            return this._playbackResource
        };
        n._getLoop = function() {
            return this._loop
        };
        n._setLoop = function(n) {
            null != this._playbackResource && (0 != this._loop && 0 == n ? this._removeLooping(n) : 0 == this._loop && 0 != n && this._addLooping(n));
            this._loop = n
        };
        n._sendEvent = function(n) {
            n = new createjs.Event(n);
            this.dispatchEvent(n)
        };
        n._cleanUp = function() {
            clearTimeout(this.delayTimeoutId);
            this._handleCleanUp();
            this._paused = !1;
            createjs.Sound._playFinished(this)
        };
        n._interrupt = function() {
            this._cleanUp();
            this.playState = createjs.Sound.PLAY_INTERRUPTED;
            this._sendEvent("interrupted")
        };
        n._beginPlaying = function(n) {
            return this._setPosition(n.offset), this._setLoop(n.loop), this._setVolume(n.volume), this._setPan(n.pan), null != n.startTime && (this._setStartTime(n.startTime), this._setDuration(n.duration)), null != this._playbackResource && this._position < this._duration ? (this._paused = !1, this._handleSoundReady(), this.playState = createjs.Sound.PLAY_SUCCEEDED, this._sendEvent("succeeded"), !0) : (this._playFailed(), !1)
        };
        n._playFailed = function() {
            this._cleanUp();
            this.playState = createjs.Sound.PLAY_FAILED;
            this._sendEvent("failed")
        };
        n._handleSoundComplete = function() {
            if ((this._position = 0) != this._loop) return this._loop--, this._handleLoop(), void this._sendEvent("loop");
            this._cleanUp();
            this.playState = createjs.Sound.PLAY_FINISHED;
            this._sendEvent("complete")
        };
        n._handleSoundReady = function() {};
        n._updateVolume = function() {};
        n._updatePan = function() {};
        n._updateStartTime = function() {};
        n._updateDuration = function() {};
        n._setDurationFromSource = function() {};
        n._calculateCurrentPosition = function() {};
        n._updatePosition = function() {};
        n._removeLooping = function() {};
        n._addLooping = function() {};
        n._pause = function() {};
        n._resume = function() {};
        n._handleStop = function() {};
        n._handleCleanUp = function() {};
        n._handleLoop = function() {};
        createjs.AbstractSoundInstance = createjs.promote(t, "EventDispatcher");
        createjs.DefaultSoundInstance = createjs.AbstractSoundInstance
    }(),
    function() {
        "use strict";

        function t() {
            this._capabilities = null;
            this._loaders = {};
            this._audioSources = {};
            this._soundInstances = {};
            this._volume = 1;
            this._loaderClass;
            this._soundInstanceClass
        }
        var n = t.prototype;
        t._capabilities = null;
        t.isSupported = function() {
            return !0
        };
        n.register = function(n) {
            var t = this._loaders[n.src];
            return t && !t.canceled ? this._loaders[n.src] : (this._audioSources[n.src] = !0, this._soundInstances[n.src] = [], (t = new this._loaderClass(n)).on("complete", this._handlePreloadComplete, this), this._loaders[n.src] = t)
        };
        n.preload = function(n) {
            n.on("error", this._handlePreloadError, this);
            n.load()
        };
        n.isPreloadStarted = function(n) {
            return null != this._audioSources[n]
        };
        n.isPreloadComplete = function(n) {
            return !(null == this._audioSources[n] || 1 == this._audioSources[n])
        };
        n.removeSound = function(n) {
            if (this._soundInstances[n]) {
                for (var t = this._soundInstances[n].length; t--;) this._soundInstances[n][t].destroy();
                delete this._soundInstances[n];
                delete this._audioSources[n];
                this._loaders[n] && this._loaders[n].destroy();
                delete this._loaders[n]
            }
        };
        n.removeAllSounds = function() {
            for (var n in this._audioSources) this.removeSound(n)
        };
        n.create = function(n, t, i) {
            return this.isPreloadStarted(n) || this.preload(this.register(n)), i = new this._soundInstanceClass(n, t, i, this._audioSources[n]), this._soundInstances[n] && this._soundInstances[n].push(i), i.setMasterVolume && i.setMasterVolume(createjs.Sound.volume), i.setMasterMute && i.setMasterMute(createjs.Sound.muted), i
        };
        n.setVolume = function(n) {
            return this._volume = n, this._updateVolume(), !0
        };
        n.getVolume = function() {
            return this._volume
        };
        n.setMute = function() {
            return this._updateVolume(), !0
        };
        n.toString = function() {
            return "[AbstractPlugin]"
        };
        n._handlePreloadComplete = function(n) {
            var t = n.target.getItem().src,
                i, r;
            for (this._audioSources[t] = n.result, i = 0, r = this._soundInstances[t].length; i < r; i++) this._soundInstances[t][i].setPlaybackResource(this._audioSources[t]), this._soundInstances[t] = null
        };
        n._handlePreloadError = function() {};
        n._updateVolume = function() {};
        createjs.AbstractPlugin = t
    }(),
    function() {
        "use strict";

        function n(n) {
            this.AbstractLoader_constructor(n, !0, createjs.Types.SOUND)
        }
        var t = createjs.extend(n, createjs.AbstractLoader);
        n.context = null;
        t.toString = function() {
            return "[WebAudioLoader]"
        };
        t._createRequest = function() {
            this._request = new createjs.XHRRequest(this._item, !1);
            this._request.setResponseType("arraybuffer")
        };
        t._sendComplete = function() {
            n.context.decodeAudioData(this._rawResult, createjs.proxy(this._handleAudioDecoded, this), createjs.proxy(this._sendError, this))
        };
        t._handleAudioDecoded = function(n) {
            this._result = n;
            this.AbstractLoader__sendComplete()
        };
        createjs.WebAudioLoader = createjs.promote(n, "AbstractLoader")
    }(),
    function() {
        "use strict";

        function i(n, i, r, u) {
            this.AbstractSoundInstance_constructor(n, i, r, u);
            this.gainNode = t.context.createGain();
            this.panNode = t.context.createPanner();
            this.panNode.panningModel = t._panningModel;
            this.panNode.connect(this.gainNode);
            this._updatePan();
            this.sourceNode = null;
            this._soundCompleteTimeout = null;
            this._sourceNodeNext = null;
            this._playbackStartTime = 0;
            this._endedHandler = createjs.proxy(this._handleSoundComplete, this)
        }
        var n = createjs.extend(i, createjs.AbstractSoundInstance),
            t = i;
        t.context = null;
        t._scratchBuffer = null;
        t.destinationNode = null;
        t._panningModel = "equalpower";
        n.destroy = function() {
            this.AbstractSoundInstance_destroy();
            this.panNode.disconnect(0);
            this.panNode = null;
            this.gainNode.disconnect(0);
            this.gainNode = null
        };
        n.toString = function() {
            return "[WebAudioSoundInstance]"
        };
        n._updatePan = function() {
            this.panNode.setPosition(this._pan, 0, -.5)
        };
        n._removeLooping = function() {
            this._sourceNodeNext = this._cleanUpAudioNode(this._sourceNodeNext)
        };
        n._addLooping = function() {
            this.playState == createjs.Sound.PLAY_SUCCEEDED && (this._sourceNodeNext = this._createAndPlayAudioNode(this._playbackStartTime, 0))
        };
        n._setDurationFromSource = function() {
            this._duration = 1e3 * this.playbackResource.duration
        };
        n._handleCleanUp = function() {
            this.sourceNode && this.playState == createjs.Sound.PLAY_SUCCEEDED && (this.sourceNode = this._cleanUpAudioNode(this.sourceNode), this._sourceNodeNext = this._cleanUpAudioNode(this._sourceNodeNext));
            0 != this.gainNode.numberOfOutputs && this.gainNode.disconnect(0);
            clearTimeout(this._soundCompleteTimeout);
            this._playbackStartTime = 0
        };
        n._cleanUpAudioNode = function(n) {
            if (n) {
                if (n.stop(0), n.disconnect(0), createjs.BrowserDetect.isIOS) try {
                    n.buffer = t._scratchBuffer
                } catch (n) {}
                n = null
            }
            return n
        };
        n._handleSoundReady = function() {
            this.gainNode.connect(t.destinationNode);
            var n = .001 * this._duration,
                i = Math.min(.001 * Math.max(0, this._position), n);
            this.sourceNode = this._createAndPlayAudioNode(t.context.currentTime - n, i);
            this._playbackStartTime = this.sourceNode.startTime - i;
            this._soundCompleteTimeout = setTimeout(this._endedHandler, 1e3 * (n - i));
            0 != this._loop && (this._sourceNodeNext = this._createAndPlayAudioNode(this._playbackStartTime, 0))
        };
        n._createAndPlayAudioNode = function(n, i) {
            var r = t.context.createBufferSource(),
                u;
            return r.buffer = this.playbackResource, r.connect(this.panNode), u = .001 * this._duration, r.startTime = n + u, r.start(r.startTime, i + .001 * this._startTime, u - i), r
        };
        n._pause = function() {
            this._position = 1e3 * (t.context.currentTime - this._playbackStartTime);
            this.sourceNode = this._cleanUpAudioNode(this.sourceNode);
            this._sourceNodeNext = this._cleanUpAudioNode(this._sourceNodeNext);
            0 != this.gainNode.numberOfOutputs && this.gainNode.disconnect(0);
            clearTimeout(this._soundCompleteTimeout)
        };
        n._resume = function() {
            this._handleSoundReady()
        };
        n._updateVolume = function() {
            var n = this._muted ? 0 : this._volume;
            n != this.gainNode.gain.value && (this.gainNode.gain.value = n)
        };
        n._calculateCurrentPosition = function() {
            return 1e3 * (t.context.currentTime - this._playbackStartTime)
        };
        n._updatePosition = function() {
            this.sourceNode = this._cleanUpAudioNode(this.sourceNode);
            this._sourceNodeNext = this._cleanUpAudioNode(this._sourceNodeNext);
            clearTimeout(this._soundCompleteTimeout);
            this._paused || this._handleSoundReady()
        };
        n._handleLoop = function() {
            this._cleanUpAudioNode(this.sourceNode);
            this.sourceNode = this._sourceNodeNext;
            this._playbackStartTime = this.sourceNode.startTime;
            this._sourceNodeNext = this._createAndPlayAudioNode(this._playbackStartTime, 0);
            this._soundCompleteTimeout = setTimeout(this._endedHandler, this._duration)
        };
        n._updateDuration = function() {
            this.playState == createjs.Sound.PLAY_SUCCEEDED && (this._pause(), this._resume())
        };
        createjs.WebAudioSoundInstance = createjs.promote(i, "AbstractSoundInstance")
    }(),
    function() {
        "use strict";

        function t() {
            this.AbstractPlugin_constructor();
            this._panningModel = n._panningModel;
            this.context = n.context;
            this.dynamicsCompressorNode = this.context.createDynamicsCompressor();
            this.dynamicsCompressorNode.connect(this.context.destination);
            this.gainNode = this.context.createGain();
            this.gainNode.connect(this.dynamicsCompressorNode);
            createjs.WebAudioSoundInstance.destinationNode = this.gainNode;
            this._capabilities = n._capabilities;
            this._loaderClass = createjs.WebAudioLoader;
            this._soundInstanceClass = createjs.WebAudioSoundInstance;
            this._addPropsToClasses()
        }
        var i = createjs.extend(t, createjs.AbstractPlugin),
            n = t;
        n._capabilities = null;
        n._panningModel = "equalpower";
        n.context = null;
        n._scratchBuffer = null;
        n._unlocked = !1;
        n.DEFAULT_SAMPLE_RATE = 44100;
        n.isSupported = function() {
            var t = createjs.BrowserDetect.isIOS || createjs.BrowserDetect.isAndroid || createjs.BrowserDetect.isBlackberry;
            return !("file:" == location.protocol && !t && !this._isFileXHRSupported()) && (n._generateCapabilities(), null != n.context)
        };
        n.playEmptySound = function() {
            var t;
            null != n.context && ((t = n.context.createBufferSource()).buffer = n._scratchBuffer, t.connect(n.context.destination), t.start(0, 0, 0))
        };
        n._isFileXHRSupported = function() {
            return document.location.host
        };
        n._generateCapabilities = function() {
            var t, i, u;
            if (null == n._capabilities) {
                if ((t = document.createElement("audio"), null == t.canPlayType) || null == n.context && (n.context = n._createAudioContext(), null == n.context)) return null;
                null == n._scratchBuffer && (n._scratchBuffer = n.context.createBuffer(1, 1, 22050));
                n._compatibilitySetUp();
                "ontouchstart" in window && "running" != n.context.state && (n._unlock(), document.addEventListener("mousedown", n._unlock, !0), document.addEventListener("touchstart", n._unlock, !0), document.addEventListener("touchend", n._unlock, !0));
                n._capabilities = {
                    panning: !0,
                    volume: !0,
                    tracks: -1
                };
                for (var f = createjs.Sound.SUPPORTED_EXTENSIONS, e = createjs.Sound.EXTENSION_MAP, r = 0, o = f.length; r < o; r++) i = f[r], u = e[i] || i, n._capabilities[i] = "no" != t.canPlayType("audio/" + i) && "" != t.canPlayType("audio/" + i) || "no" != t.canPlayType("audio/" + u) && "" != t.canPlayType("audio/" + u);
                n.context.destination.numberOfChannels < 2 && (n._capabilities.panning = !1)
            }
        };
        n._createAudioContext = function() {
            var r = window.AudioContext || window.webkitAudioContext,
                u, i, t;
            return null == r ? null : (t = new r, console.warn("The AudioContext is ready"), /(iPhone|iPad)/i.test(navigator.userAgent) && t.sampleRate !== n.DEFAULT_SAMPLE_RATE && (u = t.createBuffer(1, 1, n.DEFAULT_SAMPLE_RATE), (i = t.createBufferSource()).buffer = u, i.connect(t.destination), i.start(0), i.disconnect(), t.close(), t = new r), t)
        };
        n._compatibilitySetUp = function() {
            var t;
            n._panningModel = "equalpower";
            n.context.createGain || (n.context.createGain = n.context.createGainNode, (t = n.context.createBufferSource()).__proto__.start = t.__proto__.noteGrainOn, t.__proto__.stop = t.__proto__.noteOff, n._panningModel = 0)
        };
        n._unlock = function() {
            n._unlocked || (n.playEmptySound(), "running" == n.context.state && (document.removeEventListener("mousedown", n._unlock, !0), document.removeEventListener("touchend", n._unlock, !0), document.removeEventListener("touchstart", n._unlock, !0), n._unlocked = !0))
        };
        i.toString = function() {
            return "[WebAudioPlugin]"
        };
        i._addPropsToClasses = function() {
            var t = this._soundInstanceClass;
            t.context = this.context;
            t._scratchBuffer = n._scratchBuffer;
            t.destinationNode = this.gainNode;
            t._panningModel = this._panningModel;
            this._loaderClass.context = this.context
        };
        i._updateVolume = function() {
            var n = createjs.Sound._masterMute ? 0 : this._volume;
            n != this.gainNode.gain.value && (this.gainNode.gain.value = n)
        };
        createjs.WebAudioPlugin = createjs.promote(t, "AbstractPlugin")
    }(),
    function() {
        "use strict";

        function r() {
            throw "HTMLAudioTagPool cannot be instantiated";
        }

        function i() {
            this._tags = []
        }
        var n = r,
            t;
        n._tags = {};
        n._tagPool = new i;
        n._tagUsed = {};
        n.get = function(t) {
            var i = n._tags[t];
            return null == i ? (i = n._tags[t] = n._tagPool.get()).src = t : n._tagUsed[t] ? (i = n._tagPool.get()).src = t : n._tagUsed[t] = !0, i
        };
        n.set = function(t, i) {
            i == n._tags[t] ? n._tagUsed[t] = !1 : n._tagPool.set(i)
        };
        n.remove = function(t) {
            var i = n._tags[t];
            return null != i && (n._tagPool.set(i), delete n._tags[t], delete n._tagUsed[t], !0)
        };
        n.getDuration = function(t) {
            return t = n._tags[t], null != t && t.duration ? 1e3 * t.duration : 0
        };
        createjs.HTMLAudioTagPool = r;
        t = i.prototype;
        t.constructor = i;
        t.get = function() {
            var n = 0 == this._tags.length ? this._createTag() : this._tags.pop();
            return null == n.parentNode && document.body.appendChild(n), n
        };
        t.set = function(n) {
            -1 == createjs.indexOf(this._tags, n) && (this._tags.src = null, this._tags.push(n))
        };
        t.toString = function() {
            return "[TagPool]"
        };
        t._createTag = function() {
            var n = document.createElement("audio");
            return n.autoplay = !1, n.preload = "none", n
        }
    }(),
    function() {
        "use strict";

        function t(n, t, i, r) {
            this.AbstractSoundInstance_constructor(n, t, i, r);
            this._audioSpriteStopTime = null;
            this._delayTimeoutId = null;
            this._endedHandler = createjs.proxy(this._handleSoundComplete, this);
            this._readyHandler = createjs.proxy(this._handleTagReady, this);
            this._stalledHandler = createjs.proxy(this._playFailed, this);
            this._audioSpriteEndHandler = createjs.proxy(this._handleAudioSpriteLoop, this);
            this._loopHandler = createjs.proxy(this._handleSoundComplete, this);
            i ? this._audioSpriteStopTime = .001 * (t + i) : this._duration = createjs.HTMLAudioTagPool.getDuration(this.src)
        }
        var n = createjs.extend(t, createjs.AbstractSoundInstance);
        n.setMasterVolume = function() {
            this._updateVolume()
        };
        n.setMasterMute = function() {
            this._updateVolume()
        };
        n.toString = function() {
            return "[HTMLAudioSoundInstance]"
        };
        n._removeLooping = function() {
            null != this._playbackResource && (this._playbackResource.loop = !1, this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1))
        };
        n._addLooping = function() {
            null == this._playbackResource || this._audioSpriteStopTime || (this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1), this._playbackResource.loop = !0)
        };
        n._handleCleanUp = function() {
            var n = this._playbackResource;
            if (null != n) {
                n.pause();
                n.loop = !1;
                n.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_ENDED, this._endedHandler, !1);
                n.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_READY, this._readyHandler, !1);
                n.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_STALLED, this._stalledHandler, !1);
                n.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1);
                n.removeEventListener(createjs.HTMLAudioPlugin._TIME_UPDATE, this._audioSpriteEndHandler, !1);
                try {
                    n.currentTime = this._startTime
                } catch (n) {}
                createjs.HTMLAudioTagPool.set(this.src, n);
                this._playbackResource = null
            }
        };
        n._beginPlaying = function(n) {
            return this._playbackResource = createjs.HTMLAudioTagPool.get(this.src), this.AbstractSoundInstance__beginPlaying(n)
        };
        n._handleSoundReady = function() {
            if (4 !== this._playbackResource.readyState) {
                var n = this._playbackResource;
                return n.addEventListener(createjs.HTMLAudioPlugin._AUDIO_READY, this._readyHandler, !1), n.addEventListener(createjs.HTMLAudioPlugin._AUDIO_STALLED, this._stalledHandler, !1), n.preload = "auto", void n.load()
            }
            this._updateVolume();
            this._playbackResource.currentTime = .001 * (this._startTime + this._position);
            this._audioSpriteStopTime ? this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._TIME_UPDATE, this._audioSpriteEndHandler, !1) : (this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._AUDIO_ENDED, this._endedHandler, !1), 0 != this._loop && (this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1), this._playbackResource.loop = !0));
            this._playbackResource.play()
        };
        n._handleTagReady = function() {
            this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_READY, this._readyHandler, !1);
            this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_STALLED, this._stalledHandler, !1);
            this._handleSoundReady()
        };
        n._pause = function() {
            this._playbackResource.pause()
        };
        n._resume = function() {
            this._playbackResource.play()
        };
        n._updateVolume = function() {
            var n;
            null == this._playbackResource || (n = this._muted || createjs.Sound._masterMute ? 0 : this._volume * createjs.Sound._masterVolume) != this._playbackResource.volume && (this._playbackResource.volume = n)
        };
        n._calculateCurrentPosition = function() {
            return 1e3 * this._playbackResource.currentTime - this._startTime
        };
        n._updatePosition = function() {
            this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1);
            this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._handleSetPositionSeek, !1);
            try {
                this._playbackResource.currentTime = .001 * (this._position + this._startTime)
            } catch (n) {
                this._handleSetPositionSeek(null)
            }
        };
        n._handleSetPositionSeek = function() {
            null != this._playbackResource && (this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._handleSetPositionSeek, !1), this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1))
        };
        n._handleAudioSpriteLoop = function() {
            this._playbackResource.currentTime <= this._audioSpriteStopTime || (this._playbackResource.pause(), 0 == this._loop ? this._handleSoundComplete(null) : (this._position = 0, this._loop--, this._playbackResource.currentTime = .001 * this._startTime, this._paused || this._playbackResource.play(), this._sendEvent("loop")))
        };
        n._handleLoop = function() {
            0 == this._loop && (this._playbackResource.loop = !1, this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_SEEKED, this._loopHandler, !1))
        };
        n._updateStartTime = function() {
            this._audioSpriteStopTime = .001 * (this._startTime + this._duration);
            this.playState == createjs.Sound.PLAY_SUCCEEDED && (this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_ENDED, this._endedHandler, !1), this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._TIME_UPDATE, this._audioSpriteEndHandler, !1))
        };
        n._updateDuration = function() {
            this._audioSpriteStopTime = .001 * (this._startTime + this._duration);
            this.playState == createjs.Sound.PLAY_SUCCEEDED && (this._playbackResource.removeEventListener(createjs.HTMLAudioPlugin._AUDIO_ENDED, this._endedHandler, !1), this._playbackResource.addEventListener(createjs.HTMLAudioPlugin._TIME_UPDATE, this._audioSpriteEndHandler, !1))
        };
        n._setDurationFromSource = function() {
            this._duration = createjs.HTMLAudioTagPool.getDuration(this.src);
            this._playbackResource = null
        };
        createjs.HTMLAudioSoundInstance = createjs.promote(t, "AbstractSoundInstance")
    }(),
    function() {
        "use strict";

        function i() {
            this.AbstractPlugin_constructor();
            this._capabilities = n._capabilities;
            this._loaderClass = createjs.SoundLoader;
            this._soundInstanceClass = createjs.HTMLAudioSoundInstance
        }
        var t = createjs.extend(i, createjs.AbstractPlugin),
            n = i;
        n.MAX_INSTANCES = 30;
        n._AUDIO_READY = "canplaythrough";
        n._AUDIO_ENDED = "ended";
        n._AUDIO_SEEKED = "seeked";
        n._AUDIO_STALLED = "stalled";
        n._TIME_UPDATE = "timeupdate";
        n._capabilities = null;
        n.isSupported = function() {
            return n._generateCapabilities(), null != n._capabilities
        };
        n._generateCapabilities = function() {
            var t, i, u;
            if (null == n._capabilities) {
                if (t = document.createElement("audio"), null == t.canPlayType) return null;
                n._capabilities = {
                    panning: !1,
                    volume: !0,
                    tracks: -1
                };
                for (var f = createjs.Sound.SUPPORTED_EXTENSIONS, e = createjs.Sound.EXTENSION_MAP, r = 0, o = f.length; r < o; r++) i = f[r], u = e[i] || i, n._capabilities[i] = "no" != t.canPlayType("audio/" + i) && "" != t.canPlayType("audio/" + i) || "no" != t.canPlayType("audio/" + u) && "" != t.canPlayType("audio/" + u)
            }
        };
        t.register = function(n) {
            var t = createjs.HTMLAudioTagPool.get(n.src),
                n = this.AbstractPlugin_register(n);
            return n.setTag(t), n
        };
        t.removeSound = function(n) {
            this.AbstractPlugin_removeSound(n);
            createjs.HTMLAudioTagPool.remove(n)
        };
        t.create = function(n, t, i) {
            return i = this.AbstractPlugin_create(n, t, i), i.playbackResource = null, i
        };
        t.toString = function() {
            return "[HTMLAudioPlugin]"
        };
        t.setVolume = t.getVolume = t.setMute = null;
        createjs.HTMLAudioPlugin = createjs.promote(i, "AbstractPlugin")
    }(),
    function() {
        "use strict";

        function t(n) {
            this.EventDispatcher_constructor();
            this.ignoreGlobalPause = !1;
            this.loop = 0;
            this.useTicks = !1;
            this.reversed = !1;
            this.bounce = !1;
            this.timeScale = 1;
            this.duration = 0;
            this.position = 0;
            this.rawPosition = -1;
            this._paused = !0;
            this._next = null;
            this._prev = null;
            this._parent = null;
            this._labels = null;
            this._labelList = null;
            this._status = -1;
            this._lastTick = 0;
            n && (this.useTicks = !!n.useTicks, this.ignoreGlobalPause = !!n.ignoreGlobalPause, this.loop = !0 === n.loop ? -1 : n.loop || 0, this.reversed = !!n.reversed, this.bounce = !!n.bounce, this.timeScale = n.timeScale || 1, n.onChange && this.addEventListener("change", n.onChange), n.onComplete && this.addEventListener("complete", n.onComplete))
        }
        var n = createjs.extend(t, createjs.EventDispatcher);
        n._setPaused = function(n) {
            return createjs.Tween._register(this, n), this
        };
        n.setPaused = createjs.deprecate(n._setPaused, "AbstractTween.setPaused");
        n._getPaused = function() {
            return this._paused
        };
        n.getPaused = createjs.deprecate(n._getPaused, "AbstactTween.getPaused");
        n._getCurrentLabel = function(n) {
            var i = this.getLabels(),
                t, r;
            for (null == n && (n = this.position), t = 0, r = i.length; t < r && !(n < i[t].position); t++);
            return 0 === t ? null : i[t - 1].label
        };
        n.getCurrentLabel = createjs.deprecate(n._getCurrentLabel, "AbstractTween.getCurrentLabel");
        try {
            Object.defineProperties(n, {
                paused: {
                    set: n._setPaused,
                    get: n._getPaused
                },
                currentLabel: {
                    get: n._getCurrentLabel
                }
            })
        } catch (t) {}
        n.advance = function(n, t) {
            this.setPosition(this.rawPosition + n * this.timeScale, t)
        };
        n.setPosition = function(n, t, i, r) {
            var u = this.duration,
                s = this.loop,
                o = this.rawPosition,
                h = 0,
                e = 0,
                f = !1;
            if (n < 0 && (n = 0), 0 === u) {
                if (f = !0, -1 !== o) return f
            } else {
                if (e = n - (h = n / u | 0) * u, (f = -1 !== s && s * u + u <= n) && (n = (e = u) * (h = s) + u), n === o) return f;
                !this.reversed != !(this.bounce && h % 2) && (e = u - e)
            }
            this.position = e;
            this.rawPosition = n;
            this._updatePosition(i, f);
            f && (this.paused = !0);
            r && r(this);
            t || this._runActions(o, n, i, !i && -1 === o);
            this.dispatchEvent("change");
            f && this.dispatchEvent("complete")
        };
        n.calculatePosition = function(n) {
            var t = this.duration,
                r = this.loop,
                u = 0,
                i = 0;
            return 0 === t ? 0 : (-1 !== r && r * t + t <= n ? (i = t, u = r) : i = n < 0 ? 0 : n - (u = n / t | 0) * t, !this.reversed != !(this.bounce && u % 2) ? t - i : i)
        };
        n.getLabels = function() {
            var n = this._labelList,
                t, i;
            if (!n) {
                n = this._labelList = [];
                i = this._labels;
                for (t in i) n.push({
                    label: t,
                    position: i[t]
                });
                n.sort(function(n, t) {
                    return n.position - t.position
                })
            }
            return n
        };
        n.setLabels = function(n) {
            this._labels = n;
            this._labelList = null
        };
        n.addLabel = function(n, t) {
            var i, r, u;
            if (this._labels || (this._labels = {}), this._labels[n] = t, i = this._labelList, i) {
                for (r = 0, u = i.length; r < u && !(t < i[r].position); r++);
                i.splice(r, 0, {
                    label: n,
                    position: t
                })
            }
        };
        n.gotoAndPlay = function(n) {
            this.paused = !1;
            this._goto(n)
        };
        n.gotoAndStop = function(n) {
            this.paused = !0;
            this._goto(n)
        };
        n.resolve = function(n) {
            var t = Number(n);
            return isNaN(t) && (t = this._labels && this._labels[n]), t
        };
        n.toString = function() {
            return "[AbstractTween]"
        };
        n.clone = function() {
            throw "AbstractTween can not be cloned.";
        };
        n._init = function(n) {
            n && n.paused || (this.paused = !1);
            n && null != n.position && this.setPosition(n.position)
        };
        n._updatePosition = function() {};
        n._goto = function(n) {
            n = this.resolve(n);
            null != n && this.setPosition(n, !1, !0)
        };
        n._runActions = function(n, t, i, r) {
            var l, o;
            if (this._actionHead || this.tweens) {
                var u, e, h, s, f = this.duration,
                    p = this.reversed,
                    a = this.bounce,
                    c = this.loop;
                if (0 === f ? (u = e = h = s = 0, p = a = !1) : (h = n - (u = n / f | 0) * f, s = t - (e = t / f | 0) * f), -1 !== c && (c < e && (s = f, e = c), c < u && (h = f, u = c)), i) return this._runActionsRange(s, s, i, r);
                if (u !== e || h !== s || i || r) {
                    -1 === u && (u = h = 0);
                    l = n <= t;
                    o = u;
                    do {
                        var w = !p != !(a && o % 2),
                            v = o === u ? h : l ? 0 : f,
                            y = o === e ? s : l ? f : 0;
                        if (w && (v = f - v, y = f - y), (!a || o === u || v !== y) && this._runActionsRange(v, y, i, r || o !== u && !a)) return !0
                    } while (r = !1, l && ++o <= e || !l && --o >= e)
                }
            }
        };
        n._runActionsRange = function() {};
        createjs.AbstractTween = createjs.promote(t, "EventDispatcher")
    }(),
    function() {
        "use strict";

        function n(t, r) {
            this.AbstractTween_constructor(r);
            this.pluginData = null;
            this.target = t;
            this.passive = !1;
            this._stepHead = new i(null, 0, 0, {}, null, !0);
            this._stepTail = this._stepHead;
            this._stepPosition = 0;
            this._actionHead = null;
            this._actionTail = null;
            this._plugins = null;
            this._pluginIds = null;
            this._injected = null;
            r && (this.pluginData = r.pluginData, r.override && n.removeTweens(t));
            this.pluginData || (this.pluginData = {});
            this._init(r)
        }

        function i(n, t, i, r, u, f) {
            this.next = null;
            this.prev = n;
            this.t = t;
            this.d = i;
            this.props = r;
            this.ease = u;
            this.passive = f;
            this.index = n ? n.index + 1 : 0
        }

        function r(n, t, i, r, u) {
            this.next = null;
            this.prev = n;
            this.t = t;
            this.d = 0;
            this.scope = i;
            this.funct = r;
            this.params = u
        }
        var t = createjs.extend(n, createjs.AbstractTween);
        n.IGNORE = {};
        n._tweens = [];
        n._plugins = null;
        n._tweenHead = null;
        n._tweenTail = null;
        n._inTick = 0;
        n.get = function(t, i) {
            return new n(t, i)
        };
        n.tick = function(t, i) {
            for (var e, u, r = n._tweenHead, f = n._inTick = Date.now(); r;) e = r._next, u = r._status, r._lastTick = f, 1 === u ? r._status = 0 : -1 === u ? n._delist(r) : i && !r.ignoreGlobalPause || r._paused || r.advance(r.useTicks ? 1 : t), r = e;
            n._inTick = 0
        };
        n.handleEvent = function(n) {
            "tick" === n.type && this.tick(n.delta, n.paused)
        };
        n.removeTweens = function(t) {
            var i, r;
            if (t.tweenjs_count) {
                for (i = n._tweenHead; i;) r = i._next, i.target === t && n._register(i, !0), i = r;
                t.tweenjs_count = 0
            }
        };
        n.removeAllTweens = function() {
            for (var i, t = n._tweenHead; t;) i = t._next, t._paused = !0, t.target && (t.target.tweenjs_count = 0), t._next = t._prev = null, t = i;
            n._tweenHead = n._tweenTail = null
        };
        n.hasActiveTweens = function(t) {
            return t ? !!t.tweenjs_count : !!n._tweenHead
        };
        n._installPlugin = function(t) {
            for (var u = t.priority = t.priority || 0, r = n._plugins = n._plugins || [], i = 0, f = r.length; i < f && !(u < r[i].priority); i++);
            r.splice(i, 0, t)
        };
        n._register = function(t, i) {
            var u, r = t.target;
            !i && t._paused ? (r && (r.tweenjs_count = r.tweenjs_count ? r.tweenjs_count + 1 : 1), (u = n._tweenTail) ? (n._tweenTail = u._next = t)._prev = u : n._tweenHead = n._tweenTail = t, t._status = n._inTick ? 1 : 0, !n._inited && createjs.Ticker && (createjs.Ticker.addEventListener("tick", n), n._inited = !0)) : i && !t._paused && (r && r.tweenjs_count--, n._inTick && t._lastTick !== n._inTick || n._delist(t), t._status = -1);
            t._paused = i
        };
        n._delist = function(t) {
            var i = t._next,
                r = t._prev;
            i ? i._prev = r : n._tweenTail = r;
            r ? r._next = i : n._tweenHead = i;
            t._next = t._prev = null
        };
        t.wait = function(n, t) {
            return 0 < n && this._addStep(+n, this._stepTail.props, null, t), this
        };
        t.to = function(n, t, i) {
            return (null == t || t < 0) && (t = 0), i = this._addStep(+t, null, i), this._appendProps(n, i), this
        };
        t.label = function(n) {
            return this.addLabel(n, this.duration), this
        };
        t.call = function(n, t, i) {
            return this._addAction(i || this.target, n, t || [this])
        };
        t.set = function(n, t) {
            return this._addAction(t || this.target, this._set, [n])
        };
        t.play = function(n) {
            return this._addAction(n || this, this._set, [{
                paused: !1
            }])
        };
        t.pause = function(n) {
            return this._addAction(n || this, this._set, [{
                paused: !0
            }])
        };
        t.w = t.wait;
        t.t = t.to;
        t.c = t.call;
        t.s = t.set;
        t.toString = function() {
            return "[Tween]"
        };
        t.clone = function() {
            throw "Tween can not be cloned.";
        };
        t._addPlugin = function(n) {
            var u = this._pluginIds || (this._pluginIds = {}),
                r = n.ID;
            if (r && !u[r]) {
                u[r] = !0;
                for (var t = this._plugins || (this._plugins = []), f = n.priority || 0, i = 0, e = t.length; i < e; i++)
                    if (f < t[i].priority) return void t.splice(i, 0, n);
                t.push(n)
            }
        };
        t._updatePosition = function(n, t) {
            var i = this._stepHead.next,
                r = this.position,
                u = this.duration,
                f;
            if (this.target && i) {
                for (f = i.next; f && f.t <= r;) f = (i = i.next).next;
                u = t ? 0 === u ? 1 : r / u : (r - i.t) / i.d;
                this._updateTargetProps(i, u, t)
            }
            this._stepPosition = i ? r - i.t : 0
        };
        t._updateTargetProps = function(t, i, r) {
            var e, u, c, a, l, v, o, f, s, y, h;
            if (!(this.passive = !!t.passive)) {
                l = t.prev.props;
                v = t.props;
                (a = t.ease) && (i = a(i, 0, 1, 1));
                o = this._plugins;
                n: for (f in l) {
                    if (e = (u = l[f]) !== (c = v[f]) && "number" == typeof u ? u + (c - u) * i : 1 <= i ? c : u, o)
                        for (s = 0, y = o.length; s < y; s++) {
                            if (h = o[s].change(this, t, f, e, i, r), h === n.IGNORE) continue n;
                            void 0 !== h && (e = h)
                        }
                    this.target[f] = e
                }
            }
        };
        t._runActionsRange = function(n, t, i, r) {
            var e = t < n,
                u = e ? this._actionTail : this._actionHead,
                o = t,
                s = n,
                h, f;
            for (e && (o = n, s = t), h = this.position; u;) {
                if (f = u.t, (f === t || s < f && f < o || r && f === n) && (u.funct.apply(u.scope, u.params), h !== this.position)) return !0;
                u = e ? u.prev : u.next
            }
        };
        t._appendProps = function(t, i, r) {
            var u, e, c, f, p = this._stepHead.props,
                w = this.target,
                o = n._plugins,
                v = i.prev,
                l = v.props,
                y = i.props || (i.props = this._cloneProps(l)),
                h = {},
                a, s;
            for (u in t)
                if (t.hasOwnProperty(u) && (h[u] = y[u] = t[u], void 0 === p[u])) {
                    if (f = void 0, o)
                        for (e = o.length - 1; 0 <= e; e--)
                            if (void 0 !== (c = o[e].init(this, u, f)) && (f = c), f === n.IGNORE) {
                                delete y[u];
                                delete h[u];
                                break
                            }
                    f !== n.IGNORE && (void 0 === f && (f = w[u]), l[u] = void 0 === f ? null : f)
                }
            for (u in h)
                for (c = t[u], s = v;
                    (a = s) && (s = a.prev);)
                    if (s.props !== a.props) {
                        if (void 0 !== s.props[u]) break;
                        s.props[u] = l[u]
                    }
            if (!1 !== r && (o = this._plugins))
                for (e = o.length - 1; 0 <= e; e--) o[e].step(this, i, h);
            (r = this._injected) && (this._injected = null, this._appendProps(r, i, !1));
            this.step = i
        };
        t._injectProp = function(n, t) {
            (this._injected || (this._injected = {}))[n] = t
        };
        t._addStep = function(n, t, r, u) {
            return u = new i(this._stepTail, this.duration, n, t, r, u || !1), this.duration += n, this._stepTail = this._stepTail.next = u
        };
        t._addAction = function(n, t, i) {
            return i = new r(this._actionTail, this.duration, n, t, i), this._actionTail ? this._actionTail.next = i : this._actionHead = i, this._actionTail = i, this
        };
        t._set = function(n) {
            for (var t in n) this[t] = n[t]
        };
        t._cloneProps = function(n) {
            var t, i = {};
            for (t in n) i[t] = n[t];
            return i
        };
        createjs.Tween = createjs.promote(n, "AbstractTween")
    }(),
    function() {
        "use strict";

        function t(n) {
            var t, i;
            n instanceof Array || null == n && 1 < arguments.length ? (t = n, i = arguments[1], n = arguments[2]) : n && (t = n.tweens, i = n.labels);
            this.AbstractTween_constructor(n);
            this.tweens = [];
            t && this.addTween.apply(this, t);
            this.setLabels(i);
            this._init(n)
        }
        var n = createjs.extend(t, createjs.AbstractTween);
        n.addTween = function(n) {
            var t, i, r;
            if (n._parent && n._parent.removeTween(n), t = arguments.length, 1 < t) {
                for (i = 0; i < t; i++) this.addTween(arguments[i]);
                return arguments[t - 1]
            }
            return 0 === t ? null : (this.tweens.push(n), n._parent = this, n.paused = !0, r = n.duration, 0 < n.loop && (r *= n.loop + 1), r > this.duration && (this.duration = r), 0 <= this.rawPosition && n.setPosition(this.rawPosition), n)
        };
        n.removeTween = function(n) {
            var u = arguments.length,
                i, r, t;
            if (1 < u) {
                for (i = !0, t = 0; t < u; t++) i = i && this.removeTween(arguments[t]);
                return i
            }
            if (0 === u) return !0;
            for (r = this.tweens, t = r.length; t--;)
                if (r[t] === n) return r.splice(t, 1), n._parent = null, n.duration >= this.duration && this.updateDuration(), !0;
            return !1
        };
        n.updateDuration = function() {
            for (var t, i, n = this.duration = 0, r = this.tweens.length; n < r; n++) t = this.tweens[n], i = t.duration, 0 < t.loop && (i *= t.loop + 1), i > this.duration && (this.duration = i)
        };
        n.toString = function() {
            return "[Timeline]"
        };
        n.clone = function() {
            throw "Timeline can not be cloned.";
        };
        n._updatePosition = function(n) {
            for (var i = this.position, t = 0, r = this.tweens.length; t < r; t++) this.tweens[t].setPosition(i, !0, n)
        };
        n._runActionsRange = function(n, t, i, r) {
            for (var f = this.position, u = 0, e = this.tweens.length; u < e; u++)
                if (this.tweens[u]._runActions(n, t, i, r), f !== this.position) return !0
        };
        createjs.Timeline = createjs.promote(t, "AbstractTween")
    }(),
    function() {
        "use strict";

        function n() {
            throw "Ease cannot be instantiated.";
        }
        n.none = n.linear = function(n) {
            return n
        };
        n.get = function(n) {
            return n < -1 ? n = -1 : 1 < n && (n = 1),
                function(t) {
                    return 0 == n ? t : n < 0 ? t * (t * -n + 1 + n) : t * ((2 - t) * n + (1 - n))
                }
        };
        n.getPowIn = function(n) {
            return function(t) {
                return Math.pow(t, n)
            }
        };
        n.getPowOut = function(n) {
            return function(t) {
                return 1 - Math.pow(1 - t, n)
            }
        };
        n.getPowInOut = function(n) {
            return function(t) {
                return (t *= 2) < 1 ? .5 * Math.pow(t, n) : 1 - .5 * Math.abs(Math.pow(2 - t, n))
            }
        };
        n.quadIn = n.getPowIn(2);
        n.quadOut = n.getPowOut(2);
        n.quadInOut = n.getPowInOut(2);
        n.cubicIn = n.getPowIn(3);
        n.cubicOut = n.getPowOut(3);
        n.cubicInOut = n.getPowInOut(3);
        n.quartIn = n.getPowIn(4);
        n.quartOut = n.getPowOut(4);
        n.quartInOut = n.getPowInOut(4);
        n.quintIn = n.getPowIn(5);
        n.quintOut = n.getPowOut(5);
        n.quintInOut = n.getPowInOut(5);
        n.sineIn = function(n) {
            return 1 - Math.cos(n * Math.PI / 2)
        };
        n.sineOut = function(n) {
            return Math.sin(n * Math.PI / 2)
        };
        n.sineInOut = function(n) {
            return -.5 * (Math.cos(Math.PI * n) - 1)
        };
        n.backIn = (n.getBackIn = function(n) {
            return function(t) {
                return t * t * ((n + 1) * t - n)
            }
        })(1.7);
        n.backOut = (n.getBackOut = function(n) {
            return function(t) {
                return --t * t * ((n + 1) * t + n) + 1
            }
        })(1.7);
        n.backInOut = (n.getBackInOut = function(n) {
            return n *= 1.525,
                function(t) {
                    return (t *= 2) < 1 ? t * t * ((n + 1) * t - n) * .5 : .5 * ((t -= 2) * t * ((n + 1) * t + n) + 2)
                }
        })(1.7);
        n.circIn = function(n) {
            return -(Math.sqrt(1 - n * n) - 1)
        };
        n.circOut = function(n) {
            return Math.sqrt(1 - --n * n)
        };
        n.circInOut = function(n) {
            return (n *= 2) < 1 ? -.5 * (Math.sqrt(1 - n * n) - 1) : .5 * (Math.sqrt(1 - (n -= 2) * n) + 1)
        };
        n.bounceIn = function(t) {
            return 1 - n.bounceOut(1 - t)
        };
        n.bounceOut = function(n) {
            return n < 1 / 2.75 ? 7.5625 * n * n : n < 2 / 2.75 ? 7.5625 * (n -= 1.5 / 2.75) * n + .75 : n < 2.5 / 2.75 ? 7.5625 * (n -= 2.25 / 2.75) * n + .9375 : 7.5625 * (n -= 2.625 / 2.75) * n + .984375
        };
        n.bounceInOut = function(t) {
            return t < .5 ? .5 * n.bounceIn(2 * t) : .5 * n.bounceOut(2 * t - 1) + .5
        };
        n.elasticIn = (n.getElasticIn = function(n, t) {
            var i = 2 * Math.PI;
            return function(r) {
                if (0 == r || 1 == r) return r;
                var u = t / i * Math.asin(1 / n);
                return -(n * Math.pow(2, 10 * --r) * Math.sin((r - u) * i / t))
            }
        })(1, .3);
        n.elasticOut = (n.getElasticOut = function(n, t) {
            var i = 2 * Math.PI;
            return function(r) {
                if (0 == r || 1 == r) return r;
                var u = t / i * Math.asin(1 / n);
                return n * Math.pow(2, -10 * r) * Math.sin((r - u) * i / t) + 1
            }
        })(1, .3);
        n.elasticInOut = (n.getElasticInOut = function(n, t) {
            var i = 2 * Math.PI;
            return function(r) {
                var u = t / i * Math.asin(1 / n);
                return (r *= 2) < 1 ? n * Math.pow(2, 10 * --r) * Math.sin((r - u) * i / t) * -.5 : n * Math.pow(2, -10 * --r) * Math.sin((r - u) * i / t) * .5 + 1
            }
        })(1, .3 * 1.5);
        createjs.Ease = n
    }(),
    function() {
        "use strict";

        function t() {
            throw "MotionGuidePlugin cannot be instantiated.";
        }
        var n = t;
        n.priority = 0;
        n.ID = "MotionGuide";
        n.install = function() {
            return createjs.Tween._installPlugin(t), createjs.Tween.IGNORE
        };
        n.init = function(t, i) {
            "guide" == i && t._addPlugin(n)
        };
        n.step = function(t, i, r) {
            var s, u, e, f;
            for (s in r)
                if ("guide" === s) {
                    if (u = i.props.guide, e = n._solveGuideData(r.guide, u), u.valid = !e, f = u.endData, t._injectProp("x", f.x), t._injectProp("y", f.y), e || !u.orient) break;
                    if (e = void 0 === i.prev.props.rotation ? t.target.rotation || 0 : i.prev.props.rotation, u.startOffsetRot = e - u.startData.rotation, "fixed" == u.orient) u.endAbsRot = f.rotation + u.startOffsetRot, u.deltaRotation = 0;
                    else {
                        var f = void 0 === r.rotation ? t.target.rotation || 0 : r.rotation,
                            o = f - u.endData.rotation - u.startOffsetRot,
                            h = o % 360;
                        switch (u.endAbsRot = f, u.orient) {
                            case "auto":
                                u.deltaRotation = o;
                                break;
                            case "cw":
                                u.deltaRotation = (360 + h) % 360 + 360 * Math.abs(o / 360 | 0);
                                break;
                            case "ccw":
                                u.deltaRotation = (h - 360) % 360 + -360 * Math.abs(o / 360 | 0)
                        }
                    }
                    t._injectProp("rotation", u.endAbsRot)
                }
        };
        n.change = function(t, i, r, u, f) {
            var e = i.props.guide;
            if (e && i.props !== i.prev.props && e !== i.prev.props.guide) return "guide" === r && !e.valid || "x" == r || "y" == r || "rotation" === r && e.orient ? createjs.Tween.IGNORE : void n._ratioToPositionData(f, e, t.target)
        };
        n.debug = function(t, i, r) {
            var o, f, c, h, s, e, u;
            if (t = t.guide || t, o = n._findPathProblems(t), o && console.error("MotionGuidePlugin Error found: \n" + o), !i) return o;
            for (f = t.path, c = f.length, i.save(), i.lineCap = "round", i.lineJoin = "miter", i.beginPath(), i.moveTo(f[0], f[1]), u = 2; u < c; u += 4) i.quadraticCurveTo(f[u], f[u + 1], f[u + 2], f[u + 3]);
            if (i.strokeStyle = "black", i.lineWidth = 4.5, i.stroke(), i.strokeStyle = "white", i.lineWidth = 3, i.stroke(), i.closePath(), h = r.length, r && h)
                for (s = {}, e = {}, n._solveGuideData(t, s), u = 0; u < h; u++) s.orient = "fixed", n._ratioToPositionData(r[u], s, e), i.beginPath(), i.moveTo(e.x, e.y), i.lineTo(e.x + 9 * Math.cos(.0174533 * e.rotation), e.y + 9 * Math.sin(.0174533 * e.rotation)), i.strokeStyle = "black", i.lineWidth = 4.5, i.stroke(), i.strokeStyle = "red", i.lineWidth = 3, i.stroke(), i.closePath();
            return i.restore(), o
        };
        n._solveGuideData = function(t, i) {
            var u, g, h, t;
            if (h = n.debug(t)) return h;
            u = i.path = t.path;
            i.orient = t.orient;
            i.subLines = [];
            i.totalLength = 0;
            i.startOffsetRot = 0;
            i.deltaRotation = 0;
            i.startData = {
                ratio: 0
            };
            i.endData = {
                ratio: 1
            };
            i.animSpan = 1;
            for (var y, p, c, l, nt = u.length, s = {}, a = u[0], v = u[1], r = 2; r < nt; r += 4) {
                y = u[r];
                p = u[r + 1];
                c = u[r + 2];
                l = u[r + 3];
                for (var e = {
                        weightings: [],
                        estLength: 0,
                        portion: 0
                    }, w = a, b = v, f = 1; f <= 10; f++) {
                    n._getParamsForCurve(a, v, y, p, c, l, f / 10, !1, s);
                    var k = s.x - w,
                        d = s.y - b,
                        o = Math.sqrt(k * k + d * d);
                    e.weightings.push(o);
                    e.estLength += o;
                    w = s.x;
                    b = s.y
                }
                for (i.totalLength += e.estLength, f = 0; f < 10; f++) o = e.estLength, e.weightings[f] = e.weightings[f] / o;
                i.subLines.push(e);
                a = c;
                v = l
            }
            for (o = i.totalLength, g = i.subLines.length, r = 0; r < g; r++) i.subLines[r].portion = i.subLines[r].estLength / o;
            h = isNaN(t.start) ? 0 : t.start;
            t = isNaN(t.end) ? 1 : t.end;
            n._ratioToPositionData(h, i, i.startData);
            n._ratioToPositionData(t, i, i.endData);
            i.startData.ratio = h;
            i.endData.ratio = t;
            i.animSpan = i.endData.ratio - i.startData.ratio
        };
        n._ratioToPositionData = function(t, i, r) {
            for (var a, y, o, v, e, u, c = i.subLines, s = 0, l = t * i.animSpan + i.startData.ratio, h = c.length, f = 0; f < h; f++) {
                if (l <= s + (e = c[f].portion)) {
                    u = f;
                    break
                }
                s += e
            }
            for (void 0 === u && (u = h - 1, s -= e), a = c[u].weightings, y = e, h = a.length, f = 0; f < h && !(l <= s + (e = a[f] * y)); f++) s += e;
            return u = 4 * u + 2, v = f / 10 + (l - s) / e * .1, o = i.path, n._getParamsForCurve(o[u - 2], o[u - 1], o[u], o[u + 1], o[u + 2], o[u + 3], v, i.orient, r), i.orient && (.99999 <= t && t <= 1.00001 && void 0 !== i.endAbsRot ? r.rotation = i.endAbsRot : r.rotation += i.startOffsetRot + t * i.deltaRotation), r
        };
        n._getParamsForCurve = function(n, t, i, r, u, f, e, o, s) {
            var h = 1 - e;
            s.x = h * h * n + 2 * h * e * i + e * e * u;
            s.y = h * h * t + 2 * h * e * r + e * e * f;
            o && (s.rotation = 57.2957795 * Math.atan2((r - t) * h + (f - r) * e, (i - n) * h + (u - i) * e))
        };
        n._findPathProblems = function(n) {
            var u = n.path,
                i = u && u.length || 0,
                t, r;
            if (i < 6 || (i - 2) % 4) return t = "\tCannot parse 'path' array due to invalid number of entries in path. ", t += "There should be an odd number of points, at least 3 points, and 2 entries per point (x & y). ", t += "See 'CanvasRenderingContext2D.quadraticCurveTo' for details as 'path' models a quadratic bezier.\n\n", t + ("Only [ " + i + " ] values found. Expected: " + Math.max(4 * Math.ceil((i - 2) / 4) + 2, 6));
            for (r = 0; r < i; r++)
                if (isNaN(u[r])) return "All data in path array must be numeric";
            return (t = n.start, isNaN(t) && void 0 !== t) ? "'start' out of bounds. Expected 0 to 1, got: " + t : (t = n.end, isNaN(t) && void 0 !== t) ? "'end' out of bounds. Expected 0 to 1, got: " + t : (n = n.orient, n && "fixed" != n && "auto" != n && "cw" != n && "ccw" != n ? 'Invalid orientation value. Expected ["fixed", "auto", "cw", "ccw", undefined], got: ' + n : void 0)
        };
        createjs.MotionGuidePlugin = t
    }(),
    function() {
        "use strict";
        var n = createjs.TweenJS = createjs.TweenJS || {};
        n.version = "NEXT";
        n.buildDate = "Thu, 14 Sep 2017 22:19:45 GMT"
    }(),
    function() {
        "use strict";

        function t() {
            throw "CSSPlugin cannot be instantiated.";
        }

        function i(t, i) {
            for (var e, f, r, u = [!1, t]; e = n.TRANSFORM_RE.exec(t);) "*" !== e[3] ? (f = [e[1]], r = i && i[u.length], !i || r && f[0] === r[0] || (console.log("transforms don't match: ", f[0], r && r[0]), i = null), function(t, i, r) {
                for (;;) {
                    var u = n.TRANSFORM_VALUE_RE.exec(t);
                    if (!u) return;
                    (r = r || []).push(+u[1], u[2]);
                    i && i[r.length - 1] !== u[2] && (console.log("transform units don't match: ", r[0], i[r.length - 1], u[2]), i = null)
                }
            }(e[2], r, f), u.push(f)) : u.push(i[u.length]);
            return u[0] = !!i, u
        }
        var n = t;
        n.priority = 100;
        n.ID = "CSS";
        n.VALUE_RE = /^(-?[\d.]+)([a-z%]*)$/;
        n.TRANSFORM_VALUE_RE = /(?:^| |,)(-?[\d.]+)([a-z%]*)/g;
        n.TRANSFORM_RE = /(\w+?)\(([^)]+)\)|(?:^| )(\*)(?:$| )/g;
        n.compute = !1;
        n.install = function() {
            createjs.Tween._installPlugin(t)
        };
        n.init = function(r, u, f) {
            var e = r.pluginData,
                s, o;
            if (!e.CSS_disabled && r.target instanceof HTMLElement && (o = f || (s = r.target, o = u, ((f = e.CSS_compute) || null == f && n.compute ? window.getComputedStyle(s) : s.style)[o]), void 0 !== o)) return (r._addPlugin(t), r = e.CSS || (e.CSS = {}), "transform" === u) ? (r[u] = "_t", i(o)) : (e = n.VALUE_RE.exec(o), null === e ? (r[u] = "", o) : (r[u] = e[2], parseFloat(e[1])))
        };
        n.step = function(n, t, r) {
            r.transform && (t.props.transform = i(t.props.transform, t.prev.props.transform))
        };
        n.change = function(n, t, i, r, u) {
            var f = n.pluginData.CSS[i];
            if (void 0 !== f) return "transform" === i ? r = function(n, t, i) {
                var f, s;
                if (1 === i) return t[1];
                if (0 === i || !t[0]) return n[1];
                for (var r, o, u = "", h = n.length, e = 2; e < h; e++) {
                    for (f = n[e], s = t[e], u += f[0] + "(", r = 1, o = f.length; r < o; r += 2) u += f[r] + (s[r] - f[r]) * i, u += s[r + 1] || f[r + 1], r < o - 2 && (u += ", ");
                    u += ")";
                    e < h - 1 && (u += " ")
                }
                return u
            }(t.prev.props[i], t.props[i], u) : r += f, n.target.style[i] = r, createjs.Tween.IGNORE
        };
        createjs.CSSPlugin = n
    }();
createjs.CSSPlugin.install(),
    function() {
        "use strict";

        function t() {
            throw "DotPlugin cannot be instantiated.";
        }
        var n = t;
        n.priority = 100;
        n.ID = "Dot";
        n.install = function() {
            createjs.Tween._installPlugin(t)
        };
        n.init = function(n, i, r) {
            var u = n.pluginData;
            if (!u.Dot_disabled && "." === i[0]) {
                n._addPlugin(t);
                for (var f = n.target, o = i.split("."), e = 1, h = o.length; e < h - 1; e++)
                    if (!(f = f[o[e]])) return createjs.Tween.IGNORE;
                var s = o[e],
                    n = f[s],
                    r = void 0 === r ? n : r;
                return u.Dot = u.Dot || {}, u.Dot[i] = {
                    t: f,
                    n: s
                }, r
            }
        };
        n.step = function() {};
        n.change = function(n, t, i, r) {
            var u, n = n.pluginData.Dot;
            if (n && (u = n[i])) return u.t[u.n] = r, createjs.Tween.IGNORE
        };
        createjs.DotPlugin = n
    }(),
    function() {
        "use strict";

        function t() {
            throw "RelativePlugin plugin cannot be instantiated.";
        }
        var n = t;
        n.ID = "Relative";
        n.install = function() {
            createjs.Tween._installPlugin(t)
        };
        n.init = function(t) {
            t.pluginData.Relative_disabled || t._addPlugin(n)
        };
        n.step = function(n, t, i) {
            var u, f, e, r;
            for (u in i) r = i[u], "string" == typeof r && (f = t.prev.props[u], "+" !== (e = r[0]) && "-" !== e || isNaN(r = +r + f) || (t.props[u] = r))
        };
        n.change = function() {};
        createjs.RelativePlugin = n
    }();
createjs.DotPlugin.install();
createjs.RelativePlugin.install();
window.addEventListener("DOMContentLoaded", function() {
    var n = document.createElement("style");
    n.innerHTML = "canvas {-webkit-tap-highlight-color: transparent;}";
    document.body.appendChild(n)
});
"use strict";

function zid(n) {
    return z_d("1"), document.getElementById(n)
}

function zss(n) {
    if (z_d("2"), document.getElementById(n)) return document.getElementById(n).style;
    zon && zogy("zss(): id not found")
}

function zgo(n, t, i, r, u, f) {
    if (z_d("3"), zot(t) && t != "" || t == "_self") WW.location.href = n;
    else {
        var e = "";
        return i && (e += "width=" + i + ","), r && (e += "height=" + r + ","), u && (e += "fullscreen=yes,"), f && (e += "modal=yes,alwaysRaised=yes"), WW.open(n, t, e)
    }
}

function zum(n) {
    if (z_d("4"), !zot(n)) return Number(String(n).replace(/[^\d.-]/g, ""))
}

function zot(n) {
    return n == null
}

function zop(n) {
    (z_d("5"), zot(n)) || (n.stopImmediatePropagation && n.stopImmediatePropagation(), WW.event && (WW.event.cancelBubble = !0))
}

function zil() {
    z_d("6");
    var t = function(n) {
            n || (n = event);
            n.keyCode && n.keyCode >= 32 && n.keyCode <= 40 && n.preventDefault()
        },
        n = function(n) {
            n || (n = event);
            n.preventDefault()
        },
        i = n;
    return WW.addEventListener("keydown", t, {
        passive: !1
    }), WW.addEventListener("wheel", n, {
        passive: !1
    }), WW.addEventListener("DOMMouseScroll", i, {
        passive: !1
    }), [t, n, i]
}

function zet(n) {
    function t() {
        var t = this;
        this.on = function(i, r) {
            var f, u;
            if (!zot(n) && !zot(i) && !zot(r))
                for (f = t.tags, u = 0; u < f.length; u++) f[u].addEventListener(i, r)
        };
        this.off = function(i, r) {
            var f, u;
            if (!zot(n) && !zot(i) && !zot(r))
                for (f = t.tags, u = 0; u < f.length; u++) f[u].removeEventListener(i, r)
        };
        Object.defineProperty(t, "tags", {
            get: function() {
                return zot(n) ? [] : typeof n == "string" || n instanceof String ? document.querySelectorAll(n) : typeof n.innerHTML == "string" ? [n] : []
            },
            set: function() {}
        });
        this.css = function(n, i) {
            for (var f, u = t.tags, r = 0; r < u.length; r++)
                if (arguments.length == 1 && arguments[0].constructor === {}.constructor)
                    for (f in n) u[r].style[f] = n[f];
                else {
                    if (arguments.length == 1) return t.tags[0].style[n];
                    u[r].style[n] = i
                }
        };
        this.prop = function(n, i) {
            var u, f, r, e;
            if (!zot(n)) {
                for (u = t.tags, f = [], r = 0; r < u.length; r++)
                    if (zot(i))
                        if (n.constructor === {}.constructor)
                            for (e in n) u[r][e] = n[e];
                        else f.push(u[r][n]);
                else u[r][n] = i;
                if (zot(i)) return f
            }
        }
    }
    return z_d("6.1"), new t
}

function isDUO(n) {
    return n.length == 1 && n[0] != undefined && n[0].constructor === {}.constructor
}

function zob(n, t, i, r) {
    var l = zim && (zim.ZIMONON || ZIMONON),
        u, a, o, e, s, f, c, h;
    if (isDUO(t)) {
        z_d("7");
        u = t[0];
        for (o in u)(a = o.match(/^(.+)gColor$/)) && (u[a[1] + "ackgroundColor"] = u[o], delete u[o]);
        for (e = zot(i) ? n.toString().split(/\n/, 1)[0].match(/\((.*)\)/)[1].replace(/\s+/g, "").split(",") : i.replace(/\s+/g, "").split(","), s = [], f = 0; f < e.length; f++) c = e[f].split("=")[0], e[f] = c, s.push(u[c]);
        for (f in u) e.indexOf(f) < 0 && zon && zogy(n, "bad argument " + f);
        return (h = Object.prototype.isPrototypeOf.call(n.prototype, r) ? new(n.bind.apply(n, [null].concat(s))) : n.apply(null, s)) ? (l && !h.arguments && (h.arguments = [u]), h) : !0
    }
    l && r && t && zot(r.arguments) && (r.arguments = Array.prototype.slice.call(t))
}

function zik(n) {
    if (z_d("7.5"), z_d("17.6"), !zot(n)) return zim.Pick.choose(n)
}

function z_d(n) {
    zim && (zim.DISTILL || WW.DISTILL) && zim.distillery.push(n)
}

function zimify(n, t, i, r, u, f) {
    var e, h, s, o;
    if (z_d("83.3"), n && n.noDrag) return n;
    if (f !== !0 && (f = null), e = {
            drag: function(n, t, i, r, u, f, e, o, s, h, c, l, a, v, y, p) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.drag(arguments[0])) : zim.drag(this, n, t, i, r, u, f, e, o, s, h, c, l, a, v, y, p)
            },
            noDrag: function(n) {
                return zim.noDrag(this, n)
            },
            mouse: function() {
                return zim.mouse(this)
            },
            noMouse: function() {
                return zim.noMouse(this)
            },
            effect: function(n, t, i, r, u) {
                return zim.effect(this, n, t, i, r, u)
            },
            noEffect: function(n, t) {
                return zim.noEffect(this, n, t)
            },
            updateEffects: function(n) {
                return zim.updateEffects(this, n)
            },
            wire: function(n, t, i, r, u, f, e) {
                return isDUO(arguments) ? (arguments[0].source = this, zim.wire(arguments[0])) : zim.wire(this, n, t, i, r, u, f, e)
            },
            noWire: function(n, t, i) {
                return isDUO(arguments) ? (arguments[0].source = this, zim.noWire(arguments[0])) : zim.noWire(this, n, t, i)
            },
            wired: function(n, t, i, r, u, f, e) {
                return isDUO(arguments) ? (arguments[0].target = this, zim.wired(arguments[0])) : zim.wired(this, n, t, i, r, u, f, e)
            },
            noWired: function(n, t, i) {
                return isDUO(arguments) ? (arguments[0].target = this, zim.noWired(arguments[0])) : zim.noWired(this, n, t, i)
            },
            bind: function(n, t, i, r, u) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.bind(arguments[0])) : zim.bind(this, n, t, i, r, u)
            },
            noBind: function(n, t, i, r) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.noBind(arguments[0])) : zim.noBind(this, n, t, i, r)
            },
            dragBoundary: function(n) {
                return zim.dragBoundary(this, n)
            },
            dragRect: function(n) {
                return zim.dragBoundary(this, n)
            },
            transform: function(n, t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.transform(arguments[0])) : zim.transform(this, n, t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et)
            },
            setSwipe: function(n) {
                return zim.setSwipe(this, n)
            },
            gesture: function(n, t, i, r, u, f, e, o, s, h, c, l, a, v, y) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.gesture(arguments[0])) : zim.gesture(this, n, t, i, r, u, f, e, o, s, h, c, l, a, v, y)
            },
            noGesture: function(n, t, i) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.noGesture(arguments[0])) : zim.noGesture(this, n, t, i)
            },
            gestureBoundary: function(n, t) {
                return zim.gestureBoundary(this, n, t)
            },
            gestureRect: function(n, t) {
                return zim.gestureBoundary(this, n, t)
            },
            addPhysics: function(n, t, i, r, u, f, e, o, s, h, c) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.addPhysics(arguments[0])) : zim.addPhysics(this, n, t, i, r, u, f, e, o, s, h, c)
            },
            removePhysics: function() {
                return zim.removePhysics(this)
            },
            hitTestPoint: function(n, t, i) {
                return zim.hitTestPoint(this, n, t, i)
            },
            hitTestReg: function(n, t) {
                return zim.hitTestReg(this, n, t)
            },
            hitTestRect: function(n, t, i, r) {
                return zim.hitTestRect(this, n, t, i, r)
            },
            hitTestCircle: function(n, t, i, r) {
                return zim.hitTestCircle(this, n, t, i, r)
            },
            hitTestCircleRect: function(n, t) {
                return zim.hitTestCircleRect(this, n, t)
            },
            hitTestCircles: function(n, t) {
                return zim.hitTestCircles(this, n, t)
            },
            hitTestBounds: function(n, t, i) {
                return zim.hitTestBounds(this, n, t, i)
            },
            boundsToGlobal: function(n, t, i, r) {
                return zim.boundsToGlobal(this, n, t, i, r)
            },
            resetBounds: function(n, t, i, r, u) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.resetBounds(arguments[0])) : zim.resetBounds(this, n, t, i, r, u)
            },
            hitTestPath: function(n, t, i) {
                return zim.hitTestPath(this, n, t, i)
            },
            hitTestGrid: function(n, t, i, r, u, f, e, o, s, h, c, l) {
                return zim.hitTestGrid(this, n, t, i, r, u, f, e, o, s, h, c, l)
            },
            animate: function(n, t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, dt, gt, ni, ti, ii, ri, ui, fi, ei, oi, si, hi) {
                return n && (n.props || n.obj) && isDUO(arguments) ? (arguments[0].target = this, zim.animate(arguments[0])) : zim.animate(this, n, t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, dt, gt, ni, ti, ii, ri, ui, fi, ei, oi, si, hi)
            },
            pauseAnimate: function() {
                return this
            },
            stopAnimate: function() {
                return this
            },
            wiggle: function(n, t, i, r, u, f, e, o, s, h, c, l, a, v, y) {
                return isDUO(arguments) ? (arguments[0].target = this, zim.wiggle(arguments[0])) : zim.wiggle(this, n, t, i, r, u, f, e, o, s, h, c, l, a, v, y)
            },
            loop: function(n, t, i, r, u) {
                return zim.loop(this, n, t, i, r, u)
            },
            copyMatrix: function(n) {
                return zim.copyMatrix(this, n)
            },
            duplicate: function(n) {
                return zim.duplicate(this, n)
            },
            cur: function(n) {
                return zim.cur(this, n)
            },
            sha: function(n, t, i, r) {
                return zim.sha(this, n, t, i, r)
            },
            pos: function(n, t, i, r, u, f, e, o, s, h) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.pos(arguments[0])) : zim.pos(this, n, t, i, r, u, f, e, o, s, h)
            },
            loc: function(n, t, i, r, u, f, e) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.loc(arguments[0])) : zim.loc(this, n, t, i, r, u, f, e)
            },
            mov: function(n, t) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.mov(arguments[0])) : zim.mov(this, n, t)
            },
            top: function() {
                return zim.top(this)
            },
            bot: function() {
                return zim.bot(this)
            },
            ord: function(n) {
                return zim.ord(this, n)
            },
            dep: function(n) {
                return zim.dep(this, n)
            },
            nam: function(n) {
                return zim.nam(this, n)
            },
            alp: function(n) {
                return zim.alp(this, n)
            },
            vis: function(n) {
                return zim.vis(this, n)
            },
            ble: function(n) {
                return zim.ble(this, n)
            },
            dye: function(n) {
                return zim.dye(this, n)
            },
            hov: function(n, t) {
                return zim.hov(this, n, t)
            },
            rot: function(n, t, i) {
                return zim.rot(this, n, t, i)
            },
            siz: function(n, t, i) {
                return zim.siz(this, n, t, i)
            },
            ske: function(n, t) {
                return zim.ske(this, n, t)
            },
            reg: function(n, t, i) {
                return zim.reg(this, n, t, i)
            },
            sca: function(n, t) {
                return zim.sca(this, n, t)
            },
            scaleTo: function(n, t, i, r, u) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.scaleTo(arguments[0])) : zim.scaleTo(this, n, t, i, r, u)
            },
            fit: function(n, t, i, r, u) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.fit(arguments[0])) : zim.fit(this, n, t, i, r, u)
            },
            outline: function(n, t, i) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.outline(arguments[0])) : zim.outline(this, n, t, i)
            },
            blendmodes: function(n) {
                return zim.blendmodes(this, n)
            },
            addTo: function(n, t, i) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.addTo(arguments[0])) : zim.addTo(this, n, t, i)
            },
            removeFrom: function(n) {
                return zim.removeFrom(this, n)
            },
            added: function(n, t, i) {
                return zim.added(this, n, t, i)
            },
            movement: function(n, t) {
                return zim.movement(this, n, t)
            },
            noMovement: function() {
                return zim.noMovement(this)
            },
            tap: function(n, t, i, r, u, f, e, o, s) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.tap(arguments[0])) : zim.tap(this, n, t, i, r, u, f, e, o, s)
            },
            noTap: function() {
                return zim.noTap(this)
            },
            hold: function(n, t, i, r) {
                return zim.hold(this, n, t, i, r)
            },
            noHold: function() {
                return zim.noHold(this)
            },
            change: function(n, t) {
                return zim.change(this, n, t)
            },
            noChange: function() {
                return zim.noChange(this)
            },
            centerReg: function(n, t, i) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.centerReg(arguments[0])) : zim.centerReg(this, n, t, i)
            },
            center: function(n, t, i) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.center(arguments[0])) : zim.center(this, n, t, i)
            },
            place: function(n) {
                return zim.place(this, n)
            },
            placeReg: function(n) {
                return zim.placeReg(this, n)
            },
            expand: function(n, t, i, r) {
                return isDUO(arguments) ? (arguments[0].obj = this, zim.expand(arguments[0])) : zim.expand(this, n, t, i, r)
            },
            setMask: function(n, t) {
                return zim.setMask(this, n, t)
            },
            cloneProps: function(n) {
                return n.type = this.type, n.group = this.group, n.style = this.style, n.alpha = this.alpha, n.rotation = this.rotation, n.mouseEnabled = this.mouseEnabled, n.mouseChildren = this.mouseChildren, n.tickEnabled = this.tickEnabled, n.x = this.x, n.y = this.y, n.scaleX = this.scaleX, n.scaleY = this.scaleY, n.skewX = this.skewX, n.skewY = this.skewY, n.name && (n.name = this.name), n.regX = this.regX * n.width / (this.width || 1), n.regY = this.regY * n.height / (this.height || 1), n.visible = this.visible, n.shadow = this.shadow, this.type && this.type != "Shape" || zim.copyMatrix(n, this), n.compositeOperation = this.compositeOperation, n.snapToPixel = this.snapToPixel, this.filters && this.filters.length > 0 && (n.filters = this.filters.slice(0), n.cache()), n.mask = this.mask, n.hitArea = this.hitArea, (!this.type || this.type == "Shape" || this.type == "Blob" || this.type == "Squiggle") && this._bounds && n.setBounds(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height), n
            },
            cloneChildren: function(n, t) {
                var u, i, f, r;
                for (n.children.length && n.removeAllChildren(), u = n.children, i = 0, f = this.children.length; i < f; i++) r = this.children[i].clone(t), r.parent = n, u.push(r);
                return n
            }
        }, !zot(f)) {
        f = [];
        for (h in e) f.push(h);
        return f
    }
    for (s in e) Object.prototype.hasOwnProperty.call(e, s) && (n[s] = e[s]);
    return zim && (n.cjsLocalToGlobal = n.localToGlobal, n.cjsGlobalToLocal = n.globalToLocal, n.cjsLocalToLocal = n.localToLocal, n.localToGlobal = function(t, i) {
        return zim.localToGlobal(t, i, n, n.cjsLocalToGlobal)
    }, n.globalToLocal = function(t, i) {
        return zim.globalToLocal(t, i, n, n.cjsGlobalToLocal)
    }, n.localToLocal = function(t, i, r) {
        return zim.localToLocal(t, i, r, n)
    }, n.hueBatch || zim.displayBase(n)), zot(t) || zot(i) || zot(r) || zot(u) ? zot(t) || zot(i) || (r = t, u = i, t = 0, i = 0) : t = t, zot(t) || zot(i) || zot(r) || zot(u) ? n.nominalBounds != null && n.getBounds && n.getBounds() == null && (o = n.nominalBounds, n.setBounds(o.x, o.y, o.width, o.height)) : n.setBounds(t, i, r, u), n.parent && n.parent.actionFrames && !n.parent.addPhysics && (zimify(n.parent, zdf ? zdf.width : null, zdf ? zdf.height : null), n.parent.top()), n
}

function zimplify(n) {
    var i, r, t;
    z_d("83.35");
    document.Window = Window;
    document.Blob = Blob;
    ignore = "ignore";
    zot(n) && (n = []);
    Array.isArray(n) || (n = [n]);
    i = zimify(null, null, null, null, null, !0);
    r = ["loop", "stopAnimate", "pauseAnimate", "animate", "wiggle", "wire", "wired"];
    for (t in zim)(i.indexOf(t) == -1 || r.indexOf(t) >= 0) && n.indexOf(t) == -1 && (window[t] = zim[t])
}
var WW = window || {},
    createjs = WW.createjs,
    zns = WW.zns,
    zon = WW.zon == null ? !0 : WW.zon,
    z_i, zog = zon ? console.log.bind(console) : function() {},
    zogStyle = " border:thin solid black; color: black",
    zogg = zon ? console.log.bind(console, "%c Z ", "background: #acd241;" + zogStyle) : function() {},
    zogp = zon ? console.log.bind(console, "%c Z ", "background: #e472c4;" + zogStyle) : function() {},
    zogb = zon ? console.log.bind(console, "%c Z ", "background: #50c4b7;" + zogStyle) : function() {},
    zogr = zon ? console.log.bind(console, "%c Z ", "background: #fb4758;" + zogStyle) : function() {},
    zogy = zon ? console.log.bind(console, "%c Z ", "background: #ebcb35;" + zogStyle) : function() {},
    zogo = zon ? console.log.bind(console, "%c Z ", "background: #f58e25;" + zogStyle) : function() {},
    zogl = zon ? console.log.bind(console, "%c Z ", "background: #eeeeee;" + zogStyle) : function() {},
    zogd = zon ? console.log.bind(console, "%c Z ", "background: #444444; border:thin solid black; color: white") : function() {},
    zta = console.table && zon ? console.table.bind(console) : function() {},
    zor = function() {
        for (var n = 0; n < arguments.length; n++)
            if (!zot(arguments[n])) return arguments[n]
    },
    zim = function(n) {
        function t(t, r, u, f, e) {
            n.timeCheck || (z_d("9.99"), n.timeCheck = !0);
            var o = zot(WW.TIME) ? zot(n.TIME) ? "seconds" : n.TIME : WW.TIME;
            return (o && o.toLowerCase && (o = o.toLowerCase()), o != "milliseconds" && o != "ms" && (o = "seconds"), r && r.toLowerCase && (r = r.toLowerCase()), (r == "ms" || r == "milliseconds" || r == "seconds" || r == "s") && (o = r), zot(t)) ? o.charAt(0) : (o == "ms" && (o = "milliseconds"), o == "s" && (o = "seconds"), o = o.charAt(0), e || i(t, o, u, f), o)
        }

        function i(t, i, r, u) {
            (zot(r) && (r = 10), zot(u) && (u = 9), n.TIMECHECK || WW.TIMECHECK) && (i != "m" && t > r || i == "m" && t < u) && zon && zogy("TIME - warning: time is in " + (i == "m" ? "milliseconds" : "seconds") + " (" + t + ")")
        }

        function h(t, i) {
            if (t && n.gD(t), !i && t && t.dispose && t.dispose !== n.Container.prototype.dispose && t.dispose(null, null, !0), t && t.addChild && (t.dispatchEvent("removed"), t.removeAllEventListeners(), t.numChildren))
                for (var r = t.numChildren - 1; r >= 0; r--) h(t.getChildAt(r));
            t && t.parent && t.parent.removeChild(t)
        }

        function r(n, t) {
            t ? (n.mouseChildren = !0, n.mouseEnabled = !0, n._enabled = !0) : (n.mouseChildren = !1, n.mouseEnabled = !1, n._enabled = !1)
        }

        function c(t, i, r, u, o, s, h, c, l, a, v) {
            function y() {
                function i(n) {
                    var t = f.at(n.m_fixtureB.GetBody());
                    t && t(n.m_fixtureA.GetBody().zimObj, n.m_fixtureA.GetBody());
                    t = f.at(n.m_fixtureA.GetBody());
                    t && t(n.m_fixtureB.GetBody().zimObj, n.m_fixtureB.GetBody())
                }

                function r(n) {
                    var t = e.at(n.m_fixtureB.GetBody());
                    t && t(n.m_fixtureA.GetBody().zimObj, n.m_fixtureA.GetBody());
                    t = e.at(n.m_fixtureB.GetBody().zimObj, n.m_fixtureB.GetBody());
                    t && t(n.m_fixtureB.GetBody())
                }
                WW.zimContactListener = new WW.b2ContactListener;
                f = new n.Dictionary(!0);
                e = new n.Dictionary(!0);
                WW.zimContactListener.BeginContact = i;
                WW.zimContactListener.EndContact = r;
                t.physics.world.SetContactListener(WW.zimContactListener)
            }
            z_d("69.97");
            zot(r) && (r = 0);
            u == "rectangle" ? t.body = t.physics.makeRectangle(t.width - r, t.height - r, i, o, h, c, l, a, v, s) : u == "circle" ? t.body = t.physics.makeCircle(t.width / 2 - r, i, o, h, c, l, a, v, s) : u == "triangle" && (zot(t.a) && (t.a = t.width, t.b = t.c = Math.sqrt(Math.pow(t.a / 2, 2) + Math.pow(t.height, 2))), t.body = t.physics.makeTriangle(t.a - r, t.b - r, t.c - r, i, o, h, c, l, a, v, s));
            t.body.x = t.x;
            t.body.y = t.y;
            t.body.rotation = t.rotation;
            t.physics.addMap(t.body, t);
            t.impulse = function(n, i, r, u) {
                zot(n) && (n = 0);
                zot(i) && (i = 0);
                var f = t.body.GetWorldCenter();
                return zot(r) && (r = f.x * t.physics.scale), zot(u) && (u = f.y * t.physics.scale), t.body.ApplyImpulse(new WW.b2Vec2(n, i), new WW.b2Vec2(r / t.physics.scale, u / t.physics.scale)), t
            };
            t.force = function(n, i, r, u) {
                zot(n) && (n = 0);
                zot(i) && (i = 0);
                var f = t.body.GetWorldCenter();
                return zot(r) && (r = f.x * t.physics.scale), zot(u) && (u = f.y * t.physics.scale), t.body.ApplyForce(new WW.b2Vec2(n, i), new WW.b2Vec2(r / t.physics.scale, u / t.physics.scale)), t
            };
            t.setLinearVelocity = function(n, i) {
                return t.body.SetLinearVelocity(new WW.b2Vec2(n, i)), t
            };
            t.setAngularVelocity = function(n) {
                return t.body.SetAngularVelocity(n), t
            };
            t.spin = function(n) {
                return zot(n) && (n = 10), t.body.ApplyTorque(n * 1e3), t
            };
            t.torque = function(n) {
                return zot(n) && (n = 10), t.body.ApplyTorque(n), t
            };
            t.follow = function(n, i, r, u, f, e, o, s, h, c, l, a) {
                var v;
                return (v = zob(t.follow, arguments, "damp, dampY, leftOffset, rightOffset, upOffset, downOffset, offsetDamp, offsetDampY, horizontal, vertical, borderLock, borderOriginal")) ? v : (t.physics.follow(t, n, i, r, u, f, e, o, s, h, c, l, a), t)
            };
            t.noFollow = function() {
                return t.physics.follow(null), t
            };
            t.control = function(n, i, r, u, f) {
                var e;
                return (e = zob(t.control, arguments, "type, speed, speedY, horizontal, vertical")) ? e : (t.physics.control(t, n, i, r, u, f), t)
            };
            t.noControl = function() {
                return t.physics.noControl(t), t
            };
            t.sleep = function() {
                return t.body.SetAwake(!1), t
            };
            t.wake = function() {
                return t.body.SetAwake(!0), t
            };
            t.contact = function(n) {
                return WW.zimContactListener || y(), f.add(t.body, n), t
            };
            t.noContact = function() {
                return f.remove(t.body), t
            };
            t.contactEnd = function(n) {
                return WW.zimContactListener || y(), e.add(t.body, n), t
            };
            t.noContactEnd = function() {
                return e.remove(t.body), t
            };
            t.hasOwnProperty("dynamic") || Object.defineProperty(t, "dynamic", {
                get: function() {
                    return t.body.GetType() == 2
                },
                set: function(n) {
                    t.body.SetType(n == !0 ? 2 : 0)
                }
            })
        }
        var u, o, s, f, e;
        if (n.chop = function(t, i, r, u, f, e) {
                var s;
                if (z_d("7.8"), !zot(t)) {
                    zot(i) && (i = 3);
                    zot(r) && (r = 3);
                    zot(u) && (u = !0);
                    zot(f) && (f = 0);
                    zot(e) && (e = 1);
                    s = t.getBounds();
                    zot(s) && zogy("ZIM chop() - obj must have bounds");
                    var h = s.width / i,
                        c = s.height / r,
                        o = f,
                        l = [];
                    return n.loop(r, function(r) {
                        n.loop(i, function(i) {
                            var u = new n.Bitmap(t, h + o * 2, c + o * 2, i * h - o, r * c - o, e);
                            f != 0 ? (u.setBounds(o, o, h, c), u.regX = o, u.regY = o) : u.setBounds(o, o, h, c);
                            l.push(u)
                        })
                    }), u ? new n.Tile(l, i, r, 0, 0, !0).sca(t.scaleX, t.scaleY) : l
                }
            }, n.shuffle = function(n) {
                if (z_d("8"), !zot(n)) {
                    var t = n.length,
                        i, r;
                    if (t == 0) return n;
                    while (--t) i = Math.floor(Math.random() * (t + 1)), r = n[t], n[t] = n[i], n[i] = r;
                    return n
                }
            }, n.pluck = function(n, t) {
                if (z_d("9.26"), zot(n) || !Array.isArray(n) || n.length == 0) return null;
                var i = Math.floor(Math.random() * n.length),
                    r = n[i];
                return t && n.splice(i, 1), r
            }, n.rand = function(n, t, i, r) {
                if (z_d("9"), zot(n) && zot(t)) return Math.random();
                (zot(n) || isNaN(n)) && (n = 0);
                (zot(t) || isNaN(t)) && (t = 0);
                (n % 1 != 0 || t % 1 != 0) && (i = !1);
                zot(i) && (i = !0);
                r && Math.random() > .5 && (n *= -1, t *= -1);
                i && (n > t ? n++ : t > n && t++);
                var u;
                return n == 0 && t == 0 ? 0 : (u = t == 0 ? Math.random() * n : Math.min(n, t) + Math.random() * (Math.max(n, t) - Math.min(n, t)), i ? Math.floor(u) : u)
            }, n.seedRandom = function(n) {
                return z_d("9.01"), ! function(n, t, i, r, u, f, e, o, s) {
                    function w(n) {
                        var o, f = n.length,
                            t = this,
                            i = 0,
                            e = t.i = t.j = 0,
                            u = t.S = [];
                        for (f || (n = [f++]); r > i;) u[i] = i++;
                        for (i = 0; r > i; i++) u[i] = u[e = h & e + n[i % f] + (o = u[i])], u[e] = o;
                        (t.g = function(n) {
                            for (var e, o = 0, u = t.i, f = t.j, i = t.S; n--;) e = i[u = h & u + 1], o = o * r + i[h & (i[u] = i[f = h & f + e]) + (i[f] = e)];
                            return t.i = u, t.j = f, o
                        })(r)
                    }

                    function v(n, t) {
                        var r, i = [],
                            u = typeof n;
                        if (t && "object" == u)
                            for (r in n) try {
                                i.push(v(n[r], t - 1))
                            } catch (f) {
                                + function() {}()
                            }
                        return i.length ? i : "string" == u ? n : n + "\0"
                    }

                    function l(n, t) {
                        for (var u, r = n + "", i = 0; i < r.length;) t[h & i] = h & (u ^= 19 * t[h & i]) + r.charCodeAt(i++);
                        return c(t)
                    }

                    function b(i) {
                        try {
                            return a ? c(a.randomBytes(r)) : (n.crypto.getRandomValues(i = new Uint8Array(r)), c(i))
                        } catch (u) {
                            return [+new Date, n, (i = n.navigator) && i.plugins, n.screen, c(t)]
                        }
                    }

                    function c(n) {
                        return String.fromCharCode.apply(0, n)
                    }
                    var a, k = i.pow(r, u),
                        y = i.pow(2, f),
                        d = 2 * y,
                        h = r - 1,
                        p = i["seed" + s] = function(n, f, e) {
                            var h = [],
                                a, o;
                            return f = 1 == f ? {
                                entropy: !0
                            } : f || {}, a = l(v(f.entropy ? [n, c(t)] : null == n ? b() : n, 3), h), o = new w(h), l(c(o.S), t), (f.pass || e || function(n, t, r) {
                                return r ? (i[s] = n, t) : n
                            })(function() {
                                for (var n = o.g(u), i = k, t = 0; y > n;) n = (n + t) * r, i *= r, t = o.g(1);
                                for (; n >= d;) n /= 2, i /= 2, t >>>= 1;
                                return (n + t) / i
                            }, a, "global" in f ? f.global : this == i)
                        };
                    if (l(i[s](), t), e && e.exports) {
                        e.exports = p;
                        try {
                            a = require("crypto")
                        } catch (g) {}
                    } else o && o.amd && o(function() {
                        return p
                    })
                }(this, [], Math, 256, 6, 52, "object" == typeof module && module, "function" == typeof define && define, "random"), Math.seedrandom(n), n
            }, n.odds = function(n) {
                return z_d("9.1"), (zot(n) || isNaN(n)) && (n = 50), Math.random() <= n / 100
            }, n.rarity = function(t, i, r, u) {
                if (z_d("9.2"), zot(t) || t.constructor != {}.constructor) return [];
                zot(i) && (i = !0);
                zot(r) && (r = !0);
                zot(u) && (u = !1);
                var f = [];
                return n.loop(t, function(t, i) {
                    var e = n.colors.indexOf(t),
                        r;
                    e != -1 && (t = n.colorsHex[e]);
                    Array.isArray(i) ? (t = +t == +t ? new Number(t) : new String(t), t._payload = i[1], t.dynamicPayload = u, Object.defineProperty(t, "payload", {
                        get: function() {
                            return !this.dynamicPayload && this._lastPayload != null ? this._lastPayload : (this._lastPayload = n.Pick.choose(this._payload), this._lastPayload)
                        },
                        set: function(n) {
                            this._lastPayload = null;
                            this._payload = n
                        }
                    }), r = i[0], n.loop(r, function() {
                        f.push(t)
                    })) : (r = i, n.loop(r, function() {
                        +t == +t && (t = +t);
                        f.push(t)
                    }))
                }), i && n.shuffle(f), f
            }, n.repeats = function(t, i) {
                if (z_d("9.25"), zot(t) || !Array.isArray(t)) return 0;
                var r = {},
                    u = 0,
                    f = 0;
                return n.loop(t, function(n) {
                    r[n] != null ? (r[n]++, f++) : r[n] = 0;
                    r[n] > u && (u = r[n])
                }), i ? f : u
            }, n.series = function() {
                var u, e;
                if (z_d("13.61"), arguments.length == 0) return function() {};
                arguments.length == 1 && Array.isArray(arguments[0]) ? u = arguments[0] : arguments.length == 1 && arguments[0].constructor == {}.constructor ? (e = arguments[0], zot(e.min) && (e.min = 0), zot(e.max) && (e.max = 1), zot(e.step) && (e.step = 1), u = [], n.loop(Math.floor(Math.abs(e.max - e.min) + e.step), function(n) {
                    u.push(n + e.min)
                }, null, e.step), e = null) : u = Array.prototype.slice.call(arguments);
                var t = 0,
                    r = 1,
                    f = 1,
                    s = 0,
                    o = 0,
                    a = !1,
                    v = !1,
                    y = !1,
                    p = !1,
                    h = !1,
                    w, c, i = function(i, e) {
                        if (s && o % s != 0) return o++, c;
                        o++;
                        var l = u.length,
                            b;
                        if ((p || h) && t % l == 0 && n.shuffle(u), b = u[(l * 10 + t) % l], t == 0 && (w = b), h && t % l == 0 && l > 1)
                            while (b == c) n.shuffle(u), b = u[(l * 10 + t) % l];
                        return (a ? r > 0 && t + r * f >= l ? (r = -1, t = l - 1 - (t + f - (l - 1))) : r < 0 && t + r * f < 0 ? (r = 1, t = f - t) : t += r * f : v ? r > 0 && t + r * f >= l ? (r = -1, t = l - 1 - (t + f - (l - 1)) + f) : r < 0 && t + r * f < 0 ? (r = 1, t = f - t - f) : t += r * f : y ? r > 0 && t + r * f >= l ? t = l - 1 : r < 0 && t + r * f < 0 ? t = 0 : t += r * f : t += r * f, c = b, n.isPick(b)) ? b.noPick && e ? b : n.Pick.choose(b) : b
                    },
                    l = i.original = n.copy(u);
                return i.array = u, i.type = "series", Object.defineProperty(i, "index", {
                    get: function() {
                        var n = u.length;
                        return (n * 10 + t) % n
                    },
                    set: function(n) {
                        t = n
                    }
                }), Object.defineProperty(i, "length", {
                    get: function() {
                        return u.length
                    },
                    set: function() {}
                }), i.jump = function(n) {
                    return t = n, i
                }, i.reverse = function(n) {
                    return zot(n) && (n = !0), r = n ? -1 : 1, t = u.length - 1, i
                }, i.bounce = function(n) {
                    zot(n) && (n = !0);
                    var r = u.length;
                    return t = (r * 10 + t) % r, a = n, i
                }, i.flip = function(n) {
                    zot(n) && (n = !0);
                    var r = u.length;
                    return t = (r * 10 + t) % r, v = n, i
                }, i.step = function(n) {
                    return zot(n) && (n = 1), f = Math.floor(n), i
                }, i.every = function(n) {
                    return zot(n) && (n = 1), s = Math.abs(n), o = 0, i
                }, i.constrain = function(n) {
                    return zot(n) && (n = !0), y = n, i
                }, i.random = function(n) {
                    return zot(n) && (n = !0), n || (u = l), p = n == !0, i
                }, i.mix = function(n) {
                    return zot(n) && (n = !0), n || (u = l), h = n == !0, i
                }, i.shuffle = function(t) {
                    return zot(t) && (t = !0), t ? n.shuffle(u) : u = l, i
                }, i
            }, n.makeSeries = function(n) {
                if (z_d("13.6"), zot(n)) return function() {};
                var i = 0,
                    t = function() {
                        return n[i++ % n.length]
                    };
                return t.array = n, t
            }, n.loop = function(t, i, r, u, f, e) {
                function y(n) {
                    return (zot(f) && (f = r ? n : 0), zot(e) && (e = r ? 0 : n), r && e > f || !r && f > e) ? 0 : (f < 0 && e) < 0 || f > n && e > n ? 0 : (f = Math.max(0, Math.min(f, n)), e = Math.max(0, Math.min(e, n)), Math.floor((r ? f - e : e - f) / u) + 1)
                }
                var v, s, a, h, o, c, l;
                if (v = zob(n.loop, arguments, "obj, call, reverse, step, start, end")) return v;
                if ((z_d("9.5"), zot(t) || zot(i)) || (zot(r) && (r = !1), (zot(u) || u <= 0) && (u = 1), t.constructor === Number && (t = Number(t)), t.constructor === String && (t = String(t)), s = typeof t == "number" ? "number" : t.constructor === Array ? "array" : t.constructor === {}.constructor ? "object" : typeof t == "string" ? "string" : t instanceof NodeList ? "nodelist" : t instanceof HTMLCollection ? "htmlcollection" : "invalid", s == "invalid")) return undefined;
                if (s == "number" || s == "string" || s == "array" || s == "nodelist" || s == "htmlcollection") {
                    if (a = s == "number" ? t : t.length, h = y(a - 1), h == 0) return !0;
                    if (r) {
                        for (o = f; o >= e; o -= u)
                            if (c = s == "number" ? i(o, h, f, e, t) : s == "array" || s == "string" ? i(t[o], o, h, f, e, t) : i(t.item(o), o, h, f, e, t), typeof c != "undefined") return c
                    } else
                        for (o = f; o <= e; o += u)
                            if (c = s == "number" ? i(o, h, f, e, t) : s == "array" || s == "string" ? i(t[o], o, h, f, e, t) : i(t.item(o), o, h, f, e, t), typeof c != "undefined") return c;
                    return !0
                }
                if (s == "object") {
                    a = 0;
                    l = [];
                    for (o in t) a++, l.push(o);
                    if (h = y(a - 1), h == 0) return;
                    if (r) {
                        for (o = f; o >= e; o -= u)
                            if (c = i(l[o], t[l[o]], o, h, f, e, t), typeof c != "undefined") return c
                    } else
                        for (o = f; o <= e; o += u)
                            if (c = i(l[o], t[l[o]], o, h, f, e, t), typeof c != "undefined") return c;
                    return !0
                }
            }, n.timeout = function(i, r, u, f) {
                function h() {
                    var n = Date.now();
                    if (e.time += (n - o) / (s == "s" ? 1e3 : 1), o = n, e.time >= i) {
                        e.done = !0;
                        r(e);
                        e.clear();
                        return
                    }
                    e.rid = requestAnimationFrame(h)
                }
                var c, s, e, o;
                return (c = zob(n.timeout, arguments, "time, call, pauseOnBlur, timeUnit", this)) ? c : (z_d("9.7"), zot(r)) ? void 0 : typeof r != "function" ? void 0 : (s = t(i, f), zot(i) && (i = s == "s" ? 1 : 1e3), i = n.Pick.choose(i), e = {
                    startTime: Date.now(),
                    time: 0,
                    paused: !1,
                    done: !1,
                    timeUnit: f
                }, u && (zot(n.blurCheck) && n.setBlurDetect(), n.pauseOnBlur.push(e)), o = e.startTime, e.pause = function(n, t, i) {
                    zot(n) && (n = !0);
                    n ? cancelAnimationFrame(e.rid) : (t ? o = 0 : i ? (o = Date.now(), e.time = 0) : o = Date.now(), h());
                    e.paused = n
                }, e.clear = function() {
                    e && cancelAnimationFrame(e.rid);
                    for (var n in e) delete e[n];
                    e.pause = function() {};
                    e.clear = function() {}
                }, h(), e)
            }, n.interval = function(i, r, u, f, e, o) {
                function c() {
                    s.startTime = Date.now();
                    s.interval = n.Pick.choose(s.time);
                    s.id = setTimeout(function() {
                        s.paused || s.active && (s.count++, r(s), c(), l())
                    }, s.interval * (h == "s" ? 1e3 : 1))
                }

                function l() {
                    u != -1 && s.count >= (f ? s.total - 1 : s.total) && s.clear()
                }
                var v, h, s, a;
                return (v = zob(n.interval, arguments, "time, call, total, immediate, pauseOnBlur, timeUnit", this)) ? v : (z_d("9.8"), zot(r)) ? void 0 : typeof r != "function" ? void 0 : (h = t(i, o), zot(i) && (i = h == "s" ? 1 : 1e3), zot(f) && (f = !1), !zot(u) && (isNaN(u) || u <= 0)) ? void 0 : (zot(u) && (u = -1), s = {
                    count: 0,
                    total: u,
                    paused: !1,
                    time: i,
                    active: !0,
                    timeUnit: o
                }, e && (zot(n.blurCheck) && n.setBlurDetect(), n.pauseOnBlur.push(s)), f && setTimeout(function() {
                    r(s);
                    l()
                }, 10), s.pause = function(n, t, i) {
                    zot(n) && (n = !0);
                    n ? (clearTimeout(a), clearTimeout(s.id), cancelAnimationFrame(s.rid), s.pauseTimeLeft = s.interval - (Date.now() - s.startTime) / (h == "s" ? 1e3 : 1)) : (s.paused || s.pause(!0), a = setTimeout(function() {
                        s.count++;
                        r(s);
                        c();
                        l()
                    }, t ? 0 : (i ? s.interval : s.pauseTimeLeft) * (h == "s" ? 1e3 : 1)), s.pauseTimeLeft = null);
                    s.paused = n
                }, s.clear = function() {
                    var n, t;
                    s.active = !1;
                    clearTimeout(a);
                    cancelAnimationFrame(s.rid);
                    clearTimeout(s.id);
                    n = s.count;
                    for (t in s) delete s[t];
                    s.active = !1;
                    s.count = n;
                    s.pause = function() {};
                    s.clear = function() {}
                }, c(), s)
            }, n.async = function(i, r, u, f, e) {
                var s, h, o;
                (z_d("29"), zot(i)) || (s = document.createElement("script"), h = t(f), zot(f) && (f = h == "s" ? 2 : 2e3), r ? (o = u ? u : r.toString().split(/\n/, 1)[0].match(/^function\s?([^\s(]*)/)[1], n.asyncList || (n.asyncList = {}), n.asyncList[o] || (n.asyncList[o] = []), n.asyncList[o].push(r), n.async[o] = function() {
                    var t = s,
                        i = !1,
                        u = setTimeout(function() {
                            i = e;
                            typeof r == "function" && r("asyncError", e ? "cancelled" : "timeout")
                        }, f * (h == "s" ? 1e3 : 1));
                    return function(f) {
                        clearTimeout(u);
                        n.asyncList[o] && (r = n.asyncList[o].shift());
                        typeof r != "function" || i || r(f);
                        t && t.parentNode.removeChild(t);
                        t = null
                    }
                }()) : (n.async.z_s && n.async.z_s.parentNode && n.async.z_s.parentNode.removeChild(n.async.z_s), n.async.z_s = s), i.match(/\?/) || (i += "?"), s.setAttribute("src", i + "&r=" + Math.random()), document.getElementsByTagName("head")[0].appendChild(s))
            }, n.couple = function(t) {
                var i, r, u, f, e;
                if (z_d("29.2"), !n.isJSON(t)) return t;
                i = JSON.parse(t);
                r = {};
                for (u in i) {
                    f = i[u];
                    for (e in f) r[u + "_" + e] = f[e]
                }
                return JSON.stringify(r)
            }, n.decouple = function(t) {
                var u, r, f, i;
                if (z_d("29.3"), !n.isJSON(t)) return t;
                u = JSON.parse(t);
                r = {};
                for (f in u) {
                    if (i = f.split("_", 2), i.length != 2) return t;
                    r[i[0]] || (r[i[0]] = {});
                    r[i[0]][i[1]] = u[f]
                }
                return JSON.stringify(r)
            }, n.convertColor = function(t, i, r) {
                function c(n) {
                    var t = Number(n).toString(16);
                    return t.length < 2 && (t = "0" + t), t
                }

                function w(n, t, i) {
                    n /= 255;
                    t /= 255;
                    i /= 255;
                    const u = Math.max(n, t, i),
                        r = u - Math.min(n, t, i),
                        f = r ? u === n ? (t - i) / r : u === t ? 2 + (i - n) / r : 4 + (n - t) / r : 0;
                    return [60 * f < 0 ? 60 * f + 360 : 60 * f, 100 * (r ? u <= .5 ? r / (2 * u - r) : r / (2 - (2 * u - r)) : 0), 50 * (2 * u - r)]
                }

                function v(n) {
                    var t = n.split(","),
                        r = c(t[0]),
                        u = c(t[1]),
                        f = c(t[2]),
                        i = zot(i) ? "" : c(Math.round(Number(t[3]) * 255));
                    return [r, u, f, i]
                }

                function b(n) {
                    var t;
                    return /^#([A-Fa-f0-9]{3}){1,2}$/.test(n) ? (t = n.substring(1).split(""), t.length == 3 && (t = [t[0], t[0], t[1], t[1], t[2], t[2]]), t = "0x" + t.join(""), i == "rgb" ? "rgb(" + [t >> 16 & 255, t >> 8 & 255, t & 255] + ")" : i == "array" ? [t >> 16 & 255, t >> 8 & 255, t & 255, r] : "rgba(" + [t >> 16 & 255, t >> 8 & 255, t & 255].join(",") + "," + r + ")") : /^#([A-Fa-f0-9]{4}){1,2}$/.test(n) ? (t = n.substring(1).split(""), t.length == 8 && (r = t.slice(-2).join(""), t = t.slice(0, 6)), t.length == 4 && (r = t[3] + "" + t[3], t = [t[0], t[0], t[1], t[1], t[2], t[2]]), r = parseInt(r, 16) / 255, t = "0x" + t.join(""), i == "rgb" ? "rgb(" + [t >> 16 & 255, t >> 8 & 255, t & 255] + ")" : "rgba(" + [t >> 16 & 255, t >> 8 & 255, t & 255].join(",") + "," + r + ")") : i == "rgb" ? "rgb(0,0,0)" : "rgba(0,0,0,1)"
                }
                var h, a, p, o, u, y, f, s, l, e;
                if (n.convertColorCheck || (z_d("27.5"), n.convertColorCheck = !0), zot(i) && (i = "hex"), !zot(t) && t.toLowerCase) {
                    if (t = zik(t), t = t.toLowerCase(), i = i.toLowerCase(), h = ["black", "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgrey", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkslategrey", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dimgrey", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "grey", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgray", "lightgrey", "lightgreen", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightslategrey", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "rebeccapurple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "slategrey", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen"], a = ["000000", "f0f8ff", "faebd7", "00ffff", "7fffd4", "f0ffff", "f5f5dc", "ffe4c4", "ffebcd", "0000ff", "8a2be2", "a52a2a", "deb887", "5f9ea0", "7fff00", "d2691e", "ff7f50", "6495ed", "fff8dc", "dc143c", "00ffff", "00008b", "008b8b", "b8860b", "a9a9a9", "a9a9a9", "006400", "bdb76b", "8b008b", "556b2f", "ff8c00", "9932cc", "8b0000", "e9967a", "8fbc8f", "483d8b", "2f4f4f", "2f4f4f", "00ced1", "9400d3", "ff1493", "00bfff", "696969", "696969", "1e90ff", "b22222", "fffaf0", "228b22", "ff00ff", "dcdcdc", "f8f8ff", "ffd700", "daa520", "808080", "808080", "008000", "adff2f", "f0fff0", "ff69b4", "cd5c5c", "4b0082", "fffff0", "f0e68c", "e6e6fa", "fff0f5", "7cfc00", "fffacd", "add8e6", "f08080", "e0ffff", "fafad2", "d3d3d3", "d3d3d3", "90ee90", "ffb6c1", "ffa07a", "20b2aa", "87cefa", "778899", "778899", "b0c4de", "ffffe0", "00ff00", "32cd32", "faf0e6", "ff00ff", "800000", "66cdaa", "0000cd", "ba55d3", "9370db", "3cb371", "7b68ee", "00fa9a", "48d1cc", "c71585", "191970", "f5fffa", "ffe4e1", "ffe4b5", "ffdead", "000080", "fdf5e6", "808000", "6b8e23", "ffa500", "ff4500", "da70d6", "eee8aa", "98fb98", "afeeee", "db7093", "ffefd5", "ffdab9", "cd853f", "ffc0cb", "dda0dd", "b0e0e6", "800080", "663399", "ff0000", "bc8f8f", "4169e1", "8b4513", "fa8072", "f4a460", "2e8b57", "fff5ee", "a0522d", "c0c0c0", "87ceeb", "6a5acd", "708090", "708090", "fffafa", "00ff7f", "4682b4", "d2b48c", "008080", "d8bfd8", "ff6347", "40e0d0", "ee82ee", "f5deb3", "ffffff", "f5f5f5", "ffff00", "9acd32"], i == "zim") return (p = n.colorsHex.indexOf(t), p < 0) ? t : n.colors[n.colorsHex.indexOf(t)];
                    if (i == "hsv" && i == "hsl", o = t.match(/rgba\((.*)\)/)) {
                        if (u = o[1].split(","), y = u.pop(), zot(r) && (r = y), i == "array") return u.push(y), u;
                        if (t = "rgb(" + u.join(",") + ")", i == "rgb") return t;
                        if (i == "hsl") return w(u[0], u[1], u[2])
                    }
                    if (zot(r) && (r = 1), o = t.match(/rgb\((.*)\)/)) return i == "rgba" ? "rgba(" + o[1] + "," + r + ")" : i == "hex" ? (f = r != 1 ? "," + r : "", s = v(o[1] + f), "#" + s[0] + s[1] + s[2] + s[3]) : i == "hexnumber" ? (f = r != 1 ? "," + r : 0, s = v(o[1] + f), parseInt(s[0] + "" + s[1] + "" + s[2], 16)) : i == "string" ? (t = v(o[1]).join("").toLowerCase(), l = a.indexOf(t), l == -1 ? "#" + t : h[l]) : i == "array" ? (f = r != 1 ? "," + r : 0, v(o[1] + f)) : i == "hsl" ? (u = o[1].split(","), w(u[0], u[1], u[2])) : t;
                    if (i == "hsl") return n.convertColor(n.convertColor(t, "rgb"), "hsl");
                    if (i == "array" || i == "rgb" || i == "rgba") return t.charAt(0) == "#" ? b(t) : b(n.convertColor(t));
                    if (i == "hex") {
                        if (t.charAt(0) == "#") return r != 1 ? (f = c(Math.round(r * 255)), t.length == 4 || t.length == 5 ? (e = t.split(""), e[1] = e[1] + "" + e[1], e[2] = e[2] + "" + e[2], e[3] = e[3] + "" + e[3], e[4] = f, e.join("")) : t.length == 9 ? t.substring(0, h.length - 2) + f : t + f) : t
                    } else if (i == "hexnumber") {
                        if (t.charAt(0) == "#") return parseInt(t.replace(/^#/, ""), 16)
                    } else t.charAt(0) == "#" && (t = t.replace("#", ""), t.length == 3 && (t = t.charAt(0) + t.charAt(0) + t.charAt(1) + t.charAt(1) + t.charAt(2) + t.charAt(2)));
                    return i == "string" ? (l = a.indexOf(t), l == -1 ? "#" + t : h[l]) : i == "hexnumber" ? parseInt(a[h.indexOf(t.toLowerCase()) != -1 ? h.indexOf(t) : 0], 16) : (f = r != 1 ? c(Math.round(r * 255)) : "", "#" + a[h.indexOf(t.toLowerCase()) != -1 ? h.indexOf(t) : 0] + f)
                }
            }, n.colorRange = function(t, i, r) {
                var e, o, h, s, f, u;
                for (n.colorRangeCheck || (z_d("27.6"), n.colorRangeCheck = !0), zot(r) && (r = .5), r = Math.max(0, Math.min(1, r)), zot(t) && (t = "white"), zot(i) && (i = "black"), e = n.convertColor(t, "rgb"), o = n.convertColor(i, "rgb"), t = e.substring(4, e.length - 1).split(","), i = o.substring(4, o.length - 1).split(","), s = "#", u = 0; u < t.length; u++) h = i[u] - t[u], f = Math.floor(parseInt(t[u], 10) + h * r).toString(16), f.length < 2 && (f = "0" + f), s += f;
                return s
            }, n.lighten = function(t, i) {
                return n.lightenCheck || (z_d("27.65"), n.lightenCheck = !0), zot(i) && (i = .5), i >= 0 ? n.colorRange(String(t), "#FFFFFF", i) : n.colorRange(String(t), "#000000", -i)
            }, n.darken = function(t, i) {
                return zot(i) && (i = .5), n.darkenCheck || (z_d("27.66"), n.darkenCheck = !0), i >= 0 ? n.colorRange(String(t), "#000000", i) : n.colorRange(String(t), "#ffffff", -i)
            }, n.toColor = function(t, i, r) {
                return n.toColorCheck || (z_d("27.67"), n.toColorCheck = !0), zot(r) && (r = .5), n.colorRange(String(t), i, r)
            }, n.toAlpha = function(t, i) {
                return n.toAlphaCheck || (z_d("27.68"), n.toAlphaCheck = !0), zot(i) && (i = .5), n.convertColor(String(t), "rgba", i)
            }, n.zimEase = function(t, i, r, u, f) {
                var et, g, p, w, k, nt, lt, s, h, l, a, v, o, y, e, c, d, b, tt;
                if (z_d("27.69"), et = !1, zot(f) && (f = !0), t) {
                    if (Array.isArray(t[1])) {
                        et = !0;
                        tt = t[1];
                        t = t[0];
                        var it = 0,
                            rt = tt[0],
                            ut = tt[1],
                            ot = tt[2],
                            at = tt[3],
                            ft = 5 * (rt - it),
                            st = 10 * (ut - it) - 4 * ft,
                            ht = 10 * (ot - it) + 30 * (rt - ut),
                            ct = 5 * (at + it) - 20 * (ot + rt) + 30 * ut,
                            vt = 1 - it - ct - ht - st - ft
                    }
                    g = 0;
                    p = t[0];
                    w = t[1];
                    k = t[2];
                    nt = t[3];
                    lt = 1;
                    s = 5 * (p - g);
                    h = 10 * (w - g) - 4 * s;
                    l = 10 * (k - g) + 30 * (p - w);
                    a = 5 * (nt + g) - 20 * (k + p) + 30 * w;
                    v = lt - g - a - l - h - s
                } else i ? (v = i[0], a = i[1], l = i[2], h = i[3], s = i[4], p = s / 5, w = (h + 4 * s) / 10, k = (l + 6 * s + 3 * h) / 10, nt = (a + 4 * s + 3 * h + 2 * l) / 5) : (v = 0, a = 0, l = 0, h = 0, s = 1);
                return r ? (d = function() {
                    return n.zimEase(null, [v, a, l, h, s], !0)
                }, b = {
                    reverse: d,
                    points: [p, w, k, nt],
                    polynomials: [v, a, l, h, s]
                }, b.noPick = function(n) {
                    if (f) {
                        if (n < .025) return 0;
                        if (n > .975) return 1
                    }
                    return n < .5 ? (n *= 2, o = n * 100, y = 100, e = (o /= y) * o, c = e * o, (v * c * e + a * e * e + l * c + h * e + s * o) / 2) : (n = 1 - (n - .5) * 2, o = n * 100, y = 100, e = (o /= y) * o, c = e * o, 1 - (v * c * e + a * e * e + l * c + h * e + s * o) / 2)
                }) : et ? (d = function() {
                    return zon && zogy("zimEase - multi array points cannot be reversed"), n.zimEase(null, [v, a, l, h, s])
                }, b = {
                    reverse: d,
                    points: [
                        [p, w, k, nt],
                        [rt, ut, ot, at]
                    ],
                    polynomials: [
                        [v, a, l, h, s],
                        [vt, ct, ht, st, ft]
                    ]
                }, b.noPick = function(n) {
                    if (f) {
                        if (n < .025) return 0;
                        if (n > .975) return 1
                    }
                    return n < .5 ? (n *= 2, o = n * 100, y = 100, e = (o /= y) * o, c = e * o, (v * c * e + a * e * e + l * c + h * e + s * o) / 2) : (n = (n - .5) * 2, o = n * 100, y = 100, e = (o /= y) * o, c = e * o, .5 + (vt * c * e + ct * e * e + ht * c + st * e + ft * o) / 2)
                }) : (d = function() {
                    return n.zimEase(null, [v, a, l, h, s], null, !0)
                }, b = {
                    reverse: d,
                    points: [p, w, k, nt],
                    polynomials: [v, a, l, h, s]
                }, b.noPick = u ? function(n) {
                    if (f) {
                        if (n < .025) return 0;
                        if (n > .975) return 1
                    }
                    return o = 100 - n * 100, y = 100, e = (o /= y) * o, c = e * o, 1 - (v * c * e + a * e * e + l * c + h * e + s * o)
                } : function(n) {
                    if (f) {
                        if (n < .025) return 0;
                        if (n > .975) return 1
                    }
                    return o = n * 100, y = 100, e = (o /= y) * o, c = e * o, v * c * e + a * e * e + l * c + h * e + s * o
                }), b.noPick.reverse = d, b
            }, n.spline = function(n, t, i, r, u) {
                function g(n, t) {
                    var i;
                    if (!Array.isArray(n[0]))
                        for (f = 0; f < n.length; f++) n[f] = [n[f].x, n[f].y];
                    if (t) {
                        var r = n[n.length - 1],
                            u = n[n.length - 2],
                            e = n[0],
                            o = n[1];
                        n.unshift(r);
                        n.unshift(u);
                        n.push(e);
                        n.push(o)
                    }
                    for (i = [], f = 0; f < n.length; f++) i.push(n[f][0], n[f][1]);
                    return i
                }
                var f, c;
                z_d("27.695");
                zot(n) && (n = []);
                zot(t) && (t = 1);
                zot(i) && (i = !1);
                zot(u) && (u = i);
                n = g(n, i);
                var h = n.length,
                    l = h - 4,
                    a = i ? n[2] : n[0],
                    v = i ? n[3] : n[1],
                    s = "M" + [a, v];
                r && r.mt(a, v);
                var nt = i ? 2 : 0,
                    tt = i ? h - 4 : h - 2;
                for (f = nt; f < tt; f += 2) {
                    var it = f ? n[f - 2] : n[0],
                        rt = f ? n[f - 1] : n[1],
                        y = n[f + 0],
                        p = n[f + 1],
                        e = n[f + 2],
                        o = n[f + 3],
                        ut = f !== l ? n[f + 4] : e,
                        ft = f !== l ? n[f + 5] : o,
                        w = y + (e - it) / 6 * t,
                        b = p + (o - rt) / 6 * t,
                        k = e - (ut - y) / 6 * t,
                        d = o - (ft - p) / 6 * t;
                    s += "C" + [w, b, k, d, e, o];
                    r && r.bt(w, b, k, d, e, o)
                }
                return u && (c = s.split("C"), c.pop(), s = c.join("C")), s
            }, n.pointAlongCurve = function(t, i, r, u) {
                var f, s, h, c, l, a, v, e, o, y;
                if (z_d("27.7"), t && t[0] && t[1] && t[2] && t[3]) return (zot(u) && (u = !1), f = new n.Bezier(t[0], t[1], t[2], t[3]), u ? (s = f.mx(i), h = f.my(i)) : (s = f.x(i), h = f.y(i)), r) ? (e = i - .05, o = i + .05, e < 0 && (e = 0), o > 1 && (o = 1), u ? (c = f.mx(e), l = f.my(e), a = f.mx(o), v = f.my(o)) : (c = f.x(e), l = f.y(e), a = f.x(o), v = f.y(o)), y = n.angle(c, l, a, v), {
                    x: s,
                    y: h,
                    angle: y
                }) : {
                    x: s,
                    y: h
                }
            }, n.distanceAlongCurve = function(t) {
                z_d("27.8");
                var i = n.dist(t[0], t[3]),
                    r = n.dist(t[0], t[1]) + n.dist(t[1], t[2]) + n.dist(t[2], t[3]);
                return (i + r) / 2
            }, n.closestPointAlongCurve = function(t, i, r, u, f) {
                z_d("27.9");
                var o = 1e7,
                    s, e = 0,
                    h = 0;
                return (zot(r) && (r = 10), n.loop(i, function(i, u) {
                    var f = new n.Bezier(i[0], i[1], i[2], i[3]);
                    n.loop(r, function(i, r) {
                        var c = {
                                x: f.x(i / r),
                                y: f.y(i / r)
                            },
                            l = n.dist(t, c);
                        l < o && (o = l, s = c, e = u, h = i)
                    })
                }), f) ? (e * r + h) / (i.length * r) * 100 : u ? s : e
            }, n.transformPoints = function(t, i, r, u, f) {
                var l, a, e, c;
                if (z_d("27.95"), !zot(t) && Array.isArray(t)) {
                    for (zot(u) && (u = 0), zot(f) && (f = 0), t = n.copy(t), l = u, a = f, i == "rotation" && (u != 0 && (t = n.transformPoints(t, "x", -l)), f != 0 && (t = n.transformPoints(t, "y", -a))), c = 0; c < t.length; c++)
                        if (e = t[c], Array.isArray(e))
                            if (i == "x") e[0] += r;
                            else if (i == "y") e[1] += r;
                    else if (i == "scaleX") e[0] = (e[0] - u) * r + u, e[4] = e[4] * r, e[6] = e[6] * r;
                    else if (i == "scaleY") e[1] = (e[1] - f) * r + f, e[5] = e[5] * r, e[7] = e[7] * r;
                    else if (i == "scale") e[0] = (e[0] - u) * r + u, e[4] = e[4] * r, e[6] = e[6] * r, e[1] = (e[1] - f) * r + f, e[5] = e[5] * r, e[7] = e[7] * r;
                    else if (i == "rotation") {
                        var o = r * Math.PI / 180,
                            s = e[0],
                            h = e[1];
                        e[0] = s * Math.cos(o) - h * Math.sin(o);
                        e[1] = h * Math.cos(o) + s * Math.sin(o);
                        s = e[4];
                        h = e[5];
                        e[4] = s * Math.cos(o) - h * Math.sin(o);
                        e[5] = h * Math.cos(o) + s * Math.sin(o);
                        s = e[6];
                        h = e[7];
                        e[6] = s * Math.cos(o) - h * Math.sin(o);
                        e[7] = h * Math.cos(o) + s * Math.sin(o)
                    }
                    return i == "rotation" && (u != 0 && (t = n.transformPoints(t, "x", l)), f != 0 && (t = n.transformPoints(t, "y", a))), t
                }
            }, n.trimPointEnds = function(n) {
                z_d("27.97");
                n[0][4] = 0;
                n[0][5] = 0;
                n[0][8] = "free";
                n[n.length - 1][6] = 0;
                n[n.length - 1][7] = 0;
                n[n.length - 1][8] = "free"
            }, n.reversePoints = function(t) {
                return z_d("27.975"), t.reverse(), n.loop(t, function(n) {
                    var i = n[6],
                        t;
                    n[6] = n[4];
                    n[4] = i;
                    t = n[7];
                    n[7] = n[5];
                    n[5] = t
                }), t
            }, n.appendPoints = function(n, t, i) {
                return (z_d("27.98"), zot(n) && zot(t)) ? [] : zot(n) ? t : zot(t) ? n : (n[n.length - 1][6] = t[0][6], n[n.length - 1][7] = t[0][7], i && (n[n.length - 1][8] = i), t.shift(), n.concat(t))
            }, n.prependPoints = function(n, t, i) {
                return (z_d("27.985"), zot(n) && zot(t)) ? [] : zot(n) ? t : zot(t) ? n : (t[t.length - 1][6] = n[0][6], t[t.length - 1][7] = n[0][7], i && (n[n.length - 1][8] = i), n.shift(), t.concat(n))
            }, n.splitPoints = function(t, i, r) {
                if ((z_d("27.99"), !zot(t)) && (zot(i) && (i = Math.floor(t.length / 2)), !(i < 0) && !(i > t.length - 1))) {
                    zot(r) && (r = !0);
                    var u = n.copy(t.slice(0, i + 1)),
                        f = n.copy(t.slice(i));
                    return r && (n.trimPointEnds(u), n.trimPointEnds(f)), [u, f]
                }
            }, n.makeID = function(n, t, i) {
                var u, f, e, o, r, h, s;
                for (z_d("13.5"), zot(n) && (n = "mixed"), zot(t) && (t = 5), zot(i) && (i = "uppercase"), f = [2, 3, 4, 5, 6, 7, 8, 9], e = "abcdefghjkmnpqrstuvwxyz".split(""), u = n.constructor === Array ? n : n == "numbers" ? f : n == "letters" ? e : f.concat(e), o = "", s = 0; s < t; s++) r = u[Math.floor(Math.random() * u.length)], h = Math.random(), i == "uppercase" || i == "mixed" && h > .5 ? r.toUpperCase && (r = r.toUpperCase()) : r.toLowerCase && (r = r.toLowerCase()), o += String(r);
                return o
            }, n.makeSyllable = function(t, i) {
                function o(t) {
                    var i = n.rand(t.length - 1);
                    return t.substring(i, i + 1)
                }
                var f, r, e, u;
                return z_d("13.55"), f = "bcdfghjklmnprstvwxz", r = "aeiouaeiouaeiouy", zot(t) && (t = 3), zot(i) && (i = n.rand() < .3), e = "", u = i ? r : f, n.loop(t, function() {
                    e += o(u);
                    u = u == r ? f : r
                }), e
            }, n.makePrimitive = function(t) {
                function i(t) {
                    return Array.isArray(t) ? (n.loop(t, function(n) {
                        n = i(n)
                    }), t) : t.constructor === {}.constructor ? (n.loop(t, function(n, r) {
                        t[n] = i(r)
                    }), t) : t instanceof String ? String(t) : t instanceof Number ? Number(t) : t instanceof Boolean ? Boolean(t) : t
                }
                return z_d("13.56"), i(t)
            }, n.makeMath = function() {
                var t, n;
                for (z_d("13.565"), t = Object.getOwnPropertyNames(Math), n = 0; n < t.length; n++) W[t[n]] = Math[t[n]]
            }, n.swapProperties = function(n, t, i) {
                if (z_d("17.1"), zot(t) || zot(i) || zot(t[n]) || zot(i[n])) return !1;
                var r = i[n];
                return i[n] = t[n], t[n] = r, !0
            }, n.mobile = function(t) {
                return (z_d("28"), !zot(WW.MOBILE) && WW.MOBILE != "default") ? WW.MOBILE : !zot(n.MOBILE) && n.MOBILE != "default" ? n.MOBILE : (zot(t) && (t = !0), /ip(hone|od|ad)/i.test(navigator.userAgent)) ? "ios" : /android|nexus/i.test(navigator.userAgent) ? "android" : /blackberry/i.test(navigator.userAgent) ? "blackberry" : /nokia|phone|mobile/i.test(navigator.userAgent) ? "windows" : /opera mini|webos/i.test(navigator.userAgent) ? "other" : t && WW.orientation !== undefined ? /safari/i.test(navigator.userAgent) ? "ios" : !0 : !1
            }, n.vee = function(n) {
                return z_d("28.5"), !zot(n) && (n.type == "Pick" || Array.isArray(n) || n.constructor == {}.constructor && (!zot(n.max) || !zot(n.noPick)) || typeof n == "function")
            }, n.extend = function(t, i, r, u, f) {
                function v() {
                    this.constructor = t
                }
                var a, c, h, s, o, e, l;
                if (a = zob(n.extend, arguments, "subclass, superclass, override, prefix, prototype")) return a;
                if (zot(t) || zot(i)) {
                    zon && t != n.StageGL && zogy("zim.extend() - please supply a class and its superclass");
                    return
                }
                zot(u) && (u = "super");
                zot(r) && (r = []);
                Array.isArray(r) || (r = [r]);
                zot(f) && (f = !0);
                c = {};
                for (h in t.prototype) Object.defineProperty(c, h, Object.getOwnPropertyDescriptor(t.prototype, h));
                v.prototype = i.prototype;
                t.prototype = new v;
                for (h in c) Object.defineProperty(t.prototype, h, Object.getOwnPropertyDescriptor(c, h));
                if (s = t.prototype, o = Object.getPrototypeOf && Object.getPrototypeOf(s) || s.__proto__, o) {
                    for (s[(u += "_") + "constructor"] = o.constructor, l = 0; l < r.length; l++) e = r[l], typeof o[e] == "function" && (s[u + e] = o[e]);
                    if (f)
                        for (e in o) Object.prototype.hasOwnProperty.call(s, e) && typeof o[e] == "function" && (s[u + e] = o[e])
                }
                return t
            }, n.copy = function(t, i, r) {
                var e, u, o, f, s;
                if (n.copyCheck || (z_d("10"), n.copyCheck = !0), zot(i) && (i = !1), zot(r) && (r = !0), t == null || !(t instanceof Array || t.constructor == {}.constructor)) return i && t != null ? t.clone ? t.type && (t.type != "Container" && t.type != "Stage" && t.type != "StageGL" || r) ? t.clone() : t : t : t;
                if (t instanceof Array) {
                    for (e = [], u = 0; u < t.length; u++) e[u] = n.copy(t[u], i, r);
                    return e
                }
                if (t.constructor == {}.constructor) {
                    o = {};
                    for (f in t) s = n.copy(t[f], i, r), Object.prototype.hasOwnProperty.call(t, f) && (o[f] = s);
                    return o
                }
            }, n.merge = function() {
                n.mergeCheck || (z_d("12"), n.mergeCheck = !0);
                for (var r = {}, i, t = 0; t < arguments.length; t++)
                    for (i in arguments[t]) Object.prototype.hasOwnProperty.call(arguments[t], i) && (r[i] = arguments[t][i]);
                return r
            }, n.arraysEqual = function(t, i, r) {
                if ((z_d("11"), zot(t) || zot(i)) || (zot(r) && (r = !0), t.length != i.length)) return !1;
                for (var u = 0; u < t.length; u++)
                    if (t[u] instanceof Array && i[u] instanceof Array) {
                        if (!n.arraysEqual(t[u], i[u], r)) return !1
                    } else {
                        if (r && t[u] != i[u]) return !1;
                        if (!r) return n.arraysEqual(t.sort(), i.sort(), !0)
                    }
                return !0
            }, n.arrayMinMax = function(n) {
                if (z_d("11.2"), !Array.isArray(n)) return {
                    min: null,
                    max: null
                };
                for (var t = n[0], i = n[0], r = n.length; r--;) t = n[r] < t ? n[r] : t, i = n[r] > i ? n[r] : i;
                return t = isNaN(t) ? null : t, i = isNaN(i) ? null : i, {
                    min: t,
                    max: i
                }
            }, n.isEmpty = function(t) {
                var i, r;
                if (n.zimEmptyCheck || (z_d("11.5"), n.zimEmptyCheck = !0), !zot(t)) {
                    i = 0;
                    for (r in t) {
                        i++;
                        break
                    }
                    return i == 0
                }
            }, n.isJSON = function(n) {
                if (z_d("11.6"), typeof n != "string") return !1;
                try {
                    return JSON.parse(n), !0
                } catch (t) {
                    return !1
                }
            }, n.isPick = function(t) {
                if (n.zimPickCheck || (z_d("11.7"), n.zimPickCheck = !0), !zot(t)) return Array.isArray(t) || t.constructor == {}.constructor && (t.min != null && t.max != null || t.noPick) || t.constructor === Function && (t.array != null || t() != null)
            }, n.zut = function(n) {
                if (zot(n) || typeof n == "object") return !0
            }, n.decimals = function(t, i, r, u, f, e, o) {
                var s, v, a, h, l, c, y;
                if (n.zimDecimalCheck || (z_d("13"), n.zimDecimalCheck = !0), zot(t)) return 0;
                if (zot(i) && (i = 1), zot(r) && (r = 0), zot(u) && (u = 1), zot(f) && (f = !0), zot(e) && (e = !1), s = Math.round(t * Math.pow(10, i)) / Math.pow(10, i), e && (v = s - Math.floor(s), s = n.decimals(Math.floor(s) + v * 60 / 100, 2)), a = n.sign(s), r > 0)
                    for (h = String(s).indexOf("."), l = String(s).length, h < 0 && (h = l++, s += "."), c = 0; c < r - (l - h - 1); c++) s += "0";
                if (u > 1) {
                    for (a == -1 && (s = s.substr(1, s.length - 1)), h = String(s).indexOf("."), l = String(s).length, y = h < 0 ? l : h, c = 0; c < u - y; c++) s = "0" + s;
                    a == -1 && (s = "-" + s)
                }
                return u == 0 && (s = s.toString().replace(/^0\./, ".")), r + u > 0 && !f && Number(s) == 0 && (s = 0), e && (s = String(s).replace(".", ":")), n.zut(o) ? s : null
            }, n.countDecimals = function(t) {
                return n.zimCountDecimalsCheck || (z_d("13.05"), n.zimCountDecimalsCheck = !0), t % 1 ? t.toString().split(".")[1].length : 0
            }, n.sign = function(t) {
                return n.zimSignCheck || (z_d("13.1"), n.zimSignCheck = !0), t ? t < 0 ? -1 : 1 : 0
            }, n.constrain = function(n, t, i, r) {
                if (z_d("13.2"), !zot(n)) {
                    if (zot(t) && (t = 0), zot(i) && (i = Number.MAX_VALUE), i < t) {
                        var u = t;
                        i = t;
                        t = u
                    }
                    return zot(r) && (r = !1), r && n < 0 ? Math.max(-i, Math.min(n, -t)) : Math.max(t, Math.min(n, i))
                }
            }, n.dist = function(t, i, r, u) {
                if (n.zimDistCheck || (z_d("13.3"), n.zimDistCheck = !0), !zot(t) && !zot(i)) return zot(t.x) || zot(i.x) ? (zot(r) && (r = 0), zot(u) && (u = 0)) : (u = i.y, r = i.x, i = t.y, t = t.x), Math.sqrt(Math.pow(r - t, 2) + Math.pow(u - i, 2))
            }, n.rectIntersect = function(t, i, r) {
                return n.zimRectIntersectCheck || (z_d("13.32"), n.zimRectIntersectCheck = !0), zot(r) && (r = 0), t.x >= i.x + i.width + r || t.x + t.width + r <= i.x || t.y >= i.y + i.height + r || t.y + t.height + r <= i.y ? !1 : !0
            }, n.boundsAroundPoints = function(t) {
                var f, i;
                n.zimBoundsAroundPointsCheck || (z_d("13.34"), n.zimBoundsAroundPointsCheck = !0);
                var r = 1e4,
                    u = 1e4,
                    e = -1e4,
                    o = -1e4;
                for (f = 0; f < t.length; f++) i = t[f], i.x < r && (r = i.x), i.x > e && (e = i.x), i.y < u && (u = i.y), i.y > o && (o = i.y);
                return {
                    x: r,
                    y: u,
                    width: e - r,
                    height: o - u
                }
            }, n.angle = function(t, i, r, u) {
                if (n.angleCheck || (z_d("13.4"), n.angleCheck = !0), !zot(t) && !zot(i)) return zot(r) && (r = t, t = 0), zot(u) && (u = i, i = 0), (Math.atan2(u - i, r - t) * 180 / Math.PI + 360) % 360
            }, n.TAU = Math.PI * 2, n.DEG = 180 / Math.PI, n.RAD = Math.PI / 180, n.PHI = Math.pow(5, .5) * .5 + .5, n.smoothStep = function(t, i, r) {
                z_d("13.7");
                var u = n.constrain((t - i) / (r - i), 0, 1);
                return u * u * u * (u * (u * 6 - 15) + 10)
            }, n.unicodeToUTF = function(n) {
                if (z_d("13.75"), n) {
                    n != " " && (n = n.replace(/^\s+/g, ""));
                    var i, r = "",
                        t = "";
                    return i = n.charCodeAt(0), r = i, t = n.charCodeAt(1), t >= 56320 && t <= 57343 && (i = (r - 55296) * 1024 + (t - 56320) + 65536), r = r.toString(16), t = t.toString(16), i = i.toString(16), "\\u" + r + "\\u" + t
                }
            }, n.capitalizeFirst = function(n) {
                return z_d("13.78"), n.charAt(0).toUpperCase() + n.slice(1)
            }, n.Ajax = function(t, i, r, u) {
                var f, e;
                z_d("13.8");
                f = new XMLHttpRequest;
                this.master = t;
                this.couple = i;
                this.lock = r;
                this.unique = u;
                e = this;
                this.get = function(i, u) {
                    var o = zot(e.master) ? "" : "&master=" + encodeURI(t),
                        s = zot(e.lock) ? "" : "&lock=" + encodeURI(r),
                        h = e.unique ? "&unique=true" : "";
                    f.open("GET", i + o + s + h, !0);
                    f.onload = function() {
                        f.status == 200 ? u(n.isJSON(f.responseText) ? JSON.parse(f.responseText) : f.responseText) : u(null, "Error: " + f.status)
                    };
                    f.send()
                };
                this.post = function(t, i, r, u, o) {
                    var s;
                    if (s = zob(e.post, arguments, "url, data, command, extra, callback")) return s;
                    if (!zot(t)) {
                        f.open("POST", t, !0);
                        f.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                        f.onload = function() {
                            var t = f.responseText;
                            n.isJSON(t) && (e.couple && (t = n.decouple(t)), t = JSON.parse(t));
                            o(t)
                        };
                        n.isJSON(i) || (i = JSON.stringify(i));
                        e.couple && (i = n.couple(i));
                        var h = zot(e.master) ? "" : "&master=" + encodeURIComponent(e.master),
                            c = zot(e.lock) ? "" : "&lock=" + encodeURIComponent(e.lock),
                            l = zot(r) ? "" : "&command=" + encodeURIComponent(r),
                            a = zot(u) ? "" : "&extra=" + encodeURIComponent(u);
                        f.send("data=" + encodeURIComponent(i) + h + c + l + a)
                    }
                };
                this.put = function(t, i, r) {
                    f.open("PUT", t, !0);
                    f.setRequestHeader("Content-type", "application/json");
                    f.onload = function() {
                        r(n.isJSON(f.responseText) ? JSON.parse(f.responseText) : e.http.responseText)
                    };
                    f.send(JSON.stringify(i))
                }
            }, n.Noise = function(n) {
                function c(n) {
                    var t = new Uint32Array(1);
                    return t[0] = n[0] * 1664525 + 1013904223, t
                }

                function b(n, i, r) {
                    this.dx = -i - n * t.SQUISH_2D;
                    this.dy = -r - n * t.SQUISH_2D;
                    this.xsb = i;
                    this.ysb = r
                }

                function a(n, i, r, u) {
                    this.dx = -i - n * t.SQUISH_3D;
                    this.dy = -r - n * t.SQUISH_3D;
                    this.dz = -u - n * t.SQUISH_3D;
                    this.xsb = i;
                    this.ysb = r;
                    this.zsb = u
                }

                function l(n, i, r, u, f) {
                    this.dx = -i - n * t.SQUISH_4D;
                    this.dy = -r - n * t.SQUISH_4D;
                    this.dz = -u - n * t.SQUISH_4D;
                    this.dw = -f - n * t.SQUISH_4D;
                    this.xsb = i;
                    this.ysb = r;
                    this.zsb = u;
                    this.wsb = f
                }
                var w, e, t, v, i, r, s, f, o, u, y, p, h;
                for (z_d("13.9"), zot(n) && (n = Math.random() * 1e6), w = n, this.seed = n, e = this, t = {}, t.NORM_2D = 1 / 47, t.NORM_3D = 1 / 103, t.NORM_4D = 1 / 30, t.SQUISH_2D = (Math.sqrt(3) - 1) / 2, t.SQUISH_3D = (Math.sqrt(4) - 1) / 3, t.SQUISH_4D = (Math.sqrt(5) - 1) / 4, t.STRETCH_2D = (1 / Math.sqrt(3) - 1) / 2, t.STRETCH_3D = (1 / Math.sqrt(4) - 1) / 3, t.STRETCH_4D = (1 / Math.sqrt(5) - 1) / 4, t.base2D = [
                        [1, 1, 0, 1, 0, 1, 0, 0, 0],
                        [1, 1, 0, 1, 0, 1, 2, 1, 1]
                    ], t.base3D = [
                        [0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1],
                        [2, 1, 1, 0, 2, 1, 0, 1, 2, 0, 1, 1, 3, 1, 1, 1],
                        [1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 2, 1, 1, 0, 2, 1, 0, 1, 2, 0, 1, 1]
                    ], t.base4D = [
                        [0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1],
                        [3, 1, 1, 1, 0, 3, 1, 1, 0, 1, 3, 1, 0, 1, 1, 3, 0, 1, 1, 1, 4, 1, 1, 1, 1],
                        [1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 2, 1, 1, 0, 0, 2, 1, 0, 1, 0, 2, 1, 0, 0, 1, 2, 0, 1, 1, 0, 2, 0, 1, 0, 1, 2, 0, 0, 1, 1],
                        [3, 1, 1, 1, 0, 3, 1, 1, 0, 1, 3, 1, 0, 1, 1, 3, 0, 1, 1, 1, 2, 1, 1, 0, 0, 2, 1, 0, 1, 0, 2, 1, 0, 0, 1, 2, 0, 1, 1, 0, 2, 0, 1, 0, 1, 2, 0, 0, 1, 1]
                    ], t.gradients2D = [5, 2, 2, 5, -5, 2, -2, 5, 5, -2, 2, -5, -5, -2, -2, -5], t.gradients3D = [-11, 4, 4, -4, 11, 4, -4, 4, 11, 11, 4, 4, 4, 11, 4, 4, 4, 11, -11, -4, 4, -4, -11, 4, -4, -4, 11, 11, -4, 4, 4, -11, 4, 4, -4, 11, -11, 4, -4, -4, 11, -4, -4, 4, -11, 11, 4, -4, 4, 11, -4, 4, 4, -11, -11, -4, -4, -4, -11, -4, -4, -4, -11, 11, -4, -4, 4, -11, -4, 4, -4, -11], t.gradients4D = [3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, -3, 1, 1, 1, -1, 3, 1, 1, -1, 1, 3, 1, -1, 1, 1, 3, 3, -1, 1, 1, 1, -3, 1, 1, 1, -1, 3, 1, 1, -1, 1, 3, -3, -1, 1, 1, -1, -3, 1, 1, -1, -1, 3, 1, -1, -1, 1, 3, 3, 1, -1, 1, 1, 3, -1, 1, 1, 1, -3, 1, 1, 1, -1, 3, -3, 1, -1, 1, -1, 3, -1, 1, -1, 1, -3, 1, -1, 1, -1, 3, 3, -1, -1, 1, 1, -3, -1, 1, 1, -1, -3, 1, 1, -1, -1, 3, -3, -1, -1, 1, -1, -3, -1, 1, -1, -1, -3, 1, -1, -1, -1, 3, 3, 1, 1, -1, 1, 3, 1, -1, 1, 1, 3, -1, 1, 1, 1, -3, -3, 1, 1, -1, -1, 3, 1, -1, -1, 1, 3, -1, -1, 1, 1, -3, 3, -1, 1, -1, 1, -3, 1, -1, 1, -1, 3, -1, 1, -1, 1, -3, -3, -1, 1, -1, -1, -3, 1, -1, -1, -1, 3, -1, -1, -1, 1, -3, 3, 1, -1, -1, 1, 3, -1, -1, 1, 1, -3, -1, 1, 1, -1, -3, -3, 1, -1, -1, -1, 3, -1, -1, -1, 1, -3, -1, -1, 1, -1, -3, 3, -1, -1, -1, 1, -3, -1, -1, 1, -1, -3, -1, 1, -1, -1, -3, -3, -1, -1, -1, -1, -3, -1, -1, -1, -1, -3, -1, -1, -1, -1, -3], t.lookupPairs2D = [0, 1, 1, 0, 4, 1, 17, 0, 20, 2, 21, 2, 22, 5, 23, 5, 26, 4, 39, 3, 42, 4, 43, 3], t.lookupPairs3D = [0, 2, 1, 1, 2, 2, 5, 1, 6, 0, 7, 0, 32, 2, 34, 2, 129, 1, 133, 1, 160, 5, 161, 5, 518, 0, 519, 0, 546, 4, 550, 4, 645, 3, 647, 3, 672, 5, 673, 5, 674, 4, 677, 3, 678, 4, 679, 3, 680, 13, 681, 13, 682, 12, 685, 14, 686, 12, 687, 14, 712, 20, 714, 18, 809, 21, 813, 23, 840, 20, 841, 21, 1198, 19, 1199, 22, 1226, 18, 1230, 19, 1325, 23, 1327, 22, 1352, 15, 1353, 17, 1354, 15, 1357, 17, 1358, 16, 1359, 16, 1360, 11, 1361, 10, 1362, 11, 1365, 10, 1366, 9, 1367, 9, 1392, 11, 1394, 11, 1489, 10, 1493, 10, 1520, 8, 1521, 8, 1878, 9, 1879, 9, 1906, 7, 1910, 7, 2005, 6, 2007, 6, 2032, 8, 2033, 8, 2034, 7, 2037, 6, 2038, 7, 2039, 6], t.lookupPairs4D = [0, 3, 1, 2, 2, 3, 5, 2, 6, 1, 7, 1, 8, 3, 9, 2, 10, 3, 13, 2, 16, 3, 18, 3, 22, 1, 23, 1, 24, 3, 26, 3, 33, 2, 37, 2, 38, 1, 39, 1, 41, 2, 45, 2, 54, 1, 55, 1, 56, 0, 57, 0, 58, 0, 59, 0, 60, 0, 61, 0, 62, 0, 63, 0, 256, 3, 258, 3, 264, 3, 266, 3, 272, 3, 274, 3, 280, 3, 282, 3, 2049, 2, 2053, 2, 2057, 2, 2061, 2, 2081, 2, 2085, 2, 2089, 2, 2093, 2, 2304, 9, 2305, 9, 2312, 9, 2313, 9, 16390, 1, 16391, 1, 16406, 1, 16407, 1, 16422, 1, 16423, 1, 16438, 1, 16439, 1, 16642, 8, 16646, 8, 16658, 8, 16662, 8, 18437, 6, 18439, 6, 18469, 6, 18471, 6, 18688, 9, 18689, 9, 18690, 8, 18693, 6, 18694, 8, 18695, 6, 18696, 9, 18697, 9, 18706, 8, 18710, 8, 18725, 6, 18727, 6, 131128, 0, 131129, 0, 131130, 0, 131131, 0, 131132, 0, 131133, 0, 131134, 0, 131135, 0, 131352, 7, 131354, 7, 131384, 7, 131386, 7, 133161, 5, 133165, 5, 133177, 5, 133181, 5, 133376, 9, 133377, 9, 133384, 9, 133385, 9, 133400, 7, 133402, 7, 133417, 5, 133421, 5, 133432, 7, 133433, 5, 133434, 7, 133437, 5, 147510, 4, 147511, 4, 147518, 4, 147519, 4, 147714, 8, 147718, 8, 147730, 8, 147734, 8, 147736, 7, 147738, 7, 147766, 4, 147767, 4, 147768, 7, 147770, 7, 147774, 4, 147775, 4, 149509, 6, 149511, 6, 149541, 6, 149543, 6, 149545, 5, 149549, 5, 149558, 4, 149559, 4, 149561, 5, 149565, 5, 149566, 4, 149567, 4, 149760, 9, 149761, 9, 149762, 8, 149765, 6, 149766, 8, 149767, 6, 149768, 9, 149769, 9, 149778, 8, 149782, 8, 149784, 7, 149786, 7, 149797, 6, 149799, 6, 149801, 5, 149805, 5, 149814, 4, 149815, 4, 149816, 7, 149817, 5, 149818, 7, 149821, 5, 149822, 4, 149823, 4, 149824, 37, 149825, 37, 149826, 36, 149829, 34, 149830, 36, 149831, 34, 149832, 37, 149833, 37, 149842, 36, 149846, 36, 149848, 35, 149850, 35, 149861, 34, 149863, 34, 149865, 33, 149869, 33, 149878, 32, 149879, 32, 149880, 35, 149881, 33, 149882, 35, 149885, 33, 149886, 32, 149887, 32, 150080, 49, 150082, 48, 150088, 49, 150098, 48, 150104, 47, 150106, 47, 151873, 46, 151877, 45, 151881, 46, 151909, 45, 151913, 44, 151917, 44, 152128, 49, 152129, 46, 152136, 49, 152137, 46, 166214, 43, 166215, 42, 166230, 43, 166247, 42, 166262, 41, 166263, 41, 166466, 48, 166470, 43, 166482, 48, 166486, 43, 168261, 45, 168263, 42, 168293, 45, 168295, 42, 168512, 31, 168513, 28, 168514, 31, 168517, 28, 168518, 25, 168519, 25, 280952, 40, 280953, 39, 280954, 40, 280957, 39, 280958, 38, 280959, 38, 281176, 47, 281178, 47, 281208, 40, 281210, 40, 282985, 44, 282989, 44, 283001, 39, 283005, 39, 283208, 30, 283209, 27, 283224, 30, 283241, 27, 283256, 22, 283257, 22, 297334, 41, 297335, 41, 297342, 38, 297343, 38, 297554, 29, 297558, 24, 297562, 29, 297590, 24, 297594, 21, 297598, 21, 299365, 26, 299367, 23, 299373, 26, 299383, 23, 299389, 20, 299391, 20, 299584, 31, 299585, 28, 299586, 31, 299589, 28, 299590, 25, 299591, 25, 299592, 30, 299593, 27, 299602, 29, 299606, 24, 299608, 30, 299610, 29, 299621, 26, 299623, 23, 299625, 27, 299629, 26, 299638, 24, 299639, 23, 299640, 22, 299641, 22, 299642, 21, 299645, 20, 299646, 21, 299647, 20, 299648, 61, 299649, 60, 299650, 61, 299653, 60, 299654, 59, 299655, 59, 299656, 58, 299657, 57, 299666, 55, 299670, 54, 299672, 58, 299674, 55, 299685, 52, 299687, 51, 299689, 57, 299693, 52, 299702, 54, 299703, 51, 299704, 56, 299705, 56, 299706, 53, 299709, 50, 299710, 53, 299711, 50, 299904, 61, 299906, 61, 299912, 58, 299922, 55, 299928, 58, 299930, 55, 301697, 60, 301701, 60, 301705, 57, 301733, 52, 301737, 57, 301741, 52, 301952, 79, 301953, 79, 301960, 76, 301961, 76, 316038, 59, 316039, 59, 316054, 54, 316071, 51, 316086, 54, 316087, 51, 316290, 78, 316294, 78, 316306, 73, 316310, 73, 318085, 77, 318087, 77, 318117, 70, 318119, 70, 318336, 79, 318337, 79, 318338, 78, 318341, 77, 318342, 78, 318343, 77, 430776, 56, 430777, 56, 430778, 53, 430781, 50, 430782, 53, 430783, 50, 431e3, 75, 431002, 72, 431032, 75, 431034, 72, 432809, 74, 432813, 69, 432825, 74, 432829, 69, 433032, 76, 433033, 76, 433048, 75, 433065, 74, 433080, 75, 433081, 74, 447158, 71, 447159, 68, 447166, 71, 447167, 68, 447378, 73, 447382, 73, 447386, 72, 447414, 71, 447418, 72, 447422, 71, 449189, 70, 449191, 70, 449197, 69, 449207, 68, 449213, 69, 449215, 68, 449408, 67, 449409, 67, 449410, 66, 449413, 64, 449414, 66, 449415, 64, 449416, 67, 449417, 67, 449426, 66, 449430, 66, 449432, 65, 449434, 65, 449445, 64, 449447, 64, 449449, 63, 449453, 63, 449462, 62, 449463, 62, 449464, 65, 449465, 63, 449466, 65, 449469, 63, 449470, 62, 449471, 62, 449472, 19, 449473, 19, 449474, 18, 449477, 16, 449478, 18, 449479, 16, 449480, 19, 449481, 19, 449490, 18, 449494, 18, 449496, 17, 449498, 17, 449509, 16, 449511, 16, 449513, 15, 449517, 15, 449526, 14, 449527, 14, 449528, 17, 449529, 15, 449530, 17, 449533, 15, 449534, 14, 449535, 14, 449728, 19, 449729, 19, 449730, 18, 449734, 18, 449736, 19, 449737, 19, 449746, 18, 449750, 18, 449752, 17, 449754, 17, 449784, 17, 449786, 17, 451520, 19, 451521, 19, 451525, 16, 451527, 16, 451528, 19, 451529, 19, 451557, 16, 451559, 16, 451561, 15, 451565, 15, 451577, 15, 451581, 15, 451776, 19, 451777, 19, 451784, 19, 451785, 19, 465858, 18, 465861, 16, 465862, 18, 465863, 16, 465874, 18, 465878, 18, 465893, 16, 465895, 16, 465910, 14, 465911, 14, 465918, 14, 465919, 14, 466114, 18, 466118, 18, 466130, 18, 466134, 18, 467909, 16, 467911, 16, 467941, 16, 467943, 16, 468160, 13, 468161, 13, 468162, 13, 468163, 13, 468164, 13, 468165, 13, 468166, 13, 468167, 13, 580568, 17, 580570, 17, 580585, 15, 580589, 15, 580598, 14, 580599, 14, 580600, 17, 580601, 15, 580602, 17, 580605, 15, 580606, 14, 580607, 14, 580824, 17, 580826, 17, 580856, 17, 580858, 17, 582633, 15, 582637, 15, 582649, 15, 582653, 15, 582856, 12, 582857, 12, 582872, 12, 582873, 12, 582888, 12, 582889, 12, 582904, 12, 582905, 12, 596982, 14, 596983, 14, 596990, 14, 596991, 14, 597202, 11, 597206, 11, 597210, 11, 597214, 11, 597234, 11, 597238, 11, 597242, 11, 597246, 11, 599013, 10, 599015, 10, 599021, 10, 599023, 10, 599029, 10, 599031, 10, 599037, 10, 599039, 10, 599232, 13, 599233, 13, 599234, 13, 599235, 13, 599236, 13, 599237, 13, 599238, 13, 599239, 13, 599240, 12, 599241, 12, 599250, 11, 599254, 11, 599256, 12, 599257, 12, 599258, 11, 599262, 11, 599269, 10, 599271, 10, 599272, 12, 599273, 12, 599277, 10, 599279, 10, 599282, 11, 599285, 10, 599286, 11, 599287, 10, 599288, 12, 599289, 12, 599290, 11, 599293, 10, 599294, 11, 599295, 10], t.p2D = [0, 0, 1, -1, 0, 0, -1, 1, 0, 2, 1, 1, 1, 2, 2, 0, 1, 2, 0, 2, 1, 0, 0, 0], t.p3D = [0, 0, 1, -1, 0, 0, 1, 0, -1, 0, 0, -1, 1, 0, 0, 0, 1, -1, 0, 0, -1, 0, 1, 0, 0, -1, 1, 0, 2, 1, 1, 0, 1, 1, 1, -1, 0, 2, 1, 0, 1, 1, 1, -1, 1, 0, 2, 0, 1, 1, 1, -1, 1, 1, 1, 3, 2, 1, 0, 3, 1, 2, 0, 1, 3, 2, 0, 1, 3, 1, 0, 2, 1, 3, 0, 2, 1, 3, 0, 1, 2, 1, 1, 1, 0, 0, 2, 2, 0, 0, 1, 1, 0, 1, 0, 2, 0, 2, 0, 1, 1, 0, 0, 1, 2, 0, 0, 2, 2, 0, 0, 0, 0, 1, 1, -1, 1, 2, 0, 0, 0, 0, 1, -1, 1, 1, 2, 0, 0, 0, 0, 1, 1, 1, -1, 2, 3, 1, 1, 1, 2, 0, 0, 2, 2, 3, 1, 1, 1, 2, 2, 0, 0, 2, 3, 1, 1, 1, 2, 0, 2, 0, 2, 1, 1, -1, 1, 2, 0, 0, 2, 2, 1, 1, -1, 1, 2, 2, 0, 0, 2, 1, -1, 1, 1, 2, 0, 0, 2, 2, 1, -1, 1, 1, 2, 0, 2, 0, 2, 1, 1, 1, -1, 2, 2, 0, 0, 2, 1, 1, 1, -1, 2, 0, 2, 0], t.p4D = [0, 0, 1, -1, 0, 0, 0, 1, 0, -1, 0, 0, 1, 0, 0, -1, 0, 0, -1, 1, 0, 0, 0, 0, 1, -1, 0, 0, 0, 1, 0, -1, 0, 0, -1, 0, 1, 0, 0, 0, -1, 1, 0, 0, 0, 0, 1, -1, 0, 0, -1, 0, 0, 1, 0, 0, -1, 0, 1, 0, 0, 0, -1, 1, 0, 2, 1, 1, 0, 0, 1, 1, 1, -1, 0, 1, 1, 1, 0, -1, 0, 2, 1, 0, 1, 0, 1, 1, -1, 1, 0, 1, 1, 0, 1, -1, 0, 2, 0, 1, 1, 0, 1, -1, 1, 1, 0, 1, 0, 1, 1, -1, 0, 2, 1, 0, 0, 1, 1, 1, -1, 0, 1, 1, 1, 0, -1, 1, 0, 2, 0, 1, 0, 1, 1, -1, 1, 0, 1, 1, 0, 1, -1, 1, 0, 2, 0, 0, 1, 1, 1, -1, 0, 1, 1, 1, 0, -1, 1, 1, 1, 4, 2, 1, 1, 0, 4, 1, 2, 1, 0, 4, 1, 1, 2, 0, 1, 4, 2, 1, 0, 1, 4, 1, 2, 0, 1, 4, 1, 1, 0, 2, 1, 4, 2, 0, 1, 1, 4, 1, 0, 2, 1, 4, 1, 0, 1, 2, 1, 4, 0, 2, 1, 1, 4, 0, 1, 2, 1, 4, 0, 1, 1, 2, 1, 2, 1, 1, 0, 0, 3, 2, 1, 0, 0, 3, 1, 2, 0, 0, 1, 2, 1, 0, 1, 0, 3, 2, 0, 1, 0, 3, 1, 0, 2, 0, 1, 2, 0, 1, 1, 0, 3, 0, 2, 1, 0, 3, 0, 1, 2, 0, 1, 2, 1, 0, 0, 1, 3, 2, 0, 0, 1, 3, 1, 0, 0, 2, 1, 2, 0, 1, 0, 1, 3, 0, 2, 0, 1, 3, 0, 1, 0, 2, 1, 2, 0, 0, 1, 1, 3, 0, 0, 2, 1, 3, 0, 0, 1, 2, 2, 3, 1, 1, 1, 0, 2, 1, 1, 1, -1, 2, 2, 0, 0, 0, 2, 3, 1, 1, 0, 1, 2, 1, 1, -1, 1, 2, 2, 0, 0, 0, 2, 3, 1, 0, 1, 1, 2, 1, -1, 1, 1, 2, 2, 0, 0, 0, 2, 3, 1, 1, 1, 0, 2, 1, 1, 1, -1, 2, 0, 2, 0, 0, 2, 3, 1, 1, 0, 1, 2, 1, 1, -1, 1, 2, 0, 2, 0, 0, 2, 3, 0, 1, 1, 1, 2, -1, 1, 1, 1, 2, 0, 2, 0, 0, 2, 3, 1, 1, 1, 0, 2, 1, 1, 1, -1, 2, 0, 0, 2, 0, 2, 3, 1, 0, 1, 1, 2, 1, -1, 1, 1, 2, 0, 0, 2, 0, 2, 3, 0, 1, 1, 1, 2, -1, 1, 1, 1, 2, 0, 0, 2, 0, 2, 3, 1, 1, 0, 1, 2, 1, 1, -1, 1, 2, 0, 0, 0, 2, 2, 3, 1, 0, 1, 1, 2, 1, -1, 1, 1, 2, 0, 0, 0, 2, 2, 3, 0, 1, 1, 1, 2, -1, 1, 1, 1, 2, 0, 0, 0, 2, 2, 1, 1, 1, -1, 0, 1, 1, 1, 0, -1, 0, 0, 0, 0, 0, 2, 1, 1, -1, 1, 0, 1, 1, 0, 1, -1, 0, 0, 0, 0, 0, 2, 1, -1, 1, 1, 0, 1, 0, 1, 1, -1, 0, 0, 0, 0, 0, 2, 1, 1, -1, 0, 1, 1, 1, 0, -1, 1, 0, 0, 0, 0, 0, 2, 1, -1, 1, 0, 1, 1, 0, 1, -1, 1, 0, 0, 0, 0, 0, 2, 1, -1, 0, 1, 1, 1, 0, -1, 1, 1, 0, 0, 0, 0, 0, 2, 1, 1, 1, -1, 0, 1, 1, 1, 0, -1, 2, 2, 0, 0, 0, 2, 1, 1, -1, 1, 0, 1, 1, 0, 1, -1, 2, 2, 0, 0, 0, 2, 1, 1, -1, 0, 1, 1, 1, 0, -1, 1, 2, 2, 0, 0, 0, 2, 1, 1, 1, -1, 0, 1, 1, 1, 0, -1, 2, 0, 2, 0, 0, 2, 1, -1, 1, 1, 0, 1, 0, 1, 1, -1, 2, 0, 2, 0, 0, 2, 1, -1, 1, 0, 1, 1, 0, 1, -1, 1, 2, 0, 2, 0, 0, 2, 1, 1, -1, 1, 0, 1, 1, 0, 1, -1, 2, 0, 0, 2, 0, 2, 1, -1, 1, 1, 0, 1, 0, 1, 1, -1, 2, 0, 0, 2, 0, 2, 1, -1, 0, 1, 1, 1, 0, -1, 1, 1, 2, 0, 0, 2, 0, 2, 1, 1, -1, 0, 1, 1, 1, 0, -1, 1, 2, 0, 0, 0, 2, 2, 1, -1, 1, 0, 1, 1, 0, 1, -1, 1, 2, 0, 0, 0, 2, 2, 1, -1, 0, 1, 1, 1, 0, -1, 1, 1, 2, 0, 0, 0, 2, 3, 1, 1, 0, 0, 0, 2, 2, 0, 0, 0, 2, 1, 1, 1, -1, 3, 1, 0, 1, 0, 0, 2, 0, 2, 0, 0, 2, 1, 1, 1, -1, 3, 1, 0, 0, 1, 0, 2, 0, 0, 2, 0, 2, 1, 1, 1, -1, 3, 1, 1, 0, 0, 0, 2, 2, 0, 0, 0, 2, 1, 1, -1, 1, 3, 1, 0, 1, 0, 0, 2, 0, 2, 0, 0, 2, 1, 1, -1, 1, 3, 1, 0, 0, 0, 1, 2, 0, 0, 0, 2, 2, 1, 1, -1, 1, 3, 1, 1, 0, 0, 0, 2, 2, 0, 0, 0, 2, 1, -1, 1, 1, 3, 1, 0, 0, 1, 0, 2, 0, 0, 2, 0, 2, 1, -1, 1, 1, 3, 1, 0, 0, 0, 1, 2, 0, 0, 0, 2, 2, 1, -1, 1, 1, 3, 1, 0, 1, 0, 0, 2, 0, 2, 0, 0, 2, -1, 1, 1, 1, 3, 1, 0, 0, 1, 0, 2, 0, 0, 2, 0, 2, -1, 1, 1, 1, 3, 1, 0, 0, 0, 1, 2, 0, 0, 0, 2, 2, -1, 1, 1, 1, 3, 3, 2, 1, 0, 0, 3, 1, 2, 0, 0, 4, 1, 1, 1, 1, 3, 3, 2, 0, 1, 0, 3, 1, 0, 2, 0, 4, 1, 1, 1, 1, 3, 3, 0, 2, 1, 0, 3, 0, 1, 2, 0, 4, 1, 1, 1, 1, 3, 3, 2, 0, 0, 1, 3, 1, 0, 0, 2, 4, 1, 1, 1, 1, 3, 3, 0, 2, 0, 1, 3, 0, 1, 0, 2, 4, 1, 1, 1, 1, 3, 3, 0, 0, 2, 1, 3, 0, 0, 1, 2, 4, 1, 1, 1, 1, 3, 3, 2, 1, 0, 0, 3, 1, 2, 0, 0, 2, 1, 1, 1, -1, 3, 3, 2, 0, 1, 0, 3, 1, 0, 2, 0, 2, 1, 1, 1, -1, 3, 3, 0, 2, 1, 0, 3, 0, 1, 2, 0, 2, 1, 1, 1, -1, 3, 3, 2, 1, 0, 0, 3, 1, 2, 0, 0, 2, 1, 1, -1, 1, 3, 3, 2, 0, 0, 1, 3, 1, 0, 0, 2, 2, 1, 1, -1, 1, 3, 3, 0, 2, 0, 1, 3, 0, 1, 0, 2, 2, 1, 1, -1, 1, 3, 3, 2, 0, 1, 0, 3, 1, 0, 2, 0, 2, 1, -1, 1, 1, 3, 3, 2, 0, 0, 1, 3, 1, 0, 0, 2, 2, 1, -1, 1, 1, 3, 3, 0, 0, 2, 1, 3, 0, 0, 1, 2, 2, 1, -1, 1, 1, 3, 3, 0, 2, 1, 0, 3, 0, 1, 2, 0, 2, -1, 1, 1, 1, 3, 3, 0, 2, 0, 1, 3, 0, 1, 0, 2, 2, -1, 1, 1, 1, 3, 3, 0, 0, 2, 1, 3, 0, 0, 1, 2, 2, -1, 1, 1, 1], v = [], i = 0; i < t.p2D.length; i += 4) {
                    for (f = t.base2D[t.p2D[i]], o = null, u = null, r = 0; r < f.length; r += 3) u = new b(f[r], f[r + 1], f[r + 2]), o === null ? v[i / 4] = u : o.next = u, o = u;
                    u.next = new b(t.p2D[i + 1], t.p2D[i + 2], t.p2D[i + 3])
                }
                for (this.lookup2D = [], i = 0; i < t.lookupPairs2D.length; i += 2) this.lookup2D[t.lookupPairs2D[i]] = v[t.lookupPairs2D[i + 1]];
                for (y = [], i = 0; i < t.p3D.length; i += 9) {
                    for (f = t.base3D[t.p3D[i]], o = null, u = null, r = 0; r < f.length; r += 4) u = new a(f[r], f[r + 1], f[r + 2], f[r + 3]), o === null ? y[i / 9] = u : o.next = u, o = u;
                    u.next = new a(t.p3D[i + 1], t.p3D[i + 2], t.p3D[i + 3], t.p3D[i + 4]);
                    u.next.next = new a(t.p3D[i + 5], t.p3D[i + 6], t.p3D[i + 7], t.p3D[i + 8])
                }
                for (this.lookup3D = [], i = 0; i < t.lookupPairs3D.length; i += 2) this.lookup3D[t.lookupPairs3D[i]] = y[t.lookupPairs3D[i + 1]];
                for (p = [], i = 0; i < t.p4D.length; i += 16) {
                    for (f = t.base4D[t.p4D[i]], o = null, u = null, r = 0; r < f.length; r += 5) u = new l(f[r], f[r + 1], f[r + 2], f[r + 3], f[r + 4]), o === null ? p[i / 16] = u : o.next = u, o = u;
                    u.next = new l(t.p4D[i + 1], t.p4D[i + 2], t.p4D[i + 3], t.p4D[i + 4], t.p4D[i + 5]);
                    u.next.next = new l(t.p4D[i + 6], t.p4D[i + 7], t.p4D[i + 8], t.p4D[i + 9], t.p4D[i + 10]);
                    u.next.next.next = new l(t.p4D[i + 11], t.p4D[i + 12], t.p4D[i + 13], t.p4D[i + 14], t.p4D[i + 15])
                }
                for (this.lookup4D = [], i = 0; i < t.lookupPairs4D.length; i += 2) this.lookup4D[t.lookupPairs4D[i]] = p[t.lookupPairs4D[i + 1]];
                for (this.perm = new Uint8Array(256), this.perm2D = new Uint8Array(256), this.perm3D = new Uint8Array(256), this.perm4D = new Uint8Array(256), h = new Uint8Array(256), i = 0; i < 256; i++) h[i] = i;
                for (n = new Uint32Array(1), n[0] = w, n = c(c(c(n))), i = 255; i >= 0; i--) n = c(n), s = new Uint32Array(1), s[0] = (n[0] + 31) % (i + 1), s[0] < 0 && (s[0] += i + 1), this.perm[i] = h[s[0]], this.perm2D[i] = this.perm[i] & 14, this.perm3D[i] = this.perm[i] % 24 * 3, this.perm4D[i] = this.perm[i] & 252, h[s[0]] = h[i];
                this.simplex1D = function(n) {
                    return e.simplex2D(n, 1)
                };
                this.simplex2D = function(n, i) {
                    var y = (n + i) * t.STRETCH_2D,
                        p = [n + y, i + y],
                        w = p[0],
                        b = p[1],
                        k = [Math.floor(w), Math.floor(b)],
                        o = k[0],
                        s = k[1],
                        d = (o + s) * t.SQUISH_2D,
                        g = [n - (o + d), i - (s + d)],
                        ft = g[0],
                        et = g[1],
                        nt = [w - o, b - s],
                        h = nt[0],
                        c = nt[1],
                        l = h + c,
                        r = new Uint32Array(4);
                    r[0] = h - c + 1;
                    r[1] = l;
                    r[2] = l + c;
                    r[3] = l + h;
                    for (var ot = r[0] | r[1] << 1 | r[2] << 2 | r[3] << 4, u = e.lookup2D[ot], tt = 0; typeof u != "undefined";) {
                        var it = [ft + u.dx, et + u.dy],
                            a = it[0],
                            v = it[1],
                            f = 2 - a * a - v * v;
                        if (f > 0) {
                            var rt = [o + u.xsb, s + u.ysb],
                                st = rt[0],
                                ht = rt[1],
                                ut = e.perm2D[e.perm[st & 255] + ht & 255],
                                ct = t.gradients2D[ut] * a + t.gradients2D[ut + 1] * v;
                            f *= f;
                            tt += f * f * ct
                        }
                        u = u.next
                    }
                    return tt * t.NORM_2D
                };
                this.simplex3D = function(n, i, r) {
                    var p = (n + i + r) * t.STRETCH_3D,
                        w = [n + p, i + p, r + p],
                        et = w[0],
                        ot = w[1],
                        st = w[2],
                        b = [Math.floor(et), Math.floor(ot), Math.floor(st)],
                        s = b[0],
                        h = b[1],
                        c = b[2],
                        k = (s + h + c) * t.SQUISH_3D,
                        d = [n - (s + k), i - (h + k), r - (c + k)],
                        ct = d[0],
                        lt = d[1],
                        at = d[2],
                        g = [et - s, ot - h, st - c],
                        l = g[0],
                        a = g[1],
                        v = g[2],
                        y = l + a + v,
                        u = new Uint32Array(7);
                    u[0] = a - v + 1;
                    u[1] = l - a + 1;
                    u[2] = l - v + 1;
                    u[3] = y;
                    u[4] = y + v;
                    u[5] = y + a;
                    u[6] = y + l;
                    for (var vt = u[0] | u[1] << 1 | u[2] << 2 | u[3] << 3 | u[4] << 5 | u[5] << 7 | u[6] << 9, f = e.lookup3D[vt], ht = 0; typeof f != "undefined";) {
                        var nt = [ct + f.dx, lt + f.dy, at + f.dz],
                            tt = nt[0],
                            it = nt[1],
                            rt = nt[2],
                            o = 2 - tt * tt - it * it - rt * rt;
                        if (o > 0) {
                            var ut = [s + f.xsb, h + f.ysb, c + f.zsb],
                                yt = ut[0],
                                pt = ut[1],
                                wt = ut[2],
                                ft = e.perm3D[e.perm[e.perm[yt & 255] + pt & 255] + wt & 255],
                                bt = t.gradients3D[ft] * tt + t.gradients3D[ft + 1] * it + t.gradients3D[ft + 2] * rt;
                            o *= o;
                            ht += o * o * bt
                        }
                        f = f.next
                    }
                    return ht * t.NORM_3D
                };
                this.simplex4D = function(n, i, r, u) {
                    var y = (n + i + r + u) * t.STRETCH_4D,
                        p = [n + y, i + y, r + y, u + y],
                        ht = p[0],
                        ct = p[1],
                        lt = p[2],
                        at = p[3],
                        w = [Math.floor(ht), Math.floor(ct), Math.floor(lt), Math.floor(at)],
                        b = w[0],
                        k = w[1],
                        d = w[2],
                        g = w[3],
                        nt = (b + k + d + g) * t.SQUISH_4D,
                        yt = n - (b + nt),
                        pt = i - (k + nt),
                        wt = r - (d + nt),
                        bt = u - (g + nt),
                        tt = [ht - b, ct - k, lt - d, at - g],
                        s = tt[0],
                        h = tt[1],
                        c = tt[2],
                        l = tt[3],
                        a = s + h + c + l,
                        f = new Uint32Array(11);
                    f[0] = c - l + 1;
                    f[1] = h - c + 1;
                    f[2] = h - l + 1;
                    f[3] = s - h + 1;
                    f[4] = s - c + 1;
                    f[5] = s - l + 1;
                    f[6] = a << 6;
                    f[7] = a + l;
                    f[8] = a + c;
                    f[9] = a + h;
                    f[10] = a + s;
                    for (var kt = f[0] | f[1] << 1 | f[2] << 2 | f[3] << 3 | f[4] << 4 | f[5] << 5 | f[6] << 6 | f[7] << 8 | f[8] << 11 | f[9] << 14 | f[10] << 17, o = e.lookup4D[kt], vt = 0; typeof o != "undefined";) {
                        var it = [yt + o.dx, pt + o.dy, wt + o.dz, bt + o.dw],
                            ft = it[0],
                            et = it[1],
                            ot = it[2],
                            st = it[3],
                            v = 2 - ft * ft - et * et - ot * ot - st * st;
                        if (v > 0) {
                            var rt = [b + o.xsb, k + o.ysb, d + o.zsb, g + o.wsb],
                                dt = rt[0],
                                gt = rt[1],
                                ni = rt[2],
                                ti = rt[3],
                                ut = e.perm4D[e.perm[e.perm[e.perm[dt & 255] + gt & 255] + ni & 255] + ti & 255],
                                ii = t.gradients4D[ut] * ft + t.gradients4D[ut + 1] * et + t.gradients4D[ut + 2] * ot + t.gradients4D[ut + 3] * st;
                            v *= v;
                            vt += v * v * ii
                        }
                        o = o.next
                    }
                    return vt * t.NORM_4D
                }
            }, n.Point = function(n, t, i, r, u, f, e, o, s, h) {
                z_d("13.45");
                zot(n) && (n = 0);
                zot(t) && (t = 0);
                zot(i) && (i = 0);
                zot(r) && (r = 0);
                zot(u) && (u = 0);
                zot(f) && (f = 0);
                zot(e) && (e = 0);
                zot(o) && (o = 0);
                zot(s) && (s = 0);
                zot(h) && (h = 0);
                this.createjsPoint_constructor(n, t);
                this.type = "Point";
                this.x = n;
                this.y = t;
                this.z = i;
                this.q = r;
                this.r = u;
                this.s = f;
                this.t = e;
                this.u = o;
                this.v = s;
                this.w = h;
                this.angle = function(n) {
                    return this.createjsPoint_angle(n) * 180 / Math.PI
                };
                this.project = function(n, t) {
                    return this.createjsPoint_project(n * Math.PI / 180, t)
                }
            }, n.extend(n.Point, createjs.Point, ["angle", "project"], "createjsPoint"), n.Bezier = function(n, t, i, r) {
                var u;
                z_d("13.47");
                this.a = n;
                this.b = t;
                this.c = i;
                this.d = r;
                this.len = 100;
                this.arcLengths = new Array(this.len + 1);
                this.arcLengths[0] = 0;
                var e = this.x(0),
                    o = this.y(0),
                    f = 0;
                for (u = 1; u <= this.len; u += 1) {
                    var s = this.x(u * .01),
                        h = this.y(u * .01),
                        c = e - s,
                        l = o - h;
                    f += Math.sqrt(c * c + l * l);
                    this.arcLengths[u] = f;
                    e = s;
                    o = h
                }
                this.length = f
            }, n.Bezier.prototype = {
                map: function(n) {
                    for (var i = n * this.arcLengths[this.len], r = 0, f = this.len, t = 0, u; r < f;) t = r + ((f - r) / 2 | 0), this.arcLengths[t] < i ? r = t + 1 : f = t;
                    return this.arcLengths[t] > i && t--, u = this.arcLengths[t], u === i ? t / this.len : (t + (i - u) / (this.arcLengths[t + 1] - u)) / this.len
                },
                mx: function(n) {
                    return this.x(this.map(n))
                },
                my: function(n) {
                    return this.y(this.map(n))
                },
                x: function(n) {
                    return (1 - n) * (1 - n) * (1 - n) * this.a.x + 3 * (1 - n) * (1 - n) * n * this.b.x + 3 * (1 - n) * n * n * this.c.x + n * n * n * this.d.x
                },
                y: function(n) {
                    return (1 - n) * (1 - n) * (1 - n) * this.a.y + 3 * (1 - n) * (1 - n) * n * this.b.y + 3 * (1 - n) * n * n * this.c.y + n * n * n * this.d.y
                }
            }, n.Boundary = function(n, t, i, r) {
                (z_d("13.46"), n.x && (r = n.height, i = n.width, t = n.y, n = n.x), zot(n) || zot(t) || zot(i) || zot(r)) || (this.x = n, this.y = t, this.width = i, this.height = r, this.contract = function(n, t, i, r) {
                    return zot(n) ? this : (zot(t) && (t = n), i = zot(i) ? n * 2 : i + n, r = zot(r) ? t * 2 : r + t, this.x += n, this.y += t, this.width -= i, this.height -= r, this)
                })
            }, n.GradientColor = function(n, t, i, r, u, f) {
                if (z_d("13.465"), this.type = "GradientColor", this.colors = zot(n) ? ["black", "white"] : n, Array.isArray(this.colors) || (this.colors = [this.colors, this.colors]), this.colors.length == 1 && this.colors.push(this.colors[0]), this.ratios = zot(t) ? 0 : t, !Array.isArray(this.ratios)) {
                    this.angle = this.ratios;
                    this.ratios = [];
                    for (var e = 0; e < this.colors.length; e++) this.ratios.push(e / (this.colors.length - 1))
                }!zot(i) && (zot(r) || zot(u) || zot(f)) ? (this.angle = i, i = null) : zot(this.angle) && zot(i) && zot(r) && zot(u) && zot(f) ? this.angle = 0 : (this.x0 = zot(i) ? 0 : i, this.y0 = zot(r) ? 0 : r, this.x1 = zot(u) ? 0 : u, this.y1 = zot(f) ? 100 : f)
            }, n.RadialColor = function(n, t, i, r, u, f, e, o) {
                if (z_d("13.466"), this.type = "RadialColor", this.colors = zot(n) ? ["black", "white"] : n, Array.isArray(this.colors) || (this.colors = [this.colors, this.colors]), this.colors.length == 1 && this.colors.push(this.colors[0]), this.ratios = t, !Array.isArray(this.ratios)) {
                    this.ratios = [];
                    for (var s = 0; s < this.colors.length; s++) this.ratios.push(s / (this.colors.length - 1))
                }
                this.x0 = i;
                this.y0 = r;
                this.r0 = u;
                this.x1 = f;
                this.y1 = e;
                this.r1 = o
            }, n.BitmapColor = function(n, t, i) {
                z_d("13.467");
                this.type = "BitmapColor";
                typeof n == "string" && WW.asset && (n = WW.asset(n));
                n.type != "Bitmap" && n.bitmap && (n = n.bitmap);
                this.image = n.type == "Bitmap" ? n.image : n;
                this.repetition = t;
                this.matrix = i
            }, n.Damp = function(t, i) {
                z_d("14");
                var r;
                if (r = zob(n.Damp, arguments, "startValue, damp", this)) return r;
                this.lastValue = zot(t) ? 0 : t;
                this.damp = zot(i) ? .1 : i
            }, n.Damp.prototype.convert = function(n) {
                return this.lastValue = this.lastValue + (n - this.lastValue) * this.damp
            }, n.Damp.prototype.immediate = function(n) {
                return this.lastValue = n, this
            }, n.Proportion = function(t, i, r, u, f, e, o) {
                var c, h, s;
                if (c = zob(n.Proportion, arguments, "baseMin, baseMax, targetMin, targetMax, factor, targetRound, clamp", this)) return c;
                z_d("15");
                zot(r) && (r = 0);
                zot(u) && (u = 1);
                zot(f) && (f = 1);
                zot(e) && (e = !1);
                zot(o) && (o = !0);
                this.convert = function(n) {
                    if (zot(n) && (n = t), !isNaN(n) && i - t != 0) return o && (n = Math.max(n, t), n = Math.min(n, i)), h = (n - t) / (i - t), s = f > 0 ? r + (u - r) * h : u - (u - r) * h, e && (s = Math.round(s)), s
                }
            }, n.ProportionDamp = function(t, i, r, u, f, e, o, s) {
                function d() {
                    isNaN(c) || i - t == 0 || (s && (c = Math.max(c, t), c = Math.min(c, i)), v = (c - t) / (i - t), y = u - r, a = e > 0 ? r + y * v : u - y * v, p = a, b = p - h, h += b * l.damp)
                }
                var w, k;
                if (w = zob(n.ProportionDamp, arguments, "baseMin, baseMax, targetMin, targetMax, damp, factor, targetRound, clamp", this)) return w;
                z_d("16");
                zot(r) && (r = 0);
                zot(u) && (u = 1);
                zot(f) && (f = .1);
                zot(e) && (e = 1);
                zot(o) && (o = !1);
                zot(s) && (s = !0);
                this.damp = f;
                var l = this,
                    c, v, y, a, b, p = 0,
                    h = 0;
                c = t;
                h = r;
                k = setInterval(d, 20);
                this.immediate = function(n) {
                    return l.convert(n), d(), h = a, o && (h = Math.round(h)), l
                };
                this.immediateValue = function(n) {
                    return p = h = n, l
                };
                this.convert = function(n) {
                    return c = n, o ? Math.round(h) : h
                };
                this.dispose = function() {
                    return clearInterval(k), !0
                }
            }, n.Dictionary = function(n) {
                z_d("17");
                this.length = 0;
                this.unique = n;
                var t = this.objects = [],
                    i = this.values = [];
                this.add = function(n, r) {
                    zot(n) || (zot(r) && (r = !0), this.unique && this.remove(n), t.push(n), i.push(r), this.length++)
                };
                this.at = function(n) {
                    if (!zot(n)) {
                        var r = t.indexOf(n);
                        return r > -1 ? i[r] : null
                    }
                };
                this.remove = function(n) {
                    if (zot(n)) return !1;
                    var r = t.indexOf(n);
                    return r > -1 ? (t.splice(r, 1), i.splice(r, 1), this.length--, !0) : !1
                };
                this.clear = function() {
                    return t = this.objects = [], i = this.values = [], this.length = null, this
                };
                this.dispose = function() {
                    return t = null, i = null, this.length = null, !0
                }
            }, n.Hierarchy = function(t, i) {
                function f(t) {
                    function u(t, f) {
                        n.loop(t, function(n, t) {
                            i.push(t.obj);
                            r.push(n);
                            t.open && u(t.list, f + 1)
                        })
                    }
                    var i = [],
                        r = [];
                    return u(t, 0), [i, r]
                }
                var r, u;
                (z_d("17.5"), r = this, zot(t)) || (zot(i) && (i = !1), r.processSimple = function(r) {
                    function o(t, u, e, s) {
                        if (zot(t) || (r = t), r.constructor == {}.constructor) {
                            var h;
                            r.list && (h = r, r = r.list);
                            s && h && n.loop(h, function(n, t) {
                                n != "list" && (s[n] = t)
                            });
                            n.loop(r, function(n, t) {
                                var r = {},
                                    s = u["id" + f] = {
                                        obj: n,
                                        level: e,
                                        open: i,
                                        opened: !1,
                                        list: r
                                    };
                                f++;
                                o(t, r, e + 1, s)
                            })
                        } else Array.isArray(r) && n.loop(r, function(n) {
                            u["id" + f] = {
                                obj: n
                            };
                            f++
                        })
                    }
                    var f = 0,
                        e = {};
                    return o(t, e, 0), u = f, e
                }, r.processComplex = function(t) {
                    function f(t, u) {
                        n.loop(t, function(n, t) {
                            t.level = u;
                            zot(t.open) && (t.open = i);
                            zot(t.opened) && (t.opened = !1);
                            t.list && f(t.list, u + 1);
                            r++
                        })
                    }
                    var r = 0;
                    return f(t, 0), u = r, t
                }, r.data = zot(t.id0) ? r.processSimple(t) : r.processComplex(t), r.getLinearList = function(n) {
                    return zot(n) && (n = r.data), f(n)[0]
                }, r.getLinearIDs = function(n) {
                    return zot(n) && (n = r.data), f(n)[1]
                }, r.getData = function(t) {
                    function u(r) {
                        n.loop(r, function(n, r) {
                            if (n == t) return i = r;
                            u(r.list)
                        })
                    }
                    var i;
                    return u(r.data), i
                }, r.getNextSibling = function(t) {
                    function f(r) {
                        n.loop(r, function(n, r) {
                            if (!i && u) return i = n;
                            n == t ? u = r : f(r.list)
                        })
                    }
                    var u, i;
                    return f(r.data), i
                }, r.getPrevSibling = function(t) {
                    function f(r, e) {
                        n.loop(r, function(n, r) {
                            if (n == t) return u = i[e] || i[e - 1];
                            i[e] = n;
                            f(r.list, e + 1)
                        })
                    }
                    var i = [],
                        u;
                    return f(r.data, 0), u
                }, Object.defineProperty(r, "length", {
                    get: function() {
                        return u
                    },
                    set: function() {
                        zon && zogy("Hierarchy() - length is read only")
                    }
                }))
            }, n.Pick = function(t) {
                n.pickCheck || (z_d("17.6"), n.pickCheck = !0);
                this.choices = t;
                this.num = function(t) {
                    for (var i = [], r = 0; r < t; r++) i.push(n.Pick.choose(this));
                    return this.choices = n.Pick.series(i), this
                };
                var i = this;
                this.loop = function(t, r) {
                    for (var u, f = 0; f < t; f++)
                        if (u = r(n.Pick.choose(i), f, t), typeof u != "undefined") return u
                }
            }, n.Pick.prototype.type = "Pick", n.Pick.series = function() {
                return n.pickCheck || (z_d("17.6"), n.pickCheck = !0), n.series.apply(null, arguments)
            }, n.Pick.rand = function(t, i, r, u) {
                return n.pickCheck || (z_d("17.6"), n.pickCheck = !0), n.rand(t, i, r, u)
            }, n.Pick.choose = function(t, i, r) {
                if (n.pickCheck || (z_d("17.6"), n.pickCheck = !0), i == null && (i = !0), t == null) return t;
                if (t.type == "Pick" || i) {
                    var u = t.choices || t,
                        f;
                    return Array.isArray(u) ? (f = u[Math.floor(Math.random() * u.length)], n.Pick.choose(f)) : u.constructor === {}.constructor ? zot(u.noPick) ? zot(u.max) ? u : (zot(u.integer) && (u.integer = !1), n.Pick.rand(u.min, u.max, u.integer, u.negative)) : u.noPick : u instanceof Function ? (u.count == null ? u.count = 0 : u.count++, n.Pick.choose(u(r, !0))) : t
                }
                return t
            }, n.Pick.getMinMax = function(t) {
                return !zot(t.min) && !zot(t.max) ? t : Array.isArray(t) ? n.arrayMinMax(t) : t.type == "series" ? n.arrayMinMax(t.array) : {
                    min: null,
                    max: null
                }
            }, n.scrollX = function(t, i) {
                return z_d("18"), n.abstractScroll("X", "Left", t, i)
            }, n.scrollY = function(t, i) {
                return z_d("19"), n.abstractScroll("Y", "Top", t, i)
            }, n.abstractScroll = function(i, r, u, f) {
                var c, o, e, s;
                if (z_d("20"), c = t(f), o = i == "X" ? "Y" : "X", zot(u)) return document.documentElement && document.documentElement["scroll" + r] || document.body["scroll" + r];
                if (zot(f)) WW.scrollTo(n["scroll" + o](), u);
                else {
                    e = 50;
                    s = f * (c == "s" ? 1e3 : 1);
                    s < e && (s = e);
                    var l = s / e,
                        h = n["scroll" + i](),
                        v = u - h,
                        y = v / l,
                        a = 0,
                        p = setInterval(function() {
                            a++;
                            h += y;
                            WW.scrollTo(n["scroll" + o](), h);
                            a >= l && (WW.scrollTo(n["scroll" + o](), u), clearInterval(p))
                        }, e)
                }
                return u
            }, n.windowWidth = function() {
                var t, i, r;
                return z_d("21"), t = isNaN(WW.innerWidth) ? WW.clientWidth : WW.innerWidth, i = isNaN(WW.innerHeight) ? WW.clientHeight : WW.innerHeight, !n.mobile() || zot(WW.orientation) || WW.parent || (t > i && Math.abs(WW.orientation) != 90 || i > t && Math.abs(WW.orientation) == 90) && (r = t, t = i, i = r), WW.zdf && WW.zdf.swapRotation ? i : t
            }, n.windowHeight = function() {
                var t, i, r;
                return z_d("22"), t = isNaN(WW.innerWidth) ? WW.clientWidth : WW.innerWidth, i = isNaN(WW.innerHeight) ? WW.clientHeight : WW.innerHeight, !n.mobile() || zot(WW.orientation) || WW.parent || (t > i && Math.abs(WW.orientation) != 90 || i > t && Math.abs(WW.orientation) == 90) && (r = t, t = i, i = r), WW.zdf && WW.zdf.swapRotation ? t : i
            }, n.browserZoom = function() {
                if (n.zimBZ) return zot(n.zimBZA) ? n.decimals((WW.devicePixelRatio || 1) / n.zimBZ1, 2) : n.zimBZA;
                if (z_d("22.2"), n.zimBZ = !0, typeof t == "undefined")
                    if (WW.zdf) var t = WW.zdf;
                    else return n.zimBZA = 1, 1;
                if (t.retina) n.zimBZ1 = WW.devicePixelRatio || 1;
                else return n.zimBZA = 1, 1
            }, n.getQueryString = function(n) {
                var u, i, r, t;
                if (z_d("22.5"), zot(n) && (n = location.search.replace("?", "")), n == "") return {};
                for (u = n.split("&"), i = {}, r = 0; r < u.length; r++) t = u[r].split("="), typeof i[t[0]] == "undefined" ? i[t[0]] = decodeURIComponent((t[1] + "").replace(/\+/g, "%20")) : typeof i[t[0]] == "string" ? i[t[0]] = [i[t[0]], decodeURIComponent((t[1] + "").replace(/\+/g, "%20"))] : i[t[0]].push(decodeURIComponent((t[1] + "").replace(/\+/g, "%20")));
                return i
            }, n.swapHTML = function(t, i) {
                return z_d("17.2"), n.swapProperties("innerHTML", zid(t), zid(i))
            }, n.urlEncode = function(n) {
                return z_d("23"), n = (n + "").toString(), encodeURIComponent(n).replace(/!/g, "%21").replace(/'/g, "%27").replace(/\(/g, "%28").replace(/\)/g, "%29").replace(/\*/g, "%2A").replace(/%20/g, "+")
            }, n.urlDecode = function(n) {
                return z_d("24"), decodeURIComponent((n + "").replace(/\+/g, "%20"))
            }, n.setCookie = function(n, t, i) {
                var u, r;
                if (z_d("25"), !zot(n) && !zot(t)) return i ? (r = new Date, r.setTime(r.getTime() + i * 864e5), u = "; expires=" + r.toGMTString()) : u = "", document.cookie = n + "=" + escape(t) + u + "; path=/", !0
            }, n.getCookie = function(n) {
                var r, t, u, i;
                for (z_d("26"), r = document.cookie.split(/;\s*/), t = [], i = 0; i < r.length; i++) u = r[i].split("="), t[u[0]] = u[1];
                return typeof t[n] == "undefined" ? undefined : unescape(t[n])
            }, n.deleteCookie = function(t) {
                return (z_d("27"), zot(n.getCookie(t))) ? !1 : (n.setCookie(t, "", -1), !0)
            }, createjs == null) return zon && zogr("ZIM >= 4.3.0 requires createjs namespace to be loaded (import createjs before zim)"), n;
        for (n.localToGlobal = function(t, i, r, u) {
                if (n.coordinatesCheck || (z_d("50.43"), n.coordinatesCheck = !0), t != null && i != null) {
                    var f = u.call(r, t, i),
                        e = r.stage;
                    if (!WW.zdf) {
                        if (!e) return f;
                        WW.zdf = {
                            stage: e,
                            canvas: e.canvas
                        }
                    }
                    return f.x /= n.scaX, f.y /= n.scaY, f
                }
            }, n.globalToLocal = function(t, i, r, u) {
                var f;
                if (n.coordinatesCheck || (z_d("50.43"), n.coordinatesCheck = !0), t != null && i != null) {
                    if (f = r.stage, !WW.zdf) {
                        if (!f) return u.call(r, t, i);
                        WW.zdf = {
                            stage: f,
                            canvas: f.canvas
                        }
                    }
                    return t *= n.scaX, i *= n.scaY, u.call(r, t, i)
                }
            }, n.localToLocal = function(t, i, r, u) {
                if (n.coordinatesCheck || (z_d("50.43"), n.coordinatesCheck = !0), t != null && i != null && r != null) {
                    var f = u.localToGlobal(t, i),
                        e = u.stage;
                    if (!WW.zdf) {
                        if (!e) return r.globalToLocal(f.x, f.y);
                        WW.zdf = {
                            stage: e,
                            canvas: e.canvas
                        }
                    }
                    return (e || (e = WW.zdf.stage), r == e) ? f : f ? r.globalToLocal(f.x, f.y) : void 0
                }
            }, n.displayBase = function(t) {
                var i, e, r, o, f, u;
                n.zimDBCheck || (z_d("50.432"), n.zimDBCheck = !0);
                i = t;
                Object.defineProperty(t, "width", {
                    enumerable: !0,
                    get: function() {
                        var n = this.getBounds();
                        return zot(n) ? null : Math.abs(n.width * this.scaleX)
                    },
                    set: function(n) {
                        var i, r, u;
                        if (t.scaleDimensions !== !1) {
                            if (i = this.getBounds(), zot(i) || i.width == 0) {
                                zon && zogy("DisplayObject() - width needs bounds set with setBounds()");
                                return
                            }
                            r = n / i.width;
                            this.scaleX = this.scaleY = r
                        } else u = t.width != 0 ? t.height / t.width : 0, t.setWidth(n), t.setHeight(n * u), t.drawShape()
                    }
                });
                Object.defineProperty(t, "height", {
                    enumerable: !0,
                    get: function() {
                        var n = this.getBounds();
                        return zot(n) ? null : Math.abs(n.height * this.scaleY)
                    },
                    set: function(n) {
                        var i, r, u;
                        if (t.scaleDimensions !== !1) {
                            if (i = this.getBounds(), zot(i) || i.height == 0) {
                                zon && zogy("DisplayObject() - height needs bounds set with setBounds()");
                                return
                            }
                            r = n / i.height;
                            this.scaleX = this.scaleY = r
                        } else u = t.height != 0 ? t.width / t.height : 0, t.setHeight(n), t.setWidth(n * u), t.drawShape()
                    }
                });
                Object.defineProperty(t, "widthOnly", {
                    enumerable: !0,
                    get: function() {
                        var n = this.getBounds();
                        return zot(n) ? null : Math.abs(n.width * this.scaleX)
                    },
                    set: function(n) {
                        var i, r;
                        if (t.scaleDimensions !== !1) {
                            if (i = this.getBounds(), (zot(i) || i.width == 0) && zon) {
                                zogy("DisplayObject() - widthOnly needs bounds set with setBounds()");
                                return
                            }
                            r = n / i.width;
                            this.scaleX = r
                        } else t.setWidth(n), t.drawShape()
                    }
                });
                Object.defineProperty(t, "heightOnly", {
                    enumerable: !0,
                    get: function() {
                        var n = this.getBounds();
                        return zot(n) ? null : Math.abs(n.height * this.scaleY)
                    },
                    set: function(n) {
                        var i, r;
                        if (t.scaleDimensions !== !1) {
                            if (i = this.getBounds(), (zot(i) || i.height == 0) && zon) {
                                zogy("DisplayObject() - heightOnly needs bounds set with setBounds()");
                                return
                            }
                            r = n / i.height;
                            this.scaleY = r
                        } else t.setHeight(n), t.drawShape()
                    }
                });
                Object.defineProperty(t, "level", {
                    enumerable: !0,
                    get: function() {
                        return this.parent ? this.parent.getChildIndex(this) : null
                    },
                    set: function(n) {
                        this.parent && this.parent.setChildIndex(this, Math.max(0, Math.min(n, this.parent.numChildren - 1)))
                    }
                });
                Object.defineProperty(t, "depth", {
                    enumerable: !0,
                    get: function() {
                        return this._depth
                    },
                    set: function(n) {
                        if (this._depth = n, !zot(this.vrChannel)) {
                            var t = this.vrParallaxDistance ? n * this.vrParallax * this.vrParallaxDistance : 0;
                            this.vrChannel == "left" ? this.x = this.vrStartX + n + t : this.vrChannel == "right" && (this.x = this.vrStartX - n + t)
                        }
                    }
                });
                Object.defineProperty(t, "blendMode", {
                    enumerable: !0,
                    get: function() {
                        return this.compositeOperation
                    },
                    set: function(n) {
                        this.compositeOperation = n
                    }
                });
                i.name || Object.defineProperty(i, "name", {
                    get: function() {
                        return e
                    },
                    set: function(t) {
                        e = t;
                        n.zimObjectIDs[t] = i
                    }
                });
                i._draggable;
                Object.defineProperty(i, "draggable", {
                    get: function() {
                        return this._draggable
                    },
                    set: function(n) {
                        n != this._draggable && (this._draggable = n, this._draggable ? this.drag() : this.noDrag())
                    }
                });
                i.on("mousedown", function(n) {
                    n.target.stage && (r = n.target.stage.frame, r.allowDefault && (o = !0, r.allowDefault = !1))
                });
                i.on("pressup", function() {
                    r && o && (r.allowDefault = !0)
                });
                for (f = ["hue", "saturation", "brightness", "contrast"], u = 0; u < f.length; u++) - function() {
                    for (var t = f[u], r = 0; r < 2; r++) - function() {
                        var u = r == 0 ? "" : "Batch";
                        Object.defineProperty(i, t + u, {
                            get: function() {
                                return i.effects && i.effects.multi ? i.effects.multi[t] : 0
                            },
                            set: function(r) {
                                i.effects && i.effects.multi ? i.effects.multi[t] = r : i.effect(new n.MultiEffect(t == "hue" ? r : 0, t == "saturation" ? r : 0, t == "brightness" ? r : 0, t == "contrast" ? r : 0));
                                u == "" && i.updateEffects()
                            }
                        })
                    }()
                }()
            }, n.gD = function(t) {
                if (n.zimGDCheck || (z_d("50.435"), n.zimGDCheck = !0), t) {
                    if (t.z_bc) {
                        var i = t.z_bc;
                        i.width = i.height = 1;
                        i.getContext && i.getContext("2d").clearRect(0, 0, 1, 1);
                        delete t.z_bc
                    }
                    n.KEYFOCUS == t && (n.KEYFOCUS = null);
                    WW.KEYFOCUS == t && (WW.KEYFOCUS = null);
                    t.draggable && t.noDrag();
                    t.zimTweens && t.stopAnimate();
                    t.zimWire && t.noWire();
                    t.zimWired && t.noWired();
                    t.zimClickHoldDownEvent && t.noHold();
                    t.transformControls && t.transformControls.dispose();
                    t.zimClickDownEvent && (t.zimClickDownEvent = null);
                    t.zimClickUpEvent && (t.zimClickUpEvent = null);
                    t.physics && t.removePhysics();
                    t.name && n.zimObjectIDs[t.name] == t && delete n.zimObjectIDs[t.name]
                }
            }, n.Stage = function(t, i, r) {
                if (z_d("50.44"), !zot(t)) {
                    var u = t.tagName == "CANVAS" ? t : zid(t);
                    if (!zot(u)) {
                        this.cjsStage_constructor(t);
                        this.setBounds(0, 0, u.width, u.height);
                        this.type = "Stage";
                        WW.zdf || (WW.zimDefaultFrame = WW.zdf = {
                            stage: this
                        });
                        r ? createjs.Touch.enable(this, !0) : i && createjs.Touch.enable(this, !1);
                        this.cache = function(n, t, i, r, u, f) {
                            var e, o;
                            return zot(i) && (zot(n) ? (e = this.getBounds(), zot(e) || (o = this.borderWidth > 0 ? this.borderWidth / 2 : 0, n = e.x - o, t = e.y - o, i = e.width + o * 2, r = e.height + o * 2)) : (i = n, r = t, n = 0, t = 0)), this.cjsStage_cache(n, t, i, r, u, f), this.z_bc = this.cacheCanvas, this
                        };
                        this.on("mousedown", function(n) {
                            var t = n.clone();
                            t.type = "pressdown";
                            n.target.dispatchEvent(t)
                        }, undefined, !1, undefined, !0);
                        this.loop = function(t, i, r, u, f) {
                            return n.loop(this, t, i, r, u, f)
                        };
                        this.hitTestGrid = function(t, i, r, u, f, e, o, s, h, c, l, a) {
                            return n.hitTestGrid(this, t, i, r, u, f, e, o, s, h, c, l, a)
                        };
                        this.disposeAllChildren = function() {
                            for (var t, n = this.numChildren - 1; n >= 0; n--) t = this.getChildAt(n), t.dispose && t.dispose();
                            return this
                        };
                        this.frame = WW.zdf;
                        createjs && !createjs.stageTransformable && (WW.zdf.retina || typeof exportRoot != "undefined") && (Object.defineProperty(this, "scale", {
                            get: function() {
                                return this.cjsStage_scale
                            },
                            set: function(t) {
                                this.cjsStage_scaleX = t;
                                this.cjsStage_scaleY = t;
                                n.scaX = createjs.stageTransformable ? 1 : t;
                                n.scaY = createjs.stageTransformable ? 1 : t
                            }
                        }), Object.defineProperty(this, "scaleX", {
                            get: function() {
                                return this.cjsStage_scaleX
                            },
                            set: function(t) {
                                this.cjsStage_scaleX = t;
                                n.scaX = createjs.stageTransformable ? 1 : t
                            }
                        }), Object.defineProperty(this, "scaleY", {
                            get: function() {
                                return this.cjsStage_scaleY
                            },
                            set: function(t) {
                                this.cjsStage_scaleY = t;
                                n.scaY = createjs.stageTransformable ? 1 : t
                            }
                        }), this.localToGlobal = function(t, i) {
                            return n.localToGlobal(t, i, this, this.cjsStage_localToGlobal)
                        }, this.globalToLocal = function(t, i) {
                            return n.globalToLocal(t, i, this, this.cjsStage_globalToLocal)
                        }, this.localToLocal = function(t, i, r) {
                            return n.localToLocal(t, i, r, this)
                        })
                    }
                }
            }, n.extend(n.Stage, createjs.Stage, ["cache", "localToLocal", "localToGlobal", "globalToLocal"], "cjsStage", !1), n.StageGL = function(t, i, r, u) {
                if (z_d("50.45"), !zot(t)) {
                    var f = t.tagName == "CANVAS" ? t : zid(t);
                    if (!zot(f)) {
                        this.cjsStageGL_constructor(t, i);
                        this.setBounds(0, 0, f.width, f.height);
                        this.type = "StageGL";
                        WW.zdf || (WW.zdf = {
                            stage: this
                        });
                        u ? createjs.Touch.enable(this, !0) : r && createjs.Touch.enable(this, !1);
                        this.cache = function(n, t, i, r, u, f) {
                            var e, o;
                            return zot(i) && (zot(n) ? (e = this.getBounds(), zot(e) || (o = this.borderWidth > 0 ? this.borderWidth / 2 : 0, n = e.x - o, t = e.y - o, i = e.width + o * 2, r = e.height + o * 2)) : (i = n, r = t, n = 0, t = 0)), this.cjsStageGL_cache(n, t, i, r, u, f), this.z_bc = this.cacheCanvas, this
                        };
                        this.on("mousedown", function(n) {
                            var t = n.clone();
                            t.type = "pressdown";
                            n.target.dispatchEvent(t)
                        }, undefined, !1, undefined, !0);
                        this.loop = function(t, i, r, u, f) {
                            return n.loop(this, t, i, r, u, f)
                        };
                        this.hitTestGrid = function(t, i, r, u, f, e, o, s, h, c, l, a) {
                            return n.hitTestGrid(this, t, i, r, u, f, e, o, s, h, c, l, a)
                        };
                        this.disposeAllChildren = function() {
                            for (var t, n = this.numChildren - 1; n >= 0; n--) t = this.getChildAt(n), t.dispose && t.dispose();
                            return this
                        };
                        this.frame = WW.zdf;
                        createjs && !createjs.stageTransformable && (WW.zdf.retina || typeof exportRoot != "undefined") && (Object.defineProperty(this, "scale", {
                            get: function() {
                                return this.cjsStage_scale
                            },
                            set: function(t) {
                                this.cjsStage_scaleX = t;
                                this.cjsStage_scaleY = t;
                                n.scaX = createjs.stageTransformable ? 1 : t;
                                n.scaY = createjs.stageTransformable ? 1 : t
                            }
                        }), Object.defineProperty(this, "scaleX", {
                            get: function() {
                                return this.cjsStage_scaleX
                            },
                            set: function(t) {
                                this.cjsStage_scaleX = t;
                                n.scaX = createjs.stageTransformable ? 1 : t
                            }
                        }), Object.defineProperty(this, "scaleY", {
                            get: function() {
                                return this.cjsStage_scaleY
                            },
                            set: function(t) {
                                this.cjsStage_scaleY = t;
                                n.scaY = createjs.stageTransformable ? 1 : t
                            }
                        }), this.localToGlobal = function(t, i) {
                            return n.localToGlobal(t, i, this, this.cjsStageGL_localToGlobal)
                        }, this.globalToLocal = function(t, i) {
                            return n.globalToLocal(t, i, this, this.cjsStageGL_globalToLocal)
                        }, this.localToLocal = function(t, i, r) {
                            return n.localToLocal(t, i, r, this)
                        })
                    }
                }
            }, n.extend(n.StageGL, createjs.StageGL, ["cache", "localToLocal", "localToGlobal", "globalToLocal"], "cjsStageGL", !1), n.Container = function(t, i, r, u, f, e, o) {
                function a(n, t, i, r) {
                    var u = [];
                    return zot(n) ? u = [n, t, i, r] : zot(t) ? n.x ? u = [n.x, n.y, n.width, n.height] : (u[0] = 0, u[1] = 0, u[2] = n, u[3] = n) : zot(i) ? (u[0] = 0, u[1] = 0, u[2] = n, u[3] = t) : (u[0] = n, u[1] = t, u[2] = i, u[3] = r), zot(u[3]) && (u[3] = u[2]), u
                }
                var l, s, h, c, v;
                if (l = zob(n.Container, arguments, "a, b, c, d, style, group, inherit", this)) return l;
                n.containerCheck || (z_d("50.5"), z_d("50.435"), n.containerCheck = !0);
                this.cjsContainer_constructor();
                this.type = "Container";
                this.group = e;
                s = this;
                h = f === !1 ? {} : n.getStyle(this.type, this.group, o);
                zot(t) && (t = h.a != null ? h.a : null);
                zot(i) && (i = h.b != null ? h.b : null);
                zot(r) && (r = h.c != null ? h.c : null);
                zot(u) && (u = h.d != null ? h.d : null);
                c = a(t, i, r, u);
                zot(t) || this.setBounds(c[0], c[1], c[2], c[3]);
                this.cache = function(n, t, i, r, u, f, e, o, h) {
                    var a, v, c, l;
                    return s.type == "AC" && WW.zdf ? (WW.zdf.ac("cache", arguments, s), s) : (a = "a,b,c,d,scale,options,margin,rtl,willReadFrequently", v = zob(s.cache, arguments, a)) ? v : (c = s.getBounds(), zot(i) && (zot(n) ? zot(c) || (l = s.borderWidth > 0 ? s.borderWidth / 2 : 0, n = c.x - l, t = c.y - l, i = c.width + l * 2, r = c.height + l * 2) : (i = n, r = t, n = 0, t = 0)), s.type == "Triangle" && (n -= s.borderWidth ? s.borderWidth : 0, i += s.borderWidth ? s.borderWidth * 2 : 0, t -= s.borderWidth ? s.borderWidth : 0, r += s.borderWidth ? s.borderWidth * 2 : 0), zot(e) && (e = 0), s.cjsContainer_cache(n - e, t - e, i + e * 2, r + e * 2, u, f, o, h), c && s.setBounds(c.x, c.y, c.width, c.height), s.z_bc = s.cacheCanvas, s)
                };
                this.uncache = function() {
                    return s.cjsContainer_uncache(), s
                };
                this.childrenToBitmap = function() {
                    var t = this.cacheCanvas,
                        i = new n.Bitmap(this.cache().cacheCanvas);
                    return t || this.uncache(), this.removeAllChildren(), i.addTo(this), this
                };
                v = WW.zdf || 1;
                createjs && !createjs.stageTransformable && v.retina && (this.localToGlobal = function(t, i) {
                    return n.localToGlobal(t, i, this, this.cjsContainer_localToGlobal)
                }, this.globalToLocal = function(t, i) {
                    return n.globalToLocal(t, i, this, this.cjsContainer_globalToLocal)
                }, this.localToLocal = function(t, i, r) {
                    return n.localToLocal(t, i, r, this)
                });
                this.setBounds = function(n, t, i, r) {
                    var u = a(n, t, i, r);
                    return s.cjsContainer_setBounds(u[0], u[1], u[2], u[3]), s
                };
                this.getBounds = function(n) {
                    return n ? s.boundsToGlobal(null, null, null, n) : s.cjsContainer_getBounds()
                };
                this.disposeAllChildren = function() {
                    for (var t, n = this.numChildren - 1; n >= 0; n--) t = this.getChildAt(n), t.dispose && t.dispose();
                    return this
                };
                n.displayBase(s);
                f !== !1 && n.styleTransforms(this, h);
                this.clone = function(t) {
                    if (this.type == "AC" && WW.zdf) return zon && zogy("ZIM asset() - cannot clone lazy-loaded asset - use Frame() assets parameter or loadAssets() method"), WW.zdf.ac("clone", arguments, this), this;
                    var i = this.getBounds();
                    return zot(i) && (i = {
                        x: null,
                        y: null,
                        width: null,
                        height: null
                    }), this.cloneChildren(this.cloneProps(new n.Container(i.x, i.y, i.width, i.height, f, this.group, o)), t)
                };
                this.hasProp = function(n) {
                    return !zot(this[n]) || Object.prototype.hasOwnProperty.call(this, n)
                }
            }, n.Container.prototype.dispose = function(n) {
                return h(this, n), !0
            }, n.Container.prototype.specialColor = function(n, t, i) {
                var o, s, r;
                if (t.type == "GradientColor") {
                    if (!zot(t.angle))
                        if (i.width)
                            if (r = i.getBounds(), t.angle += 36e6, t.angle %= 360, i.type == "Circle") o = r.width / 2 * Math.cos(t.angle * RAD), s = r.width / 2 * Math.sin(t.angle * RAD), t.x0 = -o, t.y0 = -s, t.x1 = o, t.y1 = s;
                            else {
                                var u = t.angle % 90,
                                    h = r.width * Math.sin(u * RAD),
                                    f = h * Math.sin(u * RAD),
                                    e = -h * Math.cos(u * RAD),
                                    c = r.height * Math.sin(u * RAD),
                                    l = r.width + c * Math.cos(u * RAD),
                                    a = c * Math.sin(u * RAD),
                                    v = r.height * Math.sin(u * RAD),
                                    y = -v * Math.cos(u * RAD),
                                    p = r.height - v * Math.sin(u * RAD);
                                t.angle >= 0 && t.angle < 90 ? (t.x0 = r.x + f, t.y0 = r.y + e, t.x1 = r.x + l, t.y1 = r.y + a) : t.angle >= 90 && t.angle < 180 ? (t.x0 = r.x + f, t.y0 = r.y + e, t.x1 = r.x + y, t.y1 = r.y + p) : t.angle >= 180 && t.angle < 270 ? (t.x0 = r.x + l, t.y0 = r.y + a, t.x1 = r.x + f, t.y1 = r.y + e) : (t.x0 = r.x + y, t.y0 = r.y + p, t.x1 = r.x + f, t.y1 = r.y + e)
                            }
                    else {
                        n.style = t.colors[0];
                        return
                    }
                    n.linearGradient(t.colors, t.ratios, t.x0, t.y0, t.x1, t.y1)
                } else if (t.type == "RadialColor") {
                    if (zot(t.x0))
                        if (i.width) r = i.getBounds(), t.r0 = 0, i.type == "Circle" ? (t.x0 = 0, t.y0 = 0, t.r1 = r.width / 2) : (t.x0 = r.x + r.width / 2, t.y0 = r.y + r.height / 2, t.r1 = Math.sqrt(Math.pow(r.width / 2, 2) + Math.pow(r.height / 2, 2))), t.x1 = t.x0, t.y1 = t.y0;
                        else {
                            n.style = t.colors[0];
                            return
                        }
                    n.radialGradient(t.colors, t.ratios, t.x0, t.y0, t.r0, t.x1, t.y1, t.r1)
                } else t.type == "BitmapColor" && n.bitmap(t.image, t.repetition, t.matrix)
            }, n.extend(n.Container, createjs.Container, ["cache", "uncache", "setBounds", "getBounds", "clone", "localToLocal", "localToGlobal", "globalToLocal"], "cjsContainer", !1), zimify(n.Container.prototype), n.Shape = function(t, i, r, u, f, e, o, s, h) {
                function w(n, t, i, r) {
                    var u = [];
                    return zot(n) ? u = [n, t, i, r] : zot(t) ? n.x ? u = [n.x, n.y, n.width, n.height] : (u[0] = 0, u[1] = 0, u[2] = n, u[3] = n) : zot(i) ? (u[0] = 0, u[1] = 0, u[2] = n, u[3] = t) : (u[0] = n, u[1] = t, u[2] = i, u[3] = r), zot(u[3]) && (u[3] = u[2]), u
                }
                var p, l, c, a, v, y, b;
                if (p = zob(n.Shape, arguments, "a, b, c, d, graphics, optimize, style, group, inherit", this)) return p;
                if (z_d("50.6"), this.cjsShape_constructor(f), this.type = "Shape", this.group = s, l = o === !1 ? {} : n.getStyle(this.type, this.group, h), c = this, zot(t) && (t = l.a != null ? l.a : null), zot(i) && (i = l.b != null ? l.b : null), zot(r) && (r = l.c != null ? l.c : null), zot(u) && (u = l.d != null ? l.d : null), zot(f) && (f = l.graphics != null ? l.graphics : null), zot(e) && (e = l.optimize != null ? l.optimize : !1), a = w(t, i, r, u), zot(t) || this.setBounds(a[0], a[1], a[2], a[3]), !e)
                    for (v = ["mt", "lt", "a", "at", "bt", "ct", "qt", "cp", "c", "f", "lf", "rf", "bf", "ef", "ss", "sd", "s", "ls", "rs", "bs", "es", "dr", "rr", "rc", "dc", "de", "dp", "pg", "p"], y = 0; y < v.length; y++) ~ function() {
                        var n = y;
                        c[v[n]] = function() {
                            return v[n] == "ct" ? c.graphics.curveTo.apply(c.graphics, arguments) : c.graphics[v[n]].apply(c.graphics, arguments), c
                        }
                    }();
                Object.defineProperty(c, "command", {
                    get: function() {
                        return c.graphics.command
                    },
                    set: function() {}
                });
                this.cache = function(n, t, i, r, u, f, e, o, s) {
                    var a, h, l;
                    return (a = zob(c.cache, arguments, "a,b,c,d,scale,options,margin,rtl,willReadFrequently")) ? a : (h = c.getBounds(), zot(i) && (zot(n) ? zot(h) || (l = c.borderWidth > 0 ? c.borderWidth / 2 : 0, n = h.x - l, t = h.y - l, i = h.width + l * 2, r = h.height + l * 2) : (i = n, r = t, n = 0, t = 0)), zot(e) && (e = 0), c.cjsShape_cache(n - e, t - e, i + e * 2, r + e * 2, u, f, o, s), c.z_bc = c.cacheCanvas, c)
                };
                this.setBounds = function(n, t, i, r) {
                    var u = w(n, t, i, r);
                    return this.cjsShape_setBounds(u[0], u[1], u[2], u[3]), this
                };
                this.getBounds = function(n) {
                    return n ? c.boundsToGlobal(null, null, null, n) : c.cjsShape_getBounds()
                };
                o !== !1 && n.styleTransforms(this, l);
                this.clone = function(t) {
                    var i, r;
                    return zot(t) && (t = !0), i = this.getBounds(), zot(i) && (i = {
                        x: null,
                        y: null,
                        width: null,
                        height: null
                    }), r = c.cloneProps(new n.Shape(i.x, i.y, i.width, i.height, f, o, s, h)), r.graphics = t ? c.graphics.clone() : c.graphics, r
                };
                b = WW.zdf || 1;
                createjs && !createjs.stageTransformable && b.retina && (this.localToGlobal = function(t, i) {
                    return n.localToGlobal(t, i, this, this.cjsShape_localToGlobal)
                }, this.globalToLocal = function(t, i) {
                    return n.globalToLocal(t, i, this, this.cjsShape_globalToLocal)
                }, this.localToLocal = function(t, i, r) {
                    return n.localToLocal(t, i, r, this)
                });
                this.hasProp = function(n) {
                    return !zot(this[n]) || Object.prototype.hasOwnProperty.call(this, n)
                };
                n.displayBase(c);
                this.dispose = function() {
                    n.gD(this);
                    this.graphics.c();
                    this.dispatchEvent("removed");
                    this.removeAllEventListeners();
                    this.parent && this.parent.removeChild(this)
                }
            }, n.extend(n.Shape, createjs.Shape, ["cache", "clone", "setBounds", "getBounds", "localToLocal", "localToGlobal", "globalToLocal"], "cjsShape", !1), zimify(n.Shape.prototype), n.Bitmap = function(t, i, r, u, f, e, o, s, h) {
                function d(n, t, i, r) {
                    var u = [];
                    return zot(n) ? u = [n, t, i, r] : zot(t) ? n.x ? u = [n.x, n.y, n.width, n.height] : (u[0] = 0, u[1] = 0, u[2] = n, u[3] = n) : zot(i) ? (u[0] = 0, u[1] = 0, u[2] = n, u[3] = t) : (u[0] = n, u[1] = t, u[2] = i, u[3] = r), zot(u[3]) && (u[3] = u[2]), u
                }
                var b, l, y, p, k, w, c, a, v;
                if (b = zob(n.Bitmap, arguments, "image, width, height, left, top, scale, style, group, inherit", this)) return b;
                z_d("50.7");
                this.group = s;
                l = o === !1 ? {} : n.getStyle("Bitmap", this.group, h);
                zot(e) && (e = l.scale != null ? l.scale : 1);
                zot(i) && (i = l.width != null ? l.width : t ? t.width : 100);
                zot(r) && (r = l.height != null ? l.height : t ? t.height : 100);
                zot(u) && (u = l.left != null ? l.left : 0);
                zot(f) && (f = l.top != null ? l.top : 0);
                y = !1;
                p = t;
                zot(t) || t.uncache && (y = !0, k = t.cacheCanvas, w = t, this.z_bc = t = t.cache(u, f, i, r, e).cacheCanvas);
                this.cjsBitmap_constructor(t);
                w && !k && w.uncache();
                c = this;
                this.type = "Bitmap";
                zot(i) || zot(r) || this.setBounds(0, 0, i, r);
                this.drawImageData = function(n, u, f, e, o, s) {
                    if (zot(n) && (n = 0), zot(u) && (u = 0), zot(f) && (f = 0), zot(e) && (e = 0), zot(o) && (o = i), zot(s) && (s = r), !c.proxyCanvas) {
                        var h = c.proxyCanvas = document.createElement("canvas");
                        h.setAttribute("width", i);
                        h.setAttribute("height", r);
                        c.proxyContext = h.getContext("2d");
                        t = p = c.image = h
                    }
                    c.proxyContext && c.proxyContext.putImageData(c.imageData, n, u, f, e, o, s)
                };
                WW.zdf && (this.imageData = WW.zdf.canvas.getContext("2d") ? WW.zdf.canvas.getContext("2d").createImageData(i, r) : document.createElement("canvas").getContext("2d").createImageData(i, r), zot(t) && c.drawImageData(), t && t.match && t.match(/data:image/i) && setTimeout(function() {
                    c.stage && c.stage.update();
                    setTimeout(function() {
                        c.stage && c.stage.update()
                    }, 50)
                }, 50));
                t && t.nodeName && t.nodeName.toLowerCase() != "video" && (c.sourceRect = y ? {
                    x: 0,
                    y: 0,
                    width: i * e,
                    height: r * e
                } : {
                    x: u,
                    y: f,
                    width: i,
                    height: r
                });
                this.setBounds = function(n, t, i, r) {
                    var u = d(n, t, i, r);
                    return c.cjsBitmap_setBounds(u[0], u[1], u[2], u[3]), c
                };
                this.getBounds = function(n) {
                    return n ? c.boundsToGlobal(null, null, null, n) : c.cjsBitmap_getBounds()
                };
                this.cache = function(n, t, i, r, u, f, e, o) {
                    var l, s, h;
                    return (l = zob(c.cache, arguments, "a,b,c,d,scale,options,rtl,willReadFrequently")) ? l : (zot(i) && (zot(n) ? (s = this.getBounds(), zot(s) || (h = this.borderWidth > 0 ? this.borderWidth / 2 : 0, n = s.x - h, t = s.y - h, i = s.width + h * 2, r = s.height + h * 2)) : (i = n, r = t, n = 0, t = 0)), s = c.getBounds(), c.cjsBitmap_cache(n, t, i, r, u, f, e, o), c.setBounds(s.x, s.y, s.width, s.height), c.z_bc = c.cacheCanvas, c)
                };
                this.clone = function() {
                    var t = this.cloneProps(new n.Bitmap(p, i, r, u, f, e, o, this.group, h));
                    return t.cloned = !0, t.src = c.src, t.file = c.file, t.image = c.image, t.svg = c.svg, t.item = c.item, t
                };
                a = WW.zdf || 1;
                createjs && !createjs.stageTransformable && a.retina && (this.localToGlobal = function(t, i) {
                    return n.localToGlobal(t, i, this, this.cjsBitmap_localToGlobal)
                }, this.globalToLocal = function(t, i) {
                    return n.globalToLocal(t, i, this, this.cjsBitmap_globalToLocal)
                }, this.localToLocal = function(t, i, r) {
                    return n.localToLocal(t, i, r, this)
                });
                this.hasProp = function(n) {
                    return !zot(this[n]) || Object.prototype.hasOwnProperty.call(this, n)
                };
                this.getColorAt = function(n, t, i) {
                    v || (c.cache(null, null, null, null, null, null, null, !0), v = c.cacheCanvas.getContext("2d"), c.uncache());
                    var r = v.getImageData(n, t, 1, 1).data;
                    return (r[3] /= 255, i) ? r : "rgba(" + r[0] + "," + r[1] + "," + r[2] + "," + r[3] + ")"
                };
                this.keyOut = function(t, e, o) {
                    zot(t) && (t = "#389b26");
                    zot(e) && (e = .1);
                    Array.isArray(t) || (t = [t]);
                    Array.isArray(e) || (e = [e]);
                    zot(o) || Array.isArray(o) || (o = [o]);
                    for (var s, l = [], a = [], p = [], h = 0; h < t.length; h++) l[h] = n.convertColor(t[h], "array"), a[h] = e[h] != null ? e[h] * 255 : e[0] * 255, o && (o[h] != null ? (p[h] = n.convertColor(o[h], "array"), p[h][3] *= 255) : (p[h] = n.convertColor(o[0], "array"), p[h][3] *= 255));
                    c.cacheCanvas && c.updateCache();
                    v || (c.cache(null, null, null, null, null, null, null, !0), v = c.cacheCanvas.getContext("2d"));
                    var d = v.getImageData(u, f, i, r),
                        y = d.data,
                        g = y.length / 4;
                    if (o)
                        for (h = 0; h < g; h++) {
                            var w = y[h * 4 + 0],
                                b = y[h * 4 + 1],
                                k = y[h * 4 + 2];
                            for (s = 0; s < t.length; s++) w > l[s][0] - a[s] && w < l[s][0] + a[s] && b > l[s][1] - a[s] && b < l[s][1] + a[s] && k > l[s][2] - a[s] && k < l[s][2] + a[s] && (y[h * 4 + 0] = p[s][0], y[h * 4 + 1] = p[s][1], y[h * 4 + 2] = p[s][2], y[h * 4 + 3] = p[s][3])
                        } else
                            for (h = 0; h < g; h++) {
                                var w = y[h * 4 + 0],
                                    b = y[h * 4 + 1],
                                    k = y[h * 4 + 2];
                                for (s = 0; s < t.length; s++) w > l[s][0] - a[s] && w < l[s][0] + a[s] && b > l[s][1] - a[s] && b < l[s][1] + a[s] && k > l[s][2] - a[s] && k < l[s][2] + a[s] && (y[h * 4 + 3] = 0)
                            }
                    return v.putImageData(d, f, u), this
                };
                n.displayBase(c);
                o !== !1 && n.styleTransforms(this, l);
                this.doDispose = function() {
                    n.gD(this);
                    this.dispatchEvent("removed");
                    this.removeAllEventListeners();
                    this.cloned || this.id && (a = this.stage && this.stage.frame ? this.stage.frame : WW.zdf, a && a.assets && a.assets[this.id] && delete a.assets[this.id], n.assets[this.id] && delete n.assets[this.id]);
                    this.parent && this.parent.removeChild(this)
                }
            }, n.Bitmap.fromData = function(t, i) {
                var u = 100,
                    f = 100,
                    r = new Image;
                r.onload = function() {
                    u = r.naturalWidth;
                    f = r.naturalHeight;
                    zot(u) && (u = r.width);
                    zot(f) && (f = r.height);
                    var e = new n.Bitmap(t, u, f);
                    setTimeout(function() {
                        i(e)
                    }, 50)
                };
                r.src = t
            }, n.extend(n.Bitmap, createjs.Bitmap, ["cache", "clone", "dispose", "setBounds", "getBounds", "localToLocal", "localToGlobal", "globalToLocal"], "cjsBitmap", !1), n.Bitmap.prototype.dispose = function() {
                return this.doDispose()
            }, zimify(n.Bitmap.prototype), n.Sprite = function(i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt) {
                function yt(t, i, r) {
                    Array.isArray(t) || (t = [t]);
                    n.loop(t, function(n, i) {
                        t[i] = n.image
                    });
                    var u = {
                        images: t,
                        frames: i,
                        animations: r ? r : []
                    };
                    ft = new createjs.SpriteSheet(u)
                }

                function dt(n, t, i, r) {
                    var u = [];
                    return zot(n) ? u = [n, t, i, r] : zot(t) ? n.x ? u = [n.x, n.y, n.width, n.height] : (u[0] = 0, u[1] = 0, u[2] = n, u[3] = n) : zot(i) ? (u[0] = 0, u[1] = 0, u[2] = n, u[3] = t) : (u[0] = n, u[1] = t, u[2] = i, u[3] = r), zot(u[3]) && (u[3] = u[2]), u
                }
                var pt, it, tt, ft, lt, at, k, et, ot, rt, vt, ct, st, ut;
                if (pt = zob(n.Sprite, arguments, "image, cols, rows, count, offsetX, offsetY, spacingX, spacingY, width, height, animations, json, id, globalControl, spriteSheet, label, frame, style, group, inherit", this)) return pt;
                if (z_d("50.8"), this.type = "Sprite", this.group = g, it = d === !1 ? {} : n.getStyle(this.type, this.group, nt), tt = this, zot(k) && (k = it.frame != null ? it.frame : WW.zdf), i && typeof i == "string" && (i = k.asset(i)), zot(v) && !zot(i)) {
                    zot(r) && (r = it.cols != null ? it.cols : 1);
                    zot(u) && (u = it.rows != null ? it.rows : 1);
                    zot(f) && (f = it.count != null ? it.count : r * u);
                    zot(e) && (e = it.offsetX != null ? it.offsetX : 0);
                    zot(o) && (o = it.offsetY != null ? it.offsetY : 0);
                    zot(s) && (s = it.spacingX != null ? it.spacingX : 0);
                    zot(h) && (h = it.spacingY != null ? it.spacingY : 0);
                    zot(c) && (c = it.width != null ? it.width : i.width);
                    zot(l) && (l = it.height != null ? it.height : i.height);
                    i.bitmap && (i = i.bitmap);
                    var wt = (c - e + s) / r - s,
                        bt = (l - o + h) / u - h,
                        ht = [],
                        kt = 0;
                    n: for (lt = 0; lt < u; lt++)
                        for (at = 0; at < r; at++) {
                            if (++kt > f) break n;
                            ht.push([e + at * (wt + s), o + lt * (bt + h), wt, bt])
                        }
                    yt(i, ht, a)
                } else if (w) ft = w, a = ft.animations;
                else if (v) {
                    if (k = tt.stage ? tt.stage.frame : WW.zdf, typeof v == "string" && (v = k.asset(v)), v.frames && !Array.isArray(v.frames)) {
                        et = [];
                        for (ot in v.frames) rt = v.frames[ot].frame, et.push([rt.x, rt.y, rt.w, rt.h]);
                        v.frames = et
                    }
                    if (v.frames && !Array.isArray(v.frames[0])) {
                        for (et = [], ot = 0; ot < v.frames.length; ot++) rt = v.frames[ot].frame, et.push([rt.x, rt.y, rt.w, rt.h]);
                        v.frames = et
                    }!v.images && v.meta && v.meta.image && (v.images = [v.meta.image]);
                    ht = v.frames;
                    a = v.animations;
                    zot(i) ? (vt = v.images ? v.images[0] : null, vt && vt.split ? (ct = [], n.loop(v.images, function(n) {
                        var t = n.split("/").pop();
                        k.asset(t) && k.asset(t).type != "EmptyAsset" ? ct.push(k.asset(t)) : k.asset(n) && k.asset(n).type != "EmptyAsset" ? ct.push(k.asset(n)) : k.asset(n).type != "EmptyAsset" ? ct.push(k.asset(n)) : zon && zogy("Sprite() - please preload Sprite in Frame or with loadAssets")
                    }), yt(ct, ht, a)) : ft = new createjs.SpriteSheet(v)) : yt(i, ht, a)
                } else return;
                this.animations = a;
                this.cjsSprite_constructor(ft, b);
                zot(b) || this.stop();
                zot(y) && (y = n.makeID());
                this.id = y;
                zot(p) && (p = !0);
                tt.globalControl = p;
                st = 0;
                this.parseFrames = function(t, i, r, u) {
                    function l(n) {
                        Array.isArray(n) ? w(n) : n.constructor == {}.constructor ? b(n) : isNaN(n) || o.push({
                            f: Math.floor(n),
                            s: 1
                        })
                    }

                    function w(n) {
                        y(n[0], n[1], n[3]);
                        n[2] && !zot(tt.animations[n[2]]) && l(tt.animations[n[2]])
                    }

                    function b(n) {
                        if (!zot(n.frames)) {
                            zot(n.speed) && (n.speed = 1);
                            for (var t = 0; t < n.frames.length; t++) n.speed < f && (f = n.speed), n.speed > e && (e = n.speed), o.push({
                                f: n.frames[t],
                                s: n.speed
                            });
                            n.next && !zot(tt.animations[n.next]) && l(tt.animations[n.next])
                        }
                    }

                    function y(n, t, i) {
                        function u(n) {
                            i < f && (f = i);
                            i > e && (e = i);
                            o.push({
                                f: n,
                                s: i
                            })
                        }
                        zot(i) && (i = 1);
                        var r;
                        if (t > n)
                            for (r = n; r <= t; r++) u(r);
                        else
                            for (r = t; r <= n; r++) u(n - (r - t))
                    }
                    var o = [],
                        f = Number.MAX_VALUE,
                        e = 0,
                        v, h, p, s, c, a;
                    if (zot(t)) zot(i) && (i = 0), zot(r) && (r = tt.totalFrames - 1), y(i, r);
                    else {
                        if (zot(tt.animations) || zot(tt.animations[t])) return [];
                        v = tt.animations[t];
                        l(v)
                    }
                    if (u) return o;
                    for (f = n.constrain(n.decimals(f), .1), e = n.constrain(n.decimals(e), .1), h = [], p = f != e, c = 0; c < o.length; c++)
                        if (s = o[c], p)
                            for (a = 0; a < n.constrain(Math.round(f < 1 ? s.s / f : s.s), .1); a++) h.push(s.f);
                        else h.push(s.f);
                    return h
                };
                this.run = function(i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, it, rt, ft, et, ot, ht, ct, lt, at) {
                    function ti() {
                        ut = tt.parseFrames(r, et, ot);
                        st = 0;
                        tt.gotoAndStop(ut[st]);
                        et = ot = null;
                        pt = {
                            normalizedFrame: ut.length - 1
                        }
                    }
                    var bt, kt, pt, yt, vt, dt, gt, wt, ni, ii;
                    if (bt = zob(tt.run, arguments, "time, label, call, params, wait, waitedCall, waitedParams, loop, loopCount, loopWait, loopCall, loopParams, loopWaitCall, loopWaitParams, loopPick, rewind, rewindWait, rewindCall, rewindParams, rewindWaitCall, rewindWaitParams, rewindTime, rewindEase, startFrame, endFrame, tweek, id, globalControl, pauseOnBlur")) return bt;
                    if (kt = t(), zot(ht) && (ht = 1), zot(ct) || (tt.id = ct), zot(lt) || (tt.globalControl = lt), Array.isArray(r)) {
                        for (pt = [], yt = 0, wt = 0; wt < r.length; wt++) vt = r[wt], vt.lookup = tt.parseFrames(vt.label, vt.startFrame, vt.endFrame), wt == 0 && (gt = vt.lookup[0]), delete vt.startFrame, delete vt.endFrame, vt.obj = n.merge(vt.obj, {
                            normalizedFrame: vt.lookup.length - 1
                        }), vt.set = n.merge(vt.set, {
                            normalizedFrames: {
                                noPick: vt.lookup
                            },
                            normalizedFrame: 0
                        }), zot(vt.wait) && (vt.wait = yt * ht), dt = vt.label, delete vt.label, pt.push(vt), yt = 0, ni = zot(vt.time) ? i : vt.time, ot - et > 0 && (yt = ni / (ot - et) / 2);
                        if (pt.length == 0) return this;
                        pt.length == 1 ? (i = pt[0].time, r = dt, ti()) : tt.gotoAndStop(gt)
                    } else ti();
                    return zot(i) && (i = kt == "s" ? 1 : 1e3), tt.running && tt.stopAnimate(tt.id), tt.running = !0, Array.isArray(pt) || (yt = 0, ot - et > 0 && (yt = i / Math.abs(ot - et) / 2), ut && ut.length > 0 && (yt = i / ut.length / 2), zot(l) && (l = yt * ht), zot(k) && (k = yt * ht)), ii = function() {
                        tt.running = !1;
                        tt.stop();
                        u && typeof u == "function" && u(f || tt)
                    }, n.animate({
                        target: tt,
                        obj: pt,
                        time: i,
                        ease: "linear",
                        call: ii,
                        params: f,
                        wait: e,
                        waitedCall: o,
                        waitedParams: s,
                        loop: h,
                        loopCount: c,
                        loopWait: l,
                        loopCall: a,
                        loopParams: v,
                        loopWaitCall: y,
                        loopWaitParams: p,
                        rewind: b,
                        rewindWait: k,
                        rewindCall: d,
                        rewindParams: g,
                        rewindWaitCall: nt,
                        rewindWaitParams: it,
                        rewindTime: rt,
                        rewindEase: ft,
                        override: !1,
                        pauseOnBlur: at,
                        id: tt.id
                    }), tt.runPaused = !1, tt
                };
                this.runPaused = !0;
                this.pauseRun = function(t) {
                    return zot(t) && (t = !0), tt.runPaused = t, tt.globalControl ? n.pauseAnimate(t, tt.id) : tt.pauseAnimate(t, tt.id), tt
                };
                this.stopRun = function() {
                    return tt.runPaused = !0, tt.running = !1, tt.globalControl ? n.stopAnimate(tt.id) : tt.stopAnimate(tt.id), tt
                };
                Object.defineProperty(this, "frame", {
                    get: function() {
                        return this.currentFrame
                    },
                    set: function(n) {
                        n = Math.round(n);
                        this.paused ? this.gotoAndStop(n) : this.gotoAndPlay(n)
                    }
                });
                Object.defineProperty(this, "normalizedFrame", {
                    get: function() {
                        return st
                    },
                    set: function(n) {
                        st = Math.round(n);
                        this.gotoAndStop(ut[st])
                    }
                });
                Object.defineProperty(this, "normalizedFrames", {
                    get: function() {
                        return ut
                    },
                    set: function(n) {
                        ut = n
                    }
                });
                Object.defineProperty(this, "totalFrames", {
                    get: function() {
                        return ft.getNumFrames()
                    },
                    set: function() {
                        zogy("zim.Sprite - totalFrames is read only")
                    }
                });
                d !== !1 && n.styleTransforms(this, it);
                this.clone = function() {
                    var t = this.cloneProps(new n.Sprite(i, r, u, f, e, o, s, h, c, l, a, v, null, p, w, b, k, d, this.group, nt));
                    return tt.frame >= 0 && t.run({
                        startFrame: tt.frame,
                        endFrame: tt.frame
                    }), t
                };
                createjs && !createjs.stageTransformable && k.retina && (this.localToGlobal = function(t, i) {
                    return n.localToGlobal(t, i, this, this.cjsSprite_localToGlobal)
                }, this.globalToLocal = function(t, i) {
                    return n.globalToLocal(t, i, this, this.cjsSprite_globalToLocal)
                }, this.localToLocal = function(t, i, r) {
                    return n.localToLocal(t, i, r, this)
                });
                this.hasProp = function(n) {
                    return !zot(this[n]) || Object.prototype.hasOwnProperty.call(this, n)
                };
                n.displayBase(tt);
                this.setBounds = function(n, t, i, r) {
                    var u = dt(n, t, i, r);
                    return tt.cjsSprite_setBounds(u[0], u[1], u[2], u[3]), tt
                };
                this.getBounds = function(n) {
                    return n ? tt.boundsToGlobal(null, null, null, n) : tt.cjsSprite_getBounds()
                };
                this.dispose = function() {
                    n.gD(this);
                    this.dispatchEvent("removed");
                    this.removeAllEventListeners();
                    this.parent && this.parent.removeChild(this)
                }
            }, n.extend(n.Sprite, createjs.Sprite, ["clone", "setBounds", "getBounds", "localToLocal", "localToGlobal", "globalToLocal"], "cjsSprite", !1), zimify(n.Sprite.prototype), n.MovieClip = function(t, i, r, u, f, e, o) {
                function l(n, t, i, r) {
                    var u = [];
                    return zot(n) ? u = [n, t, i, r] : zot(t) ? n.x ? u = [n.x, n.y, n.width, n.height] : (u[0] = 0, u[1] = 0, u[2] = n, u[3] = n) : zot(i) ? (u[0] = 0, u[1] = 0, u[2] = n, u[3] = t) : (u[0] = n, u[1] = t, u[2] = i, u[3] = r), zot(u[3]) && (u[3] = u[2]), u
                }
                var h, s, c;
                if (h = zob(n.MovieClip, arguments, "mode, startPosition, loop, labels, style, group, inherit", this)) return h;
                z_d("50.9");
                this.type = "MovieClip";
                this.group = e;
                s = f === !1 ? {} : n.getStyle(this.type, this.group, o);
                zot(t) && (t = s.mode != null ? s.mode : null);
                zot(i) && (i = s.startPosition != null ? s.startPosition : null);
                zot(r) && (r = s.loop != null ? s.loop : null);
                zot(u) && (u = s.labels != null ? s.labels : null);
                this.cjsMovieClip_constructor(t, i, r, u);
                f !== !1 && n.styleTransforms(this, s);
                this.clone = function() {
                    return this.cloneProps(new n.MovieClip(t, i, r, u, f, this.group, o))
                };
                this.hasProp = function(n) {
                    return !zot(this[n]) || Object.prototype.hasOwnProperty.call(this, n)
                };
                c = WW.zdf || 1;
                createjs && !createjs.stageTransformable && c.retina && (this.localToGlobal = function(t, i) {
                    return n.localToGlobal(t, i, this, this.cjsMovieClip_localToGlobal)
                }, this.globalToLocal = function(t, i) {
                    return n.globalToLocal(t, i, this, this.cjsMovieClip_globalToLocal)
                }, this.localToLocal = function(t, i, r) {
                    return n.localToLocal(t, i, r, this)
                });
                n.displayBase(this);
                this.setBounds = function(n, t, i, r) {
                    var u = l(n, t, i, r);
                    return that.cjsMovieClip_setBounds(u[0], u[1], u[2], u[3]), that
                };
                this.getBounds = function(n) {
                    return n ? that.boundsToGlobal(null, null, null, n) : that.cjsMovieClip_getBounds()
                };
                this.dispose = function() {
                    n.gD(this);
                    this.dispatchEvent("removed");
                    this.removeAllEventListeners();
                    this.parent && this.parent.removeChild(this)
                }
            }, n.extend(n.MovieClip, createjs.MovieClip, ["clone", "setBounds", "getBounds", "localToLocal", "localToGlobal", "globalToLocal"], "cjsMovieClip", !1), zimify(n.MovieClip.prototype), n.SVGContainer = function(t, i, r, u, f, e, o, s) {
                function wt() {
                    function u(n, t) {
                        return s(n) || o(n, t) || e(n, t) || f()
                    }

                    function f() {
                        throw new TypeError("Invalid");
                    }

                    function e(n, t) {
                        if (n) {
                            if (typeof n == "string") return i(n, t);
                            var r = Object.prototype.toString.call(n).slice(8, -1);
                            return (r === "Object" && n.constructor && (r = n.constructor.name), r === "Map" || r === "Set") ? Array.from(n) : r === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r) ? i(n, t) : void 0
                        }
                    }

                    function i(n, t) {
                        (t == null || t > n.length) && (t = n.length);
                        for (var i = 0, r = new Array(t); i < t; i++) r[i] = n[i];
                        return r
                    }

                    function o(n, t) {
                        var i, o;
                        if (typeof Symbol != "undefined" && Symbol.iterator in Object(n)) {
                            var r = [],
                                u = !0,
                                f = !1,
                                e = undefined;
                            try {
                                for (i = n[Symbol.iterator](); !(u = (o = i.next()).done); u = !0)
                                    if (r.push(o.value), t && r.length === t) break
                            } catch (s) {
                                f = !0;
                                e = s
                            } finally {
                                try {
                                    u || i["return"] == null || i["return"]()
                                } finally {
                                    if (f) throw e;
                                }
                            }
                            return r
                        }
                    }

                    function s(n) {
                        if (Array.isArray(n)) return n
                    }
                    var n = Math.PI * 2,
                        t = function(n, t, i, r, u, f, e) {
                            var o = n.x,
                                s = n.y,
                                h, c;
                            return o *= t, s *= i, h = r * o - u * s, c = u * o + r * s, {
                                x: h + f,
                                y: c + e
                            }
                        },
                        h = function(n, t) {
                            var i = t === 1.5707963267948966 ? .551915024494 : t === -1.5707963267948966 ? -.551915024494 : 4 / 3 * Math.tan(t / 4),
                                f = Math.cos(n),
                                e = Math.sin(n),
                                r = Math.cos(n + t),
                                u = Math.sin(n + t);
                            return [{
                                x: f - e * i,
                                y: e + f * i
                            }, {
                                x: r + u * i,
                                y: u - r * i
                            }, {
                                x: r,
                                y: u
                            }]
                        },
                        r = function(n, t, i, r) {
                            var f = n * r - t * i < 0 ? -1 : 1,
                                u = n * i + t * r;
                            return u > 1 && (u = 1), u < -1 && (u = -1), f * Math.acos(u)
                        },
                        c = function(t, i, u, f, e, o, s, h, c, l, a, v) {
                            var k = Math.pow(e, 2),
                                d = Math.pow(o, 2),
                                g = Math.pow(a, 2),
                                nt = Math.pow(v, 2),
                                y = k * d - k * nt - d * g;
                            y < 0 && (y = 0);
                            y /= k * nt + d * g;
                            y = Math.sqrt(y) * (s === h ? -1 : 1);
                            var w = y * e / o * v,
                                b = y * -o / e * a,
                                rt = l * w - c * b + (t + u) / 2,
                                ut = c * w + l * b + (i + f) / 2,
                                tt = (a - w) / e,
                                it = (v - b) / o,
                                ft = (-a - w) / e,
                                et = (-v - b) / o,
                                ot = r(1, 0, tt, it),
                                p = r(tt, it, ft, et);
                            return h === 0 && p > 0 && (p -= n), h === 1 && p < 0 && (p += n), [rt, ut, ot, p]
                        };
                    return function(i) {
                        var v = i.px,
                            y = i.py,
                            p = i.cx,
                            w = i.cy,
                            r = i.rx,
                            f = i.ry,
                            rt = i.xAxisRotation,
                            ut = rt === void 0 ? 0 : rt,
                            ft = i.largeArcFlag,
                            ht = ft === void 0 ? 0 : ft,
                            et = i.sweepFlag,
                            ct = et === void 0 ? 0 : et,
                            ot = [],
                            s, tt, it;
                        if (r === 0 || f === 0) return [];
                        var e = Math.sin(ut * n / 360),
                            o = Math.cos(ut * n / 360),
                            b = o * (v - p) / 2 + e * (y - w) / 2,
                            k = -e * (v - p) / 2 + o * (y - w) / 2;
                        if (b === 0 && k === 0) return [];
                        r = Math.abs(r);
                        f = Math.abs(f);
                        s = Math.pow(b, 2) / Math.pow(r, 2) + Math.pow(k, 2) / Math.pow(f, 2);
                        s > 1 && (r *= Math.sqrt(s), f *= Math.sqrt(s));
                        var lt = c(v, y, p, w, r, f, ht, ct, e, o, b, k),
                            l = u(lt, 4),
                            d = l[0],
                            g = l[1],
                            st = l[2],
                            a = l[3],
                            nt = Math.abs(a) / (n / 4);
                        for (Math.abs(1 - nt) < 1e-7 && (nt = 1), tt = Math.max(Math.ceil(nt), 1), a /= tt, it = 0; it < tt; it++) ot.push(h(st, a)), st += a;
                        return ot.map(function(n) {
                            var i = t(n[0], r, f, o, e, d, g),
                                h = i.x,
                                c = i.y,
                                u = t(n[1], r, f, o, e, d, g),
                                l = u.x,
                                a = u.y,
                                s = t(n[2], r, f, o, e, d, g),
                                v = s.x,
                                y = s.y;
                            return {
                                x1: h,
                                y1: c,
                                x2: l,
                                y2: a,
                                x: v,
                                y: y
                            }
                        })
                    }
                }

                function ft(t) {
                    n.loop(t, function(n) {
                        var t = n.tagName.toLowerCase(),
                            r, u, f, e, o, s, i;
                        t == "path" && pt(n);
                        t == "circle" && l("circle", n);
                        t == "rect" && l("rect", n);
                        t == "ellipse" && l("ellipse", n);
                        t == "line" && l("line", n);
                        t == "polygon" && l("polygon", n);
                        t == "polyline" && l("polyline", n);
                        t == "g" && (r = n.getAttribute("style"), r && (i = et(r), u = i[0], f = i[1], e = i[2], o = i[3], s = i[4]), a = n.getAttribute("transform"), k = n.getAttribute("fill") ? n.getAttribute("fill") : zot(u) ? ht : u, d = n.getAttribute("stroke") ? n.getAttribute("stroke") : zot(f) ? ct : f, g = n.getAttribute("stroke-width") ? n.getAttribute("stroke-width") : zot(e) ? lt : e, nt = n.getAttribute("fill-opacity") ? n.getAttribute("fill-opacity") : zot(o) ? at : o, tt = n.getAttribute("stroke-opacity") ? n.getAttribute("stroke-opacity") : zot(s) ? vt : s);
                        ft(n.children);
                        n.tagName.toLowerCase() == "g" && (k = ht, d = ct, g = lt, nt = at, tt = vt, a = null)
                    })
                }

                function et(t) {
                    var o = t.split(";"),
                        u, f, e, i, r;
                    return n.loop(o, function(n) {
                        n = n.replace(/,/g, "");
                        var s = n.split(":"),
                            o = s[0].trim().toLowerCase(),
                            t = s[1].trim().toLowerCase().replace("px", "");
                        o == "fill" && (u = t);
                        o == "stroke" && (f = t);
                        o == "stroke-width" && (e = t);
                        o == "opacity" && (i = t, r = t);
                        o == "fill-opacity" && (i = t);
                        o == "stroke-opacity" && (r = t)
                    }), [u, f, e, i, r]
                }

                function l(t, i) {
                    var e, b = yt(i),
                        c = b[0],
                        o = b[1],
                        s = b[2],
                        ut = b[5],
                        ft = b[6],
                        nt, it, k, d, h, g, rt, tt;
                    if (t == "circle") nt = Number(i.getAttribute("r").trim()), it = nt * .5523, e = r ? new n.Circle(Number(i.getAttribute("r")), c, o, s) : new n.Blob(c, o, s, 4, nt, it, "mirror", null, u, null, null, null, null, null, null, null, null, null, null, null, f);
                    else if (t == "rect")
                        if (r) e = new n.Rectangle(Number(i.getAttribute("width")), Number(i.getAttribute("height")), c, o, s, Number(i.getAttribute("rx")));
                        else {
                            var l = Number(i.getAttribute("width")),
                                y = Number(i.getAttribute("height")),
                                p = Number(i.getAttribute("rx")),
                                w = Number(i.getAttribute("ry"));
                            p && w ? (k = p * .5523, d = w * .5523, e = new n.Blob(c, o, s, [
                                [p, 0, 0, 0, -k, 0, 0, 0, "free"],
                                [l - p, 0, 0, 0, 0, 0, k, 0, "free"],
                                [l, w, 0, 0, 0, -d, 0, 0, "free"],
                                [l, y - w, 0, 0, 0, 0, 0, d, "free"],
                                [l - p, y, 0, 0, k, 0, 0, 0, "free"],
                                [p, y, 0, 0, 0, 0, -k, 0, "free"],
                                [0, y - w, 0, 0, 0, d, 0, 0, "free"],
                                [0, w, 0, 0, 0, 0, 0, -d, "free"]
                            ], null, null, null, null, u, null, null, null, null, null, null, null, null, null, null, null, f)) : e = new n.Blob(c, o, s, [
                                [0, 0],
                                [l, 0],
                                [l, y],
                                [0, y]
                            ], null, null, null, null, u, null, null, null, null, null, null, null, null, null, null, null, f)
                        }
                    else t == "line" ? e = new n.Squiggle(o, s, [
                        [Number(i.getAttribute("x1")), Number(i.getAttribute("y1"))],
                        [Number(i.getAttribute("x2")), Number(i.getAttribute("y2"))]
                    ], null, null, null, null, u, null, null, null, null, null, null, null, null, null, null, null, f) : t == "polygon" || t == "polyline" ? (h = i.getAttribute("points"), h = h.replace(/-/g, " -"), h = h.replace(/\s+/g, " "), g = [], h.indexOf(",") != -1 ? n.loop(h.split(" "), function(n) {
                        var t = n.split(",");
                        g.push([Number(t[0].trim()), Number(t[1].trim())])
                    }) : n.loop(h.split(" "), function(n, t) {
                        (t + 1) % 2 == 0 && g.push([rt, n.trim()]);
                        rt = n.trim()
                    }), e = t == "polygon" ? new Blob(c, o, s, g) : new n.Squiggle(o, s, g, null, null, null, null, u, null, null, null, null, null, null, null, null, null, null, null, f)) : t == "ellipse" && (e = new n.Blob(c, o, s, bt(0, 0, Number(i.getAttribute("rx")), Number(i.getAttribute("ry"))), null, null, null, null, u, null, null, null, null, null, null, null, null, null, null, null, f));
                    e.loc(ut, ft, v);
                    tt = i.getAttribute("transform");
                    (tt || a) && ot(e, tt || a);
                    f && (e.type == "Rectangle" || e.type == "Circle") && e.transform({
                        showReg: !1,
                        visible: u
                    })
                }

                function ot(t, i) {
                    var r = i.split(")");
                    n.loop(r, function(n) {
                        var e, i, r;
                        if (n != "") {
                            var o = n.trim().split("("),
                                u = o[0].trim().toLowerCase(),
                                f = o[1].trim().toLowerCase().replace("px", "").replace("deg", "");
                            u == "translate" && (e = f.split(","), t.mov(Number(e[0].trim()), e[1] ? Number(e[1].trim()) : 0));
                            u == "scale" && (i = f.split(","), t.type == "Blob" || t.type == "Squiggle" ? i.length == 1 ? t.transformPoints("scale", Number(i[0].trim())) : i.length == 2 && (t.transformPoints("scaleX", Number(i[0].trim())), t.transformPoints("scaleY", Number(i[1].trim()))) : i.length == 1 ? t.sca(Number(i[0].trim())) : i.length == 2 && t.sca(Number(i[0].trim()), Number(i[1].trim())));
                            u == "rotate" && (r = f.split(","), r.length == 1 ? r.push(0, 0) : r.length == 2 && r.push(0), t.rot(Number(r[0].trim()), Number(r[1].trim()), Number(r[2].trim())));
                            u == "skewX" && (t.skewX = f);
                            u == "skewY" && (t.skewY = f)
                        }
                    })
                }

                function bt(n, t, i, r) {
                    var s = .5522848,
                        u = i * s,
                        f = r * s,
                        e = n + i,
                        o = t + r;
                    return [
                        [n - i, t, 0, 0, n, o + f - r, n, t - f, "mirror"],
                        [n, t - r, 0, 0, n - u, t, e + u - i, t, "mirror"],
                        [e, t, 0, 0, n, t - f, n + u - u, o + f - r, "mirror"],
                        [n, o, 0, 0, e - i + u, t, n - u, t, "mirror"]
                    ]
                }

                function yt(t) {
                    var i, r, o, u, f, c = t.getAttribute("style"),
                        e, s, h;
                    return c && (e = et(c), i = e[0], r = e[1], o = e[2], u = e[3], f = e[4]), i = t.getAttribute("fill") ? t.getAttribute("fill") : zot(i) ? k : i, r = t.getAttribute("stroke") ? t.getAttribute("stroke") : zot(r) ? d : r, o = t.getAttribute("stroke-width") ? t.getAttribute("stroke-width") : zot(o) ? g : o, u = t.getAttribute("fill-opacity") ? t.getAttribute("fill-opacity") : zot(u) ? nt : u, f = t.getAttribute("stroke-opacity") ? t.getAttribute("stroke-opacity") : zot(f) ? tt : f, s = t.getAttribute("x") ? t.getAttribute("x") : 0, s = t.getAttribute("cx") ? t.getAttribute("cx") : s, h = t.getAttribute("y") ? t.getAttribute("y") : 0, h = t.getAttribute("cy") ? t.getAttribute("cy") : h, zot(u) || zot(i) || (i = n.convertColor(i, "rgba", Number(u))), zot(f) || zot(r) || (r = n.convertColor(r, "rgba", Number(f))), [i, r, Number(o), Number(u), Number(f), Number(s), Number(h)]
                }

                function pt(t, r) {
                    function p() {
                        nt = y[y.length - 1];
                        o.length >= 2 && (nt == "z" || nt == "Z") && (ht = "blob");
                        ft = ht == "squiggle" ? new n.Squiggle(ct, lt, o, null, null, null, null, u, null, null, null, null, null, null, null, null, null, null, null, f) : new n.Blob(bt, ct, lt, o, null, null, null, null, u, null, null, null, null, null, null, null, null, null, null, null, f);
                        ft.loc(0, 0, v);
                        nt = y[y.length - 1];
                        et = y[y.length - 2];
                        pt.indexOf(nt) >= 0 ? (rt[0] = o[o.length - 1][0], rt[1] = o[o.length - 1][1], h.x = o[o.length - 1][0], h.y = o[o.length - 1][1], o = [], o.push([rt[0], rt[1]])) : (rt = [0, 0], o = [
                            [0, 0]
                        ]);
                        y = [];
                        nt != "z" && nt != "Z" && y.push(nt);
                        s.x = 0;
                        s.y = 0;
                        var i = t.getAttribute("transform");
                        (i || a) && ot(ft, i || a)
                    }
                    zot(r) && (r = !0);
                    var vt = ["M", "m", "L", "l", "H", "h", "V", "v", "C", "c", "S", "s", "Q", "q", "T", "t", "A", "a", "z", "Z"],
                        pt = ["m", "l", "h", "v", "c", "s", "q", "t", "a", "z"],
                        s = new n.Point(0, 0),
                        g;
                    if (g = zot(t.getAttribute) ? t : t.getAttribute("d"), g = g.replace(/,/g, " "), g = g.replace(/([a-zA-Z])/g, " $1 "), g = g.replace(/-/g, " -"), g = g.replace(/\s+/g, " "), g = g.replace(/\.(\d*)\./g, ".$1 ."), r) var st = yt(t),
                        bt = st[0],
                        ct = st[1],
                        lt = st[2];
                    var ft, l, o = [],
                        rt = [0, 0],
                        tt = new n.Point(0, 0),
                        k = new n.Point(0, 0, 0, 0),
                        w = new n.Point(0, 0, 0, 0, 0, 0),
                        d = new n.Point(0, 0, 0, 0, 0, 0, 0),
                        at = g.split(" "),
                        kt = at.slice(1, at.length),
                        y = [],
                        ut = !1,
                        nt, et, it = !1,
                        e, ht = "squiggle",
                        c = null;
                    return n.loop(kt, function(t, r) {
                        var u, f;
                        r == 0 && (h.x = 0, h.y = 0, rt = [0, 0], nt = "", et = "");
                        vt.indexOf(t) == -1 ? (e == "lxo" && (e = "lx", y.push("l"), ut = !0), e == "lyo" && (e = "ly", ut = !0), e == "Lxo" && (e = "Lx", y.push("L"), ut = !0), e == "Lyo" && (e = "Ly", ut = !0), l = Number(t), l = Math.round(l * 100) / 100, e == "X" ? (h.x = l, e = "Y") : e == "Y" ? (h.y = l, e = "Lxo", o.push([h.x, h.y])) : e == "x" ? (h.x = h.x + l, e = "y") : e == "y" && (h.y = h.y + l, e = "lxo", o.push([h.x, h.y])), e == "H" || e == "h" ? (s.x = o[o.length - 1][0], s.y = o[o.length - 1][1], s.x = s.x + (e == "h" ? l : l - h.x), o.push([s.x, s.y]), e = "Lx") : (e == "V" || e == "v") && (s.x = o[o.length - 1][0], s.y = o[o.length - 1][1], s.y = s.y + (e == "v" ? l : l - h.y), o.push([s.x, s.y]), e = "lx"), e == "Lx" ? (tt.x = l, e = "Ly") : e == "Ly" ? (tt.y = l, s.x = tt.x, s.y = tt.y, o.push([s.x, s.y]), e = "Lx") : e == "lx" ? (y.length > 0 && (s.x != 0 && s.y != 0 ? (h.x = s.x, h.y = s.y) : (h.x = s.x + h.x, h.y = s.y + h.y)), tt.x = h.x + l, e = ut ? "lyo" : "ly") : e == "ly" && (tt.y = h.y + l, s.x = tt.x, s.y = tt.y, o.push([s.x, s.y]), e = "lx"), e == "qx" || e == "Qx" ? (o.length > 0 ? (h.x = o[o.length - 1][0], h.y = o[o.length - 1][1]) : (h.x = 0, h.y = 0), k.x = e == "qx" ? h.x + l : l, e = e == "qx" ? "qy" : "Qy") : e == "qy" || e == "Qy" ? (k.y = e == "qy" ? h.y + l : l, e = e == "qy" ? "qz" : "Qz", it && (it = !1, u = o[o.length - 1], u[6] = -u[4], u[7] = -u[5], u[8] = "mirror", s.x = k.x, s.y = k.y, o[o.length] = [s.x, s.y, 0, 0, -u[6], u[7], 0, 0, "free"], e = e == "qy" ? "qx" : "Qx")) : e == "qz" || e == "Qz" ? (k.z = e == "qz" ? h.x + l : l, e = e == "qz" ? "qq" : "Qq") : (e == "qq" || e == "Qq") && (k.w = e == "qq" ? h.y + l : l, u = o[o.length - 1], s.x = u[0], s.y = u[1], o.length == 1 ? (u[2] = 0, u[3] = 0, u[4] = 0, u[5] = 0, u[6] = 2 / 3 * (k.x - s.x), u[7] = 2 / 3 * (k.y - s.y), u[8] = "free") : o[o.length] = [s.x, s.y, 0, 0, 0, 0, 2 / 3 * (k.x - s.x), 2 / 3 * (k.y - s.y), "free"], s.x = k.z, s.y = k.w, o[o.length] = [s.x, s.y, 0, 0, 2 / 3 * (k.x - s.x), 2 / 3 * (k.y - s.y), 0, 0, "free"], e = e == "qq" ? "qx" : "Qx"), e == "cx" || e == "Cx" ? (o.length > 0 ? (h.x = o[o.length - 1][0], h.y = o[o.length - 1][1]) : (h.x = 0, h.y = 0), w.x = e == "cx" ? h.x + l : l, e = e == "cx" ? "cy" : "Cy") : e == "cy" || e == "Cy" ? (w.y = e == "cy" ? h.y + l : l, e = e == "cy" ? "cz" : "Cz") : e == "cz" || e == "Cz" ? (w.z = e == "cz" ? h.x + l : l, e = e == "cz" ? "cq" : "Cq") : e == "cq" || e == "Cq" ? (w.q = e == "cq" ? h.y + l : l, e = e == "cq" ? "cr" : "Cr", it && (et = nt == "s" ? "s" : "S", u = o[o.length - 1], u[2] = 0, u[3] = 0, zot(u[4]) && (u[4] = 0), zot(u[5]) && (u[5] = 0), u[6] = -u[4], u[7] = -u[5], u[8] = "mirror", s.x = w.z, s.y = w.q, o[o.length] = [s.x, s.y, 0, 0, w.x - s.x, w.y - s.y, 0, 0, "free"], e = e == "cr" ? "cx" : "Cx")) : e == "cr" || e == "Cr" ? (w.r = e == "cr" ? h.x + l : l, e = e == "cr" ? "cs" : "Cs") : e == "cs" || e == "Cs" ? (w.s = e == "cs" ? h.y + l : l, u = o[o.length - 1], o.length == 1 && (u[2] = 0, u[3] = 0, u[4] = 0, u[5] = 0), u[6] = w.x - u[0], u[7] = w.y - u[1], u[8] = "free", s.x = w.r, s.y = w.s, o[o.length] = [s.x, s.y, 0, 0, w.z - s.x, w.q - s.y, 0, 0, "free"], e = e == "cs" ? "cx" : "Cx") : e == "ax" || e == "Ax" ? (o.length > 0 ? (h.x = o[o.length - 1][0], h.y = o[o.length - 1][1]) : (h.x = 0, h.y = 0), d.x = l, e = e == "ax" ? "ay" : "Ay") : e == "ay" || e == "Ay" ? (d.y = l, e = e == "ay" ? "az" : "Az") : e == "az" || e == "Az" ? (d.z = l, e = e == "az" ? "aq" : "Aq") : e == "aq" || e == "Aq" ? (d.q = l, e = e == "aq" ? "ar" : "Ar") : e == "ar" || e == "Ar" ? (d.r = l, e = e == "ar" ? "as" : "As") : e == "as" || e == "As" ? (d.s = e == "as" ? h.x + l : l, e = e == "as" ? "at" : "At") : (e == "at" || e == "At") && (d.t = e == "at" ? h.y + l : l, b || (b = wt()), f = b({
                            px: h.x,
                            py: h.y,
                            cx: d.s,
                            cy: d.t,
                            rx: d.x,
                            ry: d.y,
                            xAxisRotation: d.z,
                            largeArcFlag: d.q,
                            sweepFlag: d.r
                        }), n.loop(f, function(n, t) {
                            u = o[o.length - 1];
                            o.length == 1 && (u[2] = 0, u[3] = 0, u[4] = 0, u[5] = 0);
                            t == 0 && o.length == 1 ? (u[6] = n.x1 - s.x - h.x, u[7] = n.y1 - s.y - h.y) : (u[6] = n.x1 - s.x, u[7] = n.y1 - s.y);
                            u[8] = "free";
                            s.x = n.x;
                            s.y = n.y;
                            o[o.length] = [s.x, s.y, 0, 0, n.x2 - s.x, n.y2 - s.y, 0, 0, "free"]
                        }), e = e == "at" ? "ax" : "Ax")) : (y.push(t), t != "s" && (it = !1), y.length > 1 && (t == "M" || t == "m") && (p(y), t == "M" ? (h.x = 0, h.y = 0) : (h.x = o[o.length - 1][0], h.y = o[o.length - 1][1]), o = [], y = [], y.push(t)), t == "M" ? e = "X" : t == "m" ? e = "x" : t == "L" ? (e = "Lx", i && c && c != "l" && p(y), c = "l") : t == "l" ? (e = "lx", i && c && c != "l" && p(y), c = "l") : t == "H" ? (e = "H", i && c && c != "l" && p(y), c = "l") : t == "h" ? (e = "h", i && c && c != "l" && p(y), c = "l") : t == "V" ? (e = "V", i && c && c != "l" && p(y), c = "l") : t == "v" ? (e = "v", i && c && c != "l" && p(y), c = "l") : t == "C" ? (e = "Cx", i && c && c != "c" && p(y), c = "c") : t == "c" ? (e = "cx", i && c && c != "c" && p(y), c = "c") : t == "S" ? (it = !0, e = "Cx", i && c && c != "c" && p(y), c = "c") : t == "s" ? (it = !0, e = "cx", i && c && c != "c" && p(y), c = "c") : t == "Q" ? (e = "Qx", i && c && c != "q" && p(y), c = "q") : t == "q" ? (e = "qx", i && c && c != "q" && p(y), c = "q") : t == "T" ? (it = !0, e = "Qx", i && c && c != "q" && p(y), c = "q") : t == "t" ? (it = !0, e = "qx", i && c && c != "q" && p(y), c = "q") : t == "A" ? (e = "Ax", i && c && c != "a" && p(), c = "a") : t == "a" ? (e = "ax", i && c && c != "a" && p(), c = "a") : (t == "z" || t == "Z") && (ht = "blob"))
                    }), r && p(), o
                }
                var rt, ut, v, h, b, w, c, st, y, p;
                if (rt = zob(n.SVGContainer, arguments, "svg, splitTypes, geometric, showControls, interactive, style, group, inherit", this)) return rt;
                if (z_d("50.95"), this.group = o, ut = e === !1 ? {} : n.getStyle("SVGContainer", this.group, s), t && t.type == "Bitmap" && (t = t.svg), v = this, h = new n.Point(0, 0), zot(i) && (i = !1), zot(r) && (r = !0), !zot(t)) {
                    if (t.replace && (t = t.replace(/style\s?=[^"]*"[^"]*"/ig, "")), zot(t.draggable) ? (t.getAttribute || (w = new DOMParser, t = w.parseFromString(t, "image/svg+xml").documentElement), c = this.svg = t) : (w = new DOMParser, t = t.innerHTML ? w.parseFromString(t.innerHTML, "text/xml") : t, st = t.getElementsByTagName("svg"), c = this.svg = st ? t.getElementsByTagName("svg")[0] : null), zot(c) || (y = c.getAttribute("width"), p = c.getAttribute("height")), y && (y = Number(y.trim())), p && (p = Number(p.trim())), this.zimContainer_constructor(y, p), this.type = "SVGContainer", zot(c)) return;
                    var ht = n.black,
                        k = n.black,
                        ct = n.black,
                        d = n.black,
                        lt = 2,
                        g = 2,
                        at = 1,
                        nt = 1,
                        vt = 1,
                        tt = 1,
                        a, it = t.getElementsByTagName("svg");
                    it.length == 0 && (it = [t]);
                    ft(it)
                }
                v.processPath = function(n) {
                    return pt(n, !1)
                };
                e !== !1 && n.styleTransforms(this, ut);
                this.clone = function() {
                    return v.cloneProps(new n.SVGContainer(t, i, r, u, f, e, this.group, s))
                }
            }, n.extend(n.SVGContainer, n.Container, "clone", "zimContainer", !1), n.CustomShape = function(t, i, r, u) {
                n.zimCustomShapeCheck || (z_d("50.97"), n.zimCustomShapeCheck = !0);
                this.zimContainer_constructor(t, i, r, u, !1);
                var f = this;
                this.mouseChildren = !1;
                f._dashedOffset = 5;
                Object.defineProperty(f, "color", {
                    get: function() {
                        return f._color
                    },
                    set: function(n) {
                        zot(n) && (n = "black");
                        f._color = n;
                        n && n.type ? f.specialColor(f.colorCommand, n, f) : f.colorCommand.style = n
                    }
                });
                this.setColorRange = function(n, t) {
                    return zot(t) ? (f.startColor = f.color, f.endColor = n) : zot(n) ? (f.startColor = f.color, f.endColor = t) : (f.startColor = n, f.endColor = t), f
                };
                f._colorRange = 0;
                Object.defineProperty(f, "colorRange", {
                    get: function() {
                        return f._colorRange
                    },
                    set: function(t) {
                        f._colorRange = t;
                        zot(f.startColor) || zot(f.endColor) || (f.color = n.colorRange(f.startColor, f.endColor, t))
                    }
                });
                Object.defineProperty(f, "borderColor", {
                    get: function() {
                        return f._borderColor
                    },
                    set: function(n) {
                        f._borderColor = n;
                        n && !f.borderWidth && (f.borderWidth = 1);
                        f.borderColorCommand ? n && n.type ? f.specialColor(f.borderColorCommand, n, f) : f.borderColorCommand.style = n : f.drawShape()
                    }
                });
                Object.defineProperty(f, "borderWidth", {
                    get: function() {
                        return f._borderWidth
                    },
                    set: function(n) {
                        n > 0 || (n = 0);
                        f._borderWidth = n;
                        f.borderWidthCommand && f._borderWidth != 0 ? (f.borderWidthCommand.width = f._borderWidth, f._dashed && (f.borderDashedCommand.segments = f._dashed, f.borderDashedCommand.offset = f._dashedOffset)) : (f.borderWidthCommand = null, f.drawShape())
                    }
                });
                Object.defineProperty(f, "thickness", {
                    get: function() {
                        return f._thickness
                    },
                    set: function(n) {
                        n > 0 || (n = 0);
                        f._thickness = n;
                        f.thicknessCommand && f._thickness != 0 ? (f.thicknessCommand.width = f._thickness, f._dashed && (f.dashedCommand.segments = f._dashed, f.dashedCommand.offset = f._dashedOffset)) : f.drawShape()
                    }
                });
                Object.defineProperty(f, "dashed", {
                    get: function() {
                        return f._dashed
                    },
                    set: function(n) {
                        f._dashed = n;
                        n && !Array.isArray(f._dashed) && (f.dashed = [10, 10]);
                        var t;
                        if (f.type == "Squiggle" || f.type == "Line") {
                            if (!f.thicknessCommand || f._thickness == 0) return;
                            t = f.dashedCommand
                        } else {
                            if (!f.borderWidthCommand || f._borderWidth == 0) return;
                            t = f.borderDashedCommand
                        }
                        t ? f._dashed ? (t.segments = f._dashed, t.offset = f._dashedOffset) : (t.segments = null, t.offset = null) : f.drawShape()
                    }
                });
                Object.defineProperty(f, "dashedOffset", {
                    get: function() {
                        return f._dashedOffset
                    },
                    set: function(n) {
                        isNaN(n) && (n = 5);
                        f._dashedOffset = n;
                        var t;
                        if (f.type == "Squiggle" || f.type == "Line") {
                            if (!f.thicknessCommand || f._thickness == 0) return;
                            t = f.dashedCommand
                        } else {
                            if (!f.borderWidthCommand || f._borderWidth == 0) return;
                            t = f.borderDashedCommand
                        }
                        t ? f._dashed ? (t.segments = f._dashed, t.offset = f._dashedOffset) : (t.segments = null, t.offset = null) : f.drawShape()
                    }
                });
                Object.defineProperty(f, "corner", {
                    get: function() {
                        return f._corner
                    },
                    set: function(n) {
                        f._corner = n;
                        f.drawShape()
                    }
                });
                this.linearGradient = function(n, t, i, r, u, f) {
                    return this.linearGradientParams = Array.prototype.slice.call(arguments), this.colorCommand.linearGradient(n, t, i, r, u, f), this
                };
                this.radialGradient = function(n, t, i, r, u, f, e, o) {
                    return this.radialGradientParams = Array.prototype.slice.call(arguments), this.colorCommand.radialGradient(n, t, i, r, u, f, e, o), this
                };
                this.cloneAll = function(t, i, r, u) {
                    var f = this.getBounds(),
                        e;
                    return zot(f) && (f = {
                        x: null,
                        y: null,
                        width: null,
                        height: null
                    }), e = this.cloneChildren(this.cloneProps(new n.Container(f.x, f.y, f.width, f.height, i, r, u)), t), e.mouseChildren = !1, e.type = this.type, e
                }
            }, n.extend(n.CustomShape, n.Container, null, "zimContainer", !1), n.Circle = function(t, i, r, u, f, e, o, s, h, c, l) {
                function k() {
                    return arguments
                }
                var b, v, y, a, w, p;
                if (b = zob(n.Circle, arguments, "radius, color, borderColor, borderWidth, dashed, percent, percentClose, strokeObj, style, group, inherit", this)) return b;
                z_d("51");
                this.zimCustomShape_constructor(null, null, null, null, !1);
                this.type = "Circle";
                this.group = c;
                v = h === !1 ? {} : n.getStyle(this.type, this.group, l);
                zot(t) && (t = v.radius != null ? v.radius : 50);
                zot(f) && (f = v.dashed != null ? v.dashed : !1);
                zot(r) && (r = v.borderColor != null ? v.borderColor : null);
                zot(u) && (u = v.borderWidth != null ? v.borderWidth : null);
                r < 0 || u < 0 ? r = u = null : r != null && u == null && (u = 1);
                zot(i) && (i = v.color != null ? v.color : u > 0 ? "rgba(0,0,0,0)" : "black");
                zot(e) && (e = v.percent != null ? v.percent : 100);
                zot(o) && (o = v.percentClose != null ? v.percentClose : !0);
                zot(s) && (s = v.strokeObj != null ? v.strokeObj : {});
                y = k(t, i, r, u, e);
                t = n.Pick.choose(t);
                i = n.Pick.choose(i);
                r = n.Pick.choose(r);
                u = n.Pick.choose(u);
                e = n.Pick.choose(e);
                a = this;
                a._radius = t;
                a._color = i;
                a._borderColor = r;
                a._borderWidth = u;
                a._dashed = f;
                a._dashed && !Array.isArray(a._dashed) && (a._dashed = [10, 10]);
                w = this.shape = new createjs.Shape;
                this.addChild(w);
                p = w.graphics;
                a.drawShape = function() {
                    var t, n;
                    p.c();
                    a.colorCommand = p.f(a._color).command;
                    a._color && a._color.type && a.specialColor(a.colorCommand, a._color, a);
                    (zot(a._borderWidth) || a._borderWidth > 0) && (zot(a._borderColor) && zot(a._borderWidth) || (zot(a._borderColor) && (a._borderColor = "black"), a.borderColorCommand = p.s(a._borderColor).command, a._borderColor && a._borderColor.type && a.specialColor(a.borderColorCommand, a._borderColor, a), a.borderWidthCommand = p.ss(a._borderWidth, s.caps, s.joints, s.miterLimit, s.ignoreScale).command, a._dashed && (a.borderDashedCommand = p.sd(Array.isArray(a._dashed) ? a._dashed : [10, 10], a._dashedOffset).command)));
                    t = a._radius * 2;
                    typeof e == "number" && e >= 0 && e < 100 ? (n = 360 * e / 200, p.arc(0, 0, a._radius, (-n - 90) * Math.PI / 180, (n - 90) * Math.PI / 180, !1), o && p.cp(), t = a._radius - Math.cos(n * Math.PI / 180) * a._radius) : p.dc(0, 0, a._radius);
                    a.setBounds(-a._radius, -a._radius, a._radius * 2, t)
                };
                a.drawShape();
                i.type && (a.color = i);
                Object.defineProperty(a, "radius", {
                    get: function() {
                        return a._radius
                    },
                    set: function(n) {
                        a._radius = n;
                        a.drawShape()
                    }
                });
                Object.defineProperty(a, "percentage", {
                    get: function() {
                        return e
                    },
                    set: function(n) {
                        e = n;
                        a.drawShape()
                    }
                });
                Object.defineProperty(a, "percentClose", {
                    get: function() {
                        return o
                    },
                    set: function(n) {
                        o = n;
                        a.drawShape()
                    }
                });
                h !== !1 && n.styleTransforms(this, v);
                this.clone = function(t) {
                    var i = a.cloneProps(new n.Circle(t || !n.isPick(y[0]) ? a.radius : y[0], t || !n.isPick(y[1]) ? a.color : y[1], t || !n.isPick(y[2]) ? a.borderColor : y[2], t || !n.isPick(y[3]) ? a.borderWidth : y[3], a.dashed, t || !n.isPick(y[4]) ? e : y[4], o, s, h, this.group, l));
                    return a.linearGradientParams && i.linearGradient.apply(i, a.linearGradientParams), a.radialGradientParams && i.radialGradient.apply(i, a.radialGradientParams), i
                }
            }, n.extend(n.Circle, n.CustomShape, "clone", "zimCustomShape", !1), n.Rectangle = function(t, i, r, u, f, e, o, s, h, c, l, a) {
                function d() {
                    return arguments
                }
                var k, y, p, v, b, w;
                if (k = zob(n.Rectangle, arguments, "width, height, color, borderColor, borderWidth, corner, dashed, strokeObj, scaleDimensions, style, group, inherit", this)) return k;
                z_d("52");
                this.zimCustomShape_constructor(null, null, null, null, !1);
                this.type = "Rectangle";
                this.group = l;
                y = c === !1 ? {} : n.getStyle(this.type, this.group, a);
                zot(t) && (t = y.width != null ? y.width : null);
                zot(i) && (i = y.height != null ? y.height : zot(t) ? 100 : t);
                zot(t) && (t = i);
                zot(e) && (e = y.corner != null ? y.corner : 0);
                zot(o) && (o = y.dashed != null ? y.dashed : !1);
                zot(u) && (u = y.borderColor != null ? y.borderColor : null);
                zot(f) && (f = y.borderWidth != null ? y.borderWidth : null);
                u < 0 || f < 0 ? u = f = null : u != null && f == null && (f = 1);
                zot(r) && (r = y.color != null ? y.color : f > 0 ? "rgba(0,0,0,0)" : "black");
                zot(s) && (s = y.strokeObj != null ? y.strokeObj : {});
                zot(h) && (h = y.scaleDimensions != null ? y.scaleDimensions : !0);
                p = d(t, i, r, u, f);
                t = n.Pick.choose(t);
                i = n.Pick.choose(i);
                r = n.Pick.choose(r);
                u = n.Pick.choose(u);
                f = n.Pick.choose(f);
                v = this;
                v._color = r;
                v._borderColor = u;
                v._borderWidth = f;
                v._dashed = o;
                v._dashed && !Array.isArray(v._dashed) && (v._dashed = [10, 10]);
                v._corner = e;
                v.scaleDimensions = h;
                v.setWidth = function(n) {
                    t = n
                };
                v.setHeight = function(n) {
                    i = n
                };
                b = this.shape = new createjs.Shape;
                this.addChild(b);
                w = b.graphics;
                v.drawShape = function() {
                    var n, f, e, u;
                    if (w.c(), v.colorCommand = w.f(v._color).command, r && r.type && v.specialColor(v.colorCommand, r, v), (zot(v._borderWidth) || v._borderWidth > 0) && (zot(v._borderColor) && zot(v._borderWidth) || (zot(v._borderColor) && (v._borderColor = "black"), v.borderColorCommand = w.s(v._borderColor).command, v._borderColor && v._borderColor.type && v.specialColor(v.borderColorCommand, v._borderColor, v), v.borderWidthCommand = w.ss(v._borderWidth, s.caps, s.joints, s.miterLimit, s.ignoreScale).command, v._dashed && (v.borderDashedCommand = w.sd(Array.isArray(v._dashed) ? v._dashed : [10, 10], v._dashedOffset).command))), Array.isArray(v._corner)) {
                        for (n = v._corner, Array.isArray(n) && n.length == 2 && (n = [n, n, n, n]), f = [], e = !1, u = 0; u < n.length; u++) Array.isArray(n[u]) ? (e = !0, f.push(n[u])) : f.push([n[u], n[u]]);
                        n = f;
                        e ? w.mt(0, n[0][1]).curveTo(0, 0, n[0][0], 0).lt(t - n[1][0], 0).curveTo(t, 0, t, n[1][1]).lt(t, i - n[2][1]).curveTo(t, i, t - n[2][0], i).lt(n[3][0], i).curveTo(0, i, 0, i - n[3][1]).cp() : w.rc(0, 0, t, i, v._corner[0], v._corner[1], v._corner[2], v._corner[3])
                    } else v._corner > 0 ? w.rr(0, 0, t, i, v._corner) : w.r(0, 0, t, i);
                    v.setBounds(0, 0, t, i);
                    r.type && (v.color = r)
                };
                v.drawShape();
                c !== !1 && n.styleTransforms(this, y);
                this.clone = function(r) {
                    return v.cloneProps(new n.Rectangle(r || !n.isPick(p[0]) ? t : p[0], r || !n.isPick(p[1]) ? i : p[1], r || !n.isPick(p[2]) ? v.color : p[2], r || !n.isPick(p[3]) ? v.borderColor : p[3], r || !n.isPick(p[4]) ? v.borderWidth : p[4], e, v._dashed, s, v.scaleDimensions, c, this.group, a))
                }
            }, n.extend(n.Rectangle, n.CustomShape, "clone", "zimCustomShape", !1), n.Triangle = function(t, i, r, u, f, e, o, s, h, c, l, a, v, y) {
                function ft() {
                    return arguments
                }
                var ut, w, b, p, k, nt, d;
                if (ut = zob(n.Triangle, arguments, "a, b, c, color, borderColor, borderWidth, corner, center, adjust, dashed, strokeObj, style, group, inherit", this)) return ut;
                z_d("53");
                this.zimCustomShape_constructor(null, null, null, null, !1);
                this.type = "Triangle";
                this.group = v;
                w = a === !1 ? {} : n.getStyle(this.type, this.group, y);
                zot(t) && (t = w.a != null ? w.a : 100);
                zot(i) && (i = w.b != null ? w.b : t);
                zot(r) && (r = w.c != null ? w.c : i);
                r == -1 && (r = Math.sqrt(Math.pow(t, 2) + Math.pow(i, 2)));
                zot(o) && (o = w.corner != null ? w.corner : 0);
                zot(s) && (s = w.center != null ? w.center : !0);
                zot(h) && (h = w.adjust != null ? w.adjust : 0);
                zot(f) && (f = w.borderColor != null ? w.borderColor : null);
                zot(e) && (e = w.borderWidth != null ? w.borderWidth : null);
                f < 0 || e < 0 ? f = e = null : f != null && e == null && (e = 1);
                zot(u) && (u = w.color != null ? w.color : e > 0 ? "rgba(0,0,0,0)" : "black");
                zot(h) && (h = w.adjust != null ? w.adjust : 0);
                zot(l) && (l = w.strokeObj != null ? w.strokeObj : {});
                b = ft(t, i, r, u, f, e);
                t = n.Pick.choose(t);
                i = n.Pick.choose(i);
                r = n.Pick.choose(r);
                this.a = t;
                this.b = i;
                this.c = r;
                u = n.Pick.choose(u);
                f = n.Pick.choose(f);
                e = n.Pick.choose(e);
                p = this;
                p._color = u;
                p._borderColor = f;
                p._borderWidth = e;
                p._dashed = c;
                p._dashed && !Array.isArray(p._dashed) && (p._dashed = [10, 10]);
                p._corner = o;
                k = [t, i, r];
                k.sort(function(n, t) {
                    return t - n
                });
                var tt = k[0],
                    g = k[1],
                    it = k[2],
                    rt = [k.indexOf(t), k.indexOf(i), k.indexOf(r)];
                if (tt > g + it) {
                    zogy("zim display - Triangle(): invalid triangle lengths");
                    return
                }
                nt = this.shape = new createjs.Shape;
                this.adjusted = h;
                this.addChild(nt);
                d = nt.graphics;
                p.drawShape = function() {
                    var n = [],
                        r, a;
                    for (Array.isArray(p._corner) ? n = p._corner : n.push(p._corner, p._corner, p._corner), r = 0; r < 3; r++)(n[r] < 0 || typeof n[r] != "number") && (n[r] = 0);
                    d.c();
                    p.colorCommand = d.f(p._color).command;
                    p._color && p._color.type && p.specialColor(p.colorCommand, p._color, p);
                    (zot(p._borderWidth) || p._borderWidth > 0) && (zot(p._borderColor) && zot(p._borderWidth) || (zot(p._borderColor) && (p._borderColor = "black"), p.borderColorCommand = d.s(p._borderColor).command, p._borderColor && p._borderColor.type && p.specialColor(p.borderColorCommand, p._borderColor, p), p.borderWidthCommand = d.ss(p._borderWidth, l.caps, l.joints, l.miterLimit, l.ignoreScale).command, p._dashed && (p.borderDashedCommand = d.sd(Array.isArray(p._dashed) ? p._dashed : [10, 10], p._dashedOffset).command)));
                    p.one = {
                        x: 0,
                        y: 0
                    };
                    p.two = {
                        x: t,
                        y: 0
                    };
                    var e = Math.acos((Math.pow(g, 2) + Math.pow(it, 2) - Math.pow(tt, 2)) / (2 * g * it)) * 180 / Math.PI,
                        v = Math.asin(g * Math.sin(e * Math.PI / 180) / tt) * 180 / Math.PI,
                        b = 180 - e - v,
                        o = [e, v, b];
                    p.angles = [o[rt[1]], o[rt[2]], o[rt[0]]];
                    var y = p.angles[1],
                        u = Math.cos(y * Math.PI / 180) * i,
                        f = Math.sin(y * Math.PI / 180) * i,
                        w = Math.max(t, t - u),
                        c = f;
                    p.setBounds(0, h, w, c);
                    nt.y = c;
                    p.three = {
                        x: t - u,
                        y: 0 - f
                    };
                    a = t * n[0] / (n[0] + n[1] || 1);
                    d.mt(a, 0).at(t, 0, t - u, 0 - f, n[1]).at(t - u, 0 - f, 0, 0, n[2]).at(0, 0, t, 0, n[0]).lt(a, 0);
                    d.cp();
                    s && (p.regX = w / 2, p.regY = c / 2);
                    h && (p.shape.y += h)
                };
                p.drawShape();
                u.type && (p.color = u);
                a !== !1 && n.styleTransforms(this, w);
                this.clone = function(u) {
                    var f = p.cloneProps(new n.Triangle(u || !n.isPick(b[0]) ? t : b[0], u || !n.isPick(b[1]) ? i : b[1], u || !n.isPick(b[2]) ? r : b[2], u || !n.isPick(b[3]) ? p.color : b[3], u || !n.isPick(b[4]) ? p.borderColor : b[4], u || !n.isPick(b[5]) ? p.borderWidth : b[5], o, s, h, c, l, a, this.group, y));
                    return p.linearGradientParams && f.linearGradient.apply(f, p.linearGradientParams), p.radialGradientParams && f.radialGradient.apply(f, p.radialGradientParams), f
                }
            }, n.extend(n.Triangle, n.CustomShape, "clone", "zimCustomShape"), n.Poly = function(t, i, r, u, f, e, o, s, h, c, l) {
                function k() {
                    return arguments
                }
                var b, v, y, a, w, p;
                if (b = zob(n.Poly, arguments, "radius, sides, pointSize, color, borderColor, borderWidth, dashed, strokeObj, style, group, inherit", this)) return b;
                z_d("53.1");
                this.zimCustomShape_constructor(null, null, null, null, !1);
                this.type = "Poly";
                this.group = c;
                v = h === !1 ? {} : n.getStyle(this.type, this.group, l);
                zot(t) && (t = v.radius != null ? v.radius : 50);
                zot(i) && (i = v.sides != null ? v.sides : 5);
                zot(r) && (r = v.pointSize != null ? v.pointSize : 0);
                zot(o) && (o = v.dashed != null ? v.dashed : !1);
                zot(f) && (f = v.borderColor != null ? v.borderColor : null);
                zot(e) && (e = v.borderWidth != null ? v.borderWidth : null);
                f < 0 || e < 0 ? f = e = null : f != null && e == null && (e = 1);
                zot(u) && (u = v.color != null ? v.color : e > 0 ? "rgba(0,0,0,0)" : "black");
                zot(s) && (s = v.strokeObj != null ? v.strokeObj : {});
                y = k(t, i, r, u, f, e);
                t = n.Pick.choose(t);
                i = n.Pick.choose(i);
                r = n.Pick.choose(r);
                u = n.Pick.choose(u);
                f = n.Pick.choose(f);
                e = n.Pick.choose(e);
                a = this;
                a._radius = t;
                a._color = u;
                a._sides = i;
                a._pointSize = r;
                a._borderColor = f;
                a._borderWidth = e;
                a._dashed = o;
                a._dashed && !Array.isArray(a._dashed) && (a._dashed = [10, 10]);
                w = this.shape = new createjs.Shape;
                this.addChild(w);
                w.rotation = -90;
                p = w.graphics;
                a.drawShape = function() {
                    p.c();
                    a.colorCommand = p.f(a._color).command;
                    a._color && a._color.type && a.specialColor(a.colorCommand, a._color, a);
                    (zot(a._borderWidth) || a._borderWidth > 0) && (zot(a._borderColor) && zot(a._borderWidth) || (zot(a._borderColor) && (a._borderColor = "black"), a.borderColorCommand = p.s(a._borderColor).command, a._borderColor && a._borderColor.type && a.specialColor(a.borderColorCommand, a._borderColor, a), a.borderWidthCommand = p.ss(a._borderWidth, s.caps, s.joints, s.miterLimit, s.ignoreScale).command, a._dashed && (a.borderDashedCommand = p.sd(Array.isArray(a._dashed) ? a._dashed : [10, 10], a._dashedOffset).command)));
                    p.dp(0, 0, a._radius, a._sides, a._pointSize);
                    a.setBounds(-a._radius, -a._radius, a._radius * 2, a._radius * 2)
                };
                a.drawShape();
                u.type && (a.color = u);
                Object.defineProperty(a, "radius", {
                    get: function() {
                        return a._radius
                    },
                    set: function(n) {
                        a._radius = n;
                        a.drawShape()
                    }
                });
                Object.defineProperty(a, "sides", {
                    get: function() {
                        return a._sides
                    },
                    set: function(n) {
                        a._sides = n;
                        a.drawShape()
                    }
                });
                Object.defineProperty(a, "pointSize", {
                    get: function() {
                        return a._pointSize
                    },
                    set: function(n) {
                        a._pointSize = n;
                        a.drawShape()
                    }
                });
                h !== !1 && n.styleTransforms(this, v);
                this.clone = function(t) {
                    var i = a.cloneProps(new n.Poly(t || !n.isPick(y[0]) ? a.radius : y[0], t || !n.isPick(y[1]) ? a.sides : y[1], t || !n.isPick(y[2]) ? a.pointSize : y[2], t || !n.isPick(y[3]) ? a.color : y[3], t || !n.isPick(y[4]) ? a.borderColor : y[4], t || !n.isPick(y[5]) ? a.borderWidth : y[5], a.dashed, s, h, this.group, l));
                    return a.linearGradientParams && i.linearGradient.apply(i, a.linearGradientParams), a.radialGradientParams && i.radialGradient.apply(i, a.radialGradientParams), i
                }
            }, n.extend(n.Poly, n.CustomShape, "clone", "zimCustomShape", !1), n.Line = function(t, i, r, u, f, e, o, s, h, c, l, a, v, y, p) {
                function it() {
                    return arguments
                }

                function tt(t, u) {
                    if (u == "triangle" || u == "arrow") {
                        var f = w["_" + t + "Head"] = new n.Triangle(i * 4, i * 4, i * 4, r);
                        f.rotation = 90
                    } else u == "circle" && (w["_" + t + "Head"] = new n.Circle(i * 2.2, r));
                    zot(w["_" + t + "Head"].startAngle) && (w["_" + t + "Head"].startAngle = w["_" + t + "Head"].rotation)
                }
                var nt, b, d, w, g, k;
                if (nt = zob(n.Line, arguments, "length, thickness, color, startHead, endHead, dashed, strokeObj, lineType, lineOrientation, curveH, curveV, points, style, group, inherit", this)) return nt;
                z_d("53.15");
                this.zimCustomShape_constructor(null, null, null, null, !1);
                this.type = "Line";
                this.group = y;
                b = v === !1 ? {} : n.getStyle(this.type, this.group, p);
                zot(t) && (t = b.length != null ? b.length : 100);
                zot(e) && (e = b.dashed != null ? b.dashed : !1);
                zot(i) && (i = b.thickness != null ? b.thickness : 3);
                zot(r) && (r = b.color != null ? b.color : "black");
                zot(u) && (u = b.startHead != null ? b.startHead : null);
                zot(f) && (f = b.endHead != null ? b.endHead : null);
                zot(o) && (o = b.strokeObj != null ? b.strokeObj : {});
                zot(s) && (s = b.lineType != null ? b.lineType : "straight");
                s !== "corner" && s != "curve" && (s = "straight");
                zot(h) && (h = b.lineOrientation != null ? b.lineOrientation : "auto");
                h !== "vertical" && h != "horizontal" && (h = "auto");
                zot(c) && (c = b.curveH != null ? b.curveH : 20);
                zot(l) && (l = b.curveV != null ? b.curveV : 20);
                zot(o) && (o = b.strokeObj != null ? b.strokeObj : {});
                d = it(t, r, i, u, f);
                t = n.Pick.choose(t);
                r = n.Pick.choose(r);
                i = n.Pick.choose(i);
                u = n.Pick.choose(u);
                f = n.Pick.choose(f);
                u && u.clone && (u = u.clone());
                f && f.clone && (f = f.clone());
                w = this;
                w._length = t;
                w._color = r;
                w._thickness = i;
                w._dashed = e;
                w._dashed && !Array.isArray(w._dashed) && (w._dashed = [10, 10]);
                w._startX = 0;
                w._startY = 0;
                w._endX = t;
                w._endY = 0;
                w._startHead = u;
                w._endHead = f;
                w._points = a;
                w._lineOrientation = h;
                w.angle = 0;
                w.lineType = s;
                w._startHead && tt("start", w._startHead);
                w._endHead && tt("end", w._endHead);
                u = w._startHead;
                f = w._endHead;
                u && u.type == "Triangle" && (u.startRegY = u.regY);
                f && f.type == "Triangle" && (f.startRegY = f.regY);
                g = this.shape = new createjs.Shape;
                this.addChild(g);
                k = g.graphics;
                w.drawShape = function(t, i) {
                    var d, b, et, ot, yt, st, v, ht, ct, lt, ft, nt, at, vt, bt, kt;
                    if (k.c(), w.colorCommand = k.s(w._color).command, r && r.type && w.specialColor(w.colorCommand, r, w), w.thicknessCommand = k.ss(w._thickness, o.caps, o.joints, o.miterLimit, o.ignoreScale).command, w._dashed && (w.dashedCommand = k.sd(Array.isArray(w._dashed) ? w._dashed : [10, 10], w._dashedOffset).command), w._points) {
                        for (et = w._points[0], w._startX = et[0], w._startY = et[1], ot = w._points[w._points.length - 1], yt = [ot[ot.length - 2], ot[ot.length - 1]], w._endX = yt[0], w._endY = yt[1], k.mt(et[0], et[1]), st = 1; st < w._points.length; st++) v = w._points[st], st == 1 && (d = [w._startX, w._startY, v[0], v[1]]), v.length == 2 ? k.lt(v[0], v[1]) : v.length == 4 ? k.qt(v[0], v[1], v[2], v[3]) : v.length == 6 && k.bt(v[0], v[1], v[2], v[3], v[4], v[5]);
                        v.length >= 4 ? b = [v[v.length - 4], v[v.length - 3], w._endX, w._endY] : (ht = w._points[w._points.length - 2], b = [ht[ht.lenth - 2], ht[ht.lenth - 1], w._endX, w._endY])
                    } else {
                        var h = w._startX,
                            a = w._startY,
                            y = w._endX,
                            p = w._endY,
                            g;
                        if (w.lineType == "straight" ? (u && u.type == "Triangle" && (u.regY = 0, g = n.dist(h, a, y, p), g != 0 && (h = h + w._startHead.height / 2 * (y - h) / g), g != 0 && (a = a + w._startHead.height / 2 * (p - a) / g)), f && f.type == "Triangle" && (f.regY = 0, g = n.dist(h, a, y, p), g != 0 && (y = y - w._endHead.height / 2 * (y - h) / g), g != 0 && (p = p - w._endHead.height / 2 * (p - a) / g))) : (t ? w._lineOrientation == "horizontal" || w.autoOrientation == "horizontal" ? u && u.type == "Triangle" && (u.regY = 0, h = y > h ? Math.min(y, h + w._startHead.height / 2) : Math.max(y, h - w._startHead.height / 2)) : u && u.type == "Triangle" && (u.regY = 0, a = p > a ? Math.min(p, a + w._startHead.height / 2) : Math.max(p, a - w._startHead.height / 2)) : u && u.type == "Triangle" && (u.regY = u.startRegY), i ? w._lineOrientation == "horizontal" || w.autoOrientation == "horizontal" ? f && f.type == "Triangle" && (f.regY = 0, y > h ? y -= w._endHead.height / 2 : y += w._endHead.height / 2) : f && f.type == "Triangle" && (f.regY = 0, p > a ? p -= w._endHead.height / 2 : p += w._endHead.height / 2) : f && f.type == "Triangle" && (f.regY = f.startRegY)), w.lineType == "straight") k.mt(h, a).lt(y, p), d = b = [h, a, y, p];
                        else if (w.lineType == "corner") ct = h + (y - h) * .4, lt = a + (p - a) * .4, w._lineOrientation == "auto" && (w.autoOrientation = Math.abs(h - y) > Math.abs(a - p) ? "horizontal" : "vertical"), w._lineOrientation == "horizontal" || w.autoOrientation == "horizontal" ? (d = b = [h, a, ct, a], k.mt(h, a).lt(ct, a).lt(ct, p).lt(y, p)) : (d = b = [h, a, h, lt], k.mt(h, a).lt(h, lt).lt(y, lt).lt(y, p));
                        else {
                            var tt = h > y ? -1 : 1,
                                it = a > p ? -1 : 1,
                                e = h,
                                s = a,
                                pt = Math.abs(h - y),
                                wt = Math.abs(a - p),
                                rt = Math.min(c, pt * .5),
                                ut = Math.min(l, wt * .5);
                            w._lineOrientation == "auto" && (w.autoOrientation = Math.abs(h - y) > Math.abs(a - p) ? "horizontal" : "vertical");
                            w._lineOrientation == "horizontal" || w.autoOrientation == "horizontal" ? (ft = wt - ut * 2, nt = (pt - rt * 2) / 2, k.mt(e, s), nt > 0 && (e = e + nt * tt, k.lt(e, s)), vt = s, s = s + ut * it, e = e + rt * tt, k.qt(e, vt, e, s), d = b = [h, a, e, a], ft > 0 && (s = s + ft * it, k.lt(e, s)), s = s + ut * it, at = e, e = e + rt * tt, k.qt(at, s, e, s), nt > 0 && (e = e + nt * tt, k.lt(e, s))) : (ft = pt - rt * 2, nt = (wt - ut * 2) / 2, k.mt(e, s), nt > 0 && (s = s + nt * it, k.lt(e, s)), at = e, e = e + rt * tt, s = s + ut * it, k.qt(at, s, e, s), d = b = [h, a, h, s], ft > 0 && (e = e + ft * tt, k.lt(e, s)), e = e + rt * tt, vt = s, s = s + ut * it, k.qt(e, vt, e, s), nt > 0 && (s = s + nt * it, k.lt(e, s)))
                        }
                    }
                    w.setBounds(Math.min(w._startX, w._endX), Math.min(w._startY, w._endY), Math.abs(w._startX - w._endX), Math.abs(w._startY - w._endY));
                    w._length = Math.sqrt(Math.pow(w._startX - w._endX, 2) + Math.pow(w._startY - w._endY, 2));
                    w.angle = Math.atan2(w._endY - w._startY, w._endX - w._startX) * 180 / Math.PI;
                    w._startHead && w._startHead.loc && (w._startHead.loc(w._startX, w._startY, w), bt = Math.atan2(d[3] - d[1], d[2] - d[0]) * 180 / Math.PI, w._startHead.rotation = bt - 180 + w._startHead.startAngle);
                    w._endHead && w._endHead.loc && (w._endHead.loc(w._endX, w._endY, w), kt = Math.atan2(b[3] - b[1], b[2] - b[0]) * 180 / Math.PI, w._endHead.rotation = kt + w._endHead.startAngle)
                };
                w.drawShape();
                r.type && (w.color = r);
                this.setPoints = function(n, t, i, r, u, f) {
                    return Array.isArray(n) && zot(t) ? (w.points = n, w) : (n && !zot(n.x) ? (w._startX = zot(n.x) ? w._startX : n.x, w._startY = zot(n.y) ? w._startY : n.y, t && (w._endX = zot(t.x) ? w._endX : t.x, w._endY = zot(t.y) ? w._endY : t.y)) : (w._startX = zot(n) ? w._startX : n, w._startY = zot(t) ? w._startY : t, w._endX = zot(i) ? w._endX : i, w._endY = zot(r) ? w._endY : r), w.drawShape(u, f), w)
                };
                this.from = function(n, t) {
                    return n && !zot(n.x) ? (w._startX = zot(n.x) ? w._startX : n.x, w._startY = zot(n.y) ? w._startY : n.y) : (w._startX = zot(n) ? w._startX : n, w._startY = zot(t) ? w._startY : t), w.drawShape(), w
                };
                this.to = function(n, t) {
                    return n && !zot(n.x) ? (w._endX = zot(n.x) ? w._endX : n.x, w._endY = zot(n.y) ? w._endY : n.y) : (w._endX = zot(n) ? w._endX : n, w._endY = zot(t) ? w._endY : t), w.drawShape(), w
                };
                Object.defineProperty(w, "length", {
                    get: function() {
                        return w._length
                    },
                    set: function(n) {
                        var t = w.length != 0 ? n / w.length : 0,
                            u, f, i, r, e, o;
                        isNaN(t) || (u = w.scaleX, f = w.scaleY, w.scaleX *= t, w.scaleY *= t, i = w.localToGlobal(w._startX, w._startY), r = w.localToGlobal(w._endX, w._endY), w.scaleX = u, w.scaleY = f, e = w.globalToLocal(i.x, i.y), o = w.globalToLocal(r.x, r.y), w.setPoints(e, o))
                    }
                });
                Object.defineProperty(w, "startPoint", {
                    get: function() {
                        return new n.Point(w._startX, w._startY)
                    },
                    set: function(n) {
                        w._startX = zot(n.x) ? w._startX : n.x;
                        w._startY = zot(n.y) ? w._startY : n.y;
                        w.drawShape()
                    }
                });
                Object.defineProperty(w, "endPoint", {
                    get: function() {
                        return new n.Point(w._endX, w._endY)
                    },
                    set: function(n) {
                        w._endX = zot(n.x) ? w._endX : n.x;
                        w._endY = zot(n.y) ? w._endY : n.y;
                        w.drawShape()
                    }
                });
                Object.defineProperty(w, "startHead", {
                    get: function() {
                        return w._startHead
                    },
                    set: function(n) {
                        w._startHead = n;
                        w.drawShape()
                    }
                });
                Object.defineProperty(w, "endHead", {
                    get: function() {
                        return w._endHead
                    },
                    set: function(n) {
                        w._endHead = n;
                        w.drawShape()
                    }
                });
                Object.defineProperty(w, "startX", {
                    get: function() {
                        return w._startX
                    },
                    set: function(n) {
                        w._startX = n || 0;
                        w.drawShape()
                    }
                });
                Object.defineProperty(w, "startY", {
                    get: function() {
                        return w._startY
                    },
                    set: function(n) {
                        w._startY = n || 0;
                        w.drawShape()
                    }
                });
                Object.defineProperty(w, "endX", {
                    get: function() {
                        return w._endX
                    },
                    set: function(n) {
                        w._endX = n || 0;
                        w.drawShape()
                    }
                });
                Object.defineProperty(w, "endY", {
                    get: function() {
                        return w._endY
                    },
                    set: function(n) {
                        w._endY = n || 0;
                        w.drawShape()
                    }
                });
                Object.defineProperty(w, "points", {
                    get: function() {
                        return w._points
                    },
                    set: function(n) {
                        n && (w._points = n, w.drawShape())
                    }
                });
                Object.defineProperty(w, "lineOrientation", {
                    get: function() {
                        return w._lineOrientation
                    },
                    set: function(n) {
                        n && (w._lineOrientation = n, w.drawShape())
                    }
                });
                v !== !1 && n.styleTransforms(this, b);
                this.clone = function(t) {
                    var u = t || !n.isPick(d[3]) ? w._startHead : d[3],
                        r, i;
                    return u && u.clone && (u = u.clone(), u.rotation = w._startHead.startAngle), r = t || !n.isPick(d[4]) ? w._endHead : d[4], r && r.clone && (r = r.clone(), r.rotation = w._endHead.startAngle), i = w.cloneProps(new n.Line(t || !n.isPick(d[0]) ? w.length : d[0], t || !n.isPick(d[2]) ? w.thickness : d[2], t || !n.isPick(d[1]) ? w.color : d[1], u, r, w.dashed, o, s, w._lineOrientation, c, l, n.copy(a), v, this.group, p)), w.points ? i.setPoints(w.points) : i.setPoints(w._startX, w._startY, w._endX, w._endY), w.linearGradientParams && i.linearGradient.apply(i, w.linearGradientParams), w.radialGradientParams && i.radialGradient.apply(i, w.radialGradientParams), i
                }
            }, n.extend(n.Line, n.CustomShape, "clone", "zimCustomShape", !1), n.Squiggle = function(t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt) {
                function ai() {
                    return arguments
                }

                function li() {
                    function ir(n) {
                        vi ? (n.preventDefault(), gi(n)) : (vi = !0, setTimeout(function() {
                            vi = !1
                        }, 300))
                    }

                    function gi(n) {
                        var i, r, u;
                        ut.lockControlType || (i = n.target, r = ft[i.index][4] ? ft[i.index][4] : e, Math.abs(i.rect1.x) <= 2 && Math.abs(i.rect1.y) <= 2 && Math.abs(i.rect2.x) <= 2 && Math.abs(i.rect2.y) <= 2 && (r = "none"), r == "none" && i.parent.addChildAt(i, 0), r = ut.types[(ut.types.indexOf(r) + (ut.shiftKey ? -1 : 1) + ut.types.length) % ut.types.length], r == "none" && (i.rect1.x = i.rect1.y = i.rect2.x = i.rect2.y = 0, i.parent.addChild(i), n.stopImmediatePropagation()), ft[i.index][4] = r, i.rect1.color = ri(r), i.rect2.color = ri(r), ut.drawShape(), t.type && (ut.color = t), u = new createjs.Event("change"), u.controlType = "bezierSwitch", ut.dispatchEvent(u), i.stage.update())
                    }

                    function ri(t) {
                        var i = {
                            straight: n.pink,
                            free: n.yellow,
                            none: n.blue
                        };
                        return i[t] ? i[t] : n.purple
                    }

                    function rr(n) {
                        var t, i;
                        if (ut.selectPoints)
                            if (t = ti(), t && t.indexOf(n) == -1) wt(n);
                            else if (t && t.length > 0)
                            for (i = 0; i < t.length; i++) wt(t[i]);
                        else wt(n);
                        else wt(n)
                    }

                    function ur() {
                        if (ut.onTop) {
                            var n = ut.parent.numChildren - 1;
                            ut.parent.getChildAt(n).type == "Keyboard" && n--;
                            ut.parent.setChildIndex(ut, n)
                        }
                    }

                    function tr(t) {
                        var r, i;
                        if (t.target.type == "Circle") {
                            if (r = ut.lastSelectedIndex = ut.controls.getChildIndex(t.target.parent), ut.controls.numChildren <= 2) return;
                            i = ut.points;
                            ut.selectPoints && (ut.lastPoints = n.copy(i));
                            i.splice(r, 1);
                            ut.points = i;
                            ut.stage.update();
                            ut.lastSelected = ut.lastSelectedIndex = null
                        }
                    }
                    var bt, d, li, yi, kt, ai, p, di, si, w, it, at, l, pi, yt, hi, wi, bi, ki, vi, nr, ci;
                    for (st && st.removeAllEventListeners(), ut.num = lt = typeof r == "number" ? r : r.length, lt = Math.max(2, lt), f = u / lt, ot = ut.shape = new n.Shape({
                            style: !1
                        }).addTo(ut), bt = ut.sticks = new n.Shape({
                            style: !1
                        }).addTo(ut), c <= 0 && bt.removeFrom(), d = ot.graphics, d.c(), li = bt.graphics, li.c(), yi = c / 10 * 8, kt = c, ut.selectPoints ? (ut.selectedBalls = new n.SelectionSet, ut.selectedRect1s = new n.SelectionSet, ut.selectedRect2s = new n.SelectionSet, ut.selectionManager = new n.SelectionManager([ut.selectedBalls, ut.selectedRect1s, ut.selectedRect2s], "ctrl", !1)) : ut.selectionManager = new n.SelectionManager(null, "ctrl"), ai = n.mobile(), st = ut.controls = new n.Container({
                            style: !1
                        }).addTo(ut), ut.interactive && st.drag({
                            onTop: !ai
                        }), ft = [], fi = [], vt = [], p = 0; p < lt; p++) {
                        if (w = new n.Container({
                                style: !1
                            }).addTo(st), w.num = p, typeof r == "number" ? (hi = n.Pick.choose(f), si = new n.Container(hi, i, null, null, !1).addTo(ut).loc({
                                x: p * u / (lt - 1) - hi / 2,
                                y: p % 2 * hi
                            }), l = new n.Circle(yi, ut.selectPoints && ut.selectedBalls.isSelected(p) ? b : n.light, n.dark, 2, null, null, null, null, !1).centerReg(si).loc({
                                x: hi / 2,
                                y: 0
                            }), it = new n.Rectangle(kt, kt, ut.selectPoints && ut.selectedRect1s.isSelected(p) ? b : ri(e), c == 0 ? null : n.dark, c == 0 ? null : 2, null, null, null, null, !1).centerReg(si).loc({
                                x: 0,
                                y: 0
                            }), at = new n.Rectangle(kt, kt, ut.selectPoints && ut.selectedRect2s.isSelected(p) ? b : ri(e), c == 0 ? null : n.dark, c == 0 ? null : 2, null, null, null, null, !1).centerReg(si).loc({
                                x: hi,
                                y: 0
                            }), wi = si.localToLocal(l.x, l.y, st), l.x = wi.x, l.y = wi.y, l.addTo(w, null, !1), bi = si.localToLocal(it.x, it.y, st), it.x = e == "none" ? 0 : bi.x - l.x, it.y = e == "none" ? 0 : bi.y - l.y, it.addTo(w, null, !1), ki = si.localToLocal(at.x, at.y, st), at.x = e == "none" ? 0 : ki.x - l.x, at.y = e == "none" ? 0 : ki.y - l.y, at.addTo(w, null, !1), w.x = l.x, w.y = l.y, l.x = 0, l.y = 0, e == "none" && l.addTo(w, null, !1)) : (yt = r[p], pi = yt[8] ? yt[8] : e, w.loc({
                                x: yt[0],
                                y: yt[1]
                            }), l = new n.Circle(yi, n.light, n.dark, 2, null, null, null, null, !1).centerReg({
                                add: !1
                            }).addTo(w).loc({
                                x: yt[2],
                                y: yt[3]
                            }), it = new n.Rectangle(kt, kt, ri(pi), c == 0 ? null : n.dark, c == 0 ? null : 2, null, null, null, null, !1).centerReg({
                                add: !1
                            }).addTo(w, 0).loc({
                                x: yt[4],
                                y: yt[5]
                            }), at = new n.Rectangle(kt, kt, ri(pi), c == 0 ? null : n.dark, c == 0 ? null : 2, null, null, null, null, !1).centerReg({
                                add: !1
                            }).addTo(w, 0).loc({
                                x: yt[6],
                                y: yt[7]
                            })), l.mySet = w, l.rect1 = it, l.rect2 = at, l.index = p, ai) l.on("mousedown", ir);
                        else l.on("dblclick", gi);
                        it.ball = l;
                        it.other = at;
                        at.ball = l;
                        at.other = it;
                        c == 0 && (l.expand(10), it.expand(10), at.expand(10));
                        ai && (l.expand(), it.expand(), at.expand());
                        di = [w, l, it, at, yt ? yt[8] : e];
                        ft.push(di);
                        vt.push(l);
                        fi.push(w)
                    }
                    vi = !1;
                    nr = n.mobile();
                    ut.drawShape = function() {
                        d.c();
                        var b = nr ? 10 : 6,
                            n, u, e, f, p, y, s, h, r, c, l, w, o, a, v;
                        if (i < b)
                            for (d.s("rgba(0,0,0,.01)").ss(b), f = ft[0][0], r = f.localToLocal(ft[0][1].x, ft[0][1].y, ot), d.mt(r.x, r.y), n = 0; n < ft.length; n++) u = n, e = (n + 1) % ft.length, f = ft[u][0], p = ft[u][1], y = ft[u][2], s = ft[u][3], h = ft[e][0], c = ft[e][1], l = ft[e][2], o = f.localToLocal(s.x, s.y, ot), a = h.localToLocal(l.x, l.y, ot), v = h.localToLocal(c.x, c.y, ot), n != ft.length - 1 && d.bt(o.x, o.y, a.x, a.y, v.x, v.y);
                        for (ut.colorCommand || (ut.colorCommand = d.s(ut._color).command, t && t.type && ut.specialColor(ut.colorCommand, t, ut)), ut.thicknessCommand || (ut.thicknessCommand = d.ss(ut._thickness, nt.caps, nt.joints, nt.miterLimit, nt.ignoreScale).command), ut._dashed && (ut.dashedCommand || (ut.dashedCommand = d.sd(Array.isArray(ut._dashed) ? ut._dashed : [10, 10], ut._dashedOffset).command)), f = ft[0][0], r = f.localToLocal(ft[0][1].x, ft[0][1].y, ot), d.mt(r.x, r.y), li.c().s(ut.stickColor).ss(ut.stickThickness), n = 0; n < ft.length; n++) u = n, e = (n + 1) % ft.length, f = ft[u][0], p = ft[u][1], y = ft[u][2], s = ft[u][3], h = ft[e][0], c = ft[e][1], l = ft[e][2], o = f.localToLocal(s.x, s.y, ot), a = h.localToLocal(l.x, l.y, ot), v = h.localToLocal(c.x, c.y, ot), n != ft.length - 1 && d.bt(o.x, o.y, a.x, a.y, v.x, v.y), r = f.localToLocal(p.x, p.y, ot), w = f.localToLocal(y.x, y.y, ot), n == 0 && (y.visible = 0), n != 0 && li.mt(r.x, r.y).lt(w.x, w.y), n != ft.length - 1 && li.mt(r.x, r.y).lt(o.x, o.y), n == ft.length - 1 && (s.visible = 0);
                        ut._dashed && d.append(ut.dashedCommand);
                        d.append(ut.thicknessCommand);
                        d.append(ut.colorCommand)
                    };
                    ut.drawShape();
                    t.type && (ut.color = t);
                    st.on("mousedown", function(n) {
                        var i, u, f, r, t;
                        if (ht = n.target.stage, !ut.lockControls) {
                            if (ut.selectPoints && (ut.keyFocus = !0), ci = {
                                    x: n.target.x,
                                    y: n.target.y
                                }, n.target.rect1) l = n.target, l.startX = l.x, l.startY = l.y, l.rect1.startX = l.rect1.x, l.rect1.startY = l.rect1.y, l.rect2.startX = l.rect2.x, l.rect2.startY = l.rect2.y;
                            else if (i = n.target, i.startX = i.x, i.startY = i.y, l = i.ball, u = l.index, f = e, zot(ft[u][4]) || (f = ft[u][4]), f == "straight") {
                                var o = i.other,
                                    s = o.x - l.x,
                                    h = o.y - l.y;
                                o.stickLength = Math.sqrt(Math.pow(s, 2) + Math.pow(h, 2))
                            }
                            if (ut.selectPoints && (r = ut.selectionManager.currentSet, r && r.selections && r.selections.length > 0))
                                for (p = 0; p < r.selections.length; p++) t = ut.pointObjects[r.selections[p]], t[1].startX = t[1].x, t[1].startY = t[1].y, t[2].startX = t[2].x, t[2].startY = t[2].y, t[3].startX = t[3].x, t[3].startY = t[3].y
                        }
                    });
                    ut.selectPoints && st.tap(function(t) {
                        var i, u, r;
                        for (t.target.rect1 ? (i = t.target, ut.selectedBalls.toggle(i.parent.num)) : (u = t.target, u.color = "white", i = u.ball, i.rect1 == u ? ut.selectedRect1s.toggle(i.parent.num) : ut.selectedRect2s.toggle(i.parent.num)), p = 0; p < ut.pointObjects.length; p++) r = ut.pointObjects[p], r[1].color = ut.selectedBalls.isSelected(p) ? n.white : n.light, r[2].color = ut.selectedRect1s.isSelected(p) ? n.white : ri(r[4]), r[3].color = ut.selectedRect2s.isSelected(p) ? n.white : ri(r[4]);
                        ht.update()
                    });
                    st.on("pressmove", function(n) {
                        var i, u, f, r, t;
                        if (!ut.lockControls)
                            if (ut.selectPoints) {
                                if (i = ti(), i.indexOf(n.target) == -1) pt(n.target), ut.drawShape();
                                else if (i.length > 0) {
                                    for (u = n.target.x - n.target.startX, f = n.target.y - n.target.startY, r = 0; r < i.length; r++) t = i[r], t.x = t.startX + u, t.y = t.startY + f, pt(t);
                                    ut.drawShape()
                                }
                            } else pt(n.target), ut.drawShape()
                    });
                    st.on("pressup", function(n) {
                        if (!ut.lockControls) {
                            var i = n.target.x != ci.x || n.target.y != ci.y,
                                t = new createjs.Event("change");
                            n.target.rect1 ? (t.controlType = "bezierPoint", rr(n.target)) : t.controlType = "bezierHandle";
                            i && ut.dispatchEvent(t)
                        }
                    });
                    ut.changeControl = function(n, t, i, r, u, f, e, o, s) {
                        var c, h;
                        if (c = zob(ut.changeControl, arguments, "index, type, rect1X, rect1Y, rect2X, rect2Y, circleX, circleY, update")) return c;
                        if (zot(n)) {
                            for (p = 0; p < ft.length; p++) ut.changeControl(p, t, i, r, u, f, e, o);
                            return
                        }
                        h = ft[n];
                        h[4] = t;
                        t == "none" ? (zot(e) || (h[2].x = e), zot(o) || (h[2].y = o), h[2].x = h[1].x, h[2].y = h[1].y, h[3].x = h[1].x, h[3].y = h[1].y, h[1].parent.addChild(h[1])) : (zot(i) || (h[2].x = i), zot(r) || (h[2].y = r), zot(u) || (h[3].x = u), zot(f) || (h[3].y = f), zot(e) || (h[1].x = e), zot(o) || (h[1].y = o), h[1].parent.addChildAt(h[1], 0));
                        s && (ut.update(), ht && ht.update())
                    };
                    ut.transformPoints = function(t, i, r, u, f) {
                        return zot(f) && (f = !0), ut.points = n.transformPoints(ut.points, t, i, r, u), f && ut.approximateBounds(), ut
                    };
                    ut.traverse = function(t, i, r, u) {
                        var f = n.copy(ut.segmentRatios),
                            e, o, s;
                        f.unshift(0);
                        zot(r) && (r = i + 1);
                        e = i < r;
                        e ? (o = f[i] * 100, s = f[r] * 100) : (o = 50 + (100 - f[i] * 100) / 2, s = 50 + (100 - f[r] * 100) / 2);
                        t.percentComplete = t.zimStartPercent = o;
                        t.animate({
                            ease: "linear",
                            props: {
                                path: ut
                            },
                            rewind: !e,
                            time: u,
                            events: !0
                        });
                        t.on("animation", function(n) {
                            if (t.percentComplete > s || t.percentComplete == 0) {
                                t.stopAnimate();
                                n.remove();
                                var i = new createjs.Event("traversed");
                                i.obj = t;
                                ut.dispatchEvent(i)
                            }
                        });
                        return ut
                    };
                    ut.reversePoints = function() {
                        return r = n.copy(ut.points), ut.points = n.reversePoints(n.copy(ut.points)), ut.update(), ut
                    };
                    ut.appendPoints = function(t, i) {
                        var r = n.copy(ut.points);
                        return ut.points = n.appendPoints(r, t, i), ut.update(), ut
                    };
                    ut.prependPoints = function(t, i) {
                        var u = n.copy(ut.points);
                        return ut.points = n.rependPoints(u, r, i), ut.update(), ut
                    };
                    ut.splitPoints = function(t) {
                        var r = n.copy(ut.points);
                        if (!(t < 1) && !(t > r.length - 1)) {
                            var u = n.splitPoints(r, t),
                                f = u[0],
                                e = u[1],
                                i = ut.clone();
                            return ut.points = f, ut.update(), i.points = e, ut.parent && i.addTo(ut.parent), i
                        }
                    };
                    ut.makeBlob = function(t, i) {
                        var r;
                        return zot(t) && (t = "mirror"), zot(i) && (i = 5), r = n.copy(ut.points), n.loop(r, function(n, i, r) {
                            n[8] || (n[8] = "mirror");
                            i == 0 && (t == "free" && (n[4] = n[5] = 0), n[8] = t);
                            i == r - 1 && (t == "free" && (n[6] = n[7] = 0), n[8] = t)
                        }), Math.abs(r[0][0] - r[r.length - 1][0]) < i && Math.abs(r[0][1] - r[r.length - 1][1]) < i && (r[0][4] = r[r.length - 1][4], r[0][5] = r[r.length - 1][5], r.pop()), new n.Blob({
                            points: r,
                            borderColor: ut.color,
                            borderWidth: ut.thickness,
                            showControls: ut.controlsVisible,
                            interactive: ut.interactive,
                            onTop: ut.onTop,
                            dashed: ut.dashed,
                            stickColor: ut.stickColor,
                            stickThickness: ut.stickThickness
                        })
                    };
                    ut.update = function(n) {
                        return n ? ut.points = ut.pointsAdjusted : ut.drawShape(), ut.zimAnimateChanged = !0, ut
                    };
                    ut.interactive && (a && ot.drag({
                        onTop: !1
                    }), dt = ot.on("mousedown", function(n) {
                        ht = n.target.stage;
                        ci = {
                            x: ot.x,
                            y: ot.y
                        };
                        ut.selectPoints && (ut.keyFocus = !0);
                        ur()
                    }), gt = ot.on("pressmove", function() {
                        st.x = ot.x;
                        st.y = ot.y;
                        bt.x = ot.x;
                        bt.y = ot.y
                    }), ni = ot.on("pressup", function() {
                        var i = ot.x != ci.x || ot.y != ci.y,
                            t = ot.localToLocal(ut.regX, ut.regY, ut.parent),
                            n;
                        ut.x = t.x;
                        ut.y = t.y;
                        st.x = st.y = bt.x = bt.y = ot.x = ot.y = 0;
                        i && (n = new createjs.Event("change"), n.controlType = "move", ut.dispatchEvent(n));
                        ht && ht.update()
                    }), ut.move || ii(!0));
                    ut.toggleEvent = ut.on("mousedown", function() {
                        ut.allowToggle && (ct || (ut.showControls(), ut.dispatchEvent("controlsshow")))
                    });
                    ut.added(function() {
                        ht = ut.stage;
                        ut.toggleStageEvent && ht.off("stagemousedown", ut.toggleStageEvent);
                        ut.toggleStageEvent = ht.on("stagemousedown", function(t) {
                            ut.allowToggle && ut.stage && ct && !ut.hitTestPoint(t.stageX / n.scaX, t.stageY / n.scaY, !1) && (ut.hideControls(), ut.dispatchEvent("controlshide"))
                        })
                    });
                    ut.clickEvent = ut.on("click", function() {
                        ut.ctrlKey && setTimeout(function() {
                            ut.clone(!0).addTo(ut.stage).mov(0, 100);
                            ut.allowToggle && (ut.hideControls(), ut.dispatchEvent("controlshide"));
                            var n = new createjs.Event("change");
                            n.controlType = "move";
                            ut.dispatchEvent(n);
                            ut.stage.update()
                        }, 50)
                    });
                    ut.hideControls = function() {
                        return ut.toggled = !1, st.visible = !1, bt.visible = !1, ct = !1, ut.stage && ut.stage.update(), !ut.allowToggle && ut.move && ii(), ut
                    };
                    s || ut.hideControls();
                    ut.showControls = function() {
                        return ut.toggled = !0, st.visible = !0, bt.visible = !0, ct = !0, st.x = ot.x, st.y = ot.y, bt.x = ot.x, bt.y = ot.y, ut.addChildAt(ot, 0), ut.move && !ut.allowToggle && oi(), ut.stage && ut.stage.update(), ut
                    };
                    ut.toggle = function(n) {
                        return n === !0 ? ut.showControls() : n === !1 ? ut.hideControls() : ct ? ut.hideControls() : ut.showControls(), ut
                    };
                    ut.recordData = function(n) {
                        zot(n) && (n = !1);
                        var t = {
                            type: "Blob",
                            index: ut.parent ? ut.parent.getChildIndex(ut) : -1,
                            x: ut.x,
                            y: ut.y,
                            points: ut.recordPoints(),
                            color: ut.color,
                            thickness: ut.thickness,
                            move: ut.move,
                            toggle: ut.allowToggle,
                            controlsVisible: ct
                        };
                        return n ? JSON.stringify(t) : t
                    };
                    ut.setData = function(n, t) {
                        var i, r, u;
                        if (!zot(n)) {
                            if (t) try {
                                n = JSON.parse(n)
                            } catch (f) {
                                return
                            }
                            i = n.index;
                            zot(i) && (i = -1);
                            delete n.index;
                            r = n.points;
                            zot(r) || ut.setPoints(r);
                            delete n.points;
                            ut.num = r.length;
                            for (u in n) ut[u] = n[u];
                            return ut.parent && ut.parent.setChildIndex(ut, i), ut.update(), ut
                        }
                    };
                    ut.recordPoints = function(t) {
                        var i, r, u;
                        return zot(t) && (t = !1), i = ut.points, t && (ut.pane || (r = ut.pane = new n.Pane({
                            container: ut.stage,
                            width: Math.min(500, ut.stage.width - 20),
                            height: Math.min(500, ut.stage.height - 20),
                            draggable: !0
                        }), u = ut.textArea = new n.TextArea(Math.min(400, ut.stage.width - 70), Math.min(400, ut.stage.height - 70)), u.centerReg(r)), ut.textArea.text = JSON.stringify(i), ut.pane.show()), i
                    };
                    ut.setPoints = function(n) {
                        for (var t, i, r = 0; r < n.length; r++)(t = ft[r], i = n[r], zot(t)) || (t[0].x = i[0], t[0].y = i[1], t[1].x = i[2], t[1].y = i[3], t[2].x = i[4], t[2].y = i[5], t[3].x = i[6], t[3].y = i[7], t[4] = i[8]);
                        return ut.update(), ut
                    };
                    tt !== !1 && n.styleTransforms(ut, et);
                    ut.clone = function(t, i) {
                        var s = [],
                            l = !1,
                            r;
                        return n.loop(ut.pointControls, function(n) {
                            n.scaleX + n.scaleY + n.regX + n.regY + n.rotation != 2 && (l = !0);
                            s.push([n.scaleX, n.scaleY, n.regX, n.regY, n.rotation])
                        }), r = ut.cloneProps(new n.Squiggle(i ? ut.colorCommand : t || !n.isPick(ui[0]) ? ut.color : ui[0], ut.thickness, ut.recordPoints(), u, f, e, o, st.visible, h, c, ut.allowToggle, ut.move, v, y, ut.stickColor, ut.stickThickness, b, k, ut.editPoints, g, nt, tt, ut.group, rt)), l && (n.loop(r.pointControls, function(n, t) {
                            n.scaleX = s[t][0];
                            n.scaleY = s[t][1];
                            n.regX = s[t][2];
                            n.regY = s[t][3];
                            n.rotation = s[t][4]
                        }), r.update()), ut.linearGradientParams && r.linearGradient.apply(r, ut.linearGradientParams), ut.radialGradientParams && r.radialGradient.apply(r, ut.radialGradientParams), r
                    };
                    ut.shape.on("mousedown", function(t) {
                        (ht = t.target.stage, ut.editPoints) && (ut.controlsVisible ? (ut.pressX = t.stageX / n.scaX, ut.pressY = t.stageY / n.scaX) : (ut.pressX = null, ut.pressY = null))
                    });
                    ut.addPointFactor = 10;
                    ut.addMinDistance = 15;
                    ut.shape.on("pressup", function(t) {
                        if (ut.editPoints && ut.pressX && Math.abs(ut.pressX - t.stageX / n.scaX) < ei && Math.abs(ut.pressY - t.stageY / n.scaY) < ei) {
                            ut.selectPoints && (ut.lastPoints = n.copy(ut.points));
                            var u = ut.points,
                                r = ut.globalToLocal(t.stageX / n.scaX, t.stageY / n.scaY),
                                i = n.closestPointAlongCurve(r, ut.segmentPoints);
                            if (ut.editPoints == "anywhere") u.splice(i + 1, 0, [r.x, r.y, 0, 0, 0, 0, 0, 0]), ut.points = u, ut.changeControl({
                                index: i + 1,
                                type: "mirror",
                                update: !0
                            });
                            else {
                                var f = ut.pointsAdjusted,
                                    l = ut.getSegmentPoint(f[i], f[(i + 1) % f.length]),
                                    a = n.distanceAlongCurve(l),
                                    o = Math.round(a / ut.addPointFactor),
                                    v = ut.interpolate(o, i, !1, u),
                                    e = 1e4,
                                    s;
                                if (n.loop(v, function(t, i) {
                                        var u = n.dist(t, r);
                                        u < e && (e = u, s = i)
                                    }), e < ut.addMinDistance) {
                                    var h = ut.segmentRatios,
                                        y = h[i],
                                        c = i > 0 ? h[i - 1] : 0;
                                    ut.addPoint(100 * (c + (y - c) * (s / (o + 1))))
                                }
                            }
                            ut.lastSelectedIndex = i + 1;
                            ut.lastSelected = ut.controls.getChildAt(ut.lastSelectedIndex);
                            ut.stage.update()
                        }
                    });
                    ut.controls.on("click", function(n) {
                        (ut.lastSelected = n.target.parent, ut.lastSelectedIndex = ut.controls.getChildIndex(n.target.parent), ut.editPoints) && ut.selectionManager.shiftKey && tr(n)
                    });
                    ut.controls.hold(tr);
                    ct || ut.hideControls();
                    ut.dispatchEvent("update")
                }

                function ti() {
                    var t = [],
                        n = ut.selectionManager.currentSet,
                        i, r;
                    if (n && n.selections && n.selections.length > 0)
                        for (i = 0; i < n.selections.length; i++)
                            if (r = ut.pointObjects[n.selections[i]], n == ut.selectedBalls) t.push(r[1]);
                            else if (n == ut.selectedRect1s) t.push(r[2]);
                    else if (n == ut.selectedRect2s) t.push(r[3]);
                    else continue;
                    return t
                }

                function wt(n) {
                    if (n.type == "Circle") {
                        var t = n,
                            i = t.mySet,
                            r = t.rect1,
                            u = t.rect2;
                        r.x -= t.x;
                        r.y -= t.y;
                        u.x -= t.x;
                        u.y -= t.y;
                        i.x += t.x;
                        i.y += t.y;
                        t.x = 0;
                        t.y = 0
                    }
                }

                function oi() {
                    ut.move != "always" && (yt || (yt = !0, ot.drag({
                        onTop: !1
                    }), dt = ot.on("mousedown", dt), gt = ot.on("pressmove", gt), ni = ot.on("pressup", ni)))
                }

                function ii(n) {
                    ut.move != "always" && (n || yt) && (yt = !1, ot.noDrag(), ot.off("mousedown", dt), ot.off("pressmove", gt), ot.off("pressup", ni))
                }

                function vi() {
                    if (ut.selectPoints) {
                        ut.keyFocus = !0;
                        var n = document.activeElement;
                        n && n.blur()
                    }
                }

                function kt(n, t, i) {
                    return {
                        x: n.x + (t.x - n.x) * i,
                        y: n.y + (t.y - n.y) * i
                    }
                }

                function ri(t, i, r, u, f, e, o, s) {
                    var h = t.length - 1,
                        y = 0,
                        p = 0,
                        k, d;
                    u == 100 && ut.type == "Squiggle" && (u = 99.99);
                    u = (u + 1e5) % 100;
                    n.loop(r, function(n, t) {
                        if (u / 100 < n) return h = t, p = n, !0;
                        y = n
                    });
                    var l = ut.segmentPoints[h],
                        a = p > 0 ? (u / 100 - y) / (p - y) : 0,
                        c = n.pointAlongCurve(l, a, null, s),
                        v = [c.x, c.y, 0, 0];
                    if (!e) {
                        if (o) {
                            ut.interpolatedPoints.push({
                                x: c.x,
                                y: c.y,
                                r: u / 100
                            });
                            return
                        }
                        if (f != "none") {
                            var w = kt(l[0], l[1], a),
                                g = kt(l[1], l[2], a),
                                b = kt(l[2], l[3], a),
                                nt = kt(w, g, a),
                                tt = kt(g, b, a);
                            v[4] = nt.x - c.x;
                            v[5] = nt.y - c.y;
                            v[6] = tt.x - c.x;
                            v[7] = tt.y - c.y;
                            k = ut.localToLocal(w.x, w.y, i[h]);
                            t[h][6] = k.x;
                            t[h][7] = k.y;
                            d = ut.localToLocal(b.x, b.y, i[(h + 1) % t.length]);
                            t[(h + 1) % t.length][4] = d.x;
                            t[(h + 1) % t.length][5] = d.y
                        }
                        f && (v[8] = f);
                        t.splice(h + 1, 0, v)
                    }
                }
                var si, et, hi, ci, lt, at, ct, ui, ut, ht, ft, vt, fi, ot, dt, gt, ni, yt, ei, pt, st, bt;
                if (si = zob(n.Squiggle, arguments, "color, thickness, points, length, controlLength, controlType, lockControlType, showControls, lockControls, handleSize, allowToggle, move, dashed, onTop, stickColor, stickThickness, selectColor, selectPoints, editPoints, interactive, strokeObj, style, group, inherit", this)) return si;
                if (z_d("53.2"), this.group = it, et = tt === !1 ? {} : n.getStyle("Squiggle", this.group, rt), zot(i) && (i = et.thickness != null ? et.thickness : 6), zot(u) && (u = et.length != null ? et.length : 300), zot(r) && (r = et.points != null ? et.points : 5), typeof r == "string" && (hi = new n.SVGContainer, r = hi.processPath(r)), ci = typeof r != "number", lt = typeof r == "number" ? r : r.length, lt != 0) {
                    zot(f) && (f = et.controlLength != null ? et.controlLength : u / lt);
                    this.zimCustomShape_constructor(u, f, null, null, !1);
                    this.type = "Squiggle";
                    this.mouseChildren = !0;
                    zot(v) && (v = et.dashed != null ? et.dashed : !1);
                    zot(t) && (t = et.color != null ? et.color : n.blue);
                    t.style && (this.colorCommand = t, t = "black");
                    zot(e) && (e = et.controlType != null ? et.controlType : null);
                    at = e;
                    zot(e) && (e = "mirror");
                    zot(o) && (o = et.lockControlType != null ? et.lockControlType : !1);
                    zot(g) && (g = et.interactive != null ? et.interactive : !0);
                    zot(s) && (s = et.showControls != null ? et.showControls : g);
                    ct = s;
                    zot(h) && (h = et.lockControls != null ? et.lockControls : !g);
                    zot(c) && (c = et.handleSize != null ? et.handleSize : n.mobile() ? 20 : 10);
                    zot(l) && (l = et.allowToggle != null ? et.allowToggle : g);
                    zot(a) && (a = et.move != null ? et.move : g);
                    zot(p) && (p = et.stickColor != null ? et.stickColor : "#111");
                    zot(w) && (w = et.stickThickness != null ? et.stickThickness : 1);
                    zot(b) && (b = et.selectColor != null ? et.selectColor : "#fff");
                    zot(k) && (k = et.selectPoints != null ? et.selectPoints : g);
                    this.stickColor = p;
                    this.stickThickness = w;
                    zot(y) && (y = et.onTop != null ? et.onTop : !0);
                    zot(d) && (d = et.editPoints != null ? et.editPoints : g);
                    zot(nt) && (nt = et.strokeObj != null ? et.strokeObj : {});
                    ui = ai(t);
                    t = n.Pick.choose(t);
                    ut = this;
                    this.types = ["mirror", "straight", "free", "none"];
                    this.interactive = g;
                    this.num = lt;
                    this.onTop = y;
                    this.move = a;
                    this.editPoints = d;
                    this.allowToggle = l;
                    this.lockControlType = o;
                    this.selectPoints = k;
                    this.lockControls = h;
                    ut._color = t;
                    ut._thickness = i;
                    ut._dashed = v;
                    ut._dashed && !Array.isArray(ut._dashed) && (ut._dashed = [10, 10]);
                    yt = ut.move;
                    ei = 2;
                    at && typeof r != "number" && n.loop(r, function(n) {
                        n[8] = at;
                        at == "none" && (n[4] = n[5] = n[6] = n[7] = 0)
                    });
                    li();
                    ut.selectionManager.on("keydown", function(n) {
                        var i, r, t;
                        if (ut.selectPoints && ut.keyFocus && n.keyCode >= 37 && n.keyCode <= 40 && (i = ti(), i.length > 0)) {
                            for (r = 0; r < i.length; r++) t = i[r], n.keyCode == 37 ? t.x -= ut.selectionManager.shiftKey ? 10 : 1 : n.keyCode == 39 ? t.x += ut.selectionManager.shiftKey ? 10 : 1 : n.keyCode == 38 ? t.y -= ut.selectionManager.shiftKey ? 10 : 1 : n.keyCode == 40 && (t.y += ut.selectionManager.shiftKey ? 10 : 1), pt(t);
                            ut.drawShape();
                            ut.dispatchEvent("update");
                            ut.stage && ut.stage.update()
                        }
                    });
                    ut.selectionManager.on("keyup", function(n) {
                        var t, i;
                        if (ut.selectPoints && ut.keyFocus && n.keyCode >= 37 && n.keyCode <= 40 && (t = ti(), t.length > 0))
                            for (i = 0; i < t.length; i++) wt(t[i])
                    });
                    ut.selectionManager.on("undo", function() {
                        if (ut.selectPoints && ut.keyFocus && ut.lastPoints) {
                            var t = n.copy(ut.lastPoints);
                            ut.lastPoints = n.copy(ut.points);
                            ut.points = t;
                            ut.stage && ut.stage.update()
                        }
                    });
                    pt = function(n) {
                        var t, f, o, r, i, s, u, h, c;
                        if (!ut.lockControls)
                            if (n.rect1) t = n, f = t.x - t.startX, o = t.y - t.startY, t.rect1.x = t.rect1.startX + f, t.rect1.y = t.rect1.startY + o, t.rect2.x = t.rect2.startX + f, t.rect2.y = t.rect2.startY + o;
                            else if (r = n, i = r.other, t = r.ball, s = t.index, u = e, zot(ft[s][4]) || (u = ft[s][4]), u == "straight" || u == "mirror")
                            if (h = r.x - t.x, c = r.y - t.y, u == "mirror") i.x = t.x - h, i.y = t.y - c;
                            else {
                                var l = Math.atan2(c, h),
                                    a = -i.stickLength * Math.cos(l + Math.PI),
                                    v = -i.stickLength * Math.sin(l + Math.PI);
                                i.x = t.x - a;
                                i.y = t.y - v
                            }
                    };
                    Object.defineProperty(ut, "move", {
                        get: function() {
                            return a
                        },
                        set: function(n) {
                            a != n && (a = n, n ? oi() : ii())
                        }
                    });
                    Object.defineProperty(ut, "interactive", {
                        get: function() {
                            return g
                        },
                        set: function(n) {
                            g = n;
                            ct = g;
                            ut.allowToggle = g;
                            ut.editPoints = g;
                            ut.lockControls = !g;
                            ut.selectPoints = g;
                            ut.move = g;
                            var t = ut.points;
                            ut.points = t
                        }
                    });
                    Object.defineProperty(ut, "allowToggle", {
                        get: function() {
                            return l
                        },
                        set: function(n) {
                            l != n && (l = n, l ? ut.move && oi() : !ct && ut.move && ii())
                        }
                    });
                    bt = h;
                    Object.defineProperty(ut, "lockControls", {
                        get: function() {
                            return bt
                        },
                        set: function(n) {
                            bt = n;
                            n ? (ut.controls.mouseChildren = !1, ut.controls.mouseEnabled = !1) : (ut.controls.mouseChildren = !0, ut.controls.mouseEnabled = !0)
                        }
                    });
                    ut.lockControls = bt;
                    Object.defineProperty(ut, "controlsVisible", {
                        get: function() {
                            return ct
                        },
                        set: function(n) {
                            ct = n;
                            n ? ut.showControls() : ut.hideControls()
                        }
                    });
                    WW.KEYFOCUS != null && (n.KEYFOCUS = WW.KEYFOCUS);
                    Object.defineProperty(this, "keyFocus", {
                        get: function() {
                            return n.KEYFOCUS == ut
                        },
                        set: function() {
                            n.KEYFOCUS = ut
                        }
                    });
                    n.KEYFOCUS || vi();
                    Object.defineProperty(ut, "points", {
                        get: function() {
                            for (var u = [], i, t, r = 0; r < ft.length; r++) t = ft[r], i = [n.decimals(t[0].x), n.decimals(t[0].y), n.decimals(t[1].x), n.decimals(t[1].y), n.decimals(t[2].x), n.decimals(t[2].y), n.decimals(t[3].x), n.decimals(t[3].y)], t[4] && t[4] !== "mirror" && i.push(t[4]), u.push(i);
                            return u
                        },
                        set: function(t) {
                            var f = ut.x,
                                e = ut.y,
                                o = ut.visible,
                                i = [],
                                u = !1;
                            n.loop(ut.pointControls, function(n) {
                                n.scaleX + n.scaleY + n.regX + n.regY + n.rotation != 2 && (u = !0);
                                i.push([n.scaleX, n.scaleY, n.regX, n.regY, n.rotation])
                            });
                            ut.dispose(!0);
                            r = t;
                            li();
                            ut.lockControls = bt;
                            ut.x = f;
                            ut.y = e;
                            ut.visible = o;
                            u && (n.loop(ut.pointControls, function(n, t) {
                                n.scaleX = i[t][0];
                                n.scaleY = i[t][1];
                                n.regX = i[t][2];
                                n.regY = i[t][3];
                                n.rotation = i[t][4]
                            }), ut.update())
                        }
                    });
                    Object.defineProperty(ut, "pointsAdjusted", {
                        get: function() {
                            var u = [],
                                r, t, i, f = ut.pointObjects;
                            return n.loop(f.length, function(e) {
                                if (i = f[e], t = ft[e], i[0].rotation == 0 && i[0].scaleX == 0 && i[0].scaleY == 0) r = [n.decimals(t[0].x), n.decimals(t[0].y), n.decimals(t[1].x), n.decimals(t[1].y), n.decimals(t[2].x), n.decimals(t[2].y), n.decimals(t[3].x), n.decimals(t[3].y)];
                                else {
                                    var o = i[0].localToLocal(i[2].x, i[2].y, i[0].parent),
                                        s = i[0].localToLocal(i[3].x, i[3].y, i[0].parent);
                                    r = [n.decimals(t[0].x), n.decimals(t[0].y), n.decimals(t[1].x), n.decimals(t[1].y), n.decimals(o.x - t[0].x), n.decimals(o.y - t[0].y), n.decimals(s.x - t[0].x), n.decimals(s.y - t[0].y)]
                                }
                                t[4] && t[4] !== "mirror" && r.push(t[4]);
                                u.push(r)
                            }), u
                        },
                        set: function() {
                            zon && zogy("Squiggle() - pointsAdjusted is read only")
                        }
                    });
                    Object.defineProperty(ut, "pointObjects", {
                        get: function() {
                            return ft
                        },
                        set: function() {
                            zon && zogy("Squiggle() - pointObjects is read only - but its contents can be manipulated - use squiggle.update() after changes")
                        }
                    });
                    Object.defineProperty(ut, "pointControls", {
                        get: function() {
                            return fi
                        },
                        set: function() {
                            zon && zogy("Squiggle() - pointControls is read only - but its contents can be manipulated - use blob.update() after changes")
                        }
                    });
                    Object.defineProperty(ut, "pointCircles", {
                        get: function() {
                            return vt
                        },
                        set: function() {
                            zon && zogy("Squiggle() - pointCircles is read only - but its contents can be manipulated - use blob.update() after changes")
                        }
                    });
                    Object.defineProperty(ut, "segmentPoints", {
                        get: function() {
                            var i = [],
                                t = ut.pointsAdjusted;
                            return n.loop(t.length - 1, function(n) {
                                var r = ut.getSegmentPoint(t[n], t[n + 1]);
                                i.push(r)
                            }), i
                        },
                        set: function() {
                            zon && zogy("Squiggle() - segmentPoints is read only")
                        }
                    });
                    Object.defineProperty(ut, "segmentRatios", {
                        get: function() {
                            var r = [],
                                u = 0,
                                t, i;
                            return n.loop(ut.segmentPoints, function(t) {
                                var i = n.distanceAlongCurve(t);
                                r.push(i);
                                u += i
                            }), t = [], i = 0, n.loop(r, function(n) {
                                var r = n / u;
                                i += r;
                                t.push(i)
                            }), t
                        },
                        set: function() {
                            zon && zogy("Squiggle() - segmentRatios is read only")
                        }
                    });
                    ut.approximateBounds = function(t, i, r) {
                        var e, f, o, u;
                        if (zot(t) && (t = 80), zot(r) && (r = 0), t /= ut.num, e = ut.interpolate(t, null, !0, null, !0), f = n.boundsAroundPoints(e), ut.setBounds(f.x - r, f.y - r, f.width + r * 2, f.height + r * 2), i) {
                            if (!ut.parent) return zon && zogy("approximateBounds() - add to stage to first to see points"), ut;
                            for (ut.hitPathPoints ? ut.hitPathPoints.removeAllChildren() : ut.hitPathPoints = (new n.Container).addTo(), ut.hitPathPoints.top(), o = 0; o < e.length; o++) u = e[o], u = ut.localToGlobal(u.x, u.y), new n.Circle(3).loc(u.x, u.y, ut.hitPathPoints)
                        }
                        return ut
                    };
                    ut.getPointAngle = function(t) {
                        var e = ut.pointObjects[t][0],
                            i = ut.pointObjects[t][2],
                            r = ut.pointObjects[t][3],
                            u, f;
                        return e == ut.stage ? (u = new n.Point(i.x, i.y), f = new n.Point(r.x, r.y)) : (u = e.localToGlobal(i.x, i.y), f = e.localToGlobal(r.x, r.y)), n.angle(u.x, u.y, f.x, f.y)
                    };
                    ut.getSegmentPoint = function(n, t) {
                        if (!zot(n) && !zot(t)) {
                            (n[2] != 0 || n[3] != 0) && (n[4] -= n[2], n[5] -= n[3], n[6] -= n[2], n[7] -= n[3], n[0] += n[2], n[1] += n[3], n[2] = 0, n[3] = 0);
                            (t[2] != 0 || t[3] != 0) && (t[4] -= t[2], t[5] -= t[3], t[6] -= t[2], t[7] -= t[3], t[0] += t[2], t[1] += t[3], t[2] = 0, t[3] = 0);
                            var i = {
                                    x: n[0],
                                    y: n[1]
                                },
                                r = {
                                    x: n[0] + n[6],
                                    y: n[1] + n[7]
                                },
                                u = {
                                    x: t[0] + t[4],
                                    y: t[1] + t[5]
                                },
                                f = {
                                    x: t[0],
                                    y: t[1]
                                };
                            return (st.x != 0 || st.y != 0) && (i.x += st.x, r.x += st.x, u.x += st.x, f.x += st.x, i.y += st.y, r.y += st.y, u.y += st.y, f.y += st.y), [i, r, u, f]
                        }
                    };
                    ut.getAdjacentSegmentData = function(n) {
                        zot(n) && (n = 0);
                        var t = ut.pointsAdjusted;
                        return ut.num == 2 ? [
                            [ut.getSegmentPoint(t[0], t[1])],
                            [0]
                        ] : n == 0 ? [
                            [ut.getSegmentPoint(t[0], t[1]), ut.getSegmentPoint(t[1], t[2])],
                            [0, 1]
                        ] : n >= ut.num - 2 ? [
                            [ut.getSegmentPoint(t[ut.num - 3], t[ut.num - 2]), ut.getSegmentPoint(t[ut.num - 2], t[ut.num - 1])],
                            [ut.num - 3, ut.num - 2]
                        ] : [
                            [ut.getSegmentPoint(t[n - 1], t[n]), ut.getSegmentPoint(t[n], t[n + 1]), ut.getSegmentPoint(t[n + 1], t[n + 2])],
                            [n - 1, n, n + 1]
                        ]
                    };
                    ut.getCurvePoint = function(t, i, r, u, f) {
                        (zot(t) || isNaN(t)) && (t = 0);
                        zot(i) && (i = ut.segmentRatios);
                        zot(r) && (r = ut.segmentPoints);
                        zot(u) && (u = !1);
                        zot(f) && (f = !1);
                        var o = i,
                            l = r,
                            e = n.loop(o, function(n, i) {
                                if (n >= t) return i
                            }),
                            a = e > 0 ? o[e - 1] : 0,
                            c = e > 0 ? o[e] - o[e - 1] : o[e];
                        if (!c) return undefined;
                        var v = (t - a) / c,
                            h = n.pointAlongCurve(l[e], v, u, !0),
                            s = ut.localToGlobal(h.x, h.y);
                        return s.angle = h.angle, s.z = e, zot(s) ? undefined : s
                    };
                    this.addPoint = function(n, t) {
                        zot(n) && (n = 100);
                        var i = ut.points,
                            r = ut.segmentRatios,
                            u = ut.pointControls;
                        return t = t ? t : at, ri(i, u, r, n, t), ut.points = i, ut.num = i.length, ut
                    };
                    this.addPoints = function(t, i, r, u, f, e, o) {
                        var h, s, c;
                        return zot(e) && (e = n.copy(ut.points)), h = n.copy(ut.segmentRatios), s = 0, f && (ut.interpolatedPoints = []), u && (c = h.length * t), n.loop(h, function(h, l) {
                            f && ri(e, ut.pointControls, ut.segmentRatios, s * 100, i, !zot(r) && l != r, f, o);
                            var a = u ? Math.round(c * (h - s)) : t,
                                v = 1 / (a + 1);
                            n.loop(a, function(n) {
                                var u = s + (h - s) * v * (n + 1);
                                ri(e, ut.pointControls, ut.segmentRatios, u * 100, i, !zot(r) && l != r, f, o);
                                !f && t > 0 && (ut.points = e)
                            });
                            s = h
                        }), f && ut.type == "Squiggle" && ri(e, ut.pointControls, ut.segmentRatios, 100, i, !1, f, o), ut.stage && ut.stage.update(), ut.num = e.length, ut
                    };
                    this.interpolate = function(n, t, i, r, u) {
                        return zot(n) && (n = 1), ut.addPoints(n, "none", t, i, !0, r, u), ut.interpolatedPoints
                    };
                    ci && ut.approximateBounds();
                    this.dispose = function(t, i, r) {
                        if (ut.shape) {
                            if (n.gD(ut), ht && ut.toggleStageEvent && ht.off("stagemousedown", ut.toggleStageEvent), ut.controls.noDrag(), ut.controls.removeAllEventListeners(), ut.selectPoints && ut.selectionManager && ut.selectionManager.dispose(), ut.selectedBalls = null, ut.selectedRect1s = null, ut.selectedRect2s = null, ut.selectionManager = null, ut.off("mousedown", ut.toggleEvent), ut.off("click", ut.clickEvent), t) {
                                ut.shape.dispose();
                                ut.shape = null;
                                for (var u = 0; u < ut.points.length; u++) ut.pointObjects[u][0].removeAllEventListeners(), ut.pointObjects[u][1].removeAllEventListeners(), ut.pointObjects[u][2].removeAllEventListeners(), ut.pointObjects[u][3].removeAllEventListeners();
                                ut.controls.removeFrom(ut);
                                ut.sticks.dispose();
                                ft = null;
                                vt = null
                            } else ut.removeAllEventListeners(), ft = null, vt = null, r || this.zimCustomShape_dispose(!0);
                            return !0
                        }
                    }
                }
            }, n.extend(n.Squiggle, n.CustomShape, ["clone", "dispose"], "zimCustomShape", !1), n.Blob = function(t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut) {
                function pi() {
                    return arguments
                }

                function li(t) {
                    var r, i;
                    return (t == "circle" || t == "rectangle" || t == "triangle") && (t == "circle" && (t = new n.Circle(f)), t == "rectangle" && (t = new n.Rectangle(f * 2, f * 2).centerReg({
                        add: !1
                    })), t == "triangle" && (t = new n.Triangle(f * 2, f * 2, f * 2))), t.type == "Circle" || t.type == "Rectangle" || t.type == "Triangle" ? (i = t.getBounds(), t.type == "Circle" ? (r = 4, ci = e = f * 2 * .5523) : t.type == "Rectangle" ? (t.centerReg({
                        add: !1
                    }), r = [
                        [i.x - i.width / 2, i.y - i.height / 2],
                        [i.x + i.width / 2, i.y - i.height / 2],
                        [i.x + i.width / 2, i.y + i.height / 2],
                        [i.x - i.width / 2, i.y + i.height / 2]
                    ], ft.setBounds(i.x - i.width / 2, i.y - i.height / 2, i.width, i.height), ft.regX = t.regX - i.width / 2, ft.regY = t.regY - i.height / 2) : t.type == "Triangle" && (r = [
                        [t.three.x - t.width / 2, t.three.y + t.height / 2 + t.adjusted],
                        [t.two.x - t.width / 2, t.two.y + t.height / 2 + t.adjusted],
                        [t.one.x - t.width / 2, t.one.y + t.height / 2 + t.adjusted]
                    ], ft.setBounds(i.x - i.width / 2, i.y - i.height / 2, i.width, i.height)), r) : t
                }

                function vi() {
                    function nr(n) {
                        li ? (n.preventDefault(), di(n)) : (li = !0, setTimeout(function() {
                            li = !1
                        }, 300))
                    }

                    function di(n) {
                        var t, i, r;
                        ft.lockControlType || (t = n.target, i = ht[t.index][4] ? ht[t.index][4] : o, Math.abs(t.rect1.x) <= 2 && Math.abs(t.rect1.y) <= 2 && Math.abs(t.rect2.x) <= 2 && Math.abs(t.rect2.y) <= 2 && (i = "none"), i == "none" && t.parent.addChildAt(t, 0), i = ft.types[(ft.types.indexOf(i) + (ft.shiftKey ? -1 : 1) + ft.types.length) % ft.types.length], i == "none" && (t.rect1.x = t.rect1.y = t.rect2.x = t.rect2.y = 0, t.parent.addChild(t), n.stopImmediatePropagation()), ht[t.index][4] = i, t.rect1.color = g(i), t.rect2.color = g(i), ft.drawShape(), r = new createjs.Event("change"), r.controlType = "bezierSwitch", ft.dispatchEvent(r), t.stage.update())
                    }

                    function g(t) {
                        var i = {
                            mirror: n.purple,
                            free: n.yellow,
                            none: n.blue
                        };
                        return i[t] ? i[t] : n.pink
                    }

                    function tr(n) {
                        var t, i;
                        if (ft.selectPoints)
                            if (t = ri(), t && t.indexOf(n) == -1) kt(n);
                            else if (t && t.length > 0)
                            for (i = 0; i < t.length; i++) kt(t[i]);
                        else kt(n);
                        else kt(n)
                    }

                    function ir() {
                        if (ft.onTop) {
                            var n = ft.parent.numChildren - 1;
                            ft.parent.getChildAt(n).type == "Keyboard" && n--;
                            ft.parent.setChildIndex(ft, n)
                        }
                    }

                    function gi(t) {
                        var r, i;
                        if (t.target.type == "Circle") {
                            if (r = ft.lastSelectedIndex = ft.controls.getChildIndex(t.target.parent), ft.controls.numChildren <= 2) return;
                            i = ft.points;
                            ft.selectPoints && (ft.lastPoints = n.copy(i));
                            i.splice(r, 1);
                            ft.points = i;
                            ft.stage.update();
                            ft.lastSelected = ft.lastSelectedIndex = null
                        }
                    }
                    var rt, h, fi, vt, ki, dt, r, a, w, i, vi, b, hi, yi, pi, wi, li, gt;
                    if (st && st.removeAllEventListeners(), ft.selectPoints ? (ft.selectedBalls = new n.SelectionSet, ft.selectedRect1s = new n.SelectionSet, ft.selectedRect2s = new n.SelectionSet, ft.selectionManager = new n.SelectionManager([ft.selectedBalls, ft.selectedRect1s, ft.selectedRect2s], "ctrl", !1)) : ft.selectionManager = new n.SelectionManager(null, "ctrl"), lt = typeof u == "number" ? u : u.length, !(lt <= 0)) {
                        zot(ci) && (e = f * 4 / lt);
                        ot = ft.shape = new n.Shape({
                            style: !1
                        }).addTo(ft);
                        rt = ft.sticks = new n.Shape({
                            style: !1
                        }).addTo(ft);
                        l <= 0 && rt.removeFrom();
                        h = ot.graphics;
                        h.c();
                        fi = rt.graphics;
                        fi.c();
                        var bi = l / 10 * 8,
                            wt = l,
                            ai = n.mobile();
                        for (st = ft.controls = new n.Container({
                                style: !1
                            }).addTo(ft), ft.interactive && st.drag({
                                onTop: !ai
                            }), ht = [], ei = [], pt = [], vt = 0; vt < lt; vt++) {
                            if (r = new n.Container({
                                    style: !1
                                }).addTo(st), r.num = vt, typeof u == "number" ? (hi = n.Pick.choose(e), dt = new n.Container(hi, f, null, null, !1).reg(hi / 2, f).addTo(ft), dt.rotation = vt / lt * 360, i = new n.Circle(bi, ft.selectPoints && ft.selectedBalls.isSelected(vt) ? k : n.light, n.dark, 2, null, null, null, null, !1).centerReg(dt).loc({
                                    x: hi / 2,
                                    y: 0
                                }), a = new n.Rectangle(wt, wt, ft.selectPoints && ft.selectedRect1s.isSelected(vt) ? k : g(o), l == 0 ? null : n.dark, l == 0 ? null : 2, null, null, null, null, !1).centerReg(dt).loc({
                                    x: 0,
                                    y: 0
                                }), w = new n.Rectangle(wt, wt, ft.selectPoints && ft.selectedRect2s.isSelected(vt) ? k : g(o), l == 0 ? null : n.dark, l == 0 ? null : 2, null, null, null, null, !1).centerReg(dt).loc({
                                    x: hi,
                                    y: 0
                                }), yi = dt.localToLocal(i.x, i.y, st), i.x = yi.x, i.y = yi.y, i.addTo(r, null, !1), pi = dt.localToLocal(a.x, a.y, st), a.x = o == "none" ? 0 : pi.x - i.x, a.y = o == "none" ? 0 : pi.y - i.y, a.addTo(r, null, !1), wi = dt.localToLocal(w.x, w.y, st), w.x = o == "none" ? 0 : wi.x - i.x, w.y = o == "none" ? 0 : wi.y - i.y, w.addTo(r, null, !1), r.x = i.x, r.y = i.y, i.x = 0, i.y = 0, o == "none" && i.addTo(r, null, !1)) : (b = u[vt], vi = b[8] ? b[8] : o, r.loc({
                                    x: b[0],
                                    y: b[1]
                                }), i = new n.Circle(bi, n.light, n.dark, 2, null, null, null, null, !1).centerReg({
                                    add: !1
                                }).addTo(r).loc({
                                    x: b[2],
                                    y: b[3]
                                }), a = new n.Rectangle(wt, wt, g(vi), l == 0 ? null : n.dark, l == 0 ? null : 2, null, null, null, null, !1).centerReg({
                                    add: !1
                                }).addTo(r, 0).loc({
                                    x: b[4],
                                    y: b[5]
                                }), w = new n.Rectangle(wt, wt, g(vi), l == 0 ? null : n.dark, l == 0 ? null : 2, null, null, null, null, !1).centerReg({
                                    add: !1
                                }).addTo(r, 0).loc({
                                    x: b[6],
                                    y: b[7]
                                })), i.mySet = r, i.rect1 = a, i.rect2 = w, i.index = vt, l == 0 && (i.expand(10), a.expand(10), w.expand(10)), ai) i.on("mousedown", nr);
                            else i.on("dblclick", di);
                            a.ball = i;
                            a.other = w;
                            w.ball = i;
                            w.other = a;
                            ai && (i.expand(), a.expand(), w.expand());
                            ki = [r, i, a, w, b ? b[8] : o];
                            ht.push(ki);
                            pt.push(i);
                            ei.push(r)
                        }
                        li = !1;
                        ft.drawShape = function() {
                            var u, o, r, s, c, l, n, a, v, y, f, p, w, e;
                            for (h.c(), ft.colorCommand || (ft.colorCommand = h.f(ft._color).command, t && t.type && ft.specialColor(ft.colorCommand, t, ft)), (zot(ft._borderWidth) || ft._borderWidth > 0) && (zot(ft._borderColor) && zot(ft._borderWidth) || (zot(ft._borderColor) && (ft._borderColor = "black"), ft.borderColorCommand || (ft.borderColorCommand = h.s(ft._borderColor).command, ft._borderColor && ft._borderColor.type && ft.specialColor(ft.borderColorCommand, ft._borderColor, ft)), ft.borderWidthCommand || (ft.borderWidthCommand = h.ss(ft._borderWidth, tt.caps, tt.joints, tt.miterLimit, tt.ignoreScale).command), ft._dashed && (ft.borderDashedCommand || (ft.borderDashedCommand = h.sd(Array.isArray(ft._dashed) ? ft._dashed : [10, 10], ft._dashedOffset).command)))), r = ht[0][0], n = r.localToLocal(ht[0][1].x, ht[0][1].y, ot), h.mt(n.x, n.y), fi.c().s(ft.stickColor).ss(ft.stickThickness), e = 0; e < ht.length; e++) u = e, o = (e + 1) % ht.length, r = ht[u][0], i = ht[u][1], s = ht[u][2], c = ht[u][3], l = ht[o][0], a = ht[o][1], v = ht[o][2], f = r.localToLocal(c.x, c.y, ot), p = l.localToLocal(v.x, v.y, ot), w = l.localToLocal(a.x, a.y, ot), h.bt(f.x, f.y, p.x, p.y, w.x, w.y), n = r.localToLocal(i.x, i.y, ot), y = r.localToLocal(s.x, s.y, ot), fi.mt(n.x, n.y).lt(y.x, y.y), fi.mt(n.x, n.y).lt(f.x, f.y);
                            h.cp();
                            h.append(ft.colorCommand);
                            ft._dashed && h.append(ft.borderDashedCommand);
                            ft.borderWidthCommand && h.append(ft.borderWidthCommand);
                            ft.borderColorCommand && h.append(ft.borderColorCommand)
                        };
                        ft.drawShape();
                        t.type && (ft.color = t);
                        st.on("mousedown", function(n) {
                            var t, r, e, s, u, f, i;
                            if (!ft.lockControls) {
                                if (ft.selectPoints && (ft.keyFocus = !0), gt = {
                                        x: n.target.x,
                                        y: n.target.y
                                    }, n.target.rect1) t = n.target, t.startX = t.x, t.startY = t.y, t.rect1.startX = t.rect1.x, t.rect1.startY = t.rect1.y, t.rect2.startX = t.rect2.x, t.rect2.startY = t.rect2.y;
                                else if (r = n.target, r.startX = r.x, r.startY = r.y, t = r.ball, e = t.index, s = o, zot(ht[e][4]) || (s = ht[e][4]), s == "straight") {
                                    var h = r.other,
                                        c = h.x - t.x,
                                        l = h.y - t.y;
                                    h.stickLength = Math.sqrt(Math.pow(c, 2) + Math.pow(l, 2))
                                }
                                if (ft.selectPoints && (u = ft.selectionManager.currentSet, u && u.selections && u.selections.length > 0))
                                    for (f = 0; f < u.selections.length; f++) i = ft.pointObjects[u.selections[f]], i[1].startX = i[1].x, i[1].startY = i[1].y, i[2].startX = i[2].x, i[2].startY = i[2].y, i[3].startX = i[3].x, i[3].startY = i[3].y
                            }
                        });
                        ft.selectPoints && st.tap(function(t) {
                            var r, f, i, u;
                            for (t.target.rect1 ? (r = t.target, ft.selectedBalls.toggle(r.parent.num)) : (f = t.target, f.color = "white", r = f.ball, r.rect1 == f ? ft.selectedRect1s.toggle(r.parent.num) : ft.selectedRect2s.toggle(r.parent.num)), i = 0; i < ft.pointObjects.length; i++) u = ft.pointObjects[i], u[1].color = ft.selectedBalls.isSelected(i) ? n.white : n.light, u[2].color = ft.selectedRect1s.isSelected(i) ? n.white : g(u[4]), u[3].color = ft.selectedRect2s.isSelected(i) ? n.white : g(u[4]);
                            t.target.stage.update()
                        });
                        st.on("pressmove", function(n) {
                            var i, u, f, r, t;
                            if (!ft.lockControls)
                                if (ft.selectPoints) {
                                    if (i = ri(), i.indexOf(n.target) == -1) bt(n.target), ft.drawShape();
                                    else if (i.length > 0) {
                                        for (u = n.target.x - n.target.startX, f = n.target.y - n.target.startY, r = 0; r < i.length; r++) t = i[r], t.x = t.startX + u, t.y = t.startY + f, bt(t);
                                        ft.drawShape()
                                    }
                                } else bt(n.target), ft.drawShape()
                        });
                        st.on("pressup", function(n) {
                            if (!ft.lockControls) {
                                var i = n.target.x != gt.x || n.target.y != gt.y,
                                    t = new createjs.Event("change");
                                n.target.rect1 ? (t.controlType = "bezierPoint", tr(n.target)) : t.controlType = "bezierHandle";
                                i && ft.dispatchEvent(t)
                            }
                        });
                        ft.changeControl = function(n, t, i, r, u, f, e, o, s) {
                            var l, c, h;
                            if (l = zob(ft.changeControl, arguments, "index, type, rect1X, rect1Y, rect2X, rect2Y, circleX, circleY, update")) return l;
                            if (zot(n)) {
                                for (c = 0; c < ht.length; c++) ft.changeControl(c, t, i, r, u, f, e, o);
                                return ft
                            }
                            return h = ht[n], h[4] = t, t == "none" ? (zot(e) || (h[1].x = e), zot(o) || (h[1].y = o), h[2].x = h[1].x, h[2].y = h[1].y, h[3].x = h[1].x, h[3].y = h[1].y, h[1].parent.addChild(h[1])) : (zot(e) || (h[1].x = e), zot(o) || (h[1].y = o), zot(i) || (h[2].x = i), zot(r) || (h[2].y = r), zot(u) || (h[3].x = u), zot(f) || (h[3].y = f), h[1].parent.addChildAt(h[1], 0)), h[2].color = g(t), h[3].color = g(t), s && (ft.update(), ft.stage && ft.stage.update()), ft
                        };
                        ft.transformPoints = function(t, i, r, u, f) {
                            return zot(f) && (f = !0), ft.points = n.transformPoints(ft.points, t, i, r, u), f && ft.approximateBounds(), ft
                        };
                        ft.traverse = function(t, i, r, u) {
                            var f = n.copy(ft.segmentRatios),
                                e, o, s;
                            f.unshift(0);
                            zot(r) && (r = i + 1);
                            e = i < r;
                            e ? (o = f[i] * 100, s = f[r] * 100) : (o = 50 + (100 - f[i] * 100) / 2, s = 50 + (100 - f[r] * 100) / 2);
                            t.percentComplete = o;
                            t.animate({
                                ease: "linear",
                                props: {
                                    path: ft
                                },
                                rewind: !e,
                                time: u,
                                events: !0
                            });
                            t.on("animation", function(n) {
                                if (t.percentComplete > s || t.percentComplete == 0) {
                                    t.stopAnimate();
                                    n.remove();
                                    var i = new createjs.Event("traversed");
                                    i.obj = t;
                                    ft.dispatchEvent(i)
                                }
                            });
                            return ft
                        };
                        ft.reversePoints = function(t) {
                            return zot(t) && (t = !0), u = n.copy(ft.points), u.reverse(), t && u.unshift(u.pop()), n.loop(u, function(n) {
                                var i = n[6],
                                    t;
                                n[6] = n[4];
                                n[4] = i;
                                t = n[7];
                                n[7] = n[5];
                                n[5] = t
                            }), ft.points = u, ft.update(), ft
                        };
                        ft.splitPoints = function(t) {
                            var r = n.copy(ft.points),
                                u, f, i;
                            if (!(t < 1) && !(t > r.length - 1)) return u = n.copy(r.slice(0, t + 1)), f = n.copy(r.slice(t)), n.trimPointEnds(u), n.trimPointEnds(f), i = ft.clone(), ft.points = u, ft.update(), i.points = f, ft.parent && i.addTo(ft.parent), i
                        };
                        ft.makeSquiggle = function(t) {
                            var i = n.copy(ft.points),
                                r, u;
                            return zot(t) && (t = 0), t = (t + i.length * 1e3) % i.length, r = n.copy(i.slice(t)), u = n.copy(i.slice(0, t + 1)), i = r.concat(u), n.trimPointEnds(i), new n.Squiggle({
                                points: i,
                                color: ft.borderColor,
                                thickness: ft.borderWidth,
                                showControls: ft.controlsVisible,
                                interactive: ft.interactive,
                                onTop: ft.onTop,
                                dashed: ft.dashed,
                                stickColor: ft.stickColor,
                                stickThickness: ft.stickThickness
                            })
                        };
                        ft.update = function(n) {
                            return n ? ft.points = ft.pointsAdjusted : ft.drawShape(), ft.zimAnimateChanged = !0, ft
                        };
                        ft.move && ft.interactive && ot.drag({
                            onTop: !1
                        });
                        ni = ot.on("mousedown", function(n) {
                            at = n.target.stage;
                            gt = {
                                x: ot.x,
                                y: ot.y
                            };
                            ft.selectPoints && (ft.keyFocus = !0);
                            ir()
                        });
                        ti = ot.on("pressmove", function() {
                            st.x = ot.x;
                            st.y = ot.y;
                            rt.x = ot.x;
                            rt.y = ot.y
                        });
                        ii = ot.on("pressup", function() {
                            var i = ot.x != gt.x || ot.y != gt.y,
                                t = ot.localToLocal(ft.regX, ft.regY, ft.parent),
                                n;
                            ft.x = t.x;
                            ft.y = t.y;
                            st.x = st.y = rt.x = rt.y = ot.x = ot.y = 0;
                            i && (n = new createjs.Event("change"), n.controlType = "move", ft.dispatchEvent(n));
                            at.update()
                        });
                        v || ui(!0);
                        ft.toggleEvent = ft.on("mousedown", function() {
                            ft.allowToggle && (ct || (ft.showControls(), ft.dispatchEvent("controlsshow")))
                        });
                        ft.added(function() {
                            at = ft.stage;
                            ft.toggleStageEvent && ft.stage.off("stagemousedown", ft.toggleStageEvent);
                            ft.toggleStageEvent = ft.stage.on("stagemousedown", function(t) {
                                ft.allowToggle && ft.stage && ct && !ft.hitTestPoint(t.stageX / n.scaX, t.stageY / n.scaY, !1) && (ft.hideControls(), ft.dispatchEvent("controlshide"))
                            })
                        });
                        ft.clickEvent = ft.on("click", function() {
                            ft.ctrlKey && setTimeout(function() {
                                ft.clone(!0).addTo(ft.stage).mov(100);
                                ft.allowToggle && (ft.hideControls(), ft.dispatchEvent("controlshide"));
                                var n = new createjs.Event("change");
                                n.controlType = "move";
                                ft.dispatchEvent(n);
                                ft.stage.update()
                            }, 50)
                        });
                        ft.hideControls = function() {
                            return ft.toggled = !1, st.visible = !1, rt.visible = !1, ct = !1, ft.stage && ft.stage.update(), !ft.allowToggle && ft.move && ui(), ft
                        };
                        ct || ft.hideControls();
                        ft.showControls = function() {
                            return ft.toggled = !0, st.visible = !0, rt.visible = !0, ct = !0, st.x = ot.x, st.y = ot.y, rt.x = ot.x, rt.y = ot.y, ft.addChildAt(ot, 0), ft.move && !ft.allowToggle && si(), ft.stage && ft.stage.update(), ft
                        };
                        ft.toggle = function(n) {
                            return n === !0 ? ft.showControls() : n === !1 ? ft.hideControls() : ct ? ft.hideControls() : ft.showControls(), ft
                        };
                        ft.recordData = function(n) {
                            zot(n) && (n = !1);
                            var t = {
                                type: "Blob",
                                index: ft.parent ? ft.parent.getChildIndex(ft) : -1,
                                x: ft.x,
                                y: ft.y,
                                points: ft.recordPoints(),
                                color: ft.color,
                                borderColor: ft.borderColor,
                                borderWidth: ft.borderWidth,
                                move: ft.move,
                                toggle: ft.allowToggle,
                                controlsVisible: ct
                            };
                            return n ? JSON.stringify(t) : t
                        };
                        ft.setData = function(n, t) {
                            var i, r, u;
                            if (!zot(n)) {
                                if (t) try {
                                    n = JSON.parse(n)
                                } catch (f) {
                                    return
                                }
                                i = n.index;
                                zot(i) && (i = -1);
                                delete n.index;
                                r = n.points;
                                zot(r) || ft.setPoints(r);
                                delete n.points;
                                this.num = r.length;
                                for (u in n) ft[u] = n[u];
                                return ft.parent && ft.parent.setChildIndex(ft, i), ft
                            }
                        };
                        ft.recordPoints = function(t) {
                            var r, i, u;
                            return zot(t) && (t = !1), r = ft.points, t && (i || (i = ft.pane = new n.Pane({
                                displayClose: !1,
                                container: ft.stage,
                                width: Math.min(500, ft.stage.width - 20),
                                height: Math.min(500, ft.stage.height - 20),
                                draggable: !0
                            }), u = ft.textArea = new n.TextArea(Math.min(400, ft.stage.width - 70), Math.min(400, ft.stage.height - 70)), u.centerReg(i)), i.show(), u.text = JSON.stringify(r)), r
                        };
                        ft.setPoints = function(n) {
                            for (var t, i, r = 0; r < n.length; r++)(t = ht[r], i = n[r], zot(t)) || (t[0].x = i[0], t[0].y = i[1], t[1].x = i[2], t[1].y = i[3], t[2].x = i[4], t[2].y = i[5], t[3].x = i[6], t[3].y = i[7], t[4] = i[8], t[2].color = g(t[4]), t[3].color = g(t[4]));
                            return ft.update(), ft
                        };
                        it !== !1 && n.styleTransforms(ft, et);
                        ft.clone = function(t, i) {
                            var u = [],
                                h = !1,
                                r;
                            return n.loop(ft.pointControls, function(n) {
                                n.scaleX + n.scaleY + n.regX + n.regY + n.rotation != 2 && (h = !0);
                                u.push([n.scaleX, n.scaleY, n.regX, n.regY, n.rotation])
                            }), r = ft.cloneProps(new n.Blob(i ? ft.colorCommand : t || !n.isPick(yt[0]) ? ft.color : yt[0], i ? ft.borderColorCommand : t || !n.isPick(yt[1]) ? ft.borderColor : yt[1], ft.borderWidth, ft.recordPoints(), f, e, o, s, st.visible, c, l, ft.allowToggle, ft.move, y, p, ft.stickColor, ft.stickThickness, k, d, ft.editPoints, nt, tt, it, ft.group, ut)), h && (n.loop(r.pointControls, function(n, t) {
                                n.scaleX = u[t][0];
                                n.scaleY = u[t][1];
                                n.regX = u[t][2];
                                n.regY = u[t][3];
                                n.rotation = u[t][4]
                            }), r.update()), ft.linearGradientParams && r.linearGradient.apply(r, ft.linearGradientParams), ft.radialGradientParams && r.radialGradient.apply(r, ft.radialGradientParams), r
                        };
                        ft.shapeMousedownEvent = ft.shape.on("mousedown", function(t) {
                            (at = t.target.stage, ft.editPoints) && (ft.controlsVisible ? (ft.pressX = t.stageX / n.scaX, ft.pressY = t.stageY / n.scaY) : (ft.pressX = null, ft.pressY = null))
                        });
                        ft.addPointFactor = 10;
                        ft.addMinDistance = 15;
                        ft.shapePressupEvent = ft.shape.on("pressup", function(t) {
                            if (ft.editPoints && ft.pressX && Math.abs(ft.pressX - t.stageX / n.scaX) < oi && Math.abs(ft.pressY - t.stageY / n.scaY) < oi) {
                                ft.selectPoints && (ft.lastPoints = n.copy(ft.points));
                                var u = ft.points,
                                    r = ft.globalToLocal(t.stageX / n.scaX, t.stageY / n.scaY),
                                    i = n.closestPointAlongCurve(r, ft.segmentPoints);
                                if (ft.editPoints == "anywhere") u.splice(i + 1, 0, [r.x, r.y, 0, 0, 0, 0, 0, 0]), ft.points = u, ft.changeControl({
                                    index: i + 1,
                                    type: "mirror",
                                    update: !0
                                });
                                else {
                                    var f = ft.pointsAdjusted,
                                        l = ft.getSegmentPoint(f[i], f[(i + 1) % f.length]),
                                        a = n.distanceAlongCurve(l),
                                        o = Math.round(a / ft.addPointFactor),
                                        v = ft.interpolate(o, i, !1, u),
                                        e = 1e4,
                                        s;
                                    if (n.loop(v, function(t, i) {
                                            if (i != 0) {
                                                var u = n.dist(t, r);
                                                u < e && (e = u, s = i)
                                            }
                                        }), e < ft.addMinDistance) {
                                        var h = ft.segmentRatios,
                                            y = h[i],
                                            c = i > 0 ? h[i - 1] : 0;
                                        ft.addPoint(100 * (c + (y - c) * (s / (o + 1))))
                                    }
                                }
                                ft.lastSelectedIndex = i + 1;
                                ft.lastSelected = ft.controls.getChildAt(ft.lastSelectedIndex);
                                ft.stage.update()
                            }
                        });
                        ft.controlsClickEvent = ft.controls.on("click", function(n) {
                            (ft.lastSelected = n.target.parent, ft.lastSelectedIndex = ft.controls.getChildIndex(n.target.parent), ft.editPoints) && ft.selectionManager.shiftKey && gi(n)
                        });
                        ft.controls.hold(gi);
                        ct || ft.hideControls();
                        ft.dispatchEvent("update")
                    }
                }

                function ri() {
                    var t = [],
                        n = ft.selectionManager.currentSet,
                        i, r;
                    if (n && n.selections && n.selections.length > 0)
                        for (i = 0; i < n.selections.length; i++)
                            if (r = ft.pointObjects[n.selections[i]], n == ft.selectedBalls) t.push(r[1]);
                            else if (n == ft.selectedRect1s) t.push(r[2]);
                    else if (n == ft.selectedRect2s) t.push(r[3]);
                    else continue;
                    return t
                }

                function kt(n) {
                    if (ft.selectPoints && n.type == "Circle") {
                        var t = n,
                            i = t.mySet,
                            r = t.rect1,
                            u = t.rect2;
                        r.x -= t.x;
                        r.y -= t.y;
                        u.x -= t.x;
                        u.y -= t.y;
                        i.x += t.x;
                        i.y += t.y;
                        t.x = 0;
                        t.y = 0
                    }
                }

                function si() {
                    ft.move != "always" && (wt || (wt = !0, ot.drag({
                        onTop: !1
                    }), ni = ot.on("mousedown", ni), ti = ot.on("pressmove", ti), ii = ot.on("pressup", ii)))
                }

                function ui(n) {
                    ft.move != "always" && (n || wt) && (wt = !1, ot.noDrag(), ot.off("mousedown", ni), ot.off("pressmove", ti), ot.off("pressup", ii))
                }

                function wi() {
                    ft.keyFocus = !0;
                    var n = document.activeElement;
                    n && n.blur()
                }

                function gt(n, t, i) {
                    return {
                        x: n.x + (t.x - n.x) * i,
                        y: n.y + (t.y - n.y) * i
                    }
                }

                function fi(t, i, r, u, f, e, o, s) {
                    var h = t.length - 1,
                        y = 0,
                        p = 0,
                        k, d;
                    u == 100 && ft.type == "Squiggle" && (u = 99.99);
                    u = (u + 1e5) % 100;
                    n.loop(r, function(n, t) {
                        if (u / 100 < n) return h = t, p = n, !0;
                        y = n
                    });
                    var l = ft.segmentPoints[h],
                        a = p > 0 ? (u / 100 - y) / (p - y) : 0,
                        c = n.pointAlongCurve(l, a, null, s),
                        v = [c.x, c.y, 0, 0];
                    if (!e) {
                        if (o) {
                            ft.interpolatedPoints.push({
                                x: c.x,
                                y: c.y,
                                r: u / 100
                            });
                            return
                        }
                        if (f != "none") {
                            var w = gt(l[0], l[1], a),
                                g = gt(l[1], l[2], a),
                                b = gt(l[2], l[3], a),
                                nt = gt(w, g, a),
                                tt = gt(g, b, a);
                            v[4] = nt.x - c.x;
                            v[5] = nt.y - c.y;
                            v[6] = tt.x - c.x;
                            v[7] = tt.y - c.y;
                            k = ft.localToLocal(w.x, w.y, i[h]);
                            t[h][6] = k.x;
                            t[h][7] = k.y;
                            d = ft.localToLocal(b.x, b.y, i[(h + 1) % t.length]);
                            t[(h + 1) % t.length][4] = d.x;
                            t[(h + 1) % t.length][5] = d.y
                        }
                        f && (v[8] = f);
                        t.splice(h + 1, 0, v)
                    }
                }
                var hi, et, vt, ct, yt, ft, ht, pt, ei, ot, ni, ti, ii, at, wt, oi, bt, st, ai, dt;
                if (hi = zob(n.Blob, arguments, "color, borderColor, borderWidth, points, radius, controlLength, controlType, lockControlType, showControls, lockControls, handleSize, allowToggle, move, dashed, onTop, stickColor, stickThickness, selectColor, selectPoints, editPoints, interactive, strokeObj, style, group, inherit", this)) return hi;
                z_d("53.5");
                this.group = rt;
                et = it === !1 ? {} : n.getStyle("Blob", this.group, ut);
                zot(f) && (f = et.radius != null ? et.radius : 100);
                this.zimCustomShape_constructor(-f, -f, f * 2, f * 2, !1);
                this.type = "Blob";
                this.mouseChildren = !0;
                zot(y) && (y = et.dashed != null ? et.dashed : !1);
                zot(i) && (i = et.borderColor != null ? et.borderColor : null);
                zot(r) && (r = et.borderWidth != null ? et.borderWidth : null);
                i < 0 || r < 0 ? i = r = null : i != null && r == null && (r = 1);
                zot(t) && (t = et.color != null ? et.color : r > 0 ? "rgba(0,0,0,0)" : n.green);
                t.style && (this.colorCommand = t, t = "black");
                i && i.style && (this.borderColorCommand = i, i = "black");
                zot(u) && (u = et.points != null ? et.points : 4);
                var yi = typeof u != "number",
                    lt = typeof u == "number" ? u : u.length,
                    ci = e;
                zot(e) && (e = et.controlLength != null ? et.controlLength : f * 4 / lt);
                zot(o) && (o = et.controlType != null ? et.controlType : null);
                vt = o;
                zot(o) && (o = "straight");
                zot(s) && (s = et.lockControlType != null ? et.lockControlType : !1);
                zot(nt) && (nt = et.interactive != null ? et.interactive : !0);
                zot(h) && (h = et.showControls != null ? et.showControls : nt);
                ct = h;
                zot(c) && (c = et.lockControls != null ? et.lockControls : !nt);
                zot(l) && (l = et.handleSize != null ? et.handleSize : n.mobile() ? 20 : 10);
                zot(a) && (a = et.allowToggle != null ? et.allowToggle : nt);
                zot(v) && (v = et.move != null ? et.move : nt);
                zot(w) && (w = et.stickColor != null ? et.stickColor : "#111");
                zot(b) && (b = et.stickThickness != null ? et.stickThickness : 1);
                zot(k) && (k = et.selectColor != null ? et.selectColor : "#fff");
                zot(d) && (d = et.selectPoints != null ? et.selectPoints : nt);
                this.stickColor = w;
                this.stickThickness = b;
                zot(p) && (p = et.onTop != null ? et.onTop : !0);
                zot(g) && (g = et.editPoints != null ? et.editPoints : nt);
                zot(tt) && (tt = et.strokeObj != null ? et.strokeObj : {});
                yt = pi(t, i);
                t = n.Pick.choose(t);
                i = n.Pick.choose(i);
                ft = this;
                this.interactive = nt;
                this.num = lt;
                this.editPoints = g;
                this.selectPoints = d;
                this.lockControls = c;
                this.onTop = p;
                this.move = v;
                this.allowToggle = a;
                this.lockControlType = s;
                this.types = ["mirror", "straight", "free", "none"];
                ft._color = t;
                ft._borderColor = i;
                ft._borderWidth = r;
                ft._dashed = y;
                ft._dashed && !Array.isArray(ft._dashed) && (ft._dashed = [10, 10]);
                wt = ft.move;
                oi = 2;
                u = li(u);
                typeof u == "string" && (ai = new n.SVGContainer, u = ai.processPath(u), u[0][0] == u[u.length - 1][0] && u[0][1] == u[u.length - 1][1] && (u[0][4] = u[u.length - 1][4], u[0][5] = u[u.length - 1][5], u.pop()));
                vt && typeof u != "number" && n.loop(u, function(n) {
                    n[8] = vt;
                    vt == "none" && (n[4] = n[5] = n[6] = n[7] = 0)
                });
                vi();
                ft.selectionManager.on("keydown", function(n) {
                    var i, r, t;
                    if (ft.selectPoints && ft.keyFocus && n.keyCode >= 37 && n.keyCode <= 40 && (i = ri(), i.length > 0)) {
                        for (r = 0; r < i.length; r++) t = i[r], n.keyCode == 37 ? t.x -= ft.selectionManager.shiftKey ? 10 : 1 : n.keyCode == 39 ? t.x += ft.selectionManager.shiftKey ? 10 : 1 : n.keyCode == 38 ? t.y -= ft.selectionManager.shiftKey ? 10 : 1 : n.keyCode == 40 && (t.y += ft.selectionManager.shiftKey ? 10 : 1), bt(t);
                        ft.drawShape();
                        ft.dispatchEvent("update");
                        ft.stage && ft.stage.update()
                    }
                });
                ft.selectionManager.on("keyup", function(n) {
                    var t, i;
                    if (ft.selectPoints && ft.keyFocus && n.keyCode >= 37 && n.keyCode <= 40 && (t = ri(), t.length > 0))
                        for (i = 0; i < t.length; i++) kt(t[i])
                });
                ft.selectionManager.on("undo", function() {
                    if (ft.selectPoints && ft.keyFocus && ft.lastPoints) {
                        var t = n.copy(ft.lastPoints);
                        ft.lastPoints = n.copy(ft.points);
                        ft.points = t;
                        ft.stage && ft.stage.update()
                    }
                });
                bt = function(n) {
                    var t, f, e, r, i, s, u, h, c;
                    if (!ft.lockControls)
                        if (n.rect1) t = n, f = t.x - t.startX, e = t.y - t.startY, t.rect1.x = t.rect1.startX + f, t.rect1.y = t.rect1.startY + e, t.rect2.x = t.rect2.startX + f, t.rect2.y = t.rect2.startY + e;
                        else if (r = n, i = r.other, t = r.ball, s = t.index, u = o, zot(ht[s][4]) || (u = ht[s][4]), u == "straight" || u == "mirror")
                        if (h = r.x - t.x, c = r.y - t.y, u == "mirror") i.x = t.x - h, i.y = t.y - c;
                        else {
                            var l = Math.atan2(c, h),
                                a = -i.stickLength * Math.cos(l + Math.PI),
                                v = -i.stickLength * Math.sin(l + Math.PI);
                            i.x = t.x - a;
                            i.y = t.y - v
                        }
                };
                Object.defineProperty(ft, "move", {
                    get: function() {
                        return v
                    },
                    set: function(n) {
                        v != n && (v = n, n ? si() : ui())
                    }
                });
                Object.defineProperty(ft, "interactive", {
                    get: function() {
                        return nt
                    },
                    set: function(n) {
                        nt = n;
                        ct = nt;
                        ft.allowToggle = nt;
                        ft.editPoints = nt;
                        ft.lockControls = !nt;
                        ft.selectPoints = nt;
                        ft.move = nt;
                        var t = ft.points;
                        ft.points = t
                    }
                });
                Object.defineProperty(ft, "allowToggle", {
                    get: function() {
                        return a
                    },
                    set: function(n) {
                        a != n && (a = n, a ? ft.move && si() : !ct && ft.move && ui())
                    }
                });
                Object.defineProperty(ft, "controlsVisible", {
                    get: function() {
                        return ct
                    },
                    set: function(n) {
                        ct = n;
                        n ? ft.showControls() : ft.hideControls()
                    }
                });
                dt = c;
                Object.defineProperty(ft, "lockControls", {
                    get: function() {
                        return dt
                    },
                    set: function(n) {
                        dt = n;
                        n ? (ft.controls.mouseChildren = !1, ft.controls.mouseEnabled = !1) : (ft.controls.mouseChildren = !0, ft.controls.mouseEnabled = !0)
                    }
                });
                ft.lockControls = dt;
                WW.KEYFOCUS != null && (n.KEYFOCUS = WW.KEYFOCUS);
                Object.defineProperty(this, "keyFocus", {
                    get: function() {
                        return n.KEYFOCUS == ft
                    },
                    set: function() {
                        n.KEYFOCUS = ft
                    }
                });
                ft.selectPoints && !n.KEYFOCUS && wi();
                Object.defineProperty(ft, "points", {
                    get: function() {
                        for (var u = [], i, t, r = 0; r < ht.length; r++) t = ht[r], i = [n.decimals(t[0].x), n.decimals(t[0].y), n.decimals(t[1].x), n.decimals(t[1].y), n.decimals(t[2].x), n.decimals(t[2].y), n.decimals(t[3].x), n.decimals(t[3].y)], t[4] && t[4] !== "straight" && i.push(t[4]), u.push(i);
                        return u
                    },
                    set: function(t) {
                        var f = ft.x,
                            e = ft.y,
                            o = ft.visible,
                            i = [],
                            r = !1;
                        n.loop(ft.pointControls, function(n) {
                            n.scaleX + n.scaleY + n.regX + n.regY + n.rotation != 2 && (r = !0);
                            i.push([n.scaleX, n.scaleY, n.regX, n.regY, n.rotation])
                        });
                        ft.dispose(!0);
                        u = li(t);
                        ft.shape && (ft.shape.graphics.clear(), ft.sticks.graphics.clear(), ft.controls.noDrag(), ft.removeAllChildren(), delete ft.shape, delete ft.sticks, delete ft.controls);
                        ft.visible = !1;
                        vi();
                        ft.lockControls = dt;
                        ft.x = f;
                        ft.y = e;
                        ft.visible = o;
                        r && (n.loop(ft.pointControls, function(n, t) {
                            n.scaleX = i[t][0];
                            n.scaleY = i[t][1];
                            n.regX = i[t][2];
                            n.regY = i[t][3];
                            n.rotation = i[t][4]
                        }), ft.update())
                    }
                });
                Object.defineProperty(ft, "pointsAdjusted", {
                    get: function() {
                        var u = [],
                            r, t, i, f = ft.pointObjects;
                        return n.loop(f.length, function(e) {
                            if (i = f[e], t = ht[e], i[0].rotation == 0 && i[0].scaleX == 0 && i[0].scaleY == 0) r = [n.decimals(t[0].x), n.decimals(t[0].y), n.decimals(t[1].x), n.decimals(t[1].y), n.decimals(t[2].x), n.decimals(t[2].y), n.decimals(t[3].x), n.decimals(t[3].y)];
                            else {
                                var o = i[0].localToLocal(i[2].x, i[2].y, i[0].parent),
                                    s = i[0].localToLocal(i[3].x, i[3].y, i[0].parent);
                                r = [n.decimals(t[0].x), n.decimals(t[0].y), n.decimals(t[1].x), n.decimals(t[1].y), n.decimals(o.x - t[0].x), n.decimals(o.y - t[0].y), n.decimals(s.x - t[0].x), n.decimals(s.y - t[0].y)]
                            }
                            t[4] && t[4] !== "mirror" && r.push(t[4]);
                            u.push(r)
                        }), u
                    },
                    set: function() {
                        zon && zogy("Blob() - pointsAdjusted is read only")
                    }
                });
                Object.defineProperty(ft, "pointObjects", {
                    get: function() {
                        return ht
                    },
                    set: function() {
                        zon && zogy("Blob() - pointObjects is read only - but its contents can be manipulated - use blob.update() after changes")
                    }
                });
                Object.defineProperty(ft, "pointControls", {
                    get: function() {
                        return ei
                    },
                    set: function() {
                        zon && zogy("Blob() - pointControls is read only - but its contents can be manipulated - use blob.update() after changes")
                    }
                });
                Object.defineProperty(ft, "pointCircles", {
                    get: function() {
                        return pt
                    },
                    set: function() {
                        zon && zogy("Blob() - pointCircles is read only - but its contents can be manipulated - use blob.update() after changes")
                    }
                });
                Object.defineProperty(ft, "segmentPoints", {
                    get: function() {
                        var t = ft.pointsAdjusted,
                            i = [];
                        return n.loop(t.length, function(n, r) {
                            var u = ft.getSegmentPoint(t[n], t[n < r - 1 ? n + 1 : 0]);
                            i.push(u)
                        }), i
                    },
                    set: function() {
                        zon && zogy("Blob() - segmentPoints is read only")
                    }
                });
                Object.defineProperty(ft, "segmentRatios", {
                    get: function() {
                        var r = [],
                            u = 0,
                            t, i;
                        return n.loop(ft.segmentPoints, function(t) {
                            var i = n.distanceAlongCurve(t);
                            r.push(i);
                            u += i
                        }), t = [], i = 0, n.loop(r, function(n) {
                            var r = n / u;
                            i += r;
                            t.push(i)
                        }), t
                    },
                    set: function() {
                        zon && zogy("Blob() - segmentRatios is read only")
                    }
                });
                ft.approximateBounds = function(t, i) {
                    var f, u, e, r;
                    if (zot(t) && (t = 80), t /= ft.num, f = ft.interpolate(t, null, !0, null, !0), u = n.boundsAroundPoints(f), ft.setBounds(u.x, u.y, u.width, u.height), i) {
                        if (!ft.parent) return zon && zogy("approximateBounds() - add to stage to first to see points"), ft;
                        for (ft.hitPathPoints ? ft.hitPathPoints.removeAllChildren() : ft.hitPathPoints = (new n.Container).addTo(), ft.hitPathPoints.top(), e = 0; e < f.length; e++) r = f[e], r = ft.localToGlobal(r.x, r.y), new n.Circle(3).loc(r.x, r.y, ft.hitPathPoints)
                    }
                    return ft
                };
                ft.getPointAngle = function(t) {
                    var e = ft.pointObjects[t][0],
                        i = ft.pointObjects[t][2],
                        r = ft.pointObjects[t][3],
                        u, f;
                    return e == ft.stage ? (u = new n.Point(i.x, i.y), f = new n.Point(r.x, r.y)) : (u = e.localToGlobal(i.x, i.y), f = e.localToGlobal(r.x, r.y)), n.angle(u.x, u.y, f.x, f.y)
                };
                ft.getSegmentPoint = function(n, t) {
                    if (!zot(n) && !zot(t)) {
                        (n[2] != 0 || n[3] != 0) && (n[4] -= n[2], n[5] -= n[3], n[6] -= n[2], n[7] -= n[3], n[0] += n[2], n[1] += n[3], n[2] = 0, n[3] = 0);
                        (t[2] != 0 || t[3] != 0) && (t[4] -= t[2], t[5] -= t[3], t[6] -= t[2], t[7] -= t[3], t[0] += t[2], t[1] += t[3], t[2] = 0, t[3] = 0);
                        var i = {
                                x: n[0],
                                y: n[1]
                            },
                            r = {
                                x: n[0] + n[6],
                                y: n[1] + n[7]
                            },
                            u = {
                                x: t[0] + t[4],
                                y: t[1] + t[5]
                            },
                            f = {
                                x: t[0],
                                y: t[1]
                            };
                        return (st.x != 0 || st.y != 0) && (i.x += st.x, r.x += st.x, u.x += st.x, f.x += st.x, i.y += st.y, r.y += st.y, u.y += st.y, f.y += st.y), [i, r, u, f]
                    }
                };
                ft.getAdjacentSegmentData = function(n) {
                    var t, i;
                    return (zot(n) && (n = 0), t = ft.pointsAdjusted, ft.num == 2) ? [
                        [ft.getSegmentPoint(t[0], t[1]), ft.getSegmentPoint(t[1], t[0])],
                        [0, 1]
                    ] : n == 0 ? [
                        [ft.getSegmentPoint(t[ft.num - 1], t[0]), ft.getSegmentPoint(t[0], t[1]), ft.getSegmentPoint(t[1], t[2])],
                        [ft.num - 1, 0, 1]
                    ] : n >= ft.num - 1 ? [
                        [ft.getSegmentPoint(t[ft.num - 2], t[ft.num - 1]), ft.getSegmentPoint(t[ft.num - 1], t[0]), ft.getSegmentPoint(t[0], t[1])],
                        [ft.num - 2, ft.num - 1, 0]
                    ] : (i = n + 2 >= ft.num ? 0 : n + 2, [
                        [ft.getSegmentPoint(t[n - 1], t[n]), ft.getSegmentPoint(t[n], t[n + 1]), ft.getSegmentPoint(t[n + 1], t[i])],
                        [n - 1, n, n + 1]
                    ])
                };
                ft.getCurvePoint = function(t, i, r, u) {
                    var o;
                    zot(i) && (i = ft.segmentRatios);
                    zot(r) && (r = ft.segmentPoints);
                    zot(u) && (u = !1);
                    var e = i,
                        h = r,
                        f = n.loop(e, function(n, i) {
                            if (n >= t) return i
                        }),
                        c = f > 0 ? e[f - 1] : 0,
                        l = f > 0 ? e[f] - e[f - 1] : e[f],
                        a = (t - c) / l,
                        s = n.pointAlongCurve(h[f], a, u, !0);
                    return zot(s) ? undefined : (o = ft.localToGlobal(s.x, s.y), o.angle = s.angle, o.z = f, zot(o) ? undefined : o)
                };
                this.addPoint = function(n, t) {
                    zot(n) && (n = 100);
                    var i = ft.points,
                        r = ft.segmentRatios,
                        u = ft.pointControls;
                    return t = t ? t : vt, fi(i, u, r, n, t), ft.points = i, ft.num = i.length, ft
                };
                this.addPoints = function(t, i, r, u, f, e, o) {
                    var h, s, c;
                    return zot(e) && (e = n.copy(ft.points)), h = n.copy(ft.segmentRatios), s = 0, f && (ft.interpolatedPoints = []), u && (c = h.length * t), n.loop(h, function(h, l) {
                        f && fi(e, ft.pointControls, ft.segmentRatios, s * 100, i, !zot(r) && l != r, f, o);
                        var a = u ? Math.round(c * (h - s)) : t,
                            v = 1 / (a + 1);
                        n.loop(a, function(n) {
                            var u = s + (h - s) * v * (n + 1);
                            fi(e, ft.pointControls, ft.segmentRatios, u * 100, i, !zot(r) && l != r, f, o);
                            !f && t > 0 && (ft.points = e)
                        });
                        s = h
                    }), f && ft.type == "Squiggle" && fi(e, ft.pointControls, ft.segmentRatios, 100, i, null, f, o), ft.stage && ft.stage.update(), ft.num = e.length, ft
                };
                this.interpolate = function(n, t, i, r, u) {
                    return zot(n) && (n = 1), ft.addPoints(n, "none", t, i, !0, r, u), ft.interpolatedPoints
                };
                yi && ft.approximateBounds();
                this.dispose = function(t, i, r) {
                    if (ft.shape) {
                        if (n.gD(ft), at && ft.toggleStageEvent && at.off("stagemousedown", ft.toggleStageEvent), ft.controls.noDrag(), ft.controls.removeAllEventListeners(), ft.selectPoints && ft.selectionManager && ft.selectionManager.dispose(), ft.selectedBalls = null, ft.selectedRect1s = null, ft.selectedRect2s = null, ft.selectionManager = null, ft.off("mousedown", ft.toggleEvent), ft.off("click", ft.clickEvent), t) {
                            ft.shape.dispose();
                            ft.shape = null;
                            for (var u = 0; u < ft.points.length; u++) ft.pointObjects[u][0].removeAllEventListeners(), ft.pointObjects[u][1].removeAllEventListeners(), ft.pointObjects[u][2].removeAllEventListeners(), ft.pointObjects[u][3].removeAllEventListeners();
                            ft.controls.removeFrom(ft);
                            ft.sticks.dispose();
                            ht = null;
                            pt = null
                        } else ft.removeAllEventListeners(), ht = null, pt = null, r || this.zimCustomShape_dispose(!0);
                        return !0
                    }
                }
            }, n.extend(n.Blob, n.CustomShape, ["clone", "dispose"], "zimCustomShape", !1), n.Flare = function(t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at) {
                function pt(f, s, l, a, v, y, p, w) {
                    function ei(i) {
                        var u = s[i],
                            r = f[i],
                            o = l[i],
                            h = a[i],
                            e = v[i],
                            c, b, k, d, g, nt, tt;
                        p && (c = p[i]);
                        zot(u) && (u = gt, vt.angles[i] = u);
                        zot(r) && (r = 200, vt.lengths[i] = r);
                        zot(o) && (o = 0, vt.anglesA[i] = o);
                        zot(h) && (h = 0, vt.anglesB[i] = h);
                        zot(e) && (e = 0, vt.anglesEnd[i] = e);
                        p && zot(c) && (c = t, vt.crossColors[i] = c);
                        e = e + 90;
                        var it = 180 - e,
                            y = Math.cos((gt - u) * n.RAD),
                            w = Math.sin((gt - u) * n.RAD),
                            rt = new n.Point(0, 0),
                            ut = new n.Point(r, 0);
                        return b = zot(wt) ? new n.Point(Math.cos(ti * n.RAD) * dt, Math.sin(ti * n.RAD) * dt) : new n.Point(wt.x * y - wt.y * w, wt.x * w + wt.y * y), k = ui(r, b.x, b.y, o, it), d = new n.Point(r - k.x, -k.y), g = zot(bt) ? new n.Point(Math.cos(ii * n.RAD) * dt, Math.sin(ii * n.RAD) * ri) : new n.Point(bt.x * y - bt.y * w, bt.x * w + bt.y * y), nt = ui(r, g.x, g.y, h, e), tt = new n.Point(r - nt.x, nt.y), wt = new n.Point(d.x - r, d.y), bt = new n.Point(tt.x - r, tt.y), gt = u, {
                            a: u,
                            A: b,
                            B: d,
                            C: tt,
                            D: g,
                            E: ut,
                            F: rt,
                            tA: k.t,
                            tB: nt.t
                        }
                    }

                    function ui(t, i, r, u, f) {
                        var e = f - 90,
                            h = 90 - e,
                            c = 180 - u - h,
                            s = Math.tan(e * n.RAD) * r,
                            l = t - i - s,
                            a = l / Math.sin(c * n.RAD) * Math.sin(u * n.RAD),
                            v = Math.sqrt(Math.pow(r, 2) + Math.pow(s, 2)),
                            o = a + v,
                            y = o * Math.sin(e * n.RAD),
                            p = o * Math.cos(e * n.RAD);
                        return {
                            x: y,
                            y: p,
                            t: o
                        }
                    }
                    var b, ct, lt, ni;
                    vt.removeAllChildren();
                    b = vt.shape = (new n.Shape).addTo(vt);
                    vt.colorCommand = b.c().f(t).command;
                    t && t.type && vt.specialColor(vt.colorCommand, t, vt);
                    (zot(r) || r > 0) && (zot(i) && zot(r) || (zot(i) && (i = "black"), vt.borderColorCommand = b.s(i).command, i && i.type && vt.specialColor(vt.borderColorCommand, i, vt), vt.borderWidthCommand = b.ss(r, g.caps, g.joints, g.miterLimit, g.ignoreScale).command, d && (vt.borderDashedCommand = b.sd([10, 10], 5).command)));
                    b.mt(0, 0);
                    tt > 0 && (ct = vt.spineShape = (new n.Shape).addTo(vt), vt.spineColorCommand = ct.c().f(nt).command, nt && nt.type && vt.specialColor(vt.spineColorCommand, nt, vt), (zot(tt) || tt > 0) && (zot(it) && zot(tt) || (zot(it) && (it = "black"), vt.spineBorderColorCommand = ct.s(it).command, it && it.type && vt.specialColor(vt.spineBorderColorCommand, it, vt), vt.spineBorderWidthCommand = ct.ss(tt, ut.caps, ut.joints, ut.miterLimit, ut.ignoreScale).command, rt && (vt.spineBorderDashedCommand = ct.sd([10, 10], 5).command))));
                    zot(ft) || (lt = vt.closeShape = (new n.Shape).addTo(vt), vt.closeColorCommand = lt.c().f(ft).command, ft && ft.type && vt.specialColor(vt.closeColorCommand, ft, vt), (zot(et) || et > 0) && (zot(ot) && zot(et) || (zot(ot) && (ot = "black"), vt.closeBorderColorCommand = lt.s(ot).command, ot && ot.type && vt.specialColor(vt.closeBorderColorCommand, ot, vt), vt.closeBorderWidthCommand = lt.ss(et, ht.caps, ht.joints, ht.miterLimit, ht.ignoreScale).command, st && (vt.closeBorderDashedCommand = lt.sd([10, 10], 5).command))), b.mt(0, 0));
                    var yt = h,
                        pt = c,
                        ti = u,
                        ii = ti - 180,
                        dt = e,
                        ri = o,
                        fi = Math.max(f.length, s.length, l.length, a.length, v.length),
                        wt, bt, gt = ii,
                        kt = [],
                        at = [],
                        k = [];
                    vt.points = [];
                    ni = vt.pinPoints = [];
                    n.loop(fi, function(t) {
                        var i = ei(t),
                            r = Math.cos(i.a * n.RAD),
                            u = Math.sin(i.a * n.RAD),
                            e = new n.Point(yt + i.A.x * r - i.A.y * u, pt + i.A.x * u + i.A.y * r),
                            o = new n.Point(yt + i.B.x * r - i.B.y * u, pt + i.B.x * u + i.B.y * r),
                            s = new n.Point(yt + i.C.x * r - i.C.y * u, pt + i.C.x * u + i.C.y * r),
                            h = new n.Point(yt + i.D.x * r - i.D.y * u, pt + i.D.x * u + i.D.y * r),
                            c, f;
                        kt.push(e, o);
                        at.unshift(s, h);
                        k.push([e, o, s, h]);
                        c = new n.Point(yt + i.F.x * r - i.F.y * u, pt + i.F.x * u + i.F.y * r);
                        f = new n.Point(yt + i.E.x * r - i.E.y * u, pt + i.E.x * u + i.E.y * r);
                        t == 0 && vt.pinPoints.push(c);
                        vt.pinPoints.push(f);
                        yt = f.x;
                        pt = f.y;
                        dt = i.tA;
                        ri = i.tB
                    });
                    vt.points = kt.concat(at);
                    y ? (n.loop(k, function(n, t) {
                        b.mt(n[0].x, n[0].y);
                        zot(p) || zot(p[t]) || b.f(p[t]).mt(n[0].x, n[0].y);
                        b.lt(n[1].x, n[1].y).lt(n[2].x, n[2].y).lt(n[3].x, n[3].y).cp()
                    }), w && b.mt(k[k.length - 1][1].x, k[k.length - 1][1].y).lt(k[k.length - 1][2].x, k[k.length - 1][2].y).lt(k[0][3].x, k[0][3].y).lt(k[0][0].x, k[0][0].y).cp()) : (n.loop(kt, function(n, t) {
                        t == 0 ? b.mt(n.x, n.y) : b.lt(n.x, n.y)
                    }), w && (b.lt(kt[0].x, kt[0].y), b.cp()), n.loop(at, function(n, t) {
                        t == 0 && w ? b.mt(n.x, n.y) : b.lt(n.x, n.y)
                    }), w && b.lt(at[0].x, at[0].y), b.cp());
                    ct && (n.loop(ni, function(n, t) {
                        t == 0 ? ct.mt(n.x, n.y) : ct.lt(n.x, n.y)
                    }), w && ct.lt(ni[0].x, ni[0].y).cp());
                    zot(ft) || (n.loop(at, function(n, t) {
                        t == 0 ? lt.mt(n.x, n.y) : lt.lt(n.x, n.y)
                    }), w && lt.lt(at[0].x, at[0].y).cp())
                }
                var gt, yt, vt, ni, wt, bt, dt, kt;
                if (gt = zob(n.Flare, arguments, "color, borderColor, borderWidth, crossAngle, thickness, thicknessA, thicknessB, pin, startX, startY, lengths, angles, anglesA, anglesB, anglesEnd, cross, crossColors, close, dashed, strokeObj, spineColor, spineBorderWidth, spineBorderColor, spineDashed, spineStrokeObj, closeColor, closeBorderWidth, closeBorderColor, closeDashed, closeStrokeObj, style, group, inherit", this)) return gt;
                z_d("53.6");
                this.zimContainer_constructor();
                this.type = "Flare";
                this.group = lt;
                yt = ct === !1 ? {} : n.getStyle(this.type, this.group, at);
                vt = this;
                zot(i) && (i = yt.borderColor != null ? yt.borderColor : null);
                zot(r) && (r = yt.borderWidth != null ? yt.borderWidth : null);
                i < 0 || r < 0 ? i = r = null : i != null && r == null && (r = 1);
                zot(t) && (t = yt.color != null ? yt.color : r > 0 ? "rgba(0,0,0,0)" : "black");
                (zot(r) || r > 0) && (zot(i) && zot(r) || zot(i) && (i = "black"));
                zot(u) && (u = yt.crossAngle != null ? yt.crossAngle : 0);
                ni = u;
                u -= 90;
                zot(f) && (f = yt.thickness != null ? yt.thickness : null);
                zot(e) && (e = yt.thicknessA != null ? yt.thicknessA : null);
                zot(o) && (o = yt.thicknessB != null ? yt.thicknessB : null);
                zot(f) ? zot(o) && !zot(e) ? o = e : zot(e) && !zot(o) ? e = o : o = e = 10 : zot(o) && !zot(e) ? o = f - e : zot(e) && !zot(o) ? e = f - o : o = e = f / 2;
                vt.thickness = e + o;
                zot(w) && (w = yt.cross != null ? yt.cross : !0);
                zot(b) && (b = yt.crossColors != null ? yt.crossColors : null);
                zot(b) || Array.isArray(b) || (b = [b]);
                zot(k) && (k = yt.close != null ? yt.close : !1);
                zot(h) && (h = yt.startX != null ? yt.startX : 0);
                zot(c) && (c = yt.startY != null ? yt.startY : 0);
                zot(l) && (l = yt.lengths != null ? yt.lengths : [200]);
                Array.isArray(l) || (l = [l]);
                zot(a) && (a = yt.angles != null ? yt.angles : [0]);
                Array.isArray(a) || (a = [a]);
                zot(v) && (v = yt.anglesA != null ? yt.anglesA : [10]);
                Array.isArray(v) || (v = [v]);
                zot(y) && (y = yt.anglesB != null ? yt.anglesB : n.copy(v));
                Array.isArray(y) || (y = [y]);
                zot(p) && (p = yt.anglesEnd != null ? yt.anglesEnd : [0]);
                Array.isArray(p) || (p = [p]);
                zot(g) && (g = yt.strokeObj != null ? yt.strokeObj : {
                    miterLimit: 2
                });
                zot(it) && (it = yt.spineBorderColor != null ? yt.spineBorderColor : null);
                zot(tt) && (tt = yt.spineBorderWidth != null ? yt.spineBorderWidth : null);
                it < 0 || tt < 0 ? it = tt = null : it != null && tt == null && (tt = 1);
                zot(nt) && (nt = yt.spineColor != null ? yt.spineColor : tt > 0 ? "rgba(0,0,0,0)" : "black");
                zot(rt) && (rt = yt.spineDashed != null ? yt.spineDashed : null);
                zot(ut) && (ut = yt.spineStrokeObj != null ? yt.spineStrokeObj : {
                    miterLimit: 2
                });
                (zot(tt) || tt > 0) && (zot(it) && zot(tt) || zot(it) && (it = i ? i : "black"));
                zot(ot) && (ot = yt.closeBorderColor != null ? yt.closeBorderColor : null);
                zot(et) && (et = yt.closeBorderWidth != null ? yt.closeBorderWidth : null);
                ot < 0 || et < 0 ? ot = et = null : ot != null && et == null && (et = 1);
                zot(ft) && (ft = yt.closeColor != null ? yt.closeColor : et > 0 ? "rgba(0,0,0,0)" : null);
                zot(st) && (st = yt.closeDashed != null ? yt.closeDashed : null);
                zot(ht) && (ht = yt.closeStrokeObj != null ? yt.closeStrokeObj : {
                    miterLimit: 2
                });
                (zot(et) || et > 0) && (zot(ot) && zot(et) || zot(ot) && (ot = i ? i : "black"));
                this.thicknessA = e;
                this.thicknessB = o;
                this.cross = w;
                this.close = k;
                this.lengths = l;
                this.angles = a;
                this.anglesA = v;
                this.anglesB = y;
                this.anglesEnd = p;
                this.crossColors = b;
                pt(l, a, v, y, p, w, b, k);
                t.type && (vt.color = t);
                this.add = function(n, t, i, r, u, f, e, o) {
                    var s;
                    return (s = zob(vt.add, arguments, "lengths, angles, anglesA, anglesB, anglesEnd, cross, crossColors, close")) ? s : (zot(f) || (vt.cross = f), zot(o) || (vt.close = o), zot(n) || (Array.isArray(n) || (n = [n]), vt.lengths = zot(vt.lengths) ? n : vt.lengths.concat(n)), zot(t) || (Array.isArray(t) || (t = [t]), vt.angles = zot(vt.angles) ? t : vt.angles.concat(t)), zot(i) || (Array.isArray(i) || (i = [i]), vt.anglesA = zot(vt.anglesA) ? i : vt.anglesA.concat(i)), zot(r) || (Array.isArray(r) || (r = [r]), vt.anglesB = zot(vt.anglesB) ? r : vt.anglesB.concat(r)), zot(u) || (Array.isArray(u) || (u = [u]), vt.anglesEnd = zot(vt.anglesEnd) ? u : vt.anglesEnd.concat(u)), zot(e) || (zot(vt.crossColors) ? zon && zogy("Flare() - must set crossColor for original object parameters") : (Array.isArray(e) || (e = [e]), vt.crossColors = zot(vt.crossColors) ? e : vt.crossColors.concat(e))), vt.remake(), vt)
                };
                this.remake = function() {
                    return e = this.thicknessA, o = this.thicknessB, pt(vt.lengths, vt.angles, vt.anglesA, vt.anglesB, vt.anglesEnd, vt.cross, vt.crossColors, vt.close), vt
                };
                Object.defineProperty(vt, "color", {
                    get: function() {
                        return t
                    },
                    set: function(n) {
                        zot(n) && (n = "black");
                        t = n;
                        n && n.type ? vt.specialColor(vt.colorCommand, n, vt) : vt.colorCommand.style = n
                    }
                });
                this.setColorRange = function(n, t) {
                    return zot(t) ? (wt = vt.color, bt = n) : zot(n) ? (wt = vt.color, bt = t) : (wt = n, bt = t), vt
                };
                dt = 0;
                Object.defineProperty(vt, "colorRange", {
                    get: function() {
                        return dt
                    },
                    set: function(t) {
                        dt = t;
                        zot(wt) || zot(bt) || (vt.color = n.colorRange(wt, bt, t))
                    }
                });
                Object.defineProperty(vt, "borderColor", {
                    get: function() {
                        return i
                    },
                    set: function(n) {
                        i = n;
                        vt.borderColorCommand ? n && n.type ? vt.specialColor(vt.borderColorCommand, n, vt) : vt.borderColorCommand.style = n : pt()
                    }
                });
                Object.defineProperty(vt, "borderWidth", {
                    get: function() {
                        return r
                    },
                    set: function(n) {
                        n > 0 || (n = 0);
                        r = n;
                        vt.borderWidthCommand && r != 0 ? (vt.borderWidthCommand.width = r, d && (vt.borderDashedCommand.segments = [20, 10], vt.borderDashedCommand.offset = 5)) : pt()
                    }
                });
                Object.defineProperty(vt, "spineColor", {
                    get: function() {
                        return nt
                    },
                    set: function(n) {
                        zot(n) && (n = "black");
                        nt = n;
                        vt.spineColorCommand ? n && n.type ? vt.specialColor(vt.spineColorCommand, n, vt) : vt.spineColorCommand.style = n : pt()
                    }
                });
                Object.defineProperty(vt, "spineBorderColor", {
                    get: function() {
                        return it
                    },
                    set: function(n) {
                        it = n;
                        vt.spineBorderColorCommand ? n && n.type ? vt.specialColor(vt.spineBorderColorCommand, n, vt) : vt.spineBorderColorCommand.style = n : pt()
                    }
                });
                Object.defineProperty(vt, "spineBorderWidth", {
                    get: function() {
                        return tt
                    },
                    set: function(n) {
                        n > 0 || (n = 0);
                        tt = n;
                        vt.spineBorderWidthCommand && tt != 0 ? (vt.spineBorderWidthCommand.width = tt, rt && (vt.spineBorderDashedCommand.segments = [20, 10], vt.spineBorderDashedCommand.offset = 5)) : pt()
                    }
                });
                Object.defineProperty(vt, "closeColor", {
                    get: function() {
                        return ft
                    },
                    set: function(n) {
                        zot(n) && (n = "black");
                        ft = n;
                        vt.closeColorCommand ? n && n.type ? vt.specialColor(vt.closeColorCommand, n, vt) : vt.closeColorCommand.style = n : pt()
                    }
                });
                Object.defineProperty(vt, "closeBorderColor", {
                    get: function() {
                        return ot
                    },
                    set: function(n) {
                        ot = n;
                        vt.closeBorderColorCommand ? n && n.type ? vt.specialColor(vt.closeBorderColorCommand, n, vt) : vt.closeBorderColorCommand.style = n : pt()
                    }
                });
                Object.defineProperty(vt, "closeBorderWidth", {
                    get: function() {
                        return et
                    },
                    set: function(n) {
                        n > 0 || (n = 0);
                        et = n;
                        vt.closeBorderWidthCommand && et != 0 ? (vt.closeBorderWidthCommand.width = et, st && (vt.closeBorderDashedCommand.segments = [20, 10], vt.closeBorderDashedCommand.offset = 5)) : pt()
                    }
                });
                Object.defineProperty(vt, "pin", {
                    get: function() {
                        return s
                    },
                    set: function(n) {
                        n > 0 || (n = 0);
                        n > vt.pinPoints.length - 1 && (s = 0);
                        s = n;
                        var t = vt.pinPoints[s];
                        t && (vt.regX = t.x, vt.regY = t.y)
                    }
                });
                kt = n.boundsAroundPoints(vt.points);
                this.setBounds(kt.x, kt.y, kt.width, kt.height);
                zot(s) || (vt.pin = s);
                this.mouseChildren = !1;
                ct !== !1 && n.styleTransforms(this, yt);
                this.clone = function() {
                    return vt.cloneProps(new n.Flare(t, i, r, ni, n.copy(f), n.copy(e), n.copy(o), s, h, c, n.copy(l), n.copy(a), n.copy(v), n.copy(y), n.copy(p), w, n.copy(b), k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, this.group, at))
                }
            }, n.extend(n.Flare, n.Container, ["clone"], "zimContainer", !1), n.MultiFlare = function(t, i, r, u, f, e, o) {
                var c, h, s;
                if (c = zob(n.MultiFlare, arguments, "flares, pins, angles, endToEnd, style, group, inherit", this)) return c;
                z_d("53.7");
                this.zimContainer_constructor();
                this.type = "MultiFlare";
                this.group = e;
                h = f === !1 ? {} : n.getStyle(this.type, this.group, o);
                s = this;
                zot(t) && (t = h.flares != null ? h.flares : []);
                Array.isArray(t) || (t = [t]);
                zot(i) && (i = h.pins != null ? h.pins : null);
                zot(r) && (r = h.angles != null ? h.angles : null);
                zot(u) && (u = h.endToEnd != null ? h.endToEnd : !1);
                s.flares = t;
                s.pins = i;
                s.angles = r;
                s.endToEnd = u;
                s.mouseChildren = !1;
                s.add = function(t, i) {
                    return zot(t) ? s : (zot(i) && (i = !0), Array.isArray(t) || (t = [t]), n.loop(t, function(n) {
                        i ? s.flares.push(n.clone()) : s.flares.push(n)
                    }), s.remake(), s.stage && s.stage.update(), s)
                };
                s.remove = function(t) {
                    return zot(t) ? s : (Array.isArray(t) || (t = [t]), n.loop(t, function(n) {
                        var t = s.flares.indexOf(n);
                        t >= 0 && s.flares.splice(t, 1)
                    }), s.remake(), s.stage && s.stage.update(), s)
                };
                s.remake = function() {
                    s.removeAllChildren();
                    n.loop(s.flares, function(n, f) {
                        if (i && !zot(i[f]) && (n.pin = i[f]), r && !zot(r[f]) && (n.rotation = r[f]), n.addTo(s), s.flares.push(n), u && f > 0) {
                            var e = t[f - 1],
                                o = e.pinPoints[e.pinPoints.length - 1],
                                h = e.localToLocal(o.x, o.y, s),
                                c = n.pinPoints[0],
                                l = n.localToLocal(c.x, c.y, s);
                            n.mov(h.x - l.x, h.y - l.y)
                        }
                    })
                };
                s.remake();
                f !== !1 && n.styleTransforms(this, h);
                this.clone = function() {
                    return s.cloneProps(new n.MultiFlare(n.copy(t, !0), n.copy(i), n.copy(r), u, f, this.group, o))
                }
            }, n.extend(n.MultiFlare, n.Container, ["clone"], "zimContainer", !1), n.FlareBox = function(t, i, r, u, f, e, o, s, h, c, l) {
                var y, a, v;
                if (y = zob(n.FlareBox, arguments, "width, height, color, borderColor, borderWidth, flares, corners, pins, style, group, inherit", this)) return y;
                if (z_d("53.8"), this.group = c, a = h === !1 ? {} : n.getStyle("FlareBox", this.group, l), zot(t) && (t = a.width != null ? a.width : 220), zot(i) && (i = a.height != null ? a.height : 80), this.zimContainer_constructor(t, i), this.type = "FlareBox", v = this, this.mouseChildren = !1, zot(u) && (u = a.borderColor != null ? a.borderColor : null), zot(f) && (f = a.borderWidth != null ? a.borderWidth : null), u < 0 || f < 0 ? u = f = null : u != null && f == null && (f = 1), zot(r) && (r = a.color != null ? a.color : f > 0 ? "rgba(0,0,0,0)" : "black"), (zot(f) || f > 0) && (zot(u) && zot(f) || zot(u) && (u = "black")), zot(e) && (e = a.flares != null ? a.flares : null), zot(o) && (o = a.corners != null ? a.corners : null), zot(s) && (s = a.pins != null ? a.pins : null), v.backing = new n.Rectangle(t, i, r, u, f).addTo(this), !zot(e)) {
                    if (e.type != "MultiFlare") {
                        if (!Array.isArray(e)) {
                            if (e.type != "Flare") return;
                            e = [e]
                        }
                        e = new n.MultiFlare(e, s)
                    }
                    e.addTo(v);
                    v.multiFlare = e;
                    v.flares = v.multiFlare.flares;
                    e.loop(function(n, r) {
                        s && !zot(s[r]) ? n.pin = s[r] : zot(n.pin) && (n.pin = 0);
                        o && !zot(o[r]) ? n.corner = o[r] : zot(n.corner) && (n.corner = 0);
                        n.corner == 1 ? n.loc(t, 0) : n.corner == 2 ? n.loc(t, i) : n.corner == 3 ? n.loc(0, i) : n.loc(0, 0);
                        n.rot((n.corner - n.pin) * 90)
                    });
                    h !== !1 && n.styleTransforms(this, a);
                    this.clone = function() {
                        return v.cloneProps(new n.FlareBox(t, i, r, u, f, n.copy(e, !0), n.copy(o), n.copy(s), h, this.group, l))
                    }
                }
            }, n.extend(n.FlareBox, n.Container, ["clone"], "zimContainer", !1), n.Label = function(t, i, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt) {
                function rr() {
                    return arguments
                }

                function ui(n) {
                    var t = new createjs.Text(n, di, f);
                    return t.lineWidth = gt, t.lineHeight = p, t
                }

                function ur(n, t, i) {
                    var r = Math.ceil(gt / t * i.length),
                        u = i.substr(0, r),
                        e = ui(u),
                        f = e.getMeasuredWidth(),
                        o;
                    if (f > gt)
                        while (f > gt) r--, u = i.substr(0, r), e = ui(u), f = e.getMeasuredWidth();
                    else if (f < gt) {
                        while (f < gt) r++, u = i.substr(0, r), e = ui(u), f = e.getMeasuredWidth();
                        r--;
                        u = i.substr(0, r)
                    }
                    return o = i.substr(r, i.length), {
                        endIndex: r,
                        start: u,
                        end: o
                    }
                }

                function vi() {
                    wt.removeChild(wt.background);
                    wt.background = new n.Rectangle(wt.getBounds().width + ut * 2, wt.getBounds().height + ft * 2, d, g, nt, tt, it, null, null, !1);
                    n.center(wt.background, wt, 0);
                    wt.setBounds(wt.background.x, wt.background.y, wt.background.width, wt.background.height)
                }

                function fi() {
                    var t = kt.getBounds(),
                        e = t.y,
                        o = t.height,
                        u, f, r;
                    gt && !ti && (u = t.x, f = gt, h == "right" ? u = t.x - gt + t.width : h == "center" && (u = -gt / 2), kt.setBounds(u, e, f, o), t = kt.getBounds());
                    c == "baseline" ? r = t.y : c == "top" ? (kt.y = i - i / 6, r = 0) : c == "center" || c == "middle" ? (r = -t.height / 2, kt.y = i * .3) : r = -t.height;
                    wt.setBounds(t.x, r, bt.width ? bt.width - rt * 2 : t.width, bt.height ? bt.height - rt * 2 : t.height);
                    wt.hitArea && wt.hitArea.graphics.c().f("black").r(wt.getBounds().x, wt.getBounds().y, wt.getBounds().width, wt.getBounds().height);
                    (c == "center" || c == "middle") && (n.pos(kt, null, 0), n.mov(kt, 0, 1));
                    ct || (w ? li && pi() : zot(d) || vi());
                    c == "baseline" || ki || (kt.y += i / 32);
                    tr()
                }

                function pi() {
                    var t = w.boundsToGlobal(),
                        n = wt.boundsToGlobal(t, !0);
                    wt.setBounds(n.x, n.y, n.width, n.height)
                }

                function tr() {
                    n.pos(kt, h == "left" || h == "right" ? w || wt.background ? ut : 0 : null, c == "top" || c == "baseline" || c == "bottom" ? w || wt.background ? ft : 0 : null, h == "right", c == "bottom");
                    kt.x += et;
                    kt.y += ot
                }

                function ei() {
                    dt && (dt.x = kt.x, dt.y = kt.y, wt.addChildAt(dt, wt.background || wt.backing ? 1 : 0))
                }

                function ir() {
                    wt.mouseoverEvent = wt.on("mouseover", function() {
                        wt.showRollColor && wt.showRollColor()
                    });
                    wt.mouseoutEvent = wt.on("mouseout", function() {
                        wt.rollPersist || wt.showRollColor(!1)
                    });
                    wt.pressupEvent = wt.on("pressup", function() {
                        wt.rollPersist && wt.showRollColor(!1)
                    })
                }

                function fr() {
                    wt.off("mouseover", wt.mouseoverEvent);
                    wt.off("mouseout", wt.mouseoutEvent);
                    wt.off("pressup", wt.pressupEvent)
                }

                function ci() {
                    var t;
                    for (wt.size = lt ? lt : 200, t = 0; p < ti / 2 && (wt.height > ti || wt.width > gt);)
                        if (t++, wt.size = wt.size / 2, t > 50) break;
                    for (t = 0; wt.height <= ti && wt.width <= gt;)
                        if (t++, wt.size = Math.ceil(wt.size + 1), t > 50) break;
                    wt.size = wt.size - 1;
                    ei();
                    kt.setBounds(null);
                    var n = kt.getBounds(),
                        i = n.y,
                        r = n.height;
                    ti && (c == "bottom" ? i = i - ti + r : (c == "center" || c == "middle") && (i = (i + i - ti + r) / 2), r = ti);
                    kt.setBounds(n.x, i, n.width, r);
                    wt.setBounds(null);
                    n = wt.getBounds();
                    wt.setBounds(n.x, n.y, n.width, n.height);
                    w ? li && pi() : zot(d) || vi()
                }
                var bi, bt, ii, oi, ki, wt, ni, di, gi, ri, ai, dt, nr, yi, si, hi, wi;
                if (bi = zob(n.Label, arguments, "text, size, font, color, rollColor, shadowColor, shadowBlur, align, valign, bold, italic, variant, lineWidth, lineHeight, backing, outlineColor, outlineWidth, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, rollPersist, labelWidth, labelHeight, maxSize, splitWords, style, group, inherit", this)) return bi;
                z_d("54");
                this.zimContainer_constructor(null, null, null, null, !1);
                this.type = "Label";
                this.group = yt;
                bt = vt === !1 ? {} : n.getStyle(this.type, this.group, pt);
                zot(t) && (t = bt.text != null ? bt.text : "LABEL");
                zot(i) && (i = bt.size != null ? bt.size : 36);
                zot(u) && (u = bt.font != null ? bt.font : "arial");
                zot(f) && (f = bt.color != null ? bt.color : "black");
                zot(l) && (l = bt.bold != null ? bt.bold : !1);
                zot(a) && (a = bt.italic != null ? bt.italic : !1);
                ii = rr(t, i, u, f, l, a);
                t = n.Pick.choose(t);
                oi = !1;
                t === "" && (t = " ", oi = !0);
                i = n.Pick.choose(i);
                u = n.Pick.choose(u);
                f = n.Pick.choose(f);
                l = n.Pick.choose(l);
                a = n.Pick.choose(a);
                zot(e) && (e = bt.rollColor != null ? bt.rollColor : null);
                (zot(o) || o == "ignore") && (o = bt.shadowColor != null && o != "ignore" ? bt.shadowColor : -1);
                (zot(s) || s == "ignore") && (s = bt.shadowBlur != null && s != "ignore" ? bt.shadowBlur : 14);
                zot(h) && (h = bt.align != null ? bt.align : "left");
                zot(c) && (c = bt.valign != null ? bt.valign : "top");
                zot(b) && zot(bt.outlineColor) || !zot(k) || (k = bt.outlineWidth != null ? bt.outlineWidth : Math.round(i * .2));
                zot(k) && zot(bt.outlineWidth) || !zot(b) || (b = bt.outlineColor != null ? bt.outlineColor : "#000000");
                zot(k) && (k = bt.outlineWidth != null ? bt.outlineWidth : 0);
                (zot(d) || d == "ignore") && (d = bt.backgroundColor != null && d != "ignore" ? bt.backgroundColor : null);
                zot(g) && (g = bt.backgroundBorderColor != null && g != "ignore" ? bt.backgroundBorderColor : null);
                zot(nt) && (nt = bt.backgroundBorderWidth != null && nt != "ignore" ? bt.backgroundBorderWidth : null);
                (zot(rt) || rt == "ignore") && (rt = bt.padding != null && rt != "ignore" ? bt.padding : 10);
                zot(ut) && (ut = bt.paddingHorizontal != null ? bt.paddingHorizontal : rt);
                zot(ft) && (ft = bt.paddingVertical != null ? bt.paddingVertical : rt);
                zot(et) && (et = bt.shiftHorizontal != null ? bt.shiftHorizontal : 0);
                zot(ot) && (ot = bt.shiftVertical != null ? bt.shiftVertical : 0);
                zot(v) && (v = bt.variant != null ? bt.variant : !1);
                zot(y) && (y = bt.lineWidth != null ? bt.lineWidth : null);
                zot(p) && (p = bt.lineHeight != null ? bt.lineHeight : null);
                (zot(w) || w == "ignore") && (w = bt.backing != null && w != "ignore" ? bt.backing.clone() : null);
                zot(st) && (st = bt.rollPersist != null ? bt.rollPersist : !1);
                bt.labelWidth != null && (y = bt.labelWidth);
                zot(ht) || (y = ht);
                h == "middle" && (h = "center");
                zot(ct) && (ct = bt.labelHeight != null ? bt.labelHeight : null);
                zot(lt) && (lt = bt.maxSize != null ? bt.maxSize : null);
                i = lt ? Math.min(i, lt) : i;
                zot(at) && (at = bt.splitWords != null ? bt.splitWords : !1);
                ki = WW.zdf && WW.zdf.retina;
                wt = this;
                this.mouseChildren = !1;
                this.paddingVertical = ft;
                this.paddingHorizontal = ut;
                WW.DIR && WW.DIR == "rtl" || !WW.DIR && n.DIR == "rtl" ? h == "start" ? h = "right" : h == "end" && (h = "left") : h == "start" ? h = "left" : h == "end" && (h = "right");
                ni = [];
                ni[0] = a ? "italic" : "normal";
                ni[1] = v ? "small-caps" : "normal";
                ni[2] = l ? "bold" : "normal";
                ni[3] = i + "px";
                ni[4] = u;
                di = ni.join(" ");
                t = String(t);
                var kt, li = !1,
                    gt = y,
                    ti = ct;
                if (zot(w) && zot(d) ? (gi = new createjs.Shape, wt.hitArea = gi) : (gt && (gt = gt - ut * 2), ti && (ti = ti - ft * 2)), kt = ui(t), at && gt > i * 1.2)
                    for (ri = kt.getMetrics(), ai = 0; ri.width > gt && ai < 1e3;) ai++, n.loop(ri.lines, function(n, t) {
                        var r, u, i;
                        return n = n.replace(/^[\s\t]+/, ""), r = ui(n), u = r.getMeasuredWidth(), u > gt ? (i = ur(r, u, n), ri.lines[t] = i.start, ri.lines.length > t + 1 ? (i.end.trim(), ri.lines[t + 1] = i.end + " " + ri.lines[t + 1]) : ri.lines.push(i.end), kt = ui(ri.lines.join(" ")), ri = kt.getMetrics(), !1) : void 0
                    });
                this.label = kt;
                kt.textAlign = h;
                kt.textBaseline = "alphabetic";
                k > 0 && (dt = this.outlineLabel = kt.clone(), dt.color = b, dt.outline = k);
                o != -1 && s > 0 && (kt.shadow = new createjs.Shadow(o, 3, 3, s));
                this.addChild(kt);
                fi();
                zot(w) || (w.type == "Pattern" ? (wt.backing = new n.Container(wt.width + ut * 2, wt.height + ft * 2, null, null, !1).centerReg(null, null, !1), o != -1 && s > 0 && (nr = new n.Rectangle(wt.width + ut * 2 - 2, wt.height + ft - 2, "#666", null, null, tt, null, null, null, !1).center(wt.backing), nr.shadow = new createjs.Shadow(o, 3, 3, s)), yi = new n.Rectangle(wt.width + ut * 2, wt.height + ft * 2, d, null, null, tt, null, null, null, !1).addTo(wt.backing), w.centerReg(yi), w.setMask(yi), wt.backing.pattern = w) : wt.backing = w, wt.backing.center(wt, 0), w = wt.backing, pi(), li = !0);
                tr();
                ei();
                Object.defineProperty(wt, "text", {
                    get: function() {
                        return kt.text == " " && oi ? "" : kt.text
                    },
                    set: function(n) {
                        oi = !1;
                        n === "" && (n = " ", oi = !0);
                        kt.text = String(n);
                        kt.setBounds(null);
                        wt.setBounds(null);
                        fi();
                        dt && (dt.text = String(n));
                        zot(y) || zot(ct) || (ci(), dt && ei())
                    }
                });
                Object.defineProperty(wt, "size", {
                    get: function() {
                        return i
                    },
                    set: function(n) {
                        i = lt ? Math.min(n, lt) : n;
                        ni[3] = i + "px";
                        this.label.font = ni.join(" ");
                        dt && (dt.font = ni.join(" "));
                        kt.setBounds(null);
                        wt.setBounds(null);
                        fi();
                        ei()
                    }
                });
                Object.defineProperty(wt, "bold", {
                    get: function() {
                        return Boolean(this.label.font.match("bold"))
                    },
                    set: function(n) {
                        l = n;
                        ni[2] = n ? "bold" : "normal";
                        this.label.font = ni.join(" ");
                        dt && (dt.font = ni.join(" "))
                    }
                });
                Object.defineProperty(wt, "italic", {
                    get: function() {
                        return Boolean(this.label.font.match("italic"))
                    },
                    set: function(n) {
                        a = n;
                        ni[0] = n ? "italic" : "normal";
                        this.label.font = ni.join(" ");
                        dt && (dt.font = ni.join(" "))
                    }
                });
                Object.defineProperty(wt, "variant", {
                    get: function() {
                        return Boolean(this.label.font.match("small-caps"))
                    },
                    set: function(n) {
                        v = n;
                        ni[1] = n ? "small-caps" : "normal";
                        this.label.font = ni.join(" ");
                        dt && (dt.font = ni.join(" "))
                    }
                });
                Object.defineProperty(wt, "font", {
                    get: function() {
                        return ni[4]
                    },
                    set: function(n) {
                        zot(n) || (u = n, ni[4] = n, this.label.font = ni.join(" "), dt && (dt.font = ni.join(" ")))
                    }
                });
                Object.defineProperty(wt, "align", {
                    get: function() {
                        return h
                    },
                    set: function(n) {
                        zot(n) || (h = n, this.label.textAlign = h, dt && (dt.textAlign = h), fi(), ei())
                    }
                });
                Object.defineProperty(wt, "valign", {
                    get: function() {
                        return c
                    },
                    set: function(n) {
                        zot(n) || (c = n, fi(), ei())
                    }
                });
                Object.defineProperty(wt, "color", {
                    get: function() {
                        return f
                    },
                    set: function(t) {
                        e == f && (e = t);
                        f = t;
                        kt.color = f;
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && wt.stage && wt.stage.update()
                    }
                });
                Object.defineProperty(wt, "colorOnly", {
                    get: function() {
                        return f
                    },
                    set: function(t) {
                        f = t;
                        kt.color = f;
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && wt.stage && wt.stage.update()
                    }
                });
                this.setColorRange = function(n, t) {
                    return zot(t) ? (si = wt.color, hi = n) : zot(n) ? (si = wt.color, hi = t) : (si = n, hi = t), wt
                };
                wi = 0;
                Object.defineProperty(wt, "colorRange", {
                    get: function() {
                        return wi
                    },
                    set: function(t) {
                        wi = t;
                        zot(si) || zot(hi) || (wt.color = n.colorRange(si, hi, t))
                    }
                });
                Object.defineProperty(wt, "backgroundColor", {
                    get: function() {
                        return d
                    },
                    set: function(t) {
                        d = t;
                        wt.background ? wt.background.color = t : wt.backing ? wt.backing.color = t : vi();
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && wt.stage && wt.stage.update()
                    }
                });
                Object.defineProperty(wt, "outlineColor", {
                    get: function() {
                        return b
                    },
                    set: function(t) {
                        b = t;
                        dt && (dt.color = b);
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && wt.stage && wt.stage.update()
                    }
                });
                Object.defineProperty(wt, "rollColor", {
                    get: function() {
                        return e
                    },
                    set: function(n) {
                        !wt.mouseoverEvent && n && ir();
                        n == null && wt.mouseoverEvent && fr();
                        e = n
                    }
                });
                this._enabled = !0;
                Object.defineProperty(wt, "enabled", {
                    get: function() {
                        return wt._enabled
                    },
                    set: function(t) {
                        r(wt, t);
                        kt.color = f;
                        wt.mouseChildren = !1;
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && wt.stage && wt.stage.update()
                    }
                });
                this.showRollColor = function(n) {
                    return zot(n) && (n = !0), kt.color = n ? e : f, wt.stage && wt.stage.update(), wt
                };
                e && ir();
                Object.defineProperty(wt, "labelWidth", {
                    get: function() {
                        return y
                    },
                    set: function(t) {
                        t > 0 && (y = t, gt = y, zot(w) && zot(d) || gt && (gt = gt - ut * 2), wt.label.lineWidth = gt, dt && (dt.lineWidth = gt), kt.setBounds(null), wt.setBounds(null), fi(), ct && ci(), !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && wt.stage && wt.stage.update())
                    }
                });
                Object.defineProperty(wt, "labelHeight", {
                    get: function() {
                        return ct
                    },
                    set: function(t) {
                        t > 0 && (ct = t, ti = ct, zot(w) && zot(d) || ti && (ti = ti - ft * 2), y && ci(), wt.setBounds(null), !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && wt.stage && wt.stage.update())
                    }
                });
                zot(y) || zot(ct) || ci();
                n.styleTransforms(this, bt);
                this.clone = function(t) {
                    return wt.cloneProps(new n.Label(t || !n.isPick(ii[0]) ? wt.text : ii[0], t || !n.isPick(ii[1]) ? i : ii[1], t || !n.isPick(ii[2]) ? u : ii[2], t || !n.isPick(ii[3]) ? f : ii[3], e, o, s, h, c, t || !n.isPick(ii[4]) ? l : ii[4], t || !n.isPick(ii[5]) ? a : ii[5], v, y, p, zot(w) ? null : w.clone(t), b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, this.group, pt))
                }
            }, n.extend(n.Label, n.Container, "clone", "zimContainer"), n.LabelOnPath = function(t, i, r, u, f, e, o, s, h, c, l, a) {
                function nt() {
                    for (var n, i = p.numChildren - 1; i >= 0; i--) p.getChildAt(i).dispose();
                    for (v.numLetters = t.text.length, i = 0; i < v.numLetters; i++) {
                        n = t.clone();
                        n.text = t.text[i];
                        n.centerReg(p).reg(null, n.height);
                        n.text != "" && n.text != " " && n.expand(0);
                        v.allowToggle && (n.cursor = "pointer");
                        n.on("mousedown", function() {
                            v.allowToggle && v.toggle()
                        })
                    }
                    v.resize()
                }
                var g, y, b, v, k, p, d, w;
                if (g = zob(n.LabelOnPath, arguments, "label, path, percentAngle, percents, showPath, allowToggle, interactive, onTop, rtl, style, group, inherit", this)) return g;
                if (z_d("54.5"), this.zimContainer_constructor(null, null, null, null, !1), this.type = "LabelOnPath", this.group = l, y = c === !1 ? {} : n.getStyle(this.type, this.group, a), zot(t) && (t = y.label != null ? y.label : new n.Label("Label on Path")), zot(i) && (i = y.path != null ? y.path : new n.Squiggle({
                        points: [
                            [0, 0, 0, 0, -86, 57, 86, -57],
                            [300, 150, 0, 0, -133, 21, 133, -21]
                        ]
                    })), zot(r) && (r = y.percentAngle != null ? y.percentAngle : 100), zot(u) && (u = y.percents != null ? y.percents : null), zot(f) && (f = y.showPath != null ? y.showPath : !0), zot(e) && (e = y.allowToggle != null ? y.allowToggle : !0), zot(o) && (o = y.interactive != null ? y.interactive : !0), zot(s) && (s = y.onTop != null ? y.onTop : !1), zot(h) && (h = y.rtl != null ? y.rtl : WW.DIR == "rtl" || n.DIR == "rtl"), h && i.reversePoints(), b = t.color, i.addTo(this), v = this, this.path = i, this.allowToggle = e, i.interactive = o, typeof t == "string" && (t = new n.Label(t)), k = i.alpha, f || i.alp(0), i.onTop = s, p = this.letters = (new n.Container).addTo(this), !u)
                    for (u = [], d = 0; d < t.text.length; d++) u.push(n.decimals(100 / (t.text.length - (i.type == "Blob" ? 0 : 1)) * d));
                this.percents = u;
                this.resize = function() {
                    for (var n, f, e = i.segmentRatios, o = i.segmentPoints, t = 0; t < this.numLetters; t++)(n = i.getCurvePoint(u[t] / 100, e, o, !0), n) && (f = this.globalToLocal(n.x, n.y), f) && (p.getChildAt(t).loc(f).rot((n.angle > 180 ? n.angle - 360 : n.angle) * r / 100), h && (p.getChildAt(t).rotation += 180));
                    return this
                };
                nt();
                this.showPath = function(n) {
                    return this.toggle(!0), i.toggle(n), this
                };
                this.hidePath = function() {
                    return this.toggle(!1), this
                };
                Object.defineProperty(v, "text", {
                    get: function() {
                        return t.text
                    },
                    set: function(r) {
                        t.text = r;
                        u = [];
                        for (var f = 0; f < t.text.length; f++) u.push(n.decimals(100 / (t.text.length - (i.type == "Blob" ? 0 : 1)) * f));
                        nt()
                    }
                });
                Object.defineProperty(this, "color", {
                    get: function() {
                        return b
                    },
                    set: function(n) {
                        b = n;
                        for (var t = 0; t < v.letters.numChildren; t++) v.letters.getChildAt(t).color = b;
                        v.stage && v.stage.update()
                    }
                });
                Object.defineProperty(v, "interactive", {
                    get: function() {
                        return o
                    },
                    set: function(t) {
                        o = t;
                        i.interactive = t;
                        this.ticker && n.Ticker.remove(this.ticker);
                        o && (this.ticker = n.Ticker.add(function() {
                            v.resize()
                        }))
                    }
                });
                this.interactive && (this.ticker = n.Ticker.add(function() {
                    v.resize()
                }));
                w = v.toggled = f;
                this.toggle = function(n) {
                    if (this.allowToggle) return w = zot(n) ? !w : n ? !0 : !1, w ? (i.alp(k), this.interactive && (i.showControls(), p.mouseEnabled = !1, p.mouseChildren = !1, p.cursor = "default", this.controlHideEvent && i.off("controlshide", this.controlHideEvent), this.controlHideEvent = i.on("controlshide", function() {
                        p.mouseEnabled = !0;
                        p.mouseChildren = !0;
                        p.cursor = "pointer";
                        k = i.alpha;
                        i.alp(0);
                        w = !1;
                        v.toggled = w;
                        v.stage && v.stage.update()
                    }, null, !0))) : (k = i.alpha, i.alp(0), p.mouseEnabled = !0, p.mouseChildren = !0, p.cursor = "pointer"), v.toggled = w, v.stage && v.stage.update(), v
                };
                v.toggle(!0);
                n.styleTransforms(this, y);
                this.clone = function() {
                    return v.cloneProps(new n.LabelOnPath(v.label.clone(), v.path.clone(), r, n.copy(u), f, e, o, s, h, c, this.group, a))
                };
                this.dispose = function(t, i, r) {
                    return this.ticker && n.Ticker.remove(this.ticker), r || this.zimContainer_dispose(!0), !0
                }
            }, n.extend(n.LabelOnPath, n.Container, ["clone", "dispose"], "zimContainer", !1), n.LabelOnArc = function(t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k) {
                function ct() {
                    var u, i, r;
                    for (g.disposeAllChildren(), e && (u = t.text.split("").reverse().join(""), t.text = u), rt = g.letters = new n.Container(g.width, g.height).centerReg(g), g.numLetters = t.text.length, g.letterHeight = t.height, ut = g.labels = [], i = 0; i < g.numLetters; i++) r = t.clone(), ut.push(r), r.text = t.text[i], r.letterHolder = new n.Container(r.width, r.height), r.centerReg(r.letterHolder).rot(e ? 180 : 0);
                    if (p && ut.reverse(), ht = g.circle = new n.Circle(f), c && ht.addTo(g), st = g.arc = (new n.Shape).addTo(g), lt(), h) {
                        for (nt = 0, i = 0; i < h.length; i++) nt += h[i];
                        nt += h[h.length - 1] / 2
                    }
                    at()
                }

                function lt() {
                    var t, n, i;
                    for (nt = 0, it = [0], t = 0; t < g.numLetters; t++) n = ut[t], i = Math.atan((n.width + s) / 2 / (f + o)) * 180 / Math.PI * 2, it.push(i), nt += i, n.letterHolder.centerReg(rt).reg(null, f + o + n.height + (e ? n.height * .13 : 0));
                    g.circle.radius = f;
                    (l || a || v) && (v > 0 && zot(a) ? a = "#000000" : zot(v) && !zot(a) && (v = 2), st.graphics.c().f(null).s(a).ss(v).arc(0, 0, f, (g.startAngle - 90) * Math.PI / 180, (g.startAngle - 90 + nt) * Math.PI / 180))
                }

                function at() {
                    var n, t, i;
                    if (!ft)
                        for (h = [], n = 0; n < it.length - 1; n++) h[n] = Math.round((it[n] + it[n + 1]) * 50) / 100;
                    for (g.angles = h, g.startAngle = -nt / 2, t = g.startAngle, n = 0; n < rt.numChildren; n++) i = rt.getChildAt(n), t = i.rotation = t + h[n]
                }
                var ot, d, ft, et, tt, g, rt, ut, st, ht, nt, it;
                if (ot = zob(n.LabelOnArc, arguments, "label, size, font, color, radius, flip, spacing, letterSpacing, angles, showCircle, arcColor, arcBorderColor, arcBorderWidth, radiusSpread, rtl, style, group, inherit", this)) return ot;
                z_d("54.55");
                this.group = b;
                d = w === !1 ? {} : n.getStyle("LabelOnArc", this.group, k);
                zot(i) && (i = d.size != null ? d.size : 30);
                zot(t) && (t = d.label != null ? d.label : new n.Label("Label on Arc", i));
                zot(r) && (r = d.font != null ? d.font : "verdana");
                zot(u) && (u = d.color != null ? d.color : "white");
                zot(f) && (f = d.radius != null ? d.radius : 100);
                zot(e) && (e = d.flip != null ? d.flip : !1);
                zot(o) && (o = d.spacing != null ? d.spacing : 0);
                zot(s) && (s = d.letterSpacing != null ? d.letterSpacing : 5);
                zot(h) && (h = d.angles != null ? d.angles : null);
                ft = !zot(h);
                et = n.copy(h);
                zot(c) && (c = d.showCircle != null ? d.showCircle : !1);
                zot(l) && (l = d.arcColor != null ? d.arcColor : null);
                zot(a) && (a = d.arcBorderColor != null ? d.arcBorderColor : null);
                zot(v) && (v = d.arcBorderWidth != null ? d.arcBorderWidth : null);
                zot(y) && (y = d.radiusSpread != null ? d.radiusSpread : !1);
                zot(p) && (p = d.rtl != null ? d.rtl : WW.DIR == "rtl" || n.DIR == "rtl");
                tt = this.outerRadius = f + o + t.height;
                this.innerRadius = f + o;
                this.zimContainer_constructor(-tt, -tt, tt * 2, tt * 2, !1);
                this.type = "LabelOnArc";
                g = this;
                t.type != "Label" && (t = new n.Label(t, i, r, u));
                t.text;
                ct();
                Object.defineProperty(this, "radius", {
                    get: function() {
                        return f
                    },
                    set: function(n) {
                        f = n;
                        lt();
                        ft || y || at()
                    }
                });
                Object.defineProperty(this, "color", {
                    get: function() {
                        return u
                    },
                    set: function(n) {
                        u = n;
                        for (var t = 0; t < g.labels.length; t++) g.labels[t].color = u;
                        g.stage && g.stage.update()
                    }
                });
                Object.defineProperty(g, "text", {
                    get: function() {
                        return t.text
                    },
                    set: function(i) {
                        t.text = i;
                        h = et ? n.copy(et) : null;
                        ct()
                    }
                });
                n.styleTransforms(this, d);
                this.clone = function() {
                    return g.cloneProps(new n.LabelOnArc(t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, this.group, k))
                }
            }, n.extend(n.LabelOnArc, n.Container, "clone", "zimContainer", !1), n.LabelLetters = function(t, i, r, u, f, e, o, s, h, c, l, a, v, y, p) {
                function ci(t) {
                    function h(n) {
                        return n.split("").reverse().join("")
                    }

                    function o(t, i, u) {
                        var f, e;
                        t.length > 1 && ((i == "font" || i == "a") && u == 0 ? (f = t[0].length, n.loop(t, function(n, t) {
                            var e, o;
                            t != 0 && (e = r[f], e || (r[f] = []), e = r[f], o = n.split(">"), e[u] ? e[u].push(i + " " + o[0]) : e[u] = [i + " " + o[0]], f += o[1].length)
                        })) : (t.pop(), e = 0, n.loop(t, function(n) {
                            e += n.length;
                            var t = r[e];
                            t || (r[e] = []);
                            t = r[e];
                            t[u] ? t[u].push(i) : t[u] = [i]
                        })))
                    }
                    var r = [],
                        u, e, s, i, f;
                    return a && (wt = -1, t = t.replace(/[\u0591-\u07FF]+/ig, h), t = t.replace(/([^\u0591-\u07FF ])([\u0591-\u07FF])/ig, "$1-!!-$2"), t = t.replace(/([\u0591-\u07FF])([^\u0591-\u07FF ])/ig, "$1-!!-$2"), t = t.replace(/([^\u0591-\u07FF]) ([\u0591-\u07FF])/ig, "$1-!!- -!!-$2"), t = t.replace(/([\u0591-\u07FF]) ([^\u0591-\u07FF])/ig, "$1-!!- -!!-$2"), u = t.split(/-!!-/g), n.loop(u, function(n, t) {
                        n.match(/[\u0591-\u07FF]/i) && (u[t] = n.split(" ").reverse().join(" "))
                    }), t = u.join("")), t = t.replace(/\n|\r/g, "<br>"), t = t.replace(/<strong>|<strong \/>|<strong\/>/gi, "<b>"), t = t.replace(/<\/strong>/gi, "<\/b>"), t = t.replace(/<em>|<em \/>|<em\/>/gi, "<i>"), t = t.replace(/<\/em>/gi, "<\/i>"), t = t.replace(/\\n|\\r/g, "<br>"), t = t.replace(/<br>|<br \/>|<br\/>(<\/br>)?/gi, "<br>"), t = t.replace(/<b/gi, "<b"), t = t.replace(/<i/gi, "<i"), t = t.replace(/<u/gi, "<u"), t = t.replace(/<br/gi, "<br"), t = t.replace(/<a/gi, "<a"), t = t.replace(/<font/gi, "<font"), e = [/<(a|i|u|f|br|\/a|\/i|\/u|\/f|\/b)[^>]*>/g, /<(a|i|u|f|br|\/a|\/i|\/u|\/f|b)[^>]*>/g, /<(b|i|u|f|br|\/b|\/i|\/u|\/f|\/a)[^>]*>/g, /<(b|i|u|f|br|\/b|\/i|\/u|\/f|a)[^>]*>/g, /<(b|a|u|f|br|\/b|\/a|\/u|\/f|\/i)[^>]*>/g, /<(b|a|u|f|br|\/b|\/a|\/u|\/f|i)[^>]*>/g, /<(b|a|i|f|br|\/b|\/a|\/i|\/f|\/u)[^>]*>/g, /<(b|a|i|f|br|\/b|\/a|\/i|\/f|u)[^>]*>/g, /<(b|a|i|u|br|\/b|\/a|\/i|\/u|\/f)[^>]*>/g, /<(b|a|i|u|br|\/b|\/a|\/i|\/u|f)[^>]*>/g], s = ["b", "a", "i", "u", "font"], n.loop(s, function(n, r) {
                        i = t.replace(e[r * 2], "");
                        var u;
                        u = n == "font" ? i.split("<font ") : n == "a" ? i.split("<a ") : i.split("<" + n + ">");
                        o(u, n, 0);
                        i = t.replace(e[r * 2 + 1], "");
                        u = i.split("<\/" + n + ">");
                        o(u, n, 1)
                    }), i = t.replace(/<br>/gi, "@^#"), i = i.replace(/<(b|a|i|u|f|\/b|\/a|\/i|\/u|\/f)[^>]*>/g, ""), f = i.split("@^#"), hi = f.join("\n"), i = f.join(""), o(f, "br", 0), {
                        text: i,
                        data: r,
                        original: hi
                    }
                }

                function vi(t) {
                    var i = t.currentTarget,
                        r = k.rolls[i.rollIndex];
                    n.loop(r, function(n) {
                        n.backgroundColor = i.zrbc
                    });
                    i.stage && i.stage.update()
                }

                function li(t) {
                    var i = t.currentTarget,
                        r = k.rolls[i.rollIndex];
                    n.loop(r, function(n) {
                        n.backgroundColor = i.zobc
                    });
                    i.stage && i.stage.update()
                }
                var si, d, k, bt, hi, ot, ti, b, w, et, wt, rt, oi, ht, ai, yt;
                if (si = zob(n.LabelLetters, arguments, "label, align, valign, letterSpacing, letterSpacings, lineSpacing, lineSpacings, lineHeight, lineAlign, lineValign, cache, rtl, style, group, inherit", this)) return si;
                if (z_d("54.57"), this.group = y, d = v === !1 ? {} : n.getStyle("LabelLetters", this.group, p), zot(t) && (t = d.label != null ? d.label : new n.Label("Label Letters")), zot(i) && (i = d.align != null ? d.align : "center"), zot(r) && (r = d.valign != null ? d.valign : "center"), zot(u) && (u = d.letterSpacing != null ? d.letterSpacing : 5), zot(f) && (f = d.letterSpacings != null ? d.letterSpacings : null), zot(s) && (s = d.lineHeight != null ? d.lineHeight : null), zot(e) && (e = d.lineSpacing != null ? d.lineSpacing : 5), zot(o) && (o = d.lineSpacings != null ? d.lineSpacings : null), zot(a) && (a = d.rtl != null ? d.rtl : !1), zot(h) && (h = d.lineAlign != null ? d.lineAlign : a ? "right" : "left"), zot(c) && (c = d.lineValign != null ? d.lineValign : "bottom"), zot(l) && (l = d.cache != null ? d.cache : !1), this.zimContainer_constructor(null, null, null, null, !1), this.type = "LabelLetters", k = this, bt = k.letterData = [], t.type != "Label" ? (ot = ci(t), bt = ot.data, t = new n.Label(ot.text)) : (ot = ci(t.text), bt = ot.data, t.text = ot.text), k.text = ot.original, k._color = t.color, WW.DIR && WW.DIR == "rtl" || !WW.DIR && n.DIR == "rtl" ? h == "start" ? h = "right" : h == "end" && (h = "left") : h == "start" ? h = "left" : h == "end" && (h = "right"), k.numLetters = t.text.length, ti = !zot(f), f && !Array.isArray(f) && (f = null), f)
                    for (b = 0; b < k.numLetters; b++) zot(f[b]) && (f[b] = u);
                else
                    for (f = [], b = 0; b < k.numLetters; b++) f.push(u);
                if (k.letterSpacings = f, o && !Array.isArray(o) && (o = null), o)
                    for (b = 0; b < k.numLetters - 1; b++) zot(o[b]) && (o[b] = e);
                else
                    for (o = [], b = 0; b < k.numLetters - 1; b++) o.push(e);
                k.lineSpacings = o;
                k.labels = [];
                k.lines = [
                    []
                ];
                var kt = [],
                    ct = [],
                    ii = [0],
                    lt = 0,
                    nt = 0,
                    tt = 0,
                    pt = 0,
                    at = 0,
                    g = bt,
                    ri = !1,
                    ui = !1,
                    fi = !1,
                    st = !1,
                    ut = !1,
                    dt = !1,
                    gt = !1,
                    vt = !1,
                    ni = !1,
                    ei = !1,
                    ft = !1,
                    it = !1;
                for (k.rolls = [
                        []
                    ], b = 0; b < k.numLetters; b++) {
                    if (st = !1, g[b] && (g[b][1] && (g[b][1].indexOf("b") >= 0 && (ri = !1), g[b][1].indexOf("i") >= 0 && (ui = !1), g[b][1].indexOf("u") >= 0 && (fi = !1), n.loop(g[b][1], function(n) {
                            if (n.match(/^font/i)) {
                                ut = !1;
                                ft = !1;
                                it && k.rolls.push([]);
                                it = !1;
                                dt = !1;
                                vt = !1;
                                gt = !1;
                                return
                            }
                            if (n.match(/^a/i)) {
                                ni = !1;
                                ei = !1;
                                return
                            }
                        })), g[b][0] && (g[b][0].indexOf("b") >= 0 && (ri = !0), g[b][0].indexOf("i") >= 0 && (ui = !0), g[b][0].indexOf("u") >= 0 && (fi = !0), st = 0, n.loop(g[b][0], function(n) {
                            n == "br" && st++
                        }), n.loop(g[b][0], function(t) {
                            var i, r;
                            if (t.match(/^font/i)) {
                                i = t.match(/ color\s?=\s?(\S*)/i);
                                i && (ut = i[1], r = n.colors.indexOf(ut), r >= 0 && (ut = n.colorsHex[r]), ut = ut.replace(/'/g, ""));
                                i = t.match(/size\s?=\s?(\S*)/i);
                                i && (dt = i[1]);
                                i = t.match(/backgroundColor\s?=\s?(\S*)/i);
                                i && (ft = i[1], r = n.colors.indexOf(ft), r >= 0 && (ft = n.colorsHex[r]), ft = ft.replace(/'/g, ""));
                                i = t.match(/rollBackgroundColor\s?=\s?(\S*)/i);
                                i && (it = i[1], r = n.colors.indexOf(it), r >= 0 && (it = n.colorsHex[r]), it = it.replace(/'/g, ""));
                                i = t.match(/group\s?=\s?(\S*)/i);
                                i && (gt = i[1]);
                                i = t.match(/family\s?=\s?(.*)/i);
                                i && (vt = i[1], vt = vt.split(/\ssize\s?=|\scolor\s?=|\sgroup\s?=/i)[0]);
                                return
                            }
                            if (t.match(/^a/i)) {
                                i = t.match(/href\s?=\s?(\S*)/i);
                                i && (ni = i[1]);
                                i = t.match(/target\s?=\s?(\S*)/i);
                                i && (ei = i[1]);
                                return
                            }
                        }))), gt ? w = new n.Label({
                            text: t.text[b],
                            group: gt
                        }) : (w = t.clone(), w.text = t.text[b]), k.labels.push(w), ri && (w.bold = !0), ui && (w.italic = !0), ut && (w.color = ut), ft && (w.backgroundColor = ft), et = ti ? f[b] : zot(w.backgroundColor) ? f[b] : -.5, it) {
                        w.rollIndex = k.rolls.length - 1;
                        w.zrbc = it;
                        w.zobc = w.backgroundColor;
                        k.rolls[w.rollIndex].push(w);
                        w.expand(0);
                        w.on("mouseover", vi);
                        w.on("mouseout", li)
                    }
                    if (ni) {
                        w.expand(et, 0);
                        w.zurl = ni;
                        w.ztar = ei;
                        w.cur();
                        w.on("click", function(n) {
                            var t = n.currentTarget;
                            li(n);
                            t.ztar || (t.ztar = "_self");
                            zgo(t.zurl, t.ztar)
                        })
                    }
                    dt && (w.size = dt);
                    vt && (w.font = vt);
                    st && (lt += (zot(s) ? tt : s) + o[pt], ii.push(lt), ct.push(zot(s) ? tt : s), kt.push(nt), at = Math.max(at, nt));
                    st && (st > 1 && n.loop(st - 1, function() {
                        k.lines.push([]);
                        lt += (zot(s) ? tt : s) + o[pt];
                        ii.push(lt);
                        ct.push(zot(s) ? tt : s);
                        kt.push(0);
                        pt++
                    }), tt = 0, nt = 0, k.lines.push([]), pt++);
                    nt += w.width + et;
                    tt = Math.max(tt, w.height);
                    b == k.numLetters - 1 && (kt.push(nt), ct.push(tt), at = Math.max(at, nt));
                    k.lines[pt].push(w);
                    fi && (w.underline = new n.Line(w.width + et + 1, 1, w.color).center(w, this).mov(0, w.height / 2))
                }
                for (wt = 0, rt = 0; rt < k.lines.length; rt++)
                    for (oi = k.lines[rt], nt = kt[rt], tt = ct[rt], lt = ii[rt], ht = h == "left" ? 0 : h == "right" ? at - nt : (at - nt) / 2, ai = lt, b = 0; b < oi.length; b++) wt++, l && w.cache(), w = oi[b], w.regX = i == "left" ? 0 : i == "right" ? w.width : w.width / 2, w.regY = r == "top" ? 0 : r == "bottom" ? w.height : w.height / 2, yt = ai + (r == "top" ? 0 : r == "bottom" ? w.height : w.height / 2), c == "center" || c == "middle" ? yt += (ct[rt] - w.height) / 2 : c == "bottom" && (yt += ct[rt] - w.height), et = ti ? f[wt - 1] : zot(w.backgroundColor) ? f[wt - 1] : -.5, i == "left" ? (w.loc(ht, yt, this), ht = w.x + w.width + et) : i == "right" ? (w.loc(ht + w.width, yt, this), ht = w.x + et) : (w.loc(ht + w.width / 2, yt, this), ht = w.x + w.width / 2 + et);
                this.getBounds() || this.setBounds(0, 0, 0, 0);
                this.regX = this.getBounds().x;
                this.regY = this.getBounds().y;
                Object.defineProperty(this, "color", {
                    get: function() {
                        return this._color
                    },
                    set: function(n) {
                        this._color = n;
                        for (var t = 0; t < k.numChildren; t++) k.getChildAt(t).color = this._color;
                        k.stage && k.stage.update()
                    }
                });
                this.dispose = function() {
                    n.gD(this);
                    n.loop(k.labels, function(n) {
                        n.removeFrom();
                        n.dispose()
                    });
                    k.removeFrom()
                };
                n.styleTransforms(this, d);
                this.clone = function() {
                    return k.cloneProps(new n.LabelLetters(t, i, r, u, f, e, o, s, h, c, l, a, v, this.group, p))
                }
            }, n.extend(n.LabelLetters, n.Container, "clone", "zimContainer", !1), n.Emoji = function(t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b) {
                function ft() {
                    return arguments
                }
                var it, k, g, tt;
                if (it = zob(n.Emoji, arguments, "code, size, monochrome, italic, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backing, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, style, group, inherit", this)) return it;
                z_d("54.58");
                this.group = w;
                k = p === !1 ? {} : n.getStyle("Emoji", this.group, b);
                zot(t) && (t = k.code != null ? k.code : "🙂");
                zot(i) && (i = k.size != null ? k.size : 30);
                zot(r) && (r = k.monochrome != null ? k.monochrome : !1);
                zot(u) && (u = k.italic != null ? k.italic : !1);
                (zot(f) || f == "ignore") && (f = k.backgroundColor != null && f != "ignore" ? k.backgroundColor : null);
                zot(e) && (e = k.backgroundBorderColor != null && e != "ignore" ? k.backgroundBorderColor : null);
                zot(o) && (o = k.backgroundBorderWidth != null && o != "ignore" ? k.backgroundBorderWidth : null);
                (zot(c) || c == "ignore") && (c = k.padding != null && c != "ignore" ? k.padding : 10);
                zot(l) && (l = k.paddingHorizontal != null ? k.paddingHorizontal : c);
                zot(a) && (a = k.paddingVertical != null ? k.paddingVertical : c);
                zot(v) && (v = k.shiftHorizontal != null ? k.shiftHorizontal : 0);
                zot(y) && (y = k.shiftVertical != null ? k.shiftVertical : 0);
                g = ft(t, i);
                t = n.Pick.choose(t);
                i = n.Pick.choose(i);
                t.substring(0, 2) == "U+" && (t = n.unicodeToUTF(t));
                this.zimLabel_constructor(t, i, null, null, null, null, null, null, null, null, u, null, null, null, h, null, null, f, null, null, s, null, c, l, a, v, y);
                this.type = "Emoji";
                this.code = t;
                this.size = i;
                var d = this,
                    nt = this.getBounds(),
                    rt = 5,
                    ut = 3;
                this.bounds = this.setBounds(nt.x + ut, nt.y - rt + 1, nt.width - ut * 2, nt.height + rt);
                r && (this.saturation = -100);
                tt = r;
                Object.defineProperty(d, "monochrome", {
                    get: function() {
                        return tt
                    },
                    set: function(n) {
                        n != tt && (tt = n, n && (this.saturation = n ? -100 : 0))
                    }
                });
                this.cache = function(n, t, i, r) {
                    return zot(n) ? (t = this.getBounds(), this.zimLabel_cache(t.x - 20, t.y - 20, t.width + 40, t.height + 40)) : this.zimLabel_cache(n, t, i, r), d.z_bc = d.cacheCanvas, this
                };
                n.styleTransforms(this, k);
                this.clone = function(i) {
                    return d.cloneProps(new n.Emoji(i || !n.isPick(g[0]) ? t : g[0], i || !n.isPick(g[1]) ? d.size : g[1], r, u, f, e, o, s, h, c, l, a, v, y, p, d.group, b))
                }
            }, n.extend(n.Emoji, n.Label, ["clone", "cache"], "zimLabel", !1), n.Button = function(i, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, dt, gt, ni, ti, ii, ri, ui, fi, ei, oi, si, hi, ci, li, ai, vi, yi, pi, wi, bi, ki, di, gi, nr, tr, ir, rr, ur, fr, er, or) {
                function cf() {
                    return arguments
                }

                function nf(t, r) {
                    var s, f;
                    return sr[t] = new n.Container(i, u, null, null, !1).centerReg(null, null, !1), rt != -1 && ut > 0 && (s = new n.Rectangle(i - 2, u - 2, "#666", null, null, tt, null, null, null, !1).center(sr[t]), s.shadow = new createjs.Shadow(rt, 3, 3, ut)), f = sr[t].mask = new n.Rectangle(i, u, t.indexOf("roll") >= 0 ? o : e, null, null, tt, null, null, null, !1).addTo(sr[t]), r.centerReg(f), r.setMask(f.shape), sr[t].pattern = r, sr[t]
                }

                function uf() {
                    cu = new createjs.Shape;
                    cu.graphics.f("#000").r(-at, -at, i + at * 2, u + at * 2);
                    sr.hitArea = rf = cu
                }

                function ff() {
                    sr.toggled ? (zot(bt) || (sr.label.text = bt === !0 ? ru : bt), zot(ni) || (sr.label.colorOnly = ar = ni), zot(ti) || (sr.label.rollColor = ti), sr.rolled ? (sr.rollToggleBacking ? cr("rollToggleBacking") : sr.toggleBacking && cr("toggleBacking"), sr.rollToggleIcon ? cr("rollToggleIcon") : sr.toggleIcon && cr("toggleIcon"), zot(w) && zot(sr.rollToggleBacking) && (sr.backing.color = dt)) : (sr.toggleBacking && cr("toggleBacking"), sr.toggleIcon && cr("toggleIcon"), zot(w) && (sr.backing.color = kt))) : (sr.label.colorOnly = ar = lu, sr.label.rollColor = au, sr.rolled && sr.label.showRollColor(!0), sr.label.text = ru, vu());
                    sr.stage && sr.stage.update()
                }

                function vu() {
                    sr.pressed ? (zot(w) && sr.backing && !sr.downBacking && (sr.backing.color = s), sr.downBacking ? cr("downBacking") : sr.rollBacking ? cr("rollBacking") : sr.backing && cr("backing"), sr.downIcon ? cr("downIcon") : sr.rollIcon ? cr("rollIcon") : sr.icon ? cr("icon") : cr("icon", null)) : sr.rolled ? (zot(w) && sr.backing && !sr.rollBacking && (sr.backing.color = o), sr.rollBacking ? cr("rollBacking") : sr.backing && cr("backing"), sr.rollIcon ? cr("rollIcon") : sr.icon ? cr("icon") : cr("icon", null)) : (zot(w) && sr.backing && (sr.backing.color = e), sr.backing && cr("backing"), sr.icon ? cr("icon") : cr("icon"))
                }

                function sf() {
                    zot(ci) && zot(ki) && zot(di) || sr.waiting || (fu = !0, zot(ur) && (ur = !0), rr && (yu = sr.stage.on("stagemousedown", function(t) {
                        sr.hitTestPoint(t.stageX / n.scaX, t.stageY / n.scaY) || sr.clearWait()
                    }, null, !0)), setTimeout(function() {
                        sr.waiting = !0
                    }, 50), ef = f.text, zot(pi) || (sr.label.colorOnly = ar = pi), zot(wi) || (sr.label.rollColor = wi), of = sr.enabled, !ur && sr.enabled && (sr.enabled = !1), zot(ci) || (sr.label.text = ci), sr.rolled ? (zot(w) && !sr.rollWaitBacking && (sr.backing.color = vi), sr.rollWaitBacking ? cr("rollWaitBacking") : sr.waitBacking && cr("waitBacking"), sr.rollWaitIcon ? cr("rollWaitIcon") : sr.waitIcon && cr("waitIcon")) : (zot(w) && !sr.waitBacking && (sr.backing.color = ai), sr.waitBacking && cr("waitBacking"), sr.waitIcon && cr("waitIcon")), zot(li) && (li = gu == "s" ? 5 : 5e3), gr && gr.clear(), gr = n.timeout(li, function() {
                        sr.enabled || (sr.enabled = of );
                        sr.clearWait();
                        sr.dispatchEvent("waited")
                    }), sr.stage && sr.stage.update())
                }

                function cr(n, t) {
                    var i, r, u, f, e;
                    if (n.indexOf("con") >= 0) {
                        for (i = 0; i < dr.length; i++) r = dr[i], u = sr[r], sr.removeChild(u);
                        sr[n] && sr.addChildAt(sr[n], 1)
                    } else {
                        if (!sr[n] && !t) return;
                        for (i = 0; i < kr.length; i++) f = kr[i], e = sr[f], sr.removeChild(e);
                        sr[n] && sr.addChildAt(sr[n], 0)
                    }
                }

                function ou() {
                    sr.rolled = !0;
                    eu = !0;
                    fu ? (sr.pressed && sr.downWaitBacking ? cr("downWaitBacking") : sr.pressed && sr.downBacking ? cr("downBacking") : sr.rollWaitBacking ? cr("rollWaitBacking") : sr.waitBacking ? cr("waitBacking") : sr.rollBacking ? cr("rollBacking") : cr("backing"), sr.pressed && sr.downWaitIcon ? cr("downWaitIcon") : sr.rollWaitIcon ? cr("rollWaitIcon") : sr.waitIcon ? cr("waitIcon") : sr.rollIcon ? cr("rollIcon") : cr("icon", !0)) : wr && sr.toggled ? (sr.pressed && sr.downToggleBacking ? cr("downToggleBacking") : sr.pressed && sr.downBacking ? cr("downBacking") : sr.rollToggleBacking ? cr("rollToggleBacking") : sr.toggleBacking ? cr("toggleBacking") : sr.rollBacking ? cr("rollBacking") : cr("backing"), sr.pressed && sr.downToggleIcon ? cr("downToggleIcon") : sr.rollToggleIcon ? cr("rollToggleIcon") : sr.toggleIcon ? cr("toggleIcon") : sr.rollIcon ? cr("rollIcon") : cr("icon", !0)) : (sr.pressed && sr.downBacking ? cr("downBacking") : sr.rollBacking ? cr("rollBacking") : cr("backing"), sr.pressed && sr.downIcon ? cr("downIcon") : sr.rollIcon ? cr("rollIcon") : cr("icon", !0));
                    sr.pressed ? zot(w) && sr.backing ? sr.backing.color = s : w && !zot(w.mask) && sr.backing && (sr.backing.mask.color = s) : zot(w) && sr.backing ? sr.backing.color = o : w && !zot(w.mask) && sr.backing && (sr.backing.mask.color = o);
                    sr.border && (sr.border.borderColor = sr.pressed ? p : y);
                    sr.pressed ? sr.label.colorOnly = l : sr.label.showRollColor ? sr.label.showRollColor() : sr.label.colorOnly = ar;
                    sr.stage && sr.stage.update()
                }

                function pu() {
                    eu = !1;
                    sr.rollPersist ? uu || nu() : nu()
                }

                function nu() {
                    sr.rolled = !1;
                    fu || sr.waiting ? (zot(w) && sr.backing && zot(sr.waitBacking) && (sr.backing.color = zot(ai) ? e : ai), sr.waitBacking ? cr("waitBacking") : sr.backing && cr("backing"), sr.waitIcon ? cr("waitIcon") : sr.icon ? cr("icon") : cr("icon", null)) : sr.toggled && wr ? (zot(w) && sr.backing && zot(sr.toggleBacking) && (sr.backing.color = kt), sr.toggleBacking ? cr("toggleBacking") : sr.backing && cr("backing"), sr.toggleIcon ? cr("toggleIcon") : sr.icon ? cr("icon") : cr("icon", null)) : (zot(w) && sr.backing ? sr.backing.color = e : w && !zot(w.mask) && sr.backing && (sr.backing.mask.color = e), sr.backing && cr("backing"), sr.icon ? cr("icon") : cr("icon", null));
                    sr.border && (sr.border.borderColor = a);
                    sr.label.colorOnly = ar;
                    sr.label.showRollColor && sr.label.showRollColor(!1);
                    sr.stage && sr.stage.update()
                }

                function hf(n, t) {
                    return zot(n) ? sr : (sr.contains(sr[n]) && (sr.removeChild(sr[n]), t && sr.addChildAt(t, n.indexOf("con") >= 0 ? sr.numChildren - 1 : 0), sr.stage && sr.stage.update()), t ? (zot(w) && n == "backing" && (w = t), t.type == "Pattern" && (t = nf(n, t)), sr[n] = t, sr[n].x = i / 2, sr[n].y = u / 2) : sr[n] = null, vu(), sr)
                }
                var wu, hr, lr, ku, du, wr, sr, gu, kr, hu, vr, yr, dr, tf, tu, iu, br, rf, cu, ar, uu, eu, pr;
                if (wu = zob(n.Button, arguments, "width, height, label, backgroundColor, rollBackgroundColor, downBackgroundColor, color, rollColor, downColor, borderColor, borderWidth, rollBorderColor, downBorderColor, backing, rollBacking, downBacking, icon, rollIcon, downIcon, corner, dashed, shadowColor, shadowBlur, gradient, gloss, align, valign, indent, indentHorizontal, indentVertical, hitPadding, autoPadding, autoPaddingH, autoPaddingV, rollPersist, toggle, toggleBackgroundColor, rollToggleBackgroundColor, downToggleBackgroundColor, toggleColor, rollToggleColor, downToggleColor, toggleBacking, rollToggleBacking, downToggleBacking, toggleIcon, rollToggleIcon, downToggleIcon, toggleEvent, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, downWaitBackgroundColor, waitColor, rollWaitColor, downWaitColor, waitBacking, rollWaitBacking, downWaitBacking, waitIcon, rollWaitIcon, downWaitIcon, waitModal, waitEnabled, style, group, inherit", this)) return wu;
                z_d("55");
                this.group = er;
                hr = fr === !1 ? {} : n.getStyle("Button", er, or);
                zot(i) && (i = hr.width != null ? hr.width : 200);
                zot(u) && (u = hr.height != null ? hr.height : 60);
                zot(WW.M) && (WW.M = n.mobile());
                var su = h,
                    bu = c,
                    yf = l;
                for (zot(h) && (h = hr.color != null ? hr.color : "white"), zot(c) && (c = hr.rollColor != null ? hr.rollColor : "white"), zot(vt) && (vt = hr.autoPadding != null ? hr.autoPadding : 20), zot(yt) && (yt = hr.autoPaddingH != null ? hr.autoPaddingH : vt), zot(pt) && (pt = hr.autoPaddingV != null ? hr.autoPaddingV : vt), zot(ot) && (ot = hr.align != null ? hr.align : "center"), zot(st) && (st = hr.valign != null ? hr.valign : "center"), zot(f) && (f = zot(d) ? hr.label != null ? hr.label : "PRESS" : ""), typeof f == "string" || typeof f == "number" ? f = new n.Label({
                        text: f,
                        size: hr.size != null ? hr.size : 36,
                        font: hr.font != null ? hr.font : "arial",
                        color: hr.color != null && su == null ? hr.color : h,
                        rollColor: hr.rollColor && bu == null != null ? hr.rollColor : c,
                        align: ot,
                        valign: st,
                        rollPersist: hr.rollPersist != null ? hr.rollPersist : !1,
                        backing: "ignore",
                        shadowColor: "ignore",
                        shadowBlur: "ignore",
                        padding: "ignore",
                        backgroundColor: "ignore",
                        shiftVertical: hr.shiftVertical != null ? hr.shiftVertical : 0,
                        shiftHorizontal: hr.shiftHorizontal != null ? hr.shiftHorizontal : 0,
                        style: !1,
                        group: this.group
                    }) : (zot(su) || (f.color = su), h = f.color, (zot(f.rollColor) || !zot(bu)) && (f.rollColor = c), c = f.rollColor), zot(l) && (l = hr.downColor != null ? hr.downColor : c), i == "auto" && (i = f.width + yt * 2), u == "auto" && (u = f.height + pt * 2), this.zimContainer_constructor(i, u, null, null, !1), this.type = "Button", zot(e) && (e = hr.backgroundColor != null ? hr.backgroundColor : n.purple), zot(o) && (o = hr.rollBackgroundColor != null ? hr.rollBackgroundColor : n.pink), zot(s) && (s = hr.downBackgroundColor != null ? hr.downBackgroundColor : o), lr = cf(e, o, s, h, c, l), e = zik(e), o = zik(o), s = zik(s), h = zik(h), c = zik(c), l = zik(l), ku = a, du = v, zot(a) && (a = hr.borderColor != null ? hr.borderColor : null), zot(v) && (v = hr.borderWidth != null ? hr.borderWidth : null), a < 0 || v < 0 ? a = v = null : a != null && v == null && (v = 1), zot(y) && (y = hr.rollBorderColor != null ? hr.rollBorderColor : a), zot(p) && (p = hr.downBorderColor != null ? hr.downBorderColor : y), zot(tt) && (tt = hr.corner != null ? hr.corner : 10), zot(rt) && (rt = hr.shadowColor != null ? hr.shadowColor : "rgba(0,0,0,.3)"), zot(ut) && (ut = hr.shadowBlur != null ? hr.shadowBlur : 14), zot(at) && (at = hr.hitPadding != null ? hr.hitPadding : 0), zot(ht) && (ht = hr.indent != null ? hr.indent : 10), zot(ct) && (ct = hr.indentHorizontal != null ? hr.indentHorizontal : ht), zot(lt) && (lt = hr.indentVertical != null ? hr.indentVertical : ht), zot(ft) && (ft = hr.gradient != null ? hr.gradient : 0), zot(et) && (et = hr.gloss != null ? hr.gloss : 0), wr = (!zot(bt) || !zot(ri) || !zot(ui) || !zot(fi) || !zot(ei) || !zot(oi) || !zot(si)) && zot(ci) && zot(ki) && zot(di), wr && zot(hi) && (hi = WW.M ? "mousedown" : "click"), zot(wt) && (wt = hr.rollPersist != null ? hr.rollPersist : !1), this.rollPersist = wt, zot(it) && (it = hr.dashed != null ? hr.dashed : !1), zot(bt) || bt.type != "Label" || zon && zogy("Button() - do not pass Label to toggle parameter - just pass a String"), zot(kt) && (kt = hr.toggleBackgroundColor != null ? hr.toggleBackgroundColor : e), zot(dt) && (dt = hr.rollToggleBackgroundColor != null ? hr.rollToggleBackgroundColor : o), zot(gt) && (gt = hr.downToggleBackgroundColor != null ? hr.downToggleBackgroundColor : dt), zot(ni) && (ni = hr.toggleColor != null ? hr.toggleColor : f.color), zot(ti) && (ti = hr.rollToggleColor != null ? hr.rollToggleColor : f.rollColor), zot(ii) && (ii = hr.downToggleColor != null ? hr.downToggleColor : f.rollToggleColor), zot(ai) && (ai = hr.waitBackgroundColor != null ? hr.waitBackgroundColor : e), zot(vi) && (vi = hr.rollWaitBackgroundColor != null ? hr.rollWaitBackgroundColor : o), zot(yi) && (yi = hr.downWaitBackgroundColor != null ? hr.downWaitBackgroundColor : o), zot(pi) && (pi = hr.waitColor != null ? hr.waitColor : f.color), zot(wi) && (wi = hr.rollWaitColor != null ? hr.rollWaitColor : f.rollColor), zot(bi) && (bi = hr.downWaitColor != null ? hr.downWaitColor : wi), sr = this, this.mouseChildren = !1, this.cursor = "pointer", sr.focus = !1, sr.rolled = !1, gu = t(li), zot(w) && (w = hr.backing != null ? hr.backing.clone() : null), sr.backing = zot(w) ? new n.Rectangle(i, u, e, null, null, tt, it, null, null, !1).centerReg(null, null, !1) : w, sr.rollBacking = zot(b) ? hr.rollBacking != null ? hr.rollBacking.clone() : null : b, sr.downBacking = zot(k) ? hr.downBacking != null ? hr.downBacking.clone() : null : k, sr.waitBacking = zot(ki) ? hr.waitBacking != null ? hr.waitBacking.clone() : null : ki, sr.rollWaitBacking = zot(di) ? hr.rollWaitBacking != null ? hr.rollWaitBacking.clone() : null : di, sr.downWaitBacking = zot(gi) ? hr.downWaitBacking != null ? hr.downWaitBacking.clone() : null : gi, sr.toggleBacking = zot(ri) ? hr.toggleBacking != null ? hr.toggleBacking.clone() : null : ri, sr.rollToggleBacking = zot(ui) ? hr.rollToggleBacking != null ? hr.rollToggleBacking.clone() : null : ui, sr.downToggleBacking = zot(fi) ? hr.downToggleBacking != null ? hr.downToggleBacking.clone() : null : fi, kr = ["backing", "rollBacking", "downBacking", "toggleBacking", "rollToggleBacking", "downToggleBacking", "waitBacking", "rollWaitBacking", "downWaitBacking"], yr = 0; yr < kr.length; yr++) hu = kr[yr], vr = sr[hu], vr && (vr.type == "Pattern" ? vr = nf(hu, vr) : rt != -1 && ut > 0 && (vr.shadow = new createjs.Shadow(rt, 3, 3, ut)), vr.x = i / 2, vr.y = u / 2);
                for (sr.addChild(sr.backing), v && (sr.border = new n.Rectangle(i, u, "rgba(0,0,0,0)", a, v, tt, it, null, null, !1), sr.addChild(sr.border)), sr.icon = zot(d) ? hr.icon != null ? hr.icon.clone() : null : d, sr.rollIcon = zot(g) ? hr.rollIcon != null ? hr.rollIcon.clone() : null : g, sr.downIcon = zot(nt) ? hr.downIcon != null ? hr.downIcon.clone() : null : nt, sr.waitIcon = zot(nr) ? hr.waitIcon != null ? hr.waitIcon.clone() : null : nr, sr.rollWaitIcon = zot(tr) ? hr.rollWaitIcon != null ? hr.rollWaitIcon.clone() : null : tr, sr.downWaitIcon = zot(ir) ? hr.downWaitIcon != null ? hr.downWaitIcon.clone() : null : ir, sr.toggleIcon = zot(ei) ? hr.toggleIcon != null ? hr.toggleIcon.clone() : null : ei, sr.rollToggleIcon = zot(oi) ? hr.rollToggleIcon != null ? hr.rollToggleIcon.clone() : null : oi, sr.downToggleIcon = zot(si) ? hr.downToggleIcon != null ? hr.downToggleIcon.clone() : null : si, dr = ["icon", "rollIcon", "downIcon", "toggleIcon", "rollToggleIcon", "downToggleIcon", "waitIcon", "rollWaitIcon", "downWaitIcon"], yr = 0; yr < dr.length; yr++) tf = dr[yr], tu = sr[tf], tu && (tu.x = i / 2, tu.y = u / 2);
                if (sr.icon && sr.addChild(sr.icon), Array.isArray(tt) || (tt = [tt, tt, tt, tt]), ft > 0 && (iu = new createjs.Shape, iu.graphics.lf(["rgba(255,255,255," + ft + ")", "rgba(0,0,0," + ft + ")"], [0, 1], 0, 0, 0, u - v), iu.graphics.rc(v / 2, v / 2, i - v, u - v, tt[0], tt[1], tt[2], tt[3]), this.addChild(iu)), et > 0 && (br = new createjs.Shape, br.graphics.f("rgba(255,255,255," + et + ")"), br.graphics.rc(v / 2, v / 2, i - v, (u - v) / 2, tt[0], tt[1], 0, 0), br.graphics.f("rgba(0,0,0," + et + ")"), br.graphics.rc(v / 2, u / 2, i - v, (u - v) / 2, 0, 0, tt[2], tt[3]), this.addChild(br)), at > 0 && uf(), this.addChild(f), f.center(this), f.y += 1, this.label = f, n.pos(f, ot == "left" || ot == "right" ? ct : null, st == "top" || st == "bottom" ? lt : null, ot == "right", st == "bottom"), ar = f.color, this.toggled = !1, wr) {
                    var ru = f.text,
                        lu = f.color,
                        au = f.rollColor;
                    this.on(hi, function() {
                        sr.toggled = !sr.toggled;
                        ff()
                    })
                }
                this.toggle = function(n) {
                    return wr ? (sr.toggled = zot(n) ? !sr.toggled : n, ff(), sr) : (zon && zogy("Button() - can't toggle with wait parameters provided"), sr)
                };
                uu = !1;
                sr.waiting = !1;
                var fu = !1,
                    gr, ef, lf = sr.label.color,
                    af = sr.label.rollColor,
                    of , yu, vf = this.on("mousedown", function() {
                        uu = !0;
                        sf()
                    });
                this.wait = sf;
                this.clearWait = function() {
                    return gr ? (yu && sr.stage.off("stagemousedown", yu), gr.clear(), sr.label.text = ef, vu(), sr.label.colorOnly = ar = lf, sr.label.rollColor = af, setTimeout(function() {
                        sr.waiting = !1
                    }, 55), fu = !1, sr.stage && sr.stage.update(), sr) : sr
                };
                this.removeWait = function() {
                    return sr.clearWait(), ci = null, sr.waitBacking = null, sr.rollWaitBacking = null, sr.off("mousedown", vf), sr
                };
                eu = !1;
                this.on("mouseover", function() {
                    sr.stage && sr.stage.frame.leftMouseDown && !pr || ou()
                });
                pr = !1;
                this.on("mousedown", function() {
                    sr.pressed = pr = !0;
                    ou();
                    sr.rolled
                });
                this.on("pressup", function() {
                    sr.pressed = pr = uu = !1;
                    eu ? ou() : sr.rollPersist && nu();
                    WW.M && pu()
                });
                this.on("pressmove", function() {
                    var n = sr.stage ? sr.stage.frame : WW.zdf,
                        t = sr.hitTestPoint(n.mouseX, n.mouseY);
                    pr && !t ? (pu(), pr = !1) : !pr && t && (ou(), pr = !0)
                });
                this.on("mouseout", pu);
                sr.removeRoll = nu;
                sr.rollBacking && sr.rollBacking.removeFrom();
                Object.defineProperty(sr, "text", {
                    get: function() {
                        return f.text == " " ? "" : f.text
                    },
                    set: function(t) {
                        f.text = t;
                        ru && (ru = t);
                        f.center(this);
                        f.y += 1;
                        n.pos(f, ot == "left" || ot == "right" ? ct : null, st == "top" || st == "bottom" ? lt : null, ot == "right", st == "bottom")
                    }
                });
                Object.defineProperty(sr, "color", {
                    get: function() {
                        return h
                    },
                    set: function(t) {
                        h = t;
                        lu && (lu = h);
                        sr.label && !zot(sr.label.color) && (sr.label.color = ar = h);
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && sr.stage && sr.stage.update()
                    }
                });
                Object.defineProperty(sr, "rollColor", {
                    get: function() {
                        return c
                    },
                    set: function(n) {
                        c = n;
                        au && (au = c);
                        sr.label && (sr.label.rollColor = c)
                    }
                });
                Object.defineProperty(sr, "downColor", {
                    get: function() {
                        return l
                    },
                    set: function(n) {
                        l = n;
                        originalDownColor && (originalDownColor = l);
                        sr.label && (sr.label.downColor = l)
                    }
                });
                Object.defineProperty(sr, "backgroundColor", {
                    get: function() {
                        return e
                    },
                    set: function(t) {
                        e = t;
                        sr.backing.color ? sr.backing.color = e : sr.backing.mask && (sr.backing.mask.color = e);
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && sr.stage && sr.stage.update()
                    }
                });
                Object.defineProperty(sr, "rollBackgroundColor", {
                    get: function() {
                        return o
                    },
                    set: function(n) {
                        o = n;
                        sr.rollBacking && sr.rollBacking.color ? sr.rollBacking.color = o : sr.rollBacking && sr.rollBacking.mask && (sr.rollBacking.mask.color = o)
                    }
                });
                Object.defineProperty(sr, "downBackgroundColor", {
                    get: function() {
                        return s
                    },
                    set: function(n) {
                        s = n;
                        sr.downBacking && sr.downBacking.color ? sr.downBacking.color = s : sr.downBacking && sr.downBacking.mask && (sr.downBacking.mask.color = s)
                    }
                });
                Object.defineProperty(sr, "borderColor", {
                    get: function() {
                        return a
                    },
                    set: function(n) {
                        a = n;
                        sr.rolled || (sr.backing && sr.backing.borderColor && (sr.backing.borderColor = n), sr.border && (sr.border.borderColor = n))
                    }
                });
                Object.defineProperty(sr, "rollBorderColor", {
                    get: function() {
                        return y
                    },
                    set: function(n) {
                        y = n;
                        sr.rolled && (sr.backing && sr.backing.borderColor && (sr.backing.borderColor = n), sr.border && (sr.border.borderColor = n))
                    }
                });
                Object.defineProperty(sr, "hitPadding", {
                    get: function() {
                        return at
                    },
                    set: function(n) {
                        at = n;
                        at == 0 ? rf && (this.hitArea = null) : uf()
                    }
                });
                this._enabled = !0;
                this.startMouseChildren = this.mouseChildren;
                Object.defineProperty(sr, "enabled", {
                    get: function() {
                        return sr._enabled
                    },
                    set: function(t) {
                        sr._enabled && (sr.startMouseChildren = sr.mouseChildren);
                        t ? (r(sr, t), sr.mouseChildren = sr.startMouseChildren) : (nu(), r(sr, t));
                        var i = f.color;
                        f.color = ar = i;
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && sr.stage && sr.stage.update()
                    }
                });
                this.setBacking = function(n, t) {
                    hf(n, t)
                };
                this.setIcon = function(n, t) {
                    hf(n, t)
                };
                fr !== !1 && n.styleTransforms(this, hr);
                this.clone = function(t) {
                    var r = new n.Button(i, u, f.clone(), t || !n.isPick(lr[0]) ? e : lr[0], t || !n.isPick(lr[1]) ? o : lr[1], t || !n.isPick(lr[2]) ? s : lr[2], t || !n.isPick(lr[3]) ? h : lr[3], t || !n.isPick(lr[4]) ? c : lr[4], t || !n.isPick(lr[5]) ? l : lr[5], ku, du, y, p, zot(w) ? null : sr.backing.clone(), zot(b) ? null : sr.rollBacking.clone(), zot(k) ? null : sr.downBacking.clone(), zot(d) ? null : d.clone(), zot(g) ? null : g.clone(), zot(nt) ? null : nt.clone(), tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, dt, gt, ni, ti, ii, zot(ri) ? null : ri.clone(), zot(ui) ? null : ui.clone(), zot(fi) ? null : fi.clone(), zot(ei) ? null : ei.clone(), zot(oi) ? null : oi.clone(), zot(si) ? null : si.clone(), hi, ci, li, ai, vi, yi, pi, wi, bi, zot(ki) ? null : ki.clone(), zot(di) ? null : di.clone(), zot(gi) ? null : gi.clone(), zot(nr) ? null : nr.clone(), zot(tr) ? null : tr.clone(), zot(ir) ? null : ir.clone(), rr, ur, fr, this.group, or);
                    return sr.cloneProps(r)
                };
                this.doDispose = function(n, t, i) {
                    return sr.icon && sr.icon.dispose(), sr.rollIcon && sr.rollIcon.dispose(), sr.downIcon && sr.downIcon.dispose(), sr.waitIcon && sr.waitIcon.dispose(), sr.rollWaitIcon && sr.rollWaitIcon.dispose(), sr.downWaitIcon && sr.downWaitIcon.dispose(), sr.toggleIcon && sr.toggleIcon.dispose(), sr.rollToggleIcon && sr.rollToggleIcon.dispose(), sr.downToggleIcon && sr.downToggleIcon.dispose(), sr.icon = sr.rollIcon = sr.downIcon = sr.waitIcon = sr.rollWaitIcon = sr.downWaitIcon = sr.toggleIcon = sr.rollToggleIcon = sr.downToggleIcon = null, i || this.zimContainer_dispose(!0), !0
                }
            }, n.extend(n.Button, n.Container, ["clone", "dispose"], "zimContainer", !1), n.Button.prototype.dispose = function(n) {
                return this.doDispose(null, null, n)
            }, n.CheckBox = function(t, i, u, f, e, o, s, h, c, l, a, v, y, p, w, b) {
                function at() {
                    return arguments
                }

                function lt() {
                    nt = !nt;
                    d.setChecked(nt);
                    d.dispatchEvent("change")
                }
                var st, k, d, rt, nt, ht, ut, ft, et, ct, g, tt, it, ot;
                if (st = zob(n.CheckBox, arguments, "size, label, startChecked, color, backgroundColor, borderColor, borderWidth, corner, margin, indicatorType, indicatorColor, tap, rtl, style, group, inherit", this)) return st;
                if (z_d("56"), this.zimContainer_constructor(null, null, null, null, !1), this.type = "CheckBox", this.group = w, k = p === !1 ? {} : n.getStyle(this.type, this.group, b), zot(t) && (t = k.size != null ? k.size : 60), zot(i) && (i = k.label != null ? k.label : null), zot(u) && (u = k.startChecked != null ? k.startChecked : !1), zot(f) && (f = k.color != null ? k.color : "#111"), zot(e) && (e = k.backgroundColor != null ? k.backgroundColor : "rgba(255,255,255,.8)"), zot(o) && (o = k.borderColor != null ? k.borderColor : "#111"), zot(s) && (s = k.borderWidth != null ? k.borderWidth : t / 10), o < 0 || s < 0 ? o = s = null : o != null && s == null && (s = t / 10), zot(h) && (h = k.corner != null ? k.corner : 0), zot(c) && (c = k.margin != null ? k.margin : t / 5), l != "box" && l != "square" && l != "x" && (l = k.indicatorType != null ? k.indicatorType : "check"), zot(a) && (a = k.indicatorColor != null ? k.indicatorColor : s > 0 ? o : "black"), this.setBounds(-c, -c, t + c * 2, t + c * 2), zot(v) && (v = k.tap != null ? k.tap : !1), zot(y) && (y = k.rtl != null ? k.rtl : WW.DIR == "rtl"), d = this, this.cursor = "pointer", rt = at(i, u), i = n.Pick.choose(i), u = n.Pick.choose(u), nt = u, (typeof i == "string" || typeof i == "number") && (i = new n.Label({
                        text: i,
                        size: t * 5 / 6,
                        color: f,
                        valign: "center",
                        align: y ? "right" : "left",
                        backing: "ignore",
                        shadowColor: "ignore",
                        shadowBlur: "ignore",
                        padding: "ignore",
                        backgroundColor: "ignore",
                        style: p,
                        group: this.group
                    })), ht = this.box = new n.Rectangle(t, t, e, null, null, h), ut = this.box2 = new n.Rectangle(t * 5 / 7, t * 5 / 7, "rgba(0,0,0,0)", o, s, h), ut.x = t / 7, ut.y = t / 7, this.addChild(ht, ut), ft = t, i && (i.center(d), this.label = i, y ? (i.x = -c, this.setBounds(-i.width - c * 2, -c, t + c * 3 + i.getBounds().width, Math.max(t + c * 2, i.getBounds().height)), ft = t + i.width + c, this.regX = t) : (i.x = d.getBounds().width, this.setBounds(-c, -c, t + c * 4 + i.getBounds().width, Math.max(t + c * 2, i.getBounds().height)), ft = i.x + i.width)), et = new n.Shape({
                        style: !1
                    }), ct = et.graphics, ct.f("rgba(0,0,0,.01)").r(this.getBounds().x, this.getBounds().y, ft + c * 2, this.getBounds().height), this.hitArea = et, g = new n.Shape({
                        style: !1
                    }), tt = g.graphics, l == "check" ? tt.f(a).p("AnQAdICBiaIEEDZIF8nfICfB4In/KPg") : l == "box" || l == "square" ? tt.f(a).dr(-35, -35, 70, 70) : tt.f(a).p("AmJEVIEUkTIkXkWIB4h5IEWEYIETkTIB4B3IkTESIEQERIh4B4IkRkRIkSEVg"), it = 95, g.setBounds(-it / 2, -it / 2, it, it), ot = t / (it + 66), g.scaleX = g.scaleY = ot, g.alpha = .9, g.x = t / 2, g.y = t / 2, nt && this.addChild(g), v) this.tap(lt);
                else this.on((zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click", lt);
                Object.defineProperty(d, "checked", {
                    get: function() {
                        return nt
                    },
                    set: function(n) {
                        d.setChecked(n)
                    }
                });
                this.toggle = function(n) {
                    zot(n) && (n = !nt);
                    d.setChecked(n)
                };
                Object.defineProperty(d, "toggled", {
                    get: function() {
                        return nt
                    },
                    set: function(n) {
                        d.setChecked(n)
                    }
                });
                Object.defineProperty(d, "text", {
                    get: function() {
                        return i ? i.text : null
                    },
                    set: function(t) {
                        i && (i.text = t, !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && d.stage && d.stage.update())
                    }
                });
                Object.defineProperty(g, "indicatorColor", {
                    get: function() {
                        return a
                    },
                    set: function(i) {
                        nt && d.removeChild(g);
                        g = new createjs.Shape;
                        tt = g.graphics;
                        a = i;
                        tt.f(a).p("AnQAdICBiaIEEDZIF8nfICfB4In/KPg");
                        g.scaleX = g.scaleY = ot;
                        g.alpha = .9;
                        g.x = t / 2;
                        g.y = t / 2;
                        nt && d.addChild(g);
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && d.stage && d.stage.update()
                    }
                });
                Object.defineProperty(d, "indicator", {
                    get: function() {
                        return g
                    },
                    set: function() {
                        zogy("ZIM CheckBox - check is read only")
                    }
                });
                this._enabled = !0;
                Object.defineProperty(d, "enabled", {
                    get: function() {
                        return d._enabled
                    },
                    set: function(n) {
                        r(d, n)
                    }
                });
                this.setChecked = function(t) {
                    return zot(t) && (t = !0), nt = t, nt ? d.addChild(g) : d.removeChild(g), !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && d.stage && d.stage.update(), d
                };
                p !== !1 && n.styleTransforms(this, k);
                this.clone = function(r) {
                    return d.cloneProps(new n.CheckBox(t, r || !n.isPick(rt[0]) ? i ? i.clone() : null : rt[0], r || !n.isPick(rt[1]) ? u : rt[1], f, e, o, s, h, c, l, a, v, y, p, this.group, b))
                }
            }, n.extend(n.CheckBox, n.Container, "clone", "zimContainer", !1), n.RadioButtons = function(t, i, u, f, e, o, s, h, c, l, a, v, y, p, w, b) {
                function ot(n) {
                    var t = nt.getChildIndex(n.target);
                    l && d.selectedIndex == t || (d.setSelected(t), d.dispatchEvent("change"))
                }

                function st() {
                    for (var r, c = !1, o, s, l, e = i.length - 1; e >= 0; e--) r = i[e], r.selected && r.selected === !0 && (c ? r.selected = "false" : (c = !0, d.id = r.id));
                    for (nt.removeAllChildren(), d.buttons = [], s = 0, e = 0; e < i.length; e++) r = i[e], (typeof r == "string" || typeof r == "number") && (l = {
                        selected: !1,
                        label: new n.Label({
                            text: r,
                            size: t * 5 / 6,
                            color: k.color != null ? k.color : f,
                            valign: "center",
                            backing: "ignore",
                            shadowColor: "ignore",
                            shadowBlur: "ignore",
                            padding: "ignore",
                            backgroundColor: "ignore",
                            style: p,
                            group: d.group
                        })
                    }, r = l), (r.label && typeof r.label == "string" || typeof r.label == "number") && (r.label = new n.Label({
                        text: r.label,
                        size: k.size != null ? k.size : t * 5 / 6,
                        color: k.color != null ? k.color : f,
                        valign: "center",
                        style: p
                    })), d.labels.push(r.label), r.index = e, i[e] = r, o = ht(r.selected, r.label), o.type = "RadioButton", o.obj = r, r.selected && (g = o.obj), nt.addChild(o), u ? (o.y = s, s += o.getBounds().height + h) : (o.x = s, s += o.getBounds().width + h)
                }

                function ht(i, r) {
                    var u = new n.Container({
                            style: !1
                        }),
                        v, h, f, l, p;
                    return d.buttons.push(u), u.mouseChildren = !1, u.setBounds(-c, -c, t + c * 2, t + c * 2), v = new n.Shape({
                        style: !1
                    }), h = v.graphics, h.f(e).dc(t / 2, t / 2, t / 1.85), h.s(o).ss(s).dc(t / 2, t / 2, t / 2 - t / 10), u.addChild(v), f = u.check = new n.Circle(t / 5.2, a, null, null, null, null, null, null, !1), d.indicators.push(f), f.mouseEnabled = !1, f.alpha = .95, f.regX = f.regY = -t / 2, l = t, r && (tt == 0 && (tt = r.width), u.addChild(r), r.y = t / 2, u.text = r.text, y ? (r.x = -r.width - c, u.setBounds(-r.width - c, -c, t + c * 2 + r.getBounds().width, Math.max(t + c * 2, r.getBounds().height)), l = r.width + c + t) : (r.x = u.getBounds().width, u.setBounds(-c, -c, t + c * 2 + r.getBounds().width, Math.max(t + c * 2, r.getBounds().height)), l = r.x + r.width)), i && (u.addChild(f), d.label = r, d.label && (d.text = r.text)), p = new n.Shape({
                        style: !1
                    }), h = p.graphics, h.f("rgba(0,0,0,.01)").r(u.getBounds().x, u.getBounds().y, l + c * 2, u.getBounds().height), u.hitArea = p, u
                }
                var ft, k, d, tt, g, ut, it, nt, et, rt;
                if (ft = zob(n.RadioButtons, arguments, "size, buttons, vertical, color, backgroundColor, borderColor, borderWidth, spacing, margin, always, indicatorColor, selectedIndex, rtl, style, group, inherit", this)) return ft;
                if (z_d("57"), this.zimContainer_constructor(null, null, null, null, !1), this.type = "RadioButtons", this.group = w, k = p === !1 ? {} : n.getStyle(this.type, this.group, b), zot(t) && (t = k.size != null ? k.size : 60), t = Math.max(5, t), zot(i) && (i = k.buttons != null ? k.buttons : ["A", "B", "C"]), zot(u) && (u = k.vertical != null ? k.vertical : !0), zot(f) && (f = k.color != null ? k.color : "#111"), zot(e) && (e = k.backgroundColor != null ? k.backgroundColor : "rgba(255,255,255,.8)"), zot(o) && (o = k.borderColor != null ? k.borderColor : "#111"), zot(s) && (s = k.borderWidth != null ? k.borderWidth : t / 9), o < 0 || s < 0 ? o = s = null : o != null && s == null && (s = t / 10), zot(h) && (h = u ? k.spacing != null ? k.spacing : t * .2 : k.spacing != null ? k.spacing : t), zot(c) && (c = k.margin != null ? k.margin : t / 5), zot(l) && (l = k.always != null ? k.always : !1), zot(a) && (a = k.indicatorColor != null ? k.indicatorColor : s > 0 ? o : "black"), zot(y) && (y = k.rtl != null ? k.rtl : WW.DIR == "rtl"), d = this, this.cursor = "pointer", this.labels = [], this.indicators = [], tt = 0, typeof i == "string")
                    for (ut = i, i = [], it = 0; it < ut.length; it++) i.push({
                        label: ut[it]
                    });
                for (nt = new n.Container({
                        style: !1
                    }), this.addChild(nt), st(), rt = 0; rt < nt.numChildren; rt++) {
                    et = nt.getChildAt(rt);
                    et.on((zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click", ot)
                }
                this.getBounds() || this.setBounds(0, 0, t, t);
                y ? (this.setBounds(-c * 2 - tt, -c, this.getBounds().width + c * 2, this.getBounds().height), this.regX = u ? t + c : this.getBounds().width - tt - c * 3) : this.setBounds(-c, -c, this.getBounds().width + c * 2, this.getBounds().height);
                this.setSelected = function(t) {
                    var i, r, u;
                    if (zot(t) && (t = -1), t == -1 || nt.getChildAt(t)) {
                        for (r = 0; r < nt.numChildren; r++) i = nt.getChildAt(r), i.removeChild(i.check);
                        return t >= 0 && (i = nt.getChildAt(t), u = -2, g && (u = g.index), g = i.obj), t == -1 || u == g.index ? (g = null, d.id = null, d.label = null, d.text = "") : (i.addChild(i.check), d.id = g.id, d.label = g.label, d.label && (d.text = d.label.text)), !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && d.stage && d.stage.update(), d
                    }
                };
                Object.defineProperty(d, "selected", {
                    get: function() {
                        return g
                    },
                    set: function() {
                        zogy("ZIM RadioButton - selected is read only")
                    }
                });
                Object.defineProperty(d, "selectedIndex", {
                    get: function() {
                        return g ? g.index : -1
                    },
                    set: function(n) {
                        var t = n;
                        l && d.selectedIndex == t || d.setSelected(t)
                    }
                });
                this._enabled = !0;
                Object.defineProperty(d, "enabled", {
                    get: function() {
                        return d._enabled
                    },
                    set: function(n) {
                        r(d, n)
                    }
                });
                zot(v) && (v = k.selectedIndex != null ? k.selectedIndex : 0);
                d.selectedIndex = v;
                n.styleTransforms(this, k);
                this.clone = function() {
                    for (var r = n.copy(i), w = 0; w < r.length; w++) r[w].label = r[w].label.clone();
                    return d.cloneProps(new n.RadioButtons(t, r, u, f, e, o, s, h, c, l, a, v, y, p, this.group, b))
                }
            }, n.extend(n.RadioButtons, n.Container, "clone", "zimContainer", !1), n.Toggle = function(i, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt) {
                function st(n) {
                    var i = ut.indicator.x,
                        t = g,
                        r;
                    n === !0 && (t = 0);
                    h == "rectangle" || h == "square" ? (ut.indicator.pos(u * .2, null, et), g > 0 && ut.indicator.animate({
                        props: {
                            x: i
                        },
                        from: !0,
                        time: t
                    })) : (ut.indicator.pos(u * .175, null, et), g > 0 && ut.indicator.animate({
                        props: {
                            x: i
                        },
                        from: !0,
                        time: t
                    }));
                    ut.background.color = et ? a : o;
                    ut.text = et ? ut.label ? ut.label.text : "on" : ut.labelLeft ? ut.labelLeft.text : "off";
                    ut.zimAccessibility && (r = "Toggle set to " + (et ? ut.label ? ut.label.text + "." : "on." : ut.labelLeft ? ut.labelLeft.text + "." : "off."), setTimeout(function() {
                        ut.zimAccessibility.talk(r)
                    }, 50))
                }
                var ht, ft, ot, ut, et, ct;
                if (ht = zob(n.Toggle, arguments, "width, height, label, startToggled, backgroundColor, margin, indicatorType, indicatorColor, tap, toggleBackgroundColor, color, borderColor, borderWidth, corner, indicatorCorner, shadowColor, shadowBlur, time, labelLeft, style, group, inherit", this)) return ht;
                z_d("57.5");
                this.group = it;
                ft = tt === !1 ? {} : n.getStyle("Toggle", this.group, rt);
                zot(i) && (i = ft.width != null ? ft.width : 80);
                zot(u) && (u = ft.height != null ? ft.height : 50);
                this.zimContainer_constructor(i, u, null, null, !1);
                this.type = "Toggle";
                zot(o) && (o = ft.backgroundColor != null ? ft.backgroundColor : "#C60");
                zot(s) && (s = ft.margin != null ? ft.margin : 10);
                zot(h) && (h = ft.indicatorType != null ? ft.indicatorType : "circle");
                zot(c) && (c = ft.indicatorColor != null ? ft.indicatorColor : "#fff");
                zot(a) && (a = ft.toggleBackgroundColor != null ? ft.toggleBackgroundColor : "#F93");
                zot(v) && (v = ft.color != null ? ft.color : "#111");
                zot(y) && (y = ft.borderColor != null ? ft.borderColor : null);
                zot(p) && (p = ft.borderWidth != null ? ft.borderWidth : null);
                y < 0 || p < 0 ? y = p = null : y != null && p == null && (p = 1);
                zot(w) && (w = ft.corner != null ? ft.corner : h != "circle" ? 0 : 25);
                zot(b) && (b = ft.indicatorCorner != null ? ft.indicatorCorner : 0);
                zot(k) && (k = ft.shadowColor != null ? ft.shadowColor : "rgba(0,0,0,.3)");
                zot(d) && (d = ft.shadowBlur != null ? ft.shadowBlur : 14);
                zot(e) && (e = ft.startToggled != null ? ft.startToggled : !1);
                ot = t(g);
                zot(g) && (g = ft.time != null ? ft.time : ot == "s" ? .1 : 100);
                zot(f) && (f = ft.label != null ? ft.label : null);
                zot(nt) && (nt = ft.labelLeft != null ? ft.labelLeft : null);
                ut = this;
                ut.cursor = "pointer";
                (typeof f == "string" || typeof f == "number") && (f = this.label = new n.Label({
                    text: f,
                    size: ft.size || u * 5 / 6,
                    color: v,
                    valign: "center",
                    backing: "ignore",
                    shadowColor: "ignore",
                    shadowBlur: "ignore",
                    padding: "ignore",
                    backgroundColor: "ignore",
                    group: this.group
                }));
                (typeof nt == "string" || typeof nt == "number") && (nt = this.labelLeft = new n.Label({
                    text: nt,
                    size: ft.size || u * 5 / 6,
                    color: v,
                    valign: "center",
                    backing: "ignore",
                    shadowColor: "ignore",
                    shadowBlur: "ignore",
                    padding: "ignore",
                    backgroundColor: "ignore",
                    group: this.group
                }));
                this.background = new n.Rectangle(i, u, o, y, p, w).addTo(this);
                this.indicator = h == "rectangle" || h == "square" ? new n.Rectangle(u * .65, u * .65, c, null, null, b).center(this.background).pos(u * .2, null, e) : new n.Circle(u * .35, c).center(this.background).pos(u * .175, null, e);
                et = e;
                ut.background.color = et ? a : o;
                k != -1 && d > 0 && (this.background.shadow = new createjs.Shadow(k, 3, 3, d));
                f && (this.addChild(f), f.x = i + 2 + s + p, f.y = u / 2, this.label = f, this.setBounds(-s, -s, i + s * 3 + p + f.getBounds().width, Math.max(u + s * 2, f.getBounds().height)));
                nt && (this.addChild(nt), nt.x = 0, ut.background.x += nt.width + 3 + s + p, ut.label.x += nt.width + 3 + s + p, nt.y = u / 2, this.labelLeft = nt, this.setBounds(-s, -s, ut.getBounds().width + nt.width + 3 + s + p, ut.getBounds().height));
                this.expand(n.mobile() ? 20 : 10);
                this.tap(function(t) {
                    if (nt) {
                        var r = ut.localToGlobal(nt.width + 3 + s + p + i / 2, 0);
                        if (t.stageX / n.scaX < r.x - i / 2 && !et || t.stageX / n.scaX >= r.x + i / 2 && et) return
                    }
                    et = !et;
                    st();
                    ut.dispatchEvent("change")
                }, n.mobile() ? 20 : 10);
                ct = new n.Swipe(this, 20, ot == "s" ? .2 : 200);
                ct.on("swipe", function(n) {
                    n.swipeX != 0 && (n.swipeX == 1 && et || (n.swipeX != -1 || et) && (et = !et, st(), ut.dispatchEvent("change")))
                });
                Object.defineProperty(ut, "textLeft", {
                    get: function() {
                        return nt ? nt.text : null
                    },
                    set: function(t) {
                        nt && (nt.text = t, !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && ut.stage && ut.stage.update())
                    }
                });
                ut.toggle = function(n, t) {
                    var i = et;
                    return zot(n) && (n = !0), et = n, i != et && st(t), ut
                };
                ut.text = et ? ut.label ? ut.label.text : "on" : ut.labelLeft ? ut.labelLeft.text : "off";
                Object.defineProperty(ut, "toggled", {
                    get: function() {
                        return et
                    },
                    set: function(n) {
                        ut.toggle(n)
                    }
                });
                this._enabled = !0;
                Object.defineProperty(ut, "enabled", {
                    get: function() {
                        return ut._enabled
                    },
                    set: function(n) {
                        r(ut, n)
                    }
                });
                tt !== !1 && n.styleTransforms(this, ft);
                this.clone = function() {
                    return ut.cloneProps(new n.Toggle(i, u, f ? f.clone() : "", e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt ? nt.clone() : "", tt, this.group, rt))
                }
            }, n.extend(n.Toggle, n.Container, "clone", "zimContainer", !1), n.Tip = function(i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, dt, gt, ni, ti, ii, ri, ui) {
                var oi, ei, si, fi;
                if (oi = zob(n.Tip, arguments, "text, align, valign, margin, marginH, marginV, outside, target, delay, time, mouseClose, size, font, color, rollColor, shadowColor, shadowBlur, textAlign, textValign, lineWidth, lineHeight, backing, outlineColor, outlineWidth, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, rollPersist, labelWidth, labelHeight, maxSize, bold, italic, variant, splitWords, style, group, inherit", this)) return oi;
                z_d("57.6");
                this.group = ri;
                ei = ii === !1 ? {} : n.getStyle("Tip", this.group, ui);
                zot(i) && (i = ei.text != null ? ei.text : "Here's a tip!");
                zot(f) && (f = ei.margin != null ? ei.margin : 40);
                zot(e) && (e = ei.marginH != null ? ei.marginH : f);
                zot(o) && (o = ei.marginV != null ? ei.marginV : f);
                zot(r) && (r = ei.align != null ? ei.align : "right");
                zot(u) && (u = ei.valign != null ? ei.valign : "bottom");
                zot(s) && (s = ei.outside != null ? ei.outside : !1);
                zot(ft) && (ft = ei.backgroundColor != null ? ei.backgroundColor : n.blue);
                zot(p) && (p = ei.color != null ? ei.color : n.white);
                zot(st) && (st = ei.corner != null ? ei.corner : 25);
                zot(st) && (st = ei.corner != null ? ei.corner : 25);
                zot(st) && (st = ei.corner != null ? ei.corner : 25);
                zot(lt) && (lt = ei.paddingHorizontal != null ? ei.paddingHorizontal : 14 + (Array.isArray(st) ? st[0] : st));
                (zot(b) || b == "ignore") && (b = ei.shadowColor != null && b != "ignore" ? ei.shadowColor : "rgba(0,0,0,.3)");
                (zot(k) || k == "ignore") && (k = ei.shadowBlur != null && k != "ignore" ? ei.shadowBlur : 1);
                zot(c) && (c = ei.delay != null ? ei.delay : 0);
                si = t(l);
                zot(l) && (l = ei.time != null ? ei.time : si == "s" ? 2 : 2e3);
                zot(a) && (a = ei.mouseClose != null ? ei.mouseClose : !0);
                this.zimLabel_constructor(i, v, y, p, w, null, null, d, g, dt, gt, ni, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, ti, ii, ri, n.copy(ei));
                this.type = "Tip";
                s && (e = -e, o = -o);
                fi = this;
                fi.align = r;
                fi.valign = u;
                this.background.sha(b, 3, 5, k);
                this.show = function(i, r) {
                    function u() {
                        var i, t;
                        i = h.boundsToGlobal ? h.boundsToGlobal() : h.getBounds();
                        t = new n.Container(i.x, i.y, i.width, i.height);
                        t.zimTemp = !0;
                        t.loc(0, 0, h.stage);
                        (fi.align == "center" || fi.align == "middle" || fi.valign == "center" || fi.valign == "middle") && fi.center(t);
                        fi.pos(fi.align == "center" || fi.align == "middle" ? null : e, fi.valign == "center" || fi.valign == "middle" ? null : o, fi.align == "right", fi.valign == "bottom", t);
                        s && (fi.align == "right" ? fi.x += fi.width : fi.align == "left" && (fi.x -= fi.width), fi.valign == "bottom" ? fi.y += fi.height : fi.valign == "top" && (fi.y -= fi.height));
                        fi.addTo(t.stage);
                        t.zimTemp && t.removeFrom && (t.removeFrom(), t = null);
                        t = fi.stage;
                        fi.timeoutID && fi.timeoutID.clear();
                        fi.timeoutID = n.timeout(r, function() {
                            fi.hide();
                            t.stage.update()
                        });
                        a && (fi.upID && t.stage.off("stagemouseup", fi.upID), fi.upID = t.stage.on("stagemouseup", function() {
                            fi.hide();
                            t.stage && t.stage.update()
                        }));
                        t.stage && t.stage.update()
                    }
                    var f = t(r);
                    if (zot(i) && (i = c), zot(r) && (r = l), zot(h))
                        if (WW.zdf) h = WW.zdf.stage;
                        else return fi;
                    else if (h.getBounds) {
                        if (zot(h.stage)) return zogy("zim display - Waiter(): The container must have a stage property"), fi
                    } else return zogy("zim Tip(): Please pass in a reference to a container with bounds set as parameter to Tip"), fi;
                    return i > 0 ? fi.showID = n.timeout(i, u) : u(), fi
                };
                this.hide = function() {
                    return this.removeFrom(), this.timeoutID && this.timeoutID.clear(), this.upID && h.stage && h.stage.off("stagemouseup", this.upID), fi
                };
                this.clear = function() {
                    fi.showID && fi.showID.clear();
                    fi.hide()
                };
                this.dispose = function(n, t, i) {
                    fi.upID && fi.stage && fi.stage.off("stagemouseup", fi.upID);
                    i || this.zimLabel_dispose(!0)
                };
                ii !== !1 && n.styleTransforms(this, ei);
                this.clone = function() {
                    return fi.cloneProps(new n.Tip(i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, ti, ii, this.group, ui))
                }
            }, n.extend(n.Tip, n.Label, ["dispose", "clone"], "zimLabel", !1), n.Pane = function(t, i, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot) {
                function pt(n) {
                    st.dispatchEvent("closing");
                    setTimeout(function() {
                        ii();
                        st.dispatchEvent("close")
                    }, 10);
                    n.stopImmediatePropagation()
                }

                function ri() {
                    var t, i, u, r;
                    for (st.toggled = !1, i = 0; i < st.numChildren; i++) t = st.getChildAt(i), (t.type == "TextArea" || t.type == "Loader" || t.type == "Tag") && (u = {
                        obj: t,
                        depth: st.getChildIndex(t)
                    }, at.add(t, u));
                    for (i = st.numChildren - 1; i >= 0; i--) t = st.getChildAt(i), (t.type == "TextArea" || t.type == "Loader" || t.type == "Tag") && st.removeChild(t);
                    n.OPTIMIZE || !zns && WW.OPTIMIZE || st.container.stage.update();
                    s && (isNaN(st.resetX) || (st.x = st.resetX), isNaN(st.resetY) || (st.y = st.resetY));
                    st.zimAccessibility && (r = st.zimAccessibility, r.resize(st), kt ? kt.focus() : st.zimTabTag.nextSibling.focus(), setTimeout(function() {
                        r.talk("Pane has been closed.")
                    }, 50))
                }

                function ii() {
                    function t() {
                        st.container.removeChild(st);
                        st.closeCall && st.closeCall(st.closeParams);
                        n.OPTIMIZE || !zns && WW.OPTIMIZE || st.container.stage.update();
                        s && (isNaN(st.resetX) || (st.x = st.resetX), isNaN(st.resetY) || (st.y = st.resetY))
                    }
                    k > 0 ? st.animate({
                        obj: {
                            alpha: 0
                        },
                        time: k,
                        call: function() {
                            t();
                            st.dispatchEvent("fadedout")
                        }
                    }) : t()
                }

                function ui() {
                    for (var t, n = 0; n < at.length; n++) st.addChildAt(at.values[n].obj, at.values[n].depth);
                    st.zimAccessibility && (t = st.zimAccessibility, setTimeout(function() {
                        t.activatedObject && (kt = t.activatedObject.zimTabTag)
                    }, 50), t.resize(st), t.tabIndex = st.zimTabIndex);
                    st.toggled = !0
                }

                function fi(n, r) {
                    return n = Math.max(t / 2, Math.min(st.container.getBounds().width - t / 2, n)), r = Math.max(i / 2, Math.min(st.container.getBounds().height - i / 2, r)), {
                        x: n,
                        y: r
                    }
                }
                var dt, vt, ht, lt, yt, st, gt, at, ct, wt, ni, ti, bt, kt;
                if (dt = zob(n.Pane, arguments, "width, height, content, backgroundColor, color, draggable, resets, modal, corner, backdropColor, shadowColor, shadowBlur, center, displayClose, backdropClose, backing, fadeTime, container, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, close, closeColor, style, group, inherit", this)) return dt;
                if (z_d("58"), this.zimContainer_constructor(null, null, null, null, !1), this.type = "Pane", vt = "zim display - Pane(): Please pass in a reference to a container with bounds set as first parameter", zot(d))
                    if (WW.zdf) d = WW.zdf.stage;
                    else {
                        zogy(vt);
                        return
                    }
                else if (d.getBounds) {
                    if (zot(d.getStage)) {
                        zogy("zim display - Pane(): The container must have a stage property");
                        return
                    }
                } else {
                    zogy(vt);
                    return
                }
                this.group = et;
                ht = ft === !1 ? {} : n.getStyle(this.type, this.group, ot);
                zot(t) && (t = ht.width != null ? ht.width : 200);
                zot(i) && (i = ht.height != null ? ht.height : 200);
                zot(u) && (u = ht.content != null ? ht.content : null);
                (typeof u == "string" || typeof u == "number") && (u = new n.Label({
                    text: u,
                    size: ht.size != null ? ht.size : 40,
                    align: ht.align != null ? ht.align : "center",
                    valign: ht.valign != null ? ht.valign : "center",
                    color: ht.color != null ? ht.color : e,
                    backing: "ignore",
                    shadowColor: "ignore",
                    shadowBlur: "ignore",
                    padding: "ignore",
                    backgroundColor: "ignore",
                    group: this.group
                }).noMouse());
                u && (u = this.content = n.makeContent(u, t, n.dark));
                zot(f) && (f = ht.backgroundColor != null ? ht.backgroundColor : "white");
                zot(o) && (o = ht.draggable != null ? ht.draggable : !1);
                zot(s) && (s = ht.resets != null ? ht.resets : !0);
                zot(h) && (h = ht.modal != null ? ht.modal : !0);
                zot(c) && (c = ht.corner != null ? ht.corner : 20);
                zot(g) && (g = ht.titleBar != null ? ht.titleBar : null);
                zot(nt) && (nt = ht.titleBarColor != null ? ht.titleBarColor : null);
                zot(tt) && (tt = ht.titleBarBackgroundColor != null ? ht.titleBarBackgroundColor : null);
                zot(it) && (it = ht.titleBarHeight != null ? ht.titleBarHeight : null);
                zot(l) && (l = ht.backdropColor != null ? ht.backdropColor : "rgba(0,0,0,.2)");
                zot(a) && (a = ht.shadowColor != null ? ht.shadowColor : "rgba(0,0,0,.3)");
                zot(v) && (v = ht.shadowBlur != null ? ht.shadowBlur : 20);
                zot(y) && (y = ht.center != null ? ht.center : !0);
                zot(p) && (p = ht.displayClose != null ? ht.displayClose : !0);
                o && (p = !1);
                zot(w) && (w = ht.backdropClose != null ? ht.backdropClose : !0);
                zot(k) && (k = ht.fadeTime != null ? ht.fadeTime : 0);
                zot(rt) && (rt = ht.close != null ? ht.close : !1);
                zot(ut) && (ut = ht.closeColor != null ? ht.closeColor : "#555");
                lt = this.backdrop = new n.Shape({
                    style: !1
                });
                yt = lt.graphics;
                yt.f(l);
                yt.drawRect(-5e3, -5e3, 1e4, 1e4);
                this.setBounds(-t / 2, -i / 2, t, i);
                st = this;
                gt = ["header", "message", "text", "display", "buttons", "config"];
                u && gt.forEach(function(n) {
                    u[n] && (st[n] = u[n])
                });
                st.label = st.message;
                st.container = d;
                lt.on((zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click", w ? pt : function(n) {
                    n.stopImmediatePropagation()
                });
                at = new n.Dictionary(!0);
                lt.on("mousedown", function(n) {
                    n.stopImmediatePropagation()
                });
                if (this.addChild(lt), h || lt.noMouse(), zot(b) ? ct = this.backing = new n.Rectangle({
                        width: t,
                        height: i,
                        color: f,
                        corner: c,
                        style: !1
                    }) : (b.type == "Pattern" ? (wt = b, ct = new n.Rectangle(t, i, f, null, null, c, null, null, null, !1), wt.centerReg(ct), wt.setMask(ct.shape)) : ct = b, st.display = st.backing = ct), p) {
                    ct.cursor = "pointer";
                    ct.on((zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click", pt)
                }
                a != -1 && v > 0 && (ct.shadow = new createjs.Shadow(a, 8, 8, v));
                ct.on("click", function(n) {
                    n.stopImmediatePropagation()
                });
                if (this.resetX, this.resetY, o) {
                    ct.cursor = "pointer";
                    ct.on("mousedown", function(t) {
                        isNaN(st.resetX) && (st.resetX = st.x);
                        isNaN(st.resetY) && (st.resetY = st.y);
                        ni = t.stageX / n.scaX - st.x;
                        ti = t.stageY / n.scaY - st.y;
                        ct.cursor = "pointer"
                    });
                    ct.on("pressmove", function(t) {
                        var u = fi(t.stageX / n.scaX - ni, t.stageY / n.scaY - ti),
                            i, r;
                        for (st.x = u.x, st.y = u.y, r = 0; r < st.numChildren; r++) i = st.getChildAt(r), (i.type == "TextArea" || i.type == "Loader" || i.type == "Tag") && i.resize();
                        st.stage.update()
                    });
                    this.on("pressup", function() {
                        ct.cursor = "pointer";
                        st.stage && st.stage.update()
                    })
                }
                if (ct.centerReg(this), u && u.center(this), zot(g) || (typeof g == "string" && (g = new n.Label(g, null, null, nt)), bt = st.titleBarLabel = g, zot(it) && (it = bt.height * 1.5), zot(nt) && (nt = "black"), zot(tt) && (tt = "rgba(0,0,0,.2)"), st.titleBar = g = new n.Container(t, it, null, null, !1).centerReg(st).mov(0, -i / 2 + it / 2), g.mouseEnabled = !1, g.mouseChildren = !1, st.titleBar.backing = new n.Rectangle(t, it, tt, null, null, [c * .95, c * .95, 0, 0], null, null, null, !1).addTo(g), bt.center(g).pos({
                        x: Math.max(c / 2, 10),
                        reg: !0
                    })), rt) {
                    rt = st.close = new n.Shape(-40, -40, 80, 80, null, !1);
                    rt.graphics.f(ut).p("AmJEVIEUkTIkXkWIB4h5IEWEYIETkTIB4B3IkTESIEQERIh4B4IkRkRIkSEVg");
                    g ? rt.addTo(st).scaleTo(g, null, 50).mov(t / 2 - Math.max(c / 2, 10) - rt.width / 2, -i / 2 + it / 2).expand(40) : rt.addTo(st).sca(.3).mov(t / 2 - rt.width - 3, -i / 2 + rt.height).expand(40);
                    rt.cursor = "pointer";
                    rt.expand();
                    rt.on((zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click", pt)
                }
                Object.defineProperty(st, "text", {
                    get: function() {
                        if (st.message) return st.message.text == " " ? "" : st.message.text
                    },
                    set: function(n) {
                        st.message && (st.message.text = n)
                    }
                });
                this._enabled = !0;
                Object.defineProperty(st, "enabled", {
                    get: function() {
                        return st._enabled
                    },
                    set: function(n) {
                        r(st, n)
                    }
                });
                this.hide = function(n, t) {
                    return zot(n) || (st.closeParams = n), ii(), t && (st.dispatchEvent("close"), st.dispatchEvent("change")), st
                };
                this.on("removed", ri);
                this.show = function(n, t) {
                    return zot(n) || (st.closeCall = n), zot(t) || (st.closeParams = t), y && isNaN(st.resetX) && (st.x = st.container.getBounds().width / 2, st.y = st.container.getBounds().height / 2), st.container.addChild(st), k > 0 ? (st.alpha = 0, st.animate({
                        props: {
                            alpha: 1
                        },
                        time: k,
                        call: function() {
                            st.dispatchEvent("fadedin")
                        }
                    })) : setTimeout(function() {
                        st.container.stage && st.container.stage.update()
                    }, 10), st
                };
                this.on("added", ui);
                this.toggle = function(n) {
                    return n === !0 ? st.show() : n === !1 ? st.hide() : st.container.contains(st) ? st.hide() : st.show(), st
                };
                ft !== !1 && n.styleTransforms(this, ht);
                this.clone = function() {
                    var u = label.x,
                        d = label.y,
                        r = st.cloneProps(new n.Pane(t, i, label.clone(), f, e, o, s, h, c, l, a, v, y, p, w, zot(b) ? b.clone() : null, k, st.container, g, nt, tt, it, rt, ut, ft, this.group, ot));
                    return r.label.x = u, r.label.y = d, r
                }
            }, n.extend(n.Pane, n.Container, "clone", "zimContainer", !1), n.Panel = function(t, i, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot) {
                function ii() {
                    nt == "right" ? vt.center(f).pos(Math.max(a[0] / 2, 10), null, !0) : nt == "center" || nt == "middle" ? vt.center(f) : vt.center(f).loc(Math.max(a[0] / 2, 10));
                    vt.mov(0, 2)
                }
                var ni, ht, st, bt, vt, ti, ct, wt, kt, lt, at, yt;
                if (ni = zob(n.Panel, arguments, "width, height, content, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, backgroundColor, borderColor, borderWidth, corner, close, closeColor, next, nextColor, extraButton, collapse, collapseColor, collapsed, align, shadowColor, shadowBlur, draggable, boundary, style, group, inherit", this)) return ni;
                z_d("57.7");
                this.group = et;
                ht = ft === !1 ? {} : n.getStyle("Panel", this.group, ot);
                zot(t) && (t = ht.width != null ? ht.width : 250);
                zot(i) && (i = ht.height != null ? ht.height : 300);
                this.zimContainer_constructor(t, i, null, null, !1);
                this.type = "Panel";
                zot(u) && (u = ht.content != null ? ht.content : null);
                wt = this.content = u;
                zot(f) && (f = ht.titleBar != null ? ht.titleBar : "PANEL");
                zot(e) && (e = ht.titleBarColor != null ? ht.titleBarColor : "#fff");
                zot(o) && (o = ht.titleBarBackgroundColor != null ? ht.titleBarBackgroundColor : "#555");
                zot(s) && (s = ht.titleBarHeight != null ? ht.titleBarHeight : 30);
                zot(h) && (h = ht.backgroundColor != null ? ht.backgroundColor : "#eee");
                zot(c) && (c = ht.borderColor != null ? ht.borderColor : "#888");
                zot(l) && (l = ht.borderWidth != null ? ht.borderWidth : null);
                c < 0 || l < 0 ? c = l = null : c != null && l == null && (l = 1);
                zot(a) && (a = ht.corner != null ? ht.corner : 5);
                zot(nt) && (nt = ht.align != null ? ht.align : "left");
                zot(tt) && (tt = ht.shadowColor != null ? ht.shadowColor : "rgba(0,0,0,.3)");
                zot(it) && (it = ht.shadowBlur != null ? ht.shadowBlur : 14);
                zot(rt) && (rt = ht.draggable != null ? ht.draggable : !1);
                zot(ut) && (ut = ht.boundary != null ? ht.boundary : null);
                zot(v) && (v = ht.close != null ? ht.close : !1);
                zot(y) && (y = ht.closeColor != null ? ht.closeColor : zot(e) ? "#555" : e);
                zot(p) && (p = ht.next != null ? ht.next : n.vee(f));
                zot(w) && (w = ht.nextColor != null ? ht.nextColor : zot(e) ? "#555" : e);
                Array.isArray(a) || (a = [a, a, a, a]);
                zot(k) && (k = ht.collapse != null ? ht.collapse : !1);
                zot(d) && (d = ht.collapseColor != null ? ht.collapseColor : zot(e) ? "#555" : e);
                zot(g) && (g = ht.collapsed != null ? ht.collapsed : !1);
                st = this;
                kt = ["header", "message", "text", "display", "buttons", "config"];
                u && kt.forEach(function(n) {
                    u[n] && (st[n] = u[n])
                });
                st.label = st.message;
                bt = this.background = new n.Rectangle(t, i, h, c, l, a).addTo(this);
                tt != -1 && it > 0 && (this.background.shadow = new createjs.Shadow(tt, 3, 3, it));
                var dt = f,
                    pt = n.Pick.choose(dt),
                    ri = n.Pick.choose(e),
                    gt = n.Pick.choose(o),
                    u = st.contentContainer = new n.Container(t, i - s).addTo(st).mov(0, s);
                if (typeof pt == "string" && (pt = new n.Label({
                        text: pt,
                        color: ri,
                        size: ht.size != null ? ht.size : 20,
                        bold: ht.bold != null ? ht.bold : !1,
                        backing: "ignore",
                        shadowColor: "ignore",
                        shadowBlur: "ignore",
                        padding: "ignore",
                        backgroundColor: "ignore",
                        group: this.group
                    })), vt = st.titleBarLabel = pt, zot(gt) && (gt = "rgba(0,0,0,.2)"), st.titleBar = f = new n.Container(t, s, null, null, !1).loc(0, 0, st), ti = st.titleBar.backing = new n.Rectangle(t + l, s, gt, null, null, [a[0] * .95, a[1] * .95, 0, 0], !0, null, null, !1).center(f), f && ii(), st.label = pt, st.text = pt.text, v) {
                    ct = st.closeIcon = new n.Shape(-40, -40, 80, 80, null, !1);
                    ct.graphics.f(y).p("AmJEVIEUkTIkXkWIB4h5IEWEYIETkTIB4B3IkTESIEQERIh4B4IkRkRIkSEVg");
                    f ? (ct.centerReg(f).scaleTo(f, null, 50), ct.pos(Math.max(a[1] / 2, 15), null, !0)) : ct.addTo(st).sca(.3).mov(t / 2 - ct.width - 3, -i / 2 + v.height);
                    ct.expand(40);
                    ct.cursor = "pointer";
                    ct.on((zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click", function() {
                        var n = st.stage;
                        st.removeFrom();
                        st.dispatchEvent("close");
                        n.update()
                    })
                }
                if (st.add = function(n, t, i) {
                        i && st.contentContainer.removeAllChildren();
                        t ? n.center(st.contentContainer) : n.addTo(st.contentContainer)
                    }, st.content && (wt = n.makeContent(st.content, t), kt = ["header", "message", "text", "display", "buttons", "config"], kt.forEach(function(n) {
                        wt[n] && (st[n] = wt[n])
                    }), st.label = st.message, st.add(wt, !0)), this.nextPanel = function(t, i) {
                        var r = zot(t) || zot(dt.array) ? n.Pick.choose(dt) : dt.array[t],
                            u = zot(t) || zot(e.array) ? n.Pick.choose(e) : e.array[t],
                            f = zot(t) || zot(o.array) ? n.Pick.choose(o) : o.array[t],
                            s = zot(t) || zot(h.array) ? n.Pick.choose(h) : h.array[t],
                            l = zot(t) || zot(c.array) ? n.Pick.choose(c) : c.array[t];
                        typeof r == "string" && (r = new n.Label({
                            text: r,
                            color: u,
                            size: ht.size != null ? ht.size : 20,
                            backing: "ignore",
                            shadowColor: "ignore",
                            shadowBlur: "ignore",
                            padding: "ignore",
                            backgroundColor: "ignore",
                            group: this.group
                        }));
                        st.label = r;
                        st.text = r.text;
                        vt.removeFrom();
                        vt = st.titleBarLabel = r;
                        ii();
                        ti.color = f;
                        st.background.color = s;
                        st.background.borderColor = l;
                        i && st.dispatchEvent("change");
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && st.stage && st.stage.update()
                    }, rt) {
                    f.cursor = "pointer";
                    f.on("mousedown", function() {
                        st.drag({
                            rect: ut,
                            currentTarget: !0
                        })
                    });
                    f.on("pressup", function() {
                        st.noDrag(!1)
                    })
                }
                if (p > 0) {
                    lt = st.nextIcon = new n.Shape(-20, -20, 40, 40, null, !1);
                    lt.graphics.f(e).p("AiJieIETCeIkTCfg");
                    lt.centerReg(f).scaleTo(f, null, 70).alp(.8).hov(1).expand();
                    lt.pos(Math.max(a[1] / 2, 15), null, !0);
                    ct && lt.mov(-ct.width - 8);
                    lt.cursor = "pointer";
                    lt.on((zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click", function() {
                        st.nextPanel();
                        st.dispatchEvent("change")
                    })
                }
                if (zot(b) || (b = st.extraButton = new n.Button({
                        label: "R",
                        width: 50,
                        height: 50,
                        corner: 5,
                        group: "PanelExtra"
                    }).scaleTo(f, null, 70).centerReg(f).expand(), b.pos(Math.max(a[1] / 2, 15), null, !0), ct && b.mov(-ct.width - 8), lt && b.mov(-lt.width - 8)), k) {
                    yt = g;
                    st.collapse = function(n) {
                        if (zot(n) && (n = !0), n == yt) return st;
                        n ? (at.rot(180), bt.visible = !1, u.visible = !1, yt = !0, st.dispatchEvent("collapse")) : (at.rot(0), bt.visible = !0, u.visible = !0, yt = !1, st.dispatchEvent("expand"));
                        st.stage && st.stage.update()
                    };
                    st.collapseEvent = st.titleBar.on("dblclick", function() {
                        st.collapsed = !st.collapsed
                    });
                    zot(d) && (d = "#555");
                    at = st.collapseIcon = new n.Triangle(90, 90, 90, n.faint, d, 16);
                    at.centerReg(st).scaleTo(f, null, 41).pos({
                        x: t - Math.max(a[1] / 2, 15) - at.width / 2 - 4,
                        y: s / 2,
                        reg: !0
                    }).expand(40);
                    b && at.mov(-b.width - 8);
                    ct && at.mov(-ct.width - 8);
                    lt && at.mov(-lt.width - 8);
                    at.cursor = "pointer";
                    at.expand();
                    yt = !1;
                    at.on((zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click", function() {
                        yt ? st.collapse(!1) : st.collapse(!0)
                    })
                }
                st.overlay = new n.Rectangle(t, i, null, null, null, a).alp(.3);
                Object.defineProperty(st, "panelHeight", {
                    get: function() {
                        return st.background.height
                    },
                    set: function(i) {
                        bt.removeFrom();
                        bt = this.background = new n.Rectangle(t, i, h, c, l, a).addTo(this).bot();
                        tt != -1 && it > 0 && (this.background.shadow = new createjs.Shadow(tt, 3, 3, it));
                        st.setBounds(t, i);
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && st.stage && st.stage.update()
                    }
                });
                Object.defineProperty(st, "collapsed", {
                    get: function() {
                        return yt
                    },
                    set: function(n) {
                        st.collapse && st.collapse(n)
                    }
                });
                this._enabled = !0;
                Object.defineProperty(st, "enabled", {
                    get: function() {
                        return st._enabled
                    },
                    set: function(t) {
                        r(st, t);
                        t ? st.overlay.removeFrom() : st.overlay.addTo(st);
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && st.stage && st.stage.update()
                    }
                });
                g && (g = !1, st.collapsed = !0);
                ft !== !1 && n.styleTransforms(this, ht);
                this.clone = function() {
                    return st.cloneProps(new n.Toggle(t, i, f ? f.clone() : "", e, o, s, h, c, l, a, v, y, p, w, b, k, d, st.collapsed, nt, tt, it, rt, ut, ft, this.group, ot))
                };
                this.doDispose = function(n, t, i) {
                    return k && this.titleBar.off("dblclick", this.collapseEvent), i || this.zimContainer_dispose(!0), !0
                }
            }, n.extend(n.Panel, n.Container, ["clone", "dispose"], "zimContainer", !1), n.Panel.prototype.dispose = function(n) {
                return this.doDispose(null, null, n)
            }, n.Window = function(t, i, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, dt, gt, ni, ti, ii, ri, ui, fi) {
                function hu() {
                    ei.setBounds(0, 0, t, i);
                    lr.graphics.c().f(f).rc(0, 0, t, i, ir, ir, h, h);
                    tt != -1 && it > 0 && (lr.shadow = new createjs.Shadow(tt, 4, 4, it));
                    o > 0 && (h ? gi.graphics.c().s(e).ss(o, "square", "miter").rc(0, 0, t, i, ir, ir, h, h) : gi.graphics.c().s(e).ss(o, "square", "miter").dr(0, 0, t, i));
                    zot(er) || (er.widthOnly = ei.width + o, ei.setBounds(0, -ct, ei.width, i + ct));
                    li && (ot ? li.pos({
                        x: t - Math.max(h / 2, 10) - li.width / 2,
                        y: ct / 2,
                        reg: !0
                    }) : li.pos(Math.max(h / 2, 10) / 2, li.height / 2, !0, !1, ei));
                    ai && (ai.pos({
                        x: t - Math.max(h / 2, 10) - ai.width / 2,
                        y: ct / 2,
                        reg: !0
                    }), li && ai.mov(-li.width - 10));
                    pi && (pi.pos({
                        x: t - Math.max(h / 2, 10) - pi.width / 2,
                        y: ct / 2,
                        reg: !0
                    }), li && pi.mov(-li.width - 10), ai && pi.mov(-ai.width - 10))
                }

                function nf(n) {
                    n.currentTarget.loc(0, 0, ei).top().alp(.01).mov(ei.width, ei.height - (ei.titleBar ? ei.titleBar.height : 0))
                }

                function tf(n) {
                    n.align == "right" ? (n.x = rt, n.resize(ei.width - (yi ? si.size + si.spacing * 2 : rt) - rt * 2)) : n.align == "center" || n.align == "middle" ? n.resize(ei.width - (yi ? si.size + si.spacing * 2 : 0) - rt * 2) : n.resize(ei.width - (yi ? si.size + si.spacing * 2 : 0) - rt * 2);
                    n.alpha = n.wrapperLastAlpha
                }

                function tu(t) {
                    zot(wi) && (wi = ei.stage || WW.zdf.stage);
                    zot(t) && (t = !0);
                    t ? n.dragBoundary(u, new createjs.Rectangle(0, 0, ki ? -ei.scrollXMax : 0, yi ? -ei.scrollYMax : 0)) : n.dragBoundary(u, new createjs.Rectangle(-1e3, -1e3, wi.width + 2e3, wi.height + 2e3))
                }

                function iu() {
                    vi = u.y;
                    et && cr.immediate(vi);
                    l && ru()
                }

                function tr() {
                    ei.optimize && (wi = ei.stage, u.loop(function(n) {
                        n.hitTestBounds && n.stage && (n.hitTestBounds(wi) ? (n.visible = !0, n.loop && n.loop(function(n) {
                            n.hitTestBounds && (n.visible = n.hitTestBounds(wi) ? !0 : !1)
                        })) : n.visible = !1)
                    }))
                }

                function ru() {
                    tr();
                    ei.dispatchEvent("scrolling");
                    bi && (bi.x = -u.x, bi.y = -u.y);
                    ki && l && (hi.x = du.convert(u.x));
                    yi && l && (ci.y = gu.convert(u.y))
                }

                function vu(t) {
                    (zot(t) && (t = 100), cf(ei), c) && setTimeout(function() {
                        if (u) {
                            n.drag({
                                obj: u,
                                currentTarget: !0,
                                localBounds: !0,
                                slide: k,
                                slideDamp: d,
                                slideSnap: w && (c === !0 || c == "auto" || c == "horizontal") || b && (c === !0 || c == "auto" || c == "vertical") ? g : !1
                            });
                            u.removeAllEventListeners("slidestart");
                            u.on("slidestart", function() {
                                ei.dispatchEvent("slidestart")
                            });
                            u.removeAllEventListeners("slidestop");
                            !l && ii && (ei.zDE && u.off(ei.zDE), ei.zDE = u.on("mousedown", () => {
                                ei.zTI && n.Ticker.remove(tr)
                            }), ei.zME && u.off(ei.zME), ei.zME = u.on("pressmove", tr), ei.zSTA && u.off(ei.zSTA), ei.zSTA = u.on("slidestart", function() {
                                ei.zTI = n.Ticker.add(tr)
                            }), ei.zSTO && u.off(ei.zSTO), ei.zSTO = u.on("slidestop", function() {
                                ei.zTI && n.Ticker.remove(ei.zTI)
                            }));
                            u.on("slidestop", function(n) {
                                k && uu(n);
                                ei.dispatchEvent("slidestop")
                            });
                            u.getBounds() && u.getBounds().width > 0 && tu()
                        }
                    }, t)
                }

                function uu() {
                    n.Ticker.remove(iu);
                    sr = !1;
                    ki && p && l && n.animate(hi, {
                        alpha: 0
                    }, si.fadeTime);
                    yi && p && l && n.animate(ci, {
                        alpha: 0
                    }, si.fadeTime)
                }

                function af() {
                    fu = Date.now();
                    n.Ticker.add(hr, u.stage)
                }

                function vf() {
                    rr || (ei.dispatchEvent("hoverout"), rr = !0);
                    n.Ticker.remove(hr)
                }

                function hr() {
                    if (!u.stage) {
                        rr || (ei.dispatchEvent("hoverout"), rr = !0);
                        n.Ticker.remove(hr);
                        return
                    }
                    Math.abs(uf - ei.windowMouseX) > eu || Math.abs(ff - ei.windowMouseY) > eu ? (rr || (ei.dispatchEvent("hoverout"), rr = !0), fu = Date.now(), uf = ei.windowMouseX, ff = ei.windowMouseY) : Date.now() - fu > lf && ((Math.abs(ef - ei.windowMouseX) > eu || Math.abs( of -ei.windowMouseY) > eu) && (ei.contentMouse = u.globalToLocal(ei.windowMouseX, ei.windowMouseY), ei.dispatchEvent("hoverover"), ef = ei.windowMouseX, of = ei.windowMouseY, rr = !1), fu = Date.now())
                }

                function cf(t) {
                    et && !pu && t.stage && (pu = !0, cr = new n.Damp(ei.scrollY, et), ei.dampTicker = n.Ticker.add(function() {
                        sr || (ei.scrollY == null || vi == null || ei.scrollY == vi || Math.round(ei.scrollY) != Math.round(vi)) && (zot(vi) || (ei.scrollY = cr.convert(vi)))
                    }, t.stage))
                }
                var wu, oi, bu, ku, ei, lr, di, ou, su, wi, bi, gi, ir, si, hi, cu, ci, lu, du, gu, ki, yi, fr, ar, vr, yr, pr, wr, er, li, nr, ur, br, kr, dr, gr, ai, au, pi, or, nu, rf, sr, yu, sf, hf, vi, pu, cr;
                if (wu = zob(n.Window, arguments, "width, height, content, backgroundColor, borderColor, borderWidth, padding, corner, swipe, scrollBarActive, scrollBarDrag, scrollBarColor, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, slide, slideDamp, slideSnap, interactive, shadowColor, shadowBlur, paddingHorizontal, paddingVertical, scrollWheel, damp, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, draggable, boundary, onTop, close, closeColor, cancelCurrentDrag, fullSize, fullSizeColor, resizeHandle, collapse, collapseColor, collapsed, optimize, style, group, inherit", this)) return wu;
                if (z_d("58.1"), this.zimContainer_constructor(null, null, null, null, !1), this.type = "Window", this.group = ui, oi = ri === !1 ? {} : n.getStyle(this.type, this.group, fi), zot(t) && (t = oi.width != null ? oi.width : 300), zot(i) && (i = oi.height != null ? oi.height : 200), zot(f) && (f = oi.backgroundColor != null ? oi.backgroundColor : "#333"), bu = e, ku = o, zot(e) && (e = oi.borderColor != null ? oi.borderColor : "#999"), zot(o) && (o = oi.borderWidth != null ? oi.borderWidth : 1), zot(s) && (s = oi.padding != null ? oi.padding : 0), zot(h) && (h = oi.corner != null ? oi.corner : 0), zot(c) && (c = oi.swipe != null ? oi.swipe : !0), zot(l) && (l = oi.scrollBarActive != null ? oi.scrollBarActive : !0), zot(a) && (a = oi.scrollBarDrag != null ? oi.scrollBarDrag : !1), zot(v) && (v = oi.scrollBarColor != null ? oi.scrollBarColor : e), zot(y) && (y = oi.scrollBarAlpha != null ? oi.scrollBarAlpha : .3), zot(p) && (p = oi.scrollBarFade != null ? oi.scrollBarFade : !0), zot(w) && (w = oi.scrollBarH != null ? oi.scrollBarH : !0), zot(b) && (b = oi.scrollBarV != null ? oi.scrollBarV : !0), a && (p = oi.scrollBarFade != null ? oi.scrollBarFade : !1), zot(k) && (k = oi.slide != null ? oi.slide : !0), zot(d) && (d = oi.slideDamp != null ? oi.slideDamp : .6), zot(g) && (g = oi.slideSnap != null ? oi.slideSnap : "vertical"), zot(nt) && (nt = oi.interactive != null ? oi.interactive : !0), zot(tt) && (tt = oi.shadowColor != null ? oi.shadowColor : "rgba(0,0,0,.3)"), zot(it) && (it = oi.shadowBlur != null ? oi.shadowBlur : 20), zot(ut) && (ut = oi.paddingVertical != null ? oi.paddingVertical : s), zot(rt) && (rt = oi.paddingHorizontal != null ? oi.paddingHorizontal : s), zot(ft) && (ft = oi.scrollWheel != null ? oi.scrollWheel : !0), zot(ot) && (ot = oi.titleBar != null ? oi.titleBar : null), zot(st) && (st = oi.titleBarColor != null ? oi.titleBarColor : null), zot(ht) && (ht = oi.titleBarBackgroundColor != null ? oi.titleBarBackgroundColor : null), zot(ct) && (ct = oi.titleBarHeight != null ? oi.titleBarHeight : null), zot(lt) && (lt = oi.draggable != null ? oi.draggable : null), zot(at) && (at = oi.boundary != null ? oi.boundary : null), zot(vt) && (vt = oi.onTop != null ? oi.onTop : null), zot(yt) && (yt = oi.close != null ? oi.close : null), zot(pt) && (pt = oi.closeColor != null ? oi.closeColor : null), zot(wt) && (wt = oi.cancelCurrentDrag != null ? oi.cancelCurrentDrag : !1), zot(bt) && (bt = oi.fullSize != null ? oi.fullSize : null), zot(kt) && (kt = oi.fullSizeColor != null ? oi.fullSizeColor : null), zot(dt) && (dt = oi.resizeHandle != null ? oi.resizeHandle : null), zot(gt) && (gt = oi.collapse != null ? oi.collapse : !1), zot(ni) && (ni = oi.collapseColor != null ? oi.collapseColor : null), zot(ti) && (ti = oi.collapsed != null ? oi.collapsed : !1), zot(ii) && (ii = oi.optimize != null ? oi.optimize : !0), ot === !1 && (ot = null), zot(ot) || (zot(ct) && (ct = 30), i = i - ct), ei = this, ei.optimize = ii, this.scrollX = this.scrollY = this.scrollXMax = this.scrollYMax = 0, lr = this.backing = new n.Shape({
                        style: !1
                    }), this.addChild(lr), di = new createjs.Shape, di.type = "WindowBacking", ou = di.graphics, this.addChild(di), u && (su = u), u = this.contentContainer = new n.Container({
                        style: !1
                    }), this.addChild(u), u.mask = di, nt || (bi = new createjs.Shape), o > 0 && (gi = new createjs.Shape, this.addChild(gi)), ir = ot ? 0 : h, hu(), si = this.scrollBar = {}, si.color = v, si.size = 6, si.minSize = si.size * 2, si.spacing = 3.5 + o / 2, si.margin = 0, si.corner = si.size / 2, si.showTime = .5, si.fadeTime = 3, l && (hi = si.horizontal = new n.Shape({
                        style: !1
                    }), cu = hi.graphics, hi.alpha = y, this.addChild(hi), a && hi.drag({
                        localBounds: !0
                    }), ci = si.vertical = new n.Shape({
                        style: !1
                    }), lu = ci.graphics, ci.alpha = y, this.addChild(ci), a && ci.drag({
                        localBounds: !0
                    })), this.update = function() {
                        l && (cu.clear(), lu.clear());
                        fr = l ? si.size + si.spacing * 2 : 0;
                        ar = u.getBounds() ? u.getBounds().width : 0;
                        vr = u.getBounds() ? u.getBounds().height : 0;
                        ki = w && ar > t - rt && (l || c === !0 || c == "auto" || c == "horizontal");
                        yi = b && vr > i - ut && (l || c === !0 || c == "auto" || c == "vertical");
                        ei.scrollXMax = ar + rt * 2 - t + (yi ? fr + si.margin : 0);
                        ei.scrollYMax = vr + ut * 2 - i + (ki ? fr + si.margin : 0);
                        ou.clear();
                        var k = o / 2,
                            d = o / 2,
                            g = t - (yi && l ? si.size + si.spacing * 2 : 0) - (yi ? 0 : o),
                            tt = i - (ki && l ? si.size + si.spacing * 2 : 0) - (ki ? 0 : o);
                        ou.f("rgba(0,0,0,0)").rc(k, d, g, tt, ir, ir, yi && l ? 0 : h, ki && l ? 0 : h);
                        di.setBounds(ei.getBounds().x, ei.getBounds().y, ei.getBounds().width, ei.getBounds().height);
                        n.expand(di, 0);
                        nt || (bi.graphics.c().f("red").dr(k, d, g, tt), u.hitArea = bi);
                        var v = Math.max(h, Math.min(si.corner, si.spacing)),
                            e = v + o / 2,
                            y = v + (yi ? fr : 0) + o / 2,
                            s = v + o / 2,
                            p = v + (ki ? fr : 0) + o / 2,
                            r, f;
                        ki && l && (r = Math.max(si.minSize, (t - e - y) * (t - e - y) / (ar + rt + si.margin)), cu.f(si.color).rr(0, 0, r, si.size, si.corner), hi.x = e, hi.y = i - si.size - si.spacing, du = new n.Proportion(-ei.scrollXMax, 0, e, t - r - y, -1), a && (hi.setBounds(0, 0, r, si.size), f = new createjs.Rectangle(e, hi.y, t - r - e - y, 0), hi.dragBoundary(f), hi.proportion = new n.Proportion(f.x, f.x + f.width, 0, -ei.scrollXMax), hi.off("pressmove", yr), yr = hi.on("pressmove", function() {
                            ei.dispatchEvent("scrolling");
                            bi && (bi.x = -u.x, bi.y = -u.y);
                            u.x = hi.proportion.convert(hi.x);
                            tr()
                        })));
                        yi && l && (r = Math.max(si.minSize, (i - s - p) * (i - s - p) / (vr + ut + si.margin)), lu.f(si.color).rr(0, 0, si.size, r, si.corner), ci.x = t - si.size - si.spacing, ci.y = s, gu = new n.Proportion(-ei.scrollYMax, 0, s, i - r - p, -1), a && (ci.setBounds(0, 0, si.size, r), f = new createjs.Rectangle(ci.x, s, 0, i - r - s - p), ci.dragBoundary(f), ci.proportion = new n.Proportion(f.y, f.y + f.height, 0, -ei.scrollYMax), ci.off("pressmove", pr), pr = ci.on("pressmove", function() {
                            ei.dispatchEvent("scrolling");
                            bi && (bi.x = -u.x, bi.y = -u.y);
                            vi = u.y = ci.proportion.convert(ci.y);
                            tr()
                        })));
                        ru();
                        clearTimeout(ei.d2Timeout);
                        ei.d2Timeout = setTimeout(function() {
                            hi && hi.proportion && (u.x = hi.proportion.convert(hi.x));
                            ci && ci.proportion && (u.y = ci.proportion.convert(ci.y))
                        }, 50);
                        clearTimeout(ei.dTimeout);
                        ei.dTimeout = setTimeout(function() {
                            tu()
                        }, 300);
                        tu();
                        tr()
                    }, this.resize = function(n, r) {
                        var f, e, o;
                        for (zot(n) && (n = t), zot(r) && (r = i), f = 20, ot && (f = wr.x + wr.width + 10), n < f && (n = f), r < 20 && (r = 20), t = n, i = r, hu(), e = 0; e < u.numChildren; e++) o = u.getChildAt(e), o.type == "Wrapper" && tf(o);
                        return ei.update(), vi = u.y, et && cr.immediate(vi), ei.dispatchEvent("resize"), ei
                    }, !zot(ot))
                    if (zot(lt) && (lt = !0), typeof ot == "string" && (ot = new n.Label({
                            text: ot,
                            color: st,
                            size: oi.size != null ? oi.size : 20,
                            backing: "ignore",
                            shadowColor: "ignore",
                            shadowBlur: "ignore",
                            padding: "ignore",
                            backgroundColor: "ignore",
                            group: this.group
                        })), wr = ei.titleBarLabel = ot, zot(ht) && (ht = "rgba(0,0,0,.2)"), ei.titleBar = ot = new n.Container(t, ct, null, null, !1).centerReg(ei).mov(0, -i / 2 - ct / 2), er = ei.titleBar.backing = new n.Rectangle(t + o, ct, ht, null, null, [h * .95, h * .95, 0, 0], !0, null, null, !1).center(ot), wr.center(ot).pos({
                            x: Math.max(h / 2, Math.max(10, s)),
                            reg: !0
                        }), ei.regX = 0, ei.regY = -ct, ei.setBounds(0, -ct, t, i + ct), lt) {
                        ot.cursor = "pointer";
                        ot.on("mousedown", function() {
                            ei.drag({
                                rect: at,
                                currentTarget: !0,
                                onTop: vt
                            })
                        });
                        ot.on("pressup", function() {
                            ei.noDrag(!1)
                        })
                    } else ot.on("mousedown", function() {});
                if (yt) {
                    zot(pt) && (pt = "#555");
                    li = ei.closeIcon = new n.Shape(-40, -40, 80, 80, null, !1);
                    li.graphics.f(pt).p("AmJEVIEUkTIkXkWIB4h5IEWEYIETkTIB4B3IkTESIEQERIh4B4IkRkRIkSEVg");
                    ot ? li.centerReg(ei).scaleTo(ot, null, 50).pos({
                        x: t - Math.max(h / 2, 10) - li.width / 2,
                        y: ct / 2,
                        reg: !0
                    }).expand(40) : li.sca(.3).pos(Math.max(h / 2, 10) / 2, li.height / 2, !0, !1, ei).expand(40);
                    li.cursor = "pointer";
                    li.expand();
                    li.on((zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click", function() {
                        var n = ei.stage;
                        ei.removeFrom();
                        ei.dispatchEvent("close");
                        n && n.update()
                    })
                }
                if (!zot(ot)) {
                    if (bt) {
                        ei.fullSize = function(n) {
                            if (zot(n) && (n = !0), n == ur || !ei.parent) return ei;
                            n ? (br = ei.width, kr = ei.height, dr = ei.x, gr = ei.y, ei.resize(ei.parent.width, ei.parent.height), ei.x = 0, ei.y = 0, ur = !0, au.alpha = 1, ai.getChildAt(0).alpha = .01, ei.dispatchEvent("fullsize")) : (ei.resize(br, kr - ot.height), ei.x = dr, ei.y = gr, ur = !1, au.alpha = 0, ai.getChildAt(0).alpha = 1, ei.dispatchEvent("originalsize"));
                            ei.stage && ei.stage.update()
                        };
                        zot(kt) && (kt = "#555");
                        ai = ei.fullSizeIcon = new n.Rectangle(80, 80, n.faint, kt, 16);
                        au = (new n.Shape).s(kt).ss(16).mt(-19.6, -20.6).lt(-19.6, -40).lt(40, -40).lt(40, 20.7).lt(19.6, 20.7).lt(19.6, 40).lt(-40, 40).lt(-40, -20.6).lt(-19.6, -20.6).lt(19.6, -20.6).lt(19.6, 20.7).addTo(ai).mov(40, 40).alp(0);
                        ai.centerReg(ei).scaleTo(ot, null, 42).pos({
                            x: t - Math.max(h / 2, 10) - ai.width / 2,
                            y: ct / 2,
                            reg: !0
                        }).expand(40);
                        li && ai.mov(-li.width - 10);
                        ai.cursor = "pointer";
                        ai.expand();
                        ur = !1;
                        br = t;
                        kr = i;
                        dr = ei.x;
                        gr = ei.y;
                        ai.on((zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click", function() {
                            ur ? ei.fullSize(!1) : ei.fullSize(!0)
                        })
                    }
                    if (gt) {
                        nr = ti;
                        ei.collapse = function(n) {
                            if (zot(n) && (n = !0), n == nr) return ei;
                            n ? (pi.rot(180), ei.backing.visible = !1, ei.contentContainer.visible = !1, di.visible = !1, hi && (hi.visible = !1), hi && (ci.visible = !1), gi && (gi.visible = !1), nr = !0, er.sha(tt, 5, 5, it), ei.dispatchEvent("collapse")) : (pi.rot(0), ei.backing.visible = !0, ei.contentContainer.visible = !0, di.visible = !0, hi && (hi.visible = !0), hi && (ci.visible = !0), gi && (gi.visible = !0), nr = !1, er.sha(null), ei.dispatchEvent("expand"));
                            ei.stage && ei.stage.update()
                        };
                        zot(ni) && (ni = "#555");
                        pi = ei.collapseIcon = new n.Triangle(90, 90, 90, n.faint, ni, 16);
                        pi.centerReg(ei).scaleTo(ot, null, 42).pos({
                            x: t - Math.max(h / 2, 10) - pi.width / 2,
                            y: ct / 2,
                            reg: !0
                        }).expand(40);
                        li && pi.mov(-li.width - 10);
                        ai && pi.mov(-ai.width - 10);
                        pi.cursor = "pointer";
                        pi.expand();
                        nr = !1;
                        br = t;
                        kr = i;
                        dr = ei.x;
                        gr = ei.y;
                        pi.on((zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click", function() {
                            nr ? ei.collapse(!1) : ei.collapse(!0)
                        })
                    }
                }
                if (dt) {
                    or = ei.resizeHandle = new n.Rectangle(25, 25, n.grey, n.white).alp(.01).centerReg().rot(45).hov(.5).loc(0, 0, ei).mov(ei.width, ei.height - (ei.titleBar ? ei.titleBar.height : 0)).drag();
                    or.on("pressmove", function() {
                        ei.resize(or.x, or.y)
                    });
                    or.on("pressup", nf);
                    if (ei.titleBar) ei.titleBar.on("pressup", nf)
                }
                if (this.add = function(n, t, i, r) {
                        var e, f;
                        if (e = zob(ei.add, arguments, "obj, index, center, replace", ei)) return e;
                        if (f = n, !f.getBounds()) {
                            zogy("Window.add() - please add content with bounds set");
                            return
                        }
                        return cf(f), zot(t) && (t = u.numChildren), r && (t = 0, ei.removeAll()), i ? (f.center(ei).addTo(u, t).mov(0, ct ? ct / 2 : 0), u.height > ei.height - (ct ? ct : 0) && f.loc(null, 0), u.width > ei.width && f.loc(0)) : f.addTo(u, t), f.type == "Wrapper" && (ci.alpha = 0, w = !1, f.wrapperLastAlpha = f.alpha, f.alpha = 0, this.added(function() {
                            tf(f);
                            ei.resize();
                            hi.alpha = 1;
                            ci.alpha = 1
                        })), f.x == 0 && (f.x = rt), f.y == 0 && (f.y = ut), ei.update(), ei
                    }, su && (nu = n.makeContent(su, t), rf = ["header", "message", "text", "display", "buttons", "config"], rf.forEach(function(n) {
                        nu[n] && (ei[n] = nu[n])
                    }), ei.label = ei.message, ei.add(nu, 0, !0)), this.remove = function(n) {
                        return u.removeChild(n), ei.update(), ei
                    }, this.removeAll = function() {
                        return u.removeAllChildren(), ei.update(), ei
                    }, sr = !1, c) u.on("mousedown", function() {
                    sr || n.Ticker.add(iu, u.stage);
                    sr = !0;
                    ki && l && p && n.animate(hi, {
                        alpha: y
                    }, si.showTime);
                    yi && l && p && n.animate(ci, {
                        alpha: y
                    }, si.showTime)
                });
                this.on("added", function() {
                    vu(50)
                }, null, !0);
                if (this.cancelCurrentDrag = function() {
                        ei.contentContainer && ei.contentContainer.noDrag(!1);
                        setTimeout(function() {
                            u && (n.drag({
                                obj: u,
                                currentTarget: !0,
                                localBounds: !0,
                                slide: k,
                                slideDamp: d,
                                slideSnap: w && (c === !0 || c == "auto" || c == "horizontal") || b && (c === !0 || c == "auto" || c == "vertical") ? g : !1
                            }), u.getBounds() && u.getBounds().width > 0 && tu())
                        }, 300)
                    }, this.added(function(t) {
                        wi = t;
                        yu = wi.on("stagemousemove", function(t) {
                            ei.windowMouseX = t.stageX / n.scaX;
                            ei.windowMouseY = t.stageY / n.scaY
                        })
                    }), k) u.on("slidestop", uu);
                else u.on("mousedown", function() {
                    u.stage.on("stagemouseup", uu, null, !0)
                });
                wt && (ei.blurEvent = function() {
                    ei.cancelCurrentDrag();
                    uu()
                }, document.WW.addEventListener("blur", ei.blurEvent));
                var rr = !1,
                    fu, uf = 0,
                    ff = 0,
                    ef = 0,
                    of = 0,
                    lf = 300,
                    eu = 2;
                if (nt) {
                    u.on("mousedown", function(t) {
                        wi = t.target.stage;
                        sf = t.stageX / n.scaX;
                        hf = Date.now()
                    });
                    u.on("click", function(t) {
                        Date.now() - hf < 600 && Math.abs(t.stageX / n.scaX - sf) < 5 && (ei.contentMouse = u.globalToLocal(t.stageX / n.scaX, t.stageY / n.scaY), ei.dispatchEvent("select"))
                    });
                    u.on("mouseover", af);
                    u.on("mouseout", vf)
                }
                vi = ei.scrollY;
                ei.scrollWindow = function(t) {
                    if (yi && ei.stage && ei.hitTestPoint(ei.windowMouseX, ei.windowMouseY) && ei.contains(ei.stage.getObjectUnderPoint(ei.windowMouseX * n.scaX, ei.windowMouseY * n.scaY))) {
                        zot(t) && (t = event);
                        var i = t.detail ? t.detail * -19 : t.wheelDelta;
                        zot(i) && (i = t.deltaY * -19);
                        vi += i;
                        vi = Math.max(-ei.scrollYMax, Math.min(0, vi));
                        et || (ei.scrollY = vi, u.stage.update())
                    }
                    ii && tr()
                };
                ft && (WW.addEventListener("mousewheel", ei.scrollWindow), WW.addEventListener("wheel", ei.scrollWindow), WW.addEventListener("DOMMouseScroll", ei.scrollWindow));
                pu = !1;
                this._enabled = !0;
                Object.defineProperty(ei, "enabled", {
                    get: function() {
                        return ei._enabled
                    },
                    set: function(t) {
                        t ? vu() : (clearTimeout(ei.dTimeout), n.noDrag(u));
                        r(ei, t)
                    }
                });
                this._scrollEnabled = !0;
                Object.defineProperty(ei, "scrollEnabled", {
                    get: function() {
                        return ei._scrollEnabled
                    },
                    set: function(t) {
                        t ? (vu(), a && (yr && (hi.mouseEnabled = !0), pr && (ci.mouseEnabled = !0)), WW.addEventListener("mousewheel", ei.scrollWindow), WW.addEventListener("wheel", ei.scrollWindow), WW.addEventListener("DOMMouseScroll", ei.scrollWindow)) : (clearTimeout(ei.dTimeout), n.noDrag(u), a && (yr && (hi.mouseEnabled = !1), pr && (ci.mouseEnabled = !1)), WW.removeEventListener("mousewheel", ei.scrollWindow), WW.removeEventListener("wheel", ei.scrollWindow), WW.removeEventListener("DOMMouseScroll", ei.scrollWindow));
                        ei._scrollEnabled = t
                    }
                });
                Object.defineProperty(ei, "scrollX", {
                    get: function() {
                        return u.x
                    },
                    set: function(n) {
                        u.x = n;
                        clearTimeout(ei.d2Timeout);
                        u.zimDragImmediate && u.zimDragImmediate(u.x, u.y);
                        ru()
                    }
                });
                Object.defineProperty(ei, "scrollY", {
                    get: function() {
                        return u.y
                    },
                    set: function(n) {
                        u.y = vi = n;
                        et && cr.immediate(vi);
                        clearTimeout(ei.d2Timeout);
                        u.zimDragImmediate && u.zimDragImmediate(u.x, u.y);
                        ru()
                    }
                });
                Object.defineProperty(ei, "backgroundColor", {
                    get: function() {
                        return f
                    },
                    set: function(n) {
                        f = n;
                        hu()
                    }
                });
                Object.defineProperty(ei, "fullSized", {
                    get: function() {
                        return ur
                    },
                    set: function(n) {
                        ei.fullSize && ei.fullSize(n)
                    }
                });
                Object.defineProperty(ei, "collapsed", {
                    get: function() {
                        return nr
                    },
                    set: function(n) {
                        ei.collapse && ei.collapse(n)
                    }
                });
                ti && (nr = !1, ei.collapsed = !0);
                ei.titleBar && (ei.collapseEvent = ei.titleBar.on("dblclick", function() {
                    ei.collapsed = !ei.collapsed
                }));
                ri !== !1 && n.styleTransforms(this, oi);
                this.clone = function(r) {
                    zot(r) && (r = !0);
                    var u = ei.cloneProps(new n.Window(t, i, null, f, bu, ku, s, h, c, l, a, si.color, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, dt, gt, ni, ti, ii, ri, ui, fi));
                    return r && (ei.contentContainer.cloneChildren(u.contentContainer), u.update()), u
                };
                this.doDispose = function(t, i, r) {
                    return ft && (WW.removeEventListener("mousewheel", ei.scrollWindow), WW.removeEventListener("wheel", ei.scrollWindow), WW.removeEventListener("DOMMouseScroll", ei.scrollWindow)), u && (ei.zDE && u.off(ei.zDE), ei.zME && u.off(ei.zME), ei.zSTA && u.off(ei.zSTA), ei.zSTO && u.off(ei.zSTO), ei.zTI && n.Ticker.remove(ei.zTI)), ei.titleBar && ei.titleBar.removeAllEventListeners(), yu && wi && wi.off("stagemousemove", yu), ei.resizeHandle && ei.resizeHandle.removeAllEventListeners(), ei.blurEvent && WW.removeEventListener("blur", ei.blurEvent), typeof hr != "undefined" && n.Ticker.remove(hr), zot(iu) || n.Ticker.remove(iu), r || this.zimContainer_dispose(!0), u = ei.contentContainer = null, !0
                }
            }, n.extend(n.Window, n.Container, ["clone", "dispose"], "zimContainer", !1), n.Window.prototype.dispose = function(n) {
                return this.doDispose(null, null, n)
            }, n.Page = function(t, i, r, u, f, e, o, s, h, c, l) {
                var y, a, v, p;
                if (y = zob(n.Page, arguments, "width, height, color, color2, vertical, pattern, scalePattern, cache, style, group, inherit", this)) return y;
                z_d("58.3");
                this.group = c;
                a = h === !1 ? {} : n.getStyle("Page", this.group, l);
                zot(t) && (t = a.width != null ? a.width : WW.zdf.width);
                zot(i) && (i = a.height != null ? a.height : WW.zdf.height);
                this.zimContainer_constructor(0, 0, t, i, !1);
                this.type = "Page";
                v = this;
                zot(f) && (f = a.vertical != null ? a.vertical : !0);
                zot(r) && (r = a.color != null ? a.color : n.light);
                zot(u) && (u = a.color2 != null ? a.color2 : null);
                zot(e) && (e = a.pattern != null ? a.pattern : null);
                zot(o) && (o = a.scalePattern != null ? a.scalePattern : "fill");
                zot(s) && (s = a.cache != null ? a.cache : !1);
                zot(u) || (r = new n.GradientColor([r, u], [0, 1], 0, 0, f ? 0 : t, f ? i : 0), u = null);
                p = this.backing = new n.Rectangle({
                    width: t,
                    height: i,
                    color: r,
                    style: !1
                }).addTo(this);
                !zot(s) || zot(u) && zot(e) || (s = !0);
                s && p.cache();
                zot(e) || (this.pattern = e.addTo(this), o && e.scaleTo(this, 100, 100, o).center(this), s && e.cache());
                Object.defineProperty(v, "color", {
                    get: function() {
                        return r
                    },
                    set: function(n) {
                        zot(n) && (n = "black");
                        r = n;
                        v.backing.color = n
                    }
                });
                h !== !1 && n.styleTransforms(this, a);
                this.clone = function(a) {
                    zot(a) && (a = !1);
                    r.type && (u = null);
                    var y = v.cloneProps(new n.Page(t, i, r, u, f, e, o, s, h, c, l));
                    return a && v.cloneChildren(y), y
                }
            }, n.extend(n.Page, n.Container, ["clone"], "zimContainer", !1), n.Layer = function(i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht) {
                var wt, lt, ct, pt, yt, bt, kt;
                if (wt = zob(n.Layer, arguments, "width, height, titleBar, titleBarContainer, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, borderWidth, borderColor, dashed, transformObject, titleBarWidth, titleBarHeight, titleBarX, titleBarY, titleBarDraggable, close, closeColor, closeBackgroundColor, closeIndicatorColor, anchor, style, group, inherit", this)) return wt;
                z_d("58.5");
                this.group = st;
                lt = ot === !1 ? {} : n.getStyle("Layer", this.group, ht);
                zot(i) && (i = lt.width != null ? lt.width : 500);
                zot(r) && (r = lt.height != null ? lt.height : 500);
                this.zimContainer_constructor(0, 0, i, r, !1);
                this.type = "Layer";
                ct = this;
                ct.distX = 40;
                ct.distY = 0;
                zot(u) && (u = lt.titleBar != null ? lt.titleBar : "LAYER");
                var dt = u,
                    vt = u,
                    at = !0;
                if (zot(e) && (e = lt.backgroundColor != null ? lt.backgroundColor : "#eee"), zot(o) && (o = lt.rollBackgroundColor != null ? lt.rollBackgroundColor : "#fff"), zot(s) && (s = lt.selectedBackgroundColor != null ? lt.selectedBackgroundColor : "#666"), zot(c) && (c = lt.color != null ? lt.color : "#666"), zot(l) && (l = lt.rollColor != null ? lt.rollColor : "#666"), zot(a) && (a = lt.selectedColor != null ? lt.selectedColor : "#ddd"), zot(y) && (y = lt.borderWidth != null ? lt.borderWidth : 1), zot(p) && (p = lt.borderColor != null ? lt.borderColor : e), (p < 0 || y < 0) && (p = y = null), zot(w) && (w = lt.dashed != null ? lt.dashed : !0), zot(b) && (b = lt.titleBar != null ? lt.titleBar : null), zot(k) && (k = lt.titleBarWidth != null ? lt.titleBarWidth : 100), pt = k, zot(d) && (d = lt.titleBarHeight != null ? lt.titleBarHeight : 40), zot(g) && (g = lt.titleBarX != null ? lt.titleBarX : null), zot(nt) && (nt = lt.titleBarY != null ? lt.titleBarY : null), zot(tt) && (tt = lt.titleBarDraggable != null ? lt.titleBarDraggable : !0), zot(it) && (it = lt.close != null ? lt.close : !0), zot(rt) && (rt = lt.closeColor != null ? lt.closeColor : s), zot(ut) && (ut = lt.closeBackgroundColor != null ? lt.closeBackgroundColor : s), zot(ft) && (ft = lt.closeIndicatorColor != null ? lt.closeIndicatorColor : a), zot(et) && (et = lt.anchor != null ? lt.anchor : !0), tt || (et = !1), ct.anchor = et, it && (k += 30), b = n.merge({
                        borderColor: s
                    }, b, {
                        events: !0,
                        visible: !1,
                        ghostColor: p,
                        ghostWidth: y,
                        ghostDashed: w,
                        ghostHidden: !0
                    }), zot(f) && (f = lt.titleBarContainer != null ? lt.titleBarContainer : null), zot(f))
                    if (WW.zdf) f = WW.zdf.stage;
                    else {
                        zogy("zim Layer(): Please pass in a reference to a container with bounds set.");
                        return
                    }
                ct.active = !1;
                ct.turnOff = function() {
                    ct.active = !1;
                    it && (ct.checkBox.visible = !1);
                    ct.transformControls.remove();
                    ct.mouseChildren = !0;
                    ct.button.backgroundColor = e;
                    ct.button.rollBackgroundColor = o;
                    ct.button.color = c;
                    ct.button.rollColor = c;
                    ct.transformControls.allowToggleOff();
                    ct.resizeChildren && ct.resizeChildren()
                };
                ct.turnOn = function() {
                    ct.active = !0;
                    it && (ct.checkBox.visible = !0, ct.checkBox.checked = !0);
                    ct.button.backgroundColor = s;
                    ct.button.rollBackgroundColor = s;
                    ct.button.color = a;
                    ct.button.rollColor = a;
                    ct.mouseChildren = !1;
                    ct.transformControls.add();
                    ct.transformControls.allowToggleOn()
                };
                ct.titleBarPos = function(n, t) {
                    if (ct.titleBar) return ct.titleBar.pos ? (ct.titleBar.pos(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]), yt.update()) : (ct.distX = n, ct.distY = t), at = !1, ct
                };
                bt = ct.visible;
                ct.visible = !1;
                kt = t();
                this.added(function(t) {
                    yt = t;
                    ct.transform(b);
                    y >= 0 && ct.transformControls.hideGhost();
                    setTimeout(function() {
                        function p() {
                            return ct.localToLocal(0, 0, f)
                        }

                        function s(n) {
                            if (at && tt) {
                                var t = f.localToLocal(i.x - ct.distX, i.y - ct.distY, ct.parent),
                                    u = ct.localToLocal(ct.regX, ct.regY, ct.parent),
                                    e = ct.localToLocal(0, 0, ct.parent);
                                ct.x = t.x + (u.x - e.x);
                                ct.y = t.y + (u.y - e.y);
                                ct.transformControls.resize(n);
                                r(ct);
                                ct.stage && ct.stage.update()
                            }
                        }

                        function r(n) {
                            n.loop(function(n) {
                                n.type == "Layer" && (ct.titleBarDraggable && n.move(), n.transformControls.ghost && n.transformControls.resize(), r(n))
                            })
                        }

                        function h() {
                            return i.x == 0 ? !0 : i.y == i.height ? !0 : i.x == f.width - i.width ? !0 : i.y == f.height ? !0 : void 0
                        }

                        function w() {
                            ct.toggled ? (f.loop(function(n) {
                                n && n != i && n.layer && n.layer.turnOff && n.layer.active && n.layer.turnOff()
                            }), ct.turnOn(), ct.dispatchEvent("transformshow")) : (i.top(), ct.turnOff(), f.loop(function(n) {
                                n && n != i && n.layer && n.layer.turnOff && n.layer.active && n.layer.turnOff()
                            }), ct.dispatchEvent("transformhide"));
                            ct.stage && ct.stage.update()
                        }
                        var i, a, v, u;
                        ct.visible = bt;
                        y >= 0 && setTimeout(function() {
                            ct.transformControls.showGhost();
                            ct.stage && ct.stage.update()
                        }, 200);
                        yt = t;
                        i = ct.titleBar = new n.Container(k, d).reg(0, d).loc(ct, null, f).mov(ct.distX, ct.distY);
                        tt && i.drag({
                            all: !0,
                            boundary: new n.Boundary(0, d, f.width - k, f.height - d),
                            localBounds: !0
                        });
                        (ct.distX != 40 || ct.distY != 0) && i.pos(ct.distX, ct.distY);
                        it && (ct.checkBox = new n.CheckBox({
                            borderColor: rt,
                            backgroundColor: ut,
                            indicatorColor: ft,
                            size: 20,
                            startChecked: !0
                        }).center(i).pos(0, null, !0).change(function() {
                            ct.turnOff();
                            ct.dispatchEvent("transformhide")
                        }), ct.checkBox.visible = !1);
                        i.mouseChildren = !0;
                        i.layer = ct;
                        ct.resetTitleBar = function() {
                            ct.distX = 40;
                            ct.distY = 0;
                            at = !0;
                            ct.move(!0);
                            ct.stage && ct.stage.update()
                        };
                        (typeof vt == "string" || typeof vt == "number") && (vt = new n.Label({
                            text: vt,
                            color: c,
                            rollColor: l,
                            size: lt.size != null ? lt.size : 18,
                            group: this.group
                        }));
                        ct.label = vt;
                        ct.label.center(i);
                        ct.button = new n.Button({
                            shadowBlur: -1,
                            width: pt,
                            height: d - 1,
                            label: ct.label,
                            color: c,
                            rollColor: l,
                            backgroundColor: e,
                            rollBackgroundColor: o,
                            corner: lt.corner != null ? lt.corner : 0,
                            inherit: n.copy(lt)
                        }).addTo(i);
                        ct.button.on("mousedown", function() {
                            f.loop(function(n) {
                                n && n != i && n.layer && n.layer.turnOff && n.layer.active && n.layer.turnOff()
                            });
                            ct.active || (ct.turnOn(), ct.dispatchEvent("transformshow"));
                            i.top()
                        });
                        ct.button.on("pressmove", function() {
                            s()
                        });
                        ct.button.on("pressup", function() {
                            s(!0);
                            var n = ct.localToLocal(0, 0, f);
                            ct.distX = i.x - n.x;
                            ct.distY = i.y - n.y;
                            i.top();
                            !h() && tt && (n = ct.localToGlobal(0, 0), ct.button.hitTestPoint(n.x, n.y) && ct.resetTitleBar())
                        });
                        ct.button.on("dblclick", function() {
                            tt && ct.resetTitleBar()
                        });
                        ct.turnOff();
                        ct.on("transformed", function(n) {
                            (n.transformType == "move" || n.transformType == "size" || n.transformType == "stretch" || n.transformType == "rotate") && (tt && ct.move(), r(ct))
                        });
                        ct.move = function(n) {
                            (n || at || !ct.anchor || !h()) && (i.loc(p()).mov(ct.distX, ct.distY), i.x < 0 && (at = !1, i.x = 0), i.y < i.height && (at = !1, i.y = i.height), i.x > f.width - i.width && (at = !1, i.x = f.width - i.width), i.y > f.height && (at = !1, i.y = f.height), ct.anchor || (at = !0))
                        };
                        ct.on("transformhide", function() {
                            ct.turnOff();
                            f.loop(function(n) {
                                n && n != i && n.layer && n.layer.turnOff && n.layer.active && n.layer.turnOff()
                            })
                        });
                        ct.resizeChildren = function(n) {
                            ct.transformControls.resize(n);
                            ct.loop(function(n) {
                                n.transformControls && (n.transformControls.visible && n.transformControls.hide(), n.type == "Layer" ? n.resizeChildren() : n.transformControls.resize())
                            })
                        };
                        ct.resize = function(n) {
                            return ct.move(), ct.resizeChildren(n), ct
                        };
                        ct.toggled = !1;
                        ct.toggle = function(n) {
                            return ct.toggled = zot(n) ? !ct.toggled : n, w(), ct
                        };
                        Object.defineProperty(ct, "titleBarDraggable", {
                            get: function() {
                                return tt
                            },
                            set: function(t) {
                                tt = t;
                                tt ? i.drag({
                                    all: !0,
                                    boundary: n.Boundary(0, 40, f.width - k, f.height - d),
                                    localBounds: !0
                                }) : i.noDrag(!1)
                            }
                        });
                        ct.stageUpEvent = yt.on("stagemouseup", function() {
                            ct.transformControls.visible && i.top()
                        });
                        zot(g) && zot(nt) || (at = !1, a = zot(g) ? i.x : g, v = zot(nt) ? i.y - d : nt, ct.titleBarStartX = g, ct.titleBarStartY = nt, ct.titleBarPos(a, v), u = ct.parent.localToLocal(ct.x, ct.y, f), ct.distX = i.x - u.x, ct.distY = i.y - u.y)
                    }, 50)
                }, kt == "s" ? .05 : 50);
                ot !== !1 && n.styleTransforms(this, lt);
                this.clone = function() {
                    return ct.cloneProps(new n.Layer(i, r, dt, f, e, o, s, h, c, l, a, v, y, p, w, b, pt, d, g, nt, tt, it, rt, ut, ft, et, ot, this.group, ht))
                };
                this.dispose = function(n, t, i) {
                    return ct.stageUpEvent && yt.off("stagemouseup", ct.stageUpEvent), f && f.loop(function(n) {
                        n.layer = null
                    }), ct.transformControls.dispose(), ct.transformControls = null, i || this.zimContainer_dispose(!0), ct.titleBar.layer = null, ct.titleBar.dispose(), ct.checkBox = ct.button = null, u = ct.titleBar = b = null, !0
                }
            }, n.extend(n.Layer, n.Container, ["clone", "dispose"], "zimContainer", !1), n.Waiter = function(i, r, u, f, e, o, s, h, c, l, a) {
                var ht, y, rt, v, ft, b, et, g, k, nt, it, ot, st;
                if (ht = zob(n.Waiter, arguments, "container, speed, foregroundColor, backgroundColor, corner, shadowColor, shadowBlur, fadeTime, style, group, inherit", this)) return ht;
                z_d("59");
                this.zimContainer_constructor(null, null, null, null, !1);
                this.type = "Waiter";
                this.group = l;
                y = c === !1 ? {} : n.getStyle(this.type, this.group, a);
                rt = t(r);
                zot(r) && (r = y.speed != null ? y.speed : rt == "s" ? .6 : 600);
                zot(u) && (u = y.foregroundColor != null ? y.foregroundColor : "white");
                zot(f) && (f = y.backgroundColor != null ? y.backgroundColor : "orange");
                zot(e) && (e = y.corner != null ? y.corner : 16);
                zot(o) && (o = y.shadowColor != null ? y.shadowColor : "rgba(0,0,0,.3)");
                zot(s) && (s = y.shadowBlur != null ? y.shadowBlur : 14);
                zot(h) && (h = y.fadeTime != null ? y.fadeTime : 0);
                var d = 40,
                    p = 3,
                    w = d * .6 / 2,
                    ut = (d - w * 2) / 2,
                    tt = p * (w * 2 + ut) + ut;
                this.setBounds(-tt / 2, -d / 2, tt, d);
                v = this;
                b = this.display = new n.Shape({
                    style: !1
                });
                this.addChild(b);
                b.setBounds(0, 0, tt, d);
                b.regX = tt / 2;
                b.regY = d / 2;
                et = b.graphics;
                et.f(f);
                g = e;
                Array.isArray(g) || (g = [e, e, e, e]);
                et.rc(0, 0, tt, d, g[0], g[1], g[2], g[3]);
                o != -1 && s > 0 && (b.shadow = new createjs.Shadow(o, 3, 3, s));
                b.on("click", function(n) {
                    n.stopImmediatePropagation()
                });
                for (k = new n.Container({
                        style: !1
                    }), this.addChild(k), it = 0; it < p; it++) nt = new createjs.Shape, nt.graphics.f(u).dc(0, 0, w), nt.x = (it - (p - 1) / 2) * (w * 2 + ut), k.addChild(nt), nt.cache(-w, -w, w * 2, w * 2), nt.alpha = 0;
                this.hide = function() {
                    function n() {
                        if (v.parent && v.parent.removeChild(v), ft = v.stage, ft && ft.update(), v.zimAccessibility) {
                            var n = v.zimAccessibility;
                            n.resize(v);
                            ot ? ot.focus() : v.zimTabTag.nextSibling.focus();
                            setTimeout(function() {
                                n.talk("Waiter has finished.")
                            }, 50)
                        }
                    }
                    return h > 0 ? v.animate({
                        obj: {
                            alpha: 0
                        },
                        time: h,
                        call: n
                    }) : n(), v.toggled = !1, v
                };
                st = [];
                this.show = function() {
                    var e = "zim display - Waiter(): Please pass in a reference to a container with bounds set as first parameter to Waiter",
                        o, f, n, u, t;
                    if (zot(i))
                        if (WW.zdf) i = WW.zdf.stage;
                        else {
                            zogy(e);
                            return
                        }
                    else if (i.getBounds) {
                        if (zot(i.stage)) {
                            zogy("zim display - Waiter(): The container must have a stage property");
                            return
                        }
                    } else {
                        zogy(e);
                        return
                    }
                    for (f = 0, n = r * (rt == "s" ? 1e3 : 1), u = 0; u < k.numChildren; u++) k && st.push(setTimeout(function() {
                        o = k.getChildAt(f);
                        createjs.Tween.get(o, {
                            loop: !0
                        }).to({
                            alpha: 1
                        }, n / p / 2).wait(n / p).to({
                            alpha: 0
                        }, n / p).wait(n - n / p - n / p / 2);
                        f++
                    }, u * n / p));
                    return v.ticker = createjs.Ticker.on("tick", function() {
                        i.stage.update()
                    }), v.x = i.getBounds().width / 2, v.y = i.getBounds().height / 2, i.addChild(v), h > 0 && (v.alpha = 0, v.animate({
                        alpha: 1
                    }, h)), v.zimAccessibility && (t = v.zimAccessibility, setTimeout(function() {
                        t.activatedObject && (ot = t.activatedObject.zimTabTag)
                    }, 50), t.resize(v), t.talk(v.zimTabTag.getAttribute("aria-label"))), v.toggled = !0, v
                };
                v.toggle = function(n) {
                    return n === !0 ? v.show() : n === !1 ? v.hide() : v.parent ? v.hide() : v.show(), v
                };
                c !== !1 && n.styleTransforms(this, y);
                this.clone = function() {
                    return v.cloneProps(new n.Waiter(i, r, u, f, e, o, s, h, c, this.group, a))
                };
                this.dispose = function(n, t, i) {
                    var r, u;
                    for (v.ticker && createjs.Ticker.off("tick", v.ticker), createjs.Tween.removeTweens(v), v.removeFrom(), r = 0; r < k.numChildren; r++) u = k.getChildAt(r), clearInterval(st[r]), createjs.Tween.removeTweens(u);
                    return i || this.zimContainer_dispose(!0), !0
                }
            }, n.extend(n.Waiter, n.Container, ["clone", "dispose"], "zimContainer", !1), n.ProgressBar = function(r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it) {
                function kt(t) {
                    var i, r;
                    return rt.backing ? (i = rt.getChildIndex(rt.backing), rt.removeChild(rt.backing)) : i = rt.numChildren, rt.border && rt.removeChild(rt.border), zot(t) || t.type != "Pattern" ? t = rt.backing = zot(t) ? new n.Rectangle(ft, ot, f, e, o, v, null, null, null, !1).addTo(rt, i) : w.addTo(rt, i) : (r = t, t = rt.backing = new n.Rectangle(ft, ot, f, null, null, v, null, null, null, !1).addTo(rt, i), t.pattern = r, r.center(t), r.setMask(t.shape), o && (rt.border = new n.Rectangle(ft, ot, "rgba(0,0,0,0)", e, o, v, null, null, null, !1).addTo(rt, i + 1))), t
                }

                function pt(n) {
                    r == "circle" ? ht.graphics.c().mt(0, 0).s(u).ss(o - s * 2 + .5).a(0, 0, ft, 0, 360 * n / 100 * Math.PI / 180) : (vt.sca(n / 100, 1), ht.setMask(vt));
                    zot(a) || (h.text = h.startText + " " + Math.min(Math.round(n), 100) + "%");
                    g && k && Math.round(n) >= 100 && (rt.timeOut = setTimeout(function() {
                        rt.hide()
                    }, 200));
                    !rt.dispatched && Math.round(n) >= 100 && (rt.dispatchEvent("complete"), rt.dispatched = !0, setTimeout(function() {
                        rt && (rt.dispatched = !1)
                    }, 100));
                    rt.stage && rt.stage.update()
                }
                var wt, ut, st, ft, ht, bt, et, ct, vt, yt, lt;
                if (wt = zob(n.ProgressBar, arguments, "barType, foregroundColor, backgroundColor, borderColor, borderWidth, padding, label, color, labelPosition, percentage, corner, shadowColor, shadowBlur, backing, delay, fastClose, container, autoHide, style, group, inherit", this)) return wt;
                z_d("59.5");
                this.zimContainer_constructor(null, null, null, null, !1);
                this.type = "ProgressBar";
                this.group = tt;
                ut = nt === !1 ? {} : n.getStyle(this.type, this.group, it);
                zot(u) && (u = ut.foregroundColor != null ? ut.foregroundColor : "#acd241");
                zot(f) && (f = ut.backgroundColor != null ? ut.backgroundColor : "#444");
                zot(e) && (e = ut.borderColor != null ? ut.borderColor : f);
                zot(o) && (o = ut.borderWidth != null ? ut.borderWidth : null);
                zot(l) && (l = ut.labelPosition != null ? ut.labelPosition : "bottom");
                zot(r) && (r = ut.barType != null ? ut.barType : "circle");
                zot(s) && (s = ut.padding != null ? ut.padding : r == "circle" ? 2 : -.5);
                zot(v) && (v = ut.corner != null ? ut.corner : 15);
                zot(y) && (y = ut.shadowColor != null ? ut.shadowColor : "rgba(0,0,0,.3)");
                zot(p) && (p = ut.shadowBlur != null ? ut.shadowBlur : 14);
                zot(w) && (w = ut.backing != null ? ut.backing.clone() : null);
                zot(k) && (k = ut.fastClose != null ? ut.fastClose : !0);
                e < 0 || o < 0 ? e = o = null : e != null && o == null && (o = r == "circle" ? 10 : 2);
                st = t(b);
                zot(b) && (b = ut.delay != null ? ut.delay : st == "s" ? .1 : 100);
                zot(g) && (g = ut.autoHide != null ? ut.autoHide : !0);
                zot(h) && (h = ut.label != null ? ut.label : null);
                zot(c) && (c = ut.color != null ? ut.color : u);
                (typeof h == "string" || typeof h == "number") && (h = new n.Label({
                    text: h,
                    color: c,
                    backing: "ignore",
                    shadowColor: "ignore",
                    shadowBlur: "ignore",
                    padding: "ignore",
                    backgroundColor: "ignore",
                    group: this.group
                }));
                !zot(a) && zot(h) && (h = new n.Label(""));
                this.label = h;
                var ot = 30,
                    rt = this,
                    at = 0;
                rt.visible = !1;
                setTimeout(function() {
                    rt.visible = !0;
                    rt.stage && rt.stage.update()
                }, b);
                r == "circle" ? (ft = 20, w = this.backing = new n.Circle(ft, "rgba(0,0,0,0)", f, o, null, null, null, null, !1).addTo(rt), ht = this.bar = new n.Shape({
                    style: !1
                }).addTo(rt).loc(w.x, w.y).rot(-90)) : (ft = 200, y != -1 && p > 0 && (bt = new n.Rectangle(ft - 2, ot - 2, f, null, null, v, null, null, null, !1).addTo(this), bt.shadow = new createjs.Shadow(y, 3, 3, p)), w = kt(w), et = v, Array.isArray(et) || (et = [v, v, v, v]), ct = (s + o / 2) * 1.2, ht = this.bar = new n.Rectangle(ft - (s + o / 2) * 1.8, ot - (s + o / 2) * 1.8, u, null, null, [et[0] - ct, et[1] - ct, et[2] - ct, et[3] - ct], null, null, null, !1).center(this), vt = this.mask = new n.Rectangle(ft - (s + o / 2) * 1.8, ot - (s + o / 2) * 1.8, null, null, null, null, null, null, null, !1).center(this).alp(0).sca(0, 1), ht.setMask(vt));
                rt.setBacking = function(n) {
                    kt(n);
                    rt.stage && rt.stage.update()
                };
                w.on("click", function(n) {
                    n.stopImmediatePropagation()
                });
                zot(h) || (h.scaleX = h.scaleY = .8, h.startText = h.text, zot(a) || (h.text = h.startText + "  0%"), h.center(rt), l == "above" ? h.y -= 60 : h.y += 60, h.alpha = .8);
                this.hide = function() {
                    var t = rt.stage,
                        n;
                    return rt.parent && rt.parent.removeChild(rt), rt.backing.type == "Pattern" && rt.backing.pauseInterval && rt.backing.pauseInterval(), t && t.update(), rt.zimAccessibility && (n = rt.zimAccessibility, n.resize(rt), yt ? yt.focus() : rt.zimTabTag.nextSibling.focus(), setTimeout(function() {
                        n.talk("Progress Bar has finished.")
                    }, 50)), rt.toggled = !1, rt
                };
                this.show = function() {
                    var t = "zim display - ProgressBar(): Please pass in a reference to a container with bounds set as first parameter of the ProgressBar",
                        n;
                    if (zot(d))
                        if (WW.zdf) d = WW.zdf.stage;
                        else {
                            zogy(t);
                            return
                        }
                    else if (d.getBounds) {
                        if (zot(d.stage)) {
                            zogy("zim display - Waiter(): The container must have a stage property");
                            return
                        }
                    } else {
                        zogy(t);
                        return
                    }
                    if (rt.timeOut && clearTimeout(rt.timeOut), pt(0), rt.zimActiveLoader) rt.zimActiveLoader.on("progress", function(n) {
                        at = n.progress * 100;
                        pt(at)
                    });
                    return rt.center(d), rt.backing.type == "Pattern" && rt.backing.pauseInterval && rt.backing.pauseInterval(!1), rt.zimAccessibility && (n = rt.zimAccessibility, setTimeout(function() {
                        n.activatedObject && (yt = n.activatedObject.zimTabTag)
                    }, 50), n.resize(rt), n.talk(rt.zimTabTag.getAttribute("aria-label"))), rt.toggled = !0, rt
                };
                rt.toggle = function(n) {
                    return n === !0 ? rt.show() : n === !1 ? rt.hide() : rt.parent ? rt.hide() : rt.show(), rt
                };
                rt.run = function(n, t) {
                    var r, u;
                    return zot(t) || (g = t), zot(n) && (n = st == "s" ? 3 : 3e3), i(n, st), r = n * (st == "s" ? 1e3 : 1), rt.runInterval && clearInterval(rt.runInterval), rt.percent = 0, u = Date.now(), rt.runInterval = setInterval(function() {
                        rt.percent = (Date.now() - u) / r * 100;
                        rt.percent >= 100 && (rt.percent = 100, clearInterval(rt.runInterval))
                    }, 30), rt
                };
                rt.dispatched = !1;
                Object.defineProperty(rt, "percent", {
                    get: function() {
                        return at
                    },
                    set: function(n) {
                        at = n;
                        pt(n)
                    }
                });
                lt = rt.getBounds();
                rt.setBounds(lt.x - 5, lt.y - 5, lt.width + 10, lt.height + 10);
                nt !== !1 && n.styleTransforms(this, ut);
                this.clone = function() {
                    return rt.cloneProps(new n.ProgressBar(r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, this.group, it))
                };
                this.dispose = function(n, t, i) {
                    return rt.backing.type == "Pattern" && rt.backing.clearInterval && rt.backing.clearInterval(), rt.runInterval && clearInterval(rt.runInterval), i || this.zimContainer_dispose(!0), !0
                }
            }, n.extend(n.ProgressBar, n.Container, ["clone", "dispose"], "zimContainer", !1), n.Indicator = function(t, i, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt) {
                function at(t) {
                    var r, i, o;
                    for (t >= u && (t = -1), i = 0; i < u; i++) r = a ? i < t ? f : e : e, i == t && (r = f), o = ft.getChildAt(i), pt && (o.alpha = r == f ? 1 : d), o.color = r;
                    ut.zimAccessibility && ut.zimAccessibility.changeTitle(ut);
                    !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && ut.stage && ut.stage.update()
                }
                var vt, it, ct, ut, et, yt, ft, ht;
                if (vt = zob(n.Indicator, arguments, "width, height, num, foregroundColor, backgroundColor, borderColor, borderWidth, backdropColor, corner, indicatorType, fill, scale, lightScale, interactive, shadowColor, shadowBlur, selectedIndex, backgroundAlpha, style, group, inherit", this)) return vt;
                z_d("60");
                this.zimContainer_constructor(null, null, null, null, !1);
                this.type = "Indicator";
                this.group = nt;
                it = g === !1 ? {} : n.getStyle(this.type, this.group, tt);
                zot(t) && (t = it.width != null ? it.width : 300);
                zot(i) && (i = it.height != null ? it.height : 50);
                zot(u) && (u = it.num != null ? it.num : 6);
                zot(l) && (l = it.indicatorType != null ? it.indicatorType : "dot");
                zot(f) && (f = it.foregroundColor != null ? it.foregroundColor : l == "star" ? n.yellow : l == "heart" ? n.red : "#f58e25");
                zot(e) && (e = it.backgroundColor != null ? it.backgroundColor : "#666");
                e < 0 && (e = it.backgroundColor != null ? it.backgroundColor : "rgba(0,0,0,.01)");
                zot(o) && (o = it.borderColor != null ? it.borderColor : null);
                zot(s) && (s = it.borderWidth != null ? it.borderWidth : null);
                o < 0 || s < 0 ? o = s = null : o != null && s == null && (s = 1);
                zot(h) && (h = it.backdropColor != null ? it.backdropColor : -1);
                zot(c) && (c = it.corner != null ? it.corner : 0);
                zot(a) && (a = it.fill != null ? it.fill : !1);
                zot(v) && (v = it.scale != null ? it.scale : 1);
                zot(y) && (y = it.lightScale != null ? it.lightScale : 1);
                zot(p) && (p = it.interactive != null ? it.interactive : !1);
                zot(w) && (w = it.shadowColor != null ? it.shadowColor : "rgba(0,0,0,.3)");
                zot(b) && (b = it.shadowBlur != null ? it.shadowBlur : 5);
                zot(d) && (d = it.backgroundAlpha != null ? it.backgroundAlpha : .2);
                ct = (zns ? n.ACTIONEVENT == "mousedown" : WW.ACTIONEVENT == "mousedown") ? "mousedown" : "click";
                ut = this;
                this.lights = [];
                h != -1 && (yt = ut.backdrop = new n.Rectangle(t, i, h, o, s, c, null, null, null, !1), this.addChild(yt));
                ft = this.lightsContainer = new n.Container({
                    style: !1
                });
                this.addChild(ft);
                var rt, ot = i * .5,
                    st = t / (u + 1),
                    lt = new createjs.Shape,
                    pt = !1;
                for (l == "square" || l == "box" || l.type == "Emoji" ? lt.graphics.f("black").dr(-st / 2 / y + ot / 2, -i / 2 + ot / 2, st / y, i) : lt.graphics.f("black").dr(-st / 2 / y, -i / 2, st / y, i), ht = 0; ht < u; ht++) l == "square" || l == "box" ? (rt = new n.Rectangle(ot, ot, e, o, s, null, null, null, null, !1), rt.regX = rt.width / 2, rt.regY = rt.height / 2) : l == "star" ? rt = new n.Poly(ot * .6, 5, .5, e, o, s, null, null, !1) : l == "heart" ? rt = new n.Blob({
                    points: [
                        [0, -40.7, 0, 0, -57.3, -76.6, 41.8, -80.3, "mirror"],
                        [100, 0, 0, 0, 23.7, -45.4, -23.7, 45.4, "mirror"],
                        [0, 100, 0, 0, 0, 0, 0, 0, "mirror"],
                        [-100, 0, 0, 0, 21.9, 48.2, -21.9, -48.2, "mirror"]
                    ],
                    color: e,
                    interactive: !1
                }).transformPoints("scale", .15) : l.type == "Emoji" ? (pt = !0, rt = l.clone().reg("center", "center"), rt.myCache = !1) : rt = new n.Circle(ot / 2, e, o, s, null, null, null, null, !1), this.lights.push(rt), rt.znum = ht, rt.scaleX = rt.scaleY = y, rt.hitArea = lt, rt.x = st + st * ht, rt.y = i / 2, ft.addChild(rt);
                ft.setBounds(0, 0, t, i);
                ft.regX = ft.x = t / 2;
                ft.regY = ft.y = i / 2;
                this.addChild(ft);
                w != -1 && b > 0 && (ft.shadow = new createjs.Shadow(w, 2, 2, b));
                p && (ft.cursor = "pointer", ut.lightsEvent = ft.on(ct, function(n) {
                    if (et == n.target.znum) {
                        if (et > 0) return;
                        if (et == 0) {
                            et = -1;
                            at(et);
                            ut.dispatchEvent("change");
                            return
                        }
                    }
                    et = n.target.znum;
                    at(et);
                    ut.dispatchEvent("change")
                }));
                ft.scaleX = ft.scaleY = v;
                Object.defineProperty(this, "selectedIndex", {
                    get: function() {
                        return et
                    },
                    set: function(t) {
                        et = Math.floor(t);
                        et = n.constrain(et, -1, u - 1);
                        at(et)
                    }
                });
                Object.defineProperty(this, "num", {
                    get: function() {
                        return u
                    },
                    set: function() {
                        zon && zogy("Indicator() - num is read only")
                    }
                });
                this._enabled = !0;
                Object.defineProperty(ut, "enabled", {
                    get: function() {
                        return ut._enabled
                    },
                    set: function(n) {
                        r(ut, n)
                    }
                });
                zot(k) && (k = it.selectedIndex != null ? it.selectedIndex : 0);
                ut.selectedIndex = k;
                g !== !1 && n.styleTransforms(this, it);
                this.dispose = function(n, t, i) {
                    i || (ut.lightsEvent && ft.off(ct, ut.lightsEvent), this.zimContainer_dispose())
                };
                this.clone = function() {
                    return ut.cloneProps(new n.Indicator(t, i, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, this.group, tt))
                }
            }, n.extend(n.Indicator, n.Container, ["clone", "dispose"], "zimContainer", !1), n.TextInput = function(t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, dt, gt) {
                function hi() {
                    return arguments
                }
                var oi, ni, ri, ii, si, ti, ui, fi, ei;
                if (oi = zob(n.TextInput, arguments, "width, height, placeholder, text, size, font, color, backgroundColor, borderColor, borderWidth, maxLength, password, selectionColor, selectionAlpha, cursorColor, cursorSpeed, shadowColor, shadowBlur, align, corner, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, multiline, wrap, scrollBarActive, scrollBarDrag, scrollBarColor, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, number, inputType, rtl, uppercase, style, group, inherit", this)) return oi;
                z_d("54.2");
                this.group = dt;
                ni = kt === !1 ? {} : n.getStyle("TextInput", this.group, gt);
                zot(f) && (f = ni.size != null ? ni.size : 36);
                (zot(nt) || nt == "ignore") && (nt = ni.padding != null && nt != "ignore" ? ni.padding : 5);
                zot(tt) && (tt = ni.paddingHorizontal != null ? ni.paddingHorizontal : nt);
                zot(it) && (it = ni.paddingVertical != null ? ni.paddingVertical : nt);
                zot(t) && (t = ni.width != null ? ni.width : 300);
                zot(i) && (i = ni.height != null ? ni.height : f + it * 2);
                zot(r) && (r = ni.placeholder != null ? ni.placeholder : null);
                zot(u) && (u = ni.text != null ? ni.text : "");
                zot(e) && (e = ni.font != null ? ni.font : "arial");
                zot(o) && (o = ni.color != null ? ni.color : n.dark);
                zot(s) && (s = ni.backgroundColor != null ? ni.backgroundColor : n.lighter);
                zot(h) && (h = ni.borderColor != null ? ni.borderColor : null);
                zot(c) && (c = ni.borderWidth != null ? ni.borderWidth : null);
                ri = hi(t, i, r, u, o, s, h);
                t = n.Pick.choose(t);
                i = n.Pick.choose(i);
                r = n.Pick.choose(r);
                u = n.Pick.choose(u);
                o = n.Pick.choose(o);
                s = n.Pick.choose(s);
                h = n.Pick.choose(h);
                zot(v) && (v = ni.selectionColor != null ? ni.selectionColor : o);
                zot(y) && (y = ni.selectionAlpha != null ? ni.selectionAlpha : .2);
                zot(p) && (p = ni.cursorColor != null ? ni.cursorColor : o);
                zot(w) && (w = ni.cursorSpeed != null ? ni.cursorSpeed : .5);
                zot(b) && (b = ni.shadowColor != null ? ni.shadowColor : "rgba(0,0,0,.3)");
                zot(k) && (k = ni.shadowBlur != null ? ni.shadowBlur : 20);
                zot(d) && (d = ni.align != null ? ni.align : "left");
                zot(g) && (g = ni.corner != null ? ni.corner : 0);
                zot(rt) && (rt = ni.shiftHorizontal != null ? ni.shiftHorizontal : 0);
                zot(a) && (a = ni.password != null ? ni.password : !1);
                zot(ut) && (ut = ni.shiftVertical != null ? ni.shiftVertical : a ? f * .25 : 0);
                zot(l) && (l = ni.maxLength != null ? ni.maxLength : d == "center" ? Math.floor(t / f) * 1.8 : null);
                zot(ft) && (ft = ni.multiline != null ? ni.multiline : !1);
                zot(et) && (et = ni.wrap != null ? ni.wrap : !1);
                zot(ot) && (ot = ni.scrollBarActive != null ? ni.scrollBarActive : !1);
                zot(st) && (st = ni.scrollBarDrag != null ? ni.scrollBarDrag : !1);
                zot(ht) && (ht = ni.scrollBarColor != null ? ni.scrollBarColor : h);
                zot(ct) && (ct = ni.scrollBarAlpha != null ? ni.scrollBarAlpha : .3);
                zot(lt) && (lt = ni.scrollBarFade != null ? ni.scrollBarFade : !0);
                zot(at) && (at = ni.scrollBarH != null ? ni.scrollBarH : !0);
                zot(vt) && (vt = ni.scrollBarV != null ? ni.scrollBarV : !0);
                yt && zot(pt) && (pt = "number");
                zot(pt) && (pt = ni.inputType != null ? ni.inputType : "text");
                pt === !0 && (pt = "number");
                st && (lt = ni.scrollBarFade != null ? ni.scrollBarFade : !1);
                zot(wt) && (wt = ni.rtl != null ? ni.rtl : WW.DIR == "rtl" || n.DIR == "rtl" ? "rtl" : null);
                zot(bt) && (bt = ni.uppercase != null ? ni.uppercase : null);
                bt && (u && (u = u.toUpperCase()), r && (r = r.toUpperCase()));
                this.zimWindow_constructor(t, i, null, s, h, c, nt, g, !1, ot, st, ht, ct, lt, at, vt, !1, null, !1, !0, b, k, tt, it, !0, null, null, null, null, null, !1, null, null, null, null, null, null, null, null, null, null, null, null, kt, dt, n.copy(ni));
                this.type = "TextInput";
                ii = this;
                this.placeholderLabel = new n.Label({
                    text: r || "",
                    size: f,
                    color: o,
                    font: e,
                    shiftHorizontal: rt,
                    shiftVertical: ut,
                    valign: "top"
                }).alp(.5);
                u == "" && this.add(this.placeholderLabel);
                si = new n.Rectangle({
                    width: t - nt * 2,
                    height: i - nt * 2,
                    color: n.clear,
                    style: !1
                }).center(this);
                this.cursor = "text";
                ti = this.label = new n.TextInput.LabelInput(u, f, l, a, v, y, p, w, e, o, null, null, null, d, "top", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, rt, ut, null, null, null, null, pt, wt, bt, kt, dt, gt);
                this.add(ti);
                ti.setMask(si);
                this.htmlTag = this.label.hiddenInput;
                this.selection = this.label.selection;
                this.blinker = this.label.blinker;
                d == "right" ? (ti.x = t - tt, this.placeholderLabel.x = t - this.placeholderLabel.width - tt) : d == "center" && (ti.x = t / 2, this.placeholderLabel.x = (t - this.placeholderLabel.width) / 2);
                ui = new n.Rectangle({
                    width: nt,
                    height: i,
                    color: n.clear,
                    style: !1
                }).addTo(this).expand(0);
                ui.on("mousedown", function(n) {
                    ti.onMousedown(n);
                    n.stopImmediatePropagation()
                });
                ui.on("pressmove", function(n) {
                    ti.onPressmove(n);
                    n.stopImmediatePropagation()
                });
                ui.on("dblclick", function(n) {
                    ti.onDblclick(n);
                    n.stopImmediatePropagation()
                });
                fi = new n.Rectangle({
                    width: nt,
                    height: i,
                    color: n.clear,
                    style: !1
                }).pos(0, 0, n.RIGHT, n.TOP, this).expand(0);
                fi.on("mousedown", function(n) {
                    ti.onMousedown(n);
                    n.stopImmediatePropagation()
                });
                fi.on("pressmove", function(n) {
                    ti.onPressmove(n);
                    n.stopImmediatePropagation()
                });
                fi.on("dblclick", function(n) {
                    ti.onDblclick(n);
                    n.stopImmediatePropagation()
                });
                ei = "";
                this.on("mousedown", function(n) {
                    ti.onMousedown(n);
                    ei = ti.text
                });
                this.on("pressmove", function(n) {
                    ti.onPressmove(n);
                    n.stopImmediatePropagation()
                });
                this.on("dblclick", function(n) {
                    ti.onDblclick(n);
                    n.stopImmediatePropagation()
                });
                this.added(function(n) {
                    n.on("stagemousedown", function(n) {
                        ii.hitTestPoint(n.stageX, n.stageY) || (ti.focus = !1, ti.text != ei && ii.dispatchEvent("change"), ei = ti.text)
                    })
                });
                this.label.on("focus", function() {
                    ii.dispatchEvent("focus")
                });
                this.label.on("blur", function() {
                    ii.dispatchEvent("blur")
                });
                this.label.on("input", function() {
                    ti.text != "" && ii.placeholderLabel.parent && (ii.placeholderLabel.removeFrom(), ii.stage && ii.stage.update());
                    ti.text != "" || ii.placeholderLabel.parent || (ii.add(ii.placeholderLabel), ii.stage && ii.stage.update());
                    ii.dispatchEvent("input")
                });
                this.label.on("keydown", function() {
                    ii.dispatchEvent("keydown")
                });
                this.label.on("blinker", function() {
                    var i = ti.x + ti.blinker.x,
                        r = n.constrain(i, tt, t - tt - ti.blinker.width);
                    i != r && (ti.x -= i - r);
                    ii.stage && ii.stage.update()
                });
                Object.defineProperty(ii, "text", {
                    get: function() {
                        return ti.hiddenInput.value
                    },
                    set: function(t) {
                        ti.setText(t);
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && ii.stage && ii.stage.update()
                    }
                });
                Object.defineProperty(ii, "focus", {
                    get: function() {
                        return ti.focus
                    },
                    set: function(n) {
                        ti.focus = n
                    }
                });
                Object.defineProperty(ii, "color", {
                    get: function() {
                        return ti.color
                    },
                    set: function(t) {
                        ti.color = latestColor = t;
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && ii.stage && ii.stage.update()
                    }
                });
                Object.defineProperty(ii, "size", {
                    get: function() {
                        return ti.size
                    },
                    set: function(t) {
                        ti.size = t;
                        ti.hiddenInput.style.fontSize = t + "px";
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && ii.stage && ii.stage.update()
                    }
                });
                Object.defineProperty(ii, "align", {
                    get: function() {
                        return ti.align
                    },
                    set: function(i) {
                        d = ti.align = i;
                        ti.x = d == "right" ? t - ti.width : d == "center" ? t / 2 : 0;
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && ii.stage && ii.stage.update()
                    }
                });
                Object.defineProperty(ii, "font", {
                    get: function() {
                        return ti.font
                    },
                    set: function(t) {
                        ti.font = t;
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && ii.stage && ii.stage.update()
                    }
                });
                Object.defineProperty(ii, "selectionAlpha", {
                    get: function() {
                        return ti.selectionAlpha
                    },
                    set: function(t) {
                        ti.selectionAlpha = t;
                        ti.selection.alpha != 0 && (ti.selection.alpha = t);
                        !n.OPTIMIZE && (zns || !WW.OPTIMIZE) && ii.stage && ii.stage.update()
                    }
                });
                n.styleTransforms(this, ni);
                this.clone = function(yt) {
                    return ii.cloneProps(yt || !n.isPick(ri[0]) ? t : ri[0], yt || !n.isPick(ri[1]) ? i : ri[1], yt || !n.isPick(ri[2]) ? r : ri[2], yt || !n.isPick(ri[3]) ? u : ri[3], f, e, yt || !n.isPick(ri[4]) ? o : ri[4], yt || !n.isPick(ri[5]) ? s : ri[5], yt || !n.isPick(ri[6]) ? h : ri[6], c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, pt, bt, kt, this.group, gt)
                }
            }, n.extend(n.TextInput, n.Window, "clone", "zimWindow", !1), n.TextInput.LabelInput = function(t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, dt, gt, ni, ti) {
                var ii, ri;
                this.zimLabel_constructor(t, i, h, c, null, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, null, yt, pt, null, wt, gt, ni, ti);
                this.type = "LabelInput";
                zot(c) && (c = n.dark);
                zot(f) && (f = c);
                zot(e) && (e = .2);
                this.selectionAlpha = e;
                zot(o) && (o = c);
                zot(s) && (s = .5);
                this.hiddenInput = document.createElement("INPUT");
                this.hiddenInput.value = t;
                bt == "text" && u && (bt = "password");
                this.hiddenInput.type = bt;
                bt == "number" && (this.hiddenInput.pattern = "[^(0-9).-+*/%$]*", this.hiddenInput.inputmode = "numeric");
                r > 0 && (this.hiddenInput.maxLength = r);
                this.hiddenInput.autocapitalize = "off";
                this.hiddenInput.autocorrect = "off";
                this.hiddenInput.autocomplete = "off";
                this.hiddenInput.spellcheck = !1;
                this.hiddenInput.style.position = "absolute";
                this.hiddenInput.style.overflow = "hidden";
                this.hiddenInput.style.touchAction = "none";
                this.hiddenInput.style.left = "-99999px";
                this.hiddenInput.style.top = "-99999px";
                this.hiddenInput.style.zIndex = -999;
                this.hiddenInput.style.opacity = 0;
                this.hiddenInput.style.width = "1px";
                this.hiddenInput.style.height = "1px";
                this.hiddenInput.style.fontSize = "1px";
                this.onFocus = function() {
                    this.stage && (ri = this.stage.frame);
                    ri.zil && WW.removeEventListener("keydown", ri.zil[0]);
                    this.blinker.alp(1).replayTween();
                    this.selection.alp(.2);
                    this.positionBlinkerAndSelection();
                    this.dispatchEvent("focus")
                };
                this.onBlur = function() {
                    this.stage && (ri = this.stage.frame);
                    ri.zil && WW.addEventListener("keydown", ri.zil[0]);
                    this.positionBlinkerAndSelection();
                    this.blinker.pauseAnimate(!0).alp(0);
                    this.selection.alp(0);
                    this.hiddenInput.type = bt;
                    this.dispatchEvent("blur")
                };
                this.onInput = function() {
                    dt && (this.hiddenInput.value = this.hiddenInput.value.toUpperCase());
                    var n = this.hiddenInput.value;
                    bt == "number" && (n = n.replace(/[^(0-9).\-+*/%$]*/g, ""), this.hiddenInput.value = n);
                    this.text = this.hiddenInput.type == "password" ? n.replace(/./g, "*") : n;
                    this.measureText();
                    this.positionBlinkerAndSelection();
                    this.dispatchEvent("input")
                };
                this.onSelect = function() {
                    this.positionBlinkerAndSelection();
                    this.focus && this.blinker.replayTween()
                };
                ii = this;
                this.onKeydown = function() {
                    this.blinker.replayTween();
                    setTimeout(function() {
                        ii.positionBlinkerAndSelection.call(ii);
                        ii.dispatchEvent("keydown")
                    }, 10)
                };
                this.onMousedown = function(n) {
                    var i = this.text.length,
                        r = this.eventPositionGlobalToLocal(n),
                        t;
                    this.focus || (this.hiddenInput.focus(), (bt == "number" || bt == "email") && (this.hiddenInput.type = "text"));
                    t = this.mapPointToIndex(r);
                    kt ? this.hiddenInput.setSelectionRange(i - t, i - t) : this.hiddenInput.setSelectionRange(t, t);
                    this.positionBlinkerAndSelection()
                };
                this.onPressmove = function(n) {
                    var r = this.text.length,
                        i, t;
                    this.focus || this.hiddenInput.focus();
                    i = this.eventPositionGlobalToLocal(n);
                    t = kt ? r - this.mapPointToIndex(i) : this.mapPointToIndex(i);
                    this.hiddenInput.selectionStart === this.hiddenInput.selectionEnd ? this.hiddenInput.selectionStart <= t ? this.hiddenInput.setSelectionRange(this.hiddenInput.selectionStart, t, kt ? "backward" : "forward") : this.hiddenInput.setSelectionRange(t, this.hiddenInput.selectionEnd, kt ? "forward" : "backward") : this.hiddenInput.selectionDirection === (kt ? "backward" : "forward") ? this.hiddenInput.setSelectionRange(this.hiddenInput.selectionStart, t, kt ? "backward" : "forward") : this.hiddenInput.setSelectionRange(t, this.hiddenInput.selectionEnd, kt ? "forward" : "backward");
                    this.positionBlinkerAndSelection()
                };
                this.onDblclick = function() {
                    this.hiddenInput.select();
                    this.positionBlinkerAndSelection()
                };
                this.positionBlinkerAndSelection = function() {
                    var f = this.text.length,
                        r, u, t, i, n;
                    this.focus && (r = this.backing || this.background ? this.paddingHorizontal : 0, u = this.backing || this.background ? this.paddingVertical : 0, this.hiddenInput.selectionStart !== this.hiddenInput.selectionEnd ? (kt ? (t = this.textWidthArray[f - this.hiddenInput.selectionStart], i = this.textWidthArray[f - this.hiddenInput.selectionEnd], this.selection.widthOnly = i - t, this.selection.pos(i + r - 1 + lt, u + at)) : (t = this.textWidthArray[this.hiddenInput.selectionStart], i = this.textWidthArray[this.hiddenInput.selectionEnd], this.selection.widthOnly = i - t, this.selection.pos(t + r - 1 + lt, u + at)), this.selection.heightOnly = this.textHeight, this.selection.alp(this.selectionAlpha)) : this.selection.alp(0), this.blinker.heightOnly = this.textHeight, n = this.hiddenInput.selectionDirection === "backward" ? this.hiddenInput.selectionStart : this.hiddenInput.selectionEnd, n || (n = 0), kt && (n = f - n), this.blinker.pos(this.textWidthArray[n] + r - 1 + (y == "right" && this.text == "" ? this.width : y == "center" && this.text == "" ? this.width / 2 : 0) + lt, u + at), this.dispatchEvent("blinker"));
                    this.stage && this.stage.update()
                };
                this.eventPositionGlobalToLocal = function(t) {
                    var i = this.globalToLocal(t.stageX / n.scaX, t.stageY / n.scaY);
                    return i.x -= y == "right" ? this.label.x - this.width : y == "center" ? (this.label.x - this.width) / 2 : this.label.x, i.y -= this.label.y, i
                };
                this.mapPointToIndex = function(n) {
                    for (var r, i = this.textWidthArray.length - 1, t = 0; t < this.textWidthArray.length - 1; t++)
                        if (r = (this.textWidthArray[t] + this.textWidthArray[t + 1]) / 2, n.x <= r) {
                            i = t;
                            break
                        }
                    return i
                };
                this.measureText = function() {
                    var i = this.label.clone(),
                        t = this.text,
                        n;
                    for (kt && (t = t.split("").reverse().join("")), n = 0; n < t.length && n < this.previousMeasuredText.length;) {
                        if (t[n] !== this.previousMeasuredText[n]) break;
                        n++
                    }
                    for (this.textWidthArray = this.textWidthArray.slice(0, n + 1), n++; n <= t.length; n++) i.text = t.slice(0, n), this.textWidthArray.push(i.getMeasuredWidth());
                    this.previousMeasuredText = t;
                    this.textHeight = i.getMeasuredLineHeight()
                };
                this.setText = function(n) {
                    dt && (n = n.toUpperCase());
                    this.hiddenInput.value = n;
                    this.onInput()
                };
                Object.defineProperty(this, "focus", {
                    get: function() {
                        return document.activeElement === ii.hiddenInput
                    },
                    set: function(n) {
                        n === !0 ? ii.hiddenInput.focus() : ii.hiddenInput.blur()
                    }
                });
                this.added(function(n) {
                    ri = n.frame;
                    ii.hiddenInput.addEventListener("focus", ii.onFocus.bind(ii));
                    ii.hiddenInput.addEventListener("blur", ii.onBlur.bind(ii))
                });
                this.hiddenInput.addEventListener("input", this.onInput.bind(this));
                this.hiddenInput.addEventListener("select", this.onSelect.bind(this));
                this.hiddenInput.addEventListener("keydown", this.onKeydown.bind(this));
                document.body.appendChild(this.hiddenInput);
                this.on("mousedown", this.onMousedown.bind(this));
                this.on("pressmove", this.onPressmove.bind(this));
                this.on("dblclick", this.onDblclick.bind(this));
                this.cursor = "text";
                this.blinker = new n.Rectangle({
                    width: 2,
                    height: 1,
                    color: o,
                    style: !1
                }).animate({
                    obj: {
                        alpha: 0
                    },
                    wait: s,
                    time: .1,
                    rewind: !0,
                    rewindWait: s,
                    loop: !0,
                    loopWait: s
                }).pauseAnimate(!0).alp(0).addTo(this);
                this.selection = new n.Rectangle({
                    width: 1,
                    height: 1,
                    color: f,
                    style: !1
                }).alp(0).addTo(this);
                this.textWidthArray = [0];
                this.previousMeasuredText = "";
                this.textHeight = null;
                this.measureText()
            }, n.extend(n.TextInput.LabelInput, n.Label, null, "zimLabel", !1), n.List = function(r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d, g, nt, tt, it, rt, ut, ft, et, ot, st, ht, ct, lt, at, vt, yt, pt, wt, bt, kt, dt, gt, ni, ti, ii, ri, ui, fi, ei, oi, si, hi, ci, li, ai, vi, yi, pi, wi, bi, ki, di, gi, nr, tr, ir, rr, ur, fr, er, or, sr, hr, cr, lr) {
                function nf(t) {
                    wr = ar.tabs = new n.Tabs({
                        width: o ? ar.itemWidth : ar.itemWidth * f.length,
                        height: o ? ar.itemHeight * f.length : ar.itemHeight,
                        tabs: t,
                        spacing: b,
                        vertical: o,
                        backgroundColor: k,
                        rollBackgroundColor: d,
                        selectedBackgroundColor: g,
                        selectedRollBackgroundColor: nt,
                        color: it,
                        rollColor: rt,
                        selectedColor: ut,
                        selectedRollColor: ft,
                        backdropColor: tt,
                        currentEnabled: !0,
                        currentSelected: s,
                        align: h,
                        valign: c,
                        labelAlign: l,
                        labelValign: a,
                        labelIndent: v,
                        labelIndentHorizontal: y,
                        labelIndentVertical: p,
                        indent: w,
                        useTap: !0,
                        excludeCustomTap: di,
                        keyWrap: !1,
                        keyEnabled: sr,
                        style: hr,
                        group: cr,
                        inherit: hu
                    }).mov(o ? 0 : ri, o ? ui : 0);
                    ar.add(wr);
                    n.loop(wr.labels, function(t) {
                        t && (t.backgroundColor = n.clear)
                    })
                }

                function du(t, i, r) {
                    t.listZID = i;
                    t.label && (ou && new n.Rectangle(iu * (r.level + 1), t.height).alp(ou).pos(0, 0, ar.align == "right", !1, t), su && new n.Rectangle(t.width, t.height).alp((r.level + 1) * su).addTo(t).bot().ord(1), iu && ar.align != "center" && (t.label.x += (ar.align == "right" ? -1 : 1) * iu * (r.level + 1)));
                    var u = pr.getData(i);
                    u.obj = t;
                    u.list && !n.isEmpty(u.list) && (t.expander = new n.Label({
                        size: yr == "arrow" ? 22 : 36,
                        text: u.open ? yr == "arrow" ? "▲" : "-" : yr == "arrow" ? "▼" : "+",
                        align: "center",
                        color: n.convertColor(it, "rgba", .6)
                    }).center(t).alp(yr == "none" ? 0 : .7).pos(15, null, ar.align != "right").mov(0, u.open ? -3 : 0))
                }

                function fu() {
                    var f, r, o, e, u, s, i, t;
                    ar.selected.expander && (f = pr.getData(ar.selected.listZID), f.open ? (ar.selected.expander && (ar.selected.expander.text = yr == "arrow" ? "▼" : "+", ar.selected.expander.mov(0, 3)), f.open = !1, o = pr.getNextSibling(ar.selected.listZID), e = zot(o) ? ar.items.length - 1 : n.loop(ar.items, function(n, t) {
                        if (n.listZID == o) return t - 1
                    }), ru ? (r = 0, ar.enabled = !1, n.interval(ru, function(n) {
                        ar.removeAt(1, ar.selectedIndex + e - ar.selectedIndex - r);
                        r++;
                        n.total == n.count + 1 && (ar.enabled = !0, ar.dispatchEvent("collapsed"))
                    }, e - ar.selectedIndex, !0)) : (ar.removeAt(e - ar.selectedIndex, ar.selectedIndex + 1), ar.dispatchEvent("collapsed"))) : (f.open = !0, ar.selected.expander && (ar.selected.expander.text = yr == "arrow" ? "▲" : "-", ar.selected.expander.mov(0, -3)), u = pr.getLinearList(f.list), s = pr.getLinearIDs(f.list), f.opened ? Array.isArray(u) && (br ? (r = 0, ar.enabled = !1, n.interval(br, function(n) {
                        ar.addAt(u[r], ar.selectedIndex + 1 + r);
                        i = new createjs.Event("bloom");
                        i.item = u[r];
                        ar.dispatchEvent(i);
                        n.total == n.count + 1 && (ar.enabled = !0, i = new createjs.Event("expanded"), i.items = u, ar.dispatchEvent(i));
                        r++
                    }, u.length, !0)) : (ar.addAt(u, ar.selectedIndex + 1), i = new createjs.Event("expanded"), i.items = u, ar.dispatchEvent(i))) : (f.opened = !0, t = ku[f.level], zot(t) && (t = {}), Array.isArray(u) && (br ? (r = 0, ar.enabled = !1, n.interval(br, function(e) {
                        ar.addAt(u[r], ar.selectedIndex + 1 + r, {
                            backgroundColor: t.backgroundColor,
                            color: t.color,
                            rollBackgroundColor: t.rollBackgroundColor,
                            rollColor: t.rollColor,
                            selectedBackgroundColor: t.selectedBackgroundColor,
                            selectedColor: t.selectedColor,
                            selectedRollBackgroundColor: t.selectedRollBackgroundColor,
                            selectedRollColor: t.selectedRollColor
                        });
                        var h = s[r],
                            o = ar.items[ar.selectedIndex + 1 + r];
                        t.borderColor && (o.borderColor = t.borderColor);
                        du(o, h, f);
                        o.label && (o.label.backgroundColor = n.clear);
                        i = new createjs.Event("bloom");
                        i.item = o;
                        ar.dispatchEvent(i);
                        e.total == e.count + 1 && (ar.enabled = !0, i = new createjs.Event("expanded"), i.items = u, ar.dispatchEvent(i));
                        r++;
                        ar.stage && ar.stage.update()
                    }, u.length, !0)) : (ar.addAt(u, ar.selectedIndex + 1, {
                        backgroundColor: t.backgroundColor,
                        color: t.color,
                        rollBackgroundColor: t.rollBackgroundColor,
                        rollColor: t.rollColor,
                        selectedBackgroundColor: t.selectedBackgroundColor,
                        selectedColor: t.selectedColor,
                        selectedRollBackgroundColor: t.selectedRollBackgroundColor,
                        selectedRollColor: t.selectedRollColor
                    }), n.loop(s, function(t, i) {
                        var r = ar.items[ar.selectedIndex + 1 + i];
                        du(r, t, f);
                        r.label && (r.label.backgroundColor = n.clear)
                    }), i = new createjs.Event("expanded"), i.items = u, ar.dispatchEvent(i))))))
                }

                function cu(n) {
                    var t, i;
                    return o ? (t = -(ar.itemHeight + b) * n + u / 2 - ar.itemHeight / 2, (ar.itemHeight + b) * ar.length < u && (t = 0), t > 0 && (t = 0), (ar.itemHeight + b) * ar.length > u && t < -ar.tabs.height + u - ui * 2 && (t = -ar.tabs.height + u - ui * 2), t) : (i = -(ar.itemWidth + b) * n + r / 2 - ar.itemWidth / 2, (ar.itemWidth + b) * ar.length < r && (i = 0), i > 0 && (i = 0), (ar.itemWidth + b) * ar.length > r && i < -ar.tabs.width + r - ri * 2 && (i = -ar.tabs.width + r - ri * 2), i)
                }
                var lu, vr, au, vu, yu, pu, ar, wu, tu, pr, ku, kr, uu, wr, hu, dr, gu, gr, eu, nu;
                if (lu = zob(n.List, arguments, "width, height, list, viewNum, vertical, currentSelected, align, valign, labelAlign, labelValign, labelIndent, labelIndentHorizontal, labelIndentVertical, indent, spacing, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, backdropColor, color, rollColor, selectedColor, selectedRollColor, borderColor, borderWidth, padding, corner, swipe, scrollBarActive, scrollBarDrag, scrollBarColor, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, scrollBarOverlay, slide, slideDamp, slideSnap, shadowColor, shadowBlur, paddingHorizontal, paddingVertical, scrollWheel, damp, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, draggable, boundary, onTop, close, closeColor, collapse, collapseColor, collapsed, excludeCustomTap, organizer, checkBox, pulldown, clone, cancelCurrentDrag, selectedIndex, noScale, pulldownToggle, optimize, keyEnabled, style, group, inherit", this)) return lu;
                if (z_d("60.5"), this.group = cr, vr = hr === !1 ? {} : n.getStyle("List", this.group, lr), zot(r) && (r = vr.width != null ? vr.width : 300), au = u, zot(u) && (u = vr.height != null ? vr.height : zot(gi) ? 200 : 200 + gi.height), zot(f) && (f = f = vr.list != null ? vr.list : ["Option 1", "Option 2", "Option 3", "Option 4", "Option 5", "Option 6", "Option 7", "Option 8", "Option 9", "Option 10"]), f.length == 0 && (f = ["%-&"]), this.originalList = f, zot(e) && (e = vr.viewNum != null ? vr.viewNum : 5), zot(o) && (o = vr.vertical != null ? vr.vertical : !0), zot(s) && (s = vr.currentSelected != null ? vr.currentSelected : !0), vu = !zot(h) || !zot(l), zot(nr) && (nr = vr.checkBox != null ? vr.checkBox : !1), zot(h) && (h = vr.align != null ? vr.align : nr ? "left" : "center"), zot(c) && (c = vr.valign != null ? vr.valign : "center"), zot(l) && (l = vr.labelAlign != null ? vr.labelAlign : h), zot(a) && (a = vr.labelValign != null ? vr.labelValign : c), zot(w) && (w = vr.indent != null ? vr.indent : nr ? 0 : 10), zot(v) && (v = vr.labelIndent != null ? vr.labelIndent : w), zot(y) && (y = vr.labelIndentHorizontal != null ? vr.labelIndentHorizontal : v), zot(p) && (p = vr.labelIndentVertical != null ? vr.labelIndentVertical : v), zot(b) && (b = vr.spacing != null ? vr.spacing : 2), zot(tt) && (tt = vr.backdropColor != null ? vr.backdropColor : "#333"), zot(k) && (k = vr.backgroundColor != null ? vr.backgroundColor : "#777"), zot(d) && (d = vr.rollBackgroundColor != null ? vr.rollBackgroundColor : "#555"), zot(g) && (g = vr.selectedBackgroundColor != null ? vr.selectedBackgroundColor : "#444"), zot(nt) && (nt = vr.selectedRollBackgroundColor != null ? vr.selectedRollBackgroundColor : "#555"), zot(it) && (it = vr.color != null ? vr.color : "white"), zot(rt) && (rt = vr.rollColor != null ? vr.rollColor : it), zot(ut) && (ut = vr.selectedColor != null ? vr.selectedColor : it), zot(ft) && (ft = vr.selectedRollColor != null ? vr.selectedRollColor : rt), zot(tt) && (tt = vr.backdropColor != null ? vr.backdropColor : tt), yu = et, pu = ot, zot(et) && (et = vr.borderColor != null ? vr.borderColor : "#999"), zot(ot) && (ot = vr.borderWidth != null ? vr.borderWidth : 1), zot(st) && (st = vr.padding != null ? vr.padding : b), zot(ht) && (ht = vr.corner != null ? vr.corner : 0), zot(ct) && (ct = vr.swipe != null ? vr.swipe : !0), zot(lt) && (lt = vr.scrollBarActive != null ? vr.scrollBarActive : !0), zot(at) && (at = vr.scrollBarDrag != null ? vr.scrollBarDrag : !0), zot(vt) && (vt = vr.scrollBarColor != null ? vr.scrollBarColor : et), zot(yt) && (yt = vr.scrollBarAlpha != null ? vr.scrollBarAlpha : .3), zot(pt) && (pt = vr.scrollBarFade != null ? vr.scrollBarFade : !0), zot(wt) && (wt = vr.scrollBarH != null ? vr.scrollBarH : !o), zot(bt) && (bt = vr.scrollBarV != null ? vr.scrollBarV : o), at && (pt = vr.scrollBarFade != null ? vr.scrollBarFade : !1), zot(kt) && (kt = vr.scrollBarOverlay != null ? vr.scrollBarOverlay : !0), zot(dt) && (dt = vr.slide != null ? vr.slide : !0), zot(gt) && (gt = vr.slideDamp != null ? vr.slideDamp : .6), zot(ni) && (ni = vr.slideSnap != null ? vr.slideSnap : o ? "vertical" : "horizontal"), zot(ti) && (ti = vr.shadowColor != null ? vr.shadowColor : "rgba(0,0,0,.3)"), zot(ii) && (ii = vr.shadowBlur != null ? vr.shadowBlur : 20), zot(ui) && (ui = vr.paddingVertical != null ? vr.paddingVertical : st), zot(ri) && (ri = vr.paddingHorizontal != null ? vr.paddingHorizontal : st), zot(fi) && (fi = vr.scrollWheel != null ? vr.scrollWheel : !0), zot(oi) && (oi = vr.titleBar != null ? vr.titleBar : null), zot(si) && (si = vr.titleBarColor != null ? vr.titleBarColor : null), zot(hi) && (hi = vr.titleBarBackgroundColor != null ? vr.titleBarBackgroundColor : null), zot(ci) && (ci = vr.titleBarHeight != null ? vr.titleBarHeight : 35), zot(li) && (li = vr.draggable != null ? vr.draggable : null), zot(ai) && (ai = vr.boundary != null ? vr.boundary : null), zot(vi) && (vi = vr.onTop != null ? vr.onTop : null), zot(yi) && (yi = vr.close != null ? vr.close : null), zot(pi) && (pi = vr.closeColor != null ? vr.closeColor : null), zot(wi) && (wi = vr.collapse != null ? vr.collapse : null), zot(bi) && (bi = vr.collapseColor != null ? vr.collapseColor : null), zot(di) && (di = vr.excludeCustomTap != null ? vr.excludeCustomTap : !1), zot(nr) && (nr = vr.checkBox != null ? vr.checkBox : !1), zot(tr) && (tr = vr.pulldown != null ? vr.pulldown : !1), zot(er) && (er = vr.pulldownToggle != null ? vr.pulldownToggle : !1), zot(fr) && (fr = vr.noScale != null ? vr.noScale : !1), zot(ir) && (ir = vr.clone != null ? vr.clone : !1), zot(or) && (or = vr.optimize != null ? vr.optimize : !0), zot(sr) && (sr = vr.keyEnabled != null ? vr.keyEnabled : null), oi === !1 && (oi = null), this.vertical = o, ar = this, wu = u, WW.DIR && WW.DIR == "rtl" || !WW.DIR && n.DIR == "rtl" ? h == "start" ? h = "right" : h == "end" && (h = "left") : h == "start" ? h = "left" : h == "end" && (h = "right"), nr && n.loop(f, function(t, i) {
                        f[i] = n.List.checkItem(t, null, r, "left", 10, 10, b, it, rt, ut, ft, k, d, g, nt)
                    }), tu = t(), f.constructor == {}.constructor) {
                    var ou = zot(f.shade) ? zot(vr.shade) ? .2 : vr.shade : f.shade,
                        su = zot(f.dim) ? zot(vr.dim) ? .1 : vr.dim : f.dim,
                        iu = zot(f.shift) ? zot(vr.shift) ? 15 : vr.shift : f.shift,
                        br = zot(f.bloom) ? zot(vr.bloom) ? !1 : vr.bloom : f.bloom,
                        ru = zot(f.whither) ? zot(vr.whither) ? !1 : vr.whither : f.whither,
                        bu = zot(f.open) ? zot(vr.open) ? !1 : vr.open : f.open,
                        yr = zot(f.expander) ? zot(vr.expander) ? "plus" : vr.expander : f.expander;
                    yr = yr.toLowerCase();
                    yr == "arrows" && (yr = "arrow");
                    yr != "none" && yr != "arrow" && (yr = "plus");
                    br === !0 && (br = tu == "s" ? .01 : 10);
                    ru === !0 && (ru = tu == "s" ? .01 : 10);
                    i(br);
                    i(ru);
                    iu === !0 && (iu = 15);
                    ou === !0 && (ou = .2);
                    su === !0 && (su = .1);
                    ku = zot(f.subStyles) ? zot(vr.subStyles) ? {} : vr.subStyles : f.subStyles;
                    zot(f.menu) || (f = f.menu);
                    pr = ar.tree = new n.Hierarchy(f);
                    f = pr.getLinearList();
                    vu || (h = l = "left")
                }
                tr && (e = zot(pr) ? f.length : pr.length, zot(au)