var scaling = "fit";
var width = 860;
var height = 550;
//var color = "#cee1ff";
var color = "#5EA7EA";
var outerColor = "#cecece";
// var aplay = {
//     src: "audioSprite1.mp3",
//     audioSprite: [
//         ['fullSound', 0, 37.4] // فقط یک تکه از آهنگ که از زمان 0 شروع و تا 37.4 ثانیه ادامه دارد
//     ]
// }


// var zimAudioSpriteData = {
//     src: "audioSprite.mp3",
//     audioSprite: [
//         ['correct', 3.4, 3.3],
//         ['incorrect', 3.5, 8.4],
//         ['catJump', 9.1, 10],
//         ['meow1', 10.1, 11],
//         ['meow2', 11.6, 13.5],
//         ['meow3', 13.7, 15.4],
//         ['meow4', 16, 17.4],
//         ['meow5', 17.7, 18.7],
//         ['cardboard', 19.1, 21.9],
//         ['start1', 22.7, 25],
//         ['start2', 25.7, 27.4],
//         ['start3', 28.4, 30.2],
//         ['measure1', 31.4, 33.6],
//         ['measure2', 34.1, 37.4],
//         ['cardboardPress1', 19.3, 19.6],
//         ['cardboardPress2', 20.3, 20.6]
//     ]
// }


var assets = [{
    font: "../nshared/samim",
    src: "childFriendly.ttf"
}, "contract.png", "expand.png", "ballWool.png", "ballWoolShadow.png",
    "chair.png", "granEyes.png", "granHead.png", "grannyUpperSpriteSheet.png", "kittenWalkCycle4.png", "leftEye.png", "pounceCat.png", 
    "rollingWoolCatOnly.png", "wallpaper.png", "scarf2.png", "scarfRoll2.png", "basketBack.png", "basketFront.png", "rollMask.png", "tenLine.png", "fiveLine.png", "oneLine.png",
    "cardboardBox.png", "picTitanic.png", "picPair.png", "picButterfly.png", "rosette1.png", "rosette2.png", "rosette3.png", "rosette4.png", "rosette5.png", "rosette6.png",
    "rosette7.png", "boxTail.png", "boxPaw.png", "menuScrn.png", "smoke1.png", "smoke2.png", "smoke3.png"
];
var progress = new ProgressBar({
    barType: "rectangle",
    foregroundColor: "#ffffff",
    backgroundColor: "#3A7099",
    borderWidth: 5
});
var path = "assets/";

var frame = new Frame("holder", width, height, color, outerColor, assets, path, progress);
var frameBig = new zim.Frame("fit", width, height, color);
frameBig.on("ready", function () {
    frameBig.canvas.style.display = "none";
});
frame.on("ready", function () {

    zim.Ticker.update = true;
    var stage = frame.stage;
    var stageW = frame.width;
    var stageH = frame.height;

    var shell = new zim.Container(stageW, stageH)
        .addTo(stage);




    var bgContainer = new zim.Container();
    bgContainer.name = "bgContainer";
    shell.addChild(bgContainer);

    var cardboardContainer = new zim.Container();
    cardboardContainer.name = "cardboardContainer";
    shell.addChild(cardboardContainer);

    var grannyContainer = new zim.Container();
    grannyContainer.name = "grannyContainer";
    shell.addChild(grannyContainer);

    var kittyContainer = new zim.Container();
    kittyContainer.name = "kittyContainer";
    shell.addChild(kittyContainer);

    var smokeContainer = new zim.Container();
    smokeContainer.name = "smokeContainer";
    shell.addChild(smokeContainer);

    var foldContainer = new zim.Container();
    foldContainer.name = "foldContainer";
    shell.addChild(foldContainer);

    var menuContainer = new zim.Container();
    menuContainer.name = "menuContainer";
    shell.addChild(menuContainer);
    menuContainer.visible = true;

    // var backLink = frame.asset("backLink.png");
    // backLink.scaleX = backLink.scaleY = .3;
    // backLink.y = 5;
    // backLink.x = 5;
    // shell.addChild(backLink);

    // var copyright = frame.asset("copyright.png");
    // copyright.scaleX = copyright.scaleY = .35;
    // copyright.y = 5;
    // copyright.x = 125;
    //copyright.rotation=90;
    // copyright.alpha = .75;
    // shell.addChild(copyright);


    // backLink.on("click", function () {
    //     zgo("../index.html");
    // });

    var smallFrame = true; // track which frame is in use
    var expand = frame.asset("expand.png");
    expand.scaleX = expand.scaleY = .75;
    expand.y = 10;
    expand.x = 760;
    expand.alpha = .75;
    shell.addChild(expand);

    var contract = frame.asset("contract.png");
    contract.scaleX = contract.scaleY = .75;
    contract.y = 10;
    contract.x = 760;
    contract.alpha = .75;
    shell.addChild(contract);
    contract.visible = false;
    frameBig.allowDefault = true;


    contract.on("click", function () {

        stage = frame.stage;
        zet("article").css("display", "block");
        frameBig.canvas.style.display = "none";
        contract.visible = false;
        expand.visible = true;
        frameBig.allowDefault = true;
        frame.allowDefault = true;
        //frame.fullscreen(!frame.isFullscreen);

        smallFrame = true;
        shell.addTo(stage);
        stage.update();
    });

    expand.on("click", function () {

        if (shell.stage == frame.stage) {
            stage = frameBig.stage;
            zet("article").css("display", "none");
            frameBig.canvas.style.display = "block";
            contract.visible = true;
            expand.visible = false;
            frameBig.allowDefault = false;
            frame.allowDefault = false;
            //frame.fullscreen();
        }

        smallFrame = false;
        shell.addTo(stage);
        //restartAnimations();
        stage.update();
    });

    var woolTimer;

    var woolAnimation;
    var catOnBackAnimation;
    //var foldInterval;
    var legInterval;
    var smokeInterval;

    var scarfLength = 0;
    var knitFlag = false;

    var enteredNumber = 0;

    var menuScrn = asset("menuScrn.png");
    menuScrn.sca(1);
    menuScrn.loc(0, 0, menuContainer);

    var wallpaper = asset("wallpaper.png");
    wallpaper.reg(wallpaper.width / 2, wallpaper.height / 2);
    wallpaper.sca(.5);
    //wallpaper.loc(245,125,bgContainer);
    const tile = new Tile(wallpaper, 10, 4, 45, 45);
    tile.y = -25;
    bgContainer.addChild(tile);

    var wallShadow = new Rectangle({
        width: 900,
        height: 200,
        color: "rgba(0,0,0,.05)",
        corner: 0
    });
    wallShadow.loc(0, 325, bgContainer);
    wallShadow.rotation = -10;

    var carpet = new Rectangle({
        width: 860,
        height: 225,
        color: "#9C8DA0",
        corner: 0
    });
    carpet.loc(0, 345, bgContainer);

    var kickBoard = new Rectangle({
        width: 860,
        height: 20,
        color: "#ffffff",
        corner: 0
    });
    
    kickBoard.loc(0, 325, bgContainer);

    var picButterfly = asset("picButterfly.png");
    picButterfly.sca(.45);
    picButterfly.loc(285, 35, bgContainer);
    picButterfly.alpha = .9;

    var picPair = asset("picPair.png");
    picPair.sca(.45);
    picPair.loc(365, 145, bgContainer);
    picPair.alpha = .9;

    var picTitanic = asset("picTitanic.png");
    picTitanic.sca(.5);
    picTitanic.loc(505, 45, bgContainer);
    picTitanic.alpha = .9;

    var cardboardBox = asset("cardboardBox.png");
    cardboardBox.sca(.5);

    var boxTail = asset("boxTail.png");
    boxTail.reg(boxTail.width - 5, boxTail.height / 2);
    boxTail.sca(.5);
    boxTail.loc(55, 105, cardboardContainer);

    var boxPaw = asset("boxPaw.png");
    boxPaw.reg(0, boxPaw.height / 2);
    boxPaw.sca(.5);
    boxPaw.loc(270, 135, cardboardContainer);
    cardboardContainer.x = -325;
    cardboardContainer.y = 125;
    cardboardBox.loc(0, 0, cardboardContainer);
    //cardboardBox.alpha=.2;

    var keyValues = [7, 8, 9, 4, 5, 6, 1, 2, 3, 100, 0, 200];
    var numKey = 0;
    for (var i = 0; i < 4; i++) {
        for (var j = 0; j < 3; j++) {
            var numBut = new Rectangle({
                width: 60,
                height: 40,
                color: "rgba(255,255,255,.01)",
                corner: 5
            });
            numBut.loc((70 * j) + 50, (46 * i) + 20, cardboardContainer);
            if (i == 3) {
                numBut.y = (46 * i) + 25;
            }
            numBut.on("click", function (e) {
                var addedValue = e.currentTarget.myValue;

                if ((addedValue < 10) && (enteredNumber < 100)) {
                    enteredNumber *= 10;
                    enteredNumber += addedValue;
                    enterNumLabel.text = enteredNumber + " میلی متر";
                    // asset("cardboardPress1").play();
                } else if (addedValue == 100) {
                    enteredNumber = 0;
                    enterNumLabel.text = enteredNumber + " میلی متر";
                    // asset("cardboardPress2").play();
                } else if (addedValue == 200) {
                    submitAnswer();
                    // asset("cardboardPress2").play();
                };
                stage.update();
            });
            numBut.myValue = keyValues[numKey];
            numBut.cursor = "pointer";
            numKey++;
        }
    };


    var rosette1 = asset("rosette1.png");
    rosette1.reg(rosette1.width / 2, rosette1.height / 2);
    rosette1.sca(1);

    var rosette2 = asset("rosette2.png");
    rosette2.reg(rosette2.width / 2, rosette2.height / 2);
    rosette2.sca(1);

    var rosette3 = asset("rosette3.png");
    rosette3.reg(rosette3.width / 2, rosette3.height / 2);
    rosette3.sca(1);

    var rosette4 = asset("rosette4.png");
    rosette4.reg(rosette4.width / 2, rosette4.height / 2);
    rosette4.sca(1);

    var rosette5 = asset("rosette5.png");
    rosette5.reg(rosette5.width / 2, rosette5.height / 2);
    rosette5.sca(1);

    var rosette6 = asset("rosette6.png");
    rosette6.reg(rosette6.width / 2, rosette6.height / 2);
    rosette6.sca(1);

    var rosette7 = asset("rosette7.png");
    rosette7.reg(rosette7.width / 2, rosette7.height / 2);
    rosette7.sca(1);

    var rosetteArray = [rosette1, rosette2, rosette3, rosette4, rosette5, rosette6, rosette7];


    var chair = asset("chair.png");
    chair.reg(chair.width / 2, chair.height);
    chair.sca(.35);
    chair.loc(695, 395, bgContainer);

    var grannyLowerSpriteSheet = asset("grannyUpperSpriteSheet.png").image;
    var grannyData = {
        "framerate": 24,
        "images": [grannyLowerSpriteSheet],
        "frames": [
            [5, 5, 181, 310, 0, 94.95, 106.55],
            [191, 5, 182, 310, 0, 95.95, 106.55],
            [378, 5, 187, 310, 0, 100.95, 106.55],
            [570, 5, 193, 310, 0, 106.95, 106.55],
            [768, 5, 197, 310, 0, 110.95, 106.55],
            [970, 5, 198, 310, 0, 111.95, 106.55],
            [1173, 5, 197, 310, 0, 110.95, 106.55],
            [1375, 5, 193, 310, 0, 106.95, 106.55],
            [1573, 5, 186, 310, 0, 99.95, 106.55],
            [1764, 5, 182, 310, 0, 95.95, 106.55],
            [5, 320, 181, 310, 0, 94.95, 106.55],
            [191, 320, 181, 310, 0, 94.95, 106.55],
            [377, 320, 182, 310, 0, 94.95, 106.55],
            [564, 320, 188, 310, 0, 94.95, 106.55],
            [757, 320, 192, 310, 0, 94.95, 106.55],
            [954, 320, 189, 310, 0, 94.95, 106.55],
            [1148, 320, 185, 310, 0, 94.95, 106.55],
            [1338, 320, 181, 310, 0, 94.95, 106.55],
            [1524, 320, 181, 310, 0, 94.95, 106.55],
            [1710, 320, 181, 310, 0, 94.95, 106.55],
            [1710, 320, 181, 310, 0, 94.95, 106.55],
            [5, 635, 181, 310, 0, 94.95, 106.55],
            [191, 635, 181, 310, 0, 94.95, 106.55],
            [377, 635, 181, 310, 0, 94.95, 106.55],
            [377, 635, 181, 310, 0, 94.95, 106.55],
            [377, 635, 181, 310, 0, 94.95, 106.55],
            [191, 635, 181, 310, 0, 94.95, 106.55],
            [563, 635, 181, 310, 0, 94.95, 106.55],
            [1710, 320, 181, 310, 0, 94.95, 106.55],
            [1710, 320, 181, 310, 0, 94.95, 106.55]
        ],
        "animations": {
            "still": {
                "frames": [0]
            },
            "knitting": {
                "frames": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19]
            },
            "legMove": {
                "frames": [20, 21, 22, 23, 24, 25, 26, 27, 28, 29]
            }
        }
    };
    var grannyAnim = new Sprite({
        json: grannyData
    });
    grannyAnim.sca(.75);
    grannyAnim.loc(chair.x + 12, chair.y - 125, grannyContainer);

    var granEyes = asset("granEyes.png");
    granEyes.reg(granEyes.width / 2, granEyes.height / 2);
    granEyes.sca(.35);
    granEyes.loc(chair.x + 12, chair.y - 225, grannyContainer);
    granEyes.startX = granEyes.x;
    granEyes.startY = granEyes.y;

    var granHead = asset("granHead.png");
    granHead.reg(granHead.width / 2, granHead.height / 2);
    granHead.sca(.35);
    granHead.loc(chair.x + 12, chair.y - 240, grannyContainer);

    grannyAnim.run({
        label: "legMove",
        time: 1,
        loop: false,
        rewind: true
    });

    var leftEye = frame.asset("leftEye.png");
    var leftEyeAnim = new zim.Sprite({
        image: leftEye,
        cols: 4,
        rows: 1,
        animations: {
            opened: [0, 0],
            close: [0, 3]
        }
    });
    leftEyeAnim.scaleX = leftEyeAnim.scaleY = .74;
    leftEyeAnim.loc(granHead.x - 40, granHead.y - 5, grannyContainer);

    // var rightEye = frame.asset("rightEye.png");
    // var rightEyeAnim = new zim.Sprite({
    //     image: rightEye,
    //     cols: 4,
    //     rows: 1,
    //     animations: {
    //         opened: [0, 0],
    //         close: [0, 3]
    //     }
    // });
    // rightEyeAnim.scaleX = rightEyeAnim.scaleY = .75;
    // rightEyeAnim.loc(granHead.x + 5, granHead.y - 8, grannyContainer);

    // var mouth = frame.asset("mouth.png");
    // var mouthAnim = new zim.Sprite({
    //     image: mouth,
    //     cols: 4,
    //     rows: 1,
    //     animations: {
    //         opened: [0, 0],
    //         close: [0, 3]
    //     }
    // });
    // mouthAnim.scaleX = mouthAnim.scaleY = .7;
    // mouthAnim.loc(granHead.x - 21, granHead.y + 22, grannyContainer);




    var ballWool = asset("ballWool.png");
    ballWool.reg(ballWool.width / 2, ballWool.height / 2);
    ballWool.sca(.8);
    ballWool.loc(chair.x - 100, chair.y - 181, kittyContainer);
    var ballWoolShadow = asset("ballWoolShadow.png");
    ballWoolShadow.reg(ballWoolShadow.width / 2, ballWoolShadow.height / 2);
    ballWoolShadow.sca(.8);
    ballWoolShadow.loc(chair.x - 100, chair.y - 160, kittyContainer);

    woolAnimation = ballWool.animate({
        props: {
            rotation: -359
        },
        time: 2,
        loop: true,
        ease: "linear"
    });
    ballWool.visible = true;
    ballWoolShadow.visible = true;
    woolAnimation.pauseAnimate(true);


    var rollingWoolCatOnly = asset("rollingWoolCatOnly.png").image;
    var rollingWoolCatData = {
        "framerate": 24,
        "images": [rollingWoolCatOnly],
        "frames": [
            [5, 5, 482, 332, 0, 186.8, -6.949999999999999],
            [492, 5, 482, 327, 0, 186.8, -4.949999999999999],
            [979, 5, 482, 326, 0, 187.8, -0.9499999999999993],
            [1466, 5, 481, 326, 0, 188.8, 6.050000000000001],
            [1952, 5, 480, 325, 0, 189.8, 15.05],
            [5, 342, 480, 329, 0, 190.8, 23.05],
            [490, 342, 480, 333, 0, 191.8, 27.05],
            [975, 342, 480, 335, 0, 191.8, 29.05],
            [1460, 342, 481, 326, 0, 191.8, 20.05],
            [1946, 342, 482, 332, 0, 190.8, 23.05],
            [5, 682, 485, 326, 0, 188.8, 16.05],
            [495, 682, 490, 325, 0, 186.8, 0.05000000000000071],
            [990, 682, 493, 321, 0, 185.8, -5.949999999999999],
            [1488, 682, 495, 320, 0, 184.8, -10.95],
            [1988, 682, 495, 321, 0, 183.8, -11.95],
            [5, 1013, 501, 318, 0, 189.8, -15.95],
            [511, 1013, 512, 316, 0, 200.8, -19.95],
            [1028, 1013, 527, 283, 0, 215.8, -53.95],
            [1560, 1013, 542, 279, 0, 230.8, -76.95],
            [5, 1336, 585, 430, 0, 273.8, -64.95],
            [595, 1336, 551, 290, 0, 239.8, -76.95],
            [1151, 1336, 534, 263, 0, 222.8, -76.95],
            [1690, 1336, 522, 295, 0, 210.8, -41.95],
            [5, 1771, 508, 313, 0, 196.8, -21.95],
            [1988, 682, 495, 321, 0, 183.8, -11.95],
            [1988, 682, 495, 321, 0, 183.8, -11.95],
            [5, 1013, 501, 318, 0, 189.8, -15.95],
            [511, 1013, 512, 316, 0, 200.8, -26.95],
            [1028, 1013, 527, 283, 0, 215.8, -46.95],
            [1560, 1013, 542, 279, 0, 230.8, -76.95],
            [518, 1771, 562, 330, 0, 250.8, -76.95],
            [595, 1336, 551, 290, 0, 239.8, -76.95],
            [1151, 1336, 534, 263, 0, 222.8, -76.95],
            [1085, 1771, 522, 302, 0, 210.8, -34.95],
            [5, 1771, 508, 313, 0, 196.8, -21.95],
            [1988, 682, 495, 321, 0, 183.8, -11.95]
        ],
        "animations": {
            "still": {
                "frames": [0]
            },
            "rolling": {
                "frames": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14]
            },
            "incorrect": {
                "frames": [14, 15, 16, 17, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19]
            },
            "correct": {
                "frames": [25, 26, 27, 28, 29, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 31, 32, 33, 34, 35]
            }
        }
    };
    var rollingWoolCatAnim = new Sprite({
        json: rollingWoolCatData
    });
    rollingWoolCatAnim.sca(.25);
    rollingWoolCatAnim.loc(chair.x - 125, chair.y - 220, kittyContainer);
    rollingWoolCatAnim.visible = false;


    var pounceCat = asset("pounceCat.png").image;
    var pounceCatData = {
        "framerate": 24,
        "images": [pounceCat],
        "frames": [
            [5, 5, 493, 343, 0, -76.75, 9.349999999999994],
            [503, 5, 506, 341, 0, -71.75, 1.3499999999999943],
            [1014, 5, 516, 322, 0, -56.75, -18.650000000000006],
            [1535, 5, 537, 300, 0, -45.75, -43.650000000000006],
            [5, 353, 547, 282, 0, -37.75, -63.650000000000006],
            [557, 353, 543, 272, 0, -34.75, -71.65],
            [1105, 353, 548, 287, 0, -30.75, -57.650000000000006],
            [1658, 353, 534, 308, 0, -19.75, -24.650000000000006],
            [5, 666, 521, 384, 0, -1.75, 44.349999999999994],
            [531, 666, 472, 445, 0, 19.25, 125.35],
            [1008, 666, 503, 425, 0, 0.25, 91.35],
            [1516, 666, 511, 379, 0, -12.75, 64.35],
            [5, 1116, 486, 345, 0, -37.75, 42.349999999999994],
            [496, 1116, 472, 324, 0, -50.75, 23.349999999999994],
            [973, 1116, 461, 287, 0, -58.75, 10.349999999999994],
            [1439, 1116, 454, 277, 0, -62.75, 4.349999999999994],
            [5, 1466, 470, 314, 0, -65.75, 9.349999999999994],
            [480, 1466, 498, 349, 0, -72.75, 12.349999999999994],
            [5, 5, 493, 343, 0, -76.75, 9.349999999999994]
        ],
        "animations": {
            "still": {
                "frames": [0]
            },
            "pounce": {
                "frames": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18]
            }
        }
    };
    var pounceCatAnim = new Sprite({
        json: pounceCatData
    });
    pounceCatAnim.sca(.3);
    pounceCatAnim.loc(chair.x - 325, chair.y - 125, kittyContainer);
    pounceCatAnim.visible = false;

    var pounceLine = [
        [-341.5, 249.3, 0, 0, -39.3, 117.1, 39.3, -117.1],
        [-267.5, 64, 0, 0, -21.3, -0.8, 21.3, 0.8],
        [-227.9, 115.9, 0, 0, -10, -28.3, 10, 28.3]
    ];
    var squiggle_pounceLine = new Squiggle({
        points: pounceLine,
        color: "#000"
    });
    squiggle_pounceLine.duration = 1.5;
    squiggle_pounceLine.id = "squiggle_pounceLine";
    //squiggle_pounceLine.reg(squiggle_lhsDkLine.width,0);
    squiggle_pounceLine.loc(735.5, 40, bgContainer);
    squiggle_pounceLine.visible = false;

    var basketJump = [
        [-341.5, 249.3, 0, 0, -39.3, 117.1, 39.3, -117.1],
        [-177.8, 139.4, 0, 0, -21.3, -0.8, 21.3, 0.8],
        [-97.4, 243.3, 0, 0, -3.9, -85.4, 3.9, 85.4]
    ]
    var squiggle_basketJump = new Squiggle({
        points: basketJump,
        color: "#000"
    });
    squiggle_basketJump.duration = 1.5;
    squiggle_basketJump.id = "squiggle_basketJump";
    //squiggle_pounceLine.reg(squiggle_lhsDkLine.width,0);
    squiggle_basketJump.loc(625, 95, bgContainer);
    squiggle_basketJump.visible = false;

    frame.on("keydown", function (e) {
        if (e.keyCode == 82) {
            squiggle_basketJump.recordPoints(true);
            zog(squiggle_basketJump.x);
            zog(squiggle_basketJump.y);
        }
        stage.update();
    });



    var kittenWalkCycle4 = asset("kittenWalkCycle4.png").image;
    var kittenWalkCycleData = {
        "framerate": 24,
        "images": [kittenWalkCycle4],
        "frames": [
            [5, 5, 493, 344, 0, -76.85, 9.15],
            [503, 5, 503, 347, 0, -67.85, 7.15],
            [1011, 5, 531, 346, 0, -42.85, 5.15],
            [5, 357, 570, 343, 0, -12.850000000000001, 1.1500000000000004],
            [580, 357, 594, 340, 0, 10.149999999999999, -0.8499999999999996],
            [5, 705, 598, 327, 0, 20.15, -1.8499999999999996],
            [608, 705, 595, 340, 0, 10.149999999999999, -0.8499999999999996],
            [5, 1050, 570, 344, 0, -12.850000000000001, 2.1500000000000004],
            [580, 1050, 538, 344, 0, -42.85, 5.15],
            [5, 1399, 511, 341, 0, -67.85, 7.15],
            [5, 5, 493, 344, 0, -76.85, 9.15]
        ],
        "animations": {
            "still": {
                "frames": [0]
            },
            "running": {
                "frames": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
            }
        }
    };
    var kittenWalkCycleAnim = new Sprite({
        json: kittenWalkCycleData
    });
    kittenWalkCycleAnim.sca(.3);
    kittenWalkCycleAnim.loc(752, 295, kittyContainer);

    kittenWalkCycleAnim.run({
        label: "running",
        time: .5,
        loop: true,
        loopCount: 10,
        rewind: true
    });
    catOnBackAnimation = rollingWoolCatAnim.run({
        label: "rolling",
        time: 1,
        loop: true,
        rewind: true
    });
    ballWool.pauseAnimate(true, woolAnimation);
    rollingWoolCatAnim.pauseAnimate(true, catOnBackAnimation);


    var basketBack = asset("basketBack.png");
    basketBack.reg(basketBack.width / 2, basketBack.height / 2);
    basketBack.sca(.8);
    basketBack.loc(grannyAnim.x - 5, grannyAnim.y + 145, grannyContainer);

    var scarf = asset("scarf2.png");
    scarf.sca(.8);
    var scarfRect = new Rectangle({
        width: 85,
        height: scarf.height,
        color: "rgba(255,255,255,.01)",
        corner: 3
    });
    scarfRect.loc(grannyAnim.x - 5, grannyAnim.y, grannyContainer);
    scarfRect.reg(scarfRect.width / 2, scarfRect.height);
    scarf.loc(-5, 0, scarfRect);
    scarf.startY = scarf.y;

    var scarfHoriz = scarf.clone();
    scarfHoriz.reg(0, 0);
    var scarfRectHoriz = new Rectangle({
        width: 800,
        height: 90,
        color: "#9C56B7",
        corner: 3
    });
    scarfHoriz.rotation = -90;
    scarfHoriz.loc(0, 90, scarfRectHoriz);

    scarfRectHoriz.loc(125, 325, kittyContainer);
    scarfRectHoriz.visible = true;
    //scarfRectHoriz.reg(scarfRect.width/2,scarfRect.height);

    var horizScarfMask = new Rectangle({
        width: 800 - (805 - grannyAnim.x),
        height: 125,
        color: "#000000"
    });
    horizScarfMask.loc(0, 325, kittyContainer);
    scarfRectHoriz.setMask(horizScarfMask);
    horizScarfMask.visible = false;
    //scarf.startY=scarf.y;

    var scarfMask = new Blob({
        color: purple,
        showControls: false,
        interactive: false,
        points: [
            [21.4, -95.3, 0, 0, 0.7, -0.1, -0.2, 0, "mirror"],
            [56.6, -61.7, 0, 0, -4.7, -8.6, 4.7, 8.6, "mirror"],
            [75.1, 107.1, 0, 0, -1.3, -1.4, 1.8, 2, "mirror"],
            [21.3, 107.5, 0, 0, 16.3, 0.6, -16.3, -0.6, "mirror"],
            [-30.8, 105.4, 0, 0, 0.3, 4.3, -0.3, -4.3, "mirror"],
            [-15.4, -58.8, 0, 0, -3.2, 10.4, 3.2, -10.4, "mirror"]
        ]
    });

    scarfMask.loc(grannyAnim.x - 25, grannyAnim.y + 75, grannyContainer);
    scarfRect.setMask(scarfMask);
    scarfMask.startY = grannyAnim.y + 75
    scarfMask.visible = false;

    var scarfRoll = asset("scarfRoll2.png");
    scarfRoll.reg(scarfRoll.width / 2, 0);
    scarfRoll.scaleX = .8;
    scarfRoll.scaleY = .8;
    scarfRoll.loc(grannyAnim.x - 25, grannyAnim.y + 155, grannyContainer);
    scarfRoll.startY = scarfRoll.y;

    var scarfRoll2 = scarfRoll.clone();
    scarfRoll2.reg(scarfRoll2.width / 2, 0);
    scarfRoll2.scaleX = .8;
    scarfRoll2.scaleY = .8;
    scarfRoll2.loc(grannyAnim.x + 25, grannyAnim.y + 155, grannyContainer);
    scarfRoll2.startY = scarfRoll2.y;

    var rollMask = asset("rollMask.png");
    rollMask.reg(rollMask.width / 2, 0);
    rollMask.sca(.8);
    rollMask.loc(grannyAnim.x - 5, grannyAnim.y + 145, grannyContainer);

    var catForBasket = kittenWalkCycleAnim.clone();
    catForBasket.sca(.4);
    catForBasket.loc(-265, grannyAnim.y + 45, grannyContainer);
    catForBasket.startX = catForBasket.x;

    var basketFront = asset("basketFront.png");
    basketFront.reg(basketFront.width / 2, basketFront.height / 2);
    basketFront.sca(.8);
    basketFront.loc(grannyAnim.x - 5, grannyAnim.y + 155, grannyContainer);

    var rulerRect = new Rectangle({
        width: 730,
        height: 125,
        color: "#ffffff",
        corner: 5
    });
    rulerRect.reg(rulerRect.width / 2, 0);
    rulerRect.loc(430, 485, grannyContainer);
    rulerRect.drag();

    var smoke1 = asset("smoke1.png");
    smoke1.reg(smoke1.width / 2, smoke1.height / 2);
    smoke1.cache((smoke1.width / 2) * -1, (smoke1.height / 2) * -1, (smoke1.width / 2), (smoke1.height / 2));

    var smoke2 = asset("smoke2.png");
    smoke2.reg(smoke2.width / 2, smoke2.height / 2);
    smoke2.cache((smoke2.width / 2) * -1, (smoke2.height / 2) * -1, (smoke2.width / 2), (smoke2.height / 2));

    var smoke3 = asset("smoke3.png");
    smoke3.reg(smoke3.width / 2, smoke3.height / 2);
    smoke3.cache((smoke3.width / 2) * -1, (smoke3.height / 2) * -1, (smoke3.width / 2), (smoke3.height / 2));
    // ایجاد لیبل برای تعداد پاسخ‌های صحیح
    var correctLabel = new Label({
        text: "درست: 0",  // مقدار اولیه
        size: 20,
        font: "samim",
        align: "center",
        color: "#3A3328"
    });
    correctLabel.loc(100, -100, cardboardContainer); // مکان قرارگیری

    // ایجاد لیبل برای تعداد پاسخ‌های غلط
    var incorrectLabel = new Label({
        text: "نادرست: 0",  // مقدار اولیه
        size: 20,
        font: "samim",
        align: "center",
        color: "#3A3328"
    });
    incorrectLabel.loc(200, -100, cardboardContainer); // مکان قرارگیری

  

    var rulerLabel = new Label({
        text: "",
        size: 12,
        font: "samim",
        align: "center"
    });
    var rulerNameLabel = new Label({
        text: "سانتی متر",
        size: 20,
        font: "samim",
        align: "left",
        color: "#636363"
    });

    var enterNumLabel = new Label({
        text: "0 میلی متر",
        size: 40,
        font: "samim",
        align: "center",
        color: "#3A3328"
    });
    enterNumLabel.loc(150, -70, cardboardContainer);


    var rulerCentre = new Rectangle({
        width: 710,
        height: 40,
        color: "#e2e2e2",
        corner: 2
    });

    rulerCentre.reg(0, rulerCentre.height / 2);
    rulerCentre.loc(10, 62.5, rulerRect);

    rulerNameLabel.loc(10, 15, rulerCentre)

    var tenLine = asset("tenLine.png");
    tenLine.sca(.5);
    tenLine.reg(tenLine.width / 2, 0);

    var fiveLine = asset("fiveLine.png");
    fiveLine.sca(.5);
    fiveLine.reg(fiveLine.width / 2, 0);

    var oneLine = asset("oneLine.png");
    oneLine.sca(.5);
    oneLine.reg(tenLine.width / 2, 0);

    // for (var numLine = 0; numLine < 71; numLine++) {
    //     if (numLine % 10 == 0) {
    //         var tempLine = tenLine.clone();
    //         var tempLabel = rulerLabel.clone();
    //         tempLabel.text = numLine;
    //         tempLabel.loc((numLine * 10) + 15, 30, rulerRect);
    //     } else if (numLine % 5 == 0) {
    //         var tempLine = fiveLine.clone();
    //     } else {
    //         var tempLine = oneLine.clone();
    //     };
    //     tempLine.loc((numLine * 10) + 15, 0, rulerRect);
    // };

    for (var numLine = 0; numLine < 71; numLine++) {
        var positionX = (numLine * 10) + 15;
        if (numLine % 10 == 0) {
            var tempLine = tenLine.clone();
            var tempLabel = rulerLabel.clone();
            tempLabel.text = numLine / 10;
            tempLabel.loc(positionX, 30, rulerRect);
        } else if (numLine % 5 == 0) {
            var tempLine = fiveLine.clone();
        } else {
            var tempLine = oneLine.clone();
        }
        tempLine.loc(positionX, 0, rulerRect);
    };

    menuScrn.on("click", function () {
        // asset("fullSound").play();
        SendLogToServer("game_started", 0, 0, "game_started");
        menuContainer.visible = false;
        Ticker.add(function () {
            stage.update();
        });
        interval(5, blink);
        // interval(1,speak);
        resetRunCat();
        if (woolTimer) {
            woolTimer.clear();
            //foldInterval.clear();
        };
        nextRound();
        stage.update();
    });



    function blink() {
        // rightEyeAnim.run({
        //     label: "close",
        //     time: .25,
        //     loop: false,
        //     rewind: true
        // });
        // leftEyeAnim.run({
        //     label: "close",
        //     time: .25,
        //     loop: false,
        //     rewind: true
        // });
        // stage.update();
    }

    function speak() {
        // mouthAnim.run({
        //     label: "close",
        //     time: .2,
        //     loop: false,
        //     rewind: true
        // });
        // stage.update();
    };

    function resetRunCat() {
        kittenWalkCycleAnim.x = -65;
        pounceCatAnim.visible = false;
        kittenWalkCycleAnim.visible = true;
        kittenWalkCycleAnim.animate({
            props: {
                x: chair.x - 325
            },
            time: 2,
            loop: false,
            ease: "linear",
            call: launchCat
        });
    }

    function launchCat() {
        // asset("catJump").play();
        kittenWalkCycleAnim.visible = false;
        pounceCatAnim.sca(.3);
        pounceCatAnim.visible = true;
        pounceCatAnim.run({
            label: "pounce",
            time: 1,
            loop: false,
            rewind: false
        });
        pounceCatAnim.animate({
            props: {
                path: squiggle_pounceLine,
                orient: false
            },
            time: squiggle_pounceLine.duration,
            ease: zimEase([1, 1, 1, 1])
        });
        woolTimer = timeout(3, rollWool);
        stage.update();
    };

    function rollWool() {
        pounceCatAnim.visible = false;
        kittenWalkCycleAnim.visible = false;
        ballWool.visible = true;
        ballWoolShadow.visible = true;
        rollingWoolCatAnim.visible = true;
        //ballWool.pauseAnimate(false,woolAnimation);
        woolAnimation.pauseAnimate(false);
        catOnBackAnimation.pauseAnimate(false);
        ballWool.y = chair.y - 225;
        ballWoolShadow.y = chair.y - 203;
        //rollingWoolCatAnim.pauseAnimate(false,catOnBackAnimation);
        //timeout(10,stopWool);
    }


    function setLength() {
        var tempNum = zim.rand(5, 68);
        return tempNum;
    };

    function startKnitting(thisLength) {
        scarfRect.y = grannyAnim.y;
        scarfRect.animate({
            props: {
                y: thisLength * 20
            },
            time: thisLength / 2,
            ease: "linear"
        });
        timeout(3, function () {
            var randSnd = zim.rand(0, 20);
            if (randSnd < 9) {
                // asset("start1").play();
            } else if (randSnd > 14) {
                // asset("start2").play();
            } else {
                // asset("start3").play();
            }
            grannyTalk();
        });
        smokeInterval = interval(.15, addSmoke);
        Ticker.add(testLength);
    };

    function testLength() {
        if ((scarfRect.y > basketFront.y + 25) && (knitFlag == true)) {
            if (scarfRoll.y > basketBack.y - 25) {
                scarfRoll.y -= 0.1;
            } else if (scarfRoll2.y > basketBack.y - 28) {
                scarfRoll2.y -= 0.1;
            }
        }
        if (knitFlag == false) {
            Ticker.remove(testLength);
            smokeInterval.clear();
        }
    }
    //سرعت بافت
    // function nextRound() {
        
    //     if (legInterval) {
    //         legInterval.clear();
    //     };
    //     scarfLength = setLength();
    //     if (scarfLength > 15) {
    //         grannyAnim.run({
    //             label: "knitting",
    //             time: 1,
    //             loop: true,
    //             loopCount: Math.floor(scarfLength / 7) - 1,
    //             rewind: true,
    //             call: endOfKnitting
    //         });
    //         startKnitting(scarfLength);
    //     } else {
    //         grannyAnim.run({
    //             label: "knitting",
    //             time: 1,
    //             loop: true,
    //             loopCount: Math.floor(scarfLength / 4),
    //             rewind: true,
    //             call: endOfKnitting
    //         });
    //         startKnitting(scarfLength + 10);
    //     }

    //     //foldInterval=interval({time:8,call:addFold,immediate:false});
    //     knitFlag = true;
    //     scarfRect.y = grannyAnim.y;
    //     scarfMask.y = scarfMask.startY;
    //     scarfRoll.y = scarfRoll.startY;
    //     scarfRoll2.y = scarfRoll2.startY;
    //     scarf.y = scarf.startY;
    //     scarf.visible = true;
    //     scarfRoll.visible = true;
    //     scarfRoll2.visible = true;
    //     catForBasket.x = catForBasket.startX;
    //     pounceCatAnim.loc(chair.x - 325, chair.y - 125, kittyContainer);
    //     pounceCatAnim.sca(.3);
    //     pounceCatAnim.visible = false;
    //     scarfRectHoriz.visible = false;
    //     enteredNumber = 0;
    //     catForBasket.x = -265;
    //     scarfRectHoriz.x = 125;
    //     enteredNumber = 0;
    //     enterNumLabel.text = enteredNumber + " میلی متر";
    //     cardboardContainer.x = -325;
    //     boxPaw.loc(270, 135, cardboardContainer, 0);
    //     boxTail.loc(55, 105, cardboardContainer, 0);

    //     moveGransEyes(granEyes.startX, granEyes.startY, false, .5);


    // };

    function bringOnBox() {
        cardboardContainer.animate({
            props: {
                x: 0
            },
            time: 2,
            loop: false,
            ease: zimEase([1, 1, 1, 1])
        });
        // asset("cardboard").play();
        stage.update();
    }

    function takeBoxOff() {
        cardboardContainer.animate({
            props: {
                x: -325
            },
            time: 2,
            loop: false,
            ease: zimEase([1, 1, 1, 1])
        });
        // asset("cardboard").play();
        stage.update();
    }

    function endOfKnitting() {
        knitFlag = false;
        moveGransEyes(granEyes.startX, granEyes.startY - 4, false, .25);
        legInterval = interval(5, function () {
            grannyAnim.run({
                label: "legMove",
                time: 1
            });
        });
        catForBasket.run({
            label: "running",
            time: .5,
            loop: true,
            loopCount: 4,
            rewind: true
        });
        catForBasket.animate({
            props: {
                x: basketBack.x - 375
            },
            time: 2.5,
            loop: false,
            ease: "linear",
            call: jumpIntoBasket
        });
        scarfMask.animate({
            props: {
                y: scarfMask.startY + 160
            },
            time: .75,
            loop: false,
            ease: zimEase([1, 1, 1, 1])
        });
        var randMeas = zim.rand(0, 20);
        if (randMeas < 11) {
            // asset("measure1").play();
        } else {
            // asset("measure2").play();
        }
        grannyTalk();
    }

    function jumpIntoBasket() {
        // asset("catJump").play();
        catForBasket.visible = false;
        grannyContainer.addChildAt(pounceCatAnim, grannyContainer.getChildIndex(basketFront) - 1);

        pounceCatAnim.sca(.4);
        pounceCatAnim.visible = true;
        pounceCatAnim.run({
            label: "pounce",
            time: .45,
            loop: false,
            rewind: false
        });
        timeout(squiggle_basketJump.duration - .85, tipBasket);
        pounceCatAnim.animate({
            props: {
                path: squiggle_basketJump,
                orient: false
            },
            time: squiggle_basketJump.duration,
            ease: zimEase([1, 1, 1, 1])
        });
    }

    function moveGransEyes(newX, newY, rewindFlag, timeNum) {
        granEyes.animate({
            props: {
                x: newX,
                y: newY
            },
            //rewind:rewindFlag,
            time: timeNum,
            loop: false,
            ease: zimEase([0, 0, 1, 1])
        });
    };

    function tipBasket() {
        scarfRoll.visible = false;
        scarfRoll2.visible = false;
        scarf.visible = false;
        moveGransEyes(granEyes.startX, granEyes.startY - 12, true, .5);
        timeout(.5, reverseCat);
        basketBack.animate({
            props: {
                y: grannyAnim.y + 90,
                rotation: -90
            },
            time: .25,
            loop: false,
            ease: zimEase([0, 0, 1, 1])
        });
        basketFront.animate({
            props: {
                y: grannyAnim.y + 90,
                rotation: -90
            },
            time: .25,
            loop: false,
            ease: zimEase([0, 0, 1, 1])
        });
    };

    function reverseCat() {
        moveGransEyes(granEyes.startX, granEyes.startY - 4, false, .25);
        pounceCatAnim.visible = false;
        catForBasket.x = pounceCatAnim.x;
        catForBasket.visible = true;
        scarfRectHoriz.x = catForBasket.x + (catForBasket.width);
        scarfRectHoriz.visible = true;
        catForBasket.animate({
            props: {
                x: pounceCatAnim.x - (scarfLength * 10) - 15
            },
            time: 1,
            loop: false,
            ease: "linear",
            call: dropBasket
        });
        scarfRectHoriz.animate({
            props: {
                x: pounceCatAnim.x + (pounceCatAnim.width - 10) - (scarfLength * 10) - 15
            },
            time: 1,
            loop: false,
            ease: "linear",
            call: bringOnBox
        });
    };

    function dropBasket() {
        basketBack.animate({
            props: {
                y: grannyAnim.y + 145,
                rotation: 0
            },
            time: .25,
            loop: false,
            ease: zimEase([0, 0, 1, 1])
        });
        basketFront.animate({
            props: {
                y: grannyAnim.y + 155,
                rotation: 0
            },
            time: .25,
            loop: false,
            ease: zimEase([0, 0, 1, 1])
        });
        var randMeow = zim.rand(0, 4);
        if (randMeow == 0) {
            // asset("meow1").play();
        } else if (randMeow == 1) {
            // asset("meow2").play();
        } else if (randMeow == 2) {
            // asset("meow3").play();
        } else if (randMeow == 3) {
            // asset("meow4").play();
        } else {
            // asset("meow5").play();
        }
    };
    //امتیاز
    // متغیرهای شمارش
    // let correctAnswers = 0;
    // let incorrectAnswers = 0;

    // function submitAnswer() {
    //     // گرفتن عناصر برای نمایش امتیازها و پیام
    //     const correctScoreDiv = document.getElementById("correctScore");
    //     const incorrectScoreDiv = document.getElementById("incorrectScore");
    //     const messageDiv = document.getElementById("message");

    //     if (enteredNumber == scarfLength) {
    //         // پاسخ صحیح
    //         asset("correct").play();
    //         woolAnimation.pauseAnimate(true);
    //         catOnBackAnimation = rollingWoolCatAnim.run({
    //             label: "correct",
    //             time: 3,
    //             loop: false,
    //             rewind: false,
    //             call: resumeBallRoll
    //         });
    //         addRosette();
    //         takeBoxOff();
    //         grannyTalk();

    //         // افزایش تعداد پاسخ‌های صحیح
    //         correctAnswers++;
    //         console.log("تعداد پاسخ‌های صحیح: " + correctAnswers);

    //         // به‌روزرسانی تعداد پاسخ‌های صحیح در صفحه
    //         correctScoreDiv.innerText = " درست: " + correctAnswers;

    //         // بررسی برنده شدن
    //         if ((correctAnswers + incorrectAnswers) >= 10) {
    //             // نمایش پیام برنده شدن
    //             messageDiv.innerText = "تبریک! شما برنده شدید.";
    //             messageDiv.style.backgroundColor = "#4CAF50"; // رنگ سبز برای برنده شدن
    //             messageDiv.style.display = "block"; // نمایش دادن پیام
    //             // مخفی کردن پیام پس از 3 ثانیه
    //             setTimeout(function () {
    //                 messageDiv.style.display = "none"; // مخفی کردن پیام
    //                 location.reload(); // رفرش صفحه پس از پنهان شدن پیام
    //             }, 3000); // 3000 میلی‌ثانیه برابر با 3 ثانیه
    //         }
    //     } else {
    //         // پاسخ غلط
    //         asset("incorrect").play();
    //         moveGransEyes(granEyes.startX - 5, granEyes.startY + 2, false, .5);
    //         woolAnimation.pauseAnimate(true);
    //         catOnBackAnimation = rollingWoolCatAnim.run({
    //             label: "incorrect",
    //             time: 3,
    //             loop: false,
    //             rewind: false,
    //             call: resumeBallRoll
    //         });
    //         enteredNumber = 0;
    //         enterNumLabel.text = enteredNumber + " میلی متر";
    //         grannyTalk();

    //         // افزایش تعداد پاسخ‌های غلط
    //         incorrectAnswers++;
    //         console.log("تعداد پاسخ‌های غلط: " + incorrectAnswers);

    //         // به‌روزرسانی تعداد پاسخ‌های غلط در صفحه
    //         incorrectScoreDiv.innerText = "نادرست : " + incorrectAnswers;

    //         // بررسی بازنده شدن
    //         if (incorrectAnswers >= 3) {
    //             // نمایش پیام بازنده شدن
    //             messageDiv.innerText = "متاسفانه شما باختید.";
    //             messageDiv.style.backgroundColor = "#f44336"; // رنگ قرمز برای باخت
    //             messageDiv.style.display = "block"; // نمایش دادن پیام

    //             // مخفی کردن پیام پس از 3 ثانیه
    //             setTimeout(function () {
    //                 messageDiv.style.display = "none"; // مخفی کردن پیام
    //                 location.reload(); // رفرش صفحه پس از پنهان شدن پیام
    //             }, 3000); // 3000 میلی‌ثانیه برابر با 3 ثانیه
    //         }

    //     }
    // }
    let correctAnswers = 0;
    let incorrectAnswers = 0;
    let answeredIncorrectly = false; // پرچم برای پیگیری اشتباهات
    let answeredCorrectly = false;   // پرچم برای پیگیری پاسخ صحیح

    function submitAnswer() {
        // گرفتن عناصر برای نمایش امتیازها و پیام
        // const correctScoreDiv = document.getElementById("correctScore");
        // const incorrectScoreDiv = document.getElementById("incorrectScore");
        const messageDiv = document.getElementById("message");

        // console.log(`پاسخ فعلی کاربر: ${enteredNumber}, پاسخ درست: ${scarfLength}`);
        // console.log(`تعداد پاسخ‌های صحیح: ${correctAnswers}, تعداد پاسخ‌های غلط: ${incorrectAnswers}`);

        if ((correctAnswers + incorrectAnswers) >= 10) {
            messageDiv.innerText = "تبریک! شما برنده شدید.";
            messageDiv.style.backgroundColor = "#4CAF50"; // رنگ سبز برای برنده شدن
            messageDiv.style.display = "block"; // نمایش دادن پیام
            // مخفی کردن پیام پس از 3 ثانیه
            setTimeout(function () {
                messageDiv.style.display = "none"; // مخفی کردن پیام
                location.reload(); // رفرش صفحه پس از پنهان شدن پیام
            }, 3000); // 3000 میلی‌ثانیه برابر با 3 ثانیه
            return;
        }

        if (enteredNumber == scarfLength) {
            // اگر سوال قبلاً اشتباه پاسخ داده شده باشد، امتیاز درست ندهیم
            if (answeredIncorrectly) {
                // console.log("سوال قبلاً اشتباه پاسخ داده شده است. امتیاز درست افزوده نمی‌شود.");
            } else {
                // پاسخ صحیح
                // console.log("پاسخ صحیح داده شد.");
                // asset("correct").play();
                woolAnimation.pauseAnimate(true);
                catOnBackAnimation = rollingWoolCatAnim.run({
                    label: "correct",
                    time: 3,
                    loop: false,
                    rewind: false,
                    call: resumeBallRoll
                });
                addRosette();
                takeBoxOff();
                grannyTalk();

                // افزایش تعداد پاسخ‌های صحیح
                correctAnswers++;
                console.log("تعداد پاسخ‌های صحیح افزایش یافت: " + correctAnswers);
                correctLabel.text = "درست: " + correctAnswers;

                // تنظیم پرچم برای نشان دادن اینکه پاسخ درست داده شده
                answeredCorrectly = true;
            }

            // ریست کردن پرچم اشتباه
            answeredIncorrectly = false;

        } else {
            // asset("incorrect").play();
            moveGransEyes(granEyes.startX - 5, granEyes.startY + 2, false, .5);
            woolAnimation.pauseAnimate(true);
            catOnBackAnimation = rollingWoolCatAnim.run({
                label: "incorrect",
                time: 3,
                loop: false,
                rewind: false,
                call: resumeBallRoll
            });
            enteredNumber = 0;
            enterNumLabel.text = enteredNumber + " میلی متر";
            grannyTalk();


            // فقط یکبار امتیاز نادرست افزوده می‌شود
            if (!answeredIncorrectly) {
                incorrectAnswers++;
                // console.log("تعداد پاسخ‌های غلط افزایش یافت: " + incorrectAnswers);
                incorrectLabel.text = "نادرست: " + incorrectAnswers;

                // تنظیم پرچم برای جلوگیری از دادن امتیاز درست به این سوال
                answeredIncorrectly = true;
                answeredCorrectly = false;  // اگر اشتباه پاسخ داده شود، پرچم پاسخ درست را غیرفعال کنیم
            } else {
                console.log("پاسخ اشتباه قبلاً ثبت شده است و امتیاز نادرست تغییر نمی‌کند.");
            }
        }

        // بررسی برای نمایش پیام "بازنده شدن" بعد از 3 اشتباه
        if (incorrectAnswers >= 3) {
            console.log("کاربر 3 پاسخ اشتباه داده است.");
            messageDiv.innerText = "دوباره تلاش کن!";
            messageDiv.style.backgroundColor = "#f44336"; // رنگ قرمز برای باخت
            messageDiv.style.display = "block"; // نمایش دادن پیام
            SendLogToServer("game_over", correctAnswers, incorrectAnswers, "game_over");

            // مخفی کردن پیام پس از 3 ثانیه و ریست کردن بازی
            setTimeout(function () {
                messageDiv.style.display = "none"; // مخفی کردن پیام
                location.reload(); // رفرش صفحه پس از پنهان شدن پیام
            }, 3000); // 3000 میلی‌ثانیه برابر با 3 ثانیه
        }

        // فراخوانی تابع nextQuestion برای سوال بعدی
        nextQuestion();

        // فراخوانی تابع nextRound برای شروع دور جدید بعد از پاسخ به سوال
        nextRound();

        // بررسی پایان بازی (زمانی که مجموع پاسخ‌ها به 10 برسد)
        if ((correctAnswers + incorrectAnswers) == 10) {
            if (incorrectAnswers < 3) {
                console.log("کاربر برنده شد.");
                SendLogToServer("game_completed", correctAnswers, incorrectAnswers, "game_completed");
                messageDiv.innerText = "آفرین!برنده شدی!";
                messageDiv.style.backgroundColor = "#4CAF50"; // رنگ سبز برای برنده شدن
                messageDiv.style.display = "block"; // نمایش دادن پیام
            }

            // مخفی کردن پیام پس از 3 ثانیه و ریست کردن بازی
            setTimeout(function () {
                messageDiv.style.display = "none"; // مخفی کردن پیام
                location.reload(); // رفرش صفحه پس از پنهان شدن پیام
            }, 3000); // 3000 میلی‌ثانیه برابر با 3 ثانیه
        }
    }

    // برای سوال بعدی نمایش داده شود
    function nextQuestion() {
        answeredIncorrectly = false;  // بازنشانی پرچم برای سوال بعدی
        answeredCorrectly = false;    // بازنشانی پرچم برای سوال بعدی
        // کد نمایش سوال جدید باید اینجا بیاید
        console.log("نمایش سوال بعدی");
        // در اینجا باید سوال جدید را به کاربر نمایش دهید
    }

    // تابع nextRound که در آن دور جدید بازی شروع می‌شود
    function nextRound() {
        if (legInterval) {
            legInterval.clear();
        };
        scarfLength = setLength();
        if (scarfLength > 15) {
            grannyAnim.run({
                label: "knitting",
                time: 1,
                loop: true,
                loopCount: Math.floor(scarfLength / 7) - 1,
                rewind: true,
                call: endOfKnitting
            });
            startKnitting(scarfLength);
        } else {
            grannyAnim.run({
                label: "knitting",
                time: 1,
                loop: true,
                loopCount: Math.floor(scarfLength / 4),
                rewind: true,
                call: endOfKnitting
            });
            startKnitting(scarfLength + 10);
        }

        // تنظیمات و آماده‌سازی برای سوال بعدی
        knitFlag = true;
        scarfRect.y = grannyAnim.y;
        scarfMask.y = scarfMask.startY;
        scarfRoll.y = scarfRoll.startY;
        scarfRoll2.y = scarfRoll2.startY;
        scarf.y = scarf.startY;
        scarf.visible = true;
        scarfRoll.visible = true;
        scarfRoll2.visible = true;
        catForBasket.x = catForBasket.startX;
        pounceCatAnim.loc(chair.x - 325, chair.y - 125, kittyContainer);
        pounceCatAnim.sca(.3);
        pounceCatAnim.visible = false;
        scarfRectHoriz.visible = false;
        enteredNumber = 0;
        catForBasket.x = -265;
        scarfRectHoriz.x = 125;
        enteredNumber = 0;
        enterNumLabel.text = enteredNumber + " میلی متر";
        cardboardContainer.x = -325;
        boxPaw.loc(270, 135, cardboardContainer, 0);
        boxTail.loc(55, 105, cardboardContainer, 0);

        moveGransEyes(granEyes.startX, granEyes.startY, false, .5);
    };
//     let correctAnswers = 0;
// let incorrectAnswers = 0;
// let answeredIncorrectly = false; // پرچم برای پیگیری اشتباهات
// let answeredCorrectly = false;   // پرچم برای پیگیری پاسخ صحیح

// function submitAnswer() {
//     // گرفتن عناصر برای نمایش امتیازها و پیام
//     const correctScoreDiv = document.getElementById("correctScore");
//     const incorrectScoreDiv = document.getElementById("incorrectScore");
//     const messageDiv = document.getElementById("message");

//     console.log(`پاسخ فعلی کاربر: ${enteredNumber}, پاسخ درست: ${scarfLength}`);
//     console.log(`تعداد پاسخ‌های صحیح: ${correctAnswers}, تعداد پاسخ‌های غلط: ${incorrectAnswers}`);

//     if ((correctAnswers + incorrectAnswers) >= 10) {
//         console.log("مجموع پاسخ‌ها به 10 رسید. بازی به پایان رسیده است.");
//         return;
//     }

//     if (enteredNumber == scarfLength) {
//         // اگر سوال قبلاً اشتباه پاسخ داده شده باشد، امتیاز درست ندهیم
//         if (answeredIncorrectly) {
//             console.log("سوال قبلاً اشتباه پاسخ داده شده است. امتیاز درست افزوده نمی‌شود.");
//         } else {
//             // پاسخ صحیح
//             console.log("پاسخ صحیح داده شد.");
//             asset("correct").play();
//             woolAnimation.pauseAnimate(true);
//             catOnBackAnimation = rollingWoolCatAnim.run({
//                 label: "correct",
//                 time: 3,
//                 loop: false,
//                 rewind: false,
//                 call: resumeBallRoll
//             });
//             addRosette();
//             takeBoxOff();
//             grannyTalk();

//             // افزایش تعداد پاسخ‌های صحیح
//             correctAnswers++;
//             console.log("تعداد پاسخ‌های صحیح افزایش یافت: " + correctAnswers);
//             correctLabel.text = "درست: " + correctAnswers;
            
//             // تنظیم پرچم برای نشان دادن اینکه پاسخ درست داده شده
//             answeredCorrectly = true;
//         }

//         // ریست کردن پرچم اشتباه
//         answeredIncorrectly = false;

//     } else {
//         // پاسخ اشتباه
//         console.log("پاسخ غلط داده شد.");
//         asset("incorrect").play();
//         moveGransEyes(granEyes.startX - 5, granEyes.startY + 2, false, .5);
//         woolAnimation.pauseAnimate(true);
//         catOnBackAnimation = rollingWoolCatAnim.run({
//             label: "incorrect",
//             time: 3,
//             loop: false,
//             rewind: false,
//             call: resumeBallRoll
//         });
//         enteredNumber = 0;
//         enterNumLabel.text = enteredNumber + " میلی متر";
//         grannyTalk();

//         // فقط یکبار امتیاز نادرست افزوده می‌شود
//         if (!answeredIncorrectly) {
//             incorrectAnswers++;
//             console.log("تعداد پاسخ‌های غلط افزایش یافت: " + incorrectAnswers);
//             incorrectLabel.text = "نادرست: " + incorrectAnswers;

//             // تنظیم پرچم برای جلوگیری از دادن امتیاز درست به این سوال
//             answeredIncorrectly = true;
//             answeredCorrectly = false;  // اگر اشتباه پاسخ داده شود، پرچم پاسخ درست را غیرفعال کنیم
//         } else {
//             console.log("پاسخ اشتباه قبلاً ثبت شده است و امتیاز نادرست تغییر نمی‌کند.");
//         }
//     }

//     // بررسی پایان بازی (زمانی که مجموع پاسخ‌ها به 10 برسد)
//     if ((correctAnswers + incorrectAnswers) == 10) {
//         if (incorrectAnswers < 3) {
//             console.log("کاربر برنده شد.");
//             SendLogToServer("game_completed", correctAnswers, incorrectAnswers, "game_completed");
//             messageDiv.innerText = "آفرین!برنده شدی!";
//             messageDiv.style.backgroundColor = "#4CAF50"; // رنگ سبز برای برنده شدن
//             messageDiv.style.display = "block"; // نمایش دادن پیام
//         } else {
//             console.log("کاربر بازنده شد.");
//             SendLogToServer("game_over", correctAnswers, incorrectAnswers, "game_over");
//             messageDiv.innerText = "دوباره تلاش کن!";
//             messageDiv.style.backgroundColor = "#f44336"; // رنگ قرمز برای باخت
//             messageDiv.style.display = "block"; // نمایش دادن پیام
//         }

//         // مخفی کردن پیام پس از 3 ثانیه و ریست کردن بازی
//         setTimeout(function () {
//             messageDiv.style.display = "none"; // مخفی کردن پیام
//             location.reload(); // رفرش صفحه پس از پنهان شدن پیام
//         }, 3000); // 3000 میلی‌ثانیه برابر با 3 ثانیه
//     }
// }

// // برای سوال بعدی نمایش داده شود
// function nextQuestion() {
//     answeredIncorrectly = false;  // بازنشانی پرچم برای سوال بعدی
//     answeredCorrectly = false;    // بازنشانی پرچم برای سوال بعدی
//     // کد نمایش سوال جدید باید اینجا بیاید
// }

    // let correctAnswers = 0;
    // let incorrectAnswers = 0;
    // let answeredIncorrectly = false; // پرچم برای پیگیری اشتباهات هر سوال
    
    // function submitAnswer() {
    //     // گرفتن عناصر برای نمایش امتیازها و پیام
    //     const correctScoreDiv = document.getElementById("correctScore");
    //     const incorrectScoreDiv = document.getElementById("incorrectScore");
    //     const messageDiv = document.getElementById("message");
    
    //     console.log(`پاسخ فعلی کاربر: ${enteredNumber}, پاسخ درست: ${scarfLength}`);
    //     console.log(`تعداد پاسخ‌های صحیح: ${correctAnswers}, تعداد پاسخ‌های غلط: ${incorrectAnswers}`);
    
    //     if ((correctAnswers + incorrectAnswers) >= 10) {
    //         console.log("مجموع پاسخ‌ها به 10 رسید. بازی به پایان رسیده است.");
    //         return;
    //     }
    
    //     if (enteredNumber == scarfLength) {
    //         // اگر سوال قبلاً اشتباه پاسخ داده شده باشد، امتیاز درست ندهیم
    //         if (answeredIncorrectly) {
    //             console.log("سوال قبلاً اشتباه پاسخ داده شده است. امتیاز درست افزوده نمی‌شود.");
    //         } else {
    //             // پاسخ صحیح
    //             console.log("پاسخ صحیح داده شد.");
    //             asset("correct").play();
    //             woolAnimation.pauseAnimate(true);
    //             catOnBackAnimation = rollingWoolCatAnim.run({
    //                 label: "correct",
    //                 time: 3,
    //                 loop: false,
    //                 rewind: false,
    //                 call: resumeBallRoll
    //             });
    //             addRosette();
    //             takeBoxOff();
    //             grannyTalk();
    
    //             // افزایش تعداد پاسخ‌های صحیح
    //             correctAnswers++;
    //             console.log("تعداد پاسخ‌های صحیح افزایش یافت: " + correctAnswers);
    //             correctLabel.text = "درست: " + correctAnswers;
    //         }
    
    //         // ریست کردن پرچم اشتباه
    //         answeredIncorrectly = false;
    
    //     } else {
    //         // پاسخ اشتباه
    //         console.log("پاسخ غلط داده شد.");
    //         asset("incorrect").play();
    //         moveGransEyes(granEyes.startX - 5, granEyes.startY + 2, false, .5);
    //         woolAnimation.pauseAnimate(true);
    //         catOnBackAnimation = rollingWoolCatAnim.run({
    //             label: "incorrect",
    //             time: 3,
    //             loop: false,
    //             rewind: false,
    //             call: resumeBallRoll
    //         });
    //         enteredNumber = 0;
    //         enterNumLabel.text = enteredNumber + " میلی متر";
    //         grannyTalk();
    
    //         // فقط یکبار امتیاز نادرست افزوده می‌شود
    //         if (!answeredIncorrectly) {
    //             incorrectAnswers++;
    //             console.log("تعداد پاسخ‌های غلط افزایش یافت: " + incorrectAnswers);
    //             incorrectLabel.text = "نادرست: " + incorrectAnswers;
    
    //             // تنظیم پرچم برای جلوگیری از دادن امتیاز درست به این سوال
    //             answeredIncorrectly = true;
    //         } else {
    //             console.log("پاسخ اشتباه قبلاً ثبت شده است و امتیاز نادرست تغییر نمی‌کند.");
    //         }
    //     }
    
    //     // بررسی پایان بازی (زمانی که مجموع پاسخ‌ها به 10 برسد)
    //     if ((correctAnswers + incorrectAnswers) == 10) {
    //         if (incorrectAnswers < 3) {
    //             console.log("کاربر برنده شد.");
    //             SendLogToServer("game_completed", correctAnswers, incorrectAnswers, "game_completed");
    //             messageDiv.innerText = "آفرین!برنده شدی!";
    //             messageDiv.style.backgroundColor = "#4CAF50"; // رنگ سبز برای برنده شدن
    //             messageDiv.style.display = "block"; // نمایش دادن پیام
    //         } else {
    //             console.log("کاربر بازنده شد.");
    //             SendLogToServer("game_over", correctAnswers, incorrectAnswers, "game_over");
    //             messageDiv.innerText = "دوباره تلاش کن!";
    //             messageDiv.style.backgroundColor = "#f44336"; // رنگ قرمز برای باخت
    //             messageDiv.style.display = "block"; // نمایش دادن پیام
    //         }
    
    //         // مخفی کردن پیام پس از 3 ثانیه و ریست کردن بازی
    //         setTimeout(function () {
    //             messageDiv.style.display = "none"; // مخفی کردن پیام
    //             location.reload(); // رفرش صفحه پس از پنهان شدن پیام
    //         }, 3000); // 3000 میلی‌ثانیه برابر با 3 ثانیه
    //     }
    // }
    
    // // برای سوال بعدی نمایش داده شود
    // function nextQuestion() {
    //     answeredIncorrectly = false; // بازنشانی پرچم برای سوال بعدی
    //     // کد نمایش سوال جدید باید اینجا بیاید
    // }
    

    // let correctAnswers = 0;
    // let incorrectAnswers = 0;

    // function submitAnswer() {
    //     // گرفتن عناصر برای نمایش امتیازها و پیام
    //     const correctScoreDiv = document.getElementById("correctScore");
    //     const incorrectScoreDiv = document.getElementById("incorrectScore");
    //     const messageDiv = document.getElementById("message");

    //     if (enteredNumber == scarfLength) {
    //         // پاسخ صحیح
    //         asset("correct").play();
    //         woolAnimation.pauseAnimate(true);
    //         catOnBackAnimation = rollingWoolCatAnim.run({
    //             label: "correct",
    //             time: 3,
    //             loop: false,
    //             rewind: false,
    //             call: resumeBallRoll
    //         });
    //         addRosette();
    //         takeBoxOff();
    //         grannyTalk();

    //         // افزایش تعداد پاسخ‌های صحیح
    //         correctAnswers++;
    //         console.log("تعداد پاسخ‌های صحیح: " + correctAnswers);

    //         // به‌روزرسانی تعداد پاسخ‌های صحیح در لیبل
    //         correctLabel.text = "درست: " + correctAnswers;

    //         // بررسی برنده شدن
    //         if ((correctAnswers + incorrectAnswers) == 10) {
    //             SendLogToServer("game_completed", 0, 0, "game_completed");
    //             // نمایش پیام برنده شدن
    //             messageDiv.innerText = "آفرین!برنده شدی!";
    //             messageDiv.style.backgroundColor = "#4CAF50"; // رنگ سبز برای برنده شدن
    //             messageDiv.style.display = "block"; // نمایش دادن پیام
    //             // مخفی کردن پیام پس از 3 ثانیه
    //             setTimeout(function () {
    //                 messageDiv.style.display = "none"; // مخفی کردن پیام
    //                 location.reload(); // رفرش صفحه پس از پنهان شدن پیام
    //             }, 3000); // 3000 میلی‌ثانیه برابر با 3 ثانیه
    //         }
    //     } else {
    //         // پاسخ غلط
    //         asset("incorrect").play();
    //         moveGransEyes(granEyes.startX - 5, granEyes.startY + 2, false, .5);
    //         woolAnimation.pauseAnimate(true);
    //         catOnBackAnimation = rollingWoolCatAnim.run({
    //             label: "incorrect",
    //             time: 3,
    //             loop: false,
    //             rewind: false,
    //             call: resumeBallRoll
    //         });
    //         enteredNumber = 0;
    //         enterNumLabel.text = enteredNumber + " میلی متر";
    //         grannyTalk();

    //         // افزایش تعداد پاسخ‌های غلط
    //         incorrectAnswers++;
    //         console.log("تعداد پاسخ‌های غلط: " + incorrectAnswers);

    //         // به‌روزرسانی تعداد پاسخ‌های غلط در لیبل
    //         incorrectLabel.text = "نادرست: " + incorrectAnswers;

    //         // بررسی بازنده شدن
    //         if (incorrectAnswers >= 3) {
    //             SendLogToServer("game_over", 0, 0, "game_over");
    //             // نمایش پیام بازنده شدن
    //             messageDiv.innerText = " دوباره تلاش کن!";
    //             messageDiv.style.backgroundColor = "#f44336"; // رنگ قرمز برای باخت
    //             messageDiv.style.display = "block"; // نمایش دادن پیام

    //             // مخفی کردن پیام پس از 3 ثانیه
    //             setTimeout(function () {
    //                 messageDiv.style.display = "none"; // مخفی کردن پیام
    //                 location.reload(); // رفرش صفحه پس از پنهان شدن پیام
    //             }, 3000); // 3000 میلی‌ثانیه برابر با 3 ثانیه
    //         }
    //     }
    // }

    // function submitAnswer() {
    //     if (enteredNumber == scarfLength) {
    //         //zog("correct");
    //         asset("correct").play();
    //         woolAnimation.pauseAnimate(true);
    //         catOnBackAnimation = rollingWoolCatAnim.run({
    //             label: "correct",
    //             time: 3,
    //             loop: false,
    //             rewind: false,
    //             call: resumeBallRoll
    //         });
    //         addRosette();
    //         takeBoxOff();
    //         grannyTalk();
    //     } else {
    //         //zog("wrong");
    //         asset("incorrect").play();
    //         moveGransEyes(granEyes.startX - 5, granEyes.startY + 2, false, .5);
    //         woolAnimation.pauseAnimate(true);
    //         catOnBackAnimation = rollingWoolCatAnim.run({
    //             label: "incorrect",
    //             time: 3,
    //             loop: false,
    //             rewind: false,
    //             call: resumeBallRoll
    //         });
    //         enteredNumber = 0;
    //         enterNumLabel.text = enteredNumber + " میلی متر";
    //         grannyTalk();
    //     }
    // };

    function addRosette() {
        var randNum = zim.rand(0, rosetteArray.length - 1);
        var tempRosette = rosetteArray[randNum].clone();
        tempRosette.loc(225, 276, kittyContainer);

        tempRosette.animate({
            props: {
                scale: 2
            },
            time: 1,
            loop: false,
            ease: zimEase([1, 1, 1, 1]),
            call: nextRound
        });
        timeout(3, function () {
            var randPlace = new Point(zim.rand(45, 800), zim.rand(20, 85));
            tempRosette.animate({
                props: {
                    x: randPlace.x,
                    y: randPlace.y,
                    scale: .2
                },
                time: 1,
                loop: false,
                ease: zimEase([1, 1, 1, 1]),
                call: function () {
                    bgContainer.addChild(tempRosette);
                    tempRosette.drag();
                }
            });
        });

    }

    function resumeBallRoll() {
        woolAnimation.pauseAnimate(false);
        catOnBackAnimation = rollingWoolCatAnim.run({
            label: "rolling",
            time: 1,
            loop: true,
            rewind: true
        });
        rulerRect.noDrag();
        rulerRect.animate({
            props: {
                x: 430,
                y: 485
            },
            time: 1,
            loop: false,
            ease: zimEase([0, 0, 1, 1]),
            call: function () {
                rulerRect.drag();
            }
        });
        moveGransEyes(granEyes.startX, granEyes.startY, false, .5);
        stage.update();
    }

    function grannyTalk() {
        // timeout(.1, speak);
        // timeout(.5, speak);
        // timeout(1, speak);
        // timeout(1.15, speak);
    };

    function addSmoke() {
        var randSmoke = zim.rand(0, 2);
        if (randSmoke == 2) {
            var tempSmoke = smoke1.clone();
        } else if (randSmoke == 1) {
            var tempSmoke = smoke2.clone();
        } else {
            var tempSmoke = smoke3.clone();
        };
        tempSmoke.sca(.1);
        tempSmoke.loc(grannyAnim.x - 45 + zim.rand(0, 75), grannyAnim.y - zim.rand(0, 35), smokeContainer);
        tempSmoke.animate({
            props: {
                rotation: -180,
                scale: .5
            },
            time: 2,
            ease: "linear",
            params: tempSmoke,
            call: removeSmoke
        });

    }

    function removeSmoke(thisSmoke) {
        smokeContainer.removeChild(thisSmoke);
        thisSmoke = null;
    }





    stage.update();

}); // end of ready

//////////////log//////////////
function SendLogToServer(_status, _level = 0, _score = 0, _description = "") {
    const data = {
        id: findGetParameter('id'),
        key: findGetParameter('key'),
        GameName: 'ictgames',
        status: _status,
        level: _level,
        score: _score,
        description: _description
    };
    $.ajax({
        url: findGetParameter('callback'),
        method: 'POST',
        data: data,
        dataType: 'JSON',
        error: err => {
            console.log(err);
            console.log("cannot connect to server")
        },
        success: function (resp) {
            if (resp.status == 'success') {
                console.log("OK");
                console.log(resp);
            } else {
                console.log("failed");
            }
        }
    })
}
function findGetParameter(parameterName) {
    var result = null,
        tmp = [];
    location.search
        .substr(1)
        .split("&")
        .forEach(function (item) {
            tmp = item.split("=");
            if (tmp[0] === parameterName) result = decodeURIComponent(tmp[1]);
        });
    return result;
}
//////////////////////////////
